/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting;

import com.intellij.java.codeserver.highlighting.ExpressionChecker;
import com.intellij.java.codeserver.highlighting.JavaErrorVisitor;
import com.intellij.java.codeserver.highlighting.errors.JavaCompilationError;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.java.codeserver.highlighting.errors.JavaIncompatibleTypeErrorContext;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.IncompleteModelUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FunctionChecker {
    @NotNull
    private final JavaErrorVisitor myVisitor;

    FunctionChecker(@NotNull JavaErrorVisitor visitor) {
        if (visitor == null) {
            FunctionChecker.$$$reportNull$$$0(0);
        }
        this.myVisitor = visitor;
    }

    void checkExtendsSealedClass(@NotNull PsiFunctionalExpression expression, @NotNull PsiType functionalInterfaceType) {
        PsiClass functionalInterface;
        if (expression == null) {
            FunctionChecker.$$$reportNull$$$0(1);
        }
        if (functionalInterfaceType == null) {
            FunctionChecker.$$$reportNull$$$0(2);
        }
        if ((functionalInterface = PsiUtil.resolveClassInClassTypeOnly((PsiType)functionalInterfaceType)) == null || !functionalInterface.hasModifierProperty("sealed")) {
            return;
        }
        if (expression instanceof PsiLambdaExpression) {
            PsiLambdaExpression lambda = (PsiLambdaExpression)expression;
            this.myVisitor.report(JavaErrorKinds.LAMBDA_SEALED.create(lambda));
        } else if (expression instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression methodReference = (PsiMethodReferenceExpression)expression;
            this.myVisitor.report(JavaErrorKinds.METHOD_REFERENCE_SEALED.create(methodReference));
        }
    }

    void checkInterfaceFunctional(@NotNull PsiFunctionalExpression context, PsiType functionalInterfaceType) {
        JavaCompilationError<?, ?> error;
        if (context == null) {
            FunctionChecker.$$$reportNull$$$0(3);
        }
        if ((error = this.getFunctionalInterfaceError(context, functionalInterfaceType)) != null) {
            this.myVisitor.report(error);
        }
    }

    /*
     * Unable to fully structure code
     */
    void checkMethodReferenceQualifier(@NotNull PsiMethodReferenceExpression expression) {
        block7: {
            if (expression == null) {
                FunctionChecker.$$$reportNull$$$0(4);
            }
            referenceNameElement = expression.getReferenceNameElement();
            qualifier = expression.getQualifier();
            if (!(referenceNameElement instanceof PsiKeyword) || PsiMethodReferenceUtil.isValidQualifier((PsiMethodReferenceExpression)expression) || qualifier == null) break block7;
            if (!(qualifier instanceof PsiJavaCodeReferenceElement)) ** GOTO lbl-1000
            ref = (PsiJavaCodeReferenceElement)qualifier;
            if (this.myVisitor.isIncompleteModel() && IncompleteModelUtil.canBePendingReference((PsiJavaCodeReferenceElement)ref)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = pending = false;
            }
            if (!pending) {
                this.myVisitor.report(JavaErrorKinds.METHOD_REFERENCE_QUALIFIER_CLASS_UNRESOLVED.create(qualifier));
            }
        }
        if (qualifier instanceof PsiTypeElement) {
            typeElement = (PsiTypeElement)qualifier;
            if (expression.isConstructor() && (psiType = typeElement.getType()) instanceof PsiClassType && (referenceElement = typeElement.getInnermostComponentReferenceElement()) != null) {
                for (PsiType typeParameter : typeParameters = referenceElement.getTypeParameters()) {
                    if (!(typeParameter instanceof PsiWildcardType)) continue;
                    this.myVisitor.report(JavaErrorKinds.METHOD_REFERENCE_QUALIFIER_WILDCARD.create(typeElement));
                    break;
                }
            }
        }
    }

    void checkRawConstructorReference(@NotNull PsiMethodReferenceExpression expression) {
        PsiElement resolve;
        PsiElement qualifier;
        PsiType[] typeParameters;
        if (expression == null) {
            FunctionChecker.$$$reportNull$$$0(5);
        }
        if (expression.isConstructor() && (typeParameters = expression.getTypeParameters()).length > 0 && (qualifier = expression.getQualifier()) instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)qualifier).resolve()) instanceof PsiClass && ((PsiClass)resolve).hasTypeParameters()) {
            this.myVisitor.report(JavaErrorKinds.METHOD_REFERENCE_RAW_CONSTRUCTOR.create(expression));
        }
    }

    void checkMethodReferenceContext(@NotNull PsiMethodReferenceExpression methodRef, @NotNull PsiType functionalInterfaceType) {
        PsiClass outerClass;
        PsiClass psiClass;
        PsiElement resolve;
        if (methodRef == null) {
            FunctionChecker.$$$reportNull$$$0(6);
        }
        if (functionalInterfaceType == null) {
            FunctionChecker.$$$reportNull$$$0(7);
        }
        if ((resolve = methodRef.resolve()) == null) {
            return;
        }
        if (resolve instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolve;
            psiClass = method.getContainingClass();
        } else {
            psiClass = (PsiClass)resolve;
        }
        PsiClass containingClass = psiClass;
        boolean isStaticSelector = PsiMethodReferenceUtil.isStaticallyReferenced((PsiMethodReferenceExpression)methodRef);
        PsiElement qualifier = methodRef.getQualifier();
        boolean isConstructor = true;
        if (resolve instanceof PsiMethod) {
            PsiReferenceParameterList parameterList;
            PsiJavaCodeReferenceElement referenceElement;
            PsiMethod method = (PsiMethod)resolve;
            boolean isMethodStatic = method.hasModifierProperty("static");
            isConstructor = method.isConstructor();
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult);
            boolean receiverReferenced = PsiMethodReferenceUtil.isResolvedBySecondSearch((PsiMethodReferenceExpression)methodRef, (MethodSignature)(interfaceMethod != null ? interfaceMethod.getSignature(LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult)) : null), (boolean)method.isVarArgs(), (boolean)isMethodStatic, (int)method.getParameterList().getParametersCount());
            if (method.hasModifierProperty("abstract") && qualifier instanceof PsiSuperExpression) {
                this.myVisitor.report(JavaErrorKinds.METHOD_REFERENCE_ABSTRACT_METHOD.create(methodRef, method));
                return;
            }
            if (!receiverReferenced && isStaticSelector && !isMethodStatic && !isConstructor) {
                PsiClassType classType;
                if (functionalInterfaceType instanceof PsiClassType && (classType = (PsiClassType)functionalInterfaceType).hasParameters() && ExpressionChecker.hasSurroundingInferenceError((PsiElement)methodRef)) {
                    return;
                }
                this.myVisitor.report(JavaErrorKinds.METHOD_REFERENCE_NON_STATIC_METHOD_IN_STATIC_CONTEXT.create(methodRef, method));
                return;
            }
            if (!receiverReferenced && !isStaticSelector && isMethodStatic) {
                this.myVisitor.report(JavaErrorKinds.METHOD_REFERENCE_STATIC_METHOD_NON_STATIC_QUALIFIER.create(methodRef, method));
                return;
            }
            if (receiverReferenced && isStaticSelector && isMethodStatic) {
                this.myVisitor.report(JavaErrorKinds.METHOD_REFERENCE_STATIC_METHOD_RECEIVER.create(methodRef, method));
                return;
            }
            if (isStaticSelector && isMethodStatic && qualifier instanceof PsiTypeElement && (referenceElement = (PsiJavaCodeReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)qualifier, PsiJavaCodeReferenceElement.class)) != null && (parameterList = referenceElement.getParameterList()) != null && parameterList.getTypeArguments().length > 0) {
                this.myVisitor.report(JavaErrorKinds.METHOD_REFERENCE_PARAMETERIZED_QUALIFIER.create(parameterList));
                return;
            }
        }
        if (isConstructor && containingClass != null && PsiUtil.isInnerClass((PsiClass)containingClass) && containingClass.isPhysical() && (outerClass = containingClass.getContainingClass()) != null && !InheritanceUtil.hasEnclosingInstanceInScope((PsiClass)outerClass, (PsiElement)methodRef, (boolean)true, (boolean)false)) {
            this.myVisitor.report(JavaErrorKinds.METHOD_REFERENCE_ENCLOSING_INSTANCE_NOT_IN_SCOPE.create(methodRef, outerClass));
        }
    }

    void checkParametersCompatible(@NotNull PsiLambdaExpression expression, @Nullable PsiType functionalInterfaceType) {
        PsiClassType.ClassResolveResult resolveResult;
        PsiMethod interfaceMethod;
        if (expression == null) {
            FunctionChecker.$$$reportNull$$$0(8);
        }
        if ((interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)(resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType)))) == null) {
            return;
        }
        PsiParameter[] parameters = interfaceMethod.getParameterList().getParameters();
        PsiParameter[] lambdaParameters = expression.getParameterList().getParameters();
        if (lambdaParameters.length != parameters.length) {
            this.myVisitor.report(JavaErrorKinds.LAMBDA_WRONG_NUMBER_OF_PARAMETERS.create(expression, interfaceMethod));
            return;
        }
        boolean hasFormalParameterTypes = expression.hasFormalParameterTypes();
        PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult);
        for (int i = 0; i < lambdaParameters.length; ++i) {
            PsiParameter lambdaParameter = lambdaParameters[i];
            PsiType lambdaParameterType = lambdaParameter.getType();
            PsiType substitutedParamType = substitutor.substitute(parameters[i].getType());
            if ((!hasFormalParameterTypes || PsiTypesUtil.compareTypes((PsiType)lambdaParameterType, (PsiType)substitutedParamType, (boolean)true)) && TypeConversionUtil.isAssignable((PsiType)substitutedParamType, (PsiType)lambdaParameterType)) continue;
            this.myVisitor.report(JavaErrorKinds.LAMBDA_INCOMPATIBLE_PARAMETER_TYPES.create(lambdaParameter, Objects.requireNonNullElse(substitutedParamType, PsiTypes.nullType())));
        }
    }

    @Nullable
    private JavaCompilationError<?, ?> getFunctionalInterfaceError(@NotNull PsiFunctionalExpression context, PsiType functionalInterfaceType) {
        if (context == null) {
            FunctionChecker.$$$reportNull$$$0(9);
        }
        if (functionalInterfaceType instanceof PsiIntersectionType) {
            MethodSignature baseSignature;
            PsiIntersectionType intersection = (PsiIntersectionType)functionalInterfaceType;
            HashSet<MethodSignature> signatures = new HashSet<MethodSignature>();
            HashMap<PsiType, MethodSignature> typeAndSignature = new HashMap<PsiType, MethodSignature>();
            for (PsiType type : intersection.getConjuncts()) {
                if (this.getFunctionalInterfaceError(context, type) != null) continue;
                MethodSignature signature = LambdaUtil.getFunction((PsiClass)PsiUtil.resolveClassInType((PsiType)type));
                signatures.add(signature);
                typeAndSignature.put(type, signature);
            }
            PsiType baseType = (PsiType)typeAndSignature.entrySet().iterator().next().getKey();
            LambdaUtil.TargetMethodContainer baseContainer = LambdaUtil.getTargetMethod((PsiType)baseType, (MethodSignature)(baseSignature = (MethodSignature)typeAndSignature.get(baseType)), (PsiType)baseType);
            if (baseContainer == null) {
                return JavaErrorKinds.LAMBDA_NO_TARGET_METHOD.create((PsiElement)context, baseType);
            }
            PsiMethod baseMethod = baseContainer.targetMethod;
            if (signatures.size() > 1) {
                for (Map.Entry entry : typeAndSignature.entrySet()) {
                    if (baseType == entry.getKey()) continue;
                    LambdaUtil.TargetMethodContainer container = LambdaUtil.getTargetMethod((PsiType)((PsiType)entry.getKey()), (MethodSignature)baseSignature, (PsiType)baseType);
                    if (container == null) {
                        return JavaErrorKinds.LAMBDA_MULTIPLE_TARGET_METHODS.create((PsiElement)context, functionalInterfaceType);
                    }
                    if (LambdaUtil.isLambdaSubsignature((PsiMethod)baseMethod, (PsiType)baseType, (PsiMethod)container.targetMethod, (PsiType)((PsiType)entry.getKey())) && container.inheritor.hasModifier(JvmModifier.ABSTRACT)) continue;
                    return JavaErrorKinds.LAMBDA_MULTIPLE_TARGET_METHODS.create((PsiElement)context, functionalInterfaceType);
                }
            }
            for (PsiType type : intersection.getConjuncts()) {
                LambdaUtil.TargetMethodContainer container;
                if (typeAndSignature.containsKey(type) || (container = LambdaUtil.getTargetMethod((PsiType)type, (MethodSignature)baseSignature, (PsiType)baseType)) == null) continue;
                PsiMethod inheritor = container.inheritor;
                PsiMethod target = container.targetMethod;
                if (inheritor.hasModifier(JvmModifier.ABSTRACT) || !LambdaUtil.isLambdaSubsignature((PsiMethod)baseMethod, (PsiType)baseType, (PsiMethod)target, (PsiType)type)) continue;
                return JavaErrorKinds.LAMBDA_NO_TARGET_METHOD.create((PsiElement)context, functionalInterfaceType);
            }
            return null;
        }
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
        PsiClass aClass = resolveResult.getElement();
        if (aClass != null) {
            if (aClass instanceof PsiTypeParameter) {
                return null;
            }
            MethodSignature functionalMethod = LambdaUtil.getFunction((PsiClass)aClass);
            if (functionalMethod != null && functionalMethod.getTypeParameters().length > 0) {
                return JavaErrorKinds.LAMBDA_SAM_GENERIC.create(context);
            }
            return switch (LambdaUtil.checkInterfaceFunctional((PsiClass)aClass)) {
                default -> throw new MatchException(null, null);
                case LambdaUtil.FunctionalInterfaceStatus.VALID -> null;
                case LambdaUtil.FunctionalInterfaceStatus.NOT_INTERFACE -> JavaErrorKinds.LAMBDA_TARGET_NOT_INTERFACE.create(context, functionalInterfaceType);
                case LambdaUtil.FunctionalInterfaceStatus.NO_ABSTRACT_METHOD -> JavaErrorKinds.LAMBDA_NO_TARGET_METHOD.create((PsiElement)context, functionalInterfaceType);
                case LambdaUtil.FunctionalInterfaceStatus.MULTIPLE_ABSTRACT_METHODS -> JavaErrorKinds.LAMBDA_MULTIPLE_TARGET_METHODS.create((PsiElement)context, functionalInterfaceType);
            };
        }
        if (this.myVisitor.isIncompleteModel() && IncompleteModelUtil.isUnresolvedClassType((PsiType)functionalInterfaceType)) {
            return null;
        }
        return JavaErrorKinds.LAMBDA_NOT_FUNCTIONAL_INTERFACE.create((PsiElement)context, functionalInterfaceType);
    }

    private static boolean hasExplicitType(@NotNull PsiParameter parameter) {
        PsiTypeElement typeElement;
        if (parameter == null) {
            FunctionChecker.$$$reportNull$$$0(10);
        }
        return (typeElement = parameter.getTypeElement()) != null && !typeElement.isInferredType();
    }

    void checkConsistentParameterDeclaration(@NotNull PsiLambdaExpression expression) {
        PsiParameterList parameterList;
        PsiParameter[] parameters;
        if (expression == null) {
            FunctionChecker.$$$reportNull$$$0(11);
        }
        if ((parameters = (parameterList = expression.getParameterList()).getParameters()).length < 2) {
            return;
        }
        boolean hasExplicitParameterTypes = FunctionChecker.hasExplicitType(parameters[0]);
        for (int i = 1; i < parameters.length; ++i) {
            if (hasExplicitParameterTypes == FunctionChecker.hasExplicitType(parameters[i])) continue;
            this.myVisitor.report(JavaErrorKinds.LAMBDA_PARAMETERS_INCONSISTENT_VAR.create(parameterList));
        }
    }

    void checkLambdaTypeApplicability(@NotNull PsiLambdaExpression expression, PsiElement parent, @NotNull PsiType functionalInterfaceType) {
        boolean skipReturnCompatibility;
        if (expression == null) {
            FunctionChecker.$$$reportNull$$$0(12);
        }
        if (functionalInterfaceType == null) {
            FunctionChecker.$$$reportNull$$$0(13);
        }
        PsiCallExpression callExpression = parent instanceof PsiExpressionList && parent.getParent() instanceof PsiCallExpression ? (PsiCallExpression)parent.getParent() : null;
        MethodCandidateInfo parentCallResolveResult = callExpression != null ? (MethodCandidateInfo)ObjectUtils.tryCast((Object)callExpression.resolveMethodGenerics(), MethodCandidateInfo.class) : null;
        String parentInferenceErrorMessage = parentCallResolveResult != null ? parentCallResolveResult.getInferenceErrorMessage() : null;
        PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType);
        Map returnErrors = null;
        Set parentTypeParameters = parentCallResolveResult == null ? Set.of() : Set.of(parentCallResolveResult.getElement().getTypeParameters());
        boolean bl = skipReturnCompatibility = parentCallResolveResult != null && PsiTypesUtil.mentionsTypeParameters((PsiType)returnType, parentTypeParameters) && !FunctionChecker.lambdaParametersMentionTypeParameter(functionalInterfaceType, parentTypeParameters);
        if (!skipReturnCompatibility) {
            returnErrors = LambdaUtil.checkReturnTypeCompatible((PsiLambdaExpression)expression, (PsiType)returnType);
        }
        if (!(parentInferenceErrorMessage == null || returnErrors != null && returnErrors.containsValue(parentInferenceErrorMessage))) {
            if (returnErrors == null) {
                return;
            }
            this.checkLambdaInferenceFailure((PsiCall)callExpression, parentCallResolveResult, expression);
        } else if (returnErrors != null && !PsiTreeUtil.hasErrorElements((PsiElement)expression)) {
            returnErrors.forEach((expr, message) -> this.myVisitor.report(JavaErrorKinds.LAMBDA_RETURN_TYPE_ERROR.create((PsiElement)expr, (String)message)));
        }
    }

    private void checkLambdaInferenceFailure(@NotNull PsiCall methodCall, @NotNull MethodCandidateInfo resolveResult, @NotNull PsiLambdaExpression lambdaExpression) {
        PsiType actualType;
        String errorMessage;
        if (methodCall == null) {
            FunctionChecker.$$$reportNull$$$0(14);
        }
        if (resolveResult == null) {
            FunctionChecker.$$$reportNull$$$0(15);
        }
        if (lambdaExpression == null) {
            FunctionChecker.$$$reportNull$$$0(16);
        }
        if ((errorMessage = resolveResult.getInferenceErrorMessage()) == null) {
            return;
        }
        if (ExpressionChecker.favorParentReport(methodCall, errorMessage)) {
            return;
        }
        PsiMethod method = resolveResult.getElement();
        PsiType expectedTypeByParent = InferenceSession.getTargetTypeByParent((PsiElement)methodCall);
        PsiType psiType = actualType = methodCall instanceof PsiExpression ? ((PsiExpression)methodCall.copy()).getType() : resolveResult.getSubstitutor(false).substitute(method.getReturnType());
        if (expectedTypeByParent != null && actualType != null && !expectedTypeByParent.isAssignableFrom(actualType)) {
            this.myVisitor.report(JavaErrorKinds.TYPE_INCOMPATIBLE.create((PsiElement)methodCall, new JavaIncompatibleTypeErrorContext(expectedTypeByParent, actualType, errorMessage)));
        } else {
            this.myVisitor.report(JavaErrorKinds.LAMBDA_INFERENCE_ERROR.create(lambdaExpression, resolveResult));
        }
    }

    static boolean lambdaParametersMentionTypeParameter(@NotNull PsiType functionalInterfaceType, @NotNull Set<? extends PsiTypeParameter> parameters) {
        if (functionalInterfaceType == null) {
            FunctionChecker.$$$reportNull$$$0(17);
        }
        if (parameters == null) {
            FunctionChecker.$$$reportNull$$$0(18);
        }
        if (!(functionalInterfaceType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)functionalInterfaceType;
        PsiSubstitutor substitutor = classType.resolveGenerics().getSubstitutor();
        PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)functionalInterfaceType);
        if (method == null) {
            return false;
        }
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            if (!PsiTypesUtil.mentionsTypeParameters((PsiType)substitutor.substitute(parameter.getType()), parameters)) continue;
            return true;
        }
        return false;
    }

    void checkMethodReferenceReturnType(@NotNull PsiMethodReferenceExpression expression, @NotNull JavaResolveResult result, @Nullable PsiType functionalInterfaceType) {
        String badReturnTypeMessage;
        if (expression == null) {
            FunctionChecker.$$$reportNull$$$0(19);
        }
        if (result == null) {
            FunctionChecker.$$$reportNull$$$0(20);
        }
        if ((badReturnTypeMessage = PsiMethodReferenceUtil.checkReturnType((PsiMethodReferenceExpression)expression, (JavaResolveResult)result, (PsiType)functionalInterfaceType)) != null) {
            this.myVisitor.report(JavaErrorKinds.METHOD_REFERENCE_RETURN_TYPE_ERROR.create(expression, badReturnTypeMessage));
        }
    }

    void checkMethodReferenceResolve(@NotNull PsiMethodReferenceExpression expression, @NotNull @NotNull JavaResolveResult @NotNull [] results, @Nullable PsiType functionalInterfaceType) {
        MethodCandidateInfo methodInfo;
        JavaResolveResult javaResolveResult;
        boolean resolvedButNonApplicable;
        if (expression == null) {
            FunctionChecker.$$$reportNull$$$0(21);
        }
        if (results == null) {
            FunctionChecker.$$$reportNull$$$0(22);
        }
        boolean bl = resolvedButNonApplicable = results.length == 1 && (javaResolveResult = results[0]) instanceof MethodCandidateInfo && !(methodInfo = (MethodCandidateInfo)javaResolveResult).isApplicable() && functionalInterfaceType != null;
        if (results.length != 1 || resolvedButNonApplicable) {
            if (results.length == 1 && ((MethodCandidateInfo)results[0]).getInferenceErrorMessage() != null) {
                this.myVisitor.report(JavaErrorKinds.METHOD_REFERENCE_INFERENCE_ERROR.create(expression, (MethodCandidateInfo)results[0]));
                return;
            }
            if (expression.isConstructor()) {
                PsiClass containingClass = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)expression).getContainingClass();
                if (containingClass != null && containingClass.isPhysical()) {
                    this.myVisitor.report(JavaErrorKinds.METHOD_REFERENCE_UNRESOLVED_CONSTRUCTOR.create(expression, containingClass));
                }
            } else if (results.length > 1) {
                if (!this.myVisitor.isIncompleteModel() || !IncompleteModelUtil.isUnresolvedClassType((PsiType)functionalInterfaceType)) {
                    this.myVisitor.report(JavaErrorKinds.REFERENCE_AMBIGUOUS.create((PsiJavaCodeReferenceElement)expression, Arrays.asList(results)));
                }
            } else if (this.myVisitor.isIncompleteModel() && IncompleteModelUtil.canBePendingReference((PsiJavaCodeReferenceElement)expression)) {
                PsiElement referenceNameElement = expression.getReferenceNameElement();
                if (referenceNameElement != null) {
                    this.myVisitor.report(JavaErrorKinds.REFERENCE_PENDING.create(referenceNameElement));
                }
            } else if (!resolvedButNonApplicable || !ExpressionChecker.hasSurroundingInferenceError((PsiElement)expression)) {
                this.myVisitor.report(JavaErrorKinds.METHOD_REFERENCE_UNRESOLVED_METHOD.create(expression));
            }
        }
    }

    void checkFunctionalInterfaceTypeAccessible(@NotNull PsiFunctionalExpression expression, @NotNull PsiType functionalInterfaceType) {
        if (expression == null) {
            FunctionChecker.$$$reportNull$$$0(23);
        }
        if (functionalInterfaceType == null) {
            FunctionChecker.$$$reportNull$$$0(24);
        }
        this.checkFunctionalInterfaceTypeAccessible(expression, functionalInterfaceType, true);
    }

    private void checkFunctionalInterfaceTypeAccessible(@NotNull PsiFunctionalExpression expression, @NotNull PsiType functionalInterfaceType, boolean checkFunctionalTypeSignature) {
        PsiMethod psiMethod;
        PsiClassType.ClassResolveResult resolveResult;
        PsiClass psiClass;
        if (expression == null) {
            FunctionChecker.$$$reportNull$$$0(25);
        }
        if (functionalInterfaceType == null) {
            FunctionChecker.$$$reportNull$$$0(26);
        }
        if ((psiClass = (resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)PsiClassImplUtil.correctType((PsiType)functionalInterfaceType, (GlobalSearchScope)expression.getResolveScope()))).getElement()) == null) {
            return;
        }
        if (!PsiUtil.isAccessible((Project)this.myVisitor.project(), (PsiMember)psiClass, (PsiElement)expression, null)) {
            this.myVisitor.myModifierChecker.reportAccessProblem((PsiElement)expression, (PsiModifierListOwner)psiClass, (JavaResolveResult)resolveResult);
            return;
        }
        for (PsiType type : resolveResult.getSubstitutor().getSubstitutionMap().values()) {
            if (type == null) continue;
            this.checkFunctionalInterfaceTypeAccessible(expression, type, false);
            if (!this.myVisitor.hasErrorResults()) continue;
            return;
        }
        PsiMethod psiMethod2 = psiMethod = checkFunctionalTypeSignature ? LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult) : null;
        if (psiMethod != null) {
            PsiSubstitutor substitutor = LambdaUtil.getSubstitutor((PsiMethod)psiMethod, (PsiClassType.ClassResolveResult)resolveResult);
            for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                PsiType substitute = substitutor.substitute(parameter.getType());
                if (substitute == null) continue;
                this.checkFunctionalInterfaceTypeAccessible(expression, substitute, false);
                if (!this.myVisitor.hasErrorResults()) continue;
                return;
            }
            PsiType substitute = substitutor.substitute(psiMethod.getReturnType());
            if (substitute != null) {
                this.checkFunctionalInterfaceTypeAccessible(expression, substitute, false);
            }
            return;
        }
        this.myVisitor.myModuleChecker.checkModuleAccess((PsiModifierListOwner)psiClass, (PsiElement)expression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 7: 
            case 13: 
            case 17: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionalInterfaceType";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodRef";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaExpression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        objectArray2[1] = "com/intellij/java/codeserver/highlighting/FunctionChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkExtendsSealedClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInterfaceFunctional";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethodReferenceQualifier";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRawConstructorReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethodReferenceContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkParametersCompatible";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getFunctionalInterfaceError";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "hasExplicitType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkConsistentParameterDeclaration";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "checkLambdaTypeApplicability";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "checkLambdaInferenceFailure";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "lambdaParametersMentionTypeParameter";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethodReferenceReturnType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethodReferenceResolve";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFunctionalInterfaceTypeAccessible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

