/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting;

import com.intellij.java.codeserver.core.JavaPsiModuleUtil;
import com.intellij.java.codeserver.core.JavaServiceProviderUtil;
import com.intellij.java.codeserver.core.JpmsModuleAccessInfo;
import com.intellij.java.codeserver.core.JpmsModuleInfo;
import com.intellij.java.codeserver.highlighting.JavaErrorVisitor;
import com.intellij.java.codeserver.highlighting.errors.JavaCompilationError;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKind;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaCompilerConfigurationProxy;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiImportModuleStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReference;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaMultiReleaseUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

final class ModuleChecker {
    @NotNull
    private final JavaErrorVisitor myVisitor;

    ModuleChecker(@NotNull JavaErrorVisitor visitor) {
        if (visitor == null) {
            ModuleChecker.$$$reportNull$$$0(0);
        }
        this.myVisitor = visitor;
    }

    void checkPackageStatement(@NotNull PsiPackageStatement statement) {
        PsiFile file;
        if (statement == null) {
            ModuleChecker.$$$reportNull$$$0(1);
        }
        if (PsiUtil.isModuleFile((PsiFile)(file = this.myVisitor.file()))) {
            this.myVisitor.report(JavaErrorKinds.MODULE_NO_PACKAGE.create(statement));
            return;
        }
        PsiJavaModule javaModule = this.myVisitor.javaModule();
        if (javaModule != null) {
            String packageName = statement.getPackageName();
            PsiJavaModule origin = JavaPsiModuleUtil.findOrigin((PsiJavaModule)javaModule, (String)packageName);
            if (origin != null) {
                PsiJavaCodeReferenceElement reference = statement.getPackageReference();
                this.myVisitor.report(JavaErrorKinds.MODULE_CONFLICTING_PACKAGES.create(reference, origin));
            }
        } else {
            Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
            if (module == null) {
                return;
            }
            PsiJavaCodeReferenceElement reference = statement.getPackageReference();
            PsiPackage pack = (PsiPackage)reference.resolve();
            if (pack != null) {
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)pack.getProject()).getFileIndex();
                for (PsiDirectory directory : pack.getDirectories()) {
                    VirtualFile moduleVFile;
                    PsiJavaModule anotherJavaModule = JavaPsiModuleUtil.findDescriptorByElement((PsiElement)directory);
                    if (anotherJavaModule == null || (moduleVFile = PsiUtilCore.getVirtualFile((PsiElement)anotherJavaModule)) == null || fileIndex.findContainingSdks(moduleVFile).isEmpty()) continue;
                    VirtualFile rootForFile = fileIndex.getSourceRootForFile(file.getVirtualFile());
                    if (rootForFile != null && JavaCompilerConfigurationProxy.isPatchedModuleRoot((String)anotherJavaModule.getName(), (Module)module, (VirtualFile)rootForFile)) {
                        return;
                    }
                    for (PsiPackageAccessibilityStatement export : anotherJavaModule.getExports()) {
                        String exportPackageName = export.getPackageName();
                        if (exportPackageName == null || !exportPackageName.equals(pack.getQualifiedName())) continue;
                        this.myVisitor.report(JavaErrorKinds.MODULE_CONFLICTING_PACKAGES.create(reference, anotherJavaModule));
                        return;
                    }
                }
            }
        }
    }

    void checkFileName(@NotNull PsiJavaModule module) {
        if (module == null) {
            ModuleChecker.$$$reportNull$$$0(2);
        }
        if (!"module-info.java".equals(this.myVisitor.file().getName())) {
            this.myVisitor.report(JavaErrorKinds.MODULE_FILE_WRONG_NAME.create(module));
        }
    }

    void checkFileDuplicates(@NotNull PsiJavaModule element) {
        if (element == null) {
            ModuleChecker.$$$reportNull$$$0(3);
        }
        Project project = this.myVisitor.project();
        PsiFile file = this.myVisitor.file();
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)file);
        if (module == null) {
            return;
        }
        Collection moduleInfos = FilenameIndex.getVirtualFilesByName((String)"module-info.java", (GlobalSearchScope)module.getModuleScope());
        JpsModuleSourceRootType type = ProjectFileIndex.getInstance((Project)project).getContainingSourceRootType(file.getVirtualFile());
        if (type == null || !JavaModuleSourceRootTypes.SOURCES.contains(type)) {
            return;
        }
        ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
        List rootModuleInfos = ContainerUtil.filter((Collection)moduleInfos, moduleInfo -> moduleFileIndex.isUnderSourceRootOfType(moduleInfo, (Set)ContainerUtil.newHashSet((Object[])new JpsModuleSourceRootType[]{type})));
        if (rootModuleInfos.size() > 1) {
            PsiFile duplicate = rootModuleInfos.stream().map(f -> PsiManager.getInstance((Project)project).findFile(f)).filter(f -> f != file).findFirst().orElse(null);
            this.myVisitor.report(JavaErrorKinds.MODULE_FILE_DUPLICATE.create(element, duplicate));
        }
    }

    void checkDuplicateStatements(@NotNull PsiJavaModule module) {
        if (module == null) {
            ModuleChecker.$$$reportNull$$$0(4);
        }
        this.checkDuplicateRefs(module.getRequires(), st -> st.getModuleName(), JavaErrorKinds.MODULE_DUPLICATE_REQUIRES);
        this.checkDuplicateRefs(module.getExports(), st -> st.getPackageName(), JavaErrorKinds.MODULE_DUPLICATE_EXPORTS);
        this.checkDuplicateRefs(module.getOpens(), st -> st.getPackageName(), JavaErrorKinds.MODULE_DUPLICATE_OPENS);
        this.checkDuplicateRefs(module.getUses(), st -> ModuleChecker.qName(st.getClassReference()), JavaErrorKinds.MODULE_DUPLICATE_USES);
        this.checkDuplicateRefs(module.getProvides(), st -> ModuleChecker.qName(st.getInterfaceReference()), JavaErrorKinds.MODULE_DUPLICATE_PROVIDES);
    }

    void checkModifiers(@NotNull PsiRequiresStatement statement) {
        PsiModifierList modList;
        if (statement == null) {
            ModuleChecker.$$$reportNull$$$0(5);
        }
        if ((modList = statement.getModifierList()) != null && "java.base".equals(statement.getModuleName())) {
            boolean transitiveAvailable = PsiUtil.isAvailable((JavaFeature)JavaFeature.TRANSITIVE_DEPENDENCY_ON_JAVA_BASE, (PsiElement)statement);
            PsiTreeUtil.processElements((PsiElement)modList, PsiKeyword.class, keyword -> {
                if (keyword.getTokenType() == JavaTokenType.TRANSITIVE_KEYWORD && transitiveAvailable) {
                    return true;
                }
                String modifier = keyword.getText();
                this.myVisitor.report(JavaErrorKinds.MODIFIER_NOT_ALLOWED.create((PsiKeyword)keyword, modifier));
                return true;
            });
        }
    }

    void checkDuplicateModuleReferences(@NotNull PsiPackageAccessibilityStatement statement) {
        if (statement == null) {
            ModuleChecker.$$$reportNull$$$0(6);
        }
        HashSet<String> targets = new HashSet<String>();
        for (PsiJavaModuleReferenceElement refElement : statement.getModuleReferences()) {
            String refText = refElement.getReferenceText();
            PsiJavaModuleReference ref = refElement.getReference();
            assert (ref != null) : statement;
            if (targets.add(refText)) continue;
            boolean exports = statement.getRole() == PsiPackageAccessibilityStatement.Role.EXPORTS;
            JavaErrorKind.Simple<PsiJavaModuleReferenceElement> kind = exports ? JavaErrorKinds.MODULE_DUPLICATE_EXPORTS_TARGET : JavaErrorKinds.MODULE_DUPLICATE_OPENS_TARGET;
            this.myVisitor.report(kind.create(refElement));
        }
    }

    private static String qName(PsiJavaCodeReferenceElement ref) {
        return ref != null ? ref.getQualifiedName() : null;
    }

    private <T extends PsiStatement> void checkDuplicateRefs(@NotNull Iterable<? extends T> statements, @NotNull Function<? super T, String> ref, @NotNull JavaErrorKind.Parameterized<T, String> errorKind) {
        if (statements == null) {
            ModuleChecker.$$$reportNull$$$0(7);
        }
        if (ref == null) {
            ModuleChecker.$$$reportNull$$$0(8);
        }
        if (errorKind == null) {
            ModuleChecker.$$$reportNull$$$0(9);
        }
        HashSet<String> filter = new HashSet<String>();
        for (PsiStatement statement : statements) {
            String refText = ref.apply(statement);
            if (refText == null || filter.add(refText)) continue;
            this.myVisitor.report(errorKind.create(statement, refText));
        }
    }

    void checkClashingReads(@NotNull PsiJavaModule module) {
        JavaPsiModuleUtil.ModulePackageConflict conflict;
        if (module == null) {
            ModuleChecker.$$$reportNull$$$0(10);
        }
        if ((conflict = JavaPsiModuleUtil.findConflict((PsiJavaModule)module)) != null) {
            this.myVisitor.report(JavaErrorKinds.MODULE_CONFLICTING_READS.create(module, conflict));
        }
    }

    void checkFileLocation(@NotNull PsiJavaModule element) {
        VirtualFile root;
        VirtualFile vFile;
        if (element == null) {
            ModuleChecker.$$$reportNull$$$0(11);
        }
        if ((vFile = this.myVisitor.file().getVirtualFile()) != null && (root = ProjectFileIndex.getInstance((Project)this.myVisitor.project()).getSourceRootForFile(vFile)) != null && !root.equals(vFile.getParent())) {
            this.myVisitor.report(JavaErrorKinds.MODULE_FILE_WRONG_LOCATION.create(element, root));
        }
    }

    void checkHostModuleStrength(@NotNull PsiPackageAccessibilityStatement statement) {
        PsiJavaModule module;
        PsiElement psiElement;
        if (statement == null) {
            ModuleChecker.$$$reportNull$$$0(12);
        }
        if (statement.getRole() == PsiPackageAccessibilityStatement.Role.OPENS && (psiElement = statement.getParent()) instanceof PsiJavaModule && (module = (PsiJavaModule)psiElement).hasModifierProperty("open")) {
            this.myVisitor.report(JavaErrorKinds.MODULE_OPENS_IN_WEAK_MODULE.create(statement, module));
        }
    }

    void checkServiceReference(@Nullable PsiJavaCodeReferenceElement refElement) {
        if (refElement != null) {
            PsiElement target = refElement.resolve();
            if (!(target instanceof PsiClass)) {
                this.myVisitor.report(JavaErrorKinds.REFERENCE_UNRESOLVED.create(refElement));
            } else {
                PsiClass psiClass = (PsiClass)target;
                if (psiClass.isEnum()) {
                    this.myVisitor.report(JavaErrorKinds.MODULE_SERVICE_ENUM.create(refElement, psiClass));
                }
            }
        }
    }

    void checkModuleReference(@NotNull PsiRequiresStatement statement) {
        PsiJavaModuleReferenceElement refElement;
        if (statement == null) {
            ModuleChecker.$$$reportNull$$$0(13);
        }
        if ((refElement = statement.getReferenceElement()) != null) {
            PsiJavaModuleReference ref = refElement.getReference();
            assert (ref != null) : refElement.getParent();
            PsiJavaModule target = ref.resolve();
            if (target == null) {
                this.reportUnresolvedJavaModule(refElement);
                return;
            }
            PsiJavaModule container = (PsiJavaModule)statement.getParent();
            if (target == container) {
                this.myVisitor.report(JavaErrorKinds.MODULE_CYCLIC_DEPENDENCE.create(refElement, Set.of(container)));
            } else {
                Collection cycle = JavaPsiModuleUtil.findCycle((PsiJavaModule)target);
                if (cycle.contains(container)) {
                    this.myVisitor.report(JavaErrorKinds.MODULE_CYCLIC_DEPENDENCE.create(refElement, cycle));
                }
            }
        }
    }

    private void reportUnresolvedJavaModule(@NotNull PsiJavaModuleReferenceElement refElement) {
        if (refElement == null) {
            ModuleChecker.$$$reportNull$$$0(14);
        }
        PsiJavaModuleReference ref = refElement.getReference();
        assert (ref != null) : refElement.getParent();
        ResolveResult[] results = ref.multiResolve(true);
        switch (results.length) {
            case 0: {
                this.myVisitor.report(this.myVisitor.isIncompleteModel() ? JavaErrorKinds.REFERENCE_PENDING.create((PsiElement)refElement) : JavaErrorKinds.MODULE_NOT_FOUND.create(refElement));
                break;
            }
            case 1: {
                this.myVisitor.report(JavaErrorKinds.MODULE_NOT_ON_PATH.create(refElement));
                break;
            }
        }
    }

    void checkServiceImplementations(@NotNull PsiProvidesStatement statement) {
        PsiReferenceList implRefList;
        if (statement == null) {
            ModuleChecker.$$$reportNull$$$0(15);
        }
        if ((implRefList = statement.getImplementationList()) == null) {
            return;
        }
        PsiJavaCodeReferenceElement intRef = statement.getInterfaceReference();
        PsiElement intTarget = intRef != null ? intRef.resolve() : null;
        HashSet<String> filter = new HashSet<String>();
        for (PsiJavaCodeReferenceElement implRef : implRefList.getReferenceElements()) {
            PsiMethod provider;
            Module implModule;
            String refText = implRef.getQualifiedName();
            if (!filter.add(refText)) {
                this.myVisitor.report(JavaErrorKinds.MODULE_DUPLICATE_IMPLEMENTATION.create(implRef));
                continue;
            }
            if (!(intTarget instanceof PsiClass)) continue;
            PsiClass psiClass = (PsiClass)intTarget;
            PsiElement implTarget = implRef.resolve();
            if (!(implTarget instanceof PsiClass)) continue;
            PsiClass implClass = (PsiClass)implTarget;
            Module fileModule = ModuleUtilCore.findModuleForFile((PsiFile)this.myVisitor.file());
            if (fileModule != (implModule = ModuleUtilCore.findModuleForFile((PsiFile)implClass.getContainingFile())) && !JavaMultiReleaseUtil.areMainAndAdditionalMultiReleaseModules((Module)implModule, (Module)fileModule)) {
                this.myVisitor.report(JavaErrorKinds.MODULE_SERVICE_ALIEN.create(implRef));
            }
            if ((provider = JavaServiceProviderUtil.findServiceProviderMethod((PsiClass)implClass)) != null) {
                PsiClass typeClass;
                PsiType type = provider.getReturnType();
                if (type instanceof PsiClassType) {
                    PsiClassType classType = (PsiClassType)type;
                    v0 = classType.resolve();
                } else {
                    v0 = typeClass = null;
                }
                if (InheritanceUtil.isInheritorOrSelf((PsiClass)typeClass, (PsiClass)psiClass, (boolean)true)) continue;
                this.myVisitor.report(JavaErrorKinds.MODULE_SERVICE_PROVIDER_TYPE.create(implRef, implClass));
                continue;
            }
            if (InheritanceUtil.isInheritorOrSelf((PsiClass)implClass, (PsiClass)psiClass, (boolean)true)) {
                if (implClass.hasModifierProperty("abstract")) {
                    this.myVisitor.report(JavaErrorKinds.MODULE_SERVICE_ABSTRACT.create(implRef, implClass));
                    continue;
                }
                if (!ClassUtil.isTopLevelClass((PsiClass)implClass) && !implClass.hasModifierProperty("static")) {
                    this.myVisitor.report(JavaErrorKinds.MODULE_SERVICE_INNER.create(implRef, implClass));
                    continue;
                }
                if (PsiUtil.hasDefaultConstructor((PsiClass)implClass)) continue;
                this.myVisitor.report(JavaErrorKinds.MODULE_SERVICE_NO_CONSTRUCTOR.create(implRef, implClass));
                continue;
            }
            this.myVisitor.report(JavaErrorKinds.MODULE_SERVICE_IMPLEMENTATION_TYPE.create(implRef, new JavaErrorKinds.SuperclassSubclassContext(psiClass, implClass)));
        }
    }

    void checkPackageReference(@NotNull PsiPackageAccessibilityStatement statement) {
        if (statement == null) {
            ModuleChecker.$$$reportNull$$$0(16);
        }
        if (statement.getRole() == PsiPackageAccessibilityStatement.Role.OPENS) {
            return;
        }
        PsiJavaCodeReferenceElement refElement = statement.getPackageReference();
        if (refElement == null) {
            return;
        }
        JavaPsiModuleUtil.PackageReferenceState state = JavaPsiModuleUtil.checkPackageReference((PsiPackageAccessibilityStatement)statement);
        if (state == JavaPsiModuleUtil.PackageReferenceState.VALID) {
            return;
        }
        JavaErrorKind.Simple<PsiPackageAccessibilityStatement> kind = state == JavaPsiModuleUtil.PackageReferenceState.PACKAGE_NOT_FOUND ? JavaErrorKinds.MODULE_REFERENCE_PACKAGE_NOT_FOUND : JavaErrorKinds.MODULE_REFERENCE_PACKAGE_EMPTY;
        this.myVisitor.report(kind.create(statement));
    }

    JavaErrorKind.Parameterized<PsiElement, JpmsModuleAccessInfo> accessError(@NotNull JpmsModuleAccessInfo.JpmsModuleAccessProblem problem) {
        if (problem == null) {
            ModuleChecker.$$$reportNull$$$0(17);
        }
        return switch (problem) {
            default -> throw new MatchException(null, null);
            case JpmsModuleAccessInfo.JpmsModuleAccessProblem.FROM_NAMED -> JavaErrorKinds.MODULE_ACCESS_FROM_NAMED;
            case JpmsModuleAccessInfo.JpmsModuleAccessProblem.FROM_UNNAMED -> JavaErrorKinds.MODULE_ACCESS_FROM_UNNAMED;
            case JpmsModuleAccessInfo.JpmsModuleAccessProblem.TO_UNNAMED -> JavaErrorKinds.MODULE_ACCESS_TO_UNNAMED;
            case JpmsModuleAccessInfo.JpmsModuleAccessProblem.PACKAGE_BAD_NAME -> JavaErrorKinds.MODULE_ACCESS_PACKAGE_BAD_NAME;
            case JpmsModuleAccessInfo.JpmsModuleAccessProblem.BAD_NAME -> JavaErrorKinds.MODULE_ACCESS_BAD_NAME;
            case JpmsModuleAccessInfo.JpmsModuleAccessProblem.PACKAGE_NOT_IN_GRAPH -> JavaErrorKinds.MODULE_ACCESS_PACKAGE_NOT_IN_GRAPH;
            case JpmsModuleAccessInfo.JpmsModuleAccessProblem.NOT_IN_GRAPH -> JavaErrorKinds.MODULE_ACCESS_NOT_IN_GRAPH;
            case JpmsModuleAccessInfo.JpmsModuleAccessProblem.PACKAGE_DOES_NOT_READ -> JavaErrorKinds.MODULE_ACCESS_PACKAGE_DOES_NOT_READ;
            case JpmsModuleAccessInfo.JpmsModuleAccessProblem.DOES_NOT_READ -> JavaErrorKinds.MODULE_ACCESS_DOES_NOT_READ;
            case JpmsModuleAccessInfo.JpmsModuleAccessProblem.JPS_DEPENDENCY_PROBLEM -> JavaErrorKinds.MODULE_ACCESS_JPS_DEPENDENCY_PROBLEM;
        };
    }

    void checkModuleReference(@NotNull PsiImportModuleStatement statement) {
        PsiJavaModuleReferenceElement refElement;
        if (statement == null) {
            ModuleChecker.$$$reportNull$$$0(18);
        }
        if ((refElement = statement.getModuleReference()) == null) {
            return;
        }
        PsiJavaModuleReference ref = refElement.getReference();
        if (ref == null) {
            return;
        }
        PsiJavaModule target = ref.resolve();
        if (target == null) {
            this.reportUnresolvedJavaModule(refElement);
            return;
        }
        JpmsModuleAccessInfo moduleAccess = new JpmsModuleInfo.TargetModuleInfoByJavaModule(target, "").accessAt((PsiFileSystemItem)this.myVisitor.file().getOriginalFile());
        JpmsModuleAccessInfo.JpmsModuleAccessProblem problem = moduleAccess.checkModuleAccess((PsiElement)statement);
        if (problem != null) {
            this.myVisitor.report(this.accessError(problem).create((PsiElement)statement, moduleAccess));
        }
    }

    @NotNull
    private static PsiElement findPackagePrefix(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            ModuleChecker.$$$reportNull$$$0(19);
        }
        PsiJavaCodeReferenceElement candidate = ref;
        while (candidate instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement element = candidate;
            if (element.resolve() instanceof PsiPackage) {
                PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = candidate;
                if (psiJavaCodeReferenceElement == null) {
                    ModuleChecker.$$$reportNull$$$0(20);
                }
                return psiJavaCodeReferenceElement;
            }
            candidate = element.getQualifier();
        }
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = ref;
        if (psiJavaCodeReferenceElement == null) {
            ModuleChecker.$$$reportNull$$$0(21);
        }
        return psiJavaCodeReferenceElement;
    }

    /*
     * Enabled aggressive block sorting
     */
    void checkModuleAccess(@NotNull PsiModifierListOwner target, @NotNull PsiElement ref) {
        if (target == null) {
            ModuleChecker.$$$reportNull$$$0(22);
        }
        if (ref == null) {
            ModuleChecker.$$$reportNull$$$0(23);
        }
        if (target instanceof PsiClass) {
            PsiClass targetClass = (PsiClass)target;
            if (!(target instanceof PsiTypeParameter)) {
                String packageName = PsiUtil.getPackageName((PsiClass)targetClass);
                if (packageName == null) return;
                this.checkAccess(packageName, target.getContainingFile(), ref);
                return;
            }
        }
        if (!(target instanceof PsiPackage)) return;
        PsiPackage targetPackage = (PsiPackage)target;
        this.checkAccess(targetPackage.getQualifiedName(), null, ref);
    }

    private void checkAccess(@NotNull String targetPackageName, @Nullable PsiFile targetFile, @NotNull PsiElement place) {
        PsiFile file;
        List infos;
        if (targetPackageName == null) {
            ModuleChecker.$$$reportNull$$$0(24);
        }
        if (place == null) {
            ModuleChecker.$$$reportNull$$$0(25);
        }
        if ((infos = JpmsModuleInfo.findTargetModuleInfos((String)targetPackageName, (PsiFile)targetFile, (PsiFile)(file = this.myVisitor.file().getOriginalFile()))) == null) {
            return;
        }
        if (infos.isEmpty()) {
            this.myVisitor.report(JavaErrorKinds.REFERENCE_PACKAGE_NOT_FOUND.create(place, targetPackageName));
            return;
        }
        JavaCompilationError<PsiElement, JpmsModuleAccessInfo> error = null;
        for (JpmsModuleInfo.TargetModuleInfo info : infos) {
            PsiElement psiElement;
            JpmsModuleAccessInfo moduleAccessInfo = info.accessAt((PsiFileSystemItem)file);
            JpmsModuleAccessInfo.JpmsModuleAccessProblem problem = moduleAccessInfo.checkAccess((PsiFileSystemItem)file, JpmsModuleAccessInfo.JpmsModuleAccessMode.READ);
            if (problem == null) {
                return;
            }
            if (error != null) continue;
            if (place instanceof PsiJavaCodeReferenceElement) {
                PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)place;
                psiElement = ModuleChecker.findPackagePrefix(ref);
            } else {
                psiElement = place;
            }
            PsiElement anchor = psiElement;
            error = this.accessError(problem).create(anchor, moduleAccessInfo);
        }
        this.myVisitor.report(error);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 8: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorKind";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/codeserver/highlighting/ModuleChecker";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetPackageName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/codeserver/highlighting/ModuleChecker";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findPackagePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkPackageStatement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkFileName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkFileDuplicates";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicateStatements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkModifiers";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicateModuleReferences";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicateRefs";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkClashingReads";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkFileLocation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkHostModuleStrength";
                break;
            }
            case 13: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkModuleReference";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reportUnresolvedJavaModule";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkServiceImplementations";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkPackageReference";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "accessError";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findPackagePrefix";
                break;
            }
            case 20: 
            case 21: {
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkModuleAccess";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkAccess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 20, 21 -> new IllegalStateException(string);
        };
    }
}

