/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.highlighting.errors;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightMessageUtil;
import com.intellij.java.codeserver.highlighting.JavaCompilationErrorBundle;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorFormatUtil;
import com.intellij.java.codeserver.highlighting.errors.JavaIncompatibleTypeErrorContext;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.IncompleteModelUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record JavaMismatchedCallContext(@NotNull PsiExpressionList list, @NotNull MethodCandidateInfo candidate, @NotNull List<PsiExpression> mismatchedExpressions) {
    @NotNull
    private final PsiExpressionList list;
    @NotNull
    private final MethodCandidateInfo candidate;
    @NotNull
    private final List<PsiExpression> mismatchedExpressions;

    public JavaMismatchedCallContext(@NotNull PsiExpressionList list, @NotNull MethodCandidateInfo candidate, @NotNull List<PsiExpression> mismatchedExpressions) {
        if (list == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(0);
        }
        if (candidate == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(1);
        }
        if (mismatchedExpressions == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(2);
        }
    }

    @NotNull
    @Nls
    String createDescription() {
        PsiMethod resolvedMethod = this.candidate.getElement();
        if (this.argCountMismatch()) {
            int parametersCount = resolvedMethod.getParameterList().getParametersCount();
            String string = JavaCompilationErrorBundle.message("call.wrong.arguments.count.mismatch", parametersCount, this.list.getExpressionCount());
            if (string == null) {
                JavaMismatchedCallContext.$$$reportNull$$$0(3);
            }
            return string;
        }
        PsiClass parent = resolvedMethod.getContainingClass();
        PsiSubstitutor substitutor = this.candidate.getSubstitutor();
        String containerName = parent == null ? "" : HighlightMessageUtil.getSymbolName((PsiElement)parent, (PsiSubstitutor)substitutor);
        String argTypes = JavaErrorFormatUtil.formatArgumentTypes(this.list, false);
        String methodName = HighlightMessageUtil.getSymbolName((PsiElement)resolvedMethod, (PsiSubstitutor)substitutor);
        String string = JavaCompilationErrorBundle.message("call.wrong.arguments", methodName, containerName, argTypes);
        if (string == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean argCountMismatch() {
        PsiMethod resolvedMethod = this.candidate.getElement();
        PsiExpression[] expressions = this.list.getExpressions();
        PsiParameter[] parameters = resolvedMethod.getParameterList().getParameters();
        return JavaMismatchedCallContext.argCountMismatch(parameters, expressions);
    }

    @NotNull
    HtmlChunk createTooltip() {
        PsiMethod resolvedMethod = this.candidate.getElement();
        PsiClass parent = resolvedMethod.getContainingClass();
        if (parent != null) {
            PsiExpression[] expressions = this.list.getExpressions();
            PsiParameter[] parameters = resolvedMethod.getParameterList().getParameters();
            if (this.mismatchedExpressions.size() == 1 && parameters.length > 0) {
                return this.createOneArgMismatchTooltip(expressions, parameters);
            }
            if (JavaMismatchedCallContext.argCountMismatch(parameters, expressions)) {
                return JavaMismatchedCallContext.createMismatchedArgumentCountTooltip(parameters.length, expressions.length);
            }
            if (this.mismatchedExpressions.isEmpty()) {
                HtmlChunk htmlChunk = HtmlChunk.empty();
                if (htmlChunk == null) {
                    JavaMismatchedCallContext.$$$reportNull$$$0(5);
                }
                return htmlChunk;
            }
            return this.createMismatchedArgumentsHtmlTooltip();
        }
        HtmlChunk htmlChunk = HtmlChunk.empty();
        if (htmlChunk == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(6);
        }
        return htmlChunk;
    }

    @NotNull
    private HtmlChunk createMismatchedArgumentsHtmlTooltip() {
        PsiExpression[] expressions;
        PsiMethod method = this.candidate.getElement();
        PsiSubstitutor substitutor = this.candidate.getSubstitutor();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (JavaMismatchedCallContext.argCountMismatch(parameters, expressions = this.list.getExpressions())) {
            return JavaMismatchedCallContext.createMismatchedArgumentCountTooltip(parameters.length, expressions.length);
        }
        HtmlBuilder message = new HtmlBuilder();
        message.append(JavaMismatchedCallContext.getTypeMismatchTable(this.candidate, substitutor, parameters, expressions));
        String errorMessage = this.candidate.getInferenceErrorMessage();
        message.append(JavaMismatchedCallContext.getTypeMismatchErrorHtml(errorMessage));
        HtmlChunk.Element element = message.wrapWithHtmlBody();
        if (element == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(7);
        }
        return element;
    }

    @NotNull
    private HtmlChunk createOneArgMismatchTooltip(PsiExpression @NotNull [] expressions, PsiParameter @NotNull [] parameters) {
        PsiExpression wrongArg;
        PsiType argType;
        if (expressions == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(8);
        }
        if (parameters == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(9);
        }
        PsiType psiType = argType = (wrongArg = this.mismatchedExpressions.get(0)) != null ? wrongArg.getType() : null;
        if (argType != null) {
            int idx = ArrayUtil.find((Object[])expressions, (Object)wrongArg);
            if (idx > parameters.length - 1 && !parameters[parameters.length - 1].isVarArgs()) {
                HtmlChunk htmlChunk = HtmlChunk.empty();
                if (htmlChunk == null) {
                    JavaMismatchedCallContext.$$$reportNull$$$0(10);
                }
                return htmlChunk;
            }
            PsiType paramType = this.candidate.getSubstitutor().substitute(PsiTypesUtil.getParameterType((PsiParameter[])parameters, (int)idx, (boolean)this.candidate.isVarargs()));
            String errorMessage = this.candidate.getInferenceErrorMessage();
            HtmlChunk reason = JavaMismatchedCallContext.getTypeMismatchErrorHtml(errorMessage);
            HtmlChunk htmlChunk = new JavaIncompatibleTypeErrorContext(paramType, argType).createIncompatibleTypesTooltip((lRawType, lTypeArguments, rRawType, rTypeArguments) -> JavaIncompatibleTypeErrorContext.createRequiredProvidedTypeMessage(lRawType, lTypeArguments, rRawType, rTypeArguments, reason));
            if (htmlChunk == null) {
                JavaMismatchedCallContext.$$$reportNull$$$0(11);
            }
            return htmlChunk;
        }
        HtmlChunk htmlChunk = HtmlChunk.empty();
        if (htmlChunk == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(12);
        }
        return htmlChunk;
    }

    @NotNull
    private static HtmlChunk getTypeMismatchTable(@Nullable MethodCandidateInfo info, @NotNull PsiSubstitutor substitutor, PsiParameter @NotNull [] parameters, PsiExpression[] expressions) {
        if (substitutor == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(13);
        }
        if (parameters == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(14);
        }
        HtmlBuilder table = new HtmlBuilder();
        HtmlChunk.Element td = HtmlChunk.tag((String)"td");
        HtmlChunk.Element requiredHeader = td.style("padding-left: 16px; padding-right: 24px;").setClass("--java-display-grayed").addText(JavaCompilationErrorBundle.message("type.incompatible.tooltip.required.type", new Object[0]));
        HtmlChunk.Element providedHeader = td.style("padding-right: 28px;").setClass("--java-display-grayed").addText(JavaCompilationErrorBundle.message("type.incompatible.tooltip.provided.type", new Object[0]));
        table.append((HtmlChunk)HtmlChunk.tag((String)"tr").children(new HtmlChunk[]{td, requiredHeader, providedHeader}));
        String parameterNameStyle = "padding:1px 4px 1px 4px;";
        boolean varargAdded = false;
        for (int i = 0; i < Math.max(parameters.length, expressions.length); ++i) {
            boolean varargs;
            boolean bl = varargs = info != null && info.isVarargs();
            if (JavaMismatchedCallContext.assignmentCompatible(i, parameters, expressions, substitutor, varargs)) continue;
            PsiParameter parameter = null;
            if (i < parameters.length) {
                parameter = parameters[i];
                varargAdded = parameter.isVarArgs();
            } else if (!varargAdded) {
                parameter = parameters[parameters.length - 1];
                varargAdded = true;
            }
            PsiType parameterType = substitutor.substitute(PsiTypesUtil.getParameterType((PsiParameter[])parameters, (int)i, (boolean)varargs));
            PsiExpression expression = i < expressions.length ? expressions[i] : null;
            boolean showShortType = JavaIncompatibleTypeErrorContext.showShortType(parameterType, expression != null ? expression.getType() : null);
            HtmlChunk.Element nameCell = td;
            HtmlChunk.Element typeCell = td.style("padding-left: 16px; padding-right: 24px;");
            if (parameter != null) {
                nameCell = nameCell.child((HtmlChunk)td.style(parameterNameStyle).setClass("--java-display-parameter").addText(parameter.getName() + ":").wrapWith("tr").wrapWith("table"));
                typeCell = typeCell.child(JavaIncompatibleTypeErrorContext.redIfNotMatch(substitutor.substitute(parameter.getType()), true, showShortType));
            }
            HtmlChunk.Element mismatchedCell = td.style("padding-right: 28px;");
            if (expression != null) {
                mismatchedCell = mismatchedCell.child(JavaMismatchedCallContext.mismatchedExpressionType(parameterType, expression));
            }
            table.append((HtmlChunk)HtmlChunk.tag((String)"tr").children(new HtmlChunk[]{nameCell, typeCell, mismatchedCell}));
        }
        HtmlChunk.Element element = table.wrapWith("table");
        if (element == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(15);
        }
        return element;
    }

    @NotNull
    private static HtmlChunk mismatchedExpressionType(PsiType parameterType, @NotNull PsiExpression expression) {
        if (expression == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(16);
        }
        HtmlChunk htmlChunk = new JavaIncompatibleTypeErrorContext(parameterType, expression.getType()).createIncompatibleTypesTooltip(new JavaIncompatibleTypeErrorContext.IncompatibleTypesTooltipComposer(){

            @Override
            @NotNull
            public HtmlChunk consume(@NotNull HtmlChunk lRawType, @NotNull String lTypeArguments, @NotNull HtmlChunk rRawType, @NotNull String rTypeArguments) {
                if (lRawType == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (lTypeArguments == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (rRawType == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (rTypeArguments == null) {
                    1.$$$reportNull$$$0(3);
                }
                HtmlChunk htmlChunk = new HtmlBuilder().append(rRawType).appendRaw(rTypeArguments).toFragment();
                if (htmlChunk == null) {
                    1.$$$reportNull$$$0(4);
                }
                return htmlChunk;
            }

            @Override
            public boolean skipTypeArgsColumns() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lRawType";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lTypeArguments";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rRawType";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rTypeArguments";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaMismatchedCallContext$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaMismatchedCallContext$1";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "consume";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "consume";
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 4 -> new IllegalStateException(string);
                };
            }
        });
        if (htmlChunk == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(17);
        }
        return htmlChunk;
    }

    @NotNull
    private static HtmlChunk createMismatchedArgumentCountTooltip(int expected, int actual) {
        HtmlChunk.Element element = HtmlChunk.text((String)JavaCompilationErrorBundle.message("call.wrong.arguments.count.mismatch", expected, actual)).wrapWith("html");
        if (element == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(18);
        }
        return element;
    }

    private static boolean assignmentCompatible(int i, PsiParameter @NotNull [] parameters, PsiExpression @NotNull [] expressions, @NotNull PsiSubstitutor substitutor, boolean varargs) {
        PsiExpression expression;
        if (substitutor == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(19);
        }
        if (parameters == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(20);
        }
        if (expressions == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(21);
        }
        PsiExpression psiExpression = expression = i < expressions.length ? expressions[i] : null;
        if (expression == null) {
            return true;
        }
        PsiType paramType = substitutor.substitute(PsiTypesUtil.getParameterType((PsiParameter[])parameters, (int)i, (boolean)varargs));
        return paramType != null && TypeConversionUtil.areTypesAssignmentCompatible((PsiType)paramType, (PsiExpression)expression) || IncompleteModelUtil.isIncompleteModel((PsiElement)expression) && IncompleteModelUtil.isPotentiallyConvertible((PsiType)paramType, (PsiExpression)expression);
    }

    @NotNull
    private static List<PsiExpression> mismatchedArgs(PsiExpression @NotNull [] expressions, PsiSubstitutor substitutor, PsiParameter @NotNull [] parameters, boolean varargs) {
        if (expressions == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(22);
        }
        if (parameters == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(23);
        }
        ArrayList<PsiExpression> result = new ArrayList<PsiExpression>();
        for (int i = 0; i < Math.max(parameters.length, expressions.length); ++i) {
            if (parameters.length != 0 && JavaMismatchedCallContext.assignmentCompatible(i, parameters, expressions, substitutor, varargs)) continue;
            result.add(i < expressions.length ? expressions[i] : null);
        }
        ArrayList<PsiExpression> arrayList = result;
        if (arrayList == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(24);
        }
        return arrayList;
    }

    @NotNull
    private static HtmlChunk getTypeMismatchErrorHtml(@Nls String errorMessage) {
        if (errorMessage == null) {
            HtmlChunk htmlChunk = HtmlChunk.empty();
            if (htmlChunk == null) {
                JavaMismatchedCallContext.$$$reportNull$$$0(25);
            }
            return htmlChunk;
        }
        HtmlChunk.Element element = HtmlChunk.tag((String)"td").style("padding-left: 4px; padding-top: 10;").addText(JavaCompilationErrorBundle.message("type.incompatible.reason.inference", errorMessage)).wrapWith("tr").wrapWith("table");
        if (element == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(26);
        }
        return element;
    }

    private static boolean argCountMismatch(@NotNull @NotNull PsiParameter @NotNull [] parameters, @NotNull @NotNull PsiExpression @NotNull [] expressions) {
        if (parameters == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(27);
        }
        if (expressions == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(28);
        }
        return (parameters.length == 0 || !parameters[parameters.length - 1].isVarArgs()) && parameters.length != expressions.length;
    }

    @NotNull
    public static JavaMismatchedCallContext create(@NotNull PsiExpressionList list, @NotNull MethodCandidateInfo candidateInfo) {
        PsiMethod resolvedMethod;
        if (list == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(29);
        }
        if (candidateInfo == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(30);
        }
        if ((resolvedMethod = candidateInfo.getElement()).getContainingClass() == null) {
            return new JavaMismatchedCallContext(list, candidateInfo, List.of());
        }
        PsiParameter[] parameters = resolvedMethod.getParameterList().getParameters();
        PsiSubstitutor substitutor = candidateInfo.getSubstitutor();
        PsiExpression[] expressions = list.getExpressions();
        List<PsiExpression> mismatchedExpressions = JavaMismatchedCallContext.mismatchedArgs(expressions, substitutor, parameters, candidateInfo.isVarargs());
        return new JavaMismatchedCallContext(list, candidateInfo, mismatchedExpressions);
    }

    @NotNull
    public PsiExpressionList list() {
        PsiExpressionList psiExpressionList = this.list;
        if (psiExpressionList == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(31);
        }
        return psiExpressionList;
    }

    @NotNull
    public MethodCandidateInfo candidate() {
        MethodCandidateInfo methodCandidateInfo = this.candidate;
        if (methodCandidateInfo == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(32);
        }
        return methodCandidateInfo;
    }

    @NotNull
    public List<PsiExpression> mismatchedExpressions() {
        List<PsiExpression> list = this.mismatchedExpressions;
        if (list == null) {
            JavaMismatchedCallContext.$$$reportNull$$$0(33);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 10, 11, 12, 15, 17, 18, 24, 25, 26, 31, 32, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mismatchedExpressions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/codeserver/highlighting/errors/JavaMismatchedCallContext";
                break;
            }
            case 8: 
            case 21: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 9: 
            case 14: 
            case 20: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/codeserver/highlighting/errors/JavaMismatchedCallContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescription";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltip";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createMismatchedArgumentsHtmlTooltip";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createOneArgMismatchTooltip";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeMismatchTable";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "mismatchedExpressionType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createMismatchedArgumentCountTooltip";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "mismatchedArgs";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeMismatchErrorHtml";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "candidate";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "mismatchedExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 17: 
            case 18: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createOneArgMismatchTooltip";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTypeMismatchTable";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mismatchedExpressionType";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "assignmentCompatible";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "mismatchedArgs";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "argCountMismatch";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 10, 11, 12, 15, 17, 18, 24, 25, 26, 31, 32, 33 -> new IllegalStateException(string);
        };
    }
}

