/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http1;

import java.io.EOFException;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.http1.HeadersReader;
import okhttp3.internal.http1.Http1ExchangeCodec;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ForwardingTimeout;
import okio.Sink;
import okio.Source;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 ?2\u00020\u0001:\u0007<=>?@ABB'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020\u001cH\u0016J\b\u0010&\u001a\u00020\u001cH\u0016J\b\u0010'\u001a\u00020\u001eH\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020!H\u0002J\b\u0010.\u001a\u00020\u001eH\u0002J\b\u0010/\u001a\u00020)H\u0002J\u0010\u00100\u001a\u00020)2\u0006\u00101\u001a\u00020\u0019H\u0016J\u0012\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u00020\u0010H\u0016J\u0010\u00105\u001a\u00020!2\u0006\u00101\u001a\u00020\u0019H\u0016J\u000e\u00106\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u0019J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u00107\u001a\u00020\u001c2\u0006\u00108\u001a\u00020\u00152\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0017H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\u00020\u0010*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0018\u0010\u0016\u001a\u00020\u0010*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u001a\u00a8\u0006C"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec;", "Lokhttp3/internal/http/ExchangeCodec;", "client", "Lokhttp3/OkHttpClient;", "carrier", "Lokhttp3/internal/http/ExchangeCodec$Carrier;", "source", "Lokio/BufferedSource;", "sink", "Lokio/BufferedSink;", "(Lokhttp3/OkHttpClient;Lokhttp3/internal/http/ExchangeCodec$Carrier;Lokio/BufferedSource;Lokio/BufferedSink;)V", "getCarrier", "()Lokhttp3/internal/http/ExchangeCodec$Carrier;", "headersReader", "Lokhttp3/internal/http1/HeadersReader;", "isClosed", "", "()Z", "state", "", "trailers", "Lokhttp3/Headers;", "isChunked", "Lokhttp3/Request;", "(Lokhttp3/Request;)Z", "Lokhttp3/Response;", "(Lokhttp3/Response;)Z", "cancel", "", "createRequestBody", "Lokio/Sink;", "request", "contentLength", "", "detachTimeout", "timeout", "Lokio/ForwardingTimeout;", "finishRequest", "flushRequest", "newChunkedSink", "newChunkedSource", "Lokio/Source;", "url", "Lokhttp3/HttpUrl;", "newFixedLengthSource", "length", "newKnownLengthSink", "newUnknownLengthSource", "openResponseBodySource", "response", "readResponseHeaders", "Lokhttp3/Response$Builder;", "expectContinue", "reportedContentLength", "skipConnectBody", "writeRequest", "headers", "requestLine", "", "writeRequestHeaders", "AbstractSource", "ChunkedSink", "ChunkedSource", "Companion", "FixedLengthSource", "KnownLengthSink", "UnknownLengthSource", "okhttp"})
@SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,536:1\n1#2:537\n*E\n"})
public final class Http1ExchangeCodec
implements ExchangeCodec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final OkHttpClient client;
    @NotNull
    private final ExchangeCodec.Carrier carrier;
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final BufferedSink sink;
    private int state;
    @NotNull
    private final HeadersReader headersReader;
    @Nullable
    private Headers trailers;
    private static final long NO_CHUNK_YET = -1L;
    private static final int STATE_IDLE = 0;
    private static final int STATE_OPEN_REQUEST_BODY = 1;
    private static final int STATE_WRITING_REQUEST_BODY = 2;
    private static final int STATE_READ_RESPONSE_HEADERS = 3;
    private static final int STATE_OPEN_RESPONSE_BODY = 4;
    private static final int STATE_READING_RESPONSE_BODY = 5;
    private static final int STATE_CLOSED = 6;

    public Http1ExchangeCodec(@Nullable OkHttpClient client, @NotNull ExchangeCodec.Carrier carrier, @NotNull BufferedSource source2, @NotNull BufferedSink sink2) {
        Intrinsics.checkNotNullParameter((Object)carrier, (String)"carrier");
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        this.client = client;
        this.carrier = carrier;
        this.source = source2;
        this.sink = sink2;
        this.headersReader = new HeadersReader(this.source);
    }

    @Override
    @NotNull
    public ExchangeCodec.Carrier getCarrier() {
        return this.carrier;
    }

    private final boolean isChunked(Response $this$isChunked) {
        return StringsKt.equals((String)"chunked", (String)Response.header$default($this$isChunked, "Transfer-Encoding", null, 2, null), (boolean)true);
    }

    private final boolean isChunked(Request $this$isChunked) {
        return StringsKt.equals((String)"chunked", (String)$this$isChunked.header("Transfer-Encoding"), (boolean)true);
    }

    public final boolean isClosed() {
        return this.state == 6;
    }

    @Override
    @NotNull
    public Sink createRequestBody(@NotNull Request request, long contentLength) {
        Sink sink2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        RequestBody requestBody = request.body();
        boolean bl = requestBody != null ? requestBody.isDuplex() : false;
        if (bl) {
            throw new ProtocolException("Duplex connections are not supported for HTTP/1");
        }
        if (this.isChunked(request)) {
            sink2 = this.newChunkedSink();
        } else if (contentLength != -1L) {
            sink2 = this.newKnownLengthSink();
        } else {
            throw new IllegalStateException("Cannot stream a request body without chunked encoding or a known content length!");
        }
        return sink2;
    }

    @Override
    public void cancel() {
        this.getCarrier().cancel();
    }

    @Override
    public void writeRequestHeaders(@NotNull Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Proxy.Type type = this.getCarrier().getRoute().proxy().type();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)type), (String)"type(...)");
        String requestLine = RequestLine.INSTANCE.get(request, type);
        this.writeRequest(request.headers(), requestLine);
    }

    @Override
    public long reportedContentLength(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return !HttpHeaders.promisesBody(response) ? 0L : (this.isChunked(response) ? -1L : _UtilJvmKt.headersContentLength(response));
    }

    @Override
    @NotNull
    public Source openResponseBodySource(@NotNull Response response) {
        long contentLength;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return !HttpHeaders.promisesBody(response) ? this.newFixedLengthSource(0L) : (this.isChunked(response) ? this.newChunkedSource(response.request().url()) : ((contentLength = _UtilJvmKt.headersContentLength(response)) != -1L ? this.newFixedLengthSource(contentLength) : this.newUnknownLengthSource()));
    }

    @Override
    @NotNull
    public Headers trailers() {
        if (!(this.state == 6)) {
            boolean bl = false;
            String string = "too early; can't read the trailers yet";
            throw new IllegalStateException(string.toString());
        }
        Headers headers2 = this.trailers;
        if (headers2 == null) {
            headers2 = _UtilJvmKt.EMPTY_HEADERS;
        }
        return headers2;
    }

    @Override
    public void flushRequest() {
        this.sink.flush();
    }

    @Override
    public void finishRequest() {
        this.sink.flush();
    }

    public final void writeRequest(@NotNull Headers headers2, @NotNull String requestLine) {
        Intrinsics.checkNotNullParameter((Object)headers2, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)requestLine, (String)"requestLine");
        if (!(this.state == 0)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.sink.writeUtf8(requestLine).writeUtf8("\r\n");
        int n = headers2.size();
        for (int i = 0; i < n; ++i) {
            this.sink.writeUtf8(headers2.name(i)).writeUtf8(": ").writeUtf8(headers2.value(i)).writeUtf8("\r\n");
        }
        this.sink.writeUtf8("\r\n");
        this.state = 1;
    }

    @Override
    @Nullable
    public Response.Builder readResponseHeaders(boolean expectContinue) {
        if (!(this.state == 1 || this.state == 2 || this.state == 3)) {
            boolean $i$a$-check-Http1ExchangeCodec$readResponseHeaders$22 = false;
            String $i$a$-check-Http1ExchangeCodec$readResponseHeaders$22 = "state: " + this.state;
            throw new IllegalStateException($i$a$-check-Http1ExchangeCodec$readResponseHeaders$22.toString());
        }
        try {
            Response.Builder builder;
            StatusLine statusLine = StatusLine.Companion.parse(this.headersReader.readLine());
            Response.Builder responseBuilder2 = new Response.Builder().protocol(statusLine.protocol).code(statusLine.code).message(statusLine.message).headers(this.headersReader.readHeaders()).trailers((Function0<Headers>)((Function0)readResponseHeaders.responseBuilder.1.INSTANCE));
            if (expectContinue && statusLine.code == 100) {
                builder = null;
            } else if (statusLine.code == 100) {
                this.state = 3;
                builder = responseBuilder2;
            } else {
                int n = statusLine.code;
                boolean bl = 102 <= n ? n < 200 : false;
                if (bl) {
                    this.state = 3;
                    builder = responseBuilder2;
                } else {
                    this.state = 4;
                    builder = responseBuilder2;
                }
            }
            return builder;
        }
        catch (EOFException e) {
            String address = this.getCarrier().getRoute().address().url().redact();
            throw new IOException("unexpected end of stream on " + address, e);
        }
    }

    private final Sink newChunkedSink() {
        if (!(this.state == 1)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 2;
        return new ChunkedSink();
    }

    private final Sink newKnownLengthSink() {
        if (!(this.state == 1)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 2;
        return new KnownLengthSink();
    }

    private final Source newFixedLengthSource(long length) {
        if (!(this.state == 4)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 5;
        return new FixedLengthSource(length);
    }

    private final Source newChunkedSource(HttpUrl url) {
        if (!(this.state == 4)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 5;
        return new ChunkedSource(url);
    }

    private final Source newUnknownLengthSource() {
        if (!(this.state == 4)) {
            boolean bl = false;
            String string = "state: " + this.state;
            throw new IllegalStateException(string.toString());
        }
        this.state = 5;
        this.getCarrier().noNewExchanges();
        return new UnknownLengthSource();
    }

    private final void detachTimeout(ForwardingTimeout timeout2) {
        Timeout oldDelegate = timeout2.delegate();
        timeout2.setDelegate(Timeout.NONE);
        oldDelegate.clearDeadline();
        oldDelegate.clearTimeout();
    }

    public final void skipConnectBody(@NotNull Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        long contentLength = _UtilJvmKt.headersContentLength(response);
        if (contentLength == -1L) {
            return;
        }
        Source body = this.newFixedLengthSource(contentLength);
        _UtilJvmKt.skipAll(body, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        body.close();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\t\u001a\u00020\u0014H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lokio/Source;", "(Lokhttp3/internal/http1/Http1ExchangeCodec;)V", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "timeout", "Lokio/ForwardingTimeout;", "getTimeout", "()Lokio/ForwardingTimeout;", "read", "", "sink", "Lokio/Buffer;", "byteCount", "responseBodyComplete", "", "Lokio/Timeout;", "okhttp"})
    private abstract class AbstractSource
    implements Source {
        @NotNull
        private final ForwardingTimeout timeout;
        private boolean closed;

        public AbstractSource() {
            this.timeout = new ForwardingTimeout(Http1ExchangeCodec.this.source.timeout());
        }

        @NotNull
        protected final ForwardingTimeout getTimeout() {
            return this.timeout;
        }

        protected final boolean getClosed() {
            return this.closed;
        }

        protected final void setClosed(boolean bl) {
            this.closed = bl;
        }

        @Override
        @NotNull
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public long read(@NotNull Buffer sink2, long byteCount) {
            long l;
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            try {
                l = Http1ExchangeCodec.this.source.read(sink2, byteCount);
            }
            catch (IOException e) {
                Http1ExchangeCodec.this.getCarrier().noNewExchanges();
                this.responseBodyComplete();
                throw e;
            }
            return l;
        }

        public final void responseBodyComplete() {
            if (Http1ExchangeCodec.this.state == 6) {
                return;
            }
            if (Http1ExchangeCodec.this.state != 5) {
                throw new IllegalStateException("state: " + Http1ExchangeCodec.this.state);
            }
            Http1ExchangeCodec.this.detachTimeout(this.timeout);
            Http1ExchangeCodec.this.state = 6;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\u0005\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSink;", "Lokio/Sink;", "(Lokhttp3/internal/http1/Http1ExchangeCodec;)V", "closed", "", "timeout", "Lokio/ForwardingTimeout;", "close", "", "flush", "Lokio/Timeout;", "write", "source", "Lokio/Buffer;", "byteCount", "", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,536:1\n1#2:537\n*E\n"})
    private final class ChunkedSink
    implements Sink {
        @NotNull
        private final ForwardingTimeout timeout;
        private boolean closed;

        public ChunkedSink() {
            this.timeout = new ForwardingTimeout(Http1ExchangeCodec.this.sink.timeout());
        }

        @Override
        @NotNull
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public void write(@NotNull Buffer source2, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            if (!(!this.closed)) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (byteCount == 0L) {
                return;
            }
            Http1ExchangeCodec.this.sink.writeHexadecimalUnsignedLong(byteCount);
            Http1ExchangeCodec.this.sink.writeUtf8("\r\n");
            Http1ExchangeCodec.this.sink.write(source2, byteCount);
            Http1ExchangeCodec.this.sink.writeUtf8("\r\n");
        }

        @Override
        public synchronized void flush() {
            if (this.closed) {
                return;
            }
            Http1ExchangeCodec.this.sink.flush();
        }

        @Override
        public synchronized void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Http1ExchangeCodec.this.sink.writeUtf8("0\r\n\r\n");
            Http1ExchangeCodec.this.detachTimeout(this.timeout);
            Http1ExchangeCodec.this.state = 3;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec;", "url", "Lokhttp3/HttpUrl;", "(Lokhttp3/internal/http1/Http1ExchangeCodec;Lokhttp3/HttpUrl;)V", "bytesRemainingInChunk", "", "hasMoreChunks", "", "close", "", "read", "sink", "Lokio/Buffer;", "byteCount", "readChunkSize", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$ChunkedSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,536:1\n1#2:537\n*E\n"})
    private final class ChunkedSource
    extends AbstractSource {
        @NotNull
        private final HttpUrl url;
        private long bytesRemainingInChunk;
        private boolean hasMoreChunks;

        public ChunkedSource(HttpUrl url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            this.url = url;
            this.bytesRemainingInChunk = -1L;
            this.hasMoreChunks = true;
        }

        @Override
        public long read(@NotNull Buffer sink2, long byteCount) {
            long read;
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            if (!(byteCount >= 0L)) {
                boolean $i$a$-require-Http1ExchangeCodec$ChunkedSource$read$22 = false;
                String $i$a$-require-Http1ExchangeCodec$ChunkedSource$read$22 = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException($i$a$-require-Http1ExchangeCodec$ChunkedSource$read$22.toString());
            }
            if (!(!this.getClosed())) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (!this.hasMoreChunks) {
                return -1L;
            }
            if (this.bytesRemainingInChunk == 0L || this.bytesRemainingInChunk == -1L) {
                this.readChunkSize();
                if (!this.hasMoreChunks) {
                    return -1L;
                }
            }
            if ((read = super.read(sink2, Math.min(byteCount, this.bytesRemainingInChunk))) == -1L) {
                Http1ExchangeCodec.this.getCarrier().noNewExchanges();
                ProtocolException e = new ProtocolException("unexpected end of stream");
                this.responseBodyComplete();
                throw e;
            }
            this.bytesRemainingInChunk -= read;
            return read;
        }

        private final void readChunkSize() {
            if (this.bytesRemainingInChunk != -1L) {
                Http1ExchangeCodec.this.source.readUtf8LineStrict();
            }
            try {
                this.bytesRemainingInChunk = Http1ExchangeCodec.this.source.readHexadecimalUnsignedLong();
                String extensions = ((Object)StringsKt.trim((CharSequence)Http1ExchangeCodec.this.source.readUtf8LineStrict())).toString();
                if (this.bytesRemainingInChunk < 0L || ((CharSequence)extensions).length() > 0 && !StringsKt.startsWith$default((String)extensions, (String)";", (boolean)false, (int)2, null)) {
                    throw new ProtocolException("expected chunk size and optional extensions but was \"" + this.bytesRemainingInChunk + extensions + '\"');
                }
            }
            catch (NumberFormatException e) {
                throw new ProtocolException(e.getMessage());
            }
            if (this.bytesRemainingInChunk == 0L) {
                this.hasMoreChunks = false;
                Http1ExchangeCodec.this.trailers = Http1ExchangeCodec.this.headersReader.readHeaders();
                OkHttpClient okHttpClient = Http1ExchangeCodec.this.client;
                Intrinsics.checkNotNull((Object)okHttpClient);
                CookieJar cookieJar = okHttpClient.cookieJar();
                Headers headers2 = Http1ExchangeCodec.this.trailers;
                Intrinsics.checkNotNull((Object)headers2);
                HttpHeaders.receiveHeaders(cookieJar, this.url, headers2);
                this.responseBodyComplete();
            }
        }

        @Override
        public void close() {
            if (this.getClosed()) {
                return;
            }
            if (this.hasMoreChunks && !_UtilJvmKt.discard(this, 100, TimeUnit.MILLISECONDS)) {
                Http1ExchangeCodec.this.getCarrier().noNewExchanges();
                this.responseBodyComplete();
            }
            this.setClosed(true);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$Companion;", "", "()V", "NO_CHUNK_YET", "", "STATE_CLOSED", "", "STATE_IDLE", "STATE_OPEN_REQUEST_BODY", "STATE_OPEN_RESPONSE_BODY", "STATE_READING_RESPONSE_BODY", "STATE_READ_RESPONSE_HEADERS", "STATE_WRITING_REQUEST_BODY", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$FixedLengthSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec;", "bytesRemaining", "", "(Lokhttp3/internal/http1/Http1ExchangeCodec;J)V", "close", "", "read", "sink", "Lokio/Buffer;", "byteCount", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$FixedLengthSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,536:1\n1#2:537\n*E\n"})
    private final class FixedLengthSource
    extends AbstractSource {
        private long bytesRemaining;

        public FixedLengthSource(long bytesRemaining) {
            this.bytesRemaining = bytesRemaining;
            if (this.bytesRemaining == 0L) {
                this.responseBodyComplete();
            }
        }

        @Override
        public long read(@NotNull Buffer sink2, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            if (!(byteCount >= 0L)) {
                boolean $i$a$-require-Http1ExchangeCodec$FixedLengthSource$read$22 = false;
                String $i$a$-require-Http1ExchangeCodec$FixedLengthSource$read$22 = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException($i$a$-require-Http1ExchangeCodec$FixedLengthSource$read$22.toString());
            }
            if (!(!this.getClosed())) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (this.bytesRemaining == 0L) {
                return -1L;
            }
            long read = super.read(sink2, Math.min(this.bytesRemaining, byteCount));
            if (read == -1L) {
                Http1ExchangeCodec.this.getCarrier().noNewExchanges();
                ProtocolException e = new ProtocolException("unexpected end of stream");
                this.responseBodyComplete();
                throw e;
            }
            this.bytesRemaining -= read;
            if (this.bytesRemaining == 0L) {
                this.responseBodyComplete();
            }
            return read;
        }

        @Override
        public void close() {
            if (this.getClosed()) {
                return;
            }
            if (this.bytesRemaining != 0L && !_UtilJvmKt.discard(this, 100, TimeUnit.MILLISECONDS)) {
                Http1ExchangeCodec.this.getCarrier().noNewExchanges();
                this.responseBodyComplete();
            }
            this.setClosed(true);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\b\u0010\u0005\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$KnownLengthSink;", "Lokio/Sink;", "(Lokhttp3/internal/http1/Http1ExchangeCodec;)V", "closed", "", "timeout", "Lokio/ForwardingTimeout;", "close", "", "flush", "Lokio/Timeout;", "write", "source", "Lokio/Buffer;", "byteCount", "", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$KnownLengthSink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,536:1\n1#2:537\n*E\n"})
    private final class KnownLengthSink
    implements Sink {
        @NotNull
        private final ForwardingTimeout timeout;
        private boolean closed;

        public KnownLengthSink() {
            this.timeout = new ForwardingTimeout(Http1ExchangeCodec.this.sink.timeout());
        }

        @Override
        @NotNull
        public Timeout timeout() {
            return this.timeout;
        }

        @Override
        public void write(@NotNull Buffer source2, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
            if (!(!this.closed)) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            _UtilCommonKt.checkOffsetAndCount(source2.size(), 0L, byteCount);
            Http1ExchangeCodec.this.sink.write(source2, byteCount);
        }

        @Override
        public void flush() {
            if (this.closed) {
                return;
            }
            Http1ExchangeCodec.this.sink.flush();
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            Http1ExchangeCodec.this.detachTimeout(this.timeout);
            Http1ExchangeCodec.this.state = 3;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/internal/http1/Http1ExchangeCodec$UnknownLengthSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec$AbstractSource;", "Lokhttp3/internal/http1/Http1ExchangeCodec;", "(Lokhttp3/internal/http1/Http1ExchangeCodec;)V", "inputExhausted", "", "close", "", "read", "", "sink", "Lokio/Buffer;", "byteCount", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp1ExchangeCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http1ExchangeCodec.kt\nokhttp3/internal/http1/Http1ExchangeCodec$UnknownLengthSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,536:1\n1#2:537\n*E\n"})
    private final class UnknownLengthSource
    extends AbstractSource {
        private boolean inputExhausted;

        @Override
        public long read(@NotNull Buffer sink2, long byteCount) {
            Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
            if (!(byteCount >= 0L)) {
                boolean $i$a$-require-Http1ExchangeCodec$UnknownLengthSource$read$22 = false;
                String $i$a$-require-Http1ExchangeCodec$UnknownLengthSource$read$22 = "byteCount < 0: " + byteCount;
                throw new IllegalArgumentException($i$a$-require-Http1ExchangeCodec$UnknownLengthSource$read$22.toString());
            }
            if (!(!this.getClosed())) {
                boolean bl = false;
                String string = "closed";
                throw new IllegalStateException(string.toString());
            }
            if (this.inputExhausted) {
                return -1L;
            }
            long read = super.read(sink2, byteCount);
            if (read == -1L) {
                this.inputExhausted = true;
                this.responseBodyComplete();
                return -1L;
            }
            return read;
        }

        @Override
        public void close() {
            if (this.getClosed()) {
                return;
            }
            if (!this.inputExhausted) {
                this.responseBodyComplete();
            }
            this.setClosed(true);
        }
    }
}

