/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.refactoring.suggested;

import com.intellij.java.refactoring.suggested.JavaCallAdditionalData;
import com.intellij.java.refactoring.suggested.JavaSuggestedRefactoringStateChangesKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.intellij.refactoring.suggested.SuggestedRefactoringState;
import com.intellij.refactoring.suggested.SuggestedRefactoringStateChanges;
import com.intellij.refactoring.suggested.SuggestedRefactoringSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\b\u001a\u00020\tH\u0016J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/java/refactoring/suggested/JavaSuggestedRefactoringStateChanges;", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringStateChanges;", "refactoringSupport", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport;", "<init>", "(Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport;)V", "createInitialState", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringState;", "anchor", "Lcom/intellij/psi/PsiElement;", "isDuplicate", "", "member", "Lcom/intellij/psi/PsiMember;", "signature", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringSupport$Signature;", "areDuplicateSignatures", "signature1", "signature2", "findDeclaration", "prevState", "signatureFromCall", "Lcom/intellij/psi/PsiCallExpression;", "parameterMarkerRanges", "", "Lcom/intellij/openapi/util/TextRange;", "intellij.java.impl.refactorings"})
@SourceDebugExtension(value={"SMAP\nJavaSuggestedRefactoringStateChanges.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaSuggestedRefactoringStateChanges.kt\ncom/intellij/java/refactoring/suggested/JavaSuggestedRefactoringStateChanges\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,127:1\n777#2:128\n873#2,2:129\n1807#2,3:135\n1786#2,3:138\n37#3,2:131\n13225#4,2:133\n11705#4:141\n12052#4,3:142\n11705#4:145\n12052#4,3:146\n*S KotlinDebug\n*F\n+ 1 JavaSuggestedRefactoringStateChanges.kt\ncom/intellij/java/refactoring/suggested/JavaSuggestedRefactoringStateChanges\n*L\n38#1:128\n38#1:129,2\n50#1:135,3\n62#1:138,3\n38#1:131,2\n41#1:133,2\n91#1:141\n91#1:142,3\n102#1:145\n102#1:146,3\n*E\n"})
public final class JavaSuggestedRefactoringStateChanges
extends SuggestedRefactoringStateChanges {
    public JavaSuggestedRefactoringStateChanges(@NotNull SuggestedRefactoringSupport refactoringSupport) {
        Intrinsics.checkNotNullParameter((Object)refactoringSupport, (String)"refactoringSupport");
        super(refactoringSupport);
    }

    @Nullable
    public SuggestedRefactoringState createInitialState(@NotNull PsiElement anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Project project = anchor.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            return null;
        }
        SuggestedRefactoringState suggestedRefactoringState = super.createInitialState(anchor);
        if (suggestedRefactoringState == null) {
            return null;
        }
        SuggestedRefactoringState state = suggestedRefactoringState;
        if (anchor instanceof PsiMember && this.isDuplicate((PsiMember)anchor, state.getOldSignature())) {
            return null;
        }
        return state;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isDuplicate(PsiMember member, SuggestedRefactoringSupport.Signature signature) {
        PsiClass psiClass = member.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        PsiClass psiClass2 = psiClass;
        String string = member.getName();
        Intrinsics.checkNotNull((Object)string);
        String name = string;
        PsiMember psiMember = member;
        if (psiMember instanceof PsiMethod) {
            boolean bl;
            block14: {
                void $this$any$iv;
                PsiMethod[] psiMethodArray;
                if (psiClass2 instanceof PsiExtensibleClass) {
                    void $this$toTypedArray$iv;
                    void $this$filterTo$iv$iv;
                    List list = ((PsiExtensibleClass)psiClass2).getOwnMethods();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getOwnMethods(...)");
                    Iterable $this$filter$iv = list;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        PsiMethod it = (PsiMethod)element$iv$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    psiMethodArray = thisCollection$iv.toArray(new PsiMethod[0]);
                } else {
                    psiMethodArray = psiClass2.findMethodsByName(name, false);
                }
                Object[] objectArray = psiMethodArray;
                Intrinsics.checkNotNull((Object)objectArray);
                objectArray = objectArray;
                boolean $i$f$any = false;
                for (void element$iv : $this$any$iv) {
                    boolean bl3;
                    PsiMethod it = (PsiMethod)element$iv;
                    boolean bl4 = false;
                    if (Intrinsics.areEqual((Object)it, (Object)member)) {
                        bl3 = false;
                    } else {
                        SuggestedRefactoringSupport.Signature otherSignature;
                        Intrinsics.checkNotNull((Object)it);
                        bl3 = this.signature((PsiElement)it, null) == null ? false : this.areDuplicateSignatures(otherSignature, signature);
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block14;
                }
                bl = false;
            }
            return bl;
        }
        if (psiMember instanceof PsiField) {
            boolean bl;
            block15: {
                List list;
                if (psiClass2 instanceof PsiExtensibleClass) {
                    List list2 = ((PsiExtensibleClass)psiClass2).getOwnFields();
                    list = list2;
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getOwnFields(...)");
                } else {
                    PsiField[] psiFieldArray = psiClass2.getFields();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFieldArray, (String)"getFields(...)");
                    list = ArraysKt.toList((Object[])psiFieldArray);
                }
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PsiField it = (PsiField)element$iv;
                        boolean bl5 = false;
                        if (!(!Intrinsics.areEqual((Object)it, (Object)member) && Intrinsics.areEqual((Object)it.getName(), (Object)name))) continue;
                        bl = true;
                        break block15;
                    }
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    private final boolean areDuplicateSignatures(SuggestedRefactoringSupport.Signature signature1, SuggestedRefactoringSupport.Signature signature2) {
        boolean bl;
        block6: {
            if (!Intrinsics.areEqual((Object)signature1.getName(), (Object)signature2.getName())) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)signature1.getType(), (Object)signature2.getType())) {
                return false;
            }
            if (signature1.getParameters().size() != signature2.getParameters().size()) {
                return false;
            }
            Iterable $this$all$iv = CollectionsKt.zip((Iterable)signature1.getParameters(), (Iterable)signature2.getParameters());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    SuggestedRefactoringSupport.Parameter p1 = (SuggestedRefactoringSupport.Parameter)pair.component1();
                    SuggestedRefactoringSupport.Parameter p2 = (SuggestedRefactoringSupport.Parameter)pair.component2();
                    if (Intrinsics.areEqual((Object)p1.getType(), (Object)p2.getType()) && Intrinsics.areEqual((Object)p1.getName(), (Object)p2.getName())) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Nullable
    public PsiElement findDeclaration(@NotNull PsiElement anchor) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        return anchor instanceof PsiCallExpression ? (PsiElement)((PsiCallExpression)anchor).resolveMethod() : anchor;
    }

    @Nullable
    public SuggestedRefactoringSupport.Signature signature(@NotNull PsiElement anchor, @Nullable SuggestedRefactoringState prevState) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        if (anchor instanceof PsiCallExpression) {
            return this.signatureFromCall((PsiCallExpression)anchor);
        }
        PsiNameIdentifierOwner declaration = (PsiNameIdentifierOwner)anchor;
        String string = declaration.getName();
        if (string == null) {
            return null;
        }
        String name = string;
        if (!(declaration instanceof PsiMethod)) {
            return SuggestedRefactoringSupport.Signature.Companion.create(name, null, CollectionsKt.emptyList(), null);
        }
        SuggestedRefactoringSupport.Signature signature = JavaSuggestedRefactoringStateChangesKt.signature((PsiMethod)declaration);
        if (signature == null) {
            return null;
        }
        SuggestedRefactoringSupport.Signature signature2 = signature;
        return prevState == null ? signature2 : this.matchParametersWithPrevState(signature2, (PsiElement)declaration, prevState);
    }

    /*
     * WARNING - void declaration
     */
    private final SuggestedRefactoringSupport.Signature signatureFromCall(PsiCallExpression anchor) {
        String string;
        void $this$mapTo$iv$iv;
        PsiCallExpression expressions;
        PsiExpressionList psiExpressionList = anchor.getArgumentList();
        Intrinsics.checkNotNull((Object)psiExpressionList);
        PsiCallExpression psiCallExpression = psiExpressionList.getExpressions();
        Intrinsics.checkNotNullExpressionValue((Object)psiCallExpression, (String)"getExpressions(...)");
        PsiCallExpression $this$map$iv = expressions = psiCallExpression;
        boolean $i$f$map = false;
        PsiCallExpression psiCallExpression2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((PsiExpression[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void ex;
            void item$iv$iv;
            void var12_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ex.getText());
        }
        List args = (List)destination$iv$iv;
        psiCallExpression2 = anchor;
        if (psiCallExpression2 instanceof PsiNewExpression) {
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = ((PsiNewExpression)anchor).getClassReference();
            string = psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.getReferenceName() : null;
        } else {
            string = psiCallExpression2 instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)anchor).getMethodExpression().getReferenceName() : null;
        }
        if (string == null) {
            return null;
        }
        String name = string;
        return SuggestedRefactoringSupport.Signature.Companion.create(name, null, CollectionsKt.emptyList(), (SuggestedRefactoringSupport.SignatureAdditionalData)new JavaCallAdditionalData(args));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<TextRange> parameterMarkerRanges(@NotNull PsiElement anchor) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        if (!(anchor instanceof PsiMethod)) {
            return CollectionsKt.emptyList();
        }
        PsiParameter[] psiParameterArray = ((PsiMethod)anchor).getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        Object[] $this$map$iv = psiParameterArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiParameter psiParameter = (PsiParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PsiTypeElement psiTypeElement = it.getTypeElement();
            collection.add(psiTypeElement != null ? psiTypeElement.getTextRange() : null);
        }
        return (List)destination$iv$iv;
    }
}

