/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractJavaInplaceIntroducer
extends AbstractInplaceIntroducer<PsiVariable, PsiExpression> {
    protected TypeSelectorManagerImpl myTypeSelectorManager;
    private SuggestedNameInfo mySuggestedNameInfo;

    public AbstractJavaInplaceIntroducer(Project project, Editor editor, PsiExpression expr, PsiVariable localVariable, PsiExpression[] occurrences, TypeSelectorManagerImpl typeSelectorManager, @NlsContexts.Command String title) {
        super(project, AbstractJavaInplaceIntroducer.getEditor(editor, expr), (PsiElement)expr, (PsiNameIdentifierOwner)localVariable, (PsiElement[])occurrences, title, (FileType)JavaFileType.INSTANCE);
        this.myTypeSelectorManager = typeSelectorManager;
    }

    private static Editor getEditor(Editor editor, PsiExpression expr) {
        return expr != null && Comparing.equal((Object)InjectedLanguageManager.getInstance((Project)expr.getProject()).getTopLevelFile((PsiElement)expr), (Object)expr.getContainingFile()) ? InjectedLanguageUtil.getTopLevelEditor((Editor)editor) : editor;
    }

    protected abstract PsiVariable createFieldToStartTemplateOn(String[] var1, PsiType var2);

    protected abstract SuggestedNameInfo suggestNames(PsiType var1, String var2);

    protected abstract VariableKind getVariableKind();

    protected String @NotNull [] suggestNames(boolean replaceAll, PsiVariable variable) {
        JavaCodeStyleManager javaCodeStyleManager;
        String paramName;
        int idx;
        PsiType defaultType = this.getType();
        String propertyName = variable != null ? JavaCodeStyleManager.getInstance((Project)this.myProject).variableNameToPropertyName(variable.getName(), VariableKind.LOCAL_VARIABLE) : null;
        this.mySuggestedNameInfo = (SuggestedNameInfo)DumbService.getInstance((Project)this.myProject).computeWithAlternativeResolveEnabled(() -> this.suggestNames(defaultType, propertyName));
        Object[] names = this.mySuggestedNameInfo.names;
        if (propertyName != null && names.length > 1 && (idx = ArrayUtil.find((Object[])names, (Object)(paramName = (javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject)).propertyNameToVariableName(propertyName, this.getVariableKind())))) > -1) {
            ArrayUtil.swap((Object[])names, (int)0, (int)idx);
        }
        if (names == null) {
            AbstractJavaInplaceIntroducer.$$$reportNull$$$0(0);
        }
        return names;
    }

    protected PsiVariable createFieldToStartTemplateOn(boolean replaceAll, String[] names) {
        this.myTypeSelectorManager.setAllOccurrences(replaceAll);
        return this.createFieldToStartTemplateOn(names, this.getType());
    }

    protected void correctExpression() {
        PsiElement parent = ((PsiExpression)this.getExpr()).getParent();
        if (parent instanceof PsiExpressionStatement && parent.getLastChild() instanceof PsiErrorElement) {
            this.myExpr = ((PsiExpressionStatement)WriteAction.compute(() -> parent.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)this.myProject).createStatementFromText(parent.getText() + ";", parent)))).getExpression();
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myEditor.getDocument());
            this.myEditor.getCaretModel().moveToOffset(((PsiExpression)this.myExpr).getTextRange().getStartOffset());
        }
    }

    public PsiExpression restoreExpression(PsiFile containingFile, PsiVariable psiVariable, RangeMarker marker, String exprText) {
        return AbstractJavaInplaceIntroducer.restoreExpression(containingFile, psiVariable, JavaPsiFacade.getElementFactory((Project)this.myProject), marker, exprText);
    }

    protected void restoreState(@NotNull PsiVariable psiField) {
        if (psiField == null) {
            AbstractJavaInplaceIntroducer.$$$reportNull$$$0(1);
        }
        SmartTypePointer typePointer = SmartTypePointerManager.getInstance((Project)this.myProject).createSmartTypePointer(this.getType());
        DumbService.getInstance((Project)this.myProject).withAlternativeResolveEnabled(() -> super.restoreState((PsiNameIdentifierOwner)psiField));
        for (PsiExpression occurrence : (PsiExpression[])this.myOccurrences) {
            if (occurrence.isValid()) continue;
            return;
        }
        try {
            this.myTypeSelectorManager = this.myExpr != null ? new TypeSelectorManagerImpl(this.myProject, typePointer.getType(), (PsiExpression)this.myExpr, (PsiExpression[])this.myOccurrences) : new TypeSelectorManagerImpl(this.myProject, typePointer.getType(), (PsiExpression[])this.myOccurrences);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    protected void saveSettings(@NotNull PsiVariable variable) {
        if (variable == null) {
            AbstractJavaInplaceIntroducer.$$$reportNull$$$0(2);
        }
        this.mySuggestedNameInfo.nameChosen(variable.getName());
        TypeSelectorManagerImpl.typeSelected((PsiType)variable.getType(), (PsiType)this.getType());
        this.myTypeSelectorManager = null;
    }

    public PsiType getType() {
        return this.myTypeSelectorManager.getDefaultType();
    }

    @Nullable
    public static PsiExpression restoreExpression(PsiFile containingFile, PsiVariable psiVariable, PsiElementFactory elementFactory, RangeMarker marker, String exprText) {
        PsiNewExpression expression;
        PsiElement refVariableElementParent;
        if (exprText == null) {
            return null;
        }
        if (psiVariable == null || !psiVariable.isValid()) {
            return null;
        }
        PsiElement refVariableElement = containingFile.findElementAt(marker.getStartOffset());
        PsiElement psiElement = refVariableElementParent = refVariableElement != null ? refVariableElement.getParent() : null;
        Object object = refVariableElement instanceof PsiKeyword && refVariableElementParent instanceof PsiNewExpression ? (PsiNewExpression)refVariableElementParent : (expression = refVariableElementParent instanceof PsiParenthesizedExpression ? ((PsiParenthesizedExpression)refVariableElementParent).getExpression() : PsiTreeUtil.getParentOfType((PsiElement)refVariableElement, PsiJavaCodeReferenceElement.class));
        if (expression instanceof PsiJavaCodeReferenceElement && !(expression.getParent() instanceof PsiMethodCallExpression)) {
            String referenceName = ((PsiJavaCodeReferenceElement)expression).getReferenceName();
            if (((PsiJavaCodeReferenceElement)expression).resolve() == psiVariable || Comparing.strEqual((String)psiVariable.getName(), (String)referenceName) || Comparing.strEqual((String)exprText, (String)referenceName)) {
                return (PsiExpression)expression.replace((PsiElement)elementFactory.createExpressionFromText(exprText, (PsiElement)psiVariable));
            }
        }
        if (expression == null) {
            expression = PsiTreeUtil.getParentOfType((PsiElement)refVariableElement, PsiExpression.class);
        }
        while (expression instanceof PsiReferenceExpression || expression instanceof PsiMethodCallExpression) {
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiMethodCallExpression && parent.getText().equals(exprText)) {
                return (PsiExpression)parent;
            }
            if (parent instanceof PsiExpression) {
                expression = parent;
                if (!expression.getText().equals(exprText)) continue;
                return (PsiExpression)expression;
            }
            if (!(expression instanceof PsiReferenceExpression)) break;
            return null;
        }
        if (expression instanceof PsiExpression && expression.isValid() && expression.getText().equals(exprText)) {
            return (PsiExpression)expression;
        }
        if (refVariableElementParent instanceof PsiExpression && refVariableElementParent.getText().equals(exprText)) {
            return (PsiExpression)refVariableElementParent;
        }
        if (expression == null && refVariableElement instanceof PsiIdentifier && refVariableElementParent instanceof PsiJavaCodeReferenceElement && refVariableElement.getText().equals(psiVariable.getName())) {
            return (PsiExpression)refVariableElementParent.replace((PsiElement)elementFactory.createExpressionFromText(exprText, (PsiElement)psiVariable));
        }
        return null;
    }

    protected String chooseName(String[] names, Language language) {
        String inputName = this.getInputName();
        if (inputName != null && !this.isIdentifier(inputName, language)) {
            inputName = null;
        }
        return inputName != null ? inputName : names[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/AbstractJavaInplaceIntroducer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestNames";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/AbstractJavaInplaceIntroducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "restoreState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveSettings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

