/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.anonymousToInner;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddDefaultConstructorFix;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringActionHandlerOnPsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.anonymousToInner.AnonymousToInnerDialog;
import com.intellij.refactoring.anonymousToInner.VariableInfo;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.classMembers.ElementNeedsThis;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaPsiConstructorUtil;
import com.siyeh.ig.jdk.VarargParameterInspection;
import com.siyeh.ig.psiutils.PsiElementOrderComparator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnonymousToInnerHandler
implements RefactoringActionHandlerOnPsiElement<PsiClass> {
    private static final Logger LOG = Logger.getInstance(AnonymousToInnerHandler.class);
    private Project myProject;
    private PsiManager myManager;
    private PsiClass myAnonOrLocalClass;
    private PsiClass myTargetClass;
    protected String myNewClassName;
    protected VariableInfo[] myVariableInfos;
    protected boolean myMakeStatic;
    private final List<PsiTypeParameter> myTypeParametersToCreate = new ArrayList<PsiTypeParameter>();
    private Boolean cachedNeedsThis;

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        PsiClass aClass;
        PsiElement psiElement;
        if (project == null) {
            AnonymousToInnerHandler.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            AnonymousToInnerHandler.$$$reportNull$$$0(1);
        }
        if (elements.length == 1 && (psiElement = elements[0]) instanceof PsiClass && ((aClass = (PsiClass)psiElement) instanceof PsiAnonymousClass || PsiUtil.isLocalClass((PsiClass)aClass))) {
            this.invoke(project, (Editor)CommonDataKeys.EDITOR.getData(dataContext), aClass);
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            AnonymousToInnerHandler.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        @Nullable PsiClass anonymousOrLocal = AnonymousToInnerHandler.findClassToMove(file, offset);
        if (anonymousOrLocal == null) {
            this.showErrorMessage(editor, RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"error.wrong.caret.position.anonymous", (Object[])new Object[0])));
            return;
        }
        PsiElement parent = anonymousOrLocal.getParent();
        if (parent instanceof PsiEnumConstant) {
            this.showErrorMessage(editor, RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"anonymous.to.inner.enum.constant.cannot.refactor.message", (Object[])new Object[0])));
            return;
        }
        this.invoke(project, editor, anonymousOrLocal);
    }

    private void showErrorMessage(Editor editor, @NlsContexts.DialogMessage String message) {
        CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)editor, (String)message, (String)JavaRefactoringBundle.message((String)"anonymousToInner.refactoring.name", (Object[])new Object[0]), (String)"refactoring.convertAnonymous");
    }

    public void invoke(Project project, Editor editor, PsiClass anonymousOrLocalClass) {
        this.myProject = project;
        this.myManager = PsiManager.getInstance((Project)this.myProject);
        this.myAnonOrLocalClass = anonymousOrLocalClass;
        for (PsiClassType baseRef : this.myAnonOrLocalClass.getSuperTypes()) {
            String refText = baseRef.getCanonicalText();
            if ("java.lang.Record".equals(refText) || "java.lang.Enum".equals(refText)) continue;
            PsiClass baseClass = baseRef.resolve();
            if (baseClass == null) {
                String message = JavaRefactoringBundle.message((String)"error.cannot.resolve", (Object[])new Object[]{refText});
                this.showErrorMessage(editor, message);
                return;
            }
            if (!PsiUtil.isLocalClass((PsiClass)baseClass)) continue;
            String message = JavaRefactoringBundle.message((String)"error.not.supported.for.local", (Object[])new Object[0]);
            this.showErrorMessage(editor, message);
            return;
        }
        PsiElement targetContainer = AnonymousToInnerHandler.findTargetContainer(this.myAnonOrLocalClass);
        if (FileTypeUtils.isInServerPageFile((PsiElement)targetContainer) && targetContainer instanceof PsiFile) {
            String message = JavaRefactoringBundle.message((String)"error.not.supported.for.jsp", (Object[])new Object[]{JavaRefactoringBundle.message((String)"anonymousToInner.refactoring.name", (Object[])new Object[0])});
            this.showErrorMessage(editor, message);
            return;
        }
        LOG.assertTrue(targetContainer instanceof PsiClass);
        this.myTargetClass = (PsiClass)targetContainer;
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)this.myTargetClass)) {
            return;
        }
        LinkedHashMap<PsiVariable, VariableInfo> variableInfoMap = new LinkedHashMap<PsiVariable, VariableInfo>();
        if (!this.myAnonOrLocalClass.hasModifierProperty("static")) {
            this.collectUsedVariables(variableInfoMap, (PsiElement)this.myAnonOrLocalClass);
        }
        VariableInfo[] infos = variableInfoMap.values().toArray(new VariableInfo[0]);
        this.myVariableInfos = infos;
        Arrays.sort(this.myVariableInfos, Comparator.comparing(vi -> vi.variable.getType() instanceof PsiEllipsisType).thenComparing(vi -> ArrayUtil.find((Object[])infos, (Object)vi)));
        if (!this.showRefactoringDialog()) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            Runnable action = () -> {
                try {
                    this.doRefactoring();
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            };
            ApplicationManager.getApplication().runWriteAction(action);
        }, JavaRefactoringBundle.message((String)"anonymousToInner.refactoring.name", (Object[])new Object[0]), null);
    }

    protected boolean showRefactoringDialog() {
        boolean anInterface = this.myTargetClass.isInterface();
        boolean needsThis = this.needsThis() || PsiUtil.isInnerClass((PsiClass)this.myTargetClass);
        boolean showCanBeStatic = !needsThis && !anInterface && !this.myAnonOrLocalClass.hasModifierProperty("static");
        AnonymousToInnerDialog dialog = new AnonymousToInnerDialog(this.myProject, this.myAnonOrLocalClass, this.myVariableInfos, showCanBeStatic);
        if (!dialog.showAndGet()) {
            return false;
        }
        this.myNewClassName = dialog.getClassName();
        this.myVariableInfos = dialog.getVariableInfos();
        this.myMakeStatic = !this.myAnonOrLocalClass.hasModifierProperty("static") && !needsThis && (anInterface || dialog.isMakeStatic());
        return true;
    }

    private void doRefactoring() throws IncorrectOperationException {
        this.calculateTypeParametersToCreate();
        ChangeContextUtil.encodeContextInfo((PsiElement)this.myAnonOrLocalClass, (boolean)false);
        this.updateLocalClassConstructors(this.myAnonOrLocalClass);
        PsiClass innerClass = (PsiClass)this.myTargetClass.add((PsiElement)this.createClass(this.myNewClassName));
        ChangeContextUtil.decodeContextInfo((PsiElement)innerClass, (PsiClass)this.myTargetClass, (PsiExpression)RefactoringChangeUtil.createThisExpression((PsiManager)this.myTargetClass.getManager(), (PsiClass)this.myTargetClass));
        if (this.myAnonOrLocalClass instanceof PsiAnonymousClass) {
            this.migrateAnonymousClassCreation(innerClass);
        } else {
            this.migrateLocalClassReferences(innerClass);
        }
        this.collapseDiamonds(innerClass);
    }

    private void collapseDiamonds(PsiClass innerClass) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)innerClass, (SearchScope)new LocalSearchScope((PsiElement)this.myTargetClass)).findAll()) {
            PsiNewExpression newExpression;
            PsiJavaCodeReferenceElement ref;
            PsiJavaCodeReferenceElement refElement;
            PsiElement psiElement = reference.getElement();
            if (!(psiElement instanceof PsiJavaCodeReferenceElement) || !(refElement = (PsiJavaCodeReferenceElement)psiElement).isValid()) continue;
            PsiElement parent = refElement.getParent();
            if (parent instanceof PsiAnonymousClass) {
                PsiAnonymousClass anonymousClass = (PsiAnonymousClass)parent;
                parent = anonymousClass.getParent();
            }
            if (!(parent instanceof PsiNewExpression) || (ref = (newExpression = (PsiNewExpression)parent).getClassOrAnonymousClassReference()) == null || !PsiDiamondTypeUtil.canCollapseToDiamond((PsiNewExpression)newExpression, (PsiNewExpression)newExpression, (PsiType)newExpression.getType())) continue;
            RemoveRedundantTypeArgumentsUtil.replaceExplicitWithDiamond((PsiElement)ref.getParameterList());
        }
    }

    private void migrateLocalClassReferences(PsiClass innerClass) {
        SearchScope scope = this.myAnonOrLocalClass.getUseScope();
        Collection refs = ReferencesSearch.search((PsiElement)this.myAnonOrLocalClass, (SearchScope)scope).findAll();
        this.myAnonOrLocalClass.delete();
        for (PsiReference reference : refs) {
            if (!reference.getElement().isValid()) continue;
            reference.bindToElement((PsiElement)innerClass);
        }
    }

    private void migrateAnonymousClassCreation(PsiClass innerClass) {
        PsiNewExpression newExpr = (PsiNewExpression)this.myAnonOrLocalClass.getParent();
        @NonNls StringBuilder buf = new StringBuilder();
        buf.append("new ");
        buf.append(innerClass.getName());
        if (!this.myTypeParametersToCreate.isEmpty()) {
            buf.append("<");
            for (int idx = 0; idx < this.myTypeParametersToCreate.size(); ++idx) {
                if (idx > 0) {
                    buf.append(", ");
                }
                String string = this.myTypeParametersToCreate.get(idx).getName();
                buf.append(string);
            }
            buf.append(">");
        }
        buf.append("(");
        boolean isFirstParameter = true;
        for (VariableInfo info : this.myVariableInfos) {
            if (!info.passAsParameter) continue;
            if (isFirstParameter) {
                isFirstParameter = false;
            } else {
                buf.append(",");
            }
            buf.append(info.variable.getName());
        }
        buf.append(")");
        PsiNewExpression psiNewExpression = (PsiNewExpression)JavaPsiFacade.getElementFactory((Project)this.myManager.getProject()).createExpressionFromText(buf.toString(), null);
        newExpr.replace((PsiElement)psiNewExpression);
    }

    @Nullable
    private static PsiClass findClassToMove(PsiFile file, int offset) {
        for (PsiElement element = file.findElementAt(offset); element != null; element = element.getParent()) {
            PsiNewExpression newExpression;
            PsiClass psiClass;
            if (element instanceof PsiAnonymousClass) {
                PsiAnonymousClass anonymousClass = (PsiAnonymousClass)element;
                return anonymousClass;
            }
            if (element instanceof PsiClass && PsiUtil.isLocalClass((PsiClass)(psiClass = (PsiClass)element))) {
                return psiClass;
            }
            if (!(element instanceof PsiNewExpression) || (newExpression = (PsiNewExpression)element).getAnonymousClass() == null) continue;
            return newExpression.getAnonymousClass();
        }
        return null;
    }

    public static PsiElement findTargetContainer(PsiClass anonOrLocalClass) {
        PsiElement parent = anonOrLocalClass.getParent();
        while (!(parent instanceof PsiClass) || parent instanceof PsiAnonymousClass) {
            if (parent instanceof PsiFile) {
                return parent;
            }
            parent = parent.getParent();
        }
        return parent;
    }

    private void collectUsedVariables(final Map<PsiVariable, VariableInfo> variableInfoMap, PsiElement scope) {
        scope.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                PsiElement refElement;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (expression.getQualifierExpression() == null && (refElement = expression.resolve()) instanceof PsiVariable) {
                    PsiClass containingClass;
                    PsiVariable var = (PsiVariable)refElement;
                    if (!(refElement instanceof PsiField) && PsiTreeUtil.isAncestor((PsiElement)(containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)var, PsiClass.class)), (PsiElement)AnonymousToInnerHandler.this.myAnonOrLocalClass, (boolean)true)) {
                        AnonymousToInnerHandler.this.saveVariable(variableInfoMap, var, expression);
                    }
                }
                super.visitReferenceExpression(expression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/anonymousToInner/AnonymousToInnerHandler$1", "visitReferenceExpression"));
            }
        });
    }

    public boolean needsThis() {
        if (this.cachedNeedsThis == null) {
            PsiAnonymousClass anonymousClass;
            PsiExpressionList argList;
            ElementNeedsThis memberNeedsThis = new ElementNeedsThis(this.myTargetClass, (PsiElement)this.myAnonOrLocalClass);
            this.myAnonOrLocalClass.accept((PsiElementVisitor)memberNeedsThis);
            class HasExplicitThis
            extends JavaRecursiveElementWalkingVisitor {
                boolean hasExplicitThis;

                HasExplicitThis(AnonymousToInnerHandler this$0) {
                }

                public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                    if (expression == null) {
                        HasExplicitThis.$$$reportNull$$$0(0);
                    }
                }

                public void visitThisExpression(@NotNull PsiThisExpression expression) {
                    if (expression == null) {
                        HasExplicitThis.$$$reportNull$$$0(1);
                    }
                    this.hasExplicitThis = true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "expression";
                    objectArray2[1] = "com/intellij/refactoring/anonymousToInner/AnonymousToInnerHandler$1HasExplicitThis";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitReferenceExpression";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitThisExpression";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
            HasExplicitThis hasExplicitThis = new HasExplicitThis(this);
            PsiClass psiClass = this.myAnonOrLocalClass;
            if (psiClass instanceof PsiAnonymousClass && (argList = (anonymousClass = (PsiAnonymousClass)psiClass).getArgumentList()) != null) {
                argList.accept((PsiElementVisitor)hasExplicitThis);
            }
            this.cachedNeedsThis = memberNeedsThis.usesMembers() || hasExplicitThis.hasExplicitThis;
        }
        return this.cachedNeedsThis;
    }

    private void saveVariable(Map<PsiVariable, VariableInfo> variableInfoMap, PsiVariable var, PsiReferenceExpression usage) {
        VariableInfo info = variableInfoMap.get(var);
        if (info == null) {
            info = new VariableInfo(var);
            variableInfoMap.put(var, info);
        }
        info.saveInField = info.saveInField | !this.isUsedInInitializer((PsiElement)usage);
    }

    private boolean isUsedInInitializer(PsiElement usage) {
        PsiElement parent = usage.getParent();
        while (!this.myAnonOrLocalClass.equals((Object)parent)) {
            PsiMethod method;
            PsiExpressionList expressionList;
            if (parent instanceof PsiExpressionList ? this.myAnonOrLocalClass.equals((Object)(expressionList = (PsiExpressionList)parent).getParent()) : (parent instanceof PsiClassInitializer || parent instanceof PsiField || parent instanceof PsiMethod && (method = (PsiMethod)parent).isConstructor()) && this.myAnonOrLocalClass.equals((Object)((PsiMember)parent).getContainingClass())) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    private PsiClass createClass(String name) throws IncorrectOperationException {
        PsiElement lastChild;
        PsiClass aClass;
        this.renameReferences((PsiElement)this.myAnonOrLocalClass);
        this.updateSelfReferences(this.myAnonOrLocalClass, name);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        PsiClass psiClass = this.myAnonOrLocalClass;
        if (psiClass instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)psiClass;
            aClass = this.createInnerFromAnonymous(name, anonymousClass, factory);
        } else {
            aClass = this.createInnerFromLocal(name, factory);
        }
        PsiTypeParameterList typeParameterList = aClass.getTypeParameterList();
        LOG.assertTrue(typeParameterList != null);
        for (PsiTypeParameter typeParameter : this.myTypeParametersToCreate) {
            typeParameterList.add((PsiElement)typeParameter);
        }
        this.setupModifiers(aClass);
        if (this.myVariableInfos.length > 0) {
            AnonymousToInnerHandler.removeInitializers(aClass);
            this.createFields(aClass);
        }
        if (this.myAnonOrLocalClass instanceof PsiAnonymousClass) {
            this.createAnonymousClassConstructor(aClass);
        }
        if (PsiUtil.isJavaToken((PsiElement)(lastChild = aClass.getLastChild()), (IElementType)JavaTokenType.SEMICOLON)) {
            lastChild.delete();
        }
        return aClass;
    }

    @NotNull
    private PsiClass createInnerFromLocal(String name, PsiElementFactory factory) {
        PsiClass aClass = (PsiClass)this.myAnonOrLocalClass.copy();
        PsiIdentifier identifier = factory.createIdentifier(name);
        Objects.requireNonNull(aClass.getNameIdentifier()).replace((PsiElement)identifier);
        for (PsiMethod method : aClass.getMethods()) {
            PsiIdentifier methodName;
            if (!method.isConstructor() || (methodName = method.getNameIdentifier()) == null) continue;
            methodName.replace((PsiElement)identifier);
        }
        PsiClass psiClass = aClass;
        if (psiClass == null) {
            AnonymousToInnerHandler.$$$reportNull$$$0(3);
        }
        return psiClass;
    }

    @NotNull
    private PsiClass createInnerFromAnonymous(String name, PsiAnonymousClass anonymousClass, PsiElementFactory factory) {
        PsiClass baseClass;
        PsiTypeElement[] parameterElements;
        PsiClass aClass = factory.createClass(name);
        PsiJavaCodeReferenceElement baseClassRef = anonymousClass.getBaseClassReference();
        PsiReferenceParameterList parameterList = baseClassRef.getParameterList();
        if (parameterList != null && (parameterElements = parameterList.getTypeParameterElements()).length == 1 && parameterElements[0].getType() instanceof PsiDiamondType) {
            baseClassRef = (PsiJavaCodeReferenceElement)PsiDiamondTypeUtil.replaceDiamondWithExplicitTypes((PsiElement)parameterList);
        }
        if ((baseClass = (PsiClass)baseClassRef.resolve()) == null || !"java.lang.Object".equals(baseClass.getQualifiedName())) {
            PsiReferenceList refList;
            PsiReferenceList psiReferenceList = refList = baseClass != null && baseClass.isInterface() ? aClass.getImplementsList() : aClass.getExtendsList();
            if (refList != null) {
                refList.add((PsiElement)baseClassRef);
            }
        }
        PsiElement lbrace = this.myAnonOrLocalClass.getLBrace();
        PsiElement rbrace = this.myAnonOrLocalClass.getRBrace();
        if (lbrace != null) {
            aClass.addRange(lbrace.getNextSibling(), rbrace != null ? rbrace.getPrevSibling() : this.myAnonOrLocalClass.getLastChild());
        }
        PsiClass psiClass = aClass;
        if (psiClass == null) {
            AnonymousToInnerHandler.$$$reportNull$$$0(4);
        }
        return psiClass;
    }

    private void setupModifiers(@NotNull PsiClass aClass) {
        if (aClass == null) {
            AnonymousToInnerHandler.$$$reportNull$$$0(5);
        }
        if (!this.myTargetClass.isInterface()) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)aClass, (String)"private", (boolean)true);
            if (aClass.isInterface() || aClass.isEnum() || aClass.isRecord()) {
                return;
            }
            PsiModifierListOwner owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)this.myAnonOrLocalClass, PsiModifierListOwner.class);
            if (owner != null && owner.hasModifierProperty("static") || this.myMakeStatic) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)aClass, (String)"static", (boolean)true);
            }
        } else {
            PsiUtil.setModifierProperty((PsiModifierListOwner)aClass, (String)"packageLocal", (boolean)true);
        }
    }

    private void updateSelfReferences(@NotNull PsiClass aClass, String name) {
        if (aClass == null) {
            AnonymousToInnerHandler.$$$reportNull$$$0(6);
        }
        if (aClass instanceof PsiAnonymousClass) {
            return;
        }
        if (name.equals(aClass.getName()) && this.myTypeParametersToCreate.isEmpty()) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
        int origCount = aClass.getTypeParameters().length;
        for (PsiReference reference : ReferencesSearch.search((PsiElement)aClass, (SearchScope)aClass.getUseScope()).findAll()) {
            PsiReferenceParameterList list;
            PsiTypeElement typeElement;
            PsiJavaCodeReferenceElement refElement;
            PsiElement psiElement;
            reference.handleElementRename(name);
            if (this.myTypeParametersToCreate.isEmpty() || !((psiElement = reference.getElement()) instanceof PsiJavaCodeReferenceElement) || (psiElement = (refElement = (PsiJavaCodeReferenceElement)psiElement).getParent()) instanceof PsiTypeElement && (typeElement = (PsiTypeElement)psiElement).getParent() instanceof PsiClassObjectAccessExpression || (list = (PsiReferenceParameterList)PsiTreeUtil.getChildOfType((PsiElement)refElement, PsiReferenceParameterList.class)) == null || list.getTypeArgumentCount() != origCount) continue;
            for (PsiTypeParameter parameter : this.myTypeParametersToCreate) {
                PsiTypeElement element = factory.createTypeElement((PsiType)factory.createType((PsiClass)parameter));
                list.add((PsiElement)element);
            }
        }
    }

    private void updateLocalClassConstructors(PsiClass aClass) {
        if (aClass instanceof PsiAnonymousClass || this.myVariableInfos.length == 0) {
            return;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            constructors = new PsiMethod[]{AddDefaultConstructorFix.addDefaultConstructor((PsiClass)aClass)};
        }
        HashMap<PsiMethod, List> newExpressions = new HashMap<PsiMethod, List>();
        for (PsiMethod constructor2 : constructors) {
            newExpressions.put(constructor2, new ArrayList());
            if (!constructor2.isVarArgs()) continue;
            VarargParameterInspection.convertVarargMethodToArray((PsiMethod)constructor2);
        }
        for (PsiReference reference : ReferencesSearch.search((PsiElement)aClass, (SearchScope)aClass.getUseScope()).findAll()) {
            PsiMethodReferenceExpression methodRef;
            PsiMethod constructor2;
            constructor2 = reference.getElement().getParent();
            if (!(constructor2 instanceof PsiMethodReferenceExpression) || !(methodRef = (PsiMethodReferenceExpression)constructor2).isConstructor()) continue;
            LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)methodRef, (boolean)false, (boolean)true);
        }
        for (PsiReference reference : ReferencesSearch.search((PsiElement)aClass, (SearchScope)aClass.getUseScope()).findAll()) {
            PsiNewExpression newExpression;
            PsiMethod method;
            List newList;
            PsiElement parent = reference.getElement().getParent();
            if (parent instanceof PsiAnonymousClass) {
                PsiAnonymousClass cls = (PsiAnonymousClass)parent;
                parent = cls.getParent();
            }
            if (!(parent instanceof PsiNewExpression) || (newList = (List)newExpressions.get(method = (newExpression = (PsiNewExpression)parent).resolveConstructor())) == null) continue;
            newList.add(newExpression);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        newExpressions.forEach((constructor, callSites) -> {
            this.fillParameterList((PsiMethod)constructor);
            PsiMethodCallExpression thisOrSuperCall = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)constructor);
            if (JavaPsiConstructorUtil.isChainedConstructorCall((PsiElement)thisOrSuperCall)) {
                for (VariableInfo info : this.myVariableInfos) {
                    if (!info.passAsParameter) continue;
                    thisOrSuperCall.getArgumentList().add((PsiElement)factory.createExpressionFromText(info.parameterName, null));
                }
            } else {
                this.createAssignmentStatements((PsiMethod)constructor);
            }
            this.appendInitializers((PsiMethod)constructor);
            for (PsiNewExpression callSite : callSites) {
                PsiExpressionList arguments = callSite.getArgumentList();
                if (arguments == null) continue;
                for (VariableInfo info : this.myVariableInfos) {
                    arguments.add((PsiElement)factory.createExpressionFromText(Objects.requireNonNull(info.variable.getName()), (PsiElement)arguments));
                }
            }
        });
    }

    private void createAnonymousClassConstructor(@NotNull PsiClass aClass) {
        PsiReferenceList superConstructorThrowsList;
        if (aClass == null) {
            AnonymousToInnerHandler.$$$reportNull$$$0(7);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
        PsiNewExpression newExpression = (PsiNewExpression)this.myAnonOrLocalClass.getParent();
        PsiExpressionList argList = newExpression.getArgumentList();
        assert (argList != null);
        PsiExpression[] originalExpressions = argList.getExpressions();
        PsiMethod superConstructor = newExpression.resolveConstructor();
        PsiReferenceList psiReferenceList = superConstructorThrowsList = superConstructor != null && superConstructor.getThrowsList().getReferencedTypes().length > 0 ? superConstructor.getThrowsList() : null;
        if (this.myVariableInfos.length > 0 || originalExpressions.length > 0 || superConstructorThrowsList != null) {
            PsiMethod constructor = factory.createConstructor();
            if (superConstructorThrowsList != null) {
                constructor.getThrowsList().replace((PsiElement)superConstructorThrowsList);
            }
            if (originalExpressions.length > 0) {
                this.createSuperStatement(constructor, originalExpressions);
            }
            if (this.myVariableInfos.length > 0) {
                this.fillParameterList(constructor);
                this.createAssignmentStatements(constructor);
                this.appendInitializers(constructor);
            }
            constructor = (PsiMethod)codeStyleManager.reformat((PsiElement)constructor);
            aClass.add((PsiElement)constructor);
        }
    }

    private void appendInitializers(PsiMethod constructor) throws IncorrectOperationException {
        PsiCodeBlock constructorBody = constructor.getBody();
        assert (constructorBody != null);
        ArrayList<Object> toAdd = new ArrayList<Object>();
        for (PsiClassInitializer psiClassInitializer : this.myAnonOrLocalClass.getInitializers()) {
            if (psiClassInitializer.hasModifierProperty("static")) continue;
            toAdd.add(psiClassInitializer);
        }
        for (PsiClassInitializer psiClassInitializer : this.myAnonOrLocalClass.getFields()) {
            if (psiClassInitializer.hasModifierProperty("static") || psiClassInitializer.getInitializer() == null) continue;
            toAdd.add(psiClassInitializer);
        }
        toAdd.sort(Comparator.comparingInt(e -> e.getTextRange().getStartOffset()));
        for (PsiElement psiElement : toAdd) {
            if (psiElement instanceof PsiClassInitializer) {
                PsiClassInitializer initializer = (PsiClassInitializer)psiElement;
                PsiCodeBlock psiCodeBlock = initializer.getBody();
                PsiElement firstBodyElement = psiCodeBlock.getFirstBodyElement();
                if (firstBodyElement == null) continue;
                constructorBody.addRange(firstBodyElement, psiCodeBlock.getLastBodyElement());
                continue;
            }
            PsiField psiField = (PsiField)psiElement;
            PsiExpressionStatement statement = (PsiExpressionStatement)JavaPsiFacade.getElementFactory((Project)this.myManager.getProject()).createStatementFromText(psiField.getName() + "= 0;", null);
            PsiExpression rightExpression = ((PsiAssignmentExpression)statement.getExpression()).getRExpression();
            assert (rightExpression != null);
            PsiExpression fieldInitializer = psiField.getInitializer();
            assert (fieldInitializer != null);
            rightExpression.replace((PsiElement)fieldInitializer);
            constructorBody.add((PsiElement)statement);
        }
    }

    private static void removeInitializers(PsiClass targetClass) {
        PsiField[] fields;
        PsiClassInitializer[] initializers;
        for (PsiClassInitializer initializer : initializers = targetClass.getInitializers()) {
            if (initializer.hasModifierProperty("static")) continue;
            initializer.delete();
        }
        for (PsiField field : fields = targetClass.getFields()) {
            PsiExpression initializer = field.getInitializer();
            if (field.hasModifierProperty("static") || initializer == null) continue;
            initializer.delete();
        }
    }

    private void fillParameterList(PsiMethod constructor) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)constructor.getProject());
        PsiParameterList parameterList = constructor.getParameterList();
        for (VariableInfo info : this.myVariableInfos) {
            if (!info.passAsParameter) continue;
            parameterList.add((PsiElement)factory.createParameter(info.parameterName, info.variable.getType()));
        }
    }

    private void createFields(PsiClass aClass) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myManager.getProject());
        for (VariableInfo info : this.myVariableInfos) {
            if (!info.saveInField) continue;
            PsiType type = info.variable.getType();
            if (type instanceof PsiEllipsisType) {
                type = ((PsiEllipsisType)type).toArrayType();
            }
            PsiField field = factory.createField(info.fieldName, type);
            PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"final", (boolean)true);
            aClass.add((PsiElement)field);
        }
    }

    private void createAssignmentStatements(PsiMethod constructor) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)constructor.getProject());
        for (VariableInfo info : this.myVariableInfos) {
            boolean useThis;
            if (!info.saveInField) continue;
            @NonNls String text = info.fieldName + "=a;";
            boolean bl = useThis = info.passAsParameter && info.parameterName.equals(info.fieldName);
            if (useThis) {
                text = "this." + text;
            }
            PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText(text, null);
            statement = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)statement);
            PsiCodeBlock constructorBody = constructor.getBody();
            assert (constructorBody != null);
            statement = (PsiExpressionStatement)constructorBody.add((PsiElement)statement);
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)statement.getExpression();
            PsiReferenceExpression rExpr = (PsiReferenceExpression)assignment.getRExpression();
            assert (rExpr != null);
            if (info.passAsParameter) {
                rExpr.replace((PsiElement)factory.createExpressionFromText(info.parameterName, null));
                continue;
            }
            rExpr.delete();
        }
    }

    private void renameReferences(PsiElement scope) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myManager.getProject());
        for (VariableInfo info : this.myVariableInfos) {
            for (PsiReference reference : ReferencesSearch.search((PsiElement)info.variable, (SearchScope)new LocalSearchScope(scope)).asIterable()) {
                PsiElement ref = reference.getElement();
                PsiIdentifier identifier = (PsiIdentifier)((PsiJavaCodeReferenceElement)ref).getReferenceNameElement();
                assert (identifier != null);
                boolean renameToFieldName = !this.isUsedInInitializer(ref);
                PsiIdentifier newNameIdentifier = factory.createIdentifier(renameToFieldName ? info.fieldName : info.parameterName);
                if (renameToFieldName) {
                    identifier.replace((PsiElement)newNameIdentifier);
                    continue;
                }
                if (!info.passAsParameter) continue;
                identifier.replace((PsiElement)newNameIdentifier);
            }
        }
    }

    private void createSuperStatement(PsiMethod constructor, PsiExpression[] paramExpressions) throws IncorrectOperationException {
        PsiCodeBlock body = constructor.getBody();
        assert (body != null);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)constructor.getProject());
        PsiStatement statement = factory.createStatementFromText("super();", null);
        statement = (PsiStatement)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)statement);
        statement = (PsiStatement)body.add((PsiElement)statement);
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)((PsiExpressionStatement)statement).getExpression();
        PsiExpressionList exprList = methodCall.getArgumentList();
        PsiThisExpression qualifiedThis = (PsiThisExpression)factory.createExpressionFromText("A.this", null);
        PsiJavaCodeReferenceElement targetClassRef = factory.createClassReferenceElement(this.myTargetClass);
        PsiJavaCodeReferenceElement thisQualifier = qualifiedThis.getQualifier();
        assert (thisQualifier != null);
        thisQualifier.replace((PsiElement)targetClassRef);
        for (PsiExpression expr : paramExpressions) {
            ChangeContextUtil.encodeContextInfo((PsiElement)expr, (boolean)true);
            PsiElement newExpr = exprList.add((PsiElement)expr);
            ChangeContextUtil.decodeContextInfo((PsiElement)newExpr, (PsiClass)this.myTargetClass, (PsiExpression)qualifiedThis);
        }
    }

    private void calculateTypeParametersToCreate() {
        final ArrayDeque<Object> visitQueue = new ArrayDeque<Object>();
        JavaRecursiveElementWalkingVisitor visitor2 = new JavaRecursiveElementWalkingVisitor(){
            private final Set<PsiTypeParameter> myAddedTypeParameters = new HashSet<PsiTypeParameter>();

            public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
                PsiTypeParameter typeParameter;
                PsiTypeParameterListOwner owner;
                if (reference == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitReferenceElement(reference);
                PsiElement resolved = reference.resolve();
                if (resolved instanceof PsiTypeParameter && (owner = (typeParameter = (PsiTypeParameter)resolved).getOwner()) != null && !PsiTreeUtil.isAncestor((PsiElement)AnonymousToInnerHandler.this.myAnonOrLocalClass, (PsiElement)owner, (boolean)false) && (!PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)AnonymousToInnerHandler.this.myTargetClass, (boolean)false) || AnonymousToInnerHandler.this.myMakeStatic) && this.myAddedTypeParameters.add(typeParameter)) {
                    AnonymousToInnerHandler.this.myTypeParametersToCreate.add(typeParameter);
                    visitQueue.add(typeParameter.getExtendsList());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/refactoring/anonymousToInner/AnonymousToInnerHandler$2", "visitReferenceElement"));
            }
        };
        visitQueue.add(this.myAnonOrLocalClass);
        for (VariableInfo info : this.myVariableInfos) {
            PsiTypeElement typeElement = info.variable.getTypeElement();
            if (typeElement == null) continue;
            visitQueue.add(typeElement);
        }
        while (!visitQueue.isEmpty()) {
            ((PsiElement)visitQueue.remove()).accept((PsiElementVisitor)visitor2);
        }
        this.myTypeParametersToCreate.sort((Comparator<PsiTypeParameter>)PsiElementOrderComparator.getInstance());
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull PsiElement element) {
        if (project == null) {
            AnonymousToInnerHandler.$$$reportNull$$$0(8);
        }
        if (element == null) {
            AnonymousToInnerHandler.$$$reportNull$$$0(9);
        }
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            this.myProject = project;
            this.myManager = PsiManager.getInstance((Project)this.myProject);
            this.myAnonOrLocalClass = aClass;
            this.myNewClassName = AnonymousToInnerDialog.suggestNewClassNames(aClass)[0];
            PsiElement targetContainer = AnonymousToInnerHandler.findTargetContainer(this.myAnonOrLocalClass);
            if (!(targetContainer instanceof PsiClass)) {
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                if (intentionPreviewInfo == null) {
                    AnonymousToInnerHandler.$$$reportNull$$$0(10);
                }
                return intentionPreviewInfo;
            }
            this.myTargetClass = (PsiClass)targetContainer;
            this.myMakeStatic = !this.needsThis() && !this.myTargetClass.isInterface();
            LinkedHashMap<PsiVariable, VariableInfo> variableInfoMap = new LinkedHashMap<PsiVariable, VariableInfo>();
            this.collectUsedVariables(variableInfoMap, (PsiElement)this.myAnonOrLocalClass);
            this.myVariableInfos = variableInfoMap.values().toArray(new VariableInfo[0]);
            VariableData[] variableData = new VariableData[this.myVariableInfos.length];
            AnonymousToInnerDialog.fillVariableData(this.myProject, this.myVariableInfos, variableData);
            AnonymousToInnerDialog.getVariableInfos(this.myProject, variableData, variableInfoMap);
            this.doRefactoring();
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            if (intentionPreviewInfo == null) {
                AnonymousToInnerHandler.$$$reportNull$$$0(11);
            }
            return intentionPreviewInfo;
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            AnonymousToInnerHandler.$$$reportNull$$$0(12);
        }
        return intentionPreviewInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/anonymousToInner/AnonymousToInnerHandler";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/anonymousToInner/AnonymousToInnerHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createInnerFromLocal";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createInnerFromAnonymous";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupModifiers";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateSelfReferences";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createAnonymousClassConstructor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

