/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.chainCall;

import com.intellij.codeInsight.intention.impl.StreamRefactoringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.refactoring.chainCall.ChainCallExtractor;
import com.siyeh.ig.psiutils.StreamApiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CollectionChainCallExtractor
implements ChainCallExtractor {
    public boolean canExtractChainCall(@NotNull PsiMethodCallExpression call, @NotNull PsiExpression expression, @Nullable PsiType expressionType) {
        if (call == null) {
            CollectionChainCallExtractor.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            CollectionChainCallExtractor.$$$reportNull$$$0(1);
        }
        PsiReferenceExpression methodExpression = call.getMethodExpression();
        if (!(StreamApiUtil.isSupportedStreamElement((PsiType)expressionType) && "forEach".equals(methodExpression.getReferenceName()) && methodExpression.getQualifierExpression() != null && InheritanceUtil.isInheritor((PsiType)methodExpression.getQualifierExpression().getType(), (String)"java.util.Collection"))) {
            return false;
        }
        PsiMethod method = call.resolveMethod();
        return method != null && method.getParameterList().getParametersCount() == 1;
    }

    public String getMethodName(PsiVariable variable, PsiExpression expression, PsiType expressionType) {
        return "stream()." + StreamRefactoringUtil.getMapOperationName((PsiType)variable.getType(), (PsiType)expressionType);
    }

    public String buildChainCall(PsiVariable variable, PsiExpression expression, PsiType expressionType) {
        return ".stream()" + StreamRefactoringUtil.generateMapOperation((PsiVariable)variable, (PsiType)expressionType, (PsiElement)expression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "call";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "expression";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/chainCall/CollectionChainCallExtractor";
        objectArray[2] = "canExtractChainCall";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

