/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.chainCall;

import com.intellij.codeInsight.intention.impl.InlineStreamMapAction;
import com.intellij.codeInsight.intention.impl.StreamRefactoringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.refactoring.chainCall.ChainCallExtractor;
import com.siyeh.ig.psiutils.StreamApiUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class StreamChainCallExtractor
implements ChainCallExtractor {
    public boolean canExtractChainCall(@NotNull PsiMethodCallExpression call, @NotNull PsiExpression expression, PsiType expressionType) {
        if (call == null) {
            StreamChainCallExtractor.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            StreamChainCallExtractor.$$$reportNull$$$0(1);
        }
        if (!StreamApiUtil.isSupportedStreamElement((PsiType)expressionType) || !InlineStreamMapAction.Holder.NEXT_METHODS.contains(call.getMethodExpression().getReferenceName()) || call.getMethodExpression().getQualifierExpression() == null) {
            return false;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null || method.getParameterList().getParametersCount() != 1 || !InheritanceUtil.isInheritor((PsiClass)method.getContainingClass(), (String)"java.util.stream.BaseStream")) {
            return false;
        }
        if (method.getName().startsWith("flatMap")) {
            PsiType outType = StreamApiUtil.getStreamElementType((PsiType)call.getType());
            if (expressionType instanceof PsiPrimitiveType && !expressionType.equals(outType)) {
                return false;
            }
        }
        return true;
    }

    public String fixCallName(PsiMethodCallExpression call, PsiType inType) {
        PsiType outType = StreamApiUtil.getStreamElementType((PsiType)call.getType(), (boolean)false);
        String methodName = Objects.requireNonNull(call.getMethodExpression().getReferenceName());
        if (methodName.startsWith("flatMap")) {
            return Objects.requireNonNull(StreamRefactoringUtil.getFlatMapOperationName((PsiType)inType, (PsiType)outType));
        }
        if (methodName.startsWith("map")) {
            return StreamRefactoringUtil.getMapOperationName((PsiType)inType, (PsiType)outType);
        }
        return methodName;
    }

    public String getMethodName(PsiVariable variable, PsiExpression expression, PsiType expressionType) {
        String shortcutMappingMethod = StreamRefactoringUtil.getShortcutMappingMethod((PsiVariable)variable, (PsiType)expressionType, (PsiElement)expression);
        if (shortcutMappingMethod != null) {
            return shortcutMappingMethod;
        }
        return StreamRefactoringUtil.getMapOperationName((PsiType)variable.getType(), (PsiType)expressionType);
    }

    public String buildChainCall(PsiVariable variable, PsiExpression expression, PsiType expressionType) {
        return StreamRefactoringUtil.generateMapOperation((PsiVariable)variable, (PsiType)expressionType, (PsiElement)expression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "call";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "expression";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/chainCall/StreamChainCallExtractor";
        objectArray[2] = "canExtractChainCall";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

