/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeInsight.JavaTargetElementEvaluator;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.light.LightDefaultConstructor;
import com.intellij.psi.impl.light.LightRecordCanonicalConstructor;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeClassSignature.ChangeClassSignatureDialog;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.JavaMethodDescriptor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.inplace.InplaceChangeSignature;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaChangeSignatureHandler
implements ChangeSignatureHandler {
    private static final Logger LOG = Logger.getInstance(JavaChangeSignatureHandler.class);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            JavaChangeSignatureHandler.$$$reportNull$$$0(0);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element = this.findTargetMember(file, editor);
        if (element == null) {
            element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        }
        JavaChangeSignatureHandler.invokeOnElement(project, editor, element);
    }

    private static void invokeOnElement(Project project, @Nullable Editor editor, PsiElement element) {
        PsiMethod m;
        if (element instanceof PsiMethod && (m = (PsiMethod)element).getNameIdentifier() != null) {
            if (element instanceof SyntheticElement && !(element instanceof LightRecordCanonicalConstructor) && !(element instanceof LightDefaultConstructor)) {
                String message = JavaRefactoringBundle.message((String)"error.cannot.change.signature.implicitly.declared.method", (Object[])new Object[]{m.getName()});
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)JavaChangeSignatureHandler.getRefactoringName(), (String)"refactoring.changeSignature");
                return;
            }
            JavaChangeSignatureHandler.invoke(m, project, editor);
        } else if (element instanceof PsiClass) {
            PsiClass c = (PsiClass)element;
            JavaChangeSignatureHandler.invoke(c, editor);
        } else {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method.or.class.name"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)JavaChangeSignatureHandler.getRefactoringName(), (String)"refactoring.changeSignature");
        }
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, @Nullable DataContext dataContext) {
        if (project == null) {
            JavaChangeSignatureHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            JavaChangeSignatureHandler.$$$reportNull$$$0(2);
        }
        if (elements.length != 1) {
            return;
        }
        Editor editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        JavaChangeSignatureHandler.invokeOnElement(project, editor, elements[0]);
    }

    @NlsContexts.DialogTitle
    @NotNull
    private static String getRefactoringName() {
        String string = RefactoringBundle.message((String)"changeSignature.refactoring.name");
        if (string == null) {
            JavaChangeSignatureHandler.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String getTargetNotFoundMessage() {
        return RefactoringBundle.message((String)"error.wrong.caret.position.method.or.class.name");
    }

    private static void invoke(@NotNull PsiMethod method, @NotNull Project project, @Nullable Editor editor) {
        PsiMethod newMethod;
        if (method == null) {
            JavaChangeSignatureHandler.$$$reportNull$$$0(4);
        }
        if (project == null) {
            JavaChangeSignatureHandler.$$$reportNull$$$0(5);
        }
        if ((newMethod = SuperMethodWarningUtil.checkSuperMethod((PsiMethod)method)) == null) {
            return;
        }
        if (!newMethod.equals((Object)method)) {
            ChangeSignatureUtil.invokeChangeSignatureOn(newMethod, project);
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)method)) {
            return;
        }
        PsiClass aClass = method.getContainingClass();
        PsiReferenceExpression refExpr = editor != null ? JavaTargetElementEvaluator.findReferenceExpression((Editor)editor) : null;
        boolean allowDelegation = aClass != null && (!aClass.isInterface() || PsiUtil.isAvailable((JavaFeature)JavaFeature.EXTENSION_METHODS, (PsiElement)aClass)) && !JavaPsiRecordUtil.isCanonicalConstructor((PsiMethod)method);
        InplaceChangeSignature inplaceChangeSignature = editor != null ? InplaceChangeSignature.getCurrentRefactoring((Editor)editor) : null;
        ChangeInfo initialChange = inplaceChangeSignature != null ? inplaceChangeSignature.getStableChange() : null;
        boolean isInplace = Registry.is((String)"inplace.change.signature") && editor != null && editor.getSettings().isVariableInplaceRenameEnabled() && (initialChange == null || initialChange.getMethod() != method) && refExpr == null;
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        LOG.assertTrue(nameIdentifier != null);
        if (isInplace) {
            CommandProcessor.getInstance().executeCommand(project, () -> new InplaceChangeSignature(project, editor, (PsiElement)nameIdentifier), JavaChangeSignatureHandler.getRefactoringName(), null);
        } else {
            JavaMethodDescriptor methodDescriptor = new JavaMethodDescriptor(method);
            if (initialChange != null) {
                final JavaChangeInfo currentInfo = (JavaChangeInfo)inplaceChangeSignature.getCurrentInfo();
                if (currentInfo != null) {
                    methodDescriptor = new JavaMethodDescriptor(method){

                        public String getName() {
                            return currentInfo.getNewName();
                        }

                        @NotNull
                        public List<ParameterInfoImpl> getParameters() {
                            List<ParameterInfoImpl> list = Arrays.asList((ParameterInfoImpl[])currentInfo.getNewParameters());
                            if (list == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            return list;
                        }

                        @NotNull
                        public String getVisibility() {
                            String string = currentInfo.getNewVisibility();
                            if (string == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return string;
                        }

                        public int getParametersCount() {
                            return currentInfo.getNewParameters().length;
                        }

                        @Nullable
                        public String getReturnTypeText() {
                            return currentInfo.getNewReturnType().getTypeText();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[2];
                            objectArray2[0] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureHandler$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getParameters";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getVisibility";
                                    break;
                                }
                            }
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                        }
                    };
                }
                inplaceChangeSignature.cancel();
            }
            JavaChangeSignatureDialog dialog = new JavaChangeSignatureDialog(project, methodDescriptor, allowDelegation, (PsiElement)(refExpr == null ? method : refExpr));
            dialog.show();
        }
    }

    private static void invoke(PsiClass aClass, Editor editor) {
        PsiTypeParameterList typeParameterList = aClass.getTypeParameterList();
        Project project = aClass.getProject();
        if (typeParameterList == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"changeClassSignature.no.type.parameters", (Object[])new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)JavaChangeSignatureHandler.getRefactoringName(), (String)"change.class.signature.dialog");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)aClass)) {
            return;
        }
        ChangeClassSignatureDialog dialog = new ChangeClassSignatureDialog(aClass, true);
        dialog.show();
    }

    public PsiElement findTargetMember(@NotNull PsiElement element) {
        PsiElement resolved;
        PsiJavaCodeReferenceElement referenceElement;
        PsiReferenceParameterList referenceParameterList;
        PsiClass psiClass;
        PsiMethod m;
        if (element == null) {
            JavaChangeSignatureHandler.$$$reportNull$$$0(6);
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiParameterList.class) != null) {
            return PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        }
        PsiRecordHeader header = (PsiRecordHeader)PsiTreeUtil.getParentOfType((PsiElement)element, PsiRecordHeader.class);
        if (header != null) {
            PsiClass aClass = header.getContainingClass();
            if (aClass != null) {
                return JavaPsiRecordUtil.findCanonicalConstructor((PsiClass)aClass);
            }
            return null;
        }
        PsiTypeParameterList typeParameterList = (PsiTypeParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeParameterList.class);
        if (typeParameterList != null) {
            return PsiTreeUtil.getParentOfType((PsiElement)typeParameterList, PsiMember.class);
        }
        PsiElement elementParent = element.getParent();
        if (elementParent instanceof PsiMethod && (m = (PsiMethod)elementParent).getNameIdentifier() == element) {
            PsiClass containingClass = m.getContainingClass();
            if (containingClass != null && containingClass.isAnnotationType()) {
                return null;
            }
            return elementParent;
        }
        if (elementParent instanceof PsiClass && (psiClass = (PsiClass)elementParent).getNameIdentifier() == element) {
            if (psiClass.isAnnotationType() || psiClass.isEnum()) {
                return null;
            }
            if (psiClass.isRecord()) {
                return JavaPsiRecordUtil.findCanonicalConstructor((PsiClass)psiClass);
            }
            return elementParent;
        }
        PsiCallExpression expression = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCallExpression.class);
        if (expression != null) {
            PsiExpression qualifierExpression;
            if (expression instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression exp = (PsiMethodCallExpression)expression;
                qualifierExpression = exp.getMethodExpression().getQualifierExpression();
            } else if (expression instanceof PsiNewExpression) {
                PsiNewExpression exp = (PsiNewExpression)expression;
                qualifierExpression = exp.getQualifier();
            } else {
                qualifierExpression = null;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)qualifierExpression, (PsiElement)element, (boolean)false)) {
                PsiElement parent;
                PsiExpressionList expressionList = (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)qualifierExpression, PsiExpressionList.class);
                if (expressionList != null && (parent = expressionList.getParent()) instanceof PsiCallExpression) {
                    PsiCallExpression exp = (PsiCallExpression)parent;
                    return exp.resolveMethod();
                }
            } else {
                return expression.resolveMethod();
            }
        }
        if ((referenceParameterList = (PsiReferenceParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, PsiReferenceParameterList.class)) != null && (referenceElement = (PsiJavaCodeReferenceElement)PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiJavaCodeReferenceElement.class)) != null && ((resolved = referenceElement.resolve()) instanceof PsiClass || resolved instanceof PsiMethod)) {
            return resolved;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findTargetMember";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

