/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.TypeNullability;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeconstructionList;
import com.intellij.psi.PsiDeconstructionPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPrimaryPattern;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.light.LightRecordCanonicalConstructor;
import com.intellij.psi.impl.light.LightRecordMethod;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.VariablesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.CallReferenceUsageInfo;
import com.intellij.refactoring.changeSignature.CallerUsageInfo;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureParameterUsageInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.changeSignature.ContractConverter;
import com.intellij.refactoring.changeSignature.DeconstructionUsageInfo;
import com.intellij.refactoring.changeSignature.DefaultValueChooser;
import com.intellij.refactoring.changeSignature.FunctionalInterfaceChangedUsageInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfoConverters;
import com.intellij.refactoring.changeSignature.JavaChangeInfoImpl;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureUsageSearcher;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.changeSignature.MethodCallUsageInfo;
import com.intellij.refactoring.changeSignature.MethodReferenceUsageInfo;
import com.intellij.refactoring.changeSignature.OverriderUsageInfo;
import com.intellij.refactoring.changeSignature.ParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.RecordGetterDeclarationUsageInfo;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.rename.UnresolvableCollisionUsageInfo;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.FieldConflictsResolver;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.usageInfo.DefaultConstructorImplicitUsageInfo;
import com.intellij.refactoring.util.usageInfo.NoConstructorClassUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaChangeSignatureUsageProcessor
implements ChangeSignatureUsageProcessor {
    private static final Logger LOG = Logger.getInstance(JavaChangeSignatureUsageProcessor.class);

    private static boolean isJavaUsage(UsageInfo info) {
        PsiElement element = info.getElement();
        if (element == null) {
            return false;
        }
        return element.getLanguage() == JavaLanguage.INSTANCE;
    }

    public UsageInfo[] findUsages(ChangeInfo info) {
        UsageInfo[] usageInfoArray;
        if (info instanceof JavaChangeInfo) {
            JavaChangeInfo javaInfo = (JavaChangeInfo)info;
            usageInfoArray = new JavaChangeSignatureUsageSearcher(javaInfo).findUsages();
        } else {
            usageInfoArray = UsageInfo.EMPTY_ARRAY;
        }
        return usageInfoArray;
    }

    public MultiMap<PsiElement, @NlsContexts.DialogMessage String> findConflicts(ChangeInfo info, Ref<UsageInfo[]> refUsages) {
        MultiMap<PsiElement, String> multiMap;
        if (info instanceof JavaChangeInfo) {
            JavaChangeInfo javaInfo = (JavaChangeInfo)info;
            multiMap = new ConflictSearcher(javaInfo).findConflicts(refUsages);
        } else {
            multiMap = new MultiMap<PsiElement, String>();
        }
        return multiMap;
    }

    /*
     * Unable to fully structure code
     */
    public boolean processUsage(ChangeInfo changeInfo, UsageInfo usage, boolean beforeMethodChange, UsageInfo[] usages) {
        block34: {
            block35: {
                block36: {
                    block33: {
                        if (!JavaChangeSignatureUsageProcessor.isJavaUsage(usage)) {
                            return false;
                        }
                        javaChangeInfo = JavaChangeInfoConverters.getJavaChangeInfo((ChangeInfo)changeInfo, (UsageInfo)usage);
                        if (javaChangeInfo == null) {
                            return false;
                        }
                        if (!beforeMethodChange) break block33;
                        if (usage instanceof CallerUsageInfo) {
                            callerUsageInfo = (CallerUsageInfo)usage;
                            JavaChangeSignatureUsageProcessor.processCallerMethod(javaChangeInfo, callerUsageInfo.getMethod(), null, callerUsageInfo.isToInsertParameter(), callerUsageInfo.isToInsertException());
                            return true;
                        }
                        if (usage instanceof OverriderUsageInfo) {
                            info = (OverriderUsageInfo)usage;
                            method = info.getOverridingMethod();
                            baseMethod = info.getBaseMethod();
                            if (info.isOriginalOverrider()) {
                                JavaChangeSignatureUsageProcessor.processPrimaryMethod(javaChangeInfo, method, baseMethod, false);
                            } else {
                                JavaChangeSignatureUsageProcessor.processCallerMethod(javaChangeInfo, method, baseMethod, info.isToInsertArgs(), info.isToCatchExceptions());
                            }
                            return true;
                        }
                        if (usage instanceof DeconstructionUsageInfo) {
                            info = (DeconstructionUsageInfo)usage;
                            deconstruction = info.getDeconstruction();
                            elementFactory = JavaPsiFacade.getElementFactory((Project)usage.getProject());
                            processor = new DeconstructionProcessor(javaChangeInfo, elementFactory, deconstruction.getDeconstructionList());
                            processor.run();
                            return true;
                        }
                        if (!(usage instanceof MethodReferenceUsageInfo)) ** GOTO lbl-1000
                        info = (MethodReferenceUsageInfo)usage;
                        if (MethodReferenceUsageInfo.needToExpand(javaChangeInfo)) {
                            element = usage.getElement();
                            if (element instanceof PsiMethodReferenceExpression && (expression = LambdaRefactoringUtil.convertToMethodCallInLambdaBody((PsiMethodReferenceExpression)(ref = (PsiMethodReferenceExpression)element))) instanceof PsiCallExpression) {
                                call = (PsiCallExpression)expression;
                                info.setCallExpression(call);
                                return true;
                            }
                        } else if (usage instanceof FunctionalInterfaceChangedUsageInfo) {
                            functionalUsage = (FunctionalInterfaceChangedUsageInfo)usage;
                            elementFactory = JavaPsiFacade.getElementFactory((Project)usage.getProject());
                            element = usage.getElement();
                            interfaceMethod = functionalUsage.getMethod();
                            if (element instanceof PsiLambdaExpression) {
                                lambda = (PsiLambdaExpression)element;
                                processor = new MethodParamsProcessor(javaChangeInfo, interfaceMethod, elementFactory, PsiSubstitutor.EMPTY, lambda.getParameterList(), lambda.getBody());
                                processor.run();
                            } else if (element instanceof PsiMethodReferenceExpression && (lambdaExpression = LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)(methodRef = (PsiMethodReferenceExpression)element), (boolean)false, (boolean)true)) != null) {
                                processor = new MethodParamsProcessor(javaChangeInfo, interfaceMethod, elementFactory, PsiSubstitutor.EMPTY, lambdaExpression.getParameterList(), lambdaExpression.getBody());
                                processor.run();
                            }
                            return true;
                        }
                        break block34;
                    }
                    element = usage.getElement();
                    JavaChangeSignatureUsageProcessor.LOG.assertTrue(element != null);
                    if (!(usage instanceof DefaultConstructorImplicitUsageInfo)) break block35;
                    defConstructorUsage = (DefaultConstructorImplicitUsageInfo)usage;
                    constructor = defConstructorUsage.getConstructor();
                    if (constructor.isPhysical()) break block36;
                    if (!(changeInfo instanceof JavaChangeInfoImpl)) ** GOTO lbl-1000
                    info = (JavaChangeInfoImpl)changeInfo;
                    if (info.propagateParametersMethods.remove(constructor)) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                    toPropagate = v0;
                    containingClass = defConstructorUsage.getContainingClass();
                    constructor = (PsiMethod)containingClass.add((PsiElement)constructor);
                    PsiUtil.setModifierProperty((PsiModifierListOwner)constructor, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)containingClass.getModifierList()), (boolean)true);
                    if (toPropagate) {
                        ((JavaChangeInfoImpl)changeInfo).propagateParametersMethods.add(constructor);
                    }
                }
                JavaChangeSignatureUsageProcessor.addSuperCall(javaChangeInfo, constructor, defConstructorUsage.getBaseConstructor(), usages);
                return true;
            }
            if (usage instanceof NoConstructorClassUsageInfo) {
                info = (NoConstructorClassUsageInfo)usage;
                JavaChangeSignatureUsageProcessor.addDefaultConstructor(javaChangeInfo, info.getPsiClass(), usages);
                return true;
            }
            if (!(usage instanceof MethodReferenceUsageInfo)) ** GOTO lbl-1000
            info = (MethodReferenceUsageInfo)usage;
            if (MethodReferenceUsageInfo.needToExpand(javaChangeInfo)) {
                methodCallInfo = info.createMethodCallInfo();
                if (methodCallInfo != null) {
                    JavaChangeSignatureUsageProcessor.processMethodUsage(methodCallInfo.getElement(), javaChangeInfo, methodCallInfo.isToChangeArguments(), methodCallInfo.isToCatchExceptions(), methodCallInfo.isVarArgCall(), methodCallInfo.getReferencedMethod(), methodCallInfo.getSubstitutor(), usages);
                    return true;
                }
            } else lbl-1000:
            // 2 sources

            {
                if (usage instanceof MethodCallUsageInfo) {
                    methodCallInfo = (MethodCallUsageInfo)usage;
                    JavaChangeSignatureUsageProcessor.processMethodUsage(methodCallInfo.getElement(), javaChangeInfo, methodCallInfo.isToChangeArguments(), methodCallInfo.isToCatchExceptions(), methodCallInfo.isVarArgCall(), methodCallInfo.getReferencedMethod(), methodCallInfo.getSubstitutor(), usages);
                    return true;
                }
                if (usage instanceof ChangeSignatureParameterUsageInfo) {
                    info = (ChangeSignatureParameterUsageInfo)usage;
                    newName = info.newParameterName;
                    oldName = info.oldParameterName;
                    if (element instanceof PsiReferenceExpression) {
                        ref = (PsiReferenceExpression)element;
                        JavaChangeSignatureUsageProcessor.processParameterUsage(ref, oldName, newName);
                    }
                    return true;
                }
                if (usage instanceof RecordGetterDeclarationUsageInfo) {
                    info = (RecordGetterDeclarationUsageInfo)usage;
                    JavaChangeSignatureUsageProcessor.processRecordGetter((PsiMethod)element, info.myNewName, info.myNewType);
                } else {
                    if (usage instanceof CallReferenceUsageInfo) {
                        info = (CallReferenceUsageInfo)usage;
                        reference = info.getReference();
                        if (!JavaChangeSignatureUsageProcessor.$assertionsDisabled && reference == null) {
                            throw new AssertionError();
                        }
                        reference.handleChangeSignature(changeInfo);
                        return true;
                    }
                    if (element instanceof PsiEnumConstant) {
                        enumConstant = (PsiEnumConstant)element;
                        JavaChangeSignatureUsageProcessor.fixActualArgumentsList(enumConstant.getArgumentList(), javaChangeInfo, true, PsiSubstitutor.EMPTY, false);
                        return true;
                    }
                    if (!(usage instanceof OverriderUsageInfo) && !(usage instanceof UnresolvableCollisionUsageInfo)) {
                        v1 = reference = usage instanceof MoveRenameUsageInfo != false ? usage.getReference() : element.getReference();
                        if (element instanceof PsiImportStaticReferenceElement) {
                            refElement = (PsiImportStaticReferenceElement)element;
                            refElement.handleElementRename(javaChangeInfo.getNewName());
                        } else if (reference != null) {
                            reference.bindToElement((PsiElement)javaChangeInfo.getMethod());
                        }
                    }
                }
            }
        }
        return false;
    }

    private static void processRecordGetter(PsiMethod method, String newName, String type) {
        PsiTypeElement element;
        Project project = method.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        if (newName != null && !newName.equals(method.getName())) {
            PsiIdentifier nameId = method.getNameIdentifier();
            assert (nameId != null) : method;
            nameId.replace((PsiElement)factory.createIdentifier(newName));
        }
        if ((element = method.getReturnTypeElement()) != null && !element.getType().equalsToText(type)) {
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(element.replace((PsiElement)factory.createTypeElementFromText(type, (PsiElement)method)));
        }
    }

    private static void processParameterUsage(PsiReferenceExpression ref, String oldName, String newName) {
        PsiElement last = ref.getReferenceNameElement();
        if (last instanceof PsiIdentifier && last.getText().equals(oldName)) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)ref.getProject());
            PsiIdentifier newNameIdentifier = factory.createIdentifier(newName);
            last.replace((PsiElement)newNameIdentifier);
        }
    }

    private static void addDefaultConstructor(JavaChangeInfo changeInfo, PsiClass aClass, UsageInfo[] usages) {
        if (!(aClass instanceof PsiAnonymousClass)) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)aClass.getProject());
            PsiMethod defaultConstructor = factory.createMethodFromText(aClass.getName() + "(){}", (PsiElement)aClass);
            defaultConstructor = (PsiMethod)CodeStyleManager.getInstance((Project)aClass.getProject()).reformat((PsiElement)defaultConstructor);
            defaultConstructor = (PsiMethod)aClass.add((PsiElement)defaultConstructor);
            PsiUtil.setModifierProperty((PsiModifierListOwner)defaultConstructor, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)aClass.getModifierList()), (boolean)true);
            JavaChangeSignatureUsageProcessor.addSuperCall(changeInfo, defaultConstructor, null, usages);
        } else {
            PsiElement parent = aClass.getParent();
            if (parent instanceof PsiNewExpression) {
                PsiNewExpression expression = (PsiNewExpression)parent;
                PsiExpressionList argumentList = expression.getArgumentList();
                PsiClass baseClass = changeInfo.getMethod().getContainingClass();
                PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                JavaChangeSignatureUsageProcessor.fixActualArgumentsList(argumentList, changeInfo, true, substitutor, false);
            }
        }
    }

    private static void addSuperCall(JavaChangeInfo changeInfo, PsiMethod constructor, PsiMethod callee, UsageInfo[] usages) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)constructor.getProject());
        PsiExpressionStatement superCall = (PsiExpressionStatement)factory.createStatementFromText("super();", (PsiElement)constructor);
        PsiCodeBlock body = constructor.getBody();
        assert (body != null);
        PsiStatement[] statements = body.getStatements();
        superCall = statements.length > 0 ? (PsiExpressionStatement)body.addBefore((PsiElement)superCall, (PsiElement)statements[0]) : (PsiExpressionStatement)body.add((PsiElement)superCall);
        PsiMethodCallExpression callExpression = (PsiMethodCallExpression)superCall.getExpression();
        PsiClass aClass = constructor.getContainingClass();
        PsiClass baseClass = changeInfo.getMethod().getContainingClass();
        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)baseClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        JavaChangeSignatureUsageProcessor.processMethodUsage((PsiElement)callExpression.getMethodExpression(), changeInfo, true, false, changeInfo.wasVararg(), callee, substitutor, usages);
    }

    private static void processMethodUsage(PsiElement element, JavaChangeInfo changeInfo, boolean toChangeArguments, boolean toCatchExceptions, boolean varArgCall, PsiMethod callee, PsiSubstitutor substitutor, UsageInfo[] usages) {
        PsiStatement statement;
        PsiJavaCodeReferenceElement ref;
        PsiElement last;
        if (changeInfo.isNameChanged() && element instanceof PsiJavaCodeReferenceElement && (last = (ref = (PsiJavaCodeReferenceElement)element).getReferenceNameElement()) instanceof PsiIdentifier && last.getText().equals(changeInfo.getOldName())) {
            last.replace((PsiElement)changeInfo.getNewNameIdentifier());
        }
        PsiMethod caller = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (toChangeArguments) {
            PsiReferenceExpression ref2;
            PsiExpression qualifierExpression;
            PsiExpressionList list = RefactoringUtil.getArgumentListByMethodReference(element);
            LOG.assertTrue(list != null);
            boolean toInsertDefaultValue = JavaChangeSignatureUsageProcessor.needDefaultValue((ChangeInfo)changeInfo, caller);
            if (toInsertDefaultValue && element instanceof PsiReferenceExpression && (qualifierExpression = (ref2 = (PsiReferenceExpression)element).getQualifierExpression()) instanceof PsiSuperExpression && caller != null && JavaChangeSignatureUsageProcessor.callerSignatureIsAboutToChangeToo(caller, usages)) {
                toInsertDefaultValue = false;
            }
            JavaChangeSignatureUsageProcessor.fixActualArgumentsList(list, changeInfo, toInsertDefaultValue, substitutor, varArgCall);
        }
        if (toCatchExceptions && (!(element instanceof PsiReferenceExpression) || (statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class)) == null || !JavaHighlightUtil.isSuperOrThisCall((PsiStatement)statement, (boolean)true, (boolean)false)) && JavaChangeSignatureUsageProcessor.needToCatchExceptions(changeInfo, caller)) {
            PsiClassType[] newExceptions = callee != null ? JavaChangeSignatureUsageProcessor.getCalleeChangedExceptionInfo(callee) : JavaChangeSignatureUsageProcessor.getPrimaryChangedExceptionInfo(changeInfo);
            JavaChangeSignatureUsageProcessor.fixExceptions(element, newExceptions);
        }
    }

    private static boolean callerSignatureIsAboutToChangeToo(@NotNull PsiMethod caller, UsageInfo[] usages) {
        if (caller == null) {
            JavaChangeSignatureUsageProcessor.$$$reportNull$$$0(0);
        }
        for (UsageInfo usage : usages) {
            MethodCallUsageInfo info;
            if (!(usage instanceof MethodCallUsageInfo) || !MethodSignatureUtil.isSuperMethod((PsiMethod)(info = (MethodCallUsageInfo)usage).getReferencedMethod(), (PsiMethod)caller)) continue;
            return true;
        }
        return false;
    }

    private static PsiClassType[] getCalleeChangedExceptionInfo(PsiMethod callee) {
        return callee.getThrowsList().getReferencedTypes();
    }

    private static void fixExceptions(PsiElement ref, PsiClassType[] newExceptions) {
        newExceptions = JavaChangeSignatureUsageProcessor.filterCheckedExceptions(newExceptions);
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{PsiTryStatement.class, PsiMethod.class, PsiLambdaExpression.class});
        if (context instanceof PsiTryStatement) {
            PsiParameter[] catchParameters;
            PsiTryStatement tryStatement = (PsiTryStatement)context;
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            Collection classes = ExceptionUtil.collectUnhandledExceptions((PsiElement)tryBlock, (PsiElement)tryBlock);
            for (PsiParameter parameter : catchParameters = tryStatement.getCatchBlockParameters()) {
                PsiClassType type;
                PsiType caughtType = parameter.getType();
                if (!(caughtType instanceof PsiClassType) || ExceptionUtil.isUncheckedExceptionOrSuperclass((PsiClassType)(type = (PsiClassType)caughtType)) || !JavaChangeSignatureUsageProcessor.isCatchParameterRedundant(type, classes)) continue;
                parameter.getParent().delete();
            }
            PsiClassType[] exceptionsToAdd = JavaChangeSignatureUsageProcessor.filterUnhandledExceptions(newExceptions, (PsiElement)tryBlock);
            JavaChangeSignatureUsageProcessor.addExceptions(exceptionsToAdd, tryStatement);
            JavaChangeSignatureUsageProcessor.adjustPossibleEmptyTryStatement(tryStatement);
        } else if ((newExceptions = JavaChangeSignatureUsageProcessor.filterUnhandledExceptions(newExceptions, ref)).length > 0) {
            PsiStatement anchor;
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)ref.getProject());
            PsiTryStatement tryStatement = (PsiTryStatement)elementFactory.createStatementFromText("try {} catch (Exception e) {}", null);
            if (context instanceof PsiLambdaExpression) {
                PsiLambdaExpression lambda = (PsiLambdaExpression)context;
                PsiCodeBlock codeBlock = CommonJavaRefactoringUtil.expandExpressionLambdaToCodeBlock((PsiLambdaExpression)lambda);
                LOG.assertTrue(codeBlock != null);
                anchor = codeBlock.getStatements()[0];
            } else {
                anchor = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiStatement.class);
            }
            LOG.assertTrue(anchor != null);
            PsiElement container = anchor.getParent();
            PsiElement[] elements = SurroundWithUtil.moveDeclarationsOut((PsiElement)container, (PsiElement[])new PsiElement[]{anchor}, (boolean)true);
            tryStatement = (PsiTryStatement)container.addAfter((PsiElement)tryStatement, elements[elements.length - 1]);
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            LOG.assertTrue(tryBlock != null);
            tryBlock.addRange(elements[0], elements[elements.length - 1]);
            JavaChangeSignatureUsageProcessor.addExceptions(newExceptions, tryStatement);
            container.deleteChildRange(elements[0], elements[elements.length - 1]);
            tryStatement.getCatchSections()[0].delete();
        }
    }

    public static boolean hasNewCheckedExceptions(JavaChangeInfo changeInfo) {
        return JavaChangeSignatureUsageProcessor.filterCheckedExceptions(JavaChangeSignatureUsageProcessor.getPrimaryChangedExceptionInfo(changeInfo)).length > 0;
    }

    private static PsiClassType[] filterCheckedExceptions(PsiClassType[] exceptions) {
        ArrayList<PsiClassType> result = new ArrayList<PsiClassType>();
        for (PsiClassType exceptionType : exceptions) {
            if (ExceptionUtil.isUncheckedException((PsiClassType)exceptionType)) continue;
            result.add(exceptionType);
        }
        return result.toArray(PsiClassType.EMPTY_ARRAY);
    }

    private static void adjustPossibleEmptyTryStatement(PsiTryStatement tryStatement) {
        PsiCodeBlock tryBlock = tryStatement.getTryBlock();
        if (tryBlock != null && tryStatement.getCatchSections().length == 0 && tryStatement.getFinallyBlock() == null && tryStatement.getResourceList() == null) {
            PsiElement firstBodyElement = tryBlock.getFirstBodyElement();
            if (firstBodyElement != null) {
                tryStatement.getParent().addRangeAfter(firstBodyElement, tryBlock.getLastBodyElement(), (PsiElement)tryStatement);
            }
            tryStatement.delete();
        }
    }

    private static void addExceptions(PsiClassType[] exceptionsToAdd, PsiTryStatement tryStatement) {
        for (PsiClassType type : exceptionsToAdd) {
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)tryStatement.getProject());
            String name = styleManager.suggestVariableName((VariableKind)VariableKind.PARAMETER, null, null, (PsiType)type).names[0];
            name = styleManager.suggestUniqueVariableName(name, (PsiElement)tryStatement, false);
            PsiCatchSection catchSection = JavaPsiFacade.getElementFactory((Project)tryStatement.getProject()).createCatchSection((PsiType)type, name, (PsiElement)tryStatement);
            tryStatement.add((PsiElement)catchSection);
        }
    }

    private static PsiClassType[] filterUnhandledExceptions(PsiClassType[] exceptions, PsiElement place) {
        ArrayList<PsiClassType> result = new ArrayList<PsiClassType>();
        for (PsiClassType exception : exceptions) {
            if (ExceptionUtil.isHandled((PsiClassType)exception, (PsiElement)place)) continue;
            result.add(exception);
        }
        return result.toArray(PsiClassType.EMPTY_ARRAY);
    }

    private static boolean isCatchParameterRedundant(PsiClassType catchParamType, Collection<? extends PsiClassType> thrownTypes) {
        for (PsiType psiType : thrownTypes) {
            if (!psiType.isConvertibleFrom((PsiType)catchParamType)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void fixActualArgumentsList(PsiExpressionList list, JavaChangeInfo changeInfo, boolean toInsertDefaultValue, PsiSubstitutor substitutor, boolean varArgCall) {
        PsiExpression[] newArgs;
        String[] oldVarargs;
        int newArgsLength;
        int newNonVarargCount;
        JavaParameterInfo[] newParameters2;
        PsiExpression[] newVarargInitializers;
        int nonVarargCount;
        PsiExpression[] args;
        int varargCount;
        PsiElementFactory factory;
        block23: {
            int n;
            ParameterInfoImpl[] parameterInfoImplArray;
            block22: {
                block21: {
                    ParameterInfoImpl[] createdParamInfo;
                    factory = JavaPsiFacade.getElementFactory((Project)list.getProject());
                    if (!changeInfo.isParameterSetOrOrderChanged()) return;
                    if (!(changeInfo instanceof JavaChangeInfoImpl)) break block21;
                    JavaChangeInfoImpl javaChangeInfo = (JavaChangeInfoImpl)changeInfo;
                    if (!javaChangeInfo.isPropagationEnabled) break block21;
                    parameterInfoImplArray = createdParamInfo = javaChangeInfo.getCreatedParmsInfoWithoutVarargs();
                    n = parameterInfoImplArray.length;
                    break block22;
                }
                if ((varargCount = (args = list.getExpressions()).length - (nonVarargCount = varArgCall ? JavaChangeSignatureUsageProcessor.getNonVarargCount(changeInfo, args) : args.length)) < 0) {
                    return;
                }
                newVarargInitializers = null;
                newParameters2 = changeInfo.getNewParameters();
                if (changeInfo.isArrayToVarargs()) {
                    PsiNewExpression expression;
                    PsiArrayInitializerExpression arrayInitializer;
                    newNonVarargCount = newParameters2.length - 1;
                    JavaParameterInfo lastNewParam = newParameters2[newParameters2.length - 1];
                    PsiExpression arrayToConvert = args[lastNewParam.getOldIndex()];
                    if (arrayToConvert instanceof PsiNewExpression && (arrayInitializer = (expression = (PsiNewExpression)arrayToConvert).getArrayInitializer()) != null) {
                        newVarargInitializers = arrayInitializer.getInitializers();
                    }
                    newArgsLength = newVarargInitializers == null ? newParameters2.length : newNonVarargCount + newVarargInitializers.length;
                } else if (changeInfo.isRetainsVarargs() && varArgCall) {
                    newNonVarargCount = newParameters2.length - 1;
                    newArgsLength = newNonVarargCount + varargCount;
                } else if (changeInfo.isObtainsVarags()) {
                    newArgsLength = newNonVarargCount = newParameters2.length - 1;
                } else {
                    newNonVarargCount = newParameters2.length;
                    newArgsLength = newParameters2.length;
                }
                oldVarargs = null;
                if (varArgCall && changeInfo.wasVararg() && !changeInfo.isRetainsVarargs()) {
                    oldVarargs = new String[varargCount];
                    for (int i = nonVarargCount; i < args.length; ++i) {
                        oldVarargs[i - nonVarargCount] = args[i].getText();
                    }
                }
                newArgs = new PsiExpression[newArgsLength];
                break block23;
            }
            for (int i = 0; i < n; ++i) {
                ParameterInfoImpl info = parameterInfoImplArray[i];
                PsiExpression newArg = toInsertDefaultValue ? JavaChangeSignatureUsageProcessor.createDefaultValue(changeInfo, factory, (JavaParameterInfo)info, list, substitutor) : factory.createExpressionFromText(info.getName(), (PsiElement)list);
                if (newArg == null) continue;
                JavaCodeStyleManager.getInstance((Project)list.getProject()).shortenClassReferences(list.add((PsiElement)newArg));
            }
            return;
        }
        for (int i = 0; i < newNonVarargCount; ++i) {
            PsiType type;
            if (newParameters2[i].getOldIndex() == nonVarargCount && oldVarargs != null && (type = newParameters2[i].createType((PsiElement)changeInfo.getMethod(), list.getManager())) instanceof PsiArrayType) {
                type = substitutor.substitute(type);
                type = TypeConversionUtil.erasure((PsiType)type);
                String typeText = type.getCanonicalText();
                if (type instanceof PsiEllipsisType) {
                    typeText = typeText.replace("...", "[]");
                }
                String text = "new " + typeText + "{" + StringUtil.join((String[])oldVarargs, (String)",") + "}";
                newArgs[i] = factory.createExpressionFromText(text, (PsiElement)changeInfo.getMethod());
                continue;
            }
            newArgs[i] = JavaChangeSignatureUsageProcessor.createActualArgument(changeInfo, list, newParameters2[i], toInsertDefaultValue, args, substitutor);
        }
        if (changeInfo.isArrayToVarargs()) {
            if (newVarargInitializers == null) {
                newArgs[newNonVarargCount] = JavaChangeSignatureUsageProcessor.createActualArgument(changeInfo, list, newParameters2[newNonVarargCount], toInsertDefaultValue, args, substitutor);
            } else {
                System.arraycopy(newVarargInitializers, 0, newArgs, newNonVarargCount, newVarargInitializers.length);
            }
        } else {
            int newVarargCount = newArgsLength - newNonVarargCount;
            LOG.assertTrue(newVarargCount == 0 || newVarargCount == varargCount);
            for (int i = newNonVarargCount; i < newArgsLength; ++i) {
                int oldIndex = newParameters2[newNonVarargCount].getOldIndex();
                if (oldIndex >= 0 && oldIndex != nonVarargCount) {
                    newArgs[i] = JavaChangeSignatureUsageProcessor.createActualArgument(changeInfo, list, newParameters2[newNonVarargCount], toInsertDefaultValue, args, substitutor);
                    continue;
                }
                System.arraycopy(args, nonVarargCount, newArgs, newNonVarargCount, newVarargCount);
                break;
            }
        }
        ChangeSignatureUtil.synchronizeList(list, Arrays.asList(newArgs), ExpressionList.INSTANCE, changeInfo.toRemoveParm());
    }

    private static int getNonVarargCount(JavaChangeInfo changeInfo, PsiExpression[] args) {
        if (!changeInfo.wasVararg()) {
            return args.length;
        }
        return changeInfo.getOldParameterTypes().length - 1;
    }

    @Nullable
    private static PsiExpression createActualArgument(JavaChangeInfo changeInfo, PsiExpressionList list, JavaParameterInfo info, boolean toInsertDefaultValue, PsiExpression[] args, PsiSubstitutor substitutor) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)list.getProject());
        int index = info.getOldIndex();
        if (index >= 0 && index < args.length) {
            return args[index];
        }
        if (toInsertDefaultValue) {
            return JavaChangeSignatureUsageProcessor.createDefaultValue(changeInfo, factory, info, list, substitutor);
        }
        return factory.createExpressionFromText(info.getName(), (PsiElement)list);
    }

    @Nullable
    private static PsiExpression createDefaultValue(JavaChangeInfo changeInfo, PsiElementFactory factory, JavaParameterInfo info, final PsiExpressionList list, PsiSubstitutor substitutor) {
        if (info.isUseAnySingleVariable()) {
            PsiClass parentClass;
            final PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)list.getProject()).getResolveHelper();
            final PsiType type = info.getTypeWrapper().getType((PsiElement)changeInfo.getMethod(), list.getManager());
            VariablesProcessor processor = new VariablesProcessor(false){

                protected boolean check(PsiVariable var, ResolveState state) {
                    PsiField field;
                    if (var instanceof PsiField && !resolveHelper.isAccessible((PsiMember)(field = (PsiField)var), (PsiElement)list, null)) {
                        return false;
                    }
                    if (var instanceof PsiLocalVariable && list.getTextRange().getStartOffset() <= var.getTextRange().getStartOffset()) {
                        return false;
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)var, (PsiElement)list, (boolean)false)) {
                        return false;
                    }
                    PsiType varType = ((PsiSubstitutor)state.get(PsiSubstitutor.KEY)).substitute(var.getType());
                    return type.isAssignableFrom(varType);
                }

                public boolean execute(@NotNull PsiElement pe, @NotNull ResolveState state) {
                    if (pe == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (state == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.execute(pe, state);
                    return this.size() < 2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "pe";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "state";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureUsageProcessor$1";
                    objectArray[2] = "execute";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            PsiScopesUtil.treeWalkUp((PsiScopeProcessor)processor, (PsiElement)list, null);
            if (processor.size() == 1) {
                PsiVariable result = processor.getResult(0);
                return factory.createExpressionFromText(result.getName(), (PsiElement)list);
            }
            if (processor.size() == 0 && (parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)list, PsiClass.class)) != null) {
                PsiClass containingClass = parentClass;
                HashSet<PsiClass> containingClasses = new HashSet<PsiClass>();
                while (containingClass != null) {
                    if (type.isAssignableFrom((PsiType)factory.createType(containingClass, PsiSubstitutor.EMPTY))) {
                        containingClasses.add(containingClass);
                    }
                    containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class);
                }
                if (containingClasses.size() == 1) {
                    PsiClass aClass = containingClasses.contains(parentClass) ? null : (PsiClass)containingClasses.iterator().next();
                    return RefactoringChangeUtil.createThisExpression((PsiManager)parentClass.getManager(), (PsiClass)aClass);
                }
            }
        }
        PsiCallExpression callExpression = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)list, PsiCallExpression.class);
        String defaultValue = info.getDefaultValue();
        return callExpression != null ? (PsiExpression)info.getActualValue((PsiElement)callExpression, (Object)substitutor) : (!StringUtil.isEmpty((String)defaultValue) ? factory.createExpressionFromText(defaultValue, (PsiElement)list) : null);
    }

    public boolean processPrimaryMethod(ChangeInfo changeInfo) {
        if (!JavaLanguage.INSTANCE.equals(changeInfo.getLanguage()) || !(changeInfo instanceof JavaChangeInfo)) {
            return false;
        }
        JavaChangeInfo javaChangeInfo = (JavaChangeInfo)changeInfo;
        PsiMethod method = javaChangeInfo.getMethod();
        if (!JavaLanguage.INSTANCE.equals(method.getLanguage())) {
            return false;
        }
        if (!method.isDefaultConstructor()) {
            if (!(method.isPhysical() || method instanceof LightRecordMethod || method instanceof LightRecordCanonicalConstructor)) {
                return false;
            }
        } else {
            String className;
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
            PsiClass aClass = method.getContainingClass();
            if (method.isDefaultConstructor() && aClass != null && (className = aClass.getName()) != null) {
                PsiMethod constructor = factory.createConstructor(className, (PsiElement)aClass);
                PsiUtil.setModifierProperty((PsiModifierListOwner)constructor, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)aClass.getModifierList()), (boolean)true);
                method = (PsiMethod)aClass.add((PsiElement)constructor);
                javaChangeInfo.updateMethod(method);
            }
        }
        if (changeInfo.isGenerateDelegate()) {
            JavaChangeSignatureUsageProcessor.generateDelegate(javaChangeInfo);
        }
        JavaChangeSignatureUsageProcessor.processPrimaryMethod(javaChangeInfo, method, null, true);
        return true;
    }

    public boolean shouldPreviewUsages(ChangeInfo changeInfo, UsageInfo[] usages) {
        return false;
    }

    public boolean setupDefaultValues(ChangeInfo changeInfo, Ref<UsageInfo[]> refUsages, Project project) {
        if (!(changeInfo instanceof JavaChangeInfo)) {
            return true;
        }
        for (UsageInfo usageInfo : (UsageInfo[])refUsages.get()) {
            ParameterInfo[] parameters;
            PsiMethod caller;
            boolean needDefaultValue;
            PsiElement element;
            MethodCallUsageInfo methodCallUsageInfo;
            if (!(usageInfo instanceof MethodCallUsageInfo) || !(methodCallUsageInfo = (MethodCallUsageInfo)usageInfo).isToChangeArguments() || (element = methodCallUsageInfo.getElement()) == null || !(needDefaultValue = JavaChangeSignatureUsageProcessor.needDefaultValue(changeInfo, caller = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class))) || caller != null && MethodSignatureUtil.isSuperMethod((PsiMethod)methodCallUsageInfo.getReferencedMethod(), (PsiMethod)caller)) continue;
            for (ParameterInfo parameter : parameters = changeInfo.getNewParameters()) {
                String defaultValue = parameter.getDefaultValue();
                if (defaultValue != null || !parameter.isNew()) continue;
                ((ParameterInfoImpl)parameter).setDefaultValue("");
                if (ApplicationManager.getApplication().isUnitTestMode()) continue;
                PsiType type = ((ParameterInfoImpl)parameter).getTypeWrapper().getType(element);
                DefaultValueChooser chooser = new DefaultValueChooser(project, parameter.getName(), PsiTypesUtil.getDefaultValueOfType((PsiType)type));
                if (chooser.showAndGet()) {
                    if (chooser.feelLucky()) {
                        parameter.setUseAnySingleVariable(true);
                        continue;
                    }
                    ((ParameterInfoImpl)parameter).setDefaultValue(chooser.getDefaultValue());
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    public void registerConflictResolvers(List<? super ResolveSnapshotProvider.ResolveSnapshot> snapshots, @NotNull ResolveSnapshotProvider resolveSnapshotProvider, UsageInfo[] usages, ChangeInfo changeInfo) {
        if (resolveSnapshotProvider == null) {
            JavaChangeSignatureUsageProcessor.$$$reportNull$$$0(1);
        }
        snapshots.add((ResolveSnapshotProvider.ResolveSnapshot)resolveSnapshotProvider.createSnapshot(changeInfo.getMethod()));
        for (UsageInfo usage : usages) {
            if (!(usage instanceof OverriderUsageInfo)) continue;
            OverriderUsageInfo info = (OverriderUsageInfo)usage;
            snapshots.add((ResolveSnapshotProvider.ResolveSnapshot)resolveSnapshotProvider.createSnapshot((PsiElement)info.getOverridingMethod()));
        }
    }

    private static boolean needDefaultValue(ChangeInfo changeInfo, @Nullable PsiMethod method) {
        if (!(changeInfo instanceof JavaChangeInfoImpl)) {
            return true;
        }
        JavaChangeInfoImpl info = (JavaChangeInfoImpl)changeInfo;
        if (method != null) {
            Set parametersMethods = info.propagateParametersMethods;
            if (parametersMethods.contains(method)) {
                return false;
            }
            for (PsiMethod superMethod : method.findDeepestSuperMethods()) {
                if (!parametersMethods.contains(superMethod)) continue;
                return false;
            }
        }
        return true;
    }

    public static void generateDelegate(JavaChangeInfo changeInfo) {
        PsiMethod delegate = JavaChangeSignatureUsageProcessor.generateDelegatePrototype(changeInfo);
        PsiClass targetClass = changeInfo.getMethod().getContainingClass();
        LOG.assertTrue(targetClass != null);
        targetClass.addBefore((PsiElement)delegate, (PsiElement)changeInfo.getMethod());
    }

    public static PsiMethod generateDelegatePrototype(JavaChangeInfo changeInfo) {
        PsiMethod delegate = (PsiMethod)changeInfo.getMethod().copy();
        PsiClass targetClass = changeInfo.getMethod().getContainingClass();
        LOG.assertTrue(targetClass != null);
        if (targetClass.isInterface() && delegate.getBody() == null) {
            delegate.getModifierList().setModifierProperty("default", true);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)targetClass.getProject());
        ChangeSignatureProcessor.makeEmptyBody(factory, delegate);
        PsiCallExpression callExpression = ChangeSignatureProcessor.addDelegatingCallTemplate(delegate, changeInfo.getNewName());
        JavaChangeSignatureUsageProcessor.addDelegateArguments(changeInfo, factory, callExpression);
        return delegate;
    }

    private static void addDelegateArguments(JavaChangeInfo changeInfo, PsiElementFactory factory, PsiCallExpression callExpression) {
        String[] oldParameterNames = changeInfo.getOldParameterNames();
        for (JavaParameterInfo newParameter : changeInfo.getNewParameters()) {
            PsiExpression actualArg = newParameter.getOldIndex() >= 0 ? factory.createExpressionFromText(oldParameterNames[newParameter.getOldIndex()], (PsiElement)callExpression) : (PsiExpression)newParameter.getActualValue((PsiElement)callExpression, (Object)PsiSubstitutor.EMPTY);
            PsiExpressionList argumentList = callExpression.getArgumentList();
            if (actualArg == null || argumentList == null) continue;
            JavaCodeStyleManager.getInstance((Project)callExpression.getProject()).shortenClassReferences(argumentList.add((PsiElement)actualArg));
        }
    }

    public static void processPrimaryMethod(JavaChangeInfo changeInfo, PsiMethod method, PsiMethod baseMethod, boolean isOriginal) {
        PsiAnnotation annotation;
        if (changeInfo.isVisibilityChanged()) {
            JavaChangeInfoImpl info;
            PsiModifierList modifierList = method.getModifierList();
            String targetVisibility = isOriginal || changeInfo instanceof JavaChangeInfoImpl && (info = (JavaChangeInfoImpl)changeInfo).isPropagateVisibility() ? changeInfo.getNewVisibility() : VisibilityUtil.getHighestVisibility((String)changeInfo.getNewVisibility(), (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)modifierList));
            VisibilityUtil.setVisibility((PsiModifierList)modifierList, (String)targetVisibility);
        }
        if (changeInfo.isNameChanged()) {
            String newName;
            String string = newName = baseMethod == null ? changeInfo.getNewName() : RefactoringUtil.suggestNewOverriderName(method.getName(), baseMethod.getName(), changeInfo.getNewName());
            if (newName != null && !newName.equals(method.getName())) {
                PsiIdentifier nameId = method.getNameIdentifier();
                assert (nameId != null) : method;
                nameId.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)method.getProject()).createIdentifier(newName));
            }
        }
        PsiSubstitutor substitutor = baseMethod == null ? PsiSubstitutor.EMPTY : ChangeSignatureProcessor.calculateSubstitutor(method, baseMethod);
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)method.getProject());
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)method.getProject());
        if (changeInfo.isReturnTypeChanged()) {
            PsiTypeElement typeElement;
            PsiType newTypeElement = changeInfo.getNewReturnType().getType((PsiElement)changeInfo.getMethod().getParameterList(), method.getManager());
            PsiType returnType = substitutor.substitute(newTypeElement);
            if (method.getName().equals(changeInfo.getNewName()) && (typeElement = method.getReturnTypeElement()) != null) {
                JavaChangeSignatureUsageProcessor.ensureNullabilityAnnotationsDoNotRepeat(typeElement, returnType);
                PsiTypeElement replacementType = factory.createTypeElement(returnType);
                javaCodeStyleManager.shortenClassReferences(typeElement.replace((PsiElement)replacementType));
                if (replacementType.getText().startsWith("@")) {
                    javaCodeStyleManager.shortenClassReferences((PsiElement)method.getModifierList());
                }
            }
        }
        PsiParameterList list = method.getParameterList();
        PsiClass aClass = method.getContainingClass();
        boolean isRecordCanonicalConstructor = aClass != null && JavaPsiRecordUtil.isCanonicalConstructor((PsiMethod)method);
        boolean shouldChangeParameters = !isRecordCanonicalConstructor || JavaPsiRecordUtil.isExplicitCanonicalConstructor((PsiMethod)method);
        int newParamsLength = MethodParamsProcessor.getNewParametersCount(changeInfo, baseMethod, list);
        if (shouldChangeParameters) {
            MethodParamsProcessor processor = new MethodParamsProcessor(changeInfo, baseMethod, factory, substitutor, list, (PsiElement)method.getBody());
            processor.run();
        }
        if (isRecordCanonicalConstructor) {
            PsiRecordHeader header = aClass.getRecordHeader();
            if (header == null) {
                header = factory.createRecordHeaderFromText("", (PsiElement)aClass);
                header = (PsiRecordHeader)aClass.addAfter((PsiElement)header, (PsiElement)aClass.getTypeParameterList());
            }
            RecordHeaderProcessor processor = new RecordHeaderProcessor(changeInfo, factory, header);
            processor.run();
            if (method instanceof SyntheticElement) {
                method = Objects.requireNonNull(JavaPsiRecordUtil.findCanonicalConstructor((PsiClass)aClass));
            }
        }
        JavaChangeSignatureUsageProcessor.fixJavadocsForChangedMethod(method, changeInfo, newParamsLength);
        if (changeInfo.isExceptionSetOrOrderChanged()) {
            PsiClassType[] newExceptions = JavaChangeSignatureUsageProcessor.getPrimaryChangedExceptionInfo(changeInfo);
            JavaChangeSignatureUsageProcessor.fixPrimaryThrowsLists(method, newExceptions);
        }
        JavaChangeSignatureUsageProcessor.tryUpdateContracts(method, changeInfo);
        if (baseMethod == null && method.findSuperMethods().length == 0 && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (boolean)true, (String[])new String[]{Override.class.getName()})) != null) {
            annotation.delete();
        }
    }

    private static void applyNullability(@NotNull PsiTypeElement typeElement, @NotNull PsiType origType) {
        PsiElement parent;
        if (typeElement == null) {
            JavaChangeSignatureUsageProcessor.$$$reportNull$$$0(2);
        }
        if (origType == null) {
            JavaChangeSignatureUsageProcessor.$$$reportNull$$$0(3);
        }
        TypeNullability typeNullability = typeElement.getType().getNullability();
        Nullability nullability = typeNullability.nullability();
        if (typeNullability.equals((Object)TypeNullability.UNKNOWN) && (parent = typeElement.getParent()) instanceof PsiModifierListOwner) {
            PsiModifierListOwner owner = (PsiModifierListOwner)parent;
            nullability = NullableNotNullManager.getNullability((PsiModifierListOwner)owner);
        }
        if (nullability != origType.getNullability().nullability()) {
            String annotation = NullableNotNullManager.getInstance((Project)typeElement.getProject()).getDefaultAnnotation(origType.getNullability().nullability(), (PsiElement)typeElement);
            typeElement.addAnnotation(annotation);
        }
    }

    private static void ensureNullabilityAnnotationsDoNotRepeat(@NotNull PsiTypeElement element, PsiType newType) {
        PsiElement parent;
        if (element == null) {
            JavaChangeSignatureUsageProcessor.$$$reportNull$$$0(4);
        }
        if ((parent = element.getParent()) instanceof PsiModifierListOwner) {
            PsiModifierListOwner owner = (PsiModifierListOwner)parent;
            if (newType != null && ContainerUtil.exists((Object[])newType.getAnnotations(), annotation -> NullableNotNullManager.isNullabilityAnnotation((PsiAnnotation)annotation))) {
                Arrays.stream(owner.getAnnotations()).filter(NullableNotNullManager::isNullabilityAnnotation).forEach(PsiElement::delete);
            }
        }
    }

    private static PsiClassType[] getPrimaryChangedExceptionInfo(JavaChangeInfo changeInfo) {
        ThrownExceptionInfo[] newExceptionInfos = changeInfo.getNewExceptions();
        PsiClassType[] newExceptions = new PsiClassType[newExceptionInfos.length];
        PsiMethod method = changeInfo.getMethod();
        for (int i = 0; i < newExceptions.length; ++i) {
            newExceptions[i] = (PsiClassType)newExceptionInfos[i].createType((PsiElement)method, method.getManager());
        }
        return newExceptions;
    }

    private static void processCallerMethod(JavaChangeInfo changeInfo, PsiMethod caller, PsiMethod baseMethod, boolean toInsertParams, boolean toInsertThrows) {
        LOG.assertTrue(toInsertParams || toInsertThrows);
        if (toInsertParams) {
            ArrayList<PsiParameter> newParameters2 = new ArrayList<PsiParameter>();
            ContainerUtil.addAll(newParameters2, (Object[])caller.getParameterList().getParameters());
            JavaParameterInfo[] primaryNewParameters = changeInfo.getNewParameters();
            PsiSubstitutor substitutor = baseMethod == null ? PsiSubstitutor.EMPTY : ChangeSignatureProcessor.calculateSubstitutor(caller, baseMethod);
            PsiClass aClass = changeInfo.getMethod().getContainingClass();
            PsiClass callerContainingClass = caller.getContainingClass();
            PsiSubstitutor psiSubstitutor = aClass != null && callerContainingClass != null && callerContainingClass.isInheritor(aClass, true) ? TypeConversionUtil.getSuperClassSubstitutor((PsiClass)aClass, (PsiClass)callerContainingClass, (PsiSubstitutor)substitutor) : PsiSubstitutor.EMPTY;
            for (JavaParameterInfo info : primaryNewParameters) {
                if (info.getOldIndex() >= 0) continue;
                newParameters2.add(JavaChangeSignatureUsageProcessor.createNewParameter(changeInfo, info, psiSubstitutor, substitutor));
            }
            boolean[] toRemoveParameters = new boolean[newParameters2.size()];
            Arrays.fill(toRemoveParameters, false);
            List newParameterNames = ContainerUtil.map(newParameters2, parameter -> parameter.getName());
            JavaChangeSignatureUsageProcessor.resolveVariableVsFieldsConflicts(newParameters2, newParameterNames, caller.getParameterList(), toRemoveParameters, (PsiElement)caller.getBody(), ParameterList.INSTANCE);
        }
        if (toInsertThrows) {
            PsiClass primaryNewExns;
            ArrayList<PsiJavaCodeReferenceElement> newThrows = new ArrayList<PsiJavaCodeReferenceElement>();
            PsiReferenceList throwsList = caller.getThrowsList();
            ContainerUtil.addAll(newThrows, (Object[])throwsList.getReferenceElements());
            for (PsiClass thrownExceptionInfo : primaryNewExns = changeInfo.getNewExceptions()) {
                if (thrownExceptionInfo.getOldIndex() >= 0) continue;
                PsiClassType type = (PsiClassType)thrownExceptionInfo.createType((PsiElement)caller, caller.getManager());
                PsiJavaCodeReferenceElement ref = JavaPsiFacade.getElementFactory((Project)caller.getProject()).createReferenceElementByType(type);
                newThrows.add(ref);
            }
            PsiJavaCodeReferenceElement[] arrayed = newThrows.toArray(PsiJavaCodeReferenceElement.EMPTY_ARRAY);
            boolean[] toRemoveParameters = new boolean[arrayed.length];
            Arrays.fill(toRemoveParameters, false);
            ChangeSignatureUtil.synchronizeList(throwsList, Arrays.asList(arrayed), ThrowsList.INSTANCE, toRemoveParameters);
        }
    }

    private static void fixPrimaryThrowsLists(PsiMethod method, PsiClassType[] newExceptions) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)method.getProject());
        PsiJavaCodeReferenceElement[] refs = new PsiJavaCodeReferenceElement[newExceptions.length];
        for (int i = 0; i < refs.length; ++i) {
            refs[i] = elementFactory.createReferenceElementByType(newExceptions[i]);
        }
        PsiReferenceList throwsList = elementFactory.createReferenceList(refs);
        PsiReferenceList methodThrowsList = (PsiReferenceList)method.getThrowsList().replace((PsiElement)throwsList);
        methodThrowsList = (PsiReferenceList)JavaCodeStyleManager.getInstance((Project)method.getProject()).shortenClassReferences((PsiElement)methodThrowsList);
        CodeStyleManager.getInstance((Project)method.getManager().getProject()).reformatRange((PsiElement)method, method.getParameterList().getTextRange().getEndOffset(), methodThrowsList.getTextRange().getEndOffset());
    }

    private static void fixJavadocsForChangedMethod(PsiMethod method, JavaChangeInfo changeInfo, int newParamsLength) {
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return;
        }
        PsiDocComment methodDocComment = method.getDocComment();
        PsiDocComment classDocComment = aClass.getDocComment();
        if (changeInfo.isParameterSetOrOrderChanged() || changeInfo.isParameterNamesChanged()) {
            JavaParameterInfo[] newParms = changeInfo.getNewParameters();
            LOG.assertTrue(parameters.length <= newParamsLength);
            HashSet<PsiParameter> newParameters2 = new HashSet<PsiParameter>();
            String[] oldParameterNames = changeInfo.getOldParameterNames();
            for (int i = 0; i < newParamsLength; ++i) {
                JavaParameterInfo newParm = newParms[i];
                if (newParm.getOldIndex() >= 0 && (newParm.getOldIndex() != i || newParm.getName().equals(oldParameterNames[newParm.getOldIndex()]) && newParm.getTypeText().equals(changeInfo.getOldParameterTypes()[newParm.getOldIndex()]))) continue;
                newParameters2.add(parameters[i]);
            }
            Condition eqCondition = pair -> {
                PsiParameter parameter = (PsiParameter)pair.first;
                String oldParamName = (String)pair.second;
                int oldIdx = ArrayUtil.find((Object[])oldParameterNames, (Object)oldParamName);
                int newIndex = method.getParameterList().getParameterIndex(parameter);
                return oldIdx >= 0 && newIndex >= 0 && changeInfo.getNewParameters()[newIndex].getOldIndex() == oldIdx;
            };
            Condition matchedToOldParam = paramName -> ArrayUtil.find((Object[])oldParameterNames, (Object)paramName) >= 0;
            if (!(method instanceof SyntheticElement) && methodDocComment != null && methodDocComment.findTagByName("param") != null) {
                CommonJavaRefactoringUtil.fixJavadocsForParams((PsiMethod)method, (PsiDocComment)methodDocComment, newParameters2, (Condition)eqCondition, (Condition)matchedToOldParam);
            }
            if (JavaPsiRecordUtil.isCanonicalConstructor((PsiMethod)method) && classDocComment != null && classDocComment.findTagByName("param") != null) {
                CommonJavaRefactoringUtil.fixJavadocsForParams((PsiMethod)method, (PsiDocComment)classDocComment, newParameters2, (Condition)eqCondition, (Condition)matchedToOldParam);
            }
        }
        if (changeInfo.isReturnTypeChanged() && methodDocComment != null) {
            CanonicalTypes.Type type = changeInfo.getNewReturnType();
            PsiDocTag aReturn = methodDocComment.findTagByName("return");
            PsiDocComment oldMethodDocComment = (PsiDocComment)methodDocComment.copy();
            if (PsiTypes.voidType().equalsToText(type.getTypeText())) {
                if (aReturn != null) {
                    aReturn.delete();
                }
            } else {
                String oldReturnType = changeInfo.getOldReturnType();
                if (aReturn == null && oldReturnType != null && PsiTypes.voidType().equalsToText(oldReturnType)) {
                    methodDocComment.add((PsiElement)JavaPsiFacade.getElementFactory((Project)method.getProject()).createDocTagFromText("@return"));
                }
            }
            CommonJavaRefactoringUtil.formatJavadocIgnoringSettings((PsiMethod)method, (PsiDocComment)methodDocComment, (PsiDocComment)oldMethodDocComment);
        }
    }

    private static PsiParameter createNewParameter(JavaChangeInfo changeInfo, JavaParameterInfo newParameters2, PsiSubstitutor ... substitutor) {
        PsiMethod method = changeInfo.getMethod();
        PsiParameterList list = method.getParameterList();
        Project project = list.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiType type = newParameters2.createType((PsiElement)list);
        for (PsiSubstitutor psiSubstitutor : substitutor) {
            type = psiSubstitutor.substitute(type);
        }
        PsiParameter parameter = factory.createParameter(newParameters2.getName(), type, (PsiElement)list);
        if (JavaCodeStyleSettings.getInstance((PsiFile)((PsiElement)ObjectUtils.notNull((Object)method.getContext(), (Object)method)).getContainingFile()).GENERATE_FINAL_PARAMETERS) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)parameter, (String)"final", (boolean)true);
        }
        return parameter;
    }

    private static <Parent extends PsiElement, Child extends PsiElement> void resolveVariableVsFieldsConflicts(List<Child> newElements, List<String> newElementNames, Parent parent, boolean[] toRemoveParameters, PsiElement methodBody, ChangeSignatureUtil.ChildrenGenerator<Parent, Child> generator) {
        PsiUtilCore.ensureValid(parent);
        ArrayList<FieldConflictsResolver> conflictResolvers = new ArrayList<FieldConflictsResolver>();
        for (String newElementName : ContainerUtil.skipNulls(newElementNames)) {
            conflictResolvers.add(new FieldConflictsResolver(newElementName, methodBody));
        }
        ChangeSignatureUtil.synchronizeList(parent, newElements, generator, toRemoveParameters);
        LOG.assertTrue(parent.getContainingFile() != null, (Object)("No containing file for: " + String.valueOf(parent.getClass())));
        JavaCodeStyleManager.getInstance((Project)parent.getProject()).shortenClassReferences(parent);
        for (FieldConflictsResolver fieldConflictsResolver : conflictResolvers) {
            fieldConflictsResolver.fix();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean needToCatchExceptions(JavaChangeInfo changeInfo, PsiMethod caller) {
        if (!changeInfo.isExceptionSetOrOrderChanged()) return false;
        if (!(changeInfo instanceof JavaChangeInfoImpl)) return true;
        JavaChangeInfoImpl info = (JavaChangeInfoImpl)changeInfo;
        if (info.propagateExceptionsMethods.contains(caller)) return false;
        return true;
    }

    private static void tryUpdateContracts(PsiMethod method, JavaChangeInfo info) {
        PsiAnnotation annotation = JavaMethodContractUtil.findContractAnnotation((PsiMethod)method);
        if (annotation == null) {
            return;
        }
        try {
            PsiAnnotation newAnnotation = ContractConverter.convertContract((PsiMethod)method, (JavaChangeInfo)info);
            if (newAnnotation != null && !newAnnotation.isPhysical()) {
                annotation.replace((PsiElement)newAnnotation);
            }
        }
        catch (ContractConverter.ContractConversionException contractConversionException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveSnapshotProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureUsageProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "callerSignatureIsAboutToChangeToo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerConflictResolvers";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "applyNullability";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureNullabilityAnnotationsDoNotRepeat";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class ConflictSearcher {
        private final JavaChangeInfo myChangeInfo;

        private ConflictSearcher(@NotNull JavaChangeInfo changeInfo) {
            if (changeInfo == null) {
                ConflictSearcher.$$$reportNull$$$0(0);
            }
            this.myChangeInfo = changeInfo;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private MultiMap<PsiElement, @NlsContexts.DialogMessage String> findConflicts(Ref<UsageInfo[]> refUsages) {
            @NlsContexts.DialogMessage MultiMap conflictDescriptions = new MultiMap();
            PsiMethod prototype = this.addMethodConflicts((MultiMap<PsiElement, String>)conflictDescriptions);
            HashSet usagesSet = ContainerUtil.newHashSet((Object[])((UsageInfo[])refUsages.get()));
            RenameUtil.removeConflictUsages((Set)usagesSet);
            if (this.myChangeInfo.isVisibilityChanged()) {
                try {
                    this.addInaccessibilityDescriptions(usagesSet, (MultiMap<PsiElement, String>)conflictDescriptions);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            boolean[] toRemove = this.myChangeInfo.toRemoveParm();
            boolean checkUnusedParameter = this.myChangeInfo.checkUnusedParameter();
            if (checkUnusedParameter) {
                ConflictSearcher.checkParametersToDelete(this.myChangeInfo.getMethod(), toRemove, (MultiMap<PsiElement, String>)conflictDescriptions);
            }
            this.checkContract((MultiMap<PsiElement, String>)conflictDescriptions, this.myChangeInfo.getMethod(), false);
            for (UsageInfo usageInfo : usagesSet) {
                PsiCallExpression call;
                PsiExpressionList argumentList;
                PsiElement parent;
                PsiElement element = usageInfo.getElement();
                if (usageInfo instanceof OverriderUsageInfo) {
                    OverriderUsageInfo info = (OverriderUsageInfo)usageInfo;
                    PsiMethod method = info.getOverridingMethod();
                    PsiMethod baseMethod = info.getBaseMethod();
                    int delta = baseMethod.getParameterList().getParametersCount() - method.getParameterList().getParametersCount();
                    if (delta > 0) {
                        if (toRemove.length > 0 && toRemove[toRemove.length - 1]) {
                            conflictDescriptions.putValue((Object)baseMethod, (Object)JavaRefactoringBundle.message((String)"implicit.last.parameter.warning", (Object[])new Object[0]));
                        }
                    } else if (prototype != null && baseMethod == this.myChangeInfo.getMethod()) {
                        ConflictsUtil.checkMethodConflicts(method.getContainingClass(), method, prototype, (MultiMap<PsiElement, String>)conflictDescriptions);
                        if (checkUnusedParameter) {
                            ConflictSearcher.checkParametersToDelete(method, toRemove, (MultiMap<PsiElement, String>)conflictDescriptions);
                        }
                    }
                    this.checkContract((MultiMap<PsiElement, String>)conflictDescriptions, method, true);
                    continue;
                }
                if (element instanceof PsiMethodReferenceExpression && MethodReferenceUsageInfo.needToExpand(this.myChangeInfo)) {
                    conflictDescriptions.putValue((Object)element, (Object)JavaRefactoringBundle.message((String)"expand.method.reference.warning", (Object[])new Object[0]));
                    continue;
                }
                if (!(element instanceof PsiJavaCodeReferenceElement) || !((parent = element.getParent()) instanceof PsiCallExpression) || (argumentList = (call = (PsiCallExpression)parent).getArgumentList()) == null) continue;
                PsiExpression[] args = argumentList.getExpressions();
                for (int i = 0; i < toRemove.length; ++i) {
                    PsiParameter parameter;
                    if (!toRemove[i] || i >= args.length || !RemoveUnusedVariableUtil.checkSideEffects((PsiExpression)args[i], null, new ArrayList()) || (parameter = this.myChangeInfo.getMethod().getParameterList().getParameter(i)) == null) continue;
                    String message = JavaRefactoringBundle.message((String)"safe.delete.parameter.usage.warning", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)parameter, (boolean)true)});
                    conflictDescriptions.putValue((Object)args[i], (Object)StringUtil.capitalize((String)message));
                }
            }
            return conflictDescriptions;
        }

        public static void checkParametersToDelete(PsiMethod method, boolean[] toRemove, MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflictDescriptions) {
            ConflictSearcher.checkRecordComponentsToDelete(method, toRemove, conflictDescriptions);
            if (method instanceof SyntheticElement) {
                return;
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            PsiCodeBlock body = method.getBody();
            if (body != null) {
                LocalSearchScope searchScope = new LocalSearchScope((PsiElement)body);
                PsiMethodCallExpression superCall = ConflictSearcher.getSuperCall(method, body);
                block0: for (int i = 0; i < toRemove.length; ++i) {
                    if (!toRemove[i]) continue;
                    for (PsiReference ref : ReferencesSearch.search((PsiElement)parameters[i], (SearchScope)searchScope).asIterable()) {
                        if (superCall != null && ConflictSearcher.passUnchangedParameterToSuperCall(superCall, i, ref)) continue;
                        String paramName = StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)parameters[i], (boolean)true));
                        String message = JavaRefactoringBundle.message((String)"parameter.used.in.method.body.warning", (Object[])new Object[]{paramName});
                        conflictDescriptions.putValue((Object)parameters[i], (Object)message);
                        continue block0;
                    }
                }
            }
        }

        private static void checkRecordComponentsToDelete(@NotNull PsiMethod method, boolean[] toRemove, @NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflictDescriptions) {
            PsiClass aClass;
            if (method == null) {
                ConflictSearcher.$$$reportNull$$$0(1);
            }
            if (conflictDescriptions == null) {
                ConflictSearcher.$$$reportNull$$$0(2);
            }
            if ((aClass = method.getContainingClass()) == null || !aClass.isRecord()) {
                return;
            }
            if (!JavaPsiRecordUtil.isCanonicalConstructor((PsiMethod)method)) {
                return;
            }
            PsiRecordComponent @NotNull [] components = aClass.getRecordComponents();
            for (int i = 0; i < toRemove.length; ++i) {
                PsiMethod explicitGetter;
                Object reference2;
                if (!toRemove[i]) continue;
                if (components.length <= i) break;
                PsiRecordComponent component = components[i];
                String message = JavaRefactoringBundle.message((String)"record.component.used.in.method.body.warning", (Object[])new Object[]{component.getName()});
                PsiField field = JavaPsiRecordUtil.getFieldForComponent((PsiRecordComponent)component);
                if (field != null) {
                    for (Object reference2 : VariableAccessUtils.getVariableReferences((PsiVariable)field, (PsiElement)aClass.getContainingFile())) {
                        conflictDescriptions.putValue(reference2, (Object)message);
                    }
                }
                if ((explicitGetter = JavaPsiRecordUtil.getAccessorForRecordComponent((PsiRecordComponent)component)) == null) continue;
                reference2 = ReferencesSearch.search((PsiElement)explicitGetter, (SearchScope)explicitGetter.getUseScope(), (boolean)false).asIterable().iterator();
                while (reference2.hasNext()) {
                    PsiReference psiReference = (PsiReference)reference2.next();
                    PsiElement paramRef = psiReference.getElement();
                    conflictDescriptions.putValue((Object)paramRef, (Object)message);
                }
            }
            block3: for (PsiReference classReference : ReferencesSearch.search((PsiElement)aClass, (SearchScope)aClass.getUseScope()).asIterable()) {
                PsiDeconstructionPattern deconstructionPattern;
                PsiPattern[] deconstructionComponents;
                PsiElement grandParent;
                PsiElement element = classReference.getElement();
                PsiElement parent = element.getParent();
                if (!(parent instanceof PsiTypeElement) || !((grandParent = parent.getParent()) instanceof PsiDeconstructionPattern) || (deconstructionComponents = (deconstructionPattern = (PsiDeconstructionPattern)grandParent).getDeconstructionList().getDeconstructionComponents()).length != components.length) continue;
                for (int i = 0; i < toRemove.length; ++i) {
                    if (!toRemove[i]) continue;
                    if (components.length <= i) continue block3;
                    PsiPattern deconstructionComponent = deconstructionComponents[i];
                    PsiRecordComponent recordComponent = components[i];
                    ConflictSearcher.collectDeconstructionRecordToDeleteUsagesConflict(deconstructionComponent, aClass, conflictDescriptions, recordComponent);
                }
            }
        }

        private static void collectDeconstructionRecordToDeleteUsagesConflict(@Nullable PsiPattern pattern, @NotNull PsiClass context, @NotNull MultiMap<PsiElement, String> conflictDescriptions, @NotNull PsiRecordComponent recordComponent) {
            if (context == null) {
                ConflictSearcher.$$$reportNull$$$0(3);
            }
            if (conflictDescriptions == null) {
                ConflictSearcher.$$$reportNull$$$0(4);
            }
            if (recordComponent == null) {
                ConflictSearcher.$$$reportNull$$$0(5);
            }
            if (pattern == null) {
                return;
            }
            String message = JavaRefactoringBundle.message((String)"record.component.used.in.method.body.warning", (Object[])new Object[]{recordComponent.getName()});
            if (!JavaPsiPatternUtil.isUnconditionalForType((PsiCaseLabelElement)pattern, (PsiType)recordComponent.getType(), (boolean)true)) {
                conflictDescriptions.putValue((Object)pattern, (Object)message);
                return;
            }
            if (pattern instanceof PsiTypeTestPattern) {
                PsiTypeTestPattern typeTestPattern = (PsiTypeTestPattern)pattern;
                PsiPatternVariable variable = typeTestPattern.getPatternVariable();
                if (variable == null || variable.isUnnamed()) {
                    return;
                }
                if (VariableAccessUtils.variableIsUsed((PsiVariable)variable, (PsiElement)context.getContainingFile())) {
                    conflictDescriptions.putValue((Object)typeTestPattern, (Object)message);
                    return;
                }
            }
            if (pattern instanceof PsiDeconstructionPattern) {
                PsiDeconstructionPattern deconstructionPattern = (PsiDeconstructionPattern)pattern;
                PsiType psiType = deconstructionPattern.getTypeElement().getType();
                PsiClass nestedRecord = PsiUtil.resolveClassInClassTypeOnly((PsiType)psiType);
                if (nestedRecord == null || !nestedRecord.isRecord()) {
                    return;
                }
                PsiDeconstructionList deconstructionList = deconstructionPattern.getDeconstructionList();
                PsiPattern[] components = deconstructionList.getDeconstructionComponents();
                if (components.length != nestedRecord.getRecordComponents().length) {
                    return;
                }
                for (int i = 0; i < components.length; ++i) {
                    PsiPattern nestedDeconstructionPattern = components[i];
                    PsiRecordComponent nestedComponent = nestedRecord.getRecordComponents()[i];
                    ConflictSearcher.collectDeconstructionRecordToDeleteUsagesConflict(nestedDeconstructionPattern, context, conflictDescriptions, nestedComponent);
                }
            }
        }

        private static boolean passUnchangedParameterToSuperCall(PsiMethodCallExpression superCall, int i, PsiReference ref) {
            return ArrayUtil.find((Object[])superCall.getArgumentList().getExpressions(), (Object)PsiUtil.skipParenthesizedExprUp((PsiElement)ref.getElement())) == i;
        }

        private static PsiMethodCallExpression getSuperCall(PsiMethod method, PsiCodeBlock body) {
            PsiMethodCallExpression call;
            PsiExpressionStatement statement;
            PsiStatement[] statements = body.getStatements();
            if (statements.length == 0) {
                return null;
            }
            PsiStatement psiStatement = statements[0];
            if (psiStatement instanceof PsiExpressionStatement && (psiStatement = (statement = (PsiExpressionStatement)psiStatement).getExpression()) instanceof PsiMethodCallExpression && MethodCallUtils.isSuperMethodCall((PsiMethodCallExpression)(call = (PsiMethodCallExpression)psiStatement), (PsiMethod)method)) {
                return call;
            }
            return null;
        }

        private void checkContract(MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflictDescriptions, PsiMethod method, boolean override) {
            try {
                ContractConverter.convertContract((PsiMethod)method, (JavaChangeInfo)this.myChangeInfo);
            }
            catch (ContractConverter.ContractInheritedException e) {
                if (!override) {
                    String message = JavaRefactoringBundle.message((String)"changeSignature.contract.converter.can.not.update.annotation", (Object[])new Object[]{e.getMessage()});
                    conflictDescriptions.putValue((Object)method, (Object)message);
                }
            }
            catch (ContractConverter.ContractConversionException e) {
                String message = JavaRefactoringBundle.message((String)"changeSignature.contract.converter.can.not.update.annotation", (Object[])new Object[]{e.getMessage()});
                conflictDescriptions.putValue((Object)method, (Object)message);
            }
        }

        private boolean needToChangeCalls() {
            return this.myChangeInfo.isNameChanged() || this.myChangeInfo.isParameterSetOrOrderChanged() || this.myChangeInfo.isExceptionSetOrOrderChanged();
        }

        private void addInaccessibilityDescriptions(Set<UsageInfo> usages, MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflictDescriptions) {
            JavaChangeInfoImpl info;
            PsiMethod method = this.myChangeInfo.getMethod();
            PsiModifierList modifierList = (PsiModifierList)method.getModifierList().copy();
            String visibility = this.myChangeInfo.getNewVisibility();
            VisibilityUtil.setVisibility((PsiModifierList)modifierList, (String)visibility);
            ConflictSearcher.searchForHierarchyConflicts(method, conflictDescriptions, visibility);
            JavaChangeInfo javaChangeInfo = this.myChangeInfo;
            boolean propagateVisibility = javaChangeInfo instanceof JavaChangeInfoImpl && (info = (JavaChangeInfoImpl)javaChangeInfo).isPropagateVisibility();
            Iterator<UsageInfo> iterator = usages.iterator();
            while (iterator.hasNext()) {
                UsageInfo usageInfo = iterator.next();
                PsiElement element = usageInfo.getElement();
                PsiReference reference = usageInfo.getReference();
                if (!propagateVisibility && reference != null && !method.equals((Object)reference.resolve()) || element == null || !(element instanceof PsiQualifiedReference)) continue;
                PsiQualifiedReference ref = (PsiQualifiedReference)element;
                PsiClass accessObjectClass = null;
                PsiElement psiElement = ref.getQualifier();
                if (psiElement instanceof PsiExpression) {
                    PsiExpression expression = (PsiExpression)psiElement;
                    accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)expression).getElement();
                }
                if (JavaPsiFacade.getInstance((Project)element.getProject()).getResolveHelper().isAccessible((PsiMember)method, modifierList, element, accessObjectClass, null)) continue;
                String message = RefactoringBundle.message((String)"0.with.1.visibility.is.not.accessible.from.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)method, (boolean)true), VisibilityUtil.toPresentableText((String)visibility), RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer(element), (boolean)true)});
                conflictDescriptions.putValue((Object)method, (Object)message);
                if (this.needToChangeCalls()) continue;
                iterator.remove();
            }
        }

        public static void searchForHierarchyConflicts(final PsiMethod method, final MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts, final @PsiModifier.ModifierConstant String modifier) {
            SuperMethodsSearch.search((PsiMethod)method, (PsiClass)((PsiClass)ReadAction.compute(() -> ((PsiMethod)method).getContainingClass())), (boolean)true, (boolean)false).forEach((com.intellij.util.Processor)new ReadActionProcessor<MethodSignatureBackedByPsiMethod>(){

                public boolean processInReadAction(MethodSignatureBackedByPsiMethod methodSignature) {
                    PsiMethod superMethod = methodSignature.getMethod();
                    if (!ConflictSearcher.hasCompatibleVisibility(superMethod, true, modifier)) {
                        String message = IntentionPowerPackBundle.message((String)"0.will.have.incompatible.access.privileges.with.super.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)method, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)superMethod, (boolean)true)});
                        conflicts.putValue((Object)superMethod, (Object)message);
                    }
                    return true;
                }
            });
            OverridingMethodsSearch.search((PsiMethod)method).forEach((com.intellij.util.Processor)new ReadActionProcessor<PsiMethod>(){

                public boolean processInReadAction(PsiMethod overridingMethod) {
                    if (!ConflictSearcher.isVisibleFromOverridingMethod(method, overridingMethod, modifier)) {
                        String message = IntentionPowerPackBundle.message((String)"0.will.no.longer.be.visible.from.overriding.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)method, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)overridingMethod, (boolean)true)});
                        conflicts.putValue((Object)overridingMethod, (Object)message);
                    } else if (!ConflictSearcher.hasCompatibleVisibility(overridingMethod, false, modifier)) {
                        conflicts.putValue((Object)overridingMethod, (Object)IntentionPowerPackBundle.message((String)"0.will.have.incompatible.access.privileges.with.overriding.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)method, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)overridingMethod, (boolean)true)}));
                    }
                    return true;
                }
            });
        }

        private static boolean hasCompatibleVisibility(PsiMethod method, boolean isSuper, String modifier) {
            return switch (modifier) {
                case "private" -> false;
                case "packageLocal" -> {
                    if (!isSuper || !method.hasModifierProperty("public") && !method.hasModifierProperty("protected")) {
                        yield true;
                    }
                    yield false;
                }
                case "protected" -> {
                    if (isSuper) {
                        if (!method.hasModifierProperty("public")) {
                            yield true;
                        }
                        yield false;
                    }
                    if (method.hasModifierProperty("protected") || method.hasModifierProperty("public")) {
                        yield true;
                    }
                    yield false;
                }
                case "public" -> {
                    if (isSuper || method.hasModifierProperty("public")) {
                        yield true;
                    }
                    yield false;
                }
                default -> throw new IllegalStateException("Unexpected value: " + modifier);
            };
        }

        private static boolean isVisibleFromOverridingMethod(PsiMethod method, PsiMethod overridingMethod, @PsiModifier.ModifierConstant String modifier) {
            PsiModifierList modifierListCopy = (PsiModifierList)method.getModifierList().copy();
            modifierListCopy.setModifierProperty(modifier, true);
            return JavaResolveUtil.isAccessible((PsiMember)method, (PsiClass)method.getContainingClass(), (PsiModifierList)modifierListCopy, (PsiElement)overridingMethod, null, null);
        }

        private PsiMethod addMethodConflicts(MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
            String newMethodName = this.myChangeInfo.getNewName();
            try {
                JavaParameterInfo[] parameters;
                PsiMethod prototype;
                PsiMethod method = this.myChangeInfo.getMethod();
                if (!JavaLanguage.INSTANCE.equals(method.getLanguage())) {
                    return null;
                }
                PsiManager manager = method.getManager();
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
                CanonicalTypes.Type returnType = this.myChangeInfo.getNewReturnType();
                if (returnType != null) {
                    prototype = factory.createMethod(newMethodName, returnType.getType((PsiElement)method, manager));
                } else {
                    prototype = factory.createConstructor();
                    prototype.setName(newMethodName);
                }
                for (JavaParameterInfo info : parameters = this.myChangeInfo.getNewParameters()) {
                    PsiType parameterType = info.createType((PsiElement)method, manager);
                    if (parameterType == null) {
                        parameterType = JavaPsiFacade.getElementFactory((Project)method.getProject()).createTypeFromText("java.lang.Object", (PsiElement)method);
                    }
                    PsiParameter param = factory.createParameter(info.getName(), parameterType, (PsiElement)method);
                    if (JavaCodeStyleSettings.getInstance((PsiFile)method.getContainingFile()).GENERATE_FINAL_PARAMETERS) {
                        PsiUtil.setModifierProperty((PsiModifierListOwner)param, (String)"final", (boolean)true);
                    }
                    prototype.getParameterList().add((PsiElement)param);
                }
                ConflictsUtil.checkMethodConflicts(method.getContainingClass(), this.myChangeInfo.isGenerateDelegate() ? null : method, prototype, conflicts);
                return prototype;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conflictDescriptions";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recordComponent";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureUsageProcessor$ConflictSearcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkRecordComponentsToDelete";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectDeconstructionRecordToDeleteUsagesConflict";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class DeconstructionProcessor
    extends Processor<PsiDeconstructionList, PatternWrapper> {
        DeconstructionProcessor(@NotNull JavaChangeInfo changeInfo, @NotNull PsiElementFactory factory, @NotNull PsiDeconstructionList list) {
            if (changeInfo == null) {
                DeconstructionProcessor.$$$reportNull$$$0(0);
            }
            if (factory == null) {
                DeconstructionProcessor.$$$reportNull$$$0(1);
            }
            if (list == null) {
                DeconstructionProcessor.$$$reportNull$$$0(2);
            }
            super(changeInfo, factory, list);
        }

        @Override
        void processNew(JavaParameterInfo info, List<PatternWrapper> result) {
            PsiType newType = info.createType(this.myParent);
            if (newType != null) {
                String patternText = newType.getCanonicalText() + " " + info.getName();
                PsiExpression expression = this.myFactory.createExpressionFromText("x instanceof " + patternText, null);
                if (!(expression instanceof PsiInstanceOfExpression)) {
                    throw new IncorrectOperationException(patternText + " is not a valid pattern");
                }
                PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression;
                PsiPrimaryPattern pattern = instanceOfExpression.getPattern();
                result.add(new PatternWrapper((PsiPattern)Objects.requireNonNull(pattern)));
            }
        }

        @Override
        PatternWrapper getChild(int index) {
            return new PatternWrapper(((PsiDeconstructionList)this.myParent).getDeconstructionComponents()[index]);
        }

        @Override
        protected void process(@NotNull List<PatternWrapper> elements) {
            if (elements == null) {
                DeconstructionProcessor.$$$reportNull$$$0(3);
            }
            List newPatterns = ContainerUtil.map(elements, element -> element.pattern());
            List newElementNames = ContainerUtil.map(elements, PatternWrapper::getName);
            JavaChangeSignatureUsageProcessor.resolveVariableVsFieldsConflicts(newPatterns, newElementNames, (PsiDeconstructionList)this.myParent, this.myChangeInfo.toRemoveParm(), PsiTreeUtil.getParentOfType((PsiElement)this.myParent, PsiStatement.class), DeconstructionList.INSTANCE);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureUsageProcessor$DeconstructionProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class MethodParamsProcessor
    extends Processor<PsiParameterList, VariableWrapper> {
        @Nullable
        private final PsiElement myMethodBody;
        @NotNull
        private final PsiSubstitutor mySubstitutor;
        @Nullable
        private final PsiMethod myBaseMethod;

        MethodParamsProcessor(@NotNull JavaChangeInfo changeInfo, @Nullable PsiMethod baseMethod, @NotNull PsiElementFactory factory, @NotNull PsiSubstitutor substitutor, @NotNull PsiParameterList list, @Nullable PsiElement methodBody) {
            if (changeInfo == null) {
                MethodParamsProcessor.$$$reportNull$$$0(0);
            }
            if (factory == null) {
                MethodParamsProcessor.$$$reportNull$$$0(1);
            }
            if (substitutor == null) {
                MethodParamsProcessor.$$$reportNull$$$0(2);
            }
            if (list == null) {
                MethodParamsProcessor.$$$reportNull$$$0(3);
            }
            super(changeInfo, factory, list);
            this.myMethodBody = methodBody;
            this.mySubstitutor = substitutor;
            this.myBaseMethod = baseMethod;
        }

        @Override
        void processNew(JavaParameterInfo info, List<VariableWrapper> result) {
            PsiLambdaExpression lambda;
            PsiElement parent = ((PsiParameterList)this.myParent).getParent();
            if (parent instanceof PsiLambdaExpression && !(lambda = (PsiLambdaExpression)parent).hasFormalParameterTypes()) {
                PsiExpression dummyLambdaParam = this.myFactory.createExpressionFromText(info.getName() + "-> {}", this.myParent);
                result.add(new VariableWrapper((PsiVariable)((PsiLambdaExpression)dummyLambdaParam).getParameterList().getParameters()[0]));
            } else {
                result.add(new VariableWrapper((PsiVariable)JavaChangeSignatureUsageProcessor.createNewParameter(this.myChangeInfo, info, this.mySubstitutor)));
            }
        }

        @Override
        VariableWrapper getChild(int index) {
            return new VariableWrapper((PsiVariable)Objects.requireNonNull(((PsiParameterList)this.myParent).getParameter(index)));
        }

        @Override
        int getNewParametersCount() {
            return MethodParamsProcessor.getNewParametersCount(this.myChangeInfo, this.myBaseMethod, (PsiParameterList)this.myParent);
        }

        private static int getNewParametersCount(JavaChangeInfo changeInfo, PsiMethod baseMethod, PsiParameterList list) {
            int delta = baseMethod != null ? baseMethod.getParameterList().getParametersCount() - list.getParametersCount() : 0;
            return Math.max(changeInfo.getNewParameters().length - delta, 0);
        }

        @Override
        @NotNull
        protected PsiSubstitutor getSubstitutor() {
            PsiSubstitutor psiSubstitutor = this.mySubstitutor;
            if (psiSubstitutor == null) {
                MethodParamsProcessor.$$$reportNull$$$0(4);
            }
            return psiSubstitutor;
        }

        @Override
        protected void process(@NotNull List<VariableWrapper> newElements) {
            if (newElements == null) {
                MethodParamsProcessor.$$$reportNull$$$0(5);
            }
            List newParameters2 = ContainerUtil.map(newElements, element -> (PsiParameter)element.variable());
            List newParameterNames = ContainerUtil.map(newElements, VariableWrapper::getName);
            boolean[] toRemove = this.myChangeInfo.toRemoveParm();
            if (this.myChangeInfo.isFixFieldConflicts()) {
                JavaChangeSignatureUsageProcessor.resolveVariableVsFieldsConflicts(newParameters2, newParameterNames, (PsiParameterList)this.myParent, toRemove, this.myMethodBody, ParameterList.INSTANCE);
            } else {
                ChangeSignatureUtil.synchronizeList((PsiParameterList)this.myParent, newParameters2, ParameterList.INSTANCE, toRemove);
                JavaCodeStyleManager.getInstance((Project)((PsiParameterList)this.myParent).getProject()).shortenClassReferences(this.myParent);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substitutor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureUsageProcessor$MethodParamsProcessor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureUsageProcessor$MethodParamsProcessor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubstitutor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class ExpressionList
    implements ChangeSignatureUtil.ChildrenGenerator<PsiExpressionList, PsiExpression> {
        public static final ExpressionList INSTANCE = new ExpressionList();

        private ExpressionList() {
        }

        @Override
        public List<PsiExpression> getChildren(PsiExpressionList psiExpressionList) {
            return Arrays.asList(psiExpressionList.getExpressions());
        }
    }

    static final class RecordHeaderProcessor
    extends Processor<PsiRecordHeader, VariableWrapper> {
        RecordHeaderProcessor(@NotNull JavaChangeInfo changeInfo, @NotNull PsiElementFactory factory, @NotNull PsiRecordHeader header) {
            if (changeInfo == null) {
                RecordHeaderProcessor.$$$reportNull$$$0(0);
            }
            if (factory == null) {
                RecordHeaderProcessor.$$$reportNull$$$0(1);
            }
            if (header == null) {
                RecordHeaderProcessor.$$$reportNull$$$0(2);
            }
            super(changeInfo, factory, header);
        }

        @Override
        void processNew(JavaParameterInfo info, List<VariableWrapper> result) {
            PsiType newType = info.createType(this.myParent);
            if (newType != null) {
                String componentText = newType.getCanonicalText() + " " + info.getName();
                PsiRecordComponent[] dummyComponents = this.myFactory.createRecordHeaderFromText(componentText, this.myParent).getRecordComponents();
                if (dummyComponents.length != 1) {
                    throw new IncorrectOperationException(componentText + " is not a valid component");
                }
                result.add(new VariableWrapper((PsiVariable)dummyComponents[0]));
            }
        }

        @Override
        VariableWrapper getChild(int index) {
            return new VariableWrapper((PsiVariable)((PsiRecordHeader)this.myParent).getRecordComponents()[index]);
        }

        @Override
        protected void process(@NotNull List<VariableWrapper> newElements) {
            if (newElements == null) {
                RecordHeaderProcessor.$$$reportNull$$$0(3);
            }
            List newComponents = ContainerUtil.map(newElements, element -> (PsiRecordComponent)element.variable());
            ChangeSignatureUtil.synchronizeList((PsiRecordHeader)this.myParent, newComponents, RecordHeader.INSTANCE, this.myChangeInfo.toRemoveParm());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changeInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "factory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "header";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElements";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureUsageProcessor$RecordHeaderProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ParameterList
    implements ChangeSignatureUtil.ChildrenGenerator<PsiParameterList, PsiParameter> {
        public static final ParameterList INSTANCE = new ParameterList();

        private ParameterList() {
        }

        @Override
        public List<PsiParameter> getChildren(PsiParameterList psiParameterList) {
            return Arrays.asList(psiParameterList.getParameters());
        }
    }

    private static class ThrowsList
    implements ChangeSignatureUtil.ChildrenGenerator<PsiReferenceList, PsiJavaCodeReferenceElement> {
        public static final ThrowsList INSTANCE = new ThrowsList();

        private ThrowsList() {
        }

        @Override
        public List<PsiJavaCodeReferenceElement> getChildren(PsiReferenceList throwsList) {
            return Arrays.asList(throwsList.getReferenceElements());
        }
    }

    record PatternWrapper(@NotNull PsiPattern pattern) implements ChildWrapper
    {
        @NotNull
        private final PsiPattern pattern;

        PatternWrapper(@NotNull PsiPattern pattern) {
            if (pattern == null) {
                PatternWrapper.$$$reportNull$$$0(0);
            }
        }

        @Override
        @Nullable
        public String getName() {
            PsiPatternVariable variable = JavaPsiPatternUtil.getPatternVariable((PsiCaseLabelElement)this.pattern);
            return variable != null ? variable.getName() : null;
        }

        @Override
        @Nullable
        public PsiElement getNameIdentifier() {
            PsiPatternVariable variable = JavaPsiPatternUtil.getPatternVariable((PsiCaseLabelElement)this.pattern);
            return variable != null ? variable.getNameIdentifier() : null;
        }

        @Override
        @Nullable
        public PsiTypeElement getTypeElement() {
            return JavaPsiPatternUtil.getPatternTypeElement((PsiCaseLabelElement)this.pattern);
        }

        @NotNull
        public PsiPattern pattern() {
            PsiPattern psiPattern = this.pattern;
            if (psiPattern == null) {
                PatternWrapper.$$$reportNull$$$0(1);
            }
            return psiPattern;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureUsageProcessor$PatternWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureUsageProcessor$PatternWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "pattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    record VariableWrapper(@NotNull PsiVariable variable) implements ChildWrapper
    {
        @NotNull
        private final PsiVariable variable;

        VariableWrapper(@NotNull PsiVariable variable) {
            if (variable == null) {
                VariableWrapper.$$$reportNull$$$0(0);
            }
        }

        @Override
        public String getName() {
            return this.variable.getName();
        }

        @Override
        @Nullable
        public PsiElement getNameIdentifier() {
            return this.variable.getNameIdentifier();
        }

        @Override
        public PsiTypeElement getTypeElement() {
            return this.variable.getTypeElement();
        }

        @Override
        public void normalizeDeclaration() {
            this.variable.normalizeDeclaration();
        }

        @NotNull
        public PsiVariable variable() {
            PsiVariable psiVariable = this.variable;
            if (psiVariable == null) {
                VariableWrapper.$$$reportNull$$$0(1);
            }
            return psiVariable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureUsageProcessor$VariableWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureUsageProcessor$VariableWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "variable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    static sealed interface ChildWrapper
    permits VariableWrapper, PatternWrapper {
        @Nullable
        public String getName();

        @Nullable
        public PsiElement getNameIdentifier();

        @Nullable
        public PsiTypeElement getTypeElement();

        default public void normalizeDeclaration() {
        }
    }

    private static class RecordHeader
    implements ChangeSignatureUtil.ChildrenGenerator<PsiRecordHeader, PsiRecordComponent> {
        public static final RecordHeader INSTANCE = new RecordHeader();

        private RecordHeader() {
        }

        @Override
        public List<PsiRecordComponent> getChildren(PsiRecordHeader header) {
            return Arrays.asList(header.getRecordComponents());
        }
    }

    private static class DeconstructionList
    implements ChangeSignatureUtil.ChildrenGenerator<PsiDeconstructionList, PsiPattern> {
        public static final DeconstructionList INSTANCE = new DeconstructionList();

        private DeconstructionList() {
        }

        @Override
        public List<PsiPattern> getChildren(PsiDeconstructionList psiParameterList) {
            return Arrays.asList(psiParameterList.getDeconstructionComponents());
        }
    }

    static abstract class Processor<Parent extends PsiElement, Child extends ChildWrapper> {
        @NotNull
        protected final PsiElementFactory myFactory;
        @NotNull
        protected final Parent myParent;
        @NotNull
        protected final JavaChangeInfo myChangeInfo;
        private final String @NotNull [] myOldParameterNames;
        private final String @NotNull [] myOldParameterTypes;

        Processor(@NotNull JavaChangeInfo changeInfo, @NotNull PsiElementFactory factory, @NotNull Parent parent) {
            if (changeInfo == null) {
                Processor.$$$reportNull$$$0(0);
            }
            if (factory == null) {
                Processor.$$$reportNull$$$0(1);
            }
            if (parent == null) {
                Processor.$$$reportNull$$$0(2);
            }
            this.myFactory = factory;
            this.myParent = parent;
            this.myChangeInfo = changeInfo;
            this.myOldParameterNames = changeInfo.getOldParameterNames();
            this.myOldParameterTypes = changeInfo.getOldParameterTypes();
        }

        void run() {
            ArrayList result = new ArrayList();
            JavaParameterInfo[] parameterInfos = this.myChangeInfo.getNewParameters();
            int newParamsLength = this.getNewParametersCount();
            for (int i = 0; i < newParamsLength; ++i) {
                JavaParameterInfo info = parameterInfos[i];
                if (info.isNew()) {
                    this.processNew(info, result);
                    continue;
                }
                this.processOld(info, result);
            }
            this.process(result);
        }

        int getNewParametersCount() {
            return this.myChangeInfo.getNewParameters().length;
        }

        private void processOld(JavaParameterInfo info, List<Child> result) {
            PsiTypeElement typeElement;
            int oldIndex = info.getOldIndex();
            Child child = this.getChild(oldIndex);
            if (child == null) {
                return;
            }
            result.add(child);
            String oldName = this.myOldParameterNames[oldIndex];
            if (!oldName.equals(info.getName()) && oldName.equals(child.getName())) {
                PsiIdentifier newIdentifier = this.myFactory.createIdentifier(info.getName());
                Objects.requireNonNull(child.getNameIdentifier()).replace((PsiElement)newIdentifier);
            }
            if ((typeElement = child.getTypeElement()) != null) {
                child.normalizeDeclaration();
                typeElement = child.getTypeElement();
                String oldType = this.myOldParameterTypes[oldIndex];
                if (!oldType.equals(info.getTypeText())) {
                    PsiType newType = info.createType((PsiElement)this.myChangeInfo.getMethod().getParameterList(), this.myChangeInfo.getMethod().getManager());
                    JavaChangeSignatureUsageProcessor.ensureNullabilityAnnotationsDoNotRepeat(typeElement, newType);
                    PsiSubstitutor mySubstitutor = this.getSubstitutor();
                    if (mySubstitutor != null) {
                        newType = mySubstitutor.substitute(newType);
                    }
                    if (newType != null) {
                        PsiTypeElement targetElement = (PsiTypeElement)typeElement.replace((PsiElement)this.myFactory.createTypeElement(newType));
                        JavaChangeSignatureUsageProcessor.applyNullability(targetElement, newType);
                    }
                }
            }
        }

        protected abstract void process(List<Child> var1);

        abstract void processNew(JavaParameterInfo var1, List<Child> var2);

        @Nullable
        abstract Child getChild(int var1);

        protected PsiSubstitutor getSubstitutor() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "changeInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "factory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureUsageProcessor$Processor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

