/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.usageView.UsageInfo;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.NotNull;

public class MethodCallUsageInfo
extends UsageInfo {
    private final boolean myToChangeArguments;
    private final boolean myToCatchExceptions;
    private final boolean myVarArgCall;
    private final PsiMethod myReferencedMethod;
    private final PsiSubstitutor mySubstitutor;

    public boolean isToCatchExceptions() {
        return this.myToCatchExceptions;
    }

    public boolean isToChangeArguments() {
        return this.myToChangeArguments;
    }

    public boolean isVarArgCall() {
        return this.myVarArgCall;
    }

    public MethodCallUsageInfo(@NotNull PsiElement ref, boolean isToChangeArguments, boolean isToCatchExceptions) {
        PsiElement psiElement;
        if (ref == null) {
            MethodCallUsageInfo.$$$reportNull$$$0(0);
        }
        super(ref);
        this.myToChangeArguments = isToChangeArguments;
        this.myToCatchExceptions = isToCatchExceptions;
        PsiCall call = MethodCallUsageInfo.getCall(ref);
        if (call == null) {
            throw new IllegalArgumentException("Unknown reference: " + String.valueOf(ref.getClass()));
        }
        this.myVarArgCall = MethodCallUtils.isVarArgCall((PsiCall)call);
        JavaResolveResult resolveResult = call.resolveMethodGenerics();
        if (resolveResult == null || !((psiElement = resolveResult.getElement()) instanceof PsiMethod)) {
            throw new IllegalArgumentException("Cannot resolve call to a method " + String.valueOf(call));
        }
        PsiMethod method = (PsiMethod)psiElement;
        this.myReferencedMethod = method;
        this.mySubstitutor = resolveResult.getSubstitutor();
    }

    private static PsiCall getCall(PsiElement ref) {
        if (ref instanceof PsiCall) {
            PsiCall call = (PsiCall)ref;
            return call;
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiCall) {
            PsiCall call = (PsiCall)parent;
            return call;
        }
        if (parent instanceof PsiAnonymousClass) {
            return (PsiCall)parent.getParent();
        }
        return null;
    }

    public PsiMethod getReferencedMethod() {
        return this.myReferencedMethod;
    }

    public PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/refactoring/changeSignature/MethodCallUsageInfo", "<init>"));
    }
}

