/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.convertToInstanceMethod;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class ConvertToInstanceMethodHandler
implements RefactoringActionHandler,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance(ConvertToInstanceMethodHandler.class);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            ConvertToInstanceMethodHandler.$$$reportNull$$$0(0);
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (element == null) {
            element = file.findElementAt(editor.getCaretModel().getOffset());
        }
        if (element == null) {
            return;
        }
        if (element instanceof PsiIdentifier) {
            element = element.getParent();
        }
        if (!(element instanceof PsiMethod)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"error.wrong.caret.position.method", (Object[])new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)ConvertToInstanceMethodHandler.getRefactoringName(), (String)"refactoring.convertToInstanceMethod");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("MakeMethodStaticHandler invoked");
        }
        this.invoke(project, new PsiElement[]{element}, dataContext);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        PsiElement psiElement;
        if (project == null) {
            ConvertToInstanceMethodHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            ConvertToInstanceMethodHandler.$$$reportNull$$$0(2);
        }
        if (elements.length != 1 || !((psiElement = elements[0]) instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)psiElement;
        try {
            new ConvertToInstanceMethodDialog(method, ConvertToInstanceMethodHandler.calculatePossibleInstanceQualifiers(method)).show();
        }
        catch (CommonRefactoringUtil.RefactoringErrorHintException e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw e;
            }
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)e.getMessage()), (String)ConvertToInstanceMethodHandler.getRefactoringName(), (String)"refactoring.convertToInstanceMethod");
        }
    }

    @VisibleForTesting
    public static Object @NotNull [] calculatePossibleInstanceQualifiers(@NotNull PsiMethod method) {
        boolean canHaveUsableConstructor;
        if (method == null) {
            ConvertToInstanceMethodHandler.$$$reportNull$$$0(3);
        }
        if (!method.hasModifierProperty("static")) {
            throw new CommonRefactoringUtil.RefactoringErrorHintException(JavaRefactoringBundle.message((String)"convertToInstanceMethod.method.is.not.static", (Object[])new Object[]{method.getName()}));
        }
        ArrayList<Object> qualifiers = new ArrayList<Object>();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        boolean classTypesFound = false;
        boolean resolvableClassesFound = false;
        for (PsiParameter parameter : parameters) {
            PsiType type = parameter.getType();
            if (!(type instanceof PsiClassType)) continue;
            PsiClassType classType = (PsiClassType)type;
            classTypesFound = true;
            PsiClass psiClass = classType.resolve();
            if (psiClass == null || psiClass instanceof PsiTypeParameter) continue;
            resolvableClassesFound = true;
            if (!method.getManager().isInProject((PsiElement)psiClass)) continue;
            qualifiers.add(parameter);
        }
        PsiClass containingClass = method.getContainingClass();
        boolean bl = canHaveUsableConstructor = containingClass != null && containingClass.getQualifiedName() != null && !containingClass.isEnum() && !PsiUtil.isInnerClass((PsiClass)containingClass) && !(containingClass instanceof PsiImplicitClass);
        if (canHaveUsableConstructor) {
            boolean noArgConstructor;
            Object[] constructors = containingClass.getConstructors();
            boolean bl2 = noArgConstructor = constructors.length == 0 || ContainerUtil.exists((Object[])constructors, constructor -> constructor.getParameterList().isEmpty());
            if (noArgConstructor) {
                qualifiers.add("this / new " + containingClass.getName() + "()");
            }
        }
        if (!qualifiers.isEmpty()) {
            Object[] objectArray = qualifiers.toArray();
            if (objectArray == null) {
                ConvertToInstanceMethodHandler.$$$reportNull$$$0(4);
            }
            return objectArray;
        }
        Object message = !classTypesFound ? JavaRefactoringBundle.message((String)"convertToInstanceMethod.no.parameters.with.reference.type", (Object[])new Object[0]) : (!resolvableClassesFound ? JavaRefactoringBundle.message((String)"convertToInstanceMethod.all.reference.type.parameters.have.unknown.types", (Object[])new Object[0]) : JavaRefactoringBundle.message((String)"convertToInstanceMethod.all.reference.type.parameters.are.not.in.project", (Object[])new Object[0]));
        if (canHaveUsableConstructor) {
            message = (String)message + " " + JavaRefactoringBundle.message((String)"convertToInstanceMethod.no.default.ctor", (Object[])new Object[0]);
        }
        throw new CommonRefactoringUtil.RefactoringErrorHintException((String)message);
    }

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        PsiElement caretElement;
        if (editor == null) {
            ConvertToInstanceMethodHandler.$$$reportNull$$$0(5);
        }
        if (file == null) {
            ConvertToInstanceMethodHandler.$$$reportNull$$$0(6);
        }
        if (dataContext == null) {
            ConvertToInstanceMethodHandler.$$$reportNull$$$0(7);
        }
        return MethodUtils.getJavaMethodFromHeader((PsiElement)(caretElement = BaseRefactoringAction.getElementAtCaret((Editor)editor, (PsiFile)file))) != null;
    }

    @NlsContexts.DialogTitle
    static String getRefactoringName() {
        return JavaRefactoringBundle.message((String)"convert.to.instance.method.title", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/convertToInstanceMethod/ConvertToInstanceMethodHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/convertToInstanceMethod/ConvertToInstanceMethodHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePossibleInstanceQualifiers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleInstanceQualifiers";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForQuickList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

