/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.convertToInstanceMethod;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.convertToInstanceMethod.ConvertToInstanceMethodHandler;
import com.intellij.refactoring.convertToInstanceMethod.ImplementingClassUsageInfo;
import com.intellij.refactoring.convertToInstanceMethod.JavaDocUsageInfo;
import com.intellij.refactoring.convertToInstanceMethod.MethodCallUsageInfo;
import com.intellij.refactoring.convertToInstanceMethod.MethodReferenceUsageInfo;
import com.intellij.refactoring.convertToInstanceMethod.ParameterUsageInfo;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodViewDescriptor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringConflictsUtilImpl;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConvertToInstanceMethodProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(ConvertToInstanceMethodProcessor.class);
    private PsiMethod myMethod;
    @Nullable
    private PsiParameter myTargetParameter;
    private final boolean myParameterIsReassigned;
    private PsiClass myTargetClass;
    private Map<PsiTypeParameter, PsiTypeParameter> myTypeParameterReplacements;
    private static final Key<PsiTypeParameter> BIND_TO_TYPE_PARAMETER = Key.create((String)"REPLACEMENT");
    private final String myOldVisibility;
    private final String myNewVisibility;

    public ConvertToInstanceMethodProcessor(Project project, PsiMethod method, @Nullable PsiParameter targetParameter, String newVisibility) {
        super(project);
        this.myMethod = method;
        this.myTargetParameter = targetParameter;
        this.myParameterIsReassigned = targetParameter != null && VariableAccessUtils.variableIsAssigned((PsiVariable)this.myTargetParameter, (PsiElement)this.myTargetParameter.getDeclarationScope());
        LOG.assertTrue(method.hasModifierProperty("static"));
        if (this.myTargetParameter != null) {
            LOG.assertTrue(this.myTargetParameter.getDeclarationScope() == this.myMethod);
            LOG.assertTrue(this.myTargetParameter.getType() instanceof PsiClassType);
            PsiType type = this.myTargetParameter.getType();
            LOG.assertTrue(type instanceof PsiClassType);
            this.myTargetClass = ((PsiClassType)type).resolve();
        } else {
            this.myTargetClass = method.getContainingClass();
        }
        this.myOldVisibility = VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList());
        this.myNewVisibility = newVisibility;
    }

    public PsiClass getTargetClass() {
        return this.myTargetClass;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(0);
        }
        return new MoveInstanceMethodViewDescriptor(this.myMethod, (PsiVariable)this.myTargetParameter, this.myTargetClass);
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(1);
        }
        LOG.assertTrue(elements.length > 1);
        this.myMethod = (PsiMethod)elements[0];
        this.myTargetParameter = elements.length == 3 ? (PsiParameter)elements[1] : null;
        this.myTargetClass = (PsiClass)elements[elements.length - 1];
    }

    protected UsageInfo @NotNull [] findUsages() {
        LOG.assertTrue(this.myTargetParameter == null || this.myTargetParameter.getDeclarationScope() == this.myMethod);
        Project project = this.myMethod.getProject();
        PsiReference[] methodReferences = (PsiReference[])ReferencesSearch.search((PsiElement)this.myMethod, (SearchScope)GlobalSearchScope.projectScope((Project)project), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY);
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (PsiReference ref : methodReferences) {
            PsiElement element = ref.getElement();
            if (element instanceof PsiReferenceExpression) {
                PsiElement parent = element.getParent();
                if (parent instanceof PsiMethodCallExpression) {
                    result.add(new MethodCallUsageInfo((PsiMethodCallExpression)parent));
                    continue;
                }
                if (!(element instanceof PsiMethodReferenceExpression)) continue;
                result.add(new MethodReferenceUsageInfo((PsiMethodReferenceExpression)element, this.myTargetParameter == null || this.myMethod.getParameterList().getParameterIndex(this.myTargetParameter) == 0));
                continue;
            }
            if (!(element instanceof PsiDocTagValue)) continue;
            result.add(new JavaDocUsageInfo(ref));
        }
        if (this.myTargetParameter != null) {
            for (PsiReference ref : ReferencesSearch.search((PsiElement)this.myTargetParameter, (SearchScope)new LocalSearchScope((PsiElement)this.myMethod), (boolean)false).asIterable()) {
                PsiElement element = ref.getElement();
                if (!(element instanceof PsiReferenceExpression) && !(element instanceof PsiDocParamRef)) continue;
                result.add(new ParameterUsageInfo(ref));
            }
        }
        if (this.myTargetClass.isInterface()) {
            PsiClass[] implementingClasses;
            for (PsiClass implementingClass : implementingClasses = RefactoringHierarchyUtil.findImplementingClasses(this.myTargetClass)) {
                result.add(new ImplementingClassUsageInfo(implementingClass));
            }
        }
        UsageInfo[] usageInfoArray = result.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    @NotNull
    protected String getRefactoringId() {
        return "refactoring.makeInstance";
    }

    @NotNull
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElements(new PsiElement[]{this.myMethod, this.myTargetClass});
        RefactoringEventData refactoringEventData = data;
        if (refactoringEventData == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(3);
        }
        return refactoringEventData;
    }

    @NotNull
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(4);
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.myTargetClass);
        RefactoringEventData refactoringEventData = data;
        if (refactoringEventData == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(5);
        }
        return refactoringEventData;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(6);
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        @NlsContexts.DialogMessage MultiMap conflicts = new MultiMap();
        Set<PsiMethod> methods = Collections.singleton(this.myMethod);
        RefactoringConflictsUtil.getInstance().analyzeAccessibilityConflictsAfterMemberMove(this.myTargetClass, this.myNewVisibility, methods, conflicts);
        if (this.myTargetClass.isInterface() && !PsiUtil.isAvailable((JavaFeature)JavaFeature.EXTENSION_METHODS, (PsiElement)this.myTargetClass)) {
            for (UsageInfo usage : usagesIn) {
                if (!(usage instanceof ImplementingClassUsageInfo)) continue;
                PsiClass targetClass = ((ImplementingClassUsageInfo)usage).getPsiClass();
                RefactoringConflictsUtilImpl.analyzeUsedElementsAfterMove((PsiMember)this.myMethod, (PsiElement)this.myMethod, methods, null, targetClass, (PsiElement)targetClass, (MultiMap<PsiElement, String>)conflicts);
            }
        }
        for (UsageInfo usageInfo : usagesIn) {
            PsiMethodCallExpression place = null;
            if (usageInfo instanceof MethodCallUsageInfo) {
                place = ((MethodCallUsageInfo)usageInfo).getMethodCall();
                if (this.myTargetParameter != null) {
                    PsiExpression[] expressions = place.getArgumentList().getExpressions();
                    int index = this.myMethod.getParameterList().getParameterIndex(this.myTargetParameter);
                    if (index < expressions.length) {
                        PsiExpression instanceValue = expressions[index];
                        if ((instanceValue = RefactoringUtil.unparenthesizeExpression(instanceValue)) instanceof PsiLiteralExpression && ((PsiLiteralExpression)instanceValue).getValue() == null) {
                            String message = JavaRefactoringBundle.message((String)"0.contains.call.with.null.argument.for.parameter.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer((PsiElement)place), (boolean)true), CommonRefactoringUtil.htmlEmphasize((String)this.myTargetParameter.getName())});
                            conflicts.putValue((Object)place, (Object)message);
                        }
                    }
                }
            } else if (usageInfo instanceof MethodReferenceUsageInfo) {
                place = ((MethodReferenceUsageInfo)usageInfo).getExpression();
                if (!((MethodReferenceUsageInfo)usageInfo).isApplicableBySecondSearch()) {
                    conflicts.putValue((Object)place, (Object)JavaRefactoringBundle.message((String)"expand.method.reference.warning", (Object[])new Object[0]));
                }
            }
            if (this.myTargetParameter != null || place == null || !this.myTargetClass.hasTypeParameters() || this.thisAccessExpressionApplicable((PsiElement)place)) continue;
            conflicts.putValue((Object)place, (Object)JavaRefactoringBundle.message((String)"infer.class.type.args.warning", (Object[])new Object[]{this.myTargetClass.getName()}));
        }
        return this.showConflicts(conflicts, usagesIn);
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(7);
        }
        EditorHelper.openInEditor((PsiElement)this.doRefactoring(usages));
    }

    @NotNull
    private PsiMethod doRefactoring(UsageInfo[] usages) {
        PsiMethod result;
        this.myTypeParameterReplacements = this.buildTypeParameterReplacements();
        ArrayList<PsiClass> inheritors = new ArrayList<PsiClass>();
        CommonRefactoringUtil.sortDepthFirstRightLeftOrder((UsageInfo[])usages);
        for (UsageInfo usage : usages) {
            if (usage instanceof MethodCallUsageInfo) {
                this.processMethodCall(((MethodCallUsageInfo)usage).getMethodCall());
                continue;
            }
            if (usage instanceof ParameterUsageInfo && !this.myParameterIsReassigned) {
                this.processParameterUsage((ParameterUsageInfo)usage);
                continue;
            }
            if (usage instanceof ImplementingClassUsageInfo) {
                inheritors.add(((ImplementingClassUsageInfo)usage).getPsiClass());
                continue;
            }
            if (!(usage instanceof MethodReferenceUsageInfo)) continue;
            this.processMethodReference((MethodReferenceUsageInfo)usage);
        }
        this.prepareTypeParameterReplacement();
        if (this.myTargetParameter != null) {
            if (this.myParameterIsReassigned) {
                PsiDeclarationStatement statement = JavaPsiFacade.getElementFactory((Project)this.myProject).createVariableDeclarationStatement(this.myTargetParameter.getName(), this.myTargetParameter.getType(), this.createThisExpression());
                PsiCodeBlock body = this.myMethod.getBody();
                assert (body != null);
                PsiElement first = body.getFirstBodyElement();
                assert (first != null);
                first.getParent().addBefore((PsiElement)statement, first);
            }
            this.myTargetParameter.delete();
        }
        ChangeContextUtil.encodeContextInfo((PsiElement)this.myMethod, (boolean)true);
        if (!this.myTargetClass.isInterface()) {
            result = this.addMethodToClass(this.myTargetClass);
            this.fixVisibility(result, usages);
        } else {
            result = this.addMethodToClass(this.myTargetClass);
            PsiModifierList modifierList = result.getModifierList();
            boolean markAsDefault = PsiUtil.isAvailable((JavaFeature)JavaFeature.EXTENSION_METHODS, (PsiElement)this.myTargetClass);
            if (markAsDefault) {
                modifierList.setModifierProperty("default", true);
            }
            RefactoringUtil.makeMethodAbstract(this.myTargetClass, result);
            if (!markAsDefault) {
                for (PsiClass psiClass : inheritors) {
                    PsiMethod newMethod = this.addMethodToClass(psiClass);
                    String modifier = this.myNewVisibility != null && !this.myNewVisibility.equals("EscalateVisible") ? this.myNewVisibility : "public";
                    PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)modifier, (boolean)true);
                }
            }
        }
        PsiMethod psiMethod = result;
        if (psiMethod == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(8);
        }
        return psiMethod;
    }

    private void processMethodReference(MethodReferenceUsageInfo usage) {
        PsiMethodReferenceExpression expression = usage.getExpression();
        if (usage.isApplicableBySecondSearch()) {
            boolean thisAccess;
            PsiExpression qualifierExpression = expression.getQualifierExpression();
            LOG.assertTrue(qualifierExpression != null);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myProject);
            Object qualifier = this.myTargetParameter != null ? factory.createReferenceExpression(this.myTargetClass) : ((thisAccess = this.thisAccessExpressionApplicable((PsiElement)expression)) ? this.createThisExpression() : this.createSyntheticAccessExpression(factory, (PsiElement)expression));
            qualifierExpression.replace((PsiElement)qualifier);
        } else {
            PsiLambdaExpression lambdaExpression = LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)expression, (boolean)false, (boolean)true);
            List returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)lambdaExpression);
            if (!returnExpressions.isEmpty()) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)returnExpressions.get(0);
                this.processMethodCall(methodCall);
                usage.setReplacement(methodCall);
            }
        }
    }

    private void fixVisibility(PsiMethod method, UsageInfo[] usages) {
        PsiModifierList modifierList = method.getModifierList();
        if ("EscalateVisible".equals(this.myNewVisibility)) {
            for (UsageInfo usage : usages) {
                PsiElement place;
                UsageInfo usageInfo;
                Objects.requireNonNull(usage);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MethodCallUsageInfo.class, MethodReferenceUsageInfo.class}, (Object)usageInfo, n)) {
                    case 0: {
                        MethodCallUsageInfo info = (MethodCallUsageInfo)usageInfo;
                        PsiElement psiElement = info.getElement();
                        break;
                    }
                    case 1: {
                        PsiElement psiElement;
                        MethodReferenceUsageInfo info = (MethodReferenceUsageInfo)usageInfo;
                        PsiMethodReferenceExpression expression = info.getExpression();
                        if (expression != null && expression.isValid()) {
                            psiElement = expression;
                            break;
                        }
                        psiElement = info.getReplacement();
                        break;
                    }
                    default: {
                        PsiElement psiElement = place = null;
                    }
                }
                if (place == null) continue;
                VisibilityUtil.escalateVisibility((PsiMember)method, (PsiElement)place);
            }
        } else if (this.myNewVisibility != null && !this.myNewVisibility.equals(this.myOldVisibility)) {
            modifierList.setModifierProperty(this.myNewVisibility, true);
        }
    }

    private void prepareTypeParameterReplacement() {
        if (this.myTypeParameterReplacements == null) {
            return;
        }
        Set<PsiTypeParameter> typeParameters = this.myTypeParameterReplacements.keySet();
        for (PsiTypeParameter parameter : typeParameters) {
            for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope((PsiElement)this.myMethod), (boolean)false).asIterable()) {
                if (!(reference.getElement() instanceof PsiJavaCodeReferenceElement)) continue;
                reference.getElement().putCopyableUserData(BIND_TO_TYPE_PARAMETER, (Object)this.myTypeParameterReplacements.get(parameter));
            }
        }
        Set<PsiTypeParameter> methodTypeParameters = this.myTypeParameterReplacements.keySet();
        for (PsiTypeParameter methodTypeParameter : methodTypeParameters) {
            methodTypeParameter.delete();
        }
    }

    private PsiMethod addMethodToClass(PsiClass targetClass) {
        HashMap<PsiTypeParameter, PsiTypeParameter> additionalReplacements;
        PsiMethod newMethod;
        if (targetClass == this.myMethod.getContainingClass()) {
            newMethod = this.myMethod;
        } else {
            newMethod = (PsiMethod)targetClass.add((PsiElement)this.myMethod);
            PsiMethod copy = (PsiMethod)this.myMethod.copy();
            this.myMethod.delete();
            this.myMethod = copy;
        }
        PsiModifierList modifierList = newMethod.getModifierList();
        modifierList.setModifierProperty("static", false);
        ChangeContextUtil.decodeContextInfo((PsiElement)newMethod, null, null);
        if (this.myTypeParameterReplacements == null) {
            return newMethod;
        }
        if (targetClass != this.myTargetClass) {
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)this.myTargetClass, (PsiClass)targetClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            Map<PsiTypeParameter, PsiTypeParameter> map = ConvertToInstanceMethodProcessor.calculateReplacementMap(superClassSubstitutor, this.myTargetClass, (PsiElement)targetClass);
            if (map == null) {
                return newMethod;
            }
            additionalReplacements = new HashMap<PsiTypeParameter, PsiTypeParameter>();
            for (Map.Entry<PsiTypeParameter, PsiTypeParameter> entry : map.entrySet()) {
                additionalReplacements.put(entry.getValue(), entry.getKey());
            }
        } else {
            additionalReplacements = null;
        }
        newMethod.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(this){

            public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
                PsiTypeParameter typeParameterToBind;
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((typeParameterToBind = (PsiTypeParameter)reference.getCopyableUserData(BIND_TO_TYPE_PARAMETER)) != null) {
                    reference.putCopyableUserData(BIND_TO_TYPE_PARAMETER, null);
                    try {
                        if (additionalReplacements != null) {
                            typeParameterToBind = (PsiTypeParameter)additionalReplacements.get(typeParameterToBind);
                        }
                        reference.bindToElement((PsiElement)typeParameterToBind);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                } else {
                    this.visitElement((PsiElement)reference);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/refactoring/convertToInstanceMethod/ConvertToInstanceMethodProcessor$1", "visitReferenceElement"));
            }
        });
        return newMethod;
    }

    private void processParameterUsage(ParameterUsageInfo usage) {
        PsiReference reference = usage.getReferenceExpression();
        if (reference instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)reference;
            PsiElement psiElement = referenceExpression.getParent();
            if (psiElement instanceof PsiReferenceExpression) {
                PsiReferenceExpression parentReference = (PsiReferenceExpression)psiElement;
                PsiExpression qualifier = this.calculateQualifier(parentReference);
                if (qualifier == null) {
                    referenceExpression.delete();
                } else {
                    referenceExpression.replace((PsiElement)qualifier);
                }
            } else {
                referenceExpression.replace((PsiElement)this.createThisExpression());
            }
        } else {
            PsiElement element = reference.getElement();
            if (element instanceof PsiDocParamRef) {
                element.getParent().delete();
            }
        }
    }

    private PsiExpression calculateQualifier(PsiReferenceExpression parent) {
        if (parent instanceof PsiMethodReferenceExpression) {
            return this.createThisExpression();
        }
        PsiElement psiElement = parent.getParent();
        if (psiElement instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)psiElement;
            copy = (PsiMethodCallExpression)methodCall.copy();
            PsiExpression qualifier = copy.getMethodExpression().getQualifierExpression();
            if (qualifier != null) {
                qualifier.delete();
                JavaResolveResult resolveResult = copy.resolveMethodGenerics();
                if (methodCall.resolveMethod() == resolveResult.getElement() || !resolveResult.isValidResult()) {
                    return null;
                }
                return this.createQualifiedThisExpression();
            }
        } else {
            copy = parent.resolve();
            if (copy instanceof PsiField) {
                PsiField field = (PsiField)copy;
                copy = (PsiReferenceExpression)parent.copy();
                PsiExpression qualifier = copy.getQualifierExpression();
                if (qualifier != null) {
                    qualifier.delete();
                    PsiElement target = copy.resolve();
                    if (target == field || target == null) {
                        return null;
                    }
                    return target instanceof PsiField ? this.createQualifiedThisExpression() : this.createThisExpression();
                }
            }
        }
        return null;
    }

    @NotNull
    private PsiExpression createQualifiedThisExpression() {
        PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)this.myProject).createExpressionFromText(this.myTargetClass.getQualifiedName() + ".this", null);
        if (psiExpression == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(9);
        }
        return psiExpression;
    }

    @NotNull
    private PsiExpression createThisExpression() {
        PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)this.myProject).createExpressionFromText("this", null);
        if (psiExpression == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(10);
        }
        return psiExpression;
    }

    private void processMethodCall(PsiMethodCallExpression methodCall) {
        PsiExpression qualifier;
        PsiExpression argument;
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myMethod.getProject());
        PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
        if (this.myTargetParameter != null) {
            PsiParameterList parameterList = this.myMethod.getParameterList();
            int parameterIndex = parameterList.getParameterIndex(this.myTargetParameter);
            PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
            if (arguments.length <= parameterIndex) {
                return;
            }
            argument = arguments[parameterIndex];
        } else {
            if (this.thisAccessExpressionApplicable((PsiElement)methodCall)) {
                PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
                if (qualifierExpression != null) {
                    qualifierExpression.delete();
                }
                return;
            }
            argument = this.createSyntheticAccessExpression(factory, (PsiElement)methodCall);
        }
        if (methodExpression.getQualifierExpression() != null) {
            qualifier = methodExpression.getQualifierExpression();
        } else {
            PsiReferenceExpression newRefExpr = (PsiReferenceExpression)factory.createExpressionFromText("x." + this.myMethod.getName(), null);
            qualifier = ((PsiReferenceExpression)methodExpression.replace((PsiElement)newRefExpr)).getQualifierExpression();
        }
        qualifier.replace((PsiElement)argument);
        argument.delete();
    }

    private PsiExpression createSyntheticAccessExpression(PsiElementFactory factory, PsiElement context) {
        return factory.createExpressionFromText("new " + this.myTargetClass.getName() + "()", context);
    }

    private boolean thisAccessExpressionApplicable(PsiElement expression) {
        return PsiTreeUtil.isAncestor((PsiElement)this.myTargetClass, (PsiElement)expression, (boolean)false) && PsiUtil.getEnclosingStaticElement((PsiElement)expression, (PsiClass)this.myTargetClass) == null;
    }

    @NotNull
    protected String getCommandName() {
        String string = ConvertToInstanceMethodHandler.getRefactoringName();
        if (string == null) {
            ConvertToInstanceMethodProcessor.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    public Map<PsiTypeParameter, PsiTypeParameter> buildTypeParameterReplacements() {
        if (this.myTargetParameter == null) {
            return Collections.emptyMap();
        }
        PsiClassType type = (PsiClassType)this.myTargetParameter.getType();
        PsiSubstitutor substitutor = type.resolveGenerics().getSubstitutor();
        return ConvertToInstanceMethodProcessor.calculateReplacementMap(substitutor, this.myTargetClass, (PsiElement)this.myMethod);
    }

    @Nullable
    private static Map<PsiTypeParameter, PsiTypeParameter> calculateReplacementMap(PsiSubstitutor substitutor, PsiClass targetClass, PsiElement containingElement) {
        HashMap<PsiTypeParameter, PsiTypeParameter> result = new HashMap<PsiTypeParameter, PsiTypeParameter>();
        for (PsiTypeParameter classTypeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)targetClass)) {
            PsiType psiType = substitutor.substitute(classTypeParameter);
            if (!(psiType instanceof PsiClassType)) {
                return null;
            }
            PsiClassType classType = (PsiClassType)psiType;
            PsiClass psiClass = classType.resolve();
            if (!(psiClass instanceof PsiTypeParameter)) {
                return null;
            }
            PsiTypeParameter methodTypeParameter = (PsiTypeParameter)psiClass;
            if (methodTypeParameter.getOwner() != containingElement) {
                return null;
            }
            if (result.containsKey(methodTypeParameter)) {
                return null;
            }
            result.put(methodTypeParameter, classTypeParameter);
        }
        return result;
    }

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    @Nullable
    public PsiParameter getTargetParameter() {
        return this.myTargetParameter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/convertToInstanceMethod/ConvertToInstanceMethodProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/convertToInstanceMethod/ConvertToInstanceMethodProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeData";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doRefactoring";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createQualifiedThisExpression";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createThisExpression";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

