/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.encapsulateFields;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldHelper;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldUsageInfo;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsDescriptor;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsProcessor;
import com.intellij.refactoring.encapsulateFields.FieldDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaEncapsulateFieldHelper
extends EncapsulateFieldHelper {
    private static final Logger LOG = Logger.getInstance(JavaEncapsulateFieldHelper.class);

    @Nullable
    public EncapsulateFieldUsageInfo createUsage(@NotNull EncapsulateFieldsDescriptor descriptor, @NotNull FieldDescriptor fieldDescriptor, @NotNull PsiReference reference) {
        if (descriptor == null) {
            JavaEncapsulateFieldHelper.$$$reportNull$$$0(0);
        }
        if (fieldDescriptor == null) {
            JavaEncapsulateFieldHelper.$$$reportNull$$$0(1);
        }
        if (reference == null) {
            JavaEncapsulateFieldHelper.$$$reportNull$$$0(2);
        }
        if (!(reference instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)reference;
        boolean findSet = descriptor.isToEncapsulateSet();
        boolean findGet = descriptor.isToEncapsulateGet();
        if (findGet && JavaEncapsulateFieldHelper.isUsedInExistingAccessor(descriptor.getTargetClass(), fieldDescriptor.getGetterPrototype(), (PsiElement)ref)) {
            return null;
        }
        if (findSet && JavaEncapsulateFieldHelper.isUsedInExistingAccessor(descriptor.getTargetClass(), fieldDescriptor.getSetterPrototype(), (PsiElement)ref)) {
            return null;
        }
        if (!findGet && !PsiUtil.isAccessedForWriting((PsiExpression)ref)) {
            return null;
        }
        if (!(findSet && !fieldDescriptor.getField().hasModifierProperty("final") || PsiUtil.isAccessedForReading((PsiExpression)ref))) {
            return null;
        }
        if (!descriptor.isToUseAccessorsWhenAccessible()) {
            PsiResolveHelper helper;
            PsiModifierList newModifierList = JavaEncapsulateFieldHelper.createNewModifierList(descriptor);
            PsiClass accessObjectClass = null;
            PsiExpression qualifier = ref.getQualifierExpression();
            if (qualifier != null) {
                accessObjectClass = (PsiClass)PsiUtil.getAccessObjectClass((PsiExpression)qualifier).getElement();
            }
            if ((helper = JavaPsiFacade.getInstance((Project)((PsiReferenceExpression)reference).getProject()).getResolveHelper()).isAccessible((PsiMember)fieldDescriptor.getField(), newModifierList, (PsiElement)ref, accessObjectClass, null)) {
                return null;
            }
        }
        return new EncapsulateFieldUsageInfo((PsiReference)ref, fieldDescriptor);
    }

    public static PsiModifierList createNewModifierList(EncapsulateFieldsDescriptor descriptor) {
        PsiModifierList newModifierList = null;
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)descriptor.getTargetClass().getProject());
        try {
            PsiField field = factory.createField("a", (PsiType)PsiTypes.intType());
            EncapsulateFieldsProcessor.setNewFieldVisibility(field, descriptor);
            newModifierList = field.getModifierList();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return newModifierList;
    }

    public static boolean isUsedInExistingAccessor(PsiClass aClass, PsiMethod prototype, PsiElement element) {
        PsiMethod existingAccessor = aClass.findMethodBySignature(prototype, false);
        if (existingAccessor != null) {
            for (PsiElement parent = element; parent != null; parent = parent.getParent()) {
                if (!existingAccessor.equals((Object)parent)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processUsage(@NotNull EncapsulateFieldUsageInfo usage, @NotNull EncapsulateFieldsDescriptor descriptor, PsiMethod setter, PsiMethod getter) {
        boolean processSet;
        PsiElement element;
        if (usage == null) {
            JavaEncapsulateFieldHelper.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            JavaEncapsulateFieldHelper.$$$reportNull$$$0(4);
        }
        if (!((element = usage.getElement()) instanceof PsiReferenceExpression)) {
            return false;
        }
        FieldDescriptor fieldDescriptor = usage.getFieldDescriptor();
        PsiField field = fieldDescriptor.getField();
        boolean processGet = descriptor.isToEncapsulateGet() && getter != null;
        boolean bl = processSet = descriptor.isToEncapsulateSet() && !field.hasModifierProperty("final") && setter != null;
        if (!processGet && !processSet) {
            return true;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)descriptor.getTargetClass().getProject());
        try {
            PsiReferenceExpression expr = (PsiReferenceExpression)element;
            PsiElement parent = expr.getParent();
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
                if (expr.equals((Object)((PsiAssignmentExpression)parent).getLExpression())) {
                    PsiMethodCallExpression setExpr;
                    PsiMethodCallExpression getterCall;
                    if (assignment.getRExpression() == null) {
                        return true;
                    }
                    PsiJavaToken opSign = assignment.getOperationSign();
                    IElementType opType = opSign.getTokenType();
                    if (opType == JavaTokenType.EQ) {
                        if (!processSet) {
                            return true;
                        }
                        PsiExpression setterArgument = assignment.getRExpression();
                        PsiMethodCallExpression methodCall = JavaEncapsulateFieldHelper.createSetterCall(fieldDescriptor, setterArgument, expr, descriptor.getTargetClass(), setter);
                        if (methodCall == null) return true;
                        assignment.replace((PsiElement)methodCall);
                        return true;
                    }
                    if (opType != JavaTokenType.ASTERISKEQ && opType != JavaTokenType.DIVEQ && opType != JavaTokenType.PERCEQ && opType != JavaTokenType.PLUSEQ && opType != JavaTokenType.MINUSEQ && opType != JavaTokenType.LTLTEQ && opType != JavaTokenType.GTGTEQ && opType != JavaTokenType.GTGTGTEQ && opType != JavaTokenType.ANDEQ && opType != JavaTokenType.OREQ) {
                        if (opType != JavaTokenType.XOREQ) return true;
                    }
                    String opName = opSign.getText();
                    LOG.assertTrue(StringUtil.endsWithChar((CharSequence)opName, (char)'='));
                    opName = opName.substring(0, opName.length() - 1);
                    PsiReferenceExpression getExpr = expr;
                    if (processGet && (getterCall = JavaEncapsulateFieldHelper.createGetterCall(fieldDescriptor, expr, descriptor.getTargetClass(), getter)) != null) {
                        getExpr = getterCall;
                    }
                    @NonNls Object text = "a" + opName + "b";
                    PsiBinaryExpression binExpr = (PsiBinaryExpression)factory.createExpressionFromText((String)text, (PsiElement)expr);
                    binExpr.getLOperand().replace((PsiElement)getExpr);
                    binExpr.getROperand().replace((PsiElement)assignment.getRExpression());
                    if (processSet) {
                        setExpr = JavaEncapsulateFieldHelper.createSetterCall(fieldDescriptor, (PsiExpression)binExpr, expr, descriptor.getTargetClass(), setter);
                    } else {
                        text = "a = b";
                        PsiAssignmentExpression assignment1 = (PsiAssignmentExpression)factory.createExpressionFromText((String)text, null);
                        assignment1.getLExpression().replace((PsiElement)expr);
                        assignment1.getRExpression().replace((PsiElement)binExpr);
                        setExpr = assignment1;
                    }
                    assignment.replace((PsiElement)setExpr);
                    return true;
                }
            }
            if (PsiUtil.isIncrementDecrementOperation((PsiElement)parent)) {
                PsiMethodCallExpression setExpr;
                PsiMethodCallExpression getterCall;
                IElementType sign = ((PsiUnaryExpression)parent).getOperationTokenType();
                PsiReferenceExpression getExpr = expr;
                if (processGet && (getterCall = JavaEncapsulateFieldHelper.createGetterCall(fieldDescriptor, expr, descriptor.getTargetClass(), getter)) != null) {
                    getExpr = getterCall;
                }
                @NonNls String text = sign == JavaTokenType.PLUSPLUS ? "a+1" : "a-1";
                PsiBinaryExpression binExpr = (PsiBinaryExpression)factory.createExpressionFromText(text, null);
                binExpr.getLOperand().replace((PsiElement)getExpr);
                if (processSet) {
                    setExpr = JavaEncapsulateFieldHelper.createSetterCall(fieldDescriptor, (PsiExpression)binExpr, expr, descriptor.getTargetClass(), setter);
                } else {
                    text = "a = b";
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)factory.createExpressionFromText(text, null);
                    assignment.getLExpression().replace((PsiElement)expr);
                    assignment.getRExpression().replace((PsiElement)binExpr);
                    setExpr = assignment;
                }
                parent.replace((PsiElement)setExpr);
                return true;
            }
            if (!processGet) {
                return true;
            }
            PsiMethodCallExpression methodCall = JavaEncapsulateFieldHelper.createGetterCall(fieldDescriptor, expr, descriptor.getTargetClass(), getter);
            if (methodCall == null) return true;
            expr.replace((PsiElement)methodCall);
            return true;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return true;
    }

    private static PsiMethodCallExpression createSetterCall(FieldDescriptor fieldDescriptor, PsiExpression setterArgument, PsiReferenceExpression expr, PsiClass aClass, PsiMethod setter) throws IncorrectOperationException {
        String setterName = fieldDescriptor.getSetterName();
        @NonNls String text = setterName + "(a)";
        PsiMethodCallExpression methodCall = JavaEncapsulateFieldHelper.prepareMethodCall(expr, text);
        methodCall.getArgumentList().getExpressions()[0].replace((PsiElement)setterArgument);
        methodCall = JavaEncapsulateFieldHelper.checkMethodResolvable(methodCall, setter, expr, aClass);
        if (methodCall == null) {
            VisibilityUtil.escalateVisibility((PsiMember)fieldDescriptor.getField(), (PsiElement)expr);
        }
        return methodCall;
    }

    @Nullable
    private static PsiMethodCallExpression createGetterCall(FieldDescriptor fieldDescriptor, PsiReferenceExpression expr, PsiClass aClass, @NotNull PsiMethod getter) throws IncorrectOperationException {
        if (getter == null) {
            JavaEncapsulateFieldHelper.$$$reportNull$$$0(5);
        }
        String getterName = fieldDescriptor.getGetterName();
        @NonNls String text = getterName + "()";
        PsiMethodCallExpression methodCall = JavaEncapsulateFieldHelper.prepareMethodCall(expr, text);
        if ((methodCall = JavaEncapsulateFieldHelper.checkMethodResolvable(methodCall, getter, expr, aClass)) == null) {
            VisibilityUtil.escalateVisibility((PsiMember)fieldDescriptor.getField(), (PsiElement)expr);
        }
        return methodCall;
    }

    private static PsiMethodCallExpression prepareMethodCall(PsiReferenceExpression expr, String text) {
        PsiElement referenceNameElement;
        PsiExpression qualifier = expr.getQualifierExpression();
        if (qualifier != null && (referenceNameElement = expr.getReferenceNameElement()) != null) {
            text = expr.getText().substring(0, referenceNameElement.getStartOffsetInParent()) + (String)text;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expr.getProject());
        return (PsiMethodCallExpression)factory.createExpressionFromText((String)text, (PsiElement)expr);
    }

    @Nullable
    private static PsiMethodCallExpression checkMethodResolvable(@NotNull PsiMethodCallExpression methodCall, @NotNull PsiMethod targetMethod, PsiReferenceExpression context, PsiClass aClass) throws IncorrectOperationException {
        if (methodCall == null) {
            JavaEncapsulateFieldHelper.$$$reportNull$$$0(6);
        }
        if (targetMethod == null) {
            JavaEncapsulateFieldHelper.$$$reportNull$$$0(7);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)targetMethod.getProject());
        PsiElement resolved = methodCall.getMethodExpression().resolve();
        if (!targetMethod.equals((Object)resolved)) {
            PsiClass containingClass;
            if (resolved instanceof PsiMethod) {
                containingClass = ((PsiMethod)resolved).getContainingClass();
            } else if (resolved instanceof PsiClass) {
                containingClass = (PsiClass)resolved;
            } else {
                return null;
            }
            if (containingClass != null && containingClass.isInheritor(aClass, false)) {
                PsiExpression newMethodExpression = factory.createExpressionFromText("super." + targetMethod.getName(), (PsiElement)context);
                methodCall.getMethodExpression().replace((PsiElement)newMethodExpression);
            } else {
                methodCall = null;
            }
        }
        return methodCall;
    }

    public PsiField @NotNull [] getApplicableFields(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaEncapsulateFieldHelper.$$$reportNull$$$0(8);
        }
        List fields = ContainerUtil.filter((Object[])aClass.getFields(), field -> !(field instanceof PsiEnumConstant));
        PsiField[] psiFieldArray = fields.toArray(PsiField.EMPTY_ARRAY);
        if (psiFieldArray == null) {
            JavaEncapsulateFieldHelper.$$$reportNull$$$0(9);
        }
        return psiFieldArray;
    }

    @NotNull
    public String suggestSetterName(@NotNull PsiField field) {
        if (field == null) {
            JavaEncapsulateFieldHelper.$$$reportNull$$$0(10);
        }
        String string = GenerateMembersUtil.suggestSetterName((PsiField)field);
        if (string == null) {
            JavaEncapsulateFieldHelper.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String suggestGetterName(@NotNull PsiField field) {
        if (field == null) {
            JavaEncapsulateFieldHelper.$$$reportNull$$$0(12);
        }
        String string = GenerateMembersUtil.suggestGetterName((PsiField)field);
        if (string == null) {
            JavaEncapsulateFieldHelper.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public PsiMethod generateMethodPrototype(@NotNull PsiField field, @NotNull String methodName, boolean isGetter) {
        if (field == null) {
            JavaEncapsulateFieldHelper.$$$reportNull$$$0(14);
        }
        if (methodName == null) {
            JavaEncapsulateFieldHelper.$$$reportNull$$$0(15);
        }
        PsiMethod prototype = isGetter ? GenerateMembersUtil.generateGetterPrototype((PsiField)field) : GenerateMembersUtil.generateSetterPrototype((PsiField)field);
        try {
            prototype.setName(methodName);
            return prototype;
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 11, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethod";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/encapsulateFields/JavaEncapsulateFieldHelper";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/encapsulateFields/JavaEncapsulateFieldHelper";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableFields";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSetterName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestGetterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processUsage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createGetterCall";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodResolvable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getApplicableFields";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "suggestSetterName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "suggestGetterName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodPrototype";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 11, 13 -> new IllegalStateException(string);
        };
    }
}

