/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.IntroduceVariableUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.ExtractMethodSnapshot;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethod.newImpl.ExtractMethodHelper;
import com.intellij.refactoring.extractMethod.newImpl.MethodExtractor;
import com.intellij.refactoring.extractMethod.preview.ExtractMethodPreviewManager;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.duplicates.DuplicatesImpl;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtractMethodHandler
implements RefactoringActionHandler,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance(ExtractMethodHandler.class);

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            ExtractMethodHandler.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            ExtractMethodHandler.$$$reportNull$$$0(1);
        }
        if (dataContext != null) {
            PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            if (file != null && editor != null) {
                ExtractMethodHandler.invokeOnElements(project, editor, file, elements);
            }
        }
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            ExtractMethodHandler.$$$reportNull$$$0(2);
        }
        ExtractMethodHandler.selectAndPass(project, editor, file, selectedValue -> ExtractMethodHandler.invokeOnElements(project, editor, file, selectedValue));
    }

    public static void selectAndPass(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, final @NotNull Consumer<? super PsiElement[]> callback) {
        if (project == null) {
            ExtractMethodHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            ExtractMethodHandler.$$$reportNull$$$0(4);
        }
        if (file == null) {
            ExtractMethodHandler.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            ExtractMethodHandler.$$$reportNull$$$0(6);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (!editor.getSelectionModel().hasSelection()) {
            int offset = editor.getCaretModel().getOffset();
            List expressions = CommonJavaRefactoringUtil.collectExpressions((PsiFile)file, (Editor)editor, (int)offset, (boolean)true);
            if (expressions.isEmpty()) {
                editor.getSelectionModel().selectLineAtCaret();
            } else {
                if (expressions.size() == 1) {
                    callback.accept((PsiElement[])new PsiElement[]{(PsiElement)expressions.get(0)});
                    return;
                }
                IntroduceTargetChooser.showChooser((Editor)editor, (List)expressions, (Pass)new Pass<PsiExpression>(){

                    public void pass(PsiExpression psiExpression) {
                        callback.accept(new PsiElement[]{psiExpression});
                    }
                }, (Function)new PsiExpressionTrimRenderer.RenderFunction());
                return;
            }
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        callback.accept((PsiElement[])ExtractMethodHandler.getElements(project, editor, file));
    }

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        PsiElement[] elements;
        if (editor == null) {
            ExtractMethodHandler.$$$reportNull$$$0(7);
        }
        if (file == null) {
            ExtractMethodHandler.$$$reportNull$$$0(8);
        }
        if (dataContext == null) {
            ExtractMethodHandler.$$$reportNull$$$0(9);
        }
        return (elements = ExtractMethodHandler.getElements(file.getProject(), editor, file)) != null && elements.length > 0;
    }

    public static PsiElement[] getElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        SelectionModel selectionModel;
        if (project == null) {
            ExtractMethodHandler.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            ExtractMethodHandler.$$$reportNull$$$0(11);
        }
        if (file == null) {
            ExtractMethodHandler.$$$reportNull$$$0(12);
        }
        if ((selectionModel = editor.getSelectionModel()).hasSelection()) {
            PsiElement[] elements;
            int endOffset;
            int startOffset = selectionModel.getSelectionStart();
            PsiExpression expr = CodeInsightUtil.findExpressionInRange((PsiFile)file, (int)startOffset, (int)(endOffset = selectionModel.getSelectionEnd()));
            if (expr != null) {
                elements = new PsiElement[]{expr};
            } else {
                PsiType originalType;
                PsiExpression expression;
                elements = CodeInsightUtil.findStatementsInRange((PsiFile)file, (int)startOffset, (int)endOffset);
                if (elements.length == 0 && (expression = IntroduceVariableUtil.getSelectedExpression((Project)project, (PsiFile)file, (int)startOffset, (int)endOffset)) != null && IntroduceVariableUtil.getErrorMessage((PsiExpression)expression) == null && (originalType = CommonJavaRefactoringUtil.getTypeByExpressionWithExpectedType((PsiExpression)expression)) != null) {
                    elements = new PsiElement[]{expression};
                }
            }
            return elements;
        }
        List expressions = CommonJavaRefactoringUtil.collectExpressions((PsiFile)file, (Editor)editor, (int)editor.getCaretModel().getOffset());
        return expressions.toArray(PsiElement.EMPTY_ARRAY);
    }

    public static boolean canUseNewImpl(@NotNull Project project, PsiFile file, PsiElement @NotNull [] elements) {
        ExtractMethodProcessor processor;
        if (project == null) {
            ExtractMethodHandler.$$$reportNull$$$0(13);
        }
        if (elements == null) {
            ExtractMethodHandler.$$$reportNull$$$0(14);
        }
        if ((processor = ExtractMethodHandler.getProcessor(project, elements, file, false)) == null) {
            return true;
        }
        try {
            processor.prepare(null);
            processor.prepareVariablesAndName();
            processor.myMethodName = "extracted";
        }
        catch (PrepareFailedException e) {
            return true;
        }
        return processor.estimateDuplicatesCount() == 0 && !processor.myInputVariables.isFoldable();
    }

    public static void invokeOnElements(@NotNull Project project, Editor editor, PsiFile file, PsiElement @NotNull [] elements) {
        TextRange selection;
        if (project == null) {
            ExtractMethodHandler.$$$reportNull$$$0(15);
        }
        if (elements == null) {
            ExtractMethodHandler.$$$reportNull$$$0(16);
        }
        if ((selection = ExtractMethodHelper.findEditorSelection(editor)) == null && elements.length == 1) {
            selection = elements[0].getTextRange();
        }
        if (selection != null) {
            new MethodExtractor().doExtract(file, selection);
        }
    }

    private static boolean invokeOnElements(@NotNull Project project, @NotNull Editor editor, @NotNull ExtractMethodProcessor processor, boolean directTypes) {
        if (project == null) {
            ExtractMethodHandler.$$$reportNull$$$0(17);
        }
        if (editor == null) {
            ExtractMethodHandler.$$$reportNull$$$0(18);
        }
        if (processor == null) {
            ExtractMethodHandler.$$$reportNull$$$0(19);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)processor.getTargetClass().getContainingFile())) {
            return false;
        }
        processor.setPreviewSupported(true);
        if (processor.showDialog(directTypes)) {
            if (processor.isPreviewDuplicates()) {
                ExtractMethodHandler.previewExtractMethod(processor);
                return true;
            }
            ExtractMethodHandler.extractMethod(project, processor);
            DuplicatesImpl.processDuplicates(processor, project, editor);
            return true;
        }
        return false;
    }

    private static void previewExtractMethod(@NotNull ExtractMethodProcessor processor) {
        if (processor == null) {
            ExtractMethodHandler.$$$reportNull$$$0(20);
        }
        processor.previewRefactoring(null);
        ExtractMethodPreviewManager.getInstance(processor.getProject()).showPreview(processor);
    }

    public static void extractMethod(@NotNull Project project, @NotNull ExtractMethodProcessor processor) {
        if (project == null) {
            ExtractMethodHandler.$$$reportNull$$$0(21);
        }
        if (processor == null) {
            ExtractMethodHandler.$$$reportNull$$$0(22);
        }
        CommandProcessor.getInstance().executeCommand(project, () -> PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> ExtractMethodHandler.doRefactoring(project, processor)), ExtractMethodHandler.getRefactoringName(), null);
    }

    private static void doRefactoring(@NotNull Project project, @NotNull ExtractMethodProcessor processor) {
        if (project == null) {
            ExtractMethodHandler.$$$reportNull$$$0(23);
        }
        if (processor == null) {
            ExtractMethodHandler.$$$reportNull$$$0(24);
        }
        try {
            RefactoringEventData beforeData = new RefactoringEventData();
            beforeData.addElements(processor.myElements);
            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted("refactoring.extract.method", beforeData);
            processor.doRefactoring();
            RefactoringEventData data = new RefactoringEventData();
            data.addElement((PsiElement)processor.getExtractedMethod());
            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone("refactoring.extract.method", data);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    private static ExtractMethodProcessor getProcessor(PsiElement[] elements, Project project, PsiFile file, Editor editor, boolean showErrorMessages, @Nullable Consumer<? super ExtractMethodProcessor> pass) {
        if (elements == null || elements.length == 0) {
            if (showErrorMessages) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.a.set.of.statements.or.an.expression"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)ExtractMethodHandler.getRefactoringName(), (String)"refactoring.extractMethod");
            }
            return null;
        }
        for (PsiElement element : elements) {
            PsiStatement statement;
            if (element instanceof PsiStatement && JavaHighlightUtil.isSuperOrThisCall((PsiStatement)(statement = (PsiStatement)element), (boolean)true, (boolean)true)) {
                if (showErrorMessages) {
                    String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"selected.block.contains.invocation.of.another.class.constructor", (Object[])new Object[0]));
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)ExtractMethodHandler.getRefactoringName(), (String)"refactoring.extractMethod");
                }
                return null;
            }
            if (!(element instanceof PsiStatement) || PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class) != null) continue;
            if (showErrorMessages) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"selected.block.contains.statement.outside.of.class", (Object[])new Object[0]));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)ExtractMethodHandler.getRefactoringName(), (String)"refactoring.extractMethod");
            }
            return null;
        }
        String initialMethodName = Optional.ofNullable((ExtractMethodSnapshot)ExtractMethodSnapshot.SNAPSHOT_KEY.get((UserDataHolder)file)).map(s -> s.myMethodName).orElse("");
        ExtractMethodProcessor processor = new ExtractMethodProcessor(project, editor, elements, null, ExtractMethodHandler.getRefactoringName(), initialMethodName, "refactoring.extractMethod");
        processor.setShowErrorDialogs(showErrorMessages);
        try {
            if (!processor.prepare(pass)) {
                return null;
            }
        }
        catch (PrepareFailedException e) {
            if (showErrorMessages) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)ExtractMethodHandler.getRefactoringName(), (String)"refactoring.extractMethod");
                ExtractMethodHandler.highlightPrepareError(e, file, editor, project);
            }
            return null;
        }
        return processor;
    }

    public static void highlightPrepareError(PrepareFailedException e, PsiFile file, Editor editor, Project project) {
        if (e.getFile() == file) {
            TextRange textRange = e.getTextRange();
            HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
            highlightManager.addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
            LogicalPosition logicalPosition = editor.offsetToLogicalPosition(textRange.getStartOffset());
            editor.getScrollingModel().scrollTo(logicalPosition, ScrollType.MAKE_VISIBLE);
            WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
        }
    }

    @Nullable
    public static ExtractMethodProcessor getProcessor(Project project, PsiElement[] elements, PsiFile file, boolean openEditor) {
        return ExtractMethodHandler.getProcessor(elements, project, file, openEditor ? ExtractMethodHandler.openEditor(file) : null, false, null);
    }

    public static boolean invokeOnElements(Project project, @NotNull ExtractMethodProcessor processor, PsiFile file, boolean directTypes) {
        if (processor == null) {
            ExtractMethodHandler.$$$reportNull$$$0(25);
        }
        return ExtractMethodHandler.invokeOnElements(project, ExtractMethodHandler.openEditor(file), processor, directTypes);
    }

    @Nullable
    public static Editor openEditor(@NotNull PsiFile file) {
        if (file == null) {
            ExtractMethodHandler.$$$reportNull$$$0(26);
        }
        Project project = file.getProject();
        VirtualFile virtualFile = file.getVirtualFile();
        LOG.assertTrue(virtualFile != null);
        OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(project, virtualFile);
        return FileEditorManager.getInstance((Project)project).openTextEditor(fileDescriptor, false);
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"extract.method.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 19: 
            case 20: 
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethod/ExtractMethodHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "selectAndPass";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableForQuickList";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getElements";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "canUseNewImpl";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeOnElements";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "previewExtractMethod";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "extractMethod";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "doRefactoring";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "openEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

