/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AnonymousTargetClassPreselectionUtil;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.navigation.PsiTargetNavigator;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.java.JavaDfaListener;
import com.intellij.codeInspection.dataFlow.lang.DfaListener;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.redundantCast.RemoveRedundantCastUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowOptions;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.impl.source.codeStyle.JavaCodeStyleManagerImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.VariablesProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.IntroduceVariableUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.ControlFlowWrapper;
import com.intellij.refactoring.extractMethod.ExtractMethodDialog;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodSnapshot;
import com.intellij.refactoring.extractMethod.ExtractMethodUtil;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.extractMethod.ParametrizedDuplicates;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethod.ReusedLocalVariable;
import com.intellij.refactoring.extractMethod.ReusedLocalVariablesFinder;
import com.intellij.refactoring.extractMethod.SignatureSuggesterPreviewDialog;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectHandler;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringMessageDialog;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.refactoring.util.duplicates.DuplicatesFinder;
import com.intellij.refactoring.util.duplicates.Match;
import com.intellij.refactoring.util.duplicates.MatchProvider;
import com.intellij.refactoring.util.duplicates.MatchUtil;
import com.intellij.refactoring.util.duplicates.ReturnValue;
import com.intellij.refactoring.util.duplicates.VariableReturnValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.UniqueNameGenerator;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public class ExtractMethodProcessor
implements MatchProvider {
    private static final Logger LOG = Logger.getInstance(ExtractMethodProcessor.class);
    @TestOnly
    public static final Key<Boolean> SIGNATURE_CHANGE_ALLOWED = Key.create((String)"SignatureChangeAllowed");
    protected final Project myProject;
    private final Editor myEditor;
    protected final PsiElement[] myElements;
    private final PsiBlockStatement myEnclosingBlockStatement;
    private final PsiType myForcedReturnType;
    @NlsContexts.DialogTitle
    protected final String myRefactoringName;
    protected final String myInitialMethodName;
    private final String myHelpId;
    private final PsiManager myManager;
    private final PsiElementFactory myElementFactory;
    private final CodeStyleManager myStyleManager;
    private PsiExpression myExpression;
    private PsiElement myCodeFragmentMember;
    @NlsSafe
    protected String myMethodName;
    protected PsiType myReturnType;
    protected PsiTypeParameterList myTypeParameterList;
    protected VariableData[] myVariableDatum;
    protected PsiClassType[] myThrownExceptions;
    protected boolean myStatic;
    protected PsiClass myTargetClass;
    private PsiElement myAnchor;
    protected ControlFlowWrapper myControlFlowWrapper;
    protected InputVariables myInputVariables;
    protected PsiVariable[] myOutputVariables;
    protected PsiVariable myOutputVariable;
    protected PsiVariable myArtificialOutputVariable;
    private Collection<PsiStatement> myExitStatements;
    private boolean myHasReturnStatement;
    private boolean myHasReturnStatementOutput;
    protected boolean myHasExpressionOutput;
    private boolean myNeedChangeContext;
    private boolean myShowErrorDialogs = true;
    private boolean myIsPreviewSupported;
    private boolean myPreviewDuplicates;
    protected boolean myCanBeStatic;
    protected boolean myCanBeChainedConstructor;
    protected boolean myIsChainedConstructor;
    protected List<Match> myDuplicates;
    private ParametrizedDuplicates myParametrizedDuplicates;
    private ParametrizedDuplicates myExactDuplicates;
    @PsiModifier.ModifierConstant
    protected String myMethodVisibility = "private";
    protected boolean myGenerateConditionalExit;
    protected PsiStatement myFirstExitStatementCopy;
    protected PsiMethod myExtractedMethod;
    private PsiMethodCallExpression myMethodCall;
    private PsiBlockStatement myAddedToMethodCallLocation;
    protected boolean myNullConditionalCheck;
    protected boolean myNotNullConditionalCheck;
    protected Nullability myNullability;
    private final CodeStyleSettings myStyleSettings;

    public ExtractMethodProcessor(Project project, Editor editor, PsiElement[] elements, PsiType forcedReturnType, @NlsContexts.DialogTitle String refactoringName, String initialMethodName, String helpId) {
        this.myProject = project;
        this.myEditor = editor;
        if (elements.length != 1 || !(elements[0] instanceof PsiBlockStatement)) {
            if (elements.length == 1 && elements[0] instanceof PsiParenthesizedExpression) {
                PsiElement[] psiElementArray;
                PsiExpression expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)elements[0]));
                if (expression != null) {
                    PsiElement[] psiElementArray2 = new PsiElement[1];
                    psiElementArray = psiElementArray2;
                    psiElementArray2[0] = expression;
                } else {
                    psiElementArray = elements;
                }
                this.myElements = psiElementArray;
            } else {
                this.myElements = elements;
            }
            this.myEnclosingBlockStatement = null;
        } else {
            this.myEnclosingBlockStatement = (PsiBlockStatement)elements[0];
            PsiElement[] codeBlockChildren = this.myEnclosingBlockStatement.getCodeBlock().getChildren();
            this.myElements = ExtractMethodProcessor.processCodeBlockChildren(codeBlockChildren);
        }
        this.myForcedReturnType = forcedReturnType;
        this.myRefactoringName = refactoringName;
        this.myInitialMethodName = initialMethodName;
        this.myHelpId = helpId;
        this.myManager = PsiManager.getInstance((Project)this.myProject);
        this.myElementFactory = JavaPsiFacade.getElementFactory((Project)this.myManager.getProject());
        this.myStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
        this.myStyleSettings = editor != null ? CodeStyle.getSettings((Editor)editor) : CodeStyle.getSettings((PsiFile)elements[0].getContainingFile());
    }

    private static PsiElement[] processCodeBlockChildren(PsiElement[] codeBlockChildren) {
        PsiElement last;
        int resultLast = codeBlockChildren.length;
        if (codeBlockChildren.length == 0) {
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement first = codeBlockChildren[0];
        int resultStart = 0;
        if (PsiUtil.isJavaToken((PsiElement)first, (IElementType)JavaTokenType.LBRACE)) {
            ++resultStart;
        }
        if (PsiUtil.isJavaToken((PsiElement)(last = codeBlockChildren[codeBlockChildren.length - 1]), (IElementType)JavaTokenType.RBRACE)) {
            --resultLast;
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (int i = resultStart; i < resultLast; ++i) {
            PsiElement element = codeBlockChildren[i];
            if (element instanceof PsiWhiteSpace) continue;
            result.add(element);
        }
        return PsiUtilCore.toPsiElementArray(result);
    }

    public void setShowErrorDialogs(boolean showErrorDialogs) {
        this.myShowErrorDialogs = showErrorDialogs;
    }

    public void setPreviewSupported(boolean previewSupported) {
        this.myIsPreviewSupported = previewSupported;
    }

    public boolean isPreviewDuplicates() {
        return this.myPreviewDuplicates;
    }

    public void setChainedConstructor(boolean isChainedConstructor) {
        this.myIsChainedConstructor = isChainedConstructor;
    }

    public boolean prepare() throws PrepareFailedException {
        return this.prepare(null);
    }

    public boolean prepare(@Nullable Consumer<? super ExtractMethodProcessor> pass) throws PrepareFailedException {
        PsiElement codeFragment;
        block11: {
            PsiElement psiElement;
            if (this.myElements.length == 0) {
                return false;
            }
            this.myExpression = null;
            if (this.myElements.length == 1 && (psiElement = this.myElements[0]) instanceof PsiExpression) {
                PsiExpression expression = (PsiExpression)psiElement;
                if (expression instanceof PsiAssignmentExpression && expression.getParent() instanceof PsiExpressionStatement) {
                    this.myElements[0] = expression.getParent();
                } else {
                    this.myExpression = expression;
                }
            }
            codeFragment = ControlFlowUtil.findCodeFragment((PsiElement)this.myElements[0]);
            this.myCodeFragmentMember = (PsiElement)codeFragment.getUserData(ElementToWorkOn.PARENT);
            if (this.myCodeFragmentMember == null) {
                this.myCodeFragmentMember = codeFragment.getParent();
            }
            if (this.myCodeFragmentMember == null) {
                PsiElement context = codeFragment.getContext();
                LOG.assertTrue(context != null, (Object)("code fragment context is null: " + String.valueOf(codeFragment.getClass())));
                this.myCodeFragmentMember = ControlFlowUtil.findCodeFragment((PsiElement)context).getParent();
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)(this.myElements[0].isPhysical() ? this.myElements[0] : this.myCodeFragmentMember), PsiAnnotation.class) != null) {
                throw new PrepareFailedException(JavaRefactoringBundle.message((String)"extract.method.error.annotation.value", (Object[])new Object[0]), this.myElements[0]);
            }
            this.myControlFlowWrapper = new ControlFlowWrapper(codeFragment, this.myElements);
            try {
                this.myExitStatements = this.myControlFlowWrapper.prepareAndCheckExitStatements(this.myElements, codeFragment);
                if (this.myControlFlowWrapper.isGenerateConditionalExit()) {
                    this.myGenerateConditionalExit = true;
                } else {
                    this.myHasReturnStatement = this.myExpression == null && this.myControlFlowWrapper.isReturnPresentBetween();
                }
                this.myFirstExitStatementCopy = this.myControlFlowWrapper.getFirstExitStatementCopy();
            }
            catch (ControlFlowWrapper.ExitStatementsNotSameException e) {
                this.myExitStatements = this.myControlFlowWrapper.getExitStatements();
                this.myNotNullConditionalCheck = this.areAllExitPointsNotNull(this.getExpectedReturnType());
                if (this.myNotNullConditionalCheck) break block11;
                this.showMultipleExitPointsMessage();
                return false;
            }
        }
        this.myOutputVariables = this.myControlFlowWrapper.getOutputVariables();
        PsiClass defaultTargetClass = Optional.ofNullable(this.myElements[0].getContainingFile()).map(arg_0 -> ExtractMethodSnapshot.SNAPSHOT_KEY.get(arg_0)).map(snapshot -> snapshot.getTargetClass()).orElse(null);
        return this.chooseTargetClass(codeFragment, pass, defaultTargetClass);
    }

    private boolean checkExitPoints() throws PrepareFailedException {
        PsiPrimitiveType expressionType = null;
        if (this.myExpression != null) {
            if (this.myForcedReturnType != null) {
                expressionType = this.myForcedReturnType;
            } else {
                expressionType = CommonJavaRefactoringUtil.getTypeByExpressionWithExpectedType((PsiExpression)this.myExpression);
                if (expressionType == null && !(this.myExpression.getParent() instanceof PsiExpressionStatement)) {
                    expressionType = PsiType.getJavaLangObject((PsiManager)this.myExpression.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
                }
            }
        }
        if (expressionType == null) {
            expressionType = PsiTypes.voidType();
        }
        this.myHasExpressionOutput = !PsiTypes.voidType().equals((Object)expressionType);
        PsiType returnStatementType = this.getExpectedReturnType();
        boolean bl = this.myHasReturnStatementOutput = this.myHasReturnStatement && returnStatementType != null && !PsiTypes.voidType().equals((Object)returnStatementType);
        if (this.myGenerateConditionalExit && this.myOutputVariables.length == 1) {
            if (!(this.myOutputVariables[0].getType() instanceof PsiPrimitiveType)) {
                this.myNullConditionalCheck = this.isNullInferred(this.myOutputVariables[0].getName()) && this.getReturnsNullability(true);
            }
            this.myNotNullConditionalCheck = this.areAllExitPointsNotNull(returnStatementType);
        }
        if (!this.myHasReturnStatementOutput && this.checkOutputVariablesCount() && !this.myNullConditionalCheck && !this.myNotNullConditionalCheck) {
            this.showMultipleOutputMessage((PsiType)expressionType);
            return false;
        }
        PsiVariable psiVariable = this.myOutputVariable = this.myOutputVariables.length > 0 ? this.myOutputVariables[0] : null;
        this.myReturnType = this.myNotNullConditionalCheck ? (returnStatementType instanceof PsiPrimitiveType ? ((PsiPrimitiveType)returnStatementType).getBoxedType(this.myCodeFragmentMember) : returnStatementType) : (this.myHasReturnStatementOutput ? returnStatementType : (this.myOutputVariable != null ? this.myOutputVariable.getType() : (this.myGenerateConditionalExit ? PsiTypes.booleanType() : expressionType)));
        PsiElement container = PsiTreeUtil.getParentOfType((PsiElement)this.myElements[0], (Class[])new Class[]{PsiClass.class, PsiMethod.class});
        while (container instanceof PsiMethod && ((PsiMethod)container).getContainingClass() != this.myTargetClass) {
            container = PsiTreeUtil.getParentOfType((PsiElement)container, PsiMethod.class, (boolean)true);
        }
        if (container instanceof PsiMethod) {
            PsiElement[] elements = this.myElements;
            if (this.myExpression == null) {
                if (this.myOutputVariable != null) {
                    elements = (PsiElement[])ArrayUtil.append((Object[])this.myElements, (Object)this.myOutputVariable, PsiElement.class);
                }
                if (this.myCodeFragmentMember instanceof PsiMethod && this.myReturnType == ((PsiMethod)this.myCodeFragmentMember).getReturnType()) {
                    elements = (PsiElement[])ArrayUtil.append((Object[])this.myElements, (Object)((PsiMethod)this.myCodeFragmentMember).getReturnTypeElement(), PsiElement.class);
                }
            }
            this.myTypeParameterList = CommonJavaRefactoringUtil.createTypeParameterListWithUsedTypeParameters((PsiTypeParameterList)((PsiMethod)container).getTypeParameterList(), (PsiElement[])elements);
        }
        List exceptions = ExceptionUtil.getThrownCheckedExceptions((PsiElement[])this.myElements);
        this.myThrownExceptions = exceptions.toArray(PsiClassType.EMPTY_ARRAY);
        if (container instanceof PsiMethod) {
            this.checkLocalClasses((PsiMethod)container);
        }
        return true;
    }

    private PsiType getExpectedReturnType() {
        return this.myCodeFragmentMember instanceof PsiMethod ? ((PsiMethod)this.myCodeFragmentMember).getReturnType() : (this.myCodeFragmentMember instanceof PsiLambdaExpression ? LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)this.myCodeFragmentMember)) : null);
    }

    @Nullable
    protected PsiVariable getArtificialOutputVariable() {
        if (this.myOutputVariables.length == 0 && this.myExitStatements.isEmpty()) {
            if (this.myCanBeChainedConstructor) {
                final HashSet fields = new HashSet();
                for (PsiElement element : this.myElements) {
                    element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(this){

                        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                            if (expression == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            super.visitReferenceExpression(expression);
                            PsiElement resolve = expression.resolve();
                            if (resolve instanceof PsiField && ((PsiField)resolve).hasModifierProperty("final") && PsiUtil.isAccessedForWriting((PsiExpression)expression)) {
                                fields.add((PsiField)resolve);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/extractMethod/ExtractMethodProcessor$1", "visitReferenceExpression"));
                        }
                    });
                }
                if (!fields.isEmpty()) {
                    return fields.size() == 1 ? (PsiVariable)fields.iterator().next() : null;
                }
            }
            VariablesProcessor processor = new VariablesProcessor(true){

                protected boolean check(PsiVariable var, ResolveState state) {
                    return ExtractMethodProcessor.this.isDeclaredInside(var);
                }
            };
            PsiScopesUtil.treeWalkUp((PsiScopeProcessor)processor, (PsiElement)this.myElements[this.myElements.length - 1], (PsiElement)this.myCodeFragmentMember);
            if (processor.size() == 1) {
                return processor.getResult(0);
            }
        }
        return null;
    }

    private boolean areAllExitPointsNotNull(PsiType returnStatementType) {
        if (this.insertNotNullCheckIfPossible() && this.myControlFlowWrapper.getOutputVariables(false, 1).length == 0 && returnStatementType != null && !PsiTypes.voidType().equals((Object)returnStatementType)) {
            return this.getReturnsNullability(false);
        }
        return false;
    }

    private boolean getReturnsNullability(final boolean nullsExpected) {
        PsiElement body = null;
        if (this.myCodeFragmentMember instanceof PsiParameterListOwner) {
            body = ((PsiParameterListOwner)this.myCodeFragmentMember).getBody();
        }
        if (body == null) {
            return false;
        }
        final Set returnedExpressions = StreamEx.of(this.myExitStatements).select(PsiReturnStatement.class).map(PsiReturnStatement::getReturnValue).nonNull().toSet();
        Iterator it = returnedExpressions.iterator();
        while (it.hasNext()) {
            PsiType type = ((PsiExpression)it.next()).getType();
            if (nullsExpected) {
                if (type == PsiTypes.nullType()) {
                    it.remove();
                    continue;
                }
                if (!(type instanceof PsiPrimitiveType)) continue;
                return false;
            }
            if (type == PsiTypes.nullType()) {
                return false;
            }
            if (!(type instanceof PsiPrimitiveType)) continue;
            it.remove();
        }
        if (returnedExpressions.isEmpty()) {
            return true;
        }
        final StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner(this.myProject);
        JavaDfaListener returnChecker = new JavaDfaListener(){

            public void beforeValueReturn(@NotNull DfaValue value, @Nullable PsiExpression expression, @NotNull PsiElement context, @NotNull DfaMemoryState state) {
                if (value == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (state == null) {
                    3.$$$reportNull$$$0(2);
                }
                if (context == ExtractMethodProcessor.this.myCodeFragmentMember && expression != null && returnedExpressions.stream().anyMatch(ret -> PsiTreeUtil.isAncestor((PsiElement)ret, (PsiElement)expression, (boolean)false))) {
                    boolean result;
                    DfaNullability nullability = DfaNullability.fromDfType((DfType)state.getDfType(value));
                    boolean bl = result = nullability == (nullsExpected ? DfaNullability.NULL : DfaNullability.NOT_NULL);
                    if (!result) {
                        dfaRunner.cancel();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/refactoring/extractMethod/ExtractMethodProcessor$3";
                objectArray[2] = "beforeValueReturn";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        return dfaRunner.analyzeMethod(body, (DfaListener)returnChecker) == RunnerResult.OK;
    }

    protected boolean insertNotNullCheckIfPossible() {
        return true;
    }

    private boolean isNullInferred(String exprText) {
        PsiCodeBlock block = this.myElementFactory.createCodeBlockFromText("{}", this.myElements[0]);
        for (PsiElement element : this.myElements) {
            block.add(element);
        }
        PsiReturnStatement statementFromText = (PsiReturnStatement)this.myElementFactory.createStatementFromText("return " + exprText + ";", null);
        return ExtractMethodProcessor.inferNullability(block, Objects.requireNonNull((statementFromText = (PsiReturnStatement)block.add((PsiElement)statementFromText)).getReturnValue())) == Nullability.NOT_NULL;
    }

    private static Nullability inferNullability(@NotNull PsiCodeBlock block, final @NotNull PsiExpression expr) {
        var interceptor;
        StandardDataFlowRunner dfaRunner;
        RunnerResult rc;
        if (block == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(0);
        }
        if (expr == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(1);
        }
        return (rc = (dfaRunner = new StandardDataFlowRunner(block.getProject())).analyzeMethod((PsiElement)block, (DfaListener)(interceptor = new JavaDfaListener(){
            DfaNullability myNullability = DfaNullability.NOT_NULL;
            boolean myVisited = false;

            public void beforeExpressionPush(@NotNull DfaValue value, @NotNull PsiExpression expression, @NotNull DfaMemoryState state) {
                if (value == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (expression == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (state == null) {
                    4.$$$reportNull$$$0(2);
                }
                if (expression == expr) {
                    this.myVisited = true;
                    this.myNullability = this.myNullability.unite(DfaNullability.fromDfType((DfType)state.getDfType(value)));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/refactoring/extractMethod/ExtractMethodProcessor$4";
                objectArray[2] = "beforeExpressionPush";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }))) == RunnerResult.OK && interceptor.myVisited ? DfaNullability.toNullability((DfaNullability)interceptor.myNullability) : Nullability.UNKNOWN;
    }

    protected boolean checkOutputVariablesCount() {
        int outputCount = (this.myHasExpressionOutput ? 1 : 0) + (this.myGenerateConditionalExit ? 1 : 0) + this.myOutputVariables.length;
        return outputCount > 1;
    }

    private void checkCanBeChainedConstructor() {
        PsiElement psiElement = this.myCodeFragmentMember;
        if (!(psiElement instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)psiElement;
        if (!method.isConstructor() || !PsiTypes.voidType().equals((Object)this.myReturnType)) {
            return;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return;
        }
        PsiStatement[] psiStatements = body.getStatements();
        if (psiStatements.length > 0 && this.myElements[0] == psiStatements[0]) {
            this.myCanBeChainedConstructor = true;
        }
    }

    private void checkLocalClasses(PsiMethod container) throws PrepareFailedException {
        final ArrayList localClasses = new ArrayList();
        container.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(this){

            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    5.$$$reportNull$$$0(0);
                }
                localClasses.add(aClass);
            }

            public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
                if (aClass == null) {
                    5.$$$reportNull$$$0(1);
                }
                this.visitElement((PsiElement)aClass);
            }

            public void visitTypeParameter(@NotNull PsiTypeParameter classParameter) {
                if (classParameter == null) {
                    5.$$$reportNull$$$0(2);
                }
                this.visitElement((PsiElement)classParameter);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classParameter";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/refactoring/extractMethod/ExtractMethodProcessor$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAnonymousClass";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitTypeParameter";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        for (PsiClass localClass : localClasses) {
            boolean classExtracted = this.isExtractedElement((PsiElement)localClass);
            List extractedReferences = Collections.synchronizedList(new ArrayList());
            List remainingReferences = Collections.synchronizedList(new ArrayList());
            ReferencesSearch.search((PsiElement)localClass).forEach(psiReference -> {
                PsiElement element = psiReference.getElement();
                boolean elementExtracted = this.isExtractedElement(element);
                if (elementExtracted && !classExtracted) {
                    extractedReferences.add(element);
                    return false;
                }
                if (!elementExtracted && classExtracted) {
                    remainingReferences.add(element);
                    return false;
                }
                return true;
            });
            if (!extractedReferences.isEmpty()) {
                throw new PrepareFailedException(JavaRefactoringBundle.message((String)"extract.method.error.local.class.defined.outside", (Object[])new Object[0]), (PsiElement)extractedReferences.get(0));
            }
            if (!remainingReferences.isEmpty()) {
                throw new PrepareFailedException(JavaRefactoringBundle.message((String)"extract.method.error.local.class.used.outside", (Object[])new Object[0]), (PsiElement)remainingReferences.get(0));
            }
            if (!classExtracted) continue;
            for (PsiVariable variable : this.myControlFlowWrapper.getUsedVariables()) {
                if (!this.isDeclaredInside(variable) || variable.equals((Object)this.myOutputVariable) || PsiUtil.resolveClassInType((PsiType)variable.getType()) != localClass) continue;
                throw new PrepareFailedException(JavaRefactoringBundle.message((String)"extract.method.error.local.class.variable.used.outside", (Object[])new Object[0]), (PsiElement)variable);
            }
        }
    }

    private boolean isExtractedElement(PsiElement element) {
        boolean isExtracted = false;
        for (PsiElement psiElement : this.myElements) {
            if (!PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)element, (boolean)false)) continue;
            isExtracted = true;
            break;
        }
        return isExtracted;
    }

    private boolean shouldBeStatic() {
        for (PsiElement element : this.myElements) {
            PsiExpressionStatement statement = (PsiExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpressionStatement.class);
            if (statement == null || !JavaHighlightUtil.isSuperOrThisCall((PsiStatement)statement, (boolean)true, (boolean)true)) continue;
            return true;
        }
        PsiElement codeFragmentMember = this.myCodeFragmentMember;
        while (codeFragmentMember != null && PsiTreeUtil.isAncestor((PsiElement)this.myTargetClass, (PsiElement)codeFragmentMember, (boolean)true)) {
            if (codeFragmentMember instanceof PsiModifierListOwner && ((PsiModifierListOwner)codeFragmentMember).hasModifierProperty("static")) {
                return true;
            }
            codeFragmentMember = PsiTreeUtil.getParentOfType((PsiElement)codeFragmentMember, PsiModifierListOwner.class, (boolean)true);
        }
        return false;
    }

    public boolean showDialog(boolean direct) {
        AbstractExtractDialog dialog = this.createExtractMethodDialog(direct);
        dialog.show();
        if (dialog.isOK()) {
            this.apply(dialog);
            return true;
        }
        return false;
    }

    protected void apply(AbstractExtractDialog dialog) {
        this.myMethodName = dialog.getChosenMethodName();
        this.myVariableDatum = dialog.getChosenParameters();
        this.myStatic = this.isStatic() || dialog.isMakeStatic();
        this.myIsChainedConstructor = dialog.isChainedConstructor();
        this.myMethodVisibility = dialog.getVisibility();
        PsiType returnType = dialog.getReturnType();
        if (returnType != null) {
            this.myReturnType = returnType;
        }
        this.myPreviewDuplicates = dialog.isPreviewUsages();
    }

    protected AbstractExtractDialog createExtractMethodDialog(final boolean direct) {
        this.setDataFromInputVariables();
        this.myNullability = this.initNullability();
        this.myArtificialOutputVariable = PsiTypes.voidType().equals((Object)this.myReturnType) ? this.getArtificialOutputVariable() : null;
        PsiType returnType = this.myArtificialOutputVariable != null ? this.myArtificialOutputVariable.getType() : this.myReturnType;
        return new ExtractMethodDialog(this.myProject, this.myTargetClass, this.myInputVariables, returnType, this.getTypeParameterList(), (PsiType[])this.getThrownExceptions(), this.isStatic(), this.isCanBeStatic(), this.myCanBeChainedConstructor, this.myRefactoringName, this.myHelpId, this.myNullability, this.myElements, this::estimateDuplicatesCount){

            @Override
            protected boolean areTypesDirected() {
                return direct;
            }

            @Override
            protected String[] suggestMethodNames() {
                return ExtractMethodProcessor.this.suggestInitialMethodName();
            }

            @Override
            protected PsiExpression[] findOccurrences() {
                return ExtractMethodProcessor.this.findOccurrences();
            }

            @Override
            protected boolean isOutputVariable(PsiVariable var) {
                return ExtractMethodProcessor.this.isOutputVariable(var);
            }

            @Override
            protected boolean isVoidReturn() {
                return ExtractMethodProcessor.this.myArtificialOutputVariable != null && !(ExtractMethodProcessor.this.myArtificialOutputVariable instanceof PsiField);
            }

            @Override
            protected void checkMethodConflicts(MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
                super.checkMethodConflicts(conflicts);
                VariableData[] parameters = this.getChosenParameters();
                final HashMap vars = new HashMap();
                for (PsiElement psiElement : ExtractMethodProcessor.this.myElements) {
                    psiElement.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(this){

                        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
                            if (variable == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            super.visitLocalVariable(variable);
                            vars.put(variable.getName(), variable);
                        }

                        public void visitClass(@NotNull PsiClass aClass) {
                            if (aClass == null) {
                                1.$$$reportNull$$$0(1);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "variable";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "aClass";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/refactoring/extractMethod/ExtractMethodProcessor$6$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitLocalVariable";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitClass";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }
                for (PsiElement psiElement : parameters) {
                    String paramName = psiElement.name;
                    PsiLocalVariable variable = (PsiLocalVariable)vars.get(paramName);
                    if (variable == null) continue;
                    conflicts.putValue((Object)variable, (Object)JavaRefactoringBundle.message((String)"extract.method.conflict.variable", (Object[])new Object[]{paramName}));
                }
            }

            @Override
            protected boolean hasPreviewButton() {
                return ExtractMethodProcessor.this.myIsPreviewSupported;
            }
        };
    }

    public void setDataFromInputVariables() {
        List variables = this.myInputVariables.getInputVariables();
        this.myVariableDatum = variables.toArray(new VariableData[0]);
    }

    public PsiExpression[] findOccurrences() {
        if (this.myExpression != null) {
            return new PsiExpression[]{this.myExpression};
        }
        if (this.myOutputVariable != null) {
            PsiElement scope = this.myOutputVariable instanceof PsiLocalVariable ? CommonJavaRefactoringUtil.getVariableScope((PsiLocalVariable)((PsiLocalVariable)this.myOutputVariable)) : PsiTreeUtil.findCommonParent((PsiElement[])this.myElements);
            return CodeInsightUtil.findReferenceExpressions((PsiElement)scope, (PsiElement)this.myOutputVariable);
        }
        List filter = ContainerUtil.filter(this.myExitStatements, statement -> statement instanceof PsiReturnStatement && ((PsiReturnStatement)statement).getReturnValue() != null);
        List map = ContainerUtil.map((Collection)filter, statement -> ((PsiReturnStatement)statement).getReturnValue());
        return map.toArray(PsiExpression.EMPTY_ARRAY);
    }

    private Nullability initNullability() {
        if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.ANNOTATIONS, (PsiElement)this.myElements[0]) || PsiUtil.resolveClassInType((PsiType)this.myReturnType) == null) {
            return null;
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)this.myProject);
        String defaultAnnotation = manager.getDefaultAnnotation(Nullability.NULLABLE, this.myElements[0]);
        PsiClass nullableAnnotationClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(defaultAnnotation, this.myElements[0].getResolveScope());
        if (nullableAnnotationClass != null) {
            PsiElement elementInCopy = this.myTargetClass.getContainingFile().copy().findElementAt(this.myTargetClass.getTextOffset());
            PsiClass classCopy = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)elementInCopy, PsiClass.class);
            if (classCopy == null) {
                return null;
            }
            PsiMethod emptyMethod = (PsiMethod)classCopy.addAfter((PsiElement)this.generateEmptyMethod("name", null), classCopy.getLBrace());
            this.prepareMethodBody(emptyMethod, false);
            if (this.myNotNullConditionalCheck || this.myNullConditionalCheck) {
                return Nullability.NULLABLE;
            }
            return DfaUtil.inferMethodNullability((PsiMethod)emptyMethod);
        }
        return null;
    }

    protected String[] suggestInitialMethodName() {
        if (StringUtil.isEmpty((String)this.myInitialMethodName)) {
            LinkedHashSet<String> initialMethodNames = new LinkedHashSet<String>();
            JavaCodeStyleManagerImpl codeStyleManager = (JavaCodeStyleManagerImpl)JavaCodeStyleManager.getInstance((Project)this.myProject);
            if (this.myExpression != null || !(this.myReturnType instanceof PsiPrimitiveType)) {
                String[] names;
                for (String name : names = codeStyleManager.suggestVariableName((VariableKind)VariableKind.FIELD, null, (PsiExpression)this.myExpression, (PsiType)this.myReturnType).names) {
                    initialMethodNames.add(codeStyleManager.variableNameToPropertyName(name, VariableKind.FIELD));
                }
            }
            if (this.myOutputVariable != null) {
                VariableKind outKind = codeStyleManager.getVariableKind(this.myOutputVariable);
                SuggestedNameInfo nameInfo = codeStyleManager.suggestVariableName(VariableKind.FIELD, codeStyleManager.variableNameToPropertyName(this.myOutputVariable.getName(), outKind), null, this.myOutputVariable.getType());
                for (String name : nameInfo.names) {
                    initialMethodNames.add(codeStyleManager.variableNameToPropertyName(name, VariableKind.FIELD));
                }
            }
            String nameByComment = this.getNameByComment();
            PsiField field = JavaPsiFacade.getElementFactory((Project)this.myProject).createField("fieldNameToReplace", this.myReturnType instanceof PsiEllipsisType ? ((PsiEllipsisType)this.myReturnType).toArrayType() : this.myReturnType);
            ArrayList getters = new ArrayList(ContainerUtil.map(initialMethodNames, propertyName -> {
                if (!PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(propertyName)) {
                    LOG.info(propertyName + "; " + String.valueOf(this.myExpression));
                    return null;
                }
                field.setName(propertyName);
                return GenerateMembersUtil.suggestGetterName((PsiField)field);
            }));
            ContainerUtil.addIfNotNull(getters, (Object)nameByComment);
            return ArrayUtilRt.toStringArray(getters);
        }
        return new String[]{this.myInitialMethodName};
    }

    private String getNameByComment() {
        PsiElement prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)this.myElements[0]);
        if (prevSibling instanceof PsiComment && ((PsiComment)prevSibling).getTokenType() == JavaTokenType.END_OF_LINE_COMMENT) {
            String text = StringUtil.decapitalize((String)StringUtil.capitalizeWords((String)prevSibling.getText().trim().substring(2), (boolean)true)).replaceAll(" ", "");
            if (PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(text) && text.length() < 20) {
                return text;
            }
        }
        return null;
    }

    public boolean isOutputVariable(PsiVariable var) {
        return ArrayUtil.find((Object[])this.myOutputVariables, (Object)var) != -1;
    }

    public boolean showDialog() {
        return this.showDialog(true);
    }

    @TestOnly
    public void testRun() throws IncorrectOperationException {
        this.testPrepare();
        this.prepareNullability();
        ExtractMethodHandler.extractMethod(this.myProject, this);
    }

    public void prepareNullability() {
        this.myNullability = this.initNullability();
    }

    @TestOnly
    public void testPrepare() {
        this.prepareVariablesAndName();
    }

    public void prepareVariablesAndName() {
        this.myInputVariables.setFoldingAvailable(this.myInputVariables.isFoldingSelectedByDefault());
        this.myMethodName = this.myInitialMethodName;
        this.myVariableDatum = new VariableData[this.myInputVariables.getInputVariables().size()];
        for (int i = 0; i < this.myInputVariables.getInputVariables().size(); ++i) {
            this.myVariableDatum[i] = (VariableData)this.myInputVariables.getInputVariables().get(i);
        }
    }

    public void setTargetClass(@Nullable PsiClass targetClass) {
        if (targetClass != null) {
            this.myTargetClass = targetClass;
            this.myNeedChangeContext = true;
        }
    }

    @TestOnly
    public void testPrepare(PsiType returnType, boolean makeStatic) throws PrepareFailedException {
        if (makeStatic) {
            if (!this.isCanBeStatic()) {
                throw new PrepareFailedException(JavaRefactoringBundle.message((String)"extract.method.error.make.static", (Object[])new Object[0]), this.myElements[0]);
            }
            this.myInputVariables.setPassFields(true);
            this.myStatic = true;
        }
        if (PsiTypes.voidType().equals((Object)this.myReturnType)) {
            this.myArtificialOutputVariable = this.getArtificialOutputVariable();
        }
        this.testPrepare();
        if (returnType != null) {
            this.myReturnType = returnType;
        }
    }

    @TestOnly
    public void doNotPassParameter(int i) {
        this.myVariableDatum[i].passAsParameter = false;
    }

    @TestOnly
    public void changeParamName(int i, String param) {
        this.myVariableDatum[i].name = param;
    }

    public void doRefactoring() throws IncorrectOperationException {
        LogicalPosition pos1;
        this.initDuplicates(null);
        this.chooseAnchor();
        if (this.myEditor != null) {
            int col = this.myEditor.getCaretModel().getLogicalPosition().column;
            int line = this.myEditor.getCaretModel().getLogicalPosition().line;
            pos1 = new LogicalPosition(line, col);
            LogicalPosition pos = new LogicalPosition(0, 0);
            this.myEditor.getCaretModel().moveToLogicalPosition(pos);
        } else {
            pos1 = null;
        }
        LocalSearchScope processConflictsScope = this.myMethodVisibility.equals("private") ? new LocalSearchScope((PsiElement)this.myTargetClass) : GlobalSearchScope.projectScope((Project)this.myProject);
        HashMap overloadsResolveMap = new HashMap();
        Runnable collectOverloads = () -> this.lambda$doRefactoring$6((SearchScope)processConflictsScope, overloadsResolveMap);
        Runnable extract2 = () -> {
            this.doExtract();
            ExtractMethodUtil.decodeOverloadTargets((Map)overloadsResolveMap, (PsiMethod)this.myExtractedMethod, (PsiElement)this.myCodeFragmentMember);
        };
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            collectOverloads.run();
            extract2.run();
        } else {
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(collectOverloads, JavaRefactoringBundle.message((String)"collect.overloads", (Object[])new Object[0]), true, this.myProject)) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(extract2);
        }
        if (this.myEditor != null) {
            this.myEditor.getCaretModel().moveToLogicalPosition(pos1);
            int offset = this.myMethodCall.getMethodExpression().getTextRange().getStartOffset();
            this.myEditor.getCaretModel().moveToOffset(offset);
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            this.myEditor.getSelectionModel().removeSelection();
        }
    }

    public void previewRefactoring(@Nullable @Unmodifiable Set<? extends TextRange> textRanges) {
        this.initDuplicates(textRanges);
        this.chooseAnchor();
    }

    protected void initDuplicates(@Nullable @Unmodifiable Set<? extends TextRange> textRanges) {
        this.myParametrizedDuplicates = ParametrizedDuplicates.findDuplicates(this, DuplicatesFinder.MatchType.PARAMETRIZED, textRanges);
        if (this.myParametrizedDuplicates != null && !this.myParametrizedDuplicates.isEmpty()) {
            this.myExactDuplicates = ParametrizedDuplicates.findDuplicates(this, DuplicatesFinder.MatchType.EXACT, textRanges);
        }
        this.myDuplicates = new ArrayList<Match>();
    }

    protected int estimateDuplicatesCount() {
        List<Object> parameters;
        VariableReturnValue value;
        PsiElement[] elements = this.getFilteredElements();
        if (this.myExpression != null) {
            value = null;
            parameters = Collections.emptyList();
        } else if (elements.length != 0) {
            value = this.myOutputVariable != null ? new VariableReturnValue(this.myOutputVariable) : null;
            parameters = Arrays.asList(this.myOutputVariables);
        } else {
            return 0;
        }
        DuplicatesFinder finder = new DuplicatesFinder(elements, this.myInputVariables.copy(), (ReturnValue)value, parameters);
        List myDuplicates = finder.findDuplicates((PsiElement)this.myTargetClass);
        if (!ContainerUtil.isEmpty((Collection)myDuplicates)) {
            return myDuplicates.size();
        }
        ParametrizedDuplicates parametrizedDuplicates = ParametrizedDuplicates.findDuplicates(this, DuplicatesFinder.MatchType.PARAMETRIZED, null);
        if (parametrizedDuplicates != null) {
            List<Match> duplicates = parametrizedDuplicates.getDuplicates();
            return duplicates != null ? duplicates.size() : 0;
        }
        return 0;
    }

    private PsiElement @NotNull [] getFilteredElements() {
        PsiElement[] psiElementArray = (PsiElement[])((StreamEx)StreamEx.of((Object[])this.myElements).filter(e -> !(e instanceof PsiWhiteSpace) && !(e instanceof PsiComment) && !(e instanceof PsiEmptyStatement))).toArray((Object[])PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    public void doExtract() throws IncorrectOperationException {
        PsiMethod newMethod = this.generateEmptyMethod();
        this.myExpression = this.myInputVariables.replaceWrappedReferences(this.myElements, this.myExpression);
        this.renameInputVariables();
        LOG.assertTrue(this.myElements[0].isValid());
        PsiCodeBlock body = newMethod.getBody();
        this.myMethodCall = this.generateMethodCall(null, true, (PsiElement)this.myExpression);
        LOG.assertTrue(this.myElements[0].isValid());
        PsiStatement exitStatementCopy = this.prepareMethodBody(newMethod, true);
        if (this.myExpression == null) {
            if (this.isNeedToChangeCallContext()) {
                for (PsiElement element : this.myElements) {
                    ChangeContextUtil.encodeContextInfo((PsiElement)element, (boolean)false);
                }
            }
            if (this.myNullConditionalCheck) {
                varName = this.myOutputVariable.getName();
                if (this.isDeclaredInside(this.myOutputVariable)) {
                    this.declareVariableAtMethodCallLocation(varName);
                } else {
                    PsiExpressionStatement assignmentExpression = (PsiExpressionStatement)this.myElementFactory.createStatementFromText(varName + "=x;", null);
                    assignmentExpression = (PsiExpressionStatement)this.addToMethodCallLocation((PsiStatement)assignmentExpression);
                    this.myMethodCall = (PsiMethodCallExpression)((PsiAssignmentExpression)assignmentExpression.getExpression()).getRExpression().replace((PsiElement)this.myMethodCall);
                }
                this.declareNecessaryVariablesAfterCall(this.myOutputVariable);
                PsiIfStatement ifStatement = this.myHasReturnStatementOutput ? (PsiIfStatement)this.myElementFactory.createStatementFromText("if (" + varName + "==null) return null;", null) : (this.myGenerateConditionalExit ? this.generateConditionalExitStatement(varName) : (PsiIfStatement)this.myElementFactory.createStatementFromText("if (" + varName + "==null) return;", null));
                ifStatement = (PsiIfStatement)this.addToMethodCallLocation((PsiStatement)ifStatement);
                CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)ifStatement);
            } else if (this.myNotNullConditionalCheck) {
                varName = this.myOutputVariable != null ? this.myOutputVariable.getName() : "x";
                varName = this.declareVariableAtMethodCallLocation(varName, (PsiType)(this.myReturnType instanceof PsiPrimitiveType ? ((PsiPrimitiveType)this.myReturnType).getBoxedType(this.myCodeFragmentMember) : this.myReturnType));
                this.addToMethodCallLocation(this.generateNotNullConditionalStatement(varName));
                this.declareVariableReusedAfterCall(this.myOutputVariable);
            } else if (this.myGenerateConditionalExit) {
                PsiIfStatement ifStatement = (PsiIfStatement)this.myElementFactory.createStatementFromText("if (a) b;", null);
                ifStatement = (PsiIfStatement)this.addToMethodCallLocation((PsiStatement)ifStatement);
                this.myMethodCall = (PsiMethodCallExpression)ifStatement.getCondition().replace((PsiElement)this.myMethodCall);
                this.myFirstExitStatementCopy = (PsiStatement)ifStatement.getThenBranch().replace((PsiElement)this.myFirstExitStatementCopy);
                CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)ifStatement);
            } else if (this.myOutputVariable != null || this.isArtificialOutputUsed()) {
                String name;
                boolean toDeclare = this.isArtificialOutputUsed() ? !(this.myArtificialOutputVariable instanceof PsiField) : this.isDeclaredInside(this.myOutputVariable);
                String string = name = this.isArtificialOutputUsed() ? this.myArtificialOutputVariable.getName() : this.myOutputVariable.getName();
                if (!toDeclare) {
                    PsiExpressionStatement statement = (PsiExpressionStatement)this.myElementFactory.createStatementFromText(name + "=x;", null);
                    statement = (PsiExpressionStatement)this.myStyleManager.reformat((PsiElement)statement);
                    statement = (PsiExpressionStatement)this.addToMethodCallLocation((PsiStatement)statement);
                    PsiAssignmentExpression assignment = (PsiAssignmentExpression)statement.getExpression();
                    this.myMethodCall = (PsiMethodCallExpression)assignment.getRExpression().replace((PsiElement)this.myMethodCall);
                } else {
                    this.declareVariableAtMethodCallLocation(name);
                }
            } else if (this.myHasReturnStatementOutput) {
                statement = this.myElementFactory.createStatementFromText("return x;", null);
                statement = (PsiStatement)this.addToMethodCallLocation(statement);
                this.myMethodCall = (PsiMethodCallExpression)((PsiReturnStatement)statement).getReturnValue().replace((PsiElement)this.myMethodCall);
            } else {
                statement = this.myElementFactory.createStatementFromText("x();", null);
                statement = (PsiStatement)this.addToMethodCallLocation(statement);
                this.myMethodCall = (PsiMethodCallExpression)((PsiExpressionStatement)statement).getExpression().replace((PsiElement)this.myMethodCall);
            }
            if (this.myHasReturnStatement && !this.myHasReturnStatementOutput && !this.hasNormalExit()) {
                PsiStatement statement = this.myElementFactory.createStatementFromText("return;", null);
                this.addToMethodCallLocation(statement);
            } else if (!this.myGenerateConditionalExit && exitStatementCopy != null) {
                this.addToMethodCallLocation(exitStatementCopy);
            }
            if (!this.myNullConditionalCheck && !this.myNotNullConditionalCheck) {
                this.declareNecessaryVariablesAfterCall(this.myOutputVariable);
            }
            this.deleteExtracted();
        } else {
            PsiExpression expression2Replace = this.expressionToReplace(this.myExpression);
            this.myExpression = (PsiExpression)IntroduceVariableUtil.replace((PsiExpression)expression2Replace, (PsiExpression)this.myMethodCall, (Project)this.myProject);
            this.myMethodCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myExpression.findElementAt(this.myExpression.getText().indexOf(this.myMethodCall.getText())), PsiMethodCallExpression.class);
            this.declareNecessaryVariablesAfterCall(this.myOutputVariable);
        }
        if (this.myAnchor instanceof PsiField) {
            ((PsiField)this.myAnchor).normalizeDeclaration();
        }
        this.adjustFinalParameters(newMethod);
        int i = 0;
        for (VariableData data : this.myVariableDatum) {
            if (!data.passAsParameter) continue;
            PsiParameter psiParameter = newMethod.getParameterList().getParameters()[i++];
            PsiType paramType = psiParameter.getType();
            for (PsiReference reference : ReferencesSearch.search((PsiElement)psiParameter, (SearchScope)new LocalSearchScope((PsiElement)body)).asIterable()) {
                PsiTypeCastExpression typeCastExpression;
                PsiTypeElement castType;
                PsiElement element = reference.getElement();
                PsiElement parent = element.getParent();
                if (!(parent instanceof PsiTypeCastExpression) || (castType = (typeCastExpression = (PsiTypeCastExpression)parent).getCastType()) == null || !Comparing.equal((Object)castType.getType(), (Object)paramType)) continue;
                RemoveRedundantCastUtil.removeCast((PsiTypeCastExpression)typeCastExpression);
            }
        }
        if (this.myNullability != null && PsiUtil.resolveClassInType((PsiType)newMethod.getReturnType()) != null && PropertiesComponent.getInstance((Project)this.myProject).getBoolean("extractMethod.generateAnnotations", true)) {
            NullableNotNullManager nullManager = NullableNotNullManager.getInstance((Project)this.myProject);
            switch (this.myNullability) {
                case NOT_NULL: {
                    this.updateAnnotations((PsiModifierListOwner)newMethod, nullManager.getNullables(), nullManager.getDefaultAnnotation(this.myNullability, (PsiElement)this.myTargetClass), nullManager.getNotNulls());
                    break;
                }
                case NULLABLE: {
                    this.updateAnnotations((PsiModifierListOwner)newMethod, nullManager.getNotNulls(), nullManager.getDefaultAnnotation(this.myNullability, (PsiElement)this.myTargetClass), nullManager.getNullables());
                    break;
                }
            }
        }
        this.myExtractedMethod = this.addExtractedMethod(newMethod);
        if (this.isNeedToChangeCallContext()) {
            ChangeContextUtil.decodeContextInfo((PsiElement)this.myExtractedMethod, (PsiClass)this.myTargetClass, (PsiExpression)RefactoringChangeUtil.createThisExpression((PsiManager)this.myManager, null));
            if (this.myMethodCall.resolveMethod() != this.myExtractedMethod) {
                PsiReferenceExpression methodExpression;
                RefactoringChangeUtil.qualifyReference((PsiReferenceExpression)methodExpression, (PsiMember)this.myExtractedMethod, (PsiClass)(PsiUtil.getEnclosingStaticElement((PsiElement)(methodExpression = this.myMethodCall.getMethodExpression()), (PsiClass)this.myTargetClass) != null ? this.myTargetClass : null));
            }
        }
    }

    @NotNull
    private PsiIfStatement generateConditionalExitStatement(String varName) {
        if (this.myFirstExitStatementCopy instanceof PsiReturnStatement && ((PsiReturnStatement)this.myFirstExitStatementCopy).getReturnValue() != null) {
            PsiIfStatement psiIfStatement = (PsiIfStatement)this.myElementFactory.createStatementFromText("if (" + varName + "==null) return null;", null);
            if (psiIfStatement == null) {
                ExtractMethodProcessor.$$$reportNull$$$0(3);
            }
            return psiIfStatement;
        }
        PsiIfStatement psiIfStatement = (PsiIfStatement)this.myElementFactory.createStatementFromText("if (" + varName + "==null) " + this.myFirstExitStatementCopy.getText(), null);
        if (psiIfStatement == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(4);
        }
        return psiIfStatement;
    }

    @NotNull
    private PsiStatement generateNotNullConditionalStatement(String varName) {
        PsiStatement psiStatement = this.myElementFactory.createStatementFromText("if (" + varName + " != null) return " + varName + ";", null);
        if (psiStatement == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(5);
        }
        return psiStatement;
    }

    protected PsiExpression expressionToReplace(PsiExpression expression) {
        if (expression instanceof PsiAssignmentExpression) {
            return ((PsiAssignmentExpression)expression).getRExpression();
        }
        return expression;
    }

    protected PsiMethod addExtractedMethod(PsiMethod newMethod) {
        return (PsiMethod)this.myTargetClass.addAfter((PsiElement)newMethod, this.myAnchor);
    }

    @Nullable
    private PsiStatement prepareMethodBody(PsiMethod newMethod, boolean doExtract2) {
        String outVariableName;
        PsiCodeBlock body = newMethod.getBody();
        if (this.myExpression != null) {
            this.declareNecessaryVariablesInsideBody(body);
            if (this.myHasExpressionOutput) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)this.myElementFactory.createStatementFromText("return x;", null);
                PsiExpression returnValue = CommonJavaRefactoringUtil.convertInitializerToNormalExpression((PsiExpression)this.myExpression, (PsiType)this.myForcedReturnType);
                returnStatement.getReturnValue().replace((PsiElement)returnValue);
                body.add((PsiElement)returnStatement);
            } else {
                PsiExpressionStatement statement = (PsiExpressionStatement)this.myElementFactory.createStatementFromText("x;", null);
                statement.getExpression().replace((PsiElement)this.myExpression);
                body.add((PsiElement)statement);
            }
            return null;
        }
        boolean hasNormalExit = this.hasNormalExit();
        String string = outVariableName = this.myOutputVariable != null ? this.getNewVariableName(this.myOutputVariable) : null;
        PsiReturnStatement returnStatement = this.myNullConditionalCheck ? (PsiReturnStatement)this.myElementFactory.createStatementFromText("return null;", null) : (this.myOutputVariable != null ? (PsiReturnStatement)this.myElementFactory.createStatementFromText("return " + outVariableName + ";", null) : (this.myGenerateConditionalExit ? (PsiReturnStatement)this.myElementFactory.createStatementFromText("return true;", null) : (PsiReturnStatement)this.myElementFactory.createStatementFromText("return;", null)));
        PsiStatement exitStatementCopy = !doExtract2 || this.myNotNullConditionalCheck ? null : this.myControlFlowWrapper.getExitStatementCopy((PsiElement)returnStatement, this.myElements);
        this.declareNecessaryVariablesInsideBody(body);
        body.addRange(this.myElements[0], this.myElements[this.myElements.length - 1]);
        if (this.myNullConditionalCheck) {
            body.add((PsiElement)this.myElementFactory.createStatementFromText("return " + this.myOutputVariable.getName() + ";", null));
        } else if (this.myNotNullConditionalCheck) {
            body.add((PsiElement)this.myElementFactory.createStatementFromText("return null;", null));
        } else if (this.myGenerateConditionalExit) {
            body.add((PsiElement)this.myElementFactory.createStatementFromText("return false;", null));
        } else if (!this.myHasReturnStatement && hasNormalExit && this.myOutputVariable != null) {
            Object[] declaredElements;
            PsiStatement statement;
            PsiVariable variable;
            PsiExpression returnValue;
            PsiReturnStatement insertedReturnStatement = (PsiReturnStatement)body.add((PsiElement)returnStatement);
            if (this.myOutputVariables.length == 1 && (returnValue = insertedReturnStatement.getReturnValue()) instanceof PsiReferenceExpression && (variable = (PsiVariable)ObjectUtils.tryCast((Object)((PsiReferenceExpression)returnValue).resolve(), PsiVariable.class)) != null && Comparing.strEqual((String)variable.getName(), (String)outVariableName) && (statement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)insertedReturnStatement, PsiStatement.class)) instanceof PsiDeclarationStatement && ArrayUtil.find((Object[])(declaredElements = ((PsiDeclarationStatement)statement).getDeclaredElements()), (Object)variable) != -1) {
                InlineUtil.inlineVariable(variable, PsiUtil.skipParenthesizedExprDown((PsiExpression)variable.getInitializer()), (PsiJavaCodeReferenceElement)((PsiReferenceExpression)returnValue));
                variable.delete();
            }
        } else if (this.isArtificialOutputUsed()) {
            body.add((PsiElement)this.myElementFactory.createStatementFromText("return " + this.myArtificialOutputVariable.getName() + ";", null));
        }
        return exitStatementCopy;
    }

    private boolean isArtificialOutputUsed() {
        return this.myArtificialOutputVariable != null && !PsiTypes.voidType().equals((Object)this.myReturnType) && !this.myIsChainedConstructor;
    }

    private boolean hasNormalExit() {
        try {
            PsiCodeBlock block = JavaPsiFacade.getElementFactory((Project)this.myProject).createCodeBlock();
            block.addRange(this.myElements[0], this.myElements[this.myElements.length - 1]);
            ControlFlow flow = ControlFlowFactory.getControlFlow((PsiElement)block, (ControlFlowPolicy)new LocalsControlFlowPolicy((PsiElement)block), (ControlFlowOptions)ControlFlowOptions.NO_CONST_EVALUATE);
            return ControlFlowUtil.canCompleteNormally((ControlFlow)flow, (int)0, (int)flow.getSize());
        }
        catch (AnalysisCanceledException e) {
            PsiElement lastElement = this.myElements[this.myElements.length - 1];
            return !(lastElement instanceof PsiReturnStatement) && !(lastElement instanceof PsiBreakStatement) && !(lastElement instanceof PsiContinueStatement);
        }
    }

    protected boolean isNeedToChangeCallContext() {
        return this.myNeedChangeContext;
    }

    private void declareVariableAtMethodCallLocation(String name) {
        this.declareVariableAtMethodCallLocation(name, this.myReturnType);
    }

    private String declareVariableAtMethodCallLocation(String name, PsiType type) {
        PsiElement lastStatement;
        if (this.myControlFlowWrapper.getOutputVariables(false, 1).length == 0 && (lastStatement = PsiTreeUtil.getNextSiblingOfType((PsiElement)(this.myEnclosingBlockStatement != null ? this.myEnclosingBlockStatement : this.myElements[this.myElements.length - 1]), PsiStatement.class)) != null) {
            name = JavaCodeStyleManager.getInstance((Project)this.myProject).suggestUniqueVariableName(name, lastStatement, true);
        }
        PsiDeclarationStatement statement = this.myElementFactory.createVariableDeclarationStatement(name, type, (PsiExpression)this.myMethodCall);
        statement = (PsiDeclarationStatement)JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences(this.addToMethodCallLocation((PsiStatement)statement));
        PsiVariable var = (PsiVariable)statement.getDeclaredElements()[0];
        this.myMethodCall = (PsiMethodCallExpression)var.getInitializer();
        if (this.myOutputVariable != null) {
            var.getModifierList().replace((PsiElement)this.myOutputVariable.getModifierList());
        }
        return name;
    }

    private void adjustFinalParameters(final PsiMethod method) throws IncorrectOperationException {
        final IncorrectOperationException[] exc = new IncorrectOperationException[]{null};
        final PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length > 0) {
            if (((JavaCodeStyleSettings)this.myStyleSettings.getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_PARAMETERS) {
                method.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(this){

                    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                        PsiParameter param;
                        int index;
                        PsiElement resolved;
                        if (expression == null) {
                            7.$$$reportNull$$$0(0);
                        }
                        if ((resolved = expression.resolve()) != null && (index = ArrayUtil.find((Object[])parameters, (Object)resolved)) >= 0 && (param = parameters[index]).hasModifierProperty("final") && PsiUtil.isAccessedForWriting((PsiExpression)expression)) {
                            try {
                                PsiUtil.setModifierProperty((PsiModifierListOwner)param, (String)"final", (boolean)false);
                            }
                            catch (IncorrectOperationException e) {
                                exc[0] = e;
                            }
                        }
                        super.visitReferenceExpression(expression);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/extractMethod/ExtractMethodProcessor$7", "visitReferenceExpression"));
                    }
                });
            } else if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.EFFECTIVELY_FINAL, (PsiElement)this.myTargetClass)) {
                method.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(this){

                    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                        PsiParameter param;
                        PsiElement resolved;
                        int index;
                        if (expression == null) {
                            8.$$$reportNull$$$0(0);
                        }
                        if ((index = ArrayUtil.find((Object[])parameters, (Object)(resolved = expression.resolve()))) >= 0 && !(param = parameters[index]).hasModifierProperty("final") && RefactoringUtil.isInsideAnonymousOrLocal((PsiElement)expression, (PsiElement)method)) {
                            try {
                                PsiUtil.setModifierProperty((PsiModifierListOwner)param, (String)"final", (boolean)true);
                            }
                            catch (IncorrectOperationException e) {
                                exc[0] = e;
                            }
                        }
                        super.visitReferenceExpression(expression);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/extractMethod/ExtractMethodProcessor$8", "visitReferenceExpression"));
                    }
                });
            }
            if (exc[0] != null) {
                throw exc[0];
            }
        }
    }

    @Override
    public List<Match> getDuplicates() {
        if (this.myIsChainedConstructor) {
            return ExtractMethodProcessor.filterChainedConstructorDuplicates(this.myDuplicates);
        }
        return this.myDuplicates;
    }

    @Nullable
    public ParametrizedDuplicates getParametrizedDuplicates() {
        return this.myParametrizedDuplicates;
    }

    @Nullable
    public List<Match> getAnyDuplicates() {
        return Optional.ofNullable(this.getParametrizedDuplicates()).map(ParametrizedDuplicates::getDuplicates).orElse(this.getDuplicates());
    }

    private static List<Match> filterChainedConstructorDuplicates(List<Match> duplicates) {
        ArrayList<Match> result = new ArrayList<Match>();
        for (Match duplicate : duplicates) {
            PsiStatement[] psiStatements;
            PsiCodeBlock body;
            PsiElement matchStart = duplicate.getMatchStart();
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)matchStart, PsiMethod.class);
            if (method == null || !method.isConstructor() || (body = method.getBody()) == null || (psiStatements = body.getStatements()).length <= 0 || matchStart != psiStatements[0]) continue;
            result.add(duplicate);
        }
        return result;
    }

    @Override
    public void prepareSignature(Match match) {
        MatchUtil.changeSignature(match, this.myExtractedMethod);
    }

    @Override
    public PsiElement processMatch(Match match) throws IncorrectOperationException {
        if (PsiTreeUtil.isContextAncestor((PsiElement)this.myExtractedMethod.getContainingClass(), (PsiElement)match.getMatchStart(), (boolean)false) && CommonJavaRefactoringUtil.isInStaticContext((PsiElement)match.getMatchStart(), (PsiClass)this.myExtractedMethod.getContainingClass())) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)this.myExtractedMethod, (String)"static", (boolean)true);
        }
        PsiMethodCallExpression methodCallExpression = this.generateMethodCall(match.getInstanceExpression(), false, match.getMatchStart());
        ArrayList<VariableData> datas = new ArrayList<VariableData>();
        for (VariableData variableData : this.myVariableDatum) {
            if (!variableData.passAsParameter) continue;
            datas.add(variableData);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        for (VariableData data : datas) {
            List parameterValue = match.getParameterValues(data.variable);
            if (parameterValue != null) {
                for (PsiElement val : parameterValue) {
                    if (val instanceof PsiExpression && ExtractMethodProcessor.isCastRequired(data, (PsiExpression)val)) {
                        PsiTypeCastExpression cast = (PsiTypeCastExpression)elementFactory.createExpressionFromText("(A)a", val);
                        cast.getCastType().replace((PsiElement)elementFactory.createTypeElement(data.type));
                        cast.getOperand().replace(val.copy());
                        val = cast;
                    }
                    methodCallExpression.getArgumentList().add(val);
                }
                continue;
            }
            methodCallExpression.getArgumentList().add((PsiElement)this.myElementFactory.createExpressionFromText(data.variable.getName(), (PsiElement)methodCallExpression));
        }
        List<String> reusedVariables = ExtractMethodProcessor.findReusedVariables(match, this.myInputVariables, this.myOutputVariable);
        PsiElement replacedMatch = match.replace(this.myExtractedMethod, methodCallExpression, this.myOutputVariable, this.myReturnType);
        PsiElement appendLocation = this.addNotNullConditionalCheck(match, replacedMatch);
        ExtractMethodProcessor.declareReusedVariables(appendLocation, reusedVariables);
        return replacedMatch;
    }

    private static boolean isCastRequired(@NotNull VariableData data, @NotNull PsiExpression val) {
        PsiType exprType;
        if (data == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(6);
        }
        if (val == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(7);
        }
        if ((exprType = val.getType()) == null || TypeConversionUtil.isAssignable((PsiType)data.type, (PsiType)exprType)) {
            return false;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)data.type);
        return !(psiClass instanceof PsiTypeParameter);
    }

    @NotNull
    private static List<String> findReusedVariables(@NotNull Match match, @NotNull InputVariables inputVariables, @Nullable PsiVariable outputVariable) {
        List<ReusedLocalVariable> reusedLocalVariables;
        PsiVariable returnedVariable;
        if (match == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(8);
        }
        if (inputVariables == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(9);
        }
        Set<PsiLocalVariable> ignoreVariables = Collections.emptySet();
        ReturnValue returnValue = match.getOutputVariableValue(outputVariable);
        if (returnValue instanceof VariableReturnValue && (returnedVariable = ((VariableReturnValue)returnValue).getVariable()) instanceof PsiLocalVariable) {
            ignoreVariables = Collections.singleton((PsiLocalVariable)returnedVariable);
        }
        if (!(reusedLocalVariables = ReusedLocalVariablesFinder.findReusedLocalVariables(match.getMatchStart(), match.getMatchEnd(), ignoreVariables, inputVariables)).isEmpty()) {
            ArrayList<String> result = new ArrayList<String>();
            for (ReusedLocalVariable variable : reusedLocalVariables) {
                if (variable.reuseValue()) continue;
                result.add(variable.getDeclarationText());
            }
            ArrayList<String> arrayList = result;
            if (arrayList == null) {
                ExtractMethodProcessor.$$$reportNull$$$0(10);
            }
            return arrayList;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static void declareReusedVariables(@NotNull PsiElement appendLocation, @NotNull List<String> reusedVariables) {
        if (appendLocation == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(12);
        }
        if (reusedVariables == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(13);
        }
        if (reusedVariables.isEmpty()) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)appendLocation.getProject());
        for (String variable : reusedVariables) {
            PsiStatement declaration = factory.createStatementFromText(variable, appendLocation);
            appendLocation = appendLocation.getParent().addAfter((PsiElement)declaration, appendLocation);
        }
    }

    private PsiElement addNotNullConditionalCheck(Match match, PsiElement replacedMatch) {
        ReturnValue returnValue;
        if ((this.myNotNullConditionalCheck || this.myGenerateConditionalExit) && this.myOutputVariable != null && (returnValue = match.getOutputVariableValue(this.myOutputVariable)) instanceof VariableReturnValue) {
            String varName = ((VariableReturnValue)returnValue).getVariable().getName();
            LOG.assertTrue(varName != null, (Object)"returned variable name is null");
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)replacedMatch, PsiStatement.class, (boolean)false);
            if (statement != null) {
                PsiStatement conditionalExit = this.myNotNullConditionalCheck ? this.generateNotNullConditionalStatement(varName) : this.generateConditionalExitStatement(varName);
                return statement.getParent().addAfter((PsiElement)conditionalExit, (PsiElement)statement);
            }
        }
        return replacedMatch;
    }

    @Nullable
    protected PsiMethodCallExpression getMatchMethodCallExpression(PsiElement element) {
        PsiElement psiElement = element;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiMethodCallExpression.class, PsiExpressionStatement.class, PsiDeclarationStatement.class, PsiIfStatement.class}, (Object)psiElement, n)) {
            case 0 -> {
                PsiMethodCallExpression expression;
                yield expression = (PsiMethodCallExpression)psiElement;
            }
            case 1 -> {
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)psiElement;
                PsiExpression v1 = expressionStatement.getExpression();
                Objects.requireNonNull(v1);
                PsiExpression var8_6 = v1;
                int var9_8 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PsiMethodCallExpression.class, PsiAssignmentExpression.class}, (Object)var8_6, var9_8)) {
                    case 0: {
                        PsiMethodCallExpression call;
                        yield call = (PsiMethodCallExpression)var8_6;
                    }
                    case 1: {
                        PsiAssignmentExpression assignment = (PsiAssignmentExpression)var8_6;
                        yield (PsiMethodCallExpression)ObjectUtils.tryCast((Object)assignment.getRExpression(), PsiMethodCallExpression.class);
                    }
                }
                yield null;
            }
            case 2 -> {
                PsiDeclarationStatement decl = (PsiDeclarationStatement)psiElement;
                yield StreamEx.of((Object[])decl.getDeclaredElements()).select(PsiLocalVariable.class).map(lv -> lv.getInitializer()).select(PsiMethodCallExpression.class).findFirst().orElse(null);
            }
            case 3 -> {
                PsiIfStatement ifStatement = (PsiIfStatement)psiElement;
                yield (PsiMethodCallExpression)ObjectUtils.tryCast((Object)ifStatement.getCondition(), PsiMethodCallExpression.class);
            }
            default -> null;
        };
    }

    protected void deleteExtracted() throws IncorrectOperationException {
        if (this.myEnclosingBlockStatement == null) {
            this.myElements[0].getParent().deleteChildRange(this.myElements[0], this.myElements[this.myElements.length - 1]);
        } else {
            this.myEnclosingBlockStatement.delete();
        }
    }

    protected PsiElement addToMethodCallLocation(PsiStatement newStatement) throws IncorrectOperationException {
        PsiBlockStatement location;
        PsiBlockStatement oldStatement;
        if (this.myAddedToMethodCallLocation != null) {
            PsiCodeBlock block = this.myAddedToMethodCallLocation.getCodeBlock();
            return block.addBefore((PsiElement)newStatement, (PsiElement)block.getRBrace());
        }
        if (this.myEnclosingBlockStatement != null) {
            location = oldStatement = this.myEnclosingBlockStatement;
        } else {
            Object element = this.myExpression != null ? this.myExpression : this.myElements[0];
            PsiComment comment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false);
            if (comment == null) {
                location = oldStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class, (boolean)false);
            } else {
                location = comment;
                oldStatement = ((StreamEx)StreamEx.of((Object[])this.myElements).filter(e -> !(e instanceof PsiComment) && !(e instanceof PsiWhiteSpace))).map(e -> (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)e, PsiStatement.class, (boolean)false)).nonNull().findFirst().orElse(null);
            }
        }
        LOG.assertTrue(location != null, (Object)"Can't find statement/comment at the extracted location");
        PsiElement parent = location.getParent();
        if (ExtractMethodProcessor.isBranchOrBody(parent, (PsiElement)oldStatement)) {
            this.myAddedToMethodCallLocation = (PsiBlockStatement)this.myElementFactory.createStatementFromText("{}", (PsiElement)oldStatement);
            this.myAddedToMethodCallLocation = (PsiBlockStatement)parent.addBefore((PsiElement)this.myAddedToMethodCallLocation, (PsiElement)location);
            PsiCodeBlock block = this.myAddedToMethodCallLocation.getCodeBlock();
            return block.addBefore((PsiElement)newStatement, (PsiElement)block.getRBrace());
        }
        return parent.addBefore((PsiElement)newStatement, (PsiElement)location);
    }

    @Contract(value="_,null -> false; null,_ -> false")
    private static boolean isBranchOrBody(PsiElement parent, PsiElement element) {
        if (element == null) {
            return false;
        }
        if (parent instanceof PsiIfStatement) {
            return ((PsiIfStatement)parent).getThenBranch() == element || ((PsiIfStatement)parent).getElseBranch() == element;
        }
        if (parent instanceof PsiLoopStatement) {
            return ((PsiLoopStatement)parent).getBody() == element;
        }
        return false;
    }

    private void renameInputVariables() throws IncorrectOperationException {
        LocalSearchScope localSearchScope = null;
        for (int i = this.myVariableDatum.length - 1; i >= 0; --i) {
            VariableData data = this.myVariableDatum[i];
            PsiVariable variable = data.variable;
            if (data.name.equals(variable.getName()) && !(variable instanceof PsiField)) continue;
            if (localSearchScope == null) {
                localSearchScope = new LocalSearchScope(this.myElements);
            }
            for (PsiReference reference : ReferencesSearch.search((PsiElement)variable, localSearchScope).asIterable()) {
                PsiReferenceExpression referenceExpression;
                PsiExpression qualifierExpression;
                reference.handleElementRename(data.name);
                PsiElement element = reference.getElement();
                if (!(element instanceof PsiReferenceExpression) || !((qualifierExpression = (referenceExpression = (PsiReferenceExpression)element).getQualifierExpression()) instanceof PsiQualifiedExpression)) continue;
                referenceExpression.setQualifierExpression(null);
            }
        }
    }

    public PsiClass getTargetClass() {
        return this.myTargetClass;
    }

    public PsiType getReturnType() {
        return this.myReturnType;
    }

    private PsiMethod generateEmptyMethod() throws IncorrectOperationException {
        return this.generateEmptyMethod(this.myMethodName, null);
    }

    public PsiMethod generateEmptyMethod(String methodName, PsiElement context) throws IncorrectOperationException {
        PsiCodeBlock body;
        PsiMethod newMethod;
        if (this.myIsChainedConstructor) {
            newMethod = this.myElementFactory.createConstructor();
        } else {
            newMethod = context != null ? this.myElementFactory.createMethod(methodName, this.myReturnType, context) : this.myElementFactory.createMethod(methodName, this.myReturnType);
            PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)"static", (boolean)this.isStatic());
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)this.myMethodVisibility, (boolean)true);
        if (this.getTypeParameterList() != null) {
            newMethod.getTypeParameterList().replace((PsiElement)this.getTypeParameterList());
        }
        LOG.assertTrue((body = newMethod.getBody()) != null);
        boolean isFinal = ((JavaCodeStyleSettings)this.myStyleSettings.getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_PARAMETERS;
        PsiParameterList list = newMethod.getParameterList();
        for (VariableData data : this.myVariableDatum) {
            if (data.passAsParameter) {
                PsiParameter parm = this.myElementFactory.createParameter(data.name, data.type);
                this.copyParamAnnotations(parm);
                if (isFinal) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)parm, (String)"final", (boolean)true);
                }
                list.add((PsiElement)parm);
                continue;
            }
            if (!this.defineVariablesForUnselectedParameters()) continue;
            @NonNls StringBuilder buffer = new StringBuilder();
            if (isFinal) {
                buffer.append("final ");
            }
            buffer.append("int ");
            buffer.append(data.name);
            buffer.append("=;");
            String text = buffer.toString();
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)this.myElementFactory.createStatementFromText(text, null);
            declaration = (PsiDeclarationStatement)this.myStyleManager.reformat((PsiElement)declaration);
            PsiTypeElement typeElement = this.myElementFactory.createTypeElement(data.type);
            ((PsiVariable)declaration.getDeclaredElements()[0]).getTypeElement().replace((PsiElement)typeElement);
            body.add((PsiElement)declaration);
        }
        PsiReferenceList throwsList = newMethod.getThrowsList();
        for (PsiClassType exception : this.getThrownExceptions()) {
            throwsList.add((PsiElement)JavaPsiFacade.getElementFactory((Project)this.myManager.getProject()).createReferenceElementByType(exception));
        }
        if (this.myTargetClass.isInterface()) {
            this.updateModifiersInInterface(newMethod);
        }
        return (PsiMethod)this.myStyleManager.reformat((PsiElement)newMethod);
    }

    private void updateModifiersInInterface(PsiMethod newMethod) {
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)this.myTargetClass);
        if (JavaFeature.EXTENSION_METHODS.isSufficient(languageLevel)) {
            PsiMethod containingMethod;
            if (!this.isStatic() && (containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myCodeFragmentMember, PsiMethod.class, (boolean)false)) != null && containingMethod.hasModifierProperty("default")) {
                if (JavaFeature.PRIVATE_INTERFACE_METHODS.isSufficient(languageLevel)) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)"private", (boolean)true);
                } else {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)"default", (boolean)true);
                }
            }
            PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)"public", (boolean)false);
            PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)"protected", (boolean)false);
            if (this.isStatic() || !JavaFeature.PRIVATE_INTERFACE_METHODS.isSufficient(languageLevel)) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)newMethod, (String)"private", (boolean)false);
            }
        }
    }

    protected boolean defineVariablesForUnselectedParameters() {
        return true;
    }

    private void copyParamAnnotations(PsiParameter parm) {
        PsiModifierList modifierList;
        PsiVariable variable = PsiResolveHelper.getInstance((Project)this.myProject).resolveReferencedVariable(parm.getName(), this.myElements[0]);
        if (variable instanceof PsiParameter && (modifierList = variable.getModifierList()) != null) {
            PsiModifierList parmModifierList = parm.getModifierList();
            LOG.assertTrue(parmModifierList != null);
            GenerateMembersUtil.copyAnnotations((PsiModifierList)modifierList, (PsiModifierList)parmModifierList, (String[])new String[]{SuppressWarnings.class.getName()});
            this.updateNullabilityAnnotation(parm, variable);
        }
    }

    private void updateNullabilityAnnotation(@NotNull PsiParameter parm, @NotNull PsiVariable variable) {
        Nullability nullability;
        if (parm == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(14);
        }
        if (variable == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(15);
        }
        NullableNotNullManager nullabilityManager = NullableNotNullManager.getInstance((Project)this.myProject);
        List notNullAnnotations = nullabilityManager.getNotNulls();
        List nullableAnnotations = nullabilityManager.getNullables();
        if ((AnnotationUtil.isAnnotated((PsiModifierListOwner)variable, (Collection)nullableAnnotations, (int)8) || AnnotationUtil.isAnnotated((PsiModifierListOwner)variable, (Collection)notNullAnnotations, (int)8) || PropertiesComponent.getInstance((Project)this.myProject).getBoolean("extractMethod.generateAnnotations", false)) && (nullability = ExtractMethodProcessor.inferNullability(variable, this.myElements[0])) != Nullability.UNKNOWN) {
            boolean isNotNull = nullability == Nullability.NOT_NULL;
            List toKeep = isNotNull ? notNullAnnotations : nullableAnnotations;
            List toRemove = isNotNull ? nullableAnnotations : notNullAnnotations;
            String toAdd = nullabilityManager.getDefaultAnnotation(nullability, (PsiElement)parm);
            this.updateAnnotations((PsiModifierListOwner)parm, toRemove, toAdd, toKeep);
        }
    }

    private void updateAnnotations(PsiModifierListOwner owner, List<String> toRemove, String toAdd, List<String> toKeep) {
        PsiAnnotation annotation;
        AddAnnotationPsiFix.removePhysicalAnnotations((PsiModifierListOwner)owner, (String[])ArrayUtilRt.toStringArray(toRemove));
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null && !AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, toKeep, (int)8) && (annotation = AddAnnotationPsiFix.addPhysicalAnnotationIfAbsent((String)toAdd, (PsiNameValuePair[])PsiNameValuePair.EMPTY_ARRAY, (PsiAnnotationOwner)modifierList)) != null) {
            JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)annotation);
        }
    }

    @NotNull
    private static Nullability inferNullability(@NotNull PsiVariable variable, PsiElement startElement) {
        PsiParameterListOwner methodOrLambda;
        String variableName;
        if (variable == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(16);
        }
        if ((variableName = variable.getName()) == null) {
            Nullability nullability = Nullability.UNKNOWN;
            if (nullability == null) {
                ExtractMethodProcessor.$$$reportNull$$$0(17);
            }
            return nullability;
        }
        PsiElement methodOrLambdaBody = null;
        if (variable instanceof PsiPatternVariable) {
            Nullability nullability = Nullability.NOT_NULL;
            if (nullability == null) {
                ExtractMethodProcessor.$$$reportNull$$$0(18);
            }
            return nullability;
        }
        if ((variable instanceof PsiLocalVariable || variable instanceof PsiParameter) && (methodOrLambda = (PsiParameterListOwner)PsiTreeUtil.getParentOfType((PsiElement)variable, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class})) != null) {
            methodOrLambdaBody = methodOrLambda.getBody();
        }
        if (methodOrLambdaBody instanceof PsiCodeBlock) {
            PsiElement topmostLambdaOrAnonymousClass = null;
            for (PsiElement element = startElement; element != null && element != methodOrLambdaBody; element = element.getParent()) {
                if (!(element instanceof PsiLambdaExpression) && !(element instanceof PsiAnonymousClass)) continue;
                topmostLambdaOrAnonymousClass = element;
            }
            if (topmostLambdaOrAnonymousClass != null) {
                startElement = topmostLambdaOrAnonymousClass;
            }
            Project project = methodOrLambdaBody.getProject();
            PsiFile file = methodOrLambdaBody.getContainingFile();
            PsiFile copy = PsiFileFactory.getInstance((Project)project).createFileFromText(file.getName(), file.getFileType(), (CharSequence)file.getText(), file.getModificationStamp(), false);
            PsiCodeBlock bodyCopy = ExtractMethodProcessor.findCopy(copy, methodOrLambdaBody, PsiCodeBlock.class);
            if (startElement instanceof PsiExpression) {
                startElement = PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiStatement.class);
            }
            if (startElement instanceof PsiStatement) {
                Nullability nullability;
                PsiStatement startStatementCopy = ExtractMethodProcessor.findCopy(copy, startElement, PsiStatement.class);
                try {
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                    startStatementCopy = ExtractMethodProcessor.wrapWithBlockStatementIfNeeded(startStatementCopy, factory);
                    String dummyName = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName("_Dummy_", startElement.getParent(), true);
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)factory.createStatementFromText("java.lang.Object " + dummyName + " = " + variableName + ";", (PsiElement)startStatementCopy);
                    PsiElement parent = startStatementCopy.getParent();
                    declarationStatement = (PsiDeclarationStatement)parent.addBefore((PsiElement)declarationStatement, (PsiElement)startStatementCopy);
                    PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                    PsiExpression initializer = Objects.requireNonNull(((PsiVariable)declaredElements[0]).getInitializer());
                    nullability = ExtractMethodProcessor.inferNullability(bodyCopy, initializer);
                }
                catch (IncorrectOperationException ignore) {
                    Nullability nullability2 = Nullability.UNKNOWN;
                    if (nullability2 == null) {
                        ExtractMethodProcessor.$$$reportNull$$$0(20);
                    }
                    return nullability2;
                }
                if (nullability == null) {
                    ExtractMethodProcessor.$$$reportNull$$$0(19);
                }
                return nullability;
            }
        }
        Nullability nullability = Nullability.UNKNOWN;
        if (nullability == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(21);
        }
        return nullability;
    }

    private static <T extends PsiElement> T findCopy(@NotNull PsiFile copy, @NotNull PsiElement element, @NotNull Class<T> clazz) {
        if (copy == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(22);
        }
        if (element == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(23);
        }
        if (clazz == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(24);
        }
        TextRange range = element.getTextRange();
        return (T)CodeInsightUtil.findElementInRange((PsiFile)copy, (int)range.getStartOffset(), (int)range.getEndOffset(), clazz);
    }

    private static PsiStatement wrapWithBlockStatementIfNeeded(@NotNull PsiStatement statement, @NotNull PsiElementFactory factory) {
        PsiElement parent;
        if (statement == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(25);
        }
        if (factory == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(26);
        }
        if ((parent = statement.getParent()) instanceof PsiLoopStatement && ((PsiLoopStatement)parent).getBody() == statement || parent instanceof PsiIfStatement && (((PsiIfStatement)parent).getThenBranch() == statement || ((PsiIfStatement)parent).getElseBranch() == statement)) {
            PsiBlockStatement blockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)statement);
            blockStatement.getCodeBlock().add((PsiElement)statement);
            blockStatement = (PsiBlockStatement)statement.replace((PsiElement)blockStatement);
            return blockStatement.getCodeBlock().getStatements()[0];
        }
        if (parent instanceof PsiForStatement && (((PsiForStatement)parent).getInitialization() == statement || ((PsiForStatement)parent).getUpdate() == statement)) {
            return ExtractMethodProcessor.wrapWithBlockStatementIfNeeded((PsiStatement)((PsiForStatement)parent), factory);
        }
        return statement;
    }

    @NotNull
    protected PsiMethodCallExpression generateMethodCall(PsiExpression instanceQualifier, boolean generateArgs, PsiElement context) {
        boolean skipInstanceQualifier;
        @NonNls StringBuilder buffer = new StringBuilder();
        if (this.myIsChainedConstructor) {
            skipInstanceQualifier = true;
            buffer.append("this");
        } else {
            boolean bl = skipInstanceQualifier = instanceQualifier == null || instanceQualifier instanceof PsiThisExpression;
            if (skipInstanceQualifier) {
                if (this.isNeedToChangeCallContext()) {
                    boolean needsThisQualifier = false;
                    PsiElement parent = this.myCodeFragmentMember;
                    while (!this.myTargetClass.equals((Object)parent)) {
                        String methodName;
                        if (parent instanceof PsiMethod && (methodName = ((PsiMethod)parent).getName()).equals(this.myMethodName)) {
                            needsThisQualifier = true;
                            break;
                        }
                        parent = parent.getParent();
                    }
                    if (needsThisQualifier) {
                        buffer.append(this.myTargetClass.getName());
                        buffer.append(".this.");
                    }
                }
            } else {
                buffer.append("qqq.");
            }
            buffer.append(this.myMethodName);
        }
        buffer.append("(");
        if (generateArgs) {
            int count = 0;
            for (PsiElement data : this.myVariableDatum) {
                if (!data.passAsParameter) continue;
                if (count > 0) {
                    buffer.append(",");
                }
                this.myInputVariables.appendCallArguments((VariableData)data, buffer);
                ++count;
            }
        }
        buffer.append(")");
        String text = buffer.toString();
        PsiMethodCallExpression expr = (PsiMethodCallExpression)this.myElementFactory.createExpressionFromText(text, context);
        expr = (PsiMethodCallExpression)this.myStyleManager.reformat((PsiElement)expr);
        if (!skipInstanceQualifier) {
            PsiExpression qualifierExpression = expr.getMethodExpression().getQualifierExpression();
            LOG.assertTrue(qualifierExpression != null);
            qualifierExpression.replace((PsiElement)instanceQualifier);
        }
        PsiMethodCallExpression psiMethodCallExpression = (PsiMethodCallExpression)JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)expr);
        if (psiMethodCallExpression == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(27);
        }
        return psiMethodCallExpression;
    }

    private boolean chooseTargetClass(PsiElement codeFragment, final Consumer<? super ExtractMethodProcessor> extractPass, @Nullable PsiClass defaultTargetClass) throws PrepareFailedException {
        final List inputVariables = this.myControlFlowWrapper.getInputVariables(codeFragment, this.myElements, this.myOutputVariables);
        this.myNeedChangeContext = false;
        PsiClass psiClass = this.myTargetClass = this.myCodeFragmentMember instanceof PsiMember ? ((PsiMember)this.myCodeFragmentMember).getContainingClass() : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this.myCodeFragmentMember, PsiClass.class);
        if (this.myTargetClass == null) {
            LOG.error("Unable to find target class. Parents are: " + ((StreamEx)StreamEx.iterate((Object)this.myCodeFragmentMember, PsiElement::getParent).takeWhileInclusive(e -> e != null && !(e instanceof PsiFileSystemItem))).map(e -> e.getClass().getSimpleName()).joining((CharSequence)","));
        }
        if (!ExtractMethodProcessor.shouldAcceptCurrentTarget(extractPass, (PsiElement)this.myTargetClass)) {
            final LinkedHashMap classes = new LinkedHashMap();
            PsiElementProcessor<PsiClass> processor = new PsiElementProcessor<PsiClass>(){

                public boolean execute(@NotNull PsiClass selectedClass) {
                    if (selectedClass == null) {
                        9.$$$reportNull$$$0(0);
                    }
                    AnonymousTargetClassPreselectionUtil.rememberSelection((PsiClass)selectedClass, (PsiClass)ExtractMethodProcessor.this.myTargetClass);
                    List array = (List)classes.get(selectedClass);
                    ExtractMethodProcessor.this.myNeedChangeContext = ExtractMethodProcessor.this.myTargetClass != selectedClass;
                    ExtractMethodProcessor.this.myTargetClass = selectedClass;
                    if (array != null) {
                        for (PsiVariable variable : array) {
                            if (inputVariables.contains(variable)) continue;
                            inputVariables.addAll(array);
                        }
                    }
                    try {
                        return ExtractMethodProcessor.this.applyChosenClassAndExtract(inputVariables, extractPass);
                    }
                    catch (PrepareFailedException e) {
                        if (ExtractMethodProcessor.this.myShowErrorDialogs) {
                            CommonRefactoringUtil.showErrorHint((Project)ExtractMethodProcessor.this.myProject, (Editor)ExtractMethodProcessor.this.myEditor, (String)e.getMessage(), (String)ExtractMethodHandler.getRefactoringName(), (String)"refactoring.extractMethod");
                            ExtractMethodHandler.highlightPrepareError(e, e.getFile(), ExtractMethodProcessor.this.myEditor, ExtractMethodProcessor.this.myProject);
                        }
                        return false;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectedClass", "com/intellij/refactoring/extractMethod/ExtractMethodProcessor$9", "execute"));
                }
            };
            classes.put(this.myTargetClass, null);
            PsiElement target = this.myTargetClass.getParent();
            PsiClass targetMember = this.myTargetClass;
            while (!(target instanceof PsiFile)) {
                if (target instanceof PsiClass) {
                    boolean success = true;
                    ArrayList array = new ArrayList();
                    for (PsiElement el : this.myElements) {
                        if (ControlFlowUtil.collectOuterLocals(array, (PsiElement)el, (PsiElement)this.myCodeFragmentMember, (PsiElement)targetMember)) continue;
                        success = false;
                        break;
                    }
                    if (success) {
                        classes.put((PsiClass)target, array);
                        if (ExtractMethodProcessor.shouldAcceptCurrentTarget(extractPass, target)) {
                            return processor.execute((PsiElement)((PsiClass)target));
                        }
                    }
                }
                targetMember = target;
                target = target.getParent();
            }
            if (classes.size() > 1) {
                if (defaultTargetClass != null) {
                    return processor.execute((PsiElement)defaultTargetClass);
                }
                PsiClass[] psiClasses = classes.keySet().toArray(PsiClass.EMPTY_ARRAY);
                if (this.myEditor == null) {
                    return processor.execute((PsiElement)psiClasses[0]);
                }
                PsiClass preselection = AnonymousTargetClassPreselectionUtil.getPreselection(classes.keySet(), (PsiClass)psiClasses[0]);
                new PsiTargetNavigator((PsiElement[])psiClasses).selection((PsiElement)preselection).createPopup(this.myProject, RefactoringBundle.message((String)"choose.destination.class"), (PsiElementProcessor)processor).showInBestPositionFor(this.myEditor);
                return true;
            }
        }
        return this.applyChosenClassAndExtract(inputVariables, extractPass);
    }

    @NotNull
    protected Set<PsiVariable> getEffectivelyLocalVariables() {
        LinkedHashSet<PsiVariable> effectivelyLocal = new LinkedHashSet<PsiVariable>();
        List usedVariables = this.myControlFlowWrapper.getUsedVariablesInBody(ControlFlowUtil.findCodeFragment((PsiElement)this.myElements[0]), this.myOutputVariables);
        for (PsiVariable variable : usedVariables) {
            boolean toDeclare = !this.isDeclaredInside(variable) && this.myInputVariables.toDeclareInsideBody(variable);
            if (!toDeclare) continue;
            effectivelyLocal.add(variable);
        }
        if (this.myArtificialOutputVariable instanceof PsiField && !this.myIsChainedConstructor) {
            effectivelyLocal.add(this.myArtificialOutputVariable);
        }
        LinkedHashSet<PsiVariable> linkedHashSet = effectivelyLocal;
        if (linkedHashSet == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(28);
        }
        return linkedHashSet;
    }

    private void declareNecessaryVariablesInsideBody(PsiCodeBlock body) throws IncorrectOperationException {
        Set<PsiVariable> effectivelyLocal = this.getEffectivelyLocalVariables();
        for (PsiVariable variable : effectivelyLocal) {
            String name = variable.getName();
            LOG.assertTrue(name != null, (Object)"variable name is null");
            PsiDeclarationStatement statement = this.myElementFactory.createVariableDeclarationStatement(name, variable.getType(), null);
            body.add((PsiElement)statement);
        }
    }

    protected void declareNecessaryVariablesAfterCall(PsiVariable outputVariable) throws IncorrectOperationException {
        if (this.myHasExpressionOutput) {
            return;
        }
        List usedVariables = this.myControlFlowWrapper.getUsedVariables();
        Collection reassigned = this.myControlFlowWrapper.getInitializedTwice();
        for (PsiVariable variable : usedVariables) {
            boolean toDeclare = this.isDeclaredInside(variable) && !variable.equals((Object)outputVariable);
            if (!toDeclare) continue;
            String name = variable.getName();
            PsiDeclarationStatement statement = this.myElementFactory.createVariableDeclarationStatement(name, variable.getType(), null);
            if (reassigned.contains(new ControlFlowUtil.VariableInfo(variable, null))) {
                PsiElement[] psiElements = statement.getDeclaredElements();
                assert (psiElements.length > 0);
                PsiVariable var = (PsiVariable)psiElements[0];
                PsiUtil.setModifierProperty((PsiModifierListOwner)var, (String)"final", (boolean)false);
            }
            this.addToMethodCallLocation((PsiStatement)statement);
        }
    }

    public PsiMethodCallExpression getMethodCall() {
        return this.myMethodCall;
    }

    public void setMethodCall(PsiMethodCallExpression methodCall) {
        this.myMethodCall = methodCall;
    }

    public boolean isDeclaredInside(PsiVariable variable) {
        int endOffset;
        int startOffset;
        if (variable instanceof ImplicitVariable) {
            return false;
        }
        if (this.myExpression != null) {
            TextRange range = this.myExpression.getTextRange();
            startOffset = range.getStartOffset();
            endOffset = range.getEndOffset();
        } else {
            startOffset = this.myElements[0].getTextRange().getStartOffset();
            endOffset = this.myElements[this.myElements.length - 1].getTextRange().getEndOffset();
        }
        PsiIdentifier nameIdentifier = variable.getNameIdentifier();
        if (nameIdentifier == null) {
            return false;
        }
        TextRange range = nameIdentifier.getTextRange();
        if (range == null) {
            return false;
        }
        int offset = range.getStartOffset();
        return startOffset <= offset && offset <= endOffset;
    }

    private String getNewVariableName(PsiVariable variable) {
        for (VariableData data : this.myVariableDatum) {
            if (!data.variable.equals((Object)variable)) continue;
            return data.name;
        }
        return variable.getName();
    }

    private static boolean shouldAcceptCurrentTarget(Consumer<? super ExtractMethodProcessor> extractPass, PsiElement target) {
        return extractPass == null && !(target instanceof PsiAnonymousClass);
    }

    private boolean applyChosenClassAndExtract(List<? extends PsiVariable> inputVariables, @Nullable Consumer<? super ExtractMethodProcessor> extractPass) throws PrepareFailedException {
        this.myStatic = this.shouldBeStatic();
        LinkedHashSet fields = new LinkedHashSet();
        this.myCanBeStatic = CommonJavaRefactoringUtil.canBeStatic((PsiClass)this.myTargetClass, (PsiElement)this.myCodeFragmentMember, (PsiElement[])this.myElements, fields);
        this.myInputVariables = new InputVariables(inputVariables, this.myProject, new LocalSearchScope(this.myElements), this.isFoldingApplicable(), fields);
        if (!this.checkExitPoints()) {
            return false;
        }
        this.checkCanBeChainedConstructor();
        if (extractPass != null) {
            extractPass.accept(this);
        }
        return true;
    }

    protected boolean isFoldingApplicable() {
        return true;
    }

    protected void chooseAnchor() {
        this.myAnchor = this.myCodeFragmentMember;
        while (!this.myAnchor.getParent().equals((Object)this.myTargetClass)) {
            this.myAnchor = this.myAnchor.getParent();
        }
    }

    private void declareVariableReusedAfterCall(PsiVariable variable) {
        if (variable != null && variable.getName() != null && this.isDeclaredInside(variable) && this.myControlFlowWrapper.getUsedVariables().contains(variable) && !this.myControlFlowWrapper.needVariableValueAfterEnd(variable)) {
            PsiDeclarationStatement declaration = this.myElementFactory.createVariableDeclarationStatement(variable.getName(), variable.getType(), null);
            this.addToMethodCallLocation((PsiStatement)declaration);
        }
    }

    private void showMultipleExitPointsMessage() {
        if (this.myShowErrorDialogs) {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
            PsiStatement[] exitStatementsArray = this.myExitStatements.toArray(PsiStatement.EMPTY_ARRAY);
            highlightManager.addOccurrenceHighlights(this.myEditor, (PsiElement[])exitStatementsArray, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
            String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"there.are.multiple.exit.points.in.the.selected.code.fragment", (Object[])new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)this.myEditor, (String)message, (String)this.myRefactoringName, (String)this.myHelpId);
            WindowManager.getInstance().getStatusBar(this.myProject).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
        }
    }

    protected void showMultipleOutputMessage(PsiType expressionType) throws PrepareFailedException {
        if (this.myShowErrorDialogs) {
            String message = this.buildMultipleOutputMessageError(expressionType) + "\n" + JavaRefactoringBundle.message((String)"extract.method.object.suggestion", (Object[])new Object[0]);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new RuntimeException(message);
            }
            RefactoringMessageDialog dialog = new RefactoringMessageDialog(this.myRefactoringName, message, this.myHelpId, "OptionPane.errorIcon", true, this.myProject);
            if (dialog.showAndGet()) {
                new ExtractMethodObjectHandler().invoke(this.myProject, this.myEditor, this.myTargetClass.getContainingFile(), DataManager.getInstance().getDataContext());
            }
        }
    }

    @NlsContexts.DialogMessage
    @NotNull
    protected String buildMultipleOutputMessageError(@NotNull PsiType expressionType) {
        if (expressionType == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(29);
        }
        @Nls StringBuilder buffer = new StringBuilder();
        buffer.append(RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"there.are.multiple.output.values.for.the.selected.code.fragment", (Object[])new Object[0])));
        buffer.append("\n");
        if (this.myHasExpressionOutput) {
            buffer.append("    ").append(JavaRefactoringBundle.message((String)"expression.result", (Object[])new Object[0])).append(": ");
            buffer.append(PsiFormatUtil.formatType((PsiType)expressionType, (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
            buffer.append(",\n");
        }
        if (this.myGenerateConditionalExit) {
            buffer.append("    ").append(JavaRefactoringBundle.message((String)"boolean.method.result", (Object[])new Object[0]));
            buffer.append(",\n");
        }
        for (int i = 0; i < this.myOutputVariables.length; ++i) {
            PsiVariable var = this.myOutputVariables[i];
            buffer.append("    ");
            buffer.append(var.getName());
            buffer.append(" : ");
            buffer.append(PsiFormatUtil.formatType((PsiType)var.getType(), (int)0, (PsiSubstitutor)PsiSubstitutor.EMPTY));
            if (i < this.myOutputVariables.length - 1) {
                buffer.append(",\n");
                continue;
            }
            buffer.append(".");
        }
        String string = buffer.toString();
        if (string == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(30);
        }
        return string;
    }

    public PsiMethod getExtractedMethod() {
        return this.myExtractedMethod;
    }

    public void setExtractedMethod(PsiMethod method) {
        this.myExtractedMethod = method;
    }

    public void setMethodName(String methodName) {
        this.myMethodName = methodName;
    }

    public PsiElement getAnchor() {
        return this.myAnchor;
    }

    @Override
    public Boolean hasDuplicates() {
        List<Match> duplicates = this.getDuplicates();
        if (duplicates != null && !duplicates.isEmpty()) {
            return true;
        }
        if (this.initParametrizedDuplicates(true)) {
            return null;
        }
        return false;
    }

    public boolean initParametrizedDuplicates(boolean showDialog) {
        if (this.myExtractedMethod != null && this.myParametrizedDuplicates != null) {
            this.myDuplicates = this.myParametrizedDuplicates.getDuplicates();
            if (this.myDuplicates.isEmpty()) {
                return false;
            }
            boolean isSignatureUnchanged = this.myDuplicates.stream().map(Match::getExtractedParameters).allMatch(List::isEmpty);
            boolean isFoldable = this.myInputVariables.isFoldable();
            if (!showDialog || isSignatureUnchanged || isFoldable || this.shouldChangeSignature()) {
                this.myDuplicates = this.myParametrizedDuplicates.getDuplicates();
                if (this.myExtractedMethod.isPhysical()) {
                    WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> {
                        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
                        this.replaceParametrizedMethod();
                    });
                } else {
                    this.replaceParametrizedMethod();
                }
                this.myVariableDatum = this.myParametrizedDuplicates.getVariableDatum();
                return true;
            }
        }
        this.myDuplicates = this.myExactDuplicates != null ? this.myExactDuplicates.getDuplicates() : new ArrayList();
        return !this.myDuplicates.isEmpty();
    }

    private boolean shouldChangeSignature() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return Optional.of(this.myExtractedMethod).map(PsiElement::getContainingFile).map(psiFile -> (Boolean)psiFile.getUserData(SIGNATURE_CHANGE_ALLOWED)).orElse(true);
        }
        return new SignatureSuggesterPreviewDialog(this.myExtractedMethod, this.myParametrizedDuplicates.getParametrizedMethod(), this.myMethodCall, this.myParametrizedDuplicates.getParametrizedCall(), 0, this.myParametrizedDuplicates.getSize()).showAndGet();
    }

    private void replaceParametrizedMethod() {
        LOG.assertTrue(this.myParametrizedDuplicates != null);
        this.myExtractedMethod = this.myParametrizedDuplicates.replaceMethod(this.myExtractedMethod);
        this.myMethodCall = this.myParametrizedDuplicates.replaceCall(this.myMethodCall);
    }

    public boolean hasDuplicates(Set<? extends VirtualFile> files) {
        this.initDuplicates(null);
        DuplicatesFinder finder = this.getExactDuplicatesFinder();
        Boolean hasDuplicates = this.hasDuplicates();
        if (hasDuplicates == null || hasDuplicates.booleanValue()) {
            return true;
        }
        if (finder != null) {
            PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
            for (VirtualFile virtualFile : files) {
                if (finder.findDuplicates((PsiElement)psiManager.findFile(virtualFile)).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected DuplicatesFinder getExactDuplicatesFinder() {
        DuplicatesFinder finder = null;
        PsiElement[] elements = this.getFilteredElements();
        if (this.myExpression != null) {
            finder = new DuplicatesFinder(elements, this.myInputVariables.copy(), Collections.emptyList());
        } else if (elements.length != 0) {
            finder = new DuplicatesFinder(elements, this.myInputVariables.copy(), (ReturnValue)(this.myOutputVariable != null ? new VariableReturnValue(this.myOutputVariable) : null), Arrays.asList(this.myOutputVariables));
        }
        return finder;
    }

    @Override
    @Nullable
    public String getConfirmDuplicatePrompt(Match match) {
        boolean needToBeStatic = CommonJavaRefactoringUtil.isInStaticContext((PsiElement)match.getMatchStart(), (PsiClass)this.myExtractedMethod.getContainingClass());
        String changedSignature = MatchUtil.getChangedSignature(match, this.myExtractedMethod, needToBeStatic, VisibilityUtil.getVisibilityStringToDisplay((PsiMember)this.myExtractedMethod));
        if (changedSignature != null) {
            return JavaRefactoringBundle.message((String)"replace.this.code.fragment.and.change.signature", (Object[])new Object[]{changedSignature});
        }
        if (needToBeStatic && !this.myExtractedMethod.hasModifierProperty("static")) {
            return JavaRefactoringBundle.message((String)"replace.this.code.fragment.and.make.method.static", (Object[])new Object[0]);
        }
        return null;
    }

    @NotNull
    public UniqueNameGenerator getParameterNameGenerator(PsiElement scopeElement) {
        UniqueNameGenerator uniqueNameGenerator = new UniqueNameGenerator();
        for (VariableData data : this.myInputVariables.getInputVariables()) {
            String name;
            if (data.variable == null || (name = data.variable.getName()) == null) continue;
            uniqueNameGenerator.addExistingName(name);
        }
        for (PsiVariable variable : this.myOutputVariables) {
            String name = variable.getName();
            if (name == null) continue;
            uniqueNameGenerator.addExistingName(name);
        }
        PsiElement superParent = PsiTreeUtil.getParentOfType((PsiElement)scopeElement, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
        if (superParent != null) {
            ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser().withRoot((Object)superParent)).filter(element -> element instanceof PsiVariable)).forEach(element -> {
                String name = ((PsiVariable)element).getName();
                if (name != null) {
                    uniqueNameGenerator.addExistingName(name);
                }
            });
        }
        UniqueNameGenerator uniqueNameGenerator2 = uniqueNameGenerator;
        if (uniqueNameGenerator2 == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(31);
        }
        return uniqueNameGenerator2;
    }

    @Override
    public String getReplaceDuplicatesTitle(int idx, int size) {
        return JavaRefactoringBundle.message((String)"process.duplicates.title", (Object[])new Object[]{idx, size});
    }

    public InputVariables getInputVariables() {
        return this.myInputVariables;
    }

    public PsiTypeParameterList getTypeParameterList() {
        return this.myTypeParameterList;
    }

    public PsiClassType[] getThrownExceptions() {
        return this.myThrownExceptions;
    }

    public boolean isStatic() {
        return this.myStatic;
    }

    public void setStatic(boolean shouldBeStatic) {
        this.myStatic = shouldBeStatic;
    }

    public boolean isCanBeStatic() {
        return this.myCanBeStatic;
    }

    public PsiElement[] getElements() {
        return this.myElements;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ExtractMethodProcessor.$$$reportNull$$$0(32);
        }
        return project;
    }

    @NlsSafe
    public String getMethodName() {
        return this.myMethodName;
    }

    public PsiVariable[] getOutputVariables() {
        return this.myOutputVariables;
    }

    public void setMethodVisibility(String methodVisibility) {
        this.myMethodVisibility = methodVisibility;
    }

    private /* synthetic */ void lambda$doRefactoring$6(SearchScope processConflictsScope, Map overloadsResolveMap) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Map overloads = ExtractMethodUtil.encodeOverloadTargets((PsiClass)this.myTargetClass, (SearchScope)processConflictsScope, (String)this.myMethodName, (PsiElement)this.myCodeFragmentMember);
            overloadsResolveMap.putAll(overloads);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 10, 11, 17, 18, 19, 20, 21, 27, 28, 30, 31, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethod/ExtractMethodProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "val";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputVariables";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendLocation";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reusedVariables";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parm";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethod/ExtractMethodProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredElements";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateConditionalExitStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNotNullConditionalStatement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findReusedVariables";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "inferNullability";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "generateMethodCall";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectivelyLocalVariables";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMultipleOutputMessageError";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterNameGenerator";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inferNullability";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCastRequired";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findReusedVariables";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "declareReusedVariables";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateNullabilityAnnotation";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findCopy";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithBlockStatementIfNeeded";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "buildMultipleOutputMessageError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 10, 11, 17, 18, 19, 20, 21, 27, 28, 30, 31, 32 -> new IllegalStateException(string);
        };
    }
}

