/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.DiffRequestPanel;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SignatureSuggesterPreviewDialog
extends DialogWrapper {
    @NonNls
    private static final String DIFF_PLACE = "ExtractSignature";
    private final PsiMethod myOldMethod;
    private final PsiMethod myNewMethod;
    private final PsiMethodCallExpression myOldCall;
    private final PsiMethodCallExpression myNewCall;
    private final int myParametrizedDuplicatesNumber;
    private final int myExactDuplicatesNumber;

    public SignatureSuggesterPreviewDialog(@NotNull PsiMethod oldMethod, @NotNull PsiMethod newMethod, @NotNull PsiMethodCallExpression oldMethodCall, @NotNull PsiMethodCallExpression newMethodCall, int exactDuplicatesNumber, int parametrizedDuplicatesNumber) {
        if (oldMethod == null) {
            SignatureSuggesterPreviewDialog.$$$reportNull$$$0(0);
        }
        if (newMethod == null) {
            SignatureSuggesterPreviewDialog.$$$reportNull$$$0(1);
        }
        if (oldMethodCall == null) {
            SignatureSuggesterPreviewDialog.$$$reportNull$$$0(2);
        }
        if (newMethodCall == null) {
            SignatureSuggesterPreviewDialog.$$$reportNull$$$0(3);
        }
        super(oldMethod.getProject());
        this.myOldMethod = oldMethod;
        this.myNewMethod = newMethod;
        this.myOldCall = oldMethodCall;
        this.myNewCall = newMethodCall;
        this.myParametrizedDuplicatesNumber = parametrizedDuplicatesNumber;
        this.myExactDuplicatesNumber = exactDuplicatesNumber;
        this.setTitle(JavaRefactoringBundle.message((String)"extract.parameters.to.replace.duplicates", (Object[])new Object[0]));
        this.setOKButtonText(JavaRefactoringBundle.message((String)"accept.signature.change", (Object[])new Object[0]));
        this.setCancelButtonText(JavaRefactoringBundle.message((String)"keep.original.signature", (Object[])new Object[0]));
        this.init();
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return new JLabel(JavaRefactoringBundle.message((String)"no.exact.method.duplicates.were.found", (Object[])new Object[]{this.myExactDuplicatesNumber, this.myParametrizedDuplicatesNumber}));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        Project project = this.myOldMethod.getProject();
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)this.myOldMethod);
        DiffContentFactory contentFactory = DiffContentFactory.getInstance();
        @Nls String methodCallPrefix = JavaRefactoringBundle.message((String)"suggest.signature.preview.method.call.prefix", (Object[])new Object[0]);
        DocumentContent oldContent = contentFactory.create(this.myOldMethod.getText() + "\n\n\n" + methodCallPrefix + "\n " + this.myOldCall.getText(), file);
        DocumentContent newContent = contentFactory.create(this.myNewMethod.getText() + "\n\n\n" + methodCallPrefix + "\n " + this.myNewCall.getText(), file);
        SimpleDiffRequest request = new SimpleDiffRequest(null, (DiffContent)oldContent, (DiffContent)newContent, JavaRefactoringBundle.message((String)"suggest.signature.preview.title.before", (Object[])new Object[0]), JavaRefactoringBundle.message((String)"suggest.signature.preview.after.title", (Object[])new Object[0]));
        DiffRequestPanel diffPanel = DiffManager.getInstance().createRequestPanel(project, this.getDisposable(), null);
        diffPanel.putContextHints(DiffUserDataKeys.PLACE, (Object)DIFF_PLACE);
        diffPanel.setRequest((DiffRequest)request);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)diffPanel.getComponent(), "Center");
        panel.setBorder(IdeBorderFactory.createEmptyBorder((Insets)JBUI.insetsTop((int)5)));
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "oldMethod";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "newMethod";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "oldMethodCall";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "newMethodCall";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/extractMethod/SignatureSuggesterPreviewDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

