/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.extractMethod.preview.ElementsRange;
import com.intellij.refactoring.extractMethod.preview.ExtractableFragment;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageTreeColors;
import com.intellij.usages.ChunkExtractor;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageInfo2UsageAdapter;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FragmentNode
extends DefaultMutableTreeNode
implements Comparable<FragmentNode> {
    @NotNull
    private final @NotNull TextChunk @NotNull [] myTextChunks;
    private final TextChunk myLineNumberChunk;
    private final int myOffset;
    private final ExtractableFragment myFragment;
    private boolean myValid;

    protected FragmentNode(@NotNull PsiElement start, @NotNull PsiElement end, @NotNull ExtractableFragment fragment) {
        if (start == null) {
            FragmentNode.$$$reportNull$$$0(0);
        }
        if (end == null) {
            FragmentNode.$$$reportNull$$$0(1);
        }
        if (fragment == null) {
            FragmentNode.$$$reportNull$$$0(2);
        }
        this.myValid = true;
        this.myTextChunks = this.createTextChunks(start);
        this.myLineNumberChunk = FragmentNode.createNumberChunk(start, end);
        this.myOffset = start.getTextRange().getStartOffset();
        this.myFragment = fragment;
        this.setAllowsChildren(false);
    }

    @NotNull
    @NotNull TextChunk @NotNull [] getTextChunks() {
        if (this.myTextChunks == null) {
            FragmentNode.$$$reportNull$$$0(3);
        }
        return this.myTextChunks;
    }

    TextChunk getLineNumberChunk() {
        return this.myLineNumberChunk;
    }

    @NotNull
    protected @NotNull TextChunk @NotNull [] createTextChunks(@NotNull PsiElement element) {
        if (element == null) {
            FragmentNode.$$$reportNull$$$0(4);
        }
        UsageInfo2UsageAdapter usageAdapter = new UsageInfo2UsageAdapter(new UsageInfo(element));
        PsiFile file = element.getContainingFile();
        TextRange range = element.getTextRange();
        ArrayList result = new ArrayList();
        ChunkExtractor.getExtractor((PsiFile)file).appendTextChunks(usageAdapter, (CharSequence)file.getText(), range.getStartOffset(), range.getEndOffset(), false, result);
        TextChunk[] textChunkArray = result.toArray(TextChunk.EMPTY_ARRAY);
        if (textChunkArray == null) {
            FragmentNode.$$$reportNull$$$0(5);
        }
        return textChunkArray;
    }

    private static TextChunk createNumberChunk(@NotNull PsiElement start, @NotNull PsiElement end) {
        Document document;
        if (start == null) {
            FragmentNode.$$$reportNull$$$0(6);
        }
        if (end == null) {
            FragmentNode.$$$reportNull$$$0(7);
        }
        if ((document = PsiDocumentManager.getInstance((Project)start.getProject()).getDocument(start.getContainingFile())) != null) {
            int endLine;
            int startLine = FragmentNode.getLineNumber(document, start.getTextRange().getStartOffset()) + 1;
            Object lineText = startLine == (endLine = FragmentNode.getLineNumber(document, end.getTextRange().getEndOffset()) + 1) ? Integer.toString(startLine) : startLine + ".." + endLine;
            return new TextChunk(UsageTreeColors.NUMBER_OF_USAGES_ATTRIBUTES.toTextAttributes(), (String)lineText + "  ");
        }
        return null;
    }

    @Nullable
    public Navigatable getNavigatable() {
        return this.myFragment.getNavigatable();
    }

    public boolean isExcluded() {
        return false;
    }

    public synchronized boolean isValid() {
        return this.myValid;
    }

    public synchronized void setValid(boolean valid) {
        this.myValid = valid;
    }

    @Nullable
    public TextRange getTextRange() {
        return this.myFragment.getTextRange();
    }

    @Nullable
    ElementsRange getElementsRange() {
        return this.myFragment.getElementsRange();
    }

    private static int getLineNumber(@NotNull Document document, int offset) {
        if (document == null) {
            FragmentNode.$$$reportNull$$$0(8);
        }
        if (document.getTextLength() == 0) {
            return 0;
        }
        if (offset >= document.getTextLength()) {
            return document.getLineCount();
        }
        return document.getLineNumber(offset);
    }

    @Override
    public int compareTo(@NotNull FragmentNode o) {
        if (o == null) {
            FragmentNode.$$$reportNull$$$0(9);
        }
        return this.myOffset - o.myOffset;
    }

    @Override
    public String toString() {
        String lineNumber = this.myLineNumberChunk != null ? this.myLineNumberChunk.getText().trim() + ":" : "";
        return Stream.of(this.myTextChunks).map(TextChunk::getText).collect(Collectors.joining("", lineNumber, ""));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethod/preview/FragmentNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethod/preview/FragmentNode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextChunks";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextChunks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTextChunks";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createNumberChunk";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLineNumber";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }
}

