/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.extractMethodObject.LightMethodObjectExtractedData;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ExtractGeneratedClassUtil {
    private static final Logger LOG = Logger.getInstance(ExtractGeneratedClassUtil.class);

    ExtractGeneratedClassUtil() {
    }

    static PsiClass extractGeneratedClass(@NotNull PsiClass generatedInnerClass, @NotNull PsiElementFactory elementFactory, @NotNull PsiElement anchor, @Nullable String explicitGeneratedEvaluationClassFullName) {
        int dotIndex;
        if (generatedInnerClass == null) {
            ExtractGeneratedClassUtil.$$$reportNull$$$0(0);
        }
        if (elementFactory == null) {
            ExtractGeneratedClassUtil.$$$reportNull$$$0(1);
        }
        if (anchor == null) {
            ExtractGeneratedClassUtil.$$$reportNull$$$0(2);
        }
        Project project = generatedInnerClass.getProject();
        if (explicitGeneratedEvaluationClassFullName == null) {
            explicitGeneratedEvaluationClassFullName = "idea.debugger.rt.GeneratedEvaluationClass";
        }
        String generatedEvaluationClass = (dotIndex = explicitGeneratedEvaluationClassFullName.lastIndexOf(46)) == -1 ? explicitGeneratedEvaluationClassFullName : explicitGeneratedEvaluationClassFullName.substring(dotIndex + 1);
        String packageName = dotIndex == -1 ? "" : explicitGeneratedEvaluationClassFullName.substring(0, dotIndex);
        PsiClass extractedClass = elementFactory.createClass(generatedEvaluationClass);
        for (PsiField psiField : generatedInnerClass.getAllFields()) {
            extractedClass.add((PsiElement)elementFactory.createFieldFromText(psiField.getText(), anchor));
        }
        for (PsiField psiField : generatedInnerClass.getMethods()) {
            extractedClass.add((PsiElement)elementFactory.createMethodFromText(psiField.getText(), anchor));
        }
        PsiJavaFile generatedFile = (PsiJavaFile)PsiFileFactory.getInstance((Project)project).createFileFromText(extractedClass.getName() + ".java", (FileType)JavaFileType.INSTANCE, (CharSequence)extractedClass.getContainingFile().getText());
        generatedFile.setPackageName(packageName);
        extractedClass = (PsiClass)PsiTreeUtil.findChildOfType((PsiElement)generatedFile, PsiClass.class);
        ExtractGeneratedClassUtil.copyStaticImports((PsiElement)generatedInnerClass, generatedFile, elementFactory);
        assert (extractedClass != null);
        PsiElement codeBlock = PsiTreeUtil.findFirstParent((PsiElement)anchor, (boolean)false, element -> element instanceof PsiCodeBlock);
        if (codeBlock == null) {
            codeBlock = anchor.getParent();
        }
        ExtractGeneratedClassUtil.addGeneratedClassInfo(codeBlock, generatedInnerClass, extractedClass);
        return extractedClass;
    }

    private static void copyStaticImports(@NotNull PsiElement from, @NotNull PsiJavaFile destFile, @NotNull PsiElementFactory elementFactory) {
        PsiImportList sourceImportList;
        PsiJavaFile fromFile;
        if (from == null) {
            ExtractGeneratedClassUtil.$$$reportNull$$$0(3);
        }
        if (destFile == null) {
            ExtractGeneratedClassUtil.$$$reportNull$$$0(4);
        }
        if (elementFactory == null) {
            ExtractGeneratedClassUtil.$$$reportNull$$$0(5);
        }
        if ((fromFile = (PsiJavaFile)PsiTreeUtil.getParentOfType((PsiElement)from, PsiJavaFile.class)) != null && (sourceImportList = fromFile.getImportList()) != null) {
            PsiImportList destImportList = destFile.getImportList();
            LOG.assertTrue(destImportList != null, (Object)"import list of destination file should not be null");
            for (PsiImportStatementBase importStatement : sourceImportList.getAllImportStatements()) {
                if (!(importStatement instanceof PsiImportStaticStatement) || !ExtractGeneratedClassUtil.isPublic((PsiImportStaticStatement)importStatement)) continue;
                PsiElement importStatementCopy = ExtractGeneratedClassUtil.copy((PsiImportStaticStatement)importStatement, elementFactory);
                if (importStatementCopy != null) {
                    destImportList.add(importStatementCopy);
                    continue;
                }
                LOG.warn("Unable to copy static import statement: " + importStatement.getText());
            }
        }
    }

    @Nullable
    private static PsiElement copy(@NotNull PsiImportStaticStatement importStatement, @NotNull PsiElementFactory elementFactory) {
        if (importStatement == null) {
            ExtractGeneratedClassUtil.$$$reportNull$$$0(6);
        }
        if (elementFactory == null) {
            ExtractGeneratedClassUtil.$$$reportNull$$$0(7);
        }
        PsiClass targetClass = importStatement.resolveTargetClass();
        String memberName = importStatement.getReferenceName();
        if (targetClass != null && memberName != null) {
            return elementFactory.createImportStaticStatement(targetClass, memberName);
        }
        return null;
    }

    private static boolean isPublic(@NotNull PsiImportStaticStatement staticImport) {
        PsiJavaCodeReferenceElement reference;
        PsiClass targetClass;
        if (staticImport == null) {
            ExtractGeneratedClassUtil.$$$reportNull$$$0(8);
        }
        if ((targetClass = staticImport.resolveTargetClass()) != null && ExtractGeneratedClassUtil.isPublicClass(targetClass) && (reference = staticImport.getImportReference()) != null) {
            JavaResolveResult[] targets;
            for (JavaResolveResult target : targets = reference.multiResolve(false)) {
                PsiElement importedElement = target.getElement();
                if (!(importedElement instanceof PsiModifierListOwner) || !((PsiModifierListOwner)importedElement).hasModifierProperty("public")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isPublicClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ExtractGeneratedClassUtil.$$$reportNull$$$0(9);
        }
        while (psiClass != null) {
            if (!psiClass.hasModifierProperty("public")) {
                return false;
            }
            psiClass = psiClass.getContainingClass();
        }
        return true;
    }

    private static void addGeneratedClassInfo(@NotNull PsiElement element, final @NotNull PsiClass generatedClass, final @NotNull PsiClass extractedClass) {
        if (element == null) {
            ExtractGeneratedClassUtil.$$$reportNull$$$0(10);
        }
        if (generatedClass == null) {
            ExtractGeneratedClassUtil.$$$reportNull$$$0(11);
        }
        if (extractedClass == null) {
            ExtractGeneratedClassUtil.$$$reportNull$$$0(12);
        }
        generatedClass.putUserData(LightMethodObjectExtractedData.REFERENCED_TYPE, (Object)PsiTypesUtil.getClassType((PsiClass)extractedClass));
        element.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitNewExpression(@NotNull PsiNewExpression expression) {
                List methods;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitNewExpression(expression);
                PsiMethod constructor = expression.resolveConstructor();
                if (constructor != null && generatedClass.equals((Object)constructor.getContainingClass()) && (methods = ContainerUtil.filter((Object[])extractedClass.getConstructors(), x -> 1.isSameMethod(x, constructor))).size() == 1) {
                    LOG.info("Replace constructor: " + constructor.getName());
                    constructor.putUserData(LightMethodObjectExtractedData.REFERENCE_METHOD, (Object)((PsiMethod)methods.get(0)));
                }
            }

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                List methods;
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitMethodCallExpression(expression);
                PsiMethod method = expression.resolveMethod();
                if (method != null && generatedClass.equals((Object)method.getContainingClass()) && (methods = ContainerUtil.filter((Object[])extractedClass.getMethods(), x -> 1.isSameMethod(x, method))).size() == 1) {
                    LOG.info("Replace method: " + method.getName());
                    method.putUserData(LightMethodObjectExtractedData.REFERENCE_METHOD, (Object)((PsiMethod)methods.get(0)));
                }
            }

            private static boolean isSameMethod(@NotNull PsiMethod first, @NotNull PsiMethod second) {
                if (first == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (second == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (first.getName().equals(second.getName())) {
                    return first.getParameterList().getParametersCount() == second.getParameterList().getParametersCount();
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "first";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "second";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/refactoring/extractMethodObject/ExtractGeneratedClassUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNewExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSameMethod";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedInnerClass";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticImport";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractedClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethodObject/ExtractGeneratedClassUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "extractGeneratedClass";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "copyStaticImports";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "copy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isPublic";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isPublicClass";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addGeneratedClassInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

