/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject;

import com.intellij.codeInsight.CodeInsightFrontbackUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowOptions;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethodObject.ExtractGeneratedClassUtil;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectProcessor;
import com.intellij.refactoring.extractMethodObject.LightMethodObjectExtractedData;
import com.intellij.refactoring.extractMethodObject.reflect.ReflectionAccessorToEverything;
import com.intellij.refactoring.util.VariableData;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtractLightMethodObjectHandler {
    private static final Logger LOG = Logger.getInstance(ExtractLightMethodObjectHandler.class);

    @Nullable
    public static LightMethodObjectExtractedData extractLightMethodObject(Project project, @Nullable PsiElement originalContext, @NotNull PsiCodeFragment fragment, @NotNull String methodName, @Nullable JavaSdkVersion javaVersion) throws PrepareFailedException {
        if (fragment == null) {
            ExtractLightMethodObjectHandler.$$$reportNull$$$0(0);
        }
        if (methodName == null) {
            ExtractLightMethodObjectHandler.$$$reportNull$$$0(1);
        }
        return ExtractLightMethodObjectHandler.extractLightMethodObject(project, originalContext, fragment, methodName, javaVersion, null);
    }

    @ApiStatus.Internal
    @Nullable
    public static LightMethodObjectExtractedData extractLightMethodObject(Project project, @Nullable PsiElement originalContext, @NotNull PsiCodeFragment fragment, final @NotNull String methodName, @Nullable JavaSdkVersion javaVersion, @Nullable String explicitGeneratedEvaluationClassName) throws PrepareFailedException {
        int startOffsetInContainer;
        boolean useMagicAccessor;
        ControlFlow controlFlow;
        PsiReturnStatement returnStatement;
        PsiExpression expr;
        PsiElement firstElementCopy;
        PsiElement[] allElementsCopy;
        Object[] elementsCopy;
        PsiElement container;
        PsiElement anchor;
        PsiLambdaExpression lambdaExpression;
        PsiClass containingClass;
        PsiElement elementAt;
        TextRange range;
        PsiElement originalAnchor;
        PsiElement identifier;
        PsiNameIdentifierOwner identifierOwner;
        PsiElementFactory elementFactory;
        PsiElement[] elements;
        if (fragment == null) {
            ExtractLightMethodObjectHandler.$$$reportNull$$$0(2);
        }
        if (methodName == null) {
            ExtractLightMethodObjectHandler.$$$reportNull$$$0(3);
        }
        if ((elements = ExtractLightMethodObjectHandler.completeToStatementArray(fragment, elementFactory = JavaPsiFacade.getElementFactory((Project)project))) == null) {
            elements = CodeInsightFrontbackUtil.findStatementsInRange((PsiFile)fragment, (int)0, (int)fragment.getTextLength());
        }
        if (elements.length == 0) {
            return null;
        }
        if (originalContext == null) {
            return null;
        }
        PsiFile file = originalContext.getContainingFile();
        PsiFile copy = PsiFileFactory.getInstance((Project)project).createFileFromText(file.getName(), file.getFileType(), (CharSequence)file.getText(), file.getModificationStamp(), false);
        if (copy instanceof PsiJavaFile) {
            PsiJavaFile copyJavaFile = (PsiJavaFile)copy;
            if (file instanceof PsiJavaFile) {
                PsiJavaFile originalJavaFile = (PsiJavaFile)file;
                LanguageLevel level = PsiUtil.getLanguageLevel((PsiElement)originalJavaFile);
                PsiUtil.FILE_LANGUAGE_LEVEL_KEY.set((UserDataHolder)copyJavaFile, (Object)level);
            }
        }
        if (originalContext instanceof PsiKeyword && "private".equals(originalContext.getText()) && (identifierOwner = (PsiNameIdentifierOwner)PsiTreeUtil.getParentOfType((PsiElement)originalContext, PsiNameIdentifierOwner.class)) != null && (identifier = identifierOwner.getNameIdentifier()) != null) {
            originalContext = identifier;
        }
        if ((originalAnchor = CodeInsightFrontbackUtil.findElementInRange((PsiFile)copy, (int)(range = originalContext.getTextRange()).getStartOffset(), (int)range.getEndOffset(), (Class)originalContext.getClass())) == null && (elementAt = copy.findElementAt(range.getStartOffset())) != null && elementAt.getClass() == originalContext.getClass()) {
            originalAnchor = PsiTreeUtil.skipWhitespacesForward((PsiElement)elementAt);
        }
        if ((containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)originalAnchor, PsiClass.class, (boolean)false)) == null) {
            return null;
        }
        PsiElement containingMethod = PsiTreeUtil.getParentOfType((PsiElement)originalAnchor, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class});
        if (containingMethod instanceof PsiLambdaExpression && (lambdaExpression = (PsiLambdaExpression)containingMethod).getBody() instanceof PsiExpression) {
            PsiCodeBlock newBody = CommonJavaRefactoringUtil.expandExpressionLambdaToCodeBlock((PsiLambdaExpression)lambdaExpression);
            originalAnchor = newBody.getStatements()[0];
        }
        if ((anchor = CommonJavaRefactoringUtil.getParentStatement((PsiElement)originalAnchor, (boolean)false)) == null && PsiTreeUtil.getParentOfType((PsiElement)originalAnchor, PsiCodeBlock.class) != null) {
            anchor = originalAnchor;
        }
        if (anchor == null) {
            container = ((PsiClassInitializer)containingClass.add((PsiElement)elementFactory.createClassInitializer())).getBody();
            anchor = container.getLastChild();
        } else {
            container = anchor.getParent();
        }
        if (anchor instanceof PsiStatement && CommonJavaRefactoringUtil.isLoopOrIf((PsiElement)container)) {
            PsiBlockStatement codeBlockStatement = (PsiBlockStatement)JavaPsiFacade.getElementFactory((Project)project).createStatementFromText("{}", container);
            codeBlockStatement.getCodeBlock().add(anchor);
            PsiCodeBlock codeBlock = ((PsiBlockStatement)anchor.replace((PsiElement)codeBlockStatement)).getCodeBlock();
            originalAnchor = anchor = codeBlock.getStatements()[0];
            container = codeBlock;
        }
        if ((elementsCopy = (PsiElement[])Arrays.stream(allElementsCopy = CodeInsightFrontbackUtil.findStatementsInRange((PsiFile)copy, (int)(firstElementCopy = container.addRangeBefore(elements[0], elements[elements.length - 1], anchor)).getTextRange().getStartOffset(), (int)anchor.getTextRange().getStartOffset())).filter(e -> !(e instanceof PsiComment)).toArray(PsiElement[]::new)).length == 0) {
            return null;
        }
        PsiElement lastElement = (PsiElement)ArrayUtil.getLastElement((Object[])elementsCopy);
        if (lastElement instanceof PsiExpressionStatement) {
            PsiExpressionStatement expressionStatement = (PsiExpressionStatement)lastElement;
            expr = expressionStatement.getExpression();
            ExtractLightMethodObjectHandler.generateResult(project, expr, (PsiElement[])elementsCopy, elementFactory);
        } else if (lastElement instanceof PsiReturnStatement && (expr = (returnStatement = (PsiReturnStatement)lastElement).getReturnValue()) != null) {
            ExtractLightMethodObjectHandler.generateResult(project, expr, (PsiElement[])elementsCopy, elementFactory);
        }
        LOG.assertTrue(elementsCopy[0].getParent() == container, (Object)("element: " + elementsCopy[0].getText() + "; container: " + container.getText()));
        try {
            controlFlow = ControlFlowFactory.getControlFlow((PsiElement)container, (ControlFlowPolicy)LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), (ControlFlowOptions)ControlFlowOptions.NO_CONST_EVALUATE);
        }
        catch (AnalysisCanceledException e2) {
            return null;
        }
        List variables = ControlFlowUtil.getUsedVariables((ControlFlow)controlFlow, (int)controlFlow.getStartOffset((PsiElement)elementsCopy[0]), (int)controlFlow.getEndOffset((PsiElement)elementsCopy[elementsCopy.length - 1]));
        variables = ContainerUtil.filter((Collection)variables, arg_0 -> ExtractLightMethodObjectHandler.lambda$extractLightMethodObject$2((PsiElement[])elementsCopy, arg_0));
        String outputVariables = StringUtil.join((Collection)variables, variable -> "\"variable: \" + " + variable.getName(), (String)" +");
        PsiStatement outStatement = elementFactory.createStatementFromText("System.out.println(" + outputVariables + ");", anchor);
        outStatement = (PsiStatement)container.addAfter((PsiElement)outStatement, (PsiElement)elementsCopy[elementsCopy.length - 1]);
        boolean bl = useMagicAccessor = Registry.is((String)"debugger.compiling.evaluator.magic.accessor") && javaVersion != null && !javaVersion.isAtLeast(JavaSdkVersion.JDK_1_9);
        if (useMagicAccessor) {
            LOG.info("Magic accessor available");
            copy.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                private static void makePublic(PsiMember method) {
                    if (method.hasModifierProperty("private")) {
                        VisibilityUtil.setVisibility((PsiModifierList)method.getModifierList(), (String)"public");
                    }
                }

                public void visitMethod(@NotNull PsiMethod method) {
                    if (method == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitMethod(method);
                    1.makePublic((PsiMember)method);
                }

                public void visitField(@NotNull PsiField field) {
                    if (field == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.visitField(field);
                    1.makePublic((PsiMember)field);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "method";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "field";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/refactoring/extractMethodObject/ExtractLightMethodObjectHandler$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitMethod";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitField";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        ExtractMethodObjectProcessor extractMethodObjectProcessor = new ExtractMethodObjectProcessor(project, null, (PsiElement[])elementsCopy, ""){

            @Override
            protected AbstractExtractDialog createExtractMethodObjectDialog(ExtractMethodObjectProcessor.MyExtractMethodProcessor processor) {
                return new LightExtractMethodObjectDialog(this, methodName);
            }

            @Override
            protected PsiElement addInnerClass(PsiClass containingClass, PsiClass innerClass) {
                return containingClass.addBefore((PsiElement)innerClass, containingClass.getLastChild());
            }

            @Override
            protected boolean isFoldingApplicable() {
                return false;
            }
        };
        extractMethodObjectProcessor.getExtractProcessor().setShowErrorDialogs(false);
        ExtractMethodObjectProcessor.MyExtractMethodProcessor extractProcessor = extractMethodObjectProcessor.getExtractProcessor();
        if (extractProcessor.prepare()) {
            boolean shown = extractProcessor.showDialog();
            if (!shown) {
                throw new IllegalStateException("Must return success");
            }
            try {
                extractProcessor.doExtract();
                startOffsetInContainer = Objects.requireNonNull((PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)extractProcessor.getMethodCall(), PsiStatement.class)).getTextRangeInParent().getStartOffset();
                UsageInfo[] usages = extractMethodObjectProcessor.findUsages();
                extractMethodObjectProcessor.performRefactoring(usages);
                extractMethodObjectProcessor.runChangeSignature();
            }
            catch (IncorrectOperationException e3) {
                LOG.error((Throwable)e3);
                return null;
            }
            if (extractMethodObjectProcessor.isCreateInnerClass()) {
                extractMethodObjectProcessor.changeInstanceAccess(project);
            }
        } else {
            return null;
        }
        PsiMethod method = extractMethodObjectProcessor.getMethod();
        LOG.assertTrue(method != null);
        method.delete();
        int startOffset = startOffsetInContainer + container.getTextRange().getStartOffset();
        PsiClass inner = extractMethodObjectProcessor.getInnerClass();
        PsiMethod[] methods = inner.findMethodsByName("invoke", false);
        boolean useReflection = javaVersion == null || javaVersion.isAtLeast(JavaSdkVersion.JDK_1_9) || Registry.is((String)"debugger.compiling.evaluator.reflection.access.with.java8");
        PsiClass generatedClass = extractMethodObjectProcessor.getInnerClass();
        if (useReflection && methods.length == 1) {
            PsiMethod method2 = methods[0];
            PsiMethodCallExpression callExpression = ExtractLightMethodObjectHandler.findCallExpression(copy, method2);
            if (callExpression != null) {
                boolean isJdkAtLeast11;
                LOG.info("Use reflection to evaluate inaccessible members");
                new ReflectionAccessorToEverything(generatedClass, elementFactory).grantAccessThroughReflection(callExpression);
                boolean bl2 = isJdkAtLeast11 = javaVersion == null || javaVersion.isAtLeast(JavaSdkVersion.JDK_11);
                if (isJdkAtLeast11 || Registry.is((String)"debugger.compiling.evaluator.extract.generated.class")) {
                    generatedClass = ExtractGeneratedClassUtil.extractGeneratedClass(generatedClass, elementFactory, anchor, explicitGeneratedEvaluationClassName);
                }
            } else {
                LOG.warn("Generated method call expression not found");
            }
        }
        String generatedCall = copy.getText().substring(startOffset, outStatement.getTextOffset()).trim();
        return new LightMethodObjectExtractedData(generatedCall, (PsiClass)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)generatedClass), originalAnchor, useMagicAccessor);
    }

    private static void generateResult(@NotNull Project project, @NotNull PsiExpression expr, PsiElement[] elementsCopy, @NotNull PsiElementFactory elementFactory) {
        PsiType expressionType;
        if (project == null) {
            ExtractLightMethodObjectHandler.$$$reportNull$$$0(4);
        }
        if (expr == null) {
            ExtractLightMethodObjectHandler.$$$reportNull$$$0(5);
        }
        if (elementFactory == null) {
            ExtractLightMethodObjectHandler.$$$reportNull$$$0(6);
        }
        if ((expressionType = GenericsUtil.getVariableTypeByExpressionType((PsiType)expr.getType())) instanceof PsiDisjunctionType) {
            expressionType = ((PsiDisjunctionType)expressionType).getLeastUpperBound();
        }
        if (ExtractLightMethodObjectHandler.isValidVariableType(expressionType)) {
            String uniqueResultName = JavaCodeStyleManager.getInstance((Project)project).suggestUniqueVariableName("result", elementsCopy[0], true);
            String text = PsiTypes.nullType().equals(expressionType) ? "java.lang.Object" : expressionType.getCanonicalText();
            String statementText = text + " " + uniqueResultName + " = " + expr.getText() + ";";
            elementsCopy[elementsCopy.length - 1] = elementsCopy[elementsCopy.length - 1].replace((PsiElement)elementFactory.createStatementFromText(statementText, elementsCopy[elementsCopy.length - 1]));
        }
    }

    @Nullable
    private static PsiMethodCallExpression findCallExpression(@NotNull PsiFile copy, final @NotNull PsiMethod method) {
        if (copy == null) {
            ExtractLightMethodObjectHandler.$$$reportNull$$$0(7);
        }
        if (method == null) {
            ExtractLightMethodObjectHandler.$$$reportNull$$$0(8);
        }
        final PsiMethodCallExpression[] result = new PsiMethodCallExpression[1];
        copy.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                if (expression == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (method.equals((Object)expression.resolveMethod())) {
                    if (result[0] != null) {
                        LOG.error("To many generated method invocations found");
                    } else {
                        result[0] = expression;
                    }
                }
                super.visitMethodCallExpression(expression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/extractMethodObject/ExtractLightMethodObjectHandler$3", "visitMethodCallExpression"));
            }
        });
        return result[0];
    }

    private static PsiElement @Nullable [] completeToStatementArray(PsiCodeFragment fragment, PsiElementFactory elementFactory) {
        PsiExpression expression = CodeInsightFrontbackUtil.findExpressionInRange((PsiFile)fragment, (int)0, (int)fragment.getTextLength());
        if (expression != null) {
            Object completeExpressionText = null;
            if (expression instanceof PsiArrayInitializerExpression) {
                PsiType type;
                PsiExpression[] initializers = ((PsiArrayInitializerExpression)expression).getInitializers();
                if (initializers.length > 0 && (type = initializers[0].getType()) != null) {
                    completeExpressionText = "new " + type.getCanonicalText() + "[]" + expression.getText();
                }
            } else {
                completeExpressionText = expression.getText();
            }
            if (completeExpressionText != null) {
                return new PsiElement[]{elementFactory.createStatementFromText((String)completeExpressionText + ";", (PsiElement)expression)};
            }
        }
        return null;
    }

    private static boolean isValidVariableType(PsiType type) {
        return type instanceof PsiClassType || type instanceof PsiArrayType || type instanceof PsiPrimitiveType && !PsiTypes.voidType().equals((Object)type);
    }

    private static /* synthetic */ boolean lambda$extractLightMethodObject$2(PsiElement[] elementsCopy, PsiVariable variable) {
        PsiElement variableScope = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null);
        return variableScope != null && PsiTreeUtil.isAncestor((PsiElement)variableScope, (PsiElement)elementsCopy[elementsCopy.length - 1], (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethodObject/ExtractLightMethodObjectHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "extractLightMethodObject";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "generateResult";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findCallExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LightExtractMethodObjectDialog
    implements AbstractExtractDialog {
        private final ExtractMethodObjectProcessor myProcessor;
        @NotNull
        private final String myMethodName;

        LightExtractMethodObjectDialog(ExtractMethodObjectProcessor processor, @NotNull String methodName) {
            if (methodName == null) {
                LightExtractMethodObjectDialog.$$$reportNull$$$0(0);
            }
            this.myProcessor = processor;
            this.myMethodName = methodName;
        }

        @Override
        @NotNull
        public String getChosenMethodName() {
            String string = this.myMethodName;
            if (string == null) {
                LightExtractMethodObjectDialog.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public VariableData[] getChosenParameters() {
            InputVariables inputVariables = this.myProcessor.getExtractProcessor().getInputVariables();
            return inputVariables.getInputVariables().toArray(new VariableData[0]);
        }

        @Override
        @NotNull
        public String getVisibility() {
            return "packageLocal";
        }

        @Override
        public boolean isMakeStatic() {
            return this.myProcessor.getExtractProcessor().isCanBeStatic() && !this.myProcessor.getExtractProcessor().getInputVariables().hasInstanceFields();
        }

        @Override
        public boolean isChainedConstructor() {
            return false;
        }

        @Override
        public PsiType getReturnType() {
            return null;
        }

        @Override
        public void show() {
        }

        @Override
        public boolean isOK() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/extractMethodObject/ExtractLightMethodObjectHandler$LightExtractMethodObjectDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/extractMethodObject/ExtractLightMethodObjectHandler$LightExtractMethodObjectDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChosenMethodName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

