/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodDeclarationDescriptor
implements ItemToReplaceDescriptor {
    private static final Logger LOG = Logger.getInstance(MethodDeclarationDescriptor.class);
    private final PsiMethod myMethod;
    private final PsiType myType;

    private MethodDeclarationDescriptor(@NotNull PsiMethod method, @NotNull PsiType type) {
        if (method == null) {
            MethodDeclarationDescriptor.$$$reportNull$$$0(0);
        }
        if (type == null) {
            MethodDeclarationDescriptor.$$$reportNull$$$0(1);
        }
        this.myMethod = method;
        this.myType = type;
    }

    @Override
    public void replace(@NotNull PsiClass outerClass, @NotNull PsiElementFactory elementFactory, @NotNull PsiMethodCallExpression callExpression) {
        if (outerClass == null) {
            MethodDeclarationDescriptor.$$$reportNull$$$0(2);
        }
        if (elementFactory == null) {
            MethodDeclarationDescriptor.$$$reportNull$$$0(3);
        }
        if (callExpression == null) {
            MethodDeclarationDescriptor.$$$reportNull$$$0(4);
        }
        PsiType nearestAccessibleType = PsiReflectionAccessUtil.nearestAccessibleType(this.myType, (PsiElement)callExpression);
        PsiTypeElement returnTypeElement = this.myMethod.getReturnTypeElement();
        if (returnTypeElement != null) {
            returnTypeElement.replace((PsiElement)elementFactory.createTypeElement(nearestAccessibleType));
        }
        if (this.myMethod.equals((Object)callExpression.resolveMethod())) {
            PsiElement parent = callExpression.getParent();
            if (parent instanceof PsiLocalVariable) {
                ((PsiLocalVariable)parent).getTypeElement().replace((PsiElement)elementFactory.createTypeElement(nearestAccessibleType));
            } else {
                LOG.error("Unexpected psi parent type of call expression: " + parent.getClass().getCanonicalName());
            }
        }
    }

    @Nullable
    public static ItemToReplaceDescriptor createIfInaccessible(@NotNull PsiMethod method, @NotNull PsiClass outerClass) {
        PsiType returnType;
        if (method == null) {
            MethodDeclarationDescriptor.$$$reportNull$$$0(5);
        }
        if (outerClass == null) {
            MethodDeclarationDescriptor.$$$reportNull$$$0(6);
        }
        if ((returnType = method.getReturnType()) != null && !outerClass.equals((Object)PsiTypesUtil.getPsiClass((PsiType)returnType)) && !PsiReflectionAccessUtil.isAccessibleType(returnType)) {
            return new MethodDeclarationDescriptor(method, returnType);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/MethodDeclarationDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "replace";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createIfInaccessible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

