/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PsiReflectionAccessUtil {
    PsiReflectionAccessUtil() {
    }

    public static boolean isPublicMember(@NotNull PsiMember classMember) {
        if (classMember == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(0);
        }
        return classMember.hasModifierProperty("public") && PsiReflectionAccessUtil.isAccessible(classMember.getContainingClass());
    }

    public static boolean isAccessibleMember(@NotNull PsiMember classMember, @NotNull PsiClass outerClass, @Nullable PsiExpression qualifier) {
        if (classMember == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(1);
        }
        if (outerClass == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(2);
        }
        if (!PsiReflectionAccessUtil.isPublicMember(classMember)) {
            return false;
        }
        if (PsiUtil.isArrayClass((PsiElement)classMember.getContainingClass())) {
            return true;
        }
        if (qualifier != null) {
            return PsiReflectionAccessUtil.isQualifierAccessible(qualifier);
        }
        return !Objects.equals(outerClass.getContainingFile(), classMember.getContainingFile());
    }

    @Contract(value="null -> false")
    public static boolean isAccessible(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        if (PsiUtil.isArrayClass((PsiElement)psiClass)) {
            return true;
        }
        PsiFile containingFile = psiClass.getContainingFile();
        if (containingFile instanceof PsiJavaFile && ((PsiJavaFile)containingFile).getPackageName().isEmpty()) {
            return false;
        }
        while (psiClass != null) {
            if (!psiClass.hasModifierProperty("public")) {
                return false;
            }
            psiClass = psiClass.getContainingClass();
        }
        return true;
    }

    public static boolean isAccessibleMethodReference(@NotNull PsiMethodReferenceExpression methodReference) {
        PsiElement method;
        if (methodReference == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(3);
        }
        if (!((method = methodReference.resolve()) instanceof PsiMethod)) {
            return true;
        }
        PsiTypeElement qualifierType = methodReference.getQualifierType();
        boolean qualifierAccessible = qualifierType == null || PsiReflectionAccessUtil.isAccessibleType(qualifierType.getType());
        return qualifierAccessible && PsiReflectionAccessUtil.isPublicMember((PsiMember)method);
    }

    @Contract(value="null -> true")
    public static boolean isQualifierAccessible(@Nullable PsiExpression qualifierExpression) {
        if (qualifierExpression == null) {
            return true;
        }
        PsiType type = qualifierExpression.getType();
        return type == null || PsiReflectionAccessUtil.isAccessibleType(type);
    }

    @Nullable
    public static String getAccessibleReturnType(@NotNull PsiExpression expression, @Nullable PsiType type) {
        String expectedType;
        if (expression == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(4);
        }
        if ((expectedType = PsiReflectionAccessUtil.tryGetWeakestAccessibleExpectedType(expression)) != null) {
            return expectedType;
        }
        return type != null ? PsiReflectionAccessUtil.nearestAccessibleType(type, (PsiElement)expression).getCanonicalText() : null;
    }

    @Nullable
    public static String getAccessibleReturnType(@NotNull PsiExpression expression, @Nullable PsiClass psiClass) {
        String expectedType;
        if (expression == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(5);
        }
        if ((expectedType = PsiReflectionAccessUtil.tryGetWeakestAccessibleExpectedType(expression)) != null) {
            return expectedType;
        }
        return PsiReflectionAccessUtil.nearestAccessibleBaseClassName(psiClass);
    }

    @Nullable
    private static String tryGetWeakestAccessibleExpectedType(@NotNull PsiExpression expression) {
        if (expression == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(6);
        }
        PsiType expectedType = ExpectedTypeUtils.findExpectedType((PsiExpression)expression, (boolean)true);
        PsiType realType = expression.getType();
        if (expectedType != null && realType != null) {
            for (PsiType type : PsiReflectionAccessUtil.getAllAssignableSupertypes(realType, expectedType)) {
                if (!PsiReflectionAccessUtil.isAccessibleType(type)) continue;
                return type.getCanonicalText();
            }
        }
        return null;
    }

    @NotNull
    private static List<PsiType> getAllAssignableSupertypes(@NotNull PsiType from, @NotNull PsiType to) {
        if (from == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(7);
        }
        if (to == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(8);
        }
        LinkedHashSet<PsiType> types = new LinkedHashSet<PsiType>();
        ArrayDeque<PsiType> queue = new ArrayDeque<PsiType>();
        queue.offer(from);
        while (!queue.isEmpty()) {
            PsiType type = (PsiType)queue.poll();
            if (!to.isAssignableFrom(type)) continue;
            types.add(type);
            Arrays.stream(type.getSuperTypes()).forEach(queue::offer);
        }
        ArrayList<PsiType> result = new ArrayList<PsiType>(types);
        Collections.reverse(result);
        ArrayList<PsiType> arrayList = result;
        if (arrayList == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static String classForName(@NotNull String typeName) {
        if (typeName == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(10);
        }
        String string = TypeConversionUtil.isPrimitive((String)typeName) ? typeName + ".class" : "java.lang.Class.forName(\"" + typeName + "\")";
        if (string == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static String getUniqueMethodName(@NotNull PsiClass psiClass, @NotNull String prefix) {
        String name;
        if (psiClass == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(12);
        }
        if (prefix == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(13);
        }
        if (!StringUtil.isJavaIdentifier((String)prefix)) {
            throw new IllegalArgumentException("prefix must be a correct java identifier: " + prefix);
        }
        int i = 1;
        do {
            name = prefix + i;
            ++i;
        } while (psiClass.findMethodsByName(name, false).length != 0);
        String string = name;
        if (string == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    public static boolean isAccessibleType(@NotNull PsiType type) {
        if (type == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(15);
        }
        if (type instanceof PsiArrayType) {
            return PsiReflectionAccessUtil.isAccessibleType(type.getDeepComponentType());
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type)) {
            return true;
        }
        if (type instanceof PsiCapturedWildcardType) {
            PsiCapturedWildcardType capturedWildcardType = (PsiCapturedWildcardType)type;
            return PsiReflectionAccessUtil.isAccessibleType((PsiType)capturedWildcardType.getWildcard());
        }
        if (type instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)type;
            PsiType bound = wildcardType.getBound();
            return bound == null || PsiReflectionAccessUtil.isAccessibleType(bound);
        }
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)type);
        return PsiReflectionAccessUtil.isAccessible(psiClass) && !PsiReflectionAccessUtil.hasInaccessibleGenerics(type);
    }

    @NotNull
    public static PsiType nearestAccessibleType(@NotNull PsiType type, @NotNull PsiElement context) {
        if (type == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(16);
        }
        if (context == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(17);
        }
        boolean ellipsis = type instanceof PsiEllipsisType;
        while (!PsiReflectionAccessUtil.isAccessibleType(type)) {
            PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)type);
            boolean isAccessible = PsiReflectionAccessUtil.isAccessible(psiClass);
            if (isAccessible && PsiReflectionAccessUtil.hasInaccessibleGenerics(type)) {
                PsiType psiType = TypeConversionUtil.erasure((PsiType)type);
                if (psiType == null) {
                    PsiReflectionAccessUtil.$$$reportNull$$$0(18);
                }
                return psiType;
            }
            PsiType[] types = type.getSuperTypes();
            if (types.length == 0) {
                PsiClassType psiClassType = PsiType.getJavaLangObject((PsiManager)context.getManager(), (GlobalSearchScope)context.getResolveScope());
                if (psiClassType == null) {
                    PsiReflectionAccessUtil.$$$reportNull$$$0(19);
                }
                return psiClassType;
            }
            type = types[0];
            if (!ellipsis || !(type instanceof PsiArrayType)) continue;
            PsiArrayType arrayType = (PsiArrayType)type;
            type = new PsiEllipsisType(arrayType.getComponentType());
        }
        PsiType psiType = type;
        if (psiType == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(20);
        }
        return psiType;
    }

    @Contract(value="null -> null")
    @Nullable
    private static String nearestAccessibleBaseClassName(@Nullable PsiClass psiClass) {
        while (psiClass != null && !PsiReflectionAccessUtil.isAccessible(psiClass)) {
            psiClass = psiClass.getSuperClass();
        }
        return psiClass == null ? null : psiClass.getQualifiedName();
    }

    private static boolean hasInaccessibleGenerics(@NotNull PsiType type) {
        if (type == null) {
            PsiReflectionAccessUtil.$$$reportNull$$$0(21);
        }
        if (type instanceof PsiClassType) {
            return !ContainerUtil.and((Object[])((PsiClassType)type).getParameters(), x -> PsiReflectionAccessUtil.isAccessibleType(x));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 11, 14, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMember";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/extractMethodObject/reflect/PsiReflectionAccessUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 15: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/PsiReflectionAccessUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAssignableSupertypes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "classForName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueMethodName";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "nearestAccessibleType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPublicMember";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleMember";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleMethodReference";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAccessibleReturnType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryGetWeakestAccessibleExpectedType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAllAssignableSupertypes";
                break;
            }
            case 9: 
            case 11: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "classForName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueMethodName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "nearestAccessibleType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "hasInaccessibleGenerics";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 11, 14, 18, 19, 20 -> new IllegalStateException(string);
        };
    }
}

