/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.ConstructorDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.FieldDeclarationDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.FieldDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.LocalVariableDeclarationDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.MethodDeclarationDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.MethodDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.MethodReferenceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.ParameterDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.ThisReferenceDescriptor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class ReflectionAccessorToEverything {
    private final PsiClass myOuterClass;
    private final PsiElementFactory myElementFactory;

    public ReflectionAccessorToEverything(@NotNull PsiClass generatedInnerClass, @NotNull PsiElementFactory elementFactory) {
        if (generatedInnerClass == null) {
            ReflectionAccessorToEverything.$$$reportNull$$$0(0);
        }
        if (elementFactory == null) {
            ReflectionAccessorToEverything.$$$reportNull$$$0(1);
        }
        this.myOuterClass = generatedInnerClass;
        this.myElementFactory = elementFactory;
    }

    public void grantAccessThroughReflection(@NotNull PsiMethodCallExpression generatedMethodCall) {
        if (generatedMethodCall == null) {
            ReflectionAccessorToEverything.$$$reportNull$$$0(2);
        }
        this.replaceAll(new MyInaccessibleMethodReferencesVisitor(), generatedMethodCall);
        this.replaceAll(new MyInaccessibleFieldVisitor(), generatedMethodCall);
        this.replaceAll(new MyInaccessibleItemsVisitor(), generatedMethodCall);
    }

    private void replaceAll(ReplaceVisitor visitor2, @NotNull PsiMethodCallExpression generatedMethodCall) {
        if (generatedMethodCall == null) {
            ReflectionAccessorToEverything.$$$reportNull$$$0(3);
        }
        this.myOuterClass.accept((PsiElementVisitor)visitor2);
        visitor2.getReplaceDescriptors().forEach(descriptor -> descriptor.replace(this.myOuterClass, this.myElementFactory, generatedMethodCall));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedInnerClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedMethodCall";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessorToEverything";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "grantAccessThroughReflection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceAll";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyInaccessibleMethodReferencesVisitor
    extends ReplaceVisitor {
        private MyInaccessibleMethodReferencesVisitor() {
        }

        public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
            if (expression == null) {
                MyInaccessibleMethodReferencesVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodReferenceExpression(expression);
            this.addIfNotNull(MethodReferenceDescriptor.createIfInaccessible(expression));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessorToEverything$MyInaccessibleMethodReferencesVisitor", "visitMethodReferenceExpression"));
        }
    }

    private static abstract class ReplaceVisitor
    extends JavaRecursiveElementVisitor {
        private final List<ItemToReplaceDescriptor> myReplaceDescriptors = new SmartList();

        private ReplaceVisitor() {
        }

        void addIfNotNull(@Nullable ItemToReplaceDescriptor descriptor) {
            if (descriptor != null) {
                this.myReplaceDescriptors.add(descriptor);
            }
        }

        public @Unmodifiable List<ItemToReplaceDescriptor> getReplaceDescriptors() {
            return this.myReplaceDescriptors;
        }
    }

    private class MyInaccessibleFieldVisitor
    extends ReplaceVisitor {
        private MyInaccessibleFieldVisitor() {
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                MyInaccessibleFieldVisitor.$$$reportNull$$$0(0);
            }
            super.visitReferenceExpression(expression);
            this.addIfNotNull(FieldDescriptor.createIfInaccessible(ReflectionAccessorToEverything.this.myOuterClass, expression));
        }

        @Override
        public @Unmodifiable List<ItemToReplaceDescriptor> getReplaceDescriptors() {
            return ContainerUtil.sorted(super.getReplaceDescriptors(), Comparator.comparing(d -> {
                FieldDescriptor fieldDescriptor;
                return d instanceof FieldDescriptor && (fieldDescriptor = (FieldDescriptor)d).isUpdate();
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessorToEverything$MyInaccessibleFieldVisitor", "visitReferenceExpression"));
        }
    }

    private class MyInaccessibleItemsVisitor
    extends ReplaceVisitor {
        private MyInaccessibleItemsVisitor() {
        }

        public void visitParameter(@NotNull PsiParameter parameter) {
            if (parameter == null) {
                MyInaccessibleItemsVisitor.$$$reportNull$$$0(0);
            }
            super.visitParameter(parameter);
            this.addIfNotNull(ParameterDescriptor.createIfInaccessible(parameter));
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MyInaccessibleItemsVisitor.$$$reportNull$$$0(1);
            }
            super.visitMethod(method);
            this.addIfNotNull(MethodDeclarationDescriptor.createIfInaccessible(method, ReflectionAccessorToEverything.this.myOuterClass));
        }

        public void visitThisExpression(@NotNull PsiThisExpression expression) {
            if (expression == null) {
                MyInaccessibleItemsVisitor.$$$reportNull$$$0(2);
            }
            super.visitThisExpression(expression);
            this.addIfNotNull(ThisReferenceDescriptor.createIfInaccessible(expression));
        }

        public void visitDeclarationStatement(@NotNull PsiDeclarationStatement statement) {
            if (statement == null) {
                MyInaccessibleItemsVisitor.$$$reportNull$$$0(3);
            }
            super.visitDeclarationStatement(statement);
            this.addIfNotNull(LocalVariableDeclarationDescriptor.createIfInaccessible(statement));
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                MyInaccessibleItemsVisitor.$$$reportNull$$$0(4);
            }
            super.visitField(field);
            this.addIfNotNull(FieldDeclarationDescriptor.createIfInaccessible(field));
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                MyInaccessibleItemsVisitor.$$$reportNull$$$0(5);
            }
            super.visitReferenceExpression(expression);
            this.addIfNotNull(FieldDescriptor.createIfInaccessible(ReflectionAccessorToEverything.this.myOuterClass, expression));
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                MyInaccessibleItemsVisitor.$$$reportNull$$$0(6);
            }
            super.visitNewExpression(expression);
            PsiAnonymousClass anonymousClass = expression.getAnonymousClass();
            if (anonymousClass != null || expression.getArrayInitializer() != null) {
                return;
            }
            this.addIfNotNull(ConstructorDescriptor.createIfInaccessible(expression));
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                MyInaccessibleItemsVisitor.$$$reportNull$$$0(7);
            }
            super.visitMethodCallExpression(expression);
            this.addIfNotNull(MethodDescriptor.createIfInaccessible(ReflectionAccessorToEverything.this.myOuterClass, expression));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/extractMethodObject/reflect/ReflectionAccessorToEverything$MyInaccessibleItemsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitParameter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitThisExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitDeclarationStatement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

