/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractSuperclass;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.RefactoringActionContextUtil;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.extractInterface.ExtractClassUtil;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassUtil;
import com.intellij.refactoring.extractSuperclass.ExtractSuperclassDialog;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.memberPullUp.PullUpConflictsUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExtractSuperclassHandler
implements ElementsHandler,
ExtractSuperclassDialog.Callback,
ContextAwareActionHandler {
    private PsiClass mySubclass;
    private Project myProject;

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        if (editor == null) {
            ExtractSuperclassHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ExtractSuperclassHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            ExtractSuperclassHandler.$$$reportNull$$$0(2);
        }
        return RefactoringActionContextUtil.isOutsideModuleAndCodeBlock(editor, file);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            ExtractSuperclassHandler.$$$reportNull$$$0(3);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        List elements = CommonRefactoringUtil.findElementsFromCaretsAndSelections((Editor)editor, (PsiFile)file, null, e -> e instanceof PsiMember);
        if (elements.isEmpty()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.class"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)ExtractSuperclassHandler.getRefactoringName(), (String)"refactoring.extractSuperclass");
            return;
        }
        this.invoke(project, elements.toArray(PsiElement.EMPTY_ARRAY), dataContext);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        ExtractSuperclassDialog dialog;
        Editor editor;
        String message;
        PsiClass aClass;
        if (project == null) {
            ExtractSuperclassHandler.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            ExtractSuperclassHandler.$$$reportNull$$$0(5);
        }
        this.myProject = project;
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement[])elements);
        PsiClass psiClass = this.mySubclass = parent instanceof PsiClass ? (aClass = (PsiClass)parent) : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class, (boolean)false);
        if (this.mySubclass == null) {
            message = RefactoringBundle.message((String)"error.select.class.to.be.refactored");
            CommonRefactoringUtil.showErrorHint((Project)project, null, (String)message, (String)ExtractSuperclassHandler.getRefactoringName(), (String)"refactoring.extractSuperclass");
            return;
        }
        if (this.mySubclass instanceof PsiImplicitClass) {
            message = RefactoringBundle.message((String)"error.superclass.cannot.be.extracted.from.implicit.class");
            CommonRefactoringUtil.showErrorHint((Project)project, null, (String)message, (String)ExtractSuperclassHandler.getRefactoringName(), (String)"refactoring.extractSuperclass");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)this.mySubclass)) {
            return;
        }
        Editor editor2 = editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        if (this.mySubclass.isInterface()) {
            String message2 = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"superclass.cannot.be.extracted.from.an.interface"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message2, (String)ExtractSuperclassHandler.getRefactoringName(), (String)"refactoring.extractSuperclass");
            return;
        }
        if (this.mySubclass.isEnum()) {
            String message3 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"superclass.cannot.be.extracted.from.an.enum", (Object[])new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message3, (String)ExtractSuperclassHandler.getRefactoringName(), (String)"refactoring.extractSuperclass");
            return;
        }
        if (this.mySubclass.isRecord()) {
            String message4 = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"superclass.cannot.be.extracted.from.a.record", (Object[])new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message4, (String)ExtractSuperclassHandler.getRefactoringName(), (String)"refactoring.extractSuperclass");
            return;
        }
        List memberInfos = MemberInfo.extractClassMembers((PsiClass)this.mySubclass, (MemberInfoBase.Filter)new MemberInfoBase.Filter<PsiMember>(this){

            public boolean includeMember(PsiMember element) {
                return true;
            }
        }, (boolean)false);
        HashSet selectedMembers = new HashSet();
        Collections.addAll(selectedMembers, elements);
        for (MemberInfo info : memberInfos) {
            if (!selectedMembers.contains(info.getMember())) continue;
            info.setChecked(true);
        }
        if (this.mySubclass instanceof PsiAnonymousClass) {
            memberInfos = ContainerUtil.filter((Collection)memberInfos, memberInfo -> !(memberInfo.getMember() instanceof PsiClass) || memberInfo.getOverrides() == null);
        }
        if (!(dialog = new ExtractSuperclassDialog(project, this.mySubclass, (List<MemberInfo>)memberInfos, this)).showAndGet() || !dialog.isExtractSuperclass()) {
            return;
        }
        PsiClass superClass = (PsiClass)WriteCommandAction.writeCommandAction((Project)project).withName(ExtractSuperclassHandler.getRefactoringName()).compute(() -> ExtractSuperclassHandler.doRefactoring(project, this.mySubclass, dialog));
        ExtractClassUtil.askAndTurnRefsToSuper(this.mySubclass, superClass);
    }

    @Override
    public boolean checkConflicts(ExtractSuperclassDialog dialog) {
        MemberInfo[] infos = dialog.getSelectedMemberInfos().toArray(new MemberInfo[0]);
        PsiDirectory targetDirectory = dialog.getTargetDirectory();
        PsiPackage targetPackage = targetDirectory != null ? JavaDirectoryService.getInstance().getPackage(targetDirectory) : null;
        MultiMap conflicts = new MultiMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass superClass;
            Object object = superClass = this.mySubclass.getExtendsListTypes().length > 0 || this.mySubclass instanceof PsiAnonymousClass ? this.mySubclass.getSuperClass() : null;
            if (targetPackage != null) {
                conflicts.putAllValues(PullUpConflictsUtil.checkConflicts(infos, this.mySubclass, superClass, targetPackage, targetDirectory, dialog.getContainmentVerifier(), false));
            }
        }), RefactoringBundle.message((String)"detecting.possible.conflicts"), true, this.myProject)) {
            return false;
        }
        ExtractSuperClassUtil.checkSuperAccessible(targetDirectory, (MultiMap<PsiElement, String>)conflicts, this.mySubclass);
        return ExtractSuperClassUtil.showConflicts((DialogWrapper)dialog, (MultiMap<PsiElement, String>)conflicts, this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PsiClass doRefactoring(Project project, PsiClass subclass, ExtractSuperclassDialog dialog) {
        String superclassName = dialog.getExtractedSuperName();
        PsiDirectory targetDirectory = dialog.getTargetDirectory();
        MemberInfo[] selectedMemberInfos = dialog.getSelectedMemberInfos().toArray(new MemberInfo[0]);
        DocCommentPolicy javaDocPolicy = new DocCommentPolicy(dialog.getDocCommentPolicy());
        LocalHistoryAction a = LocalHistory.getInstance().startAction(ExtractSuperclassHandler.getCommandName(subclass, superclassName));
        try {
            PsiClass psiClass = ExtractSuperClassUtil.extractSuperClass(project, targetDirectory, superclassName, subclass, selectedMemberInfos, javaDocPolicy);
            return psiClass;
        }
        finally {
            a.finish();
        }
    }

    @NlsContexts.Label
    private static String getCommandName(PsiClass subclass, String newName) {
        return RefactoringBundle.message((String)"extract.superclass.command.name", (Object[])new Object[]{newName, DescriptiveNameUtil.getDescriptiveName((PsiElement)subclass)});
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return ContainerUtil.exists((Object[])elements, element -> element instanceof PsiMember);
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"extract.superclass.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractSuperclass/ExtractSuperclassHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableForQuickList";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

