/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass;

import com.intellij.idea.ActionsBundle;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.actions.RefactoringActionContextUtil;
import com.intellij.refactoring.extractclass.ExtractClassDialog;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ExtractClassHandler
implements ElementsHandler,
ContextAwareActionHandler {
    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        if (editor == null) {
            ExtractClassHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ExtractClassHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            ExtractClassHandler.$$$reportNull$$$0(2);
        }
        return RefactoringActionContextUtil.isOutsideModuleAndCodeBlock(editor, file);
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return ContainerUtil.exists((Object[])elements, element -> element instanceof PsiMember);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        PsiClass parentClass;
        if (project == null) {
            ExtractClassHandler.$$$reportNull$$$0(3);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        List elements = CommonRefactoringUtil.findElementsFromCaretsAndSelections((Editor)editor, (PsiFile)file, null, e -> e instanceof PsiMember);
        PsiElement parent = PsiTreeUtil.findCommonParent((List)elements);
        PsiClass containingClass = parent instanceof PsiClass ? (parentClass = (PsiClass)parent) : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class, (boolean)false);
        String cannotRefactorMessage = ExtractClassHandler.getCannotRefactorMessage(containingClass);
        if (cannotRefactorMessage != null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)(RefactorJBundle.message((String)"cannot.perform.the.refactoring", (Object[])new Object[0]) + cannotRefactorMessage), (String)ExtractClassHandler.getRefactoringName(), (String)"refactorj.extractClass");
            return;
        }
        new ExtractClassDialog(containingClass, new HashSet<PsiElement>(elements)).show();
    }

    @Nls
    private static String getCannotRefactorMessage(PsiClass containingClass) {
        if (containingClass == null) {
            return RefactorJBundle.message((String)"the.caret.should.be.positioned.within.a.class.to.be.refactored", (Object[])new Object[0]);
        }
        if (containingClass.isInterface()) {
            return RefactorJBundle.message((String)"the.selected.class.is.an.interface", (Object[])new Object[0]);
        }
        if (containingClass.isEnum()) {
            return RefactorJBundle.message((String)"the.selected.class.is.an.enumeration", (Object[])new Object[0]);
        }
        if (containingClass.isAnnotationType()) {
            return RefactorJBundle.message((String)"the.selected.class.is.an.annotation.type", (Object[])new Object[0]);
        }
        if (ExtractClassHandler.classIsInner(containingClass) && !containingClass.hasModifierProperty("static")) {
            return RefactorJBundle.message((String)"the.refactoring.is.not.supported.on.non.static.inner.classes", (Object[])new Object[0]);
        }
        if (ExtractClassHandler.classIsTrivial(containingClass)) {
            return RefactorJBundle.message((String)"the.selected.class.has.no.members.to.extract", (Object[])new Object[0]);
        }
        if (!containingClass.getManager().isInProject((PsiElement)containingClass)) {
            return RefactorJBundle.message((String)"the.selected.class.should.belong.to.project.sources", (Object[])new Object[0]);
        }
        if (containingClass instanceof PsiImplicitClass) {
            return RefactorJBundle.message((String)"refactoring.cannot.be.done.in.implicit.class", (Object[])new Object[0]);
        }
        return null;
    }

    private static boolean classIsInner(PsiClass aClass) {
        return PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true) != null;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        PsiClass aClass;
        PsiElement parent;
        PsiClass containingClass;
        String cannotRefactorMessage;
        if (project == null) {
            ExtractClassHandler.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            ExtractClassHandler.$$$reportNull$$$0(5);
        }
        if ((cannotRefactorMessage = ExtractClassHandler.getCannotRefactorMessage(containingClass = (parent = PsiTreeUtil.findCommonParent((PsiElement[])elements)) instanceof PsiClass ? (aClass = (PsiClass)parent) : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class, (boolean)false))) != null) {
            CommonRefactoringUtil.showErrorHint((Project)project, null, (String)(RefactorJBundle.message((String)"cannot.perform.the.refactoring", (Object[])new Object[0]) + cannotRefactorMessage), (String)ExtractClassHandler.getRefactoringName(), (String)"refactorj.extractClass");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)containingClass)) {
            return;
        }
        HashSet<PsiElement> selectedMembers = new HashSet<PsiElement>();
        Collections.addAll(selectedMembers, elements);
        new ExtractClassDialog(containingClass, selectedMembers).show();
    }

    private static boolean classIsTrivial(PsiClass containingClass) {
        if (containingClass.getFields().length == 0) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = containingClass.getMethods()) {
                if (method.getBody() == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return ActionsBundle.message((String)"action.ExtractClass.description", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/extractclass/ExtractClassHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableForQuickList";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

