/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractclass;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.extractclass.BackpointerUtil;
import com.intellij.refactoring.psi.MethodInheritanceUtils;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class ExtractedClassBuilder {
    private static final Logger LOGGER = Logger.getInstance(ExtractedClassBuilder.class);
    private String className;
    private String packageName;
    private final List<PsiField> fields = new ArrayList<PsiField>(5);
    private final List<PsiMethod> methods = new ArrayList<PsiMethod>(5);
    private final List<PsiClassInitializer> initializers = new ArrayList<PsiClassInitializer>(5);
    private final List<PsiClass> innerClasses = new ArrayList<PsiClass>(5);
    private final List<PsiClass> innerClassesToMakePublic = new ArrayList<PsiClass>(5);
    private final List<PsiTypeParameter> typeParams = new ArrayList<PsiTypeParameter>();
    private final List<PsiClass> interfaces = new ArrayList<PsiClass>();
    private boolean requiresBackPointer;
    private String originalClassName;
    private String backPointerName;
    private Project myProject;
    private JavaCodeStyleManager myJavaCodeStyleManager;
    private Set<PsiField> myFieldsNeedingSetters;
    private Set<PsiField> myFieldsNeedingGetter;
    private List<? extends PsiField> enumConstantFields;
    private PsiType myEnumParameterType;

    ExtractedClassBuilder() {
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setOriginalClassName(String originalClassName) {
        this.originalClassName = originalClassName;
    }

    public void addField(PsiField field) {
        this.fields.add(field);
    }

    public void addMethod(PsiMethod method) {
        this.methods.add(method);
    }

    public void addInitializer(PsiClassInitializer initializer) {
        this.initializers.add(initializer);
    }

    public void addInnerClass(PsiClass innerClass, boolean makePublic) {
        this.innerClasses.add(innerClass);
        if (makePublic) {
            this.innerClassesToMakePublic.add(innerClass);
        }
    }

    public void setTypeArguments(List<? extends PsiTypeParameter> typeParams) {
        this.typeParams.clear();
        this.typeParams.addAll(typeParams);
    }

    public void setInterfaces(List<? extends PsiClass> interfaces) {
        this.interfaces.clear();
        this.interfaces.addAll(interfaces);
    }

    public String buildBeanClass(boolean normalizeDeclaration) {
        boolean first;
        if (this.requiresBackPointer) {
            this.calculateBackpointerName();
        }
        @NonNls StringBuilder out = new StringBuilder(1024);
        if (!this.packageName.isEmpty()) {
            out.append("package ").append(this.packageName).append(";\n");
        }
        out.append("public ");
        this.fields.removeAll(this.enumConstantFields);
        out.append(this.hasEnumConstants() ? "enum " : "class ");
        out.append(this.className);
        if (!this.typeParams.isEmpty()) {
            out.append('<');
            first = true;
            for (PsiTypeParameter typeParam : this.typeParams) {
                if (!first) {
                    out.append(',');
                }
                out.append(typeParam.getText());
                first = false;
            }
            out.append('>');
        }
        if (!this.interfaces.isEmpty()) {
            out.append(" implements ");
            first = true;
            for (PsiClass implemented : this.interfaces) {
                if (!first) {
                    out.append(',');
                }
                out.append(implemented.getQualifiedName());
                first = false;
            }
        }
        out.append("{\n");
        if (this.requiresBackPointer) {
            out.append("private final ").append(this.originalClassName);
            if (!this.typeParams.isEmpty()) {
                out.append('<');
                first = true;
                for (PsiTypeParameter typeParam : this.typeParams) {
                    if (!first) {
                        out.append(',');
                    }
                    out.append(typeParam.getName());
                    first = false;
                }
                out.append('>');
            }
            out.append(' ').append(this.backPointerName).append(";");
        }
        this.outputFieldsAndInitializers(out, normalizeDeclaration);
        if (this.hasEnumConstants()) {
            String fieldName = this.getValueFieldName();
            out.append("private final ").append(this.myEnumParameterType.getCanonicalText()).append(" ").append(fieldName).append(";\n");
            this.outputConstructor(out);
            out.append("public ").append(this.myEnumParameterType.getCanonicalText()).append(" ").append(this.getterName()).append("(){\nreturn ").append(fieldName).append(";\n}\n");
        } else if (this.needConstructor() || this.requiresBackPointer) {
            this.outputConstructor(out);
        }
        this.outputMethods(out);
        this.outputInnerClasses(out);
        out.append("}");
        return out.toString();
    }

    private String getterName() {
        return GenerateMembersUtil.suggestGetterName((String)"value", (PsiType)this.myEnumParameterType, (Project)this.myProject);
    }

    private boolean hasEnumConstants() {
        return !this.enumConstantFields.isEmpty();
    }

    private String getValueFieldName() {
        String myValue = this.myJavaCodeStyleManager.variableNameToPropertyName("value", VariableKind.FIELD);
        return this.myJavaCodeStyleManager.suggestUniqueVariableName(myValue, (PsiElement)this.enumConstantFields.get(0), true);
    }

    private void calculateBackpointerName() {
        String baseName;
        if (this.originalClassName.indexOf(46) == 0) {
            baseName = StringUtil.decapitalize((String)this.originalClassName);
        } else {
            String simpleClassName = this.originalClassName.substring(this.originalClassName.lastIndexOf(46) + 1);
            baseName = StringUtil.decapitalize((String)simpleClassName);
        }
        Object name = this.myJavaCodeStyleManager.propertyNameToVariableName(baseName, VariableKind.FIELD);
        if (!this.existsFieldWithName((String)name)) {
            this.backPointerName = name;
            return;
        }
        int counter = 1;
        while (true) {
            if (!this.existsFieldWithName((String)(name = (String)name + counter))) {
                this.backPointerName = name;
                return;
            }
            ++counter;
        }
    }

    private boolean existsFieldWithName(String name) {
        for (PsiField field : this.fields) {
            String fieldName = field.getName();
            if (!name.equals(fieldName)) continue;
            return true;
        }
        return false;
    }

    private boolean needConstructor() {
        for (PsiField field : this.fields) {
            if (field.hasModifierProperty("static")) continue;
            return true;
        }
        for (PsiMethod method : this.methods) {
            if (method.hasModifierProperty("static")) continue;
            return true;
        }
        return false;
    }

    private void outputMethods(@NonNls StringBuilder out) {
        for (PsiMethod method : this.methods) {
            method.accept((PsiElementVisitor)new Mutator(out));
        }
    }

    private void outputInnerClasses(@NonNls StringBuilder out) {
        for (PsiClass innerClass : this.innerClasses) {
            this.outputMutatedInnerClass(out, innerClass, this.innerClassesToMakePublic.contains(innerClass));
        }
    }

    private void outputMutatedInnerClass(@NonNls StringBuilder out, PsiClass innerClass, boolean makePublic) {
        if (makePublic) {
            try {
                PsiUtil.setModifierProperty((PsiModifierListOwner)innerClass, (String)"public", (boolean)false);
            }
            catch (IncorrectOperationException e) {
                LOGGER.error((Throwable)e);
            }
        }
        innerClass.accept((PsiElementVisitor)new Mutator(out));
    }

    private void outputFieldsAndInitializers(@NonNls StringBuilder out, boolean normalizeDeclaration) {
        if (this.hasEnumConstants()) {
            out.append(StringUtil.join(this.enumConstantFields, field -> {
                @NonNls StringBuilder fieldStr = new StringBuilder(field.getName());
                fieldStr.append('(');
                PsiExpression initializer = field.getInitializer();
                if (initializer != null) {
                    initializer.accept((PsiElementVisitor)new Mutator(fieldStr));
                }
                fieldStr.append(')');
                return fieldStr.toString();
            }, (String)", "));
            out.append(";\n");
        }
        ArrayList<PsiClassInitializer> remainingInitializers = new ArrayList<PsiClassInitializer>(this.initializers);
        for (PsiField field2 : this.fields) {
            if (normalizeDeclaration) {
                field2.normalizeDeclaration();
            }
            Iterator initializersIterator = remainingInitializers.iterator();
            int fieldOffset = field2.getTextRange().getStartOffset();
            while (initializersIterator.hasNext()) {
                PsiClassInitializer initializer = (PsiClassInitializer)initializersIterator.next();
                if (initializer.getTextRange().getStartOffset() >= fieldOffset) continue;
                initializer.accept((PsiElementVisitor)new Mutator(out));
                initializersIterator.remove();
            }
            field2.accept((PsiElementVisitor)new Mutator(out));
            out.append('\n');
            if (this.myFieldsNeedingGetter != null && this.myFieldsNeedingGetter.contains(field2)) {
                out.append(GenerateMembersUtil.generateGetterPrototype((PsiField)field2).getText());
                out.append("\n");
            }
            if (this.myFieldsNeedingSetters == null || !this.myFieldsNeedingSetters.contains(field2)) continue;
            out.append(GenerateMembersUtil.generateSetterPrototype((PsiField)field2).getText());
            out.append("\n");
        }
        for (PsiClassInitializer initializer : remainingInitializers) {
            initializer.accept((PsiElementVisitor)new Mutator(out));
        }
    }

    private void outputConstructor(@NonNls StringBuilder out) {
        String parameterName;
        out.append(this.hasEnumConstants() ? "" : "public ").append(this.className).append('(');
        if (this.requiresBackPointer) {
            parameterName = this.myJavaCodeStyleManager.propertyNameToVariableName(this.backPointerName, VariableKind.PARAMETER);
            out.append(this.originalClassName);
            if (!this.typeParams.isEmpty()) {
                out.append('<');
                boolean first = true;
                for (PsiTypeParameter typeParam : this.typeParams) {
                    if (!first) {
                        out.append(',');
                    }
                    out.append(typeParam.getName());
                    first = false;
                }
                out.append('>');
            }
            out.append(' ').append(parameterName);
        } else if (this.hasEnumConstants()) {
            out.append(this.myEnumParameterType.getCanonicalText()).append(" ").append("value");
        }
        out.append(") {\n");
        if (this.requiresBackPointer) {
            parameterName = this.myJavaCodeStyleManager.propertyNameToVariableName(this.backPointerName, VariableKind.PARAMETER);
            if (this.backPointerName.equals(parameterName)) {
                out.append("this.");
            }
            out.append(this.backPointerName).append('=').append(parameterName).append(";\n");
        } else if (this.hasEnumConstants()) {
            String fieldName = this.getValueFieldName();
            if (fieldName.equals("value")) {
                out.append("this.");
            }
            out.append(fieldName).append("=value;\n");
        }
        out.append("}\n");
    }

    public void setRequiresBackPointer(boolean requiresBackPointer) {
        this.requiresBackPointer = requiresBackPointer;
    }

    public void setProject(Project project) {
        this.myProject = project;
        this.myJavaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
    }

    public void setFieldsNeedingGetters(Set<PsiField> fieldsNeedingGetter) {
        this.myFieldsNeedingGetter = fieldsNeedingGetter;
    }

    public void setFieldsNeedingSetters(Set<PsiField> fieldsNeedingSetters) {
        this.myFieldsNeedingSetters = fieldsNeedingSetters;
    }

    private boolean fieldIsExtracted(PsiField field) {
        ArrayList<PsiField> extractedFields = new ArrayList<PsiField>(this.fields);
        extractedFields.addAll(this.enumConstantFields);
        if (extractedFields.contains(field)) {
            return true;
        }
        PsiClass containingClass = field.getContainingClass();
        return this.innerClasses.contains(containingClass);
    }

    public void setExtractAsEnum(List<? extends PsiField> extractAsEnum) {
        this.enumConstantFields = extractAsEnum;
        if (this.hasEnumConstants()) {
            this.myEnumParameterType = this.enumConstantFields.get(0).getType();
        }
    }

    private final class Mutator
    extends JavaElementVisitor {
        @NonNls
        private final StringBuilder out;

        private Mutator(StringBuilder out) {
            this.out = out;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                Mutator.$$$reportNull$$$0(0);
            }
            super.visitElement(element);
            PsiElement[] children = element.getChildren();
            if (children.length == 0) {
                String text = element.getText();
                this.out.append(text);
            } else {
                for (PsiElement child : children) {
                    child.accept((PsiElementVisitor)this);
                }
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                Mutator.$$$reportNull$$$0(1);
            }
            JavaResolveResult resolveResult = expression.advancedResolve(true);
            boolean staticImported = resolveResult.getCurrentFileResolveScope() instanceof PsiImportStaticStatement;
            PsiElement qualifier = expression.getQualifier();
            if (qualifier == null || qualifier instanceof PsiThisExpression) {
                PsiElement referent = resolveResult.getElement();
                if (referent instanceof PsiField) {
                    PsiField field = (PsiField)referent;
                    if (ExtractedClassBuilder.this.fieldIsExtracted(field)) {
                        String name = field.getName();
                        if (ExtractedClassBuilder.this.enumConstantFields.contains(field)) {
                            this.out.append(name).append(".").append(ExtractedClassBuilder.this.getterName()).append("()");
                        } else {
                            if (qualifier != null && name.equals(expression.getReferenceName())) {
                                this.out.append("this.");
                            }
                            this.out.append(name);
                        }
                    } else if (field.hasModifierProperty("static")) {
                        if (field instanceof PsiEnumConstant) {
                            this.out.append(field.getName());
                        } else if (staticImported) {
                            PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)resolveResult.getCurrentFileResolveScope();
                            PsiClass targetClass = importStaticStatement.resolveTargetClass();
                            this.out.append(targetClass != null ? targetClass.getQualifiedName() : "").append(".").append(field.getName());
                        } else {
                            this.out.append(ExtractedClassBuilder.this.originalClassName).append('.').append(field.getName());
                        }
                    } else {
                        this.out.append(ExtractedClassBuilder.this.backPointerName).append('.').append(GenerateMembersUtil.suggestGetterName((PsiField)field)).append("()");
                    }
                } else if (referent instanceof PsiClass) {
                    String qualifiedName = ((PsiClass)referent).getQualifiedName();
                    if (qualifiedName != null) {
                        this.out.append(qualifiedName);
                    }
                } else {
                    this.visitElement((PsiElement)expression);
                }
            } else {
                this.visitElement((PsiElement)expression);
            }
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
            if (expression == null) {
                Mutator.$$$reportNull$$$0(2);
            }
            PsiExpression lhs = expression.getLExpression();
            PsiExpression rhs = expression.getRExpression();
            if (this.isBackpointerReference(lhs) && rhs != null) {
                while (lhs instanceof PsiParenthesizedExpression) {
                    lhs = ((PsiParenthesizedExpression)lhs).getExpression();
                }
                PsiReferenceExpression reference = (PsiReferenceExpression)lhs;
                assert (reference != null);
                PsiField field = (PsiField)reference.resolve();
                PsiJavaToken sign = expression.getOperationSign();
                IElementType tokenType = sign.getTokenType();
                assert (field != null);
                if (!field.hasModifierProperty("static")) {
                    this.delegate(rhs, field, sign, tokenType, ExtractedClassBuilder.this.backPointerName);
                } else {
                    this.visitElement((PsiElement)expression);
                }
            } else {
                this.visitElement((PsiElement)expression);
            }
        }

        private void delegate(PsiExpression rhs, PsiField field, PsiJavaToken sign, IElementType tokenType, String fieldName) {
            String setterName = GenerateMembersUtil.suggestSetterName((PsiField)field);
            this.out.append(fieldName).append('.').append(setterName).append('(');
            if (!tokenType.equals(JavaTokenType.EQ)) {
                String operator = sign.getText().substring(0, sign.getTextLength() - 1);
                String getterName = GenerateMembersUtil.suggestGetterName((PsiField)field);
                this.out.append(fieldName).append('.').append(getterName).append("()");
                this.out.append(operator);
            }
            rhs.accept((PsiElementVisitor)this);
            this.out.append(')');
        }

        public void visitUnaryExpression(@NotNull PsiUnaryExpression expression) {
            if (expression == null) {
                Mutator.$$$reportNull$$$0(3);
            }
            PsiExpression operand = expression.getOperand();
            IElementType tokenType = expression.getOperationSign().getTokenType();
            if (this.isBackpointerReference(operand) && (tokenType.equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS))) {
                while (operand instanceof PsiParenthesizedExpression) {
                    operand = ((PsiParenthesizedExpression)operand).getExpression();
                }
                PsiReferenceExpression reference = (PsiReferenceExpression)operand;
                String operator = tokenType.equals(JavaTokenType.PLUSPLUS) ? "+" : "-";
                PsiField field = (PsiField)reference.resolve();
                assert (field != null);
                if (!field.hasModifierProperty("static")) {
                    this.out.append(ExtractedClassBuilder.this.backPointerName).append('.').append(GenerateMembersUtil.suggestSetterName((PsiField)field)).append('(').append(ExtractedClassBuilder.this.backPointerName).append('.').append(GenerateMembersUtil.suggestGetterName((PsiField)field)).append("()").append(operator).append("1)");
                } else {
                    this.visitElement((PsiElement)expression);
                }
            } else {
                this.visitElement((PsiElement)expression);
            }
        }

        private boolean isBackpointerReference(PsiExpression expression) {
            return BackpointerUtil.isBackpointerReference(expression, psiField -> !ExtractedClassBuilder.this.fieldIsExtracted((PsiField)psiField));
        }

        public void visitThisExpression(@NotNull PsiThisExpression expression) {
            if (expression == null) {
                Mutator.$$$reportNull$$$0(4);
            }
            this.out.append(ExtractedClassBuilder.this.backPointerName);
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                Mutator.$$$reportNull$$$0(5);
            }
            PsiReferenceExpression expression = call.getMethodExpression();
            JavaResolveResult resolveResult = expression.advancedResolve(false);
            PsiElement qualifier = expression.getQualifier();
            if (qualifier == null || qualifier instanceof PsiThisExpression) {
                PsiMethod method = call.resolveMethod();
                if (method != null && !this.isCompletelyMoved(method)) {
                    String methodName = method.getName();
                    if (method.hasModifierProperty("static")) {
                        PsiElement resolveScope = resolveResult.getCurrentFileResolveScope();
                        if (resolveScope instanceof PsiImportStaticStatement) {
                            PsiClass targetClass = ((PsiImportStaticStatement)resolveScope).resolveTargetClass();
                            this.out.append(targetClass != null ? targetClass.getQualifiedName() : "").append('.').append(methodName);
                        } else {
                            this.out.append(ExtractedClassBuilder.this.originalClassName).append('.').append(methodName);
                        }
                    } else {
                        this.out.append(ExtractedClassBuilder.this.backPointerName).append('.').append(methodName);
                    }
                    PsiExpressionList argumentList = call.getArgumentList();
                    argumentList.accept((PsiElementVisitor)this);
                } else {
                    this.visitElement((PsiElement)call);
                }
            } else {
                this.visitElement((PsiElement)call);
            }
        }

        public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
            if (reference == null) {
                Mutator.$$$reportNull$$$0(6);
            }
            String referenceText = reference.getCanonicalText();
            this.out.append(referenceText);
        }

        private boolean isCompletelyMoved(PsiMethod method) {
            return ExtractedClassBuilder.this.methods.contains(method) && !MethodInheritanceUtils.hasSiblingMethods(method);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/extractclass/ExtractedClassBuilder$Mutator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitAssignmentExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitUnaryExpression";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitThisExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

