/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inheritanceToDelegation;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.PreviewableRefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.RefactoringActionContextUtil;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.inheritanceToDelegation.InheritanceToDelegationDialog;
import com.intellij.refactoring.inheritanceToDelegation.InheritanceToDelegationProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.MemberInfoStorage;
import com.intellij.usageView.UsageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InheritanceToDelegationHandler
implements PreviewableRefactoringActionHandler,
ContextAwareActionHandler {
    private static final Logger LOG = Logger.getInstance(InheritanceToDelegationHandler.class);
    private static final MemberInfoBase.Filter<PsiMember> MEMBER_INFO_FILTER = new MemberInfoBase.Filter<PsiMember>(){

        public boolean includeMember(PsiMember element) {
            PsiClass aClass;
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                return !method.hasModifierProperty("static") && !method.hasModifierProperty("private");
            }
            return element instanceof PsiClass && (aClass = (PsiClass)element).isInterface();
        }
    };

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        PsiElement element;
        PsiClass psiClass;
        if (editor == null) {
            InheritanceToDelegationHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            InheritanceToDelegationHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            InheritanceToDelegationHandler.$$$reportNull$$$0(2);
        }
        return (psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)(element = PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset(), PsiElement.class, (boolean)false)), PsiClass.class, (boolean)false)) != null && RefactoringActionContextUtil.isClassWithExtendsOrImplements(psiClass) && RefactoringActionContextUtil.isJavaClassHeader(element);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            InheritanceToDelegationHandler.$$$reportNull$$$0(3);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        while (true) {
            if (element == null || element instanceof PsiFile) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.class"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)InheritanceToDelegationHandler.getRefactoringName(), (String)"refactoring.replaceInheritWithDelegat");
                return;
            }
            if (element instanceof PsiClass && !(element instanceof PsiAnonymousClass)) {
                this.invoke(project, new PsiElement[]{element}, dataContext);
                return;
            }
            element = element.getParent();
        }
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            InheritanceToDelegationHandler.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            InheritanceToDelegationHandler.$$$reportNull$$$0(5);
        }
        if (elements.length != 1) {
            return;
        }
        PsiClass aClass = (PsiClass)elements[0];
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (aClass.isInterface()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"class.is.interface", (Object[])new Object[]{aClass.getQualifiedName()}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)InheritanceToDelegationHandler.getRefactoringName(), (String)"refactoring.replaceInheritWithDelegat");
            return;
        }
        if (aClass instanceof JspClass) {
            RefactoringMessageUtil.showNotSupportedForJspClassesError((Project)project, (Editor)editor, (String)InheritanceToDelegationHandler.getRefactoringName(), (String)"refactoring.replaceInheritWithDelegat");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)aClass)) {
            return;
        }
        PsiClass[] bases = aClass.getSupers();
        @NonNls String javaLangObject = "java.lang.Object";
        if (bases.length == 0 || bases.length == 1 && "java.lang.Object".equals(bases[0].getQualifiedName())) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"class.does.not.have.base.classes.or.interfaces", (Object[])new Object[]{aClass.getQualifiedName()}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)InheritanceToDelegationHandler.getRefactoringName(), (String)"refactoring.replaceInheritWithDelegat");
            return;
        }
        LinkedHashMap<PsiClass, Collection<MemberInfo>> basesToMemberInfos = new LinkedHashMap<PsiClass, Collection<MemberInfo>>();
        for (PsiClass base : bases) {
            if ("java.lang.Object".equals(base.getQualifiedName())) continue;
            basesToMemberInfos.put(base, InheritanceToDelegationHandler.createBaseClassMemberInfos(base));
        }
        Set baseClasses = ((HashMap)basesToMemberInfos).keySet();
        new InheritanceToDelegationDialog(project, aClass, baseClasses.toArray(PsiClass.EMPTY_ARRAY), basesToMemberInfos).show();
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull PsiElement element) {
        if (project == null) {
            InheritanceToDelegationHandler.$$$reportNull$$$0(6);
        }
        if (element == null) {
            InheritanceToDelegationHandler.$$$reportNull$$$0(7);
        }
        if (!(element instanceof PsiClass)) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                InheritanceToDelegationHandler.$$$reportNull$$$0(8);
            }
            return intentionPreviewInfo;
        }
        PsiClass aClass = (PsiClass)element;
        PsiClass superClass = aClass.getSuperClass();
        if (superClass == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                InheritanceToDelegationHandler.$$$reportNull$$$0(9);
            }
            return intentionPreviewInfo;
        }
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        InheritanceToDelegationProcessor processor = new InheritanceToDelegationProcessor(project, aClass, superClass, InheritanceToDelegationHandler.suggestFieldNames(aClass, superClass)[0], InheritanceToDelegationHandler.suggestTargetClassName(aClass), PsiClass.EMPTY_ARRAY, PsiMethod.EMPTY_ARRAY, settings.INHERITANCE_TO_DELEGATION_DELEGATE_OTHER, settings.INHERITANCE_TO_DELEGATION_DELEGATE_OTHER);
        processor.performRefactoring(UsageInfo.EMPTY_ARRAY);
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        if (intentionPreviewInfo == null) {
            InheritanceToDelegationHandler.$$$reportNull$$$0(10);
        }
        return intentionPreviewInfo;
    }

    private static List<MemberInfo> createBaseClassMemberInfos(PsiClass baseClass) {
        PsiClass deepestBase = RefactoringHierarchyUtil.getDeepestNonObjectBase(baseClass);
        LOG.assertTrue(deepestBase != null);
        MemberInfoStorage memberInfoStorage = new MemberInfoStorage(baseClass, MEMBER_INFO_FILTER);
        ArrayList<MemberInfo> memberInfoList = new ArrayList<MemberInfo>();
        memberInfoList.addAll(memberInfoStorage.getClassMemberInfos((PsiElement)deepestBase));
        memberInfoList.addAll(memberInfoStorage.getIntermediateMemberInfosList((PsiElement)deepestBase));
        return memberInfoList;
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return JavaRefactoringBundle.message((String)"replace.inheritance.with.delegation.title", (Object[])new Object[0]);
    }

    @NotNull
    public static String suggestTargetClassName(PsiClass targetClass) {
        String string = "My" + targetClass.getName();
        if (string == null) {
            InheritanceToDelegationHandler.$$$reportNull$$$0(11);
        }
        return string;
    }

    public static String @NotNull [] suggestFieldNames(@NotNull PsiClass aClass, @NotNull PsiClass targetClass) {
        if (aClass == null) {
            InheritanceToDelegationHandler.$$$reportNull$$$0(12);
        }
        if (targetClass == null) {
            InheritanceToDelegationHandler.$$$reportNull$$$0(13);
        }
        PsiManager psiManager = aClass.getManager();
        PsiClassType superType = JavaPsiFacade.getElementFactory((Project)psiManager.getProject()).createType(targetClass);
        if (JavaCodeStyleManager.getInstance((Project)psiManager.getProject()).suggestVariableName((VariableKind)VariableKind.FIELD, null, null, (PsiType)superType).names == null) {
            InheritanceToDelegationHandler.$$$reportNull$$$0(14);
        }
        return JavaCodeStyleManager.getInstance((Project)psiManager.getProject()).suggestVariableName((VariableKind)VariableKind.FIELD, null, null, (PsiType)superType).names;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/inheritanceToDelegation/InheritanceToDelegationHandler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/inheritanceToDelegation/InheritanceToDelegationHandler";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestTargetClassName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestFieldNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForQuickList";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "suggestFieldNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 14 -> new IllegalStateException(string);
        };
    }
}

