/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inheritanceToDelegation;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ConflictsDialogBase;
import com.intellij.refactoring.inheritanceToDelegation.InheritanceToDelegationUtil;
import com.intellij.refactoring.inheritanceToDelegation.InheritanceToDelegationViewDescriptor;
import com.intellij.refactoring.inheritanceToDelegation.InnerClassConstructor;
import com.intellij.refactoring.inheritanceToDelegation.InnerClassMethod;
import com.intellij.refactoring.inheritanceToDelegation.usageInfo.FieldAccessibility;
import com.intellij.refactoring.inheritanceToDelegation.usageInfo.InheritanceToDelegationUsageInfo;
import com.intellij.refactoring.inheritanceToDelegation.usageInfo.NoLongerOverridingSubClassMethodUsageInfo;
import com.intellij.refactoring.inheritanceToDelegation.usageInfo.NonDelegatedMemberUsageInfo;
import com.intellij.refactoring.inheritanceToDelegation.usageInfo.ObjectUpcastedUsageInfo;
import com.intellij.refactoring.inheritanceToDelegation.usageInfo.UnqualifiedNonDelegatedMemberUsageInfo;
import com.intellij.refactoring.inheritanceToDelegation.usageInfo.UpcastedUsageInfo;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.classMembers.ClassMemberReferencesVisitor;
import com.intellij.refactoring.util.classRefs.ClassInstanceScanner;
import com.intellij.refactoring.util.classRefs.ClassReferenceSearchingScanner;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.SealedUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InheritanceToDelegationProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(InheritanceToDelegationProcessor.class);
    private final PsiClass myClass;
    private final String myInnerClassName;
    private final boolean myIsDelegateOtherMembers;
    private final Set<PsiClass> myDelegatedInterfaces;
    private final Set<PsiMethod> myDelegatedMethods;
    private final HashMap<PsiMethod, String> myDelegatedMethodsVisibility;
    private final Set<PsiMethod> myOverriddenMethods;
    private final PsiClass myBaseClass;
    private final Set<PsiMember> myBaseClassMembers;
    private final String myFieldName;
    private final String myGetterName;
    private final boolean myGenerateGetter;
    private final Set<PsiClass> myBaseClassBases;
    private Set<PsiClass> myClassImplementedInterfaces;
    private final PsiElementFactory myFactory;
    private final PsiClassType myBaseClassType;
    private final PsiManager myManager;
    private final boolean myIsInnerClassNeeded;
    private Set<PsiClass> myClassInheritors;
    private HashSet<PsiMethod> myAbstractDelegatedMethods;
    private final Map<PsiClass, PsiSubstitutor> mySuperClassesToSubstitutors;

    public InheritanceToDelegationProcessor(Project project, PsiClass aClass, @NotNull PsiClass targetBaseClass, String fieldName, String innerClassName, PsiClass[] delegatedInterfaces, PsiMethod[] delegatedMethods, boolean delegateOtherMembers, boolean generateGetter) {
        if (targetBaseClass == null) {
            InheritanceToDelegationProcessor.$$$reportNull$$$0(0);
        }
        super(project);
        this.mySuperClassesToSubstitutors = new HashMap<PsiClass, PsiSubstitutor>();
        this.myClass = aClass;
        this.myInnerClassName = innerClassName;
        this.myIsDelegateOtherMembers = delegateOtherMembers;
        this.myManager = this.myClass.getManager();
        this.myFactory = JavaPsiFacade.getElementFactory((Project)this.myManager.getProject());
        this.myBaseClass = targetBaseClass;
        LOG.assertTrue(this.myBaseClass.getQualifiedName() == null || !this.myBaseClass.getQualifiedName().equals("java.lang.Object"), (Object)this.myBaseClass);
        this.myBaseClassMembers = this.getAllBaseClassMembers();
        this.myBaseClassBases = this.getAllBases();
        this.myBaseClassType = this.myFactory.createType(this.myBaseClass, this.getSuperSubstitutor(this.myBaseClass));
        this.myIsInnerClassNeeded = InheritanceToDelegationUtil.isInnerClassNeeded(this.myClass, this.myBaseClass);
        this.myFieldName = fieldName;
        String propertyName = JavaCodeStyleManager.getInstance((Project)this.myProject).variableNameToPropertyName(this.myFieldName, VariableKind.FIELD);
        this.myGetterName = GenerateMembersUtil.suggestGetterName((String)propertyName, (PsiType)this.myBaseClassType, (Project)this.myProject);
        this.myGenerateGetter = generateGetter;
        this.myDelegatedInterfaces = new LinkedHashSet<PsiClass>();
        Collections.addAll(this.myDelegatedInterfaces, delegatedInterfaces);
        this.myDelegatedMethods = new LinkedHashSet<PsiMethod>();
        Collections.addAll(this.myDelegatedMethods, delegatedMethods);
        this.myDelegatedMethodsVisibility = new HashMap();
        for (PsiMethod method : this.myDelegatedMethods) {
            MethodSignature signature = method.getSignature(this.getSuperSubstitutor(method.getContainingClass()));
            PsiMethod overridingMethod = MethodSignatureUtil.findMethodBySignature((PsiClass)this.myClass, (MethodSignature)signature, (boolean)false);
            if (overridingMethod == null) continue;
            this.myDelegatedMethodsVisibility.put(method, VisibilityUtil.getVisibilityModifier((PsiModifierList)overridingMethod.getModifierList()));
        }
        this.myOverriddenMethods = this.getOverriddenMethods();
    }

    private PsiSubstitutor getSuperSubstitutor(PsiClass superClass) {
        PsiSubstitutor result = this.mySuperClassesToSubstitutors.get(superClass);
        if (result == null) {
            result = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)this.myClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            this.mySuperClassesToSubstitutors.put(superClass, result);
        }
        return result;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InheritanceToDelegationProcessor.$$$reportNull$$$0(1);
        }
        return new InheritanceToDelegationViewDescriptor(this.myClass);
    }

    protected UsageInfo @NotNull [] findUsages() {
        ArrayList usages = new ArrayList();
        PsiClass[] inheritors = (PsiClass[])ClassInheritorsSearch.search((PsiClass)this.myClass).toArray((Object[])PsiClass.EMPTY_ARRAY);
        this.myClassInheritors = new HashSet<PsiClass>();
        this.myClassInheritors.add(this.myClass);
        Collections.addAll(this.myClassInheritors, inheritors);
        ClassReferenceSearchingScanner scanner = new ClassReferenceSearchingScanner(this.myClass);
        MyClassInstanceReferenceVisitor instanceReferenceVisitor = new MyClassInstanceReferenceVisitor(this.myClass, usages);
        scanner.processReferences(new ClassInstanceScanner(this.myClass, instanceReferenceVisitor));
        MyClassMemberReferencesVisitor visitor2 = new MyClassMemberReferencesVisitor(usages, instanceReferenceVisitor);
        this.myClass.accept((PsiElementVisitor)visitor2);
        this.myClassImplementedInterfaces = instanceReferenceVisitor.getImplementedInterfaces();
        for (PsiClass inheritor : inheritors) {
            this.processClass(inheritor, usages);
        }
        UsageInfo[] usageInfoArray = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            InheritanceToDelegationProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    private FieldAccessibility getFieldAccessibility(PsiElement element) {
        for (PsiClass aClass : this.myClassInheritors) {
            if (!PsiTreeUtil.isAncestor((PsiElement)aClass, (PsiElement)element, (boolean)false)) continue;
            return new FieldAccessibility(true, aClass);
        }
        return FieldAccessibility.INVISIBLE;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            InheritanceToDelegationProcessor.$$$reportNull$$$0(3);
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        ArrayList oldUsages = new ArrayList();
        Collections.addAll(oldUsages, usagesIn);
        ObjectUpcastedUsageInfo[] objectUpcastedUsageInfos = InheritanceToDelegationProcessor.objectUpcastedUsages(usagesIn);
        if (this.myPrepareSuccessfulSwingThreadCallback != null) {
            ConflictsDialogBase conflictsDialog;
            MultiMap conflicts = new MultiMap();
            if (objectUpcastedUsageInfos.length > 0) {
                String message = JavaRefactoringBundle.message((String)"instances.of.0.upcasted.to.1.were.found", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myClass, (boolean)true), CommonRefactoringUtil.htmlEmphasize((String)"java.lang.Object")});
                conflicts.putValue((Object)this.myClass, (Object)message);
            }
            this.analyzeConflicts(usagesIn, (MultiMap<PsiElement, String>)conflicts);
            if (!conflicts.isEmpty() && !(conflictsDialog = this.prepareConflictsDialog(conflicts, usagesIn)).showAndGet()) {
                if (conflictsDialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
            if (objectUpcastedUsageInfos.length > 0) {
                this.showObjectUpcastedUsageView(objectUpcastedUsageInfos);
                this.setPreviewUsages(true);
            }
        }
        ArrayList<UsageInfo> filteredUsages = this.filterUsages(oldUsages);
        refUsages.set((Object)filteredUsages.toArray(UsageInfo.EMPTY_ARRAY));
        this.prepareSuccessful();
        return true;
    }

    private void analyzeConflicts(UsageInfo[] usage, MultiMap<PsiElement, String> conflicts) {
        HashMap reportedNonDelegatedUsages = new HashMap();
        HashMap reportedUpcasts = new HashMap();
        String classDescription = RefactoringUIUtil.getDescription((PsiElement)this.myClass, (boolean)false);
        for (UsageInfo aUsage : usage) {
            PsiElement element = aUsage.getElement();
            if (aUsage instanceof InheritanceToDelegationUsageInfo) {
                String message;
                PsiElement container;
                HashSet reportedContainers;
                InheritanceToDelegationUsageInfo usageInfo = (InheritanceToDelegationUsageInfo)aUsage;
                if (this.myIsDelegateOtherMembers || usageInfo.getDelegateFieldAccessible().isAccessible()) continue;
                if (usageInfo instanceof NonDelegatedMemberUsageInfo) {
                    PsiElement nonDelegatedMember = ((NonDelegatedMemberUsageInfo)usageInfo).nonDelegatedMember;
                    reportedContainers = (HashSet)reportedNonDelegatedUsages.get(nonDelegatedMember);
                    if (reportedContainers == null) {
                        reportedContainers = new HashSet();
                        reportedNonDelegatedUsages.put(nonDelegatedMember, reportedContainers);
                    }
                    if (reportedContainers.contains(container = ConflictsUtil.getContainer(element))) continue;
                    message = JavaRefactoringBundle.message((String)"0.uses.1.of.an.instance.of.a.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)nonDelegatedMember, (boolean)true), classDescription});
                    conflicts.putValue((Object)container, (Object)StringUtil.capitalize((String)message));
                    reportedContainers.add(container);
                    continue;
                }
                if (!(usageInfo instanceof UpcastedUsageInfo)) continue;
                PsiClass upcastedTo = ((UpcastedUsageInfo)usageInfo).upcastedTo;
                reportedContainers = (HashSet)reportedUpcasts.get(upcastedTo);
                if (reportedContainers == null) {
                    reportedContainers = new HashSet();
                    reportedUpcasts.put(upcastedTo, reportedContainers);
                }
                if (reportedContainers.contains(container = ConflictsUtil.getContainer(element))) continue;
                message = JavaRefactoringBundle.message((String)"0.upcasts.an.instance.of.1.to.2", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true), classDescription, RefactoringUIUtil.getDescription((PsiElement)upcastedTo, (boolean)false)});
                conflicts.putValue((Object)container, (Object)StringUtil.capitalize((String)message));
                reportedContainers.add(container);
                continue;
            }
            if (!(aUsage instanceof NoLongerOverridingSubClassMethodUsageInfo)) continue;
            NoLongerOverridingSubClassMethodUsageInfo info = (NoLongerOverridingSubClassMethodUsageInfo)aUsage;
            String message = JavaRefactoringBundle.message((String)"0.will.no.longer.override.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)info.getSubClassMethod(), (boolean)true), RefactoringUIUtil.getDescription((PsiElement)info.getOverridenMethod(), (boolean)true)});
            conflicts.putValue((Object)info.getSubClassMethod(), (Object)message);
        }
    }

    private static ObjectUpcastedUsageInfo[] objectUpcastedUsages(UsageInfo[] usages) {
        ArrayList<ObjectUpcastedUsageInfo> result = new ArrayList<ObjectUpcastedUsageInfo>();
        for (UsageInfo usage : usages) {
            if (!(usage instanceof ObjectUpcastedUsageInfo)) continue;
            result.add((ObjectUpcastedUsageInfo)usage);
        }
        return result.toArray(new ObjectUpcastedUsageInfo[0]);
    }

    private ArrayList<UsageInfo> filterUsages(ArrayList<? extends UsageInfo> usages) {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (UsageInfo usageInfo : usages) {
            FieldAccessibility delegateFieldAccessible;
            if (!(usageInfo instanceof InheritanceToDelegationUsageInfo) || usageInfo instanceof ObjectUpcastedUsageInfo || !this.myIsDelegateOtherMembers && !(delegateFieldAccessible = ((InheritanceToDelegationUsageInfo)usageInfo).getDelegateFieldAccessible()).isAccessible()) continue;
            result.add(usageInfo);
        }
        return result;
    }

    private void processClass(PsiClass inheritor, ArrayList<? super UsageInfo> usages) {
        PsiMethod[] methods;
        ClassReferenceSearchingScanner scanner = new ClassReferenceSearchingScanner(inheritor);
        MyClassInstanceReferenceVisitor instanceVisitor = new MyClassInstanceReferenceVisitor(inheritor, usages);
        scanner.processReferences(new ClassInstanceScanner(inheritor, instanceVisitor));
        MyClassInheritorMemberReferencesVisitor classMemberVisitor = new MyClassInheritorMemberReferencesVisitor(inheritor, usages, instanceVisitor);
        inheritor.accept((PsiElementVisitor)classMemberVisitor);
        PsiSubstitutor inheritorSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)this.myClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        block0: for (PsiMethod method : methods = inheritor.getMethods()) {
            PsiMethod[] methodsByName;
            PsiMethod baseMethod = this.findSuperMethodInBaseClass(method);
            if (baseMethod == null) continue;
            if (!baseMethod.hasModifierProperty("abstract")) {
                usages.add(new NoLongerOverridingSubClassMethodUsageInfo(method, baseMethod));
                continue;
            }
            for (PsiMethod classMethod : methodsByName = this.myClass.findMethodsByName(method.getName(), false)) {
                MethodSignature signature = classMethod.getSignature(inheritorSubstitutor);
                if (!signature.equals((Object)method.getSignature(PsiSubstitutor.EMPTY)) || classMethod.hasModifierProperty("abstract")) continue;
                usages.add(new NoLongerOverridingSubClassMethodUsageInfo(method, baseMethod));
                continue block0;
            }
        }
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InheritanceToDelegationProcessor.$$$reportNull$$$0(4);
        }
        try {
            for (UsageInfo aUsage : usages) {
                InheritanceToDelegationUsageInfo usage = (InheritanceToDelegationUsageInfo)aUsage;
                if (usage instanceof UnqualifiedNonDelegatedMemberUsageInfo) {
                    this.delegateUsageFromClass(usage.getElement(), ((NonDelegatedMemberUsageInfo)usage).nonDelegatedMember, usage.getDelegateFieldAccessible());
                    continue;
                }
                this.upcastToDelegation(usage.getElement(), usage.getDelegateFieldAccessible());
            }
            this.myAbstractDelegatedMethods = new HashSet();
            this.addInnerClass();
            this.addField(usages);
            this.delegateMethods();
            this.addImplementingInterfaces();
            this.updateSealedHierarchy();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void addInnerClass() throws IncorrectOperationException {
        if (!this.myIsInnerClassNeeded) {
            return;
        }
        PsiClass innerClass = this.myFactory.createClass(this.myInnerClassName);
        PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)this.myBaseClass, (PsiClass)this.myClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        PsiClassType superClassType = this.myFactory.createType(this.myBaseClass, superClassSubstitutor);
        PsiJavaCodeReferenceElement baseClassReferenceElement = this.myFactory.createReferenceElementByType(superClassType);
        if (!this.myBaseClass.isInterface()) {
            innerClass.getExtendsList().add((PsiElement)baseClassReferenceElement);
        } else {
            innerClass.getImplementsList().add((PsiElement)baseClassReferenceElement);
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)innerClass, (String)"private", (boolean)true);
        innerClass = (PsiClass)this.myClass.add((PsiElement)innerClass);
        List<InnerClassMethod> innerClassMethods = this.getInnerClassMethods();
        for (InnerClassMethod innerClassMethod : innerClassMethods) {
            innerClassMethod.createMethod(innerClass);
        }
    }

    private void delegateUsageFromClass(PsiElement element, PsiElement nonDelegatedMember, FieldAccessibility fieldAccessibility) throws IncorrectOperationException {
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
            if (referenceExpression.getQualifierExpression() != null) {
                this.upcastToDelegation((PsiElement)referenceExpression.getQualifierExpression(), fieldAccessibility);
            } else {
                String name = ((PsiNamedElement)nonDelegatedMember).getName();
                Object qualifier = InheritanceToDelegationProcessor.isStatic(nonDelegatedMember) ? this.myBaseClass.getName() : (!fieldAccessibility.isAccessible() && this.myGenerateGetter ? this.myGetterName + "()" : this.myFieldName);
                PsiExpression newExpr = this.myFactory.createExpressionFromText((String)qualifier + "." + name, element);
                newExpr = (PsiExpression)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)newExpr);
                element.replace((PsiElement)newExpr);
            }
        } else if (element instanceof PsiJavaCodeReferenceElement) {
            String name = ((PsiNamedElement)nonDelegatedMember).getName();
            PsiElement parent = element.getParent();
            if (!InheritanceToDelegationProcessor.isStatic(nonDelegatedMember) && parent instanceof PsiNewExpression) {
                PsiNewExpression newExpr = (PsiNewExpression)parent;
                if (newExpr.getQualifier() != null) {
                    this.upcastToDelegation((PsiElement)newExpr.getQualifier(), fieldAccessibility);
                } else {
                    Object qualifier = !fieldAccessibility.isAccessible() && this.myGenerateGetter ? this.myGetterName + "()" : this.myFieldName;
                    newExpr.replace((PsiElement)this.myFactory.createExpressionFromText((String)qualifier + "." + newExpr.getText(), parent));
                }
            } else {
                String qualifier = this.myBaseClass.getName();
                PsiJavaCodeReferenceElement newRef = this.myFactory.createFQClassNameReferenceElement(qualifier + "." + name, element.getResolveScope());
                element.replace((PsiElement)newRef);
            }
        } else {
            LOG.assertTrue(false);
        }
    }

    private static boolean isStatic(PsiElement member) {
        PsiModifierListOwner method;
        return member instanceof PsiModifierListOwner && (method = (PsiModifierListOwner)member).hasModifierProperty("static");
    }

    private void upcastToDelegation(PsiElement element, FieldAccessibility fieldAccessibility) throws IncorrectOperationException {
        PsiReferenceExpression ref;
        PsiExpression newExpr;
        PsiResolveHelper resolveHelper;
        PsiVariable psiVariable;
        PsiExpression expression = (PsiExpression)element;
        String delegateQualifier = !(expression instanceof PsiQualifiedExpression) ? "a." : ((psiVariable = (resolveHelper = JavaPsiFacade.getInstance((Project)this.myProject).getResolveHelper()).resolveReferencedVariable(this.myFieldName, element)) == null ? "" : "a.");
        if (!fieldAccessibility.isAccessible() && this.myGenerateGetter) {
            newExpr = this.myFactory.createExpressionFromText(delegateQualifier + this.myGetterName + "()", (PsiElement)expression);
            ref = (PsiReferenceExpression)((PsiMethodCallExpression)newExpr).getMethodExpression().getQualifierExpression();
        } else {
            newExpr = this.myFactory.createExpressionFromText(delegateQualifier + this.myFieldName, (PsiElement)expression);
            ref = (PsiReferenceExpression)((PsiReferenceExpression)newExpr).getQualifierExpression();
        }
        if (ref != null) {
            ref.replace((PsiElement)expression);
        }
        expression.replace((PsiElement)newExpr);
    }

    private void delegateMethods() throws IncorrectOperationException {
        for (PsiMethod method : this.myDelegatedMethods) {
            if (this.myAbstractDelegatedMethods.contains(method)) continue;
            PsiMethod methodToAdd = this.delegateMethod(this.myFieldName, method, this.getSuperSubstitutor(method.getContainingClass()));
            String visibility = this.myDelegatedMethodsVisibility.get(method);
            if (visibility != null) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)methodToAdd, (String)visibility, (boolean)true);
            }
            this.myClass.add((PsiElement)methodToAdd);
        }
    }

    private PsiMethod delegateMethod(String delegationTarget, PsiMethod method, PsiSubstitutor substitutor) throws IncorrectOperationException {
        substitutor = OverrideImplementExploreUtil.correctSubstitutor((PsiMethod)method, (PsiSubstitutor)substitutor);
        PsiMethod methodToAdd = GenerateMembersUtil.substituteGenericMethod((PsiMethod)method, (PsiSubstitutor)substitutor);
        methodToAdd.getModifierList().setModifierProperty("abstract", false);
        NullableNotNullManager.getInstance((Project)this.myProject).copyNullableOrNotNullAnnotation((PsiModifierListOwner)method, (PsiModifierListOwner)methodToAdd);
        String delegationBody = InheritanceToDelegationProcessor.getDelegationBody(methodToAdd, delegationTarget);
        PsiCodeBlock newBody = this.myFactory.createCodeBlockFromText(delegationBody, (PsiElement)method);
        PsiCodeBlock oldBody = methodToAdd.getBody();
        if (oldBody != null) {
            oldBody.replace((PsiElement)newBody);
        } else {
            methodToAdd.addBefore((PsiElement)newBody, null);
        }
        if (methodToAdd.getDocComment() != null) {
            methodToAdd.getDocComment().delete();
        }
        methodToAdd = (PsiMethod)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)methodToAdd);
        methodToAdd = (PsiMethod)JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)methodToAdd);
        return methodToAdd;
    }

    private static String getDelegationBody(PsiMethod methodToAdd, String delegationTarget) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{\n");
        if (!PsiTypes.voidType().equals((Object)methodToAdd.getReturnType())) {
            buffer.append("return ");
        }
        buffer.append(delegationTarget);
        buffer.append(".");
        buffer.append(methodToAdd.getName());
        buffer.append("(");
        PsiParameter[] params = methodToAdd.getParameterList().getParameters();
        for (int i = 0; i < params.length; ++i) {
            PsiParameter param = params[i];
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(param.getName());
        }
        buffer.append(");\n}");
        return buffer.toString();
    }

    private void addImplementingInterfaces() throws IncorrectOperationException {
        PsiReferenceList implementsList = this.myClass.getImplementsList();
        LOG.assertTrue(implementsList != null);
        for (PsiClass delegatedInterface : this.myDelegatedInterfaces) {
            if (this.myClassImplementedInterfaces.contains(delegatedInterface)) continue;
            implementsList.add((PsiElement)this.myFactory.createClassReferenceElement(delegatedInterface));
        }
        if (!this.myBaseClass.isInterface()) {
            PsiReferenceList extendsList = this.myClass.getExtendsList();
            LOG.assertTrue(extendsList != null);
            extendsList.getReferenceElements()[0].delete();
        } else {
            PsiJavaCodeReferenceElement[] interfaceRefs;
            for (PsiJavaCodeReferenceElement interfaceRef : interfaceRefs = implementsList.getReferenceElements()) {
                PsiElement resolved = interfaceRef.resolve();
                if (!this.myManager.areElementsEquivalent((PsiElement)this.myBaseClass, resolved)) continue;
                interfaceRef.delete();
                break;
            }
        }
    }

    private void updateSealedHierarchy() {
        if (!this.myBaseClass.hasModifierProperty("sealed")) {
            return;
        }
        SealedUtils.removeFromPermitsList((PsiClass)this.myBaseClass, (PsiClass)this.myClass);
        PsiModifierList modifiers = this.myClass.getModifierList();
        if (modifiers == null) {
            return;
        }
        if (!modifiers.hasExplicitModifier("non-sealed") || SealedUtils.hasSealedParent((PsiClass)this.myClass)) {
            return;
        }
        modifiers.setModifierProperty("non-sealed", false);
    }

    private void addField(UsageInfo[] usages) throws IncorrectOperationException {
        String fieldVisibility = this.getFieldVisibility(usages);
        boolean fieldInitializerNeeded = this.isFieldInitializerNeeded();
        PsiField field = this.createField(fieldVisibility, fieldInitializerNeeded, this.defaultClassFieldType());
        if (!this.myIsInnerClassNeeded) {
            field.getTypeElement().replace((PsiElement)this.myFactory.createTypeElement((PsiType)this.myBaseClassType));
            if (fieldInitializerNeeded) {
                PsiJavaCodeReferenceElement classReferenceElement = this.myFactory.createReferenceElementByType(this.myBaseClassType);
                PsiNewExpression newExpression = (PsiNewExpression)field.getInitializer();
                newExpression.getClassReference().replace((PsiElement)classReferenceElement);
            }
        }
        field = (PsiField)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)field);
        this.myClass.add((PsiElement)field);
        if (!fieldInitializerNeeded) {
            this.fixConstructors();
        }
        if (this.myGenerateGetter) {
            String getterText = "public Object " + this.myGetterName + "() {\n return " + this.myFieldName + ";\n}";
            PsiMethod getter = this.myFactory.createMethodFromText(getterText, (PsiElement)this.myClass);
            getter.getReturnTypeElement().replace((PsiElement)this.myFactory.createTypeElement((PsiType)this.myBaseClassType));
            getter = (PsiMethod)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)getter);
            this.myClass.add((PsiElement)getter);
        }
    }

    private String getFieldVisibility(UsageInfo[] usages) {
        if (this.myIsDelegateOtherMembers && !this.myGenerateGetter) {
            return "public";
        }
        for (UsageInfo aUsage : usages) {
            InheritanceToDelegationUsageInfo usage = (InheritanceToDelegationUsageInfo)aUsage;
            FieldAccessibility delegateFieldAccessible = usage.getDelegateFieldAccessible();
            if (!delegateFieldAccessible.isAccessible() || delegateFieldAccessible.getContainingClass() == this.myClass) continue;
            return "protected";
        }
        return "private";
    }

    private String defaultClassFieldType() {
        return this.myIsInnerClassNeeded ? this.myInnerClassName : "Object";
    }

    private PsiField createField(String fieldVisibility, boolean fieldInitializerNeeded, String defaultTypeName) throws IncorrectOperationException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(fieldVisibility);
        buffer.append(" final ").append(defaultTypeName).append("  ");
        buffer.append(this.myFieldName);
        if (fieldInitializerNeeded) {
            buffer.append(" = new ").append(defaultTypeName).append("()");
        }
        buffer.append(";");
        return this.myFactory.createFieldFromText(buffer.toString(), (PsiElement)this.myClass);
    }

    private void fixConstructors() throws IncorrectOperationException {
        PsiMethod[] constructors;
        if (this.myBaseClass.isInterface()) {
            return;
        }
        PsiJavaCodeReferenceElement baseClassReference = this.myFactory.createClassReferenceElement(this.myBaseClass);
        for (PsiMethod constructor : constructors = this.myClass.getConstructors()) {
            PsiParameter[] constructorParams;
            PsiCodeBlock body = constructor.getBody();
            PsiStatement[] statements = body.getStatements();
            String fieldQualifier = "";
            for (PsiParameter constructorParam : constructorParams = constructor.getParameterList().getParameters()) {
                if (!this.myFieldName.equals(constructorParam.getName())) continue;
                fieldQualifier = "this.";
                break;
            }
            String assignmentText = fieldQualifier + this.myFieldName + "= new " + this.defaultClassFieldType() + "()";
            if (statements.length < 1 || !JavaHighlightUtil.isSuperOrThisCall((PsiStatement)statements[0], (boolean)true, (boolean)true) || this.myBaseClass.isInterface()) {
                PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)this.myFactory.createStatementFromText(assignmentText, (PsiElement)body);
                if (!this.myIsInnerClassNeeded) {
                    PsiAssignmentExpression assignmentExpr = (PsiAssignmentExpression)assignmentStatement.getExpression();
                    PsiNewExpression newExpression = (PsiNewExpression)assignmentExpr.getRExpression();
                    assert (newExpression != null);
                    PsiJavaCodeReferenceElement classRef = newExpression.getClassReference();
                    assert (classRef != null);
                    classRef.replace((PsiElement)baseClassReference);
                }
                assignmentStatement = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)assignmentStatement);
                if (statements.length > 0) {
                    if (!JavaHighlightUtil.isSuperOrThisCall((PsiStatement)statements[0], (boolean)true, (boolean)false)) {
                        body.addBefore((PsiElement)assignmentStatement, (PsiElement)statements[0]);
                        continue;
                    }
                    body.addAfter((PsiElement)assignmentStatement, (PsiElement)statements[0]);
                    continue;
                }
                body.add((PsiElement)assignmentStatement);
                continue;
            }
            PsiExpressionStatement callStatement = (PsiExpressionStatement)statements[0];
            if (JavaHighlightUtil.isSuperOrThisCall((PsiStatement)callStatement, (boolean)false, (boolean)true)) continue;
            PsiMethodCallExpression superConstructorCall = (PsiMethodCallExpression)callStatement.getExpression();
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)this.myFactory.createExpressionFromText(assignmentText, (PsiElement)superConstructorCall);
            PsiNewExpression newExpression = (PsiNewExpression)assignmentExpression.getRExpression();
            if (!this.myIsInnerClassNeeded) {
                newExpression.getClassReference().replace((PsiElement)baseClassReference);
            }
            assignmentExpression = (PsiAssignmentExpression)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)assignmentExpression);
            newExpression.getArgumentList().replace((PsiElement)superConstructorCall.getArgumentList());
            superConstructorCall.replace((PsiElement)assignmentExpression);
        }
    }

    private boolean isFieldInitializerNeeded() {
        PsiMethod[] constructors;
        if (this.myBaseClass.isInterface()) {
            return true;
        }
        for (PsiMethod constructor : constructors = this.myClass.getConstructors()) {
            PsiStatement[] statements = constructor.getBody().getStatements();
            if (statements.length <= 0 || !JavaHighlightUtil.isSuperOrThisCall((PsiStatement)statements[0], (boolean)true, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    private List<InnerClassMethod> getInnerClassMethods() {
        ArrayList<InnerClassMethod> result = new ArrayList<InnerClassMethod>();
        if (!this.myBaseClass.isInterface()) {
            Object constructors;
            for (Object constructor : constructors = this.myClass.getConstructors()) {
                PsiMethodCallExpression superConstructorCall;
                PsiElement superConstructor;
                PsiStatement[] statements = constructor.getBody().getStatements();
                if (statements.length <= 0 || !JavaHighlightUtil.isSuperOrThisCall((PsiStatement)statements[0], (boolean)true, (boolean)false) || !((superConstructor = (superConstructorCall = (PsiMethodCallExpression)((PsiExpressionStatement)statements[0]).getExpression()).getMethodExpression().resolve()) instanceof PsiMethod) || !((PsiMethod)superConstructor).isConstructor()) continue;
                result.add(new InnerClassConstructor((PsiMethod)superConstructor));
            }
        }
        for (PsiMethod method : this.myOverriddenMethods) {
            final class InnerClassOverridingMethod
            extends InnerClassMethod {
                InnerClassOverridingMethod(PsiMethod method) {
                    super(method);
                }

                @Override
                public void createMethod(PsiClass innerClass) throws IncorrectOperationException {
                    OverriddenMethodClassMemberReferencesVisitor visitor2 = new OverriddenMethodClassMemberReferencesVisitor();
                    InheritanceToDelegationProcessor.this.myClass.accept((PsiElementVisitor)visitor2);
                    List<PsiAction> actions = visitor2.getPsiActions();
                    for (PsiAction action : actions) {
                        action.run();
                    }
                    innerClass.add((PsiElement)this.myMethod);
                    this.myMethod.delete();
                }
            }
            result.add(new InnerClassOverridingMethod(method));
        }
        PsiMethod[] methods = this.myBaseClass.getAllMethods();
        for (PsiMethod method : methods) {
            final class InnerClassAbstractMethod
            extends InnerClassMethod {
                private final boolean myImplicitImplementation;

                InnerClassAbstractMethod(PsiMethod method, boolean implicitImplementation) {
                    super(method);
                    this.myImplicitImplementation = implicitImplementation;
                }

                @Override
                public void createMethod(PsiClass innerClass) throws IncorrectOperationException {
                    MethodSignature signature;
                    PsiMethod outerMethod;
                    PsiSubstitutor substitutor = InheritanceToDelegationProcessor.this.getSuperSubstitutor(this.myMethod.getContainingClass());
                    PsiMethod method = InheritanceToDelegationProcessor.this.delegateMethod(InheritanceToDelegationProcessor.this.myClass.getName() + ".this", this.myMethod, substitutor);
                    PsiClass containingClass = this.myMethod.getContainingClass();
                    if (InheritanceToDelegationProcessor.this.myBaseClass.isInterface() || containingClass.isInterface()) {
                        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"public", (boolean)true);
                    }
                    innerClass.add((PsiElement)method);
                    if (!this.myImplicitImplementation && (outerMethod = MethodSignatureUtil.findMethodBySignature((PsiClass)InheritanceToDelegationProcessor.this.myClass, (MethodSignature)(signature = this.myMethod.getSignature(substitutor)), (boolean)false)) == null) {
                        PsiDocComment docComment;
                        String visibility = InheritanceToDelegationProcessor.this.checkOuterClassAbstractMethod(signature);
                        PsiMethod newOuterMethod = (PsiMethod)InheritanceToDelegationProcessor.this.myClass.add((PsiElement)this.myMethod);
                        PsiUtil.setModifierProperty((PsiModifierListOwner)newOuterMethod, (String)visibility, (boolean)true);
                        if (containingClass.isInterface() && !innerClass.isInterface() && this.myMethod.getBody() == null) {
                            PsiUtil.setModifierProperty((PsiModifierListOwner)newOuterMethod, (String)"abstract", (boolean)true);
                        }
                        if ((docComment = newOuterMethod.getDocComment()) != null) {
                            docComment.delete();
                        }
                    }
                }
            }
            if (!method.hasModifierProperty("abstract")) continue;
            MethodSignature signature = method.getSignature(this.getSuperSubstitutor(method.getContainingClass()));
            PsiMethod classMethod = MethodSignatureUtil.findMethodBySignature((PsiClass)this.myClass, (MethodSignature)signature, (boolean)true);
            if (classMethod == null || classMethod.hasModifierProperty("abstract")) {
                result.add(new InnerClassAbstractMethod(method, false));
                continue;
            }
            if (!this.myBaseClass.isInterface() || classMethod.getContainingClass() == this.myClass) continue;
            result.add(new InnerClassAbstractMethod(method, true));
        }
        return result;
    }

    private void showObjectUpcastedUsageView(ObjectUpcastedUsageInfo[] usages) {
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTargetsNodeText(JavaRefactoringBundle.message((String)"replacing.inheritance.with.delegation", (Object[])new Object[0]));
        presentation.setCodeUsagesString(JavaRefactoringBundle.message((String)"instances.casted.to.java.lang.object", (Object[])new Object[0]));
        String upcastedString = JavaRefactoringBundle.message((String)"instances.upcasted.to.object", (Object[])new Object[0]);
        presentation.setUsagesString(upcastedString);
        presentation.setTabText(upcastedString);
        UsageViewManager manager = UsageViewManager.getInstance((Project)this.myProject);
        manager.showUsages(new UsageTarget[]{new PsiElement2UsageTargetAdapter((PsiElement)this.myClass)}, UsageInfoToUsageConverter.convert((PsiElement[])new PsiElement[]{this.myClass}, (UsageInfo[])usages), presentation);
        WindowManager.getInstance().getStatusBar(this.myProject).setInfo(JavaRefactoringBundle.message((String)"instances.upcasted.to.java.lang.object.found", (Object[])new Object[0]));
    }

    @PsiModifier.ModifierConstant
    private String checkOuterClassAbstractMethod(MethodSignature methodSignature) {
        String visibility = "protected";
        for (PsiMethod method : this.myDelegatedMethods) {
            MethodSignature otherSignature = method.getSignature(this.getSuperSubstitutor(method.getContainingClass()));
            if (!MethodSignatureUtil.areSignaturesEqual((MethodSignature)otherSignature, (MethodSignature)methodSignature)) continue;
            visibility = VisibilityUtil.getHighestVisibility((String)visibility, (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList()));
            this.myAbstractDelegatedMethods.add(method);
        }
        return visibility;
    }

    private Set<PsiMethod> getOverriddenMethods() {
        PsiMethod[] methods;
        LinkedHashSet<PsiMethod> result = new LinkedHashSet<PsiMethod>();
        for (PsiMethod method : methods = this.myClass.getMethods()) {
            if (this.findSuperMethodInBaseClass(method) == null) continue;
            result.add(method);
        }
        return result;
    }

    @Nullable
    private PsiMethod findSuperMethodInBaseClass(PsiMethod method) {
        PsiMethod[] superMethods;
        for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
            String qName;
            PsiClass containingClass = superMethod.getContainingClass();
            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)this.myBaseClass, (PsiClass)containingClass, (boolean)true) || "java.lang.Object".equals(qName = containingClass.getQualifiedName())) continue;
            return superMethod;
        }
        return null;
    }

    @NotNull
    protected String getCommandName() {
        String string = JavaRefactoringBundle.message((String)"replace.inheritance.with.delegation.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myClass)});
        if (string == null) {
            InheritanceToDelegationProcessor.$$$reportNull$$$0(5);
        }
        return string;
    }

    private Set<PsiMember> getAllBaseClassMembers() {
        HashSet result = new HashSet();
        Collections.addAll(result, (PsiMember[])this.myBaseClass.getAllFields());
        Collections.addAll(result, (PsiMember[])this.myBaseClass.getAllInnerClasses());
        Collections.addAll(result, (PsiMember[])this.myBaseClass.getAllMethods());
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            PsiMember member = (PsiMember)iterator.next();
            if (!"java.lang.Object".equals(member.getContainingClass().getQualifiedName())) continue;
            iterator.remove();
        }
        return Collections.unmodifiableSet(result);
    }

    private Set<PsiClass> getAllBases() {
        HashSet<PsiClass> temp = new HashSet<PsiClass>();
        InheritanceUtil.getSuperClasses((PsiClass)this.myBaseClass, temp, (boolean)true);
        temp.add(this.myBaseClass);
        return Collections.unmodifiableSet(temp);
    }

    private boolean isDelegated(PsiMember classMember) {
        if (!(classMember instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)classMember;
        for (PsiMethod delegatedMethod : this.myDelegatedMethods) {
            if (!MethodSignatureUtil.areSignaturesEqual((MethodSignature)method.getSignature(PsiSubstitutor.EMPTY), (MethodSignature)delegatedMethod.getSignature(PsiSubstitutor.EMPTY))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetBaseClass";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/inheritanceToDelegation/InheritanceToDelegationProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/inheritanceToDelegation/InheritanceToDelegationProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }

    private final class MyClassInstanceReferenceVisitor
    implements ClassInstanceScanner.ClassInstanceReferenceVisitor {
        private final PsiClass myClass;
        private final List<? super UsageInfo> myUsageInfoStorage;
        private final Set<PsiClass> myImplementedInterfaces;

        MyClassInstanceReferenceVisitor(PsiClass aClass, List<? super UsageInfo> usageInfoStorage) {
            this.myClass = aClass;
            this.myUsageInfoStorage = usageInfoStorage;
            this.myImplementedInterfaces = this.getImplementedInterfaces();
        }

        public Set<PsiClass> getImplementedInterfaces() {
            HashSet<PsiClass> result = new HashSet<PsiClass>();
            for (PsiClass aClass = this.myClass; aClass != null && !InheritanceToDelegationProcessor.this.myManager.areElementsEquivalent((PsiElement)aClass, (PsiElement)InheritanceToDelegationProcessor.this.myBaseClass); aClass = aClass.getSuperClass()) {
                PsiClassType[] implementsTypes;
                for (PsiClassType implementsType : implementsTypes = aClass.getImplementsListTypes()) {
                    PsiClass resolved = implementsType.resolve();
                    if (resolved == null || InheritanceToDelegationProcessor.this.myManager.areElementsEquivalent((PsiElement)resolved, (PsiElement)InheritanceToDelegationProcessor.this.myBaseClass)) continue;
                    result.add(resolved);
                    InheritanceUtil.getSuperClasses((PsiClass)resolved, result, (boolean)true);
                }
            }
            return result;
        }

        @Override
        public void visitQualifier(PsiReferenceExpression qualified, PsiExpression instanceRef, PsiElement referencedInstance) {
            PsiExpression qualifierExpression = qualified.getQualifierExpression();
            if (qualifierExpression == null || qualifierExpression instanceof PsiThisExpression || qualifierExpression instanceof PsiSuperExpression) {
                return;
            }
            PsiElement resolved = qualified.resolve();
            if (resolved != null && (InheritanceToDelegationProcessor.this.myBaseClassMembers.contains(resolved) || InheritanceToDelegationProcessor.this.myOverriddenMethods.contains(resolved)) && !InheritanceToDelegationProcessor.this.isDelegated((PsiMember)resolved)) {
                this.myUsageInfoStorage.add(new NonDelegatedMemberUsageInfo((PsiElement)instanceRef, resolved, InheritanceToDelegationProcessor.this.getFieldAccessibility((PsiElement)instanceRef)));
            }
        }

        @Override
        public void visitTypeCast(PsiTypeCastExpression typeCastExpression, PsiExpression instanceRef, PsiElement referencedInstance) {
            this.processTypedUsage(typeCastExpression.getCastType().getType(), instanceRef);
        }

        @Override
        public void visitReadUsage(PsiExpression instanceRef, PsiType expectedType, PsiElement referencedInstance) {
            this.processTypedUsage(expectedType, instanceRef);
        }

        @Override
        public void visitWriteUsage(PsiExpression instanceRef, PsiType assignedType, PsiElement referencedInstance) {
        }

        private void processTypedUsage(PsiType type, PsiExpression instanceRef) {
            PsiClass aClass = PsiUtil.resolveClassInType((PsiType)type);
            if (aClass == null) {
                return;
            }
            String qName = aClass.getQualifiedName();
            if ("java.lang.Object".equals(qName)) {
                this.myUsageInfoStorage.add(new ObjectUpcastedUsageInfo((PsiElement)instanceRef, aClass, InheritanceToDelegationProcessor.this.getFieldAccessibility((PsiElement)instanceRef)));
            } else if (InheritanceToDelegationProcessor.this.myBaseClassBases.contains(aClass) && !this.myImplementedInterfaces.contains(aClass) && !InheritanceToDelegationProcessor.this.myDelegatedInterfaces.contains(aClass)) {
                this.myUsageInfoStorage.add(new UpcastedUsageInfo((PsiElement)instanceRef, aClass, InheritanceToDelegationProcessor.this.getFieldAccessibility((PsiElement)instanceRef)));
            }
        }
    }

    private class MyClassMemberReferencesVisitor
    extends MyClassInheritorMemberReferencesVisitor {
        MyClassMemberReferencesVisitor(List<? super UsageInfo> usageInfoStorage, ClassInstanceScanner.ClassInstanceReferenceVisitor instanceScanner) {
            super(InheritanceToDelegationProcessor.this.myClass, usageInfoStorage, instanceScanner);
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                MyClassMemberReferencesVisitor.$$$reportNull$$$0(0);
            }
            if (!InheritanceToDelegationProcessor.this.myOverriddenMethods.contains(method)) {
                super.visitMethod(method);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/refactoring/inheritanceToDelegation/InheritanceToDelegationProcessor$MyClassMemberReferencesVisitor", "visitMethod"));
        }
    }

    private class MyClassInheritorMemberReferencesVisitor
    extends ClassMemberReferencesVisitor {
        private final List<? super UsageInfo> myUsageInfoStorage;
        private final ClassInstanceScanner.ClassInstanceReferenceVisitor myInstanceVisitor;

        MyClassInheritorMemberReferencesVisitor(PsiClass aClass, List<? super UsageInfo> usageInfoStorage, ClassInstanceScanner.ClassInstanceReferenceVisitor instanceScanner) {
            super(aClass);
            this.myUsageInfoStorage = usageInfoStorage;
            this.myInstanceVisitor = instanceScanner;
        }

        protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
            if ("super".equals(classMemberReference.getText()) && classMemberReference.getParent() instanceof PsiMethodCallExpression) {
                return;
            }
            if (classMember != null && InheritanceToDelegationProcessor.this.myBaseClassMembers.contains(classMember) && !InheritanceToDelegationProcessor.this.isDelegated(classMember)) {
                FieldAccessibility delegateFieldVisibility = new FieldAccessibility(true, this.getPsiClass());
                NonDelegatedMemberUsageInfo usageInfo = classMemberReference instanceof PsiReferenceExpression && ((PsiReferenceExpression)classMemberReference).getQualifierExpression() != null ? new NonDelegatedMemberUsageInfo((PsiElement)((PsiReferenceExpression)classMemberReference).getQualifierExpression(), (PsiElement)classMember, delegateFieldVisibility) : new UnqualifiedNonDelegatedMemberUsageInfo((PsiElement)classMemberReference, (PsiElement)classMember, delegateFieldVisibility);
                this.myUsageInfoStorage.add(usageInfo);
            }
        }

        public void visitThisExpression(@NotNull PsiThisExpression expression) {
            if (expression == null) {
                MyClassInheritorMemberReferencesVisitor.$$$reportNull$$$0(0);
            }
            ClassInstanceScanner.processNonArrayExpression(this.myInstanceVisitor, (PsiExpression)expression, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/inheritanceToDelegation/InheritanceToDelegationProcessor$MyClassInheritorMemberReferencesVisitor", "visitThisExpression"));
        }
    }

    private class OverriddenMethodClassMemberReferencesVisitor
    extends ClassMemberReferencesVisitor {
        private final ArrayList<PsiAction> myPsiActions;
        private final PsiThisExpression myQualifiedThis;

        OverriddenMethodClassMemberReferencesVisitor() throws IncorrectOperationException {
            super(InheritanceToDelegationProcessor.this.myClass);
            this.myPsiActions = new ArrayList();
            PsiJavaCodeReferenceElement classReferenceElement = InheritanceToDelegationProcessor.this.myFactory.createClassReferenceElement(InheritanceToDelegationProcessor.this.myClass);
            this.myQualifiedThis = (PsiThisExpression)InheritanceToDelegationProcessor.this.myFactory.createExpressionFromText("A.this", null);
            this.myQualifiedThis.getQualifier().replace((PsiElement)classReferenceElement);
        }

        public List<PsiAction> getPsiActions() {
            return this.myPsiActions;
        }

        protected void visitClassMemberReferenceExpression(PsiMember classMember, PsiReferenceExpression classMemberReference) {
            PsiMethod method;
            if (classMember instanceof PsiField) {
                PsiField field = (PsiField)classMember;
                if (field.getContainingClass().equals((Object)InheritanceToDelegationProcessor.this.myClass)) {
                    String name = field.getName();
                    PsiField baseField = InheritanceToDelegationProcessor.this.myBaseClass.findFieldByName(name, true);
                    if (baseField != null) {
                        this.myPsiActions.add(new QualifyName(classMemberReference, name));
                    } else if (classMemberReference.getQualifierExpression() instanceof PsiThisExpression) {
                        this.myPsiActions.add(new QualifyThis((PsiThisExpression)classMemberReference.getQualifierExpression()));
                    }
                }
            } else if (classMember instanceof PsiMethod && (method = (PsiMethod)classMember).getContainingClass().equals((Object)InheritanceToDelegationProcessor.this.myClass)) {
                if (!InheritanceToDelegationProcessor.this.myOverriddenMethods.contains(method)) {
                    PsiMethod baseMethod = InheritanceToDelegationProcessor.this.findSuperMethodInBaseClass(method);
                    if (baseMethod != null) {
                        this.myPsiActions.add(new QualifyName(classMemberReference, baseMethod.getName()));
                    } else if (classMemberReference.getQualifierExpression() instanceof PsiThisExpression) {
                        this.myPsiActions.add(new QualifyThis((PsiThisExpression)classMemberReference.getQualifierExpression()));
                    }
                } else if (!InheritanceToDelegationProcessor.this.myDelegatedMethods.contains(method)) {
                    this.myPsiActions.add(new QualifyWithField(classMemberReference, method.getName()));
                }
            }
        }

        public void visitThisExpression(final @NotNull PsiThisExpression expression) {
            if (expression == null) {
                OverriddenMethodClassMemberReferencesVisitor.$$$reportNull$$$0(0);
            }
            class Visitor
            implements ClassInstanceScanner.ClassInstanceReferenceVisitor {
                Visitor() {
                }

                @Override
                public void visitQualifier(PsiReferenceExpression qualified, PsiExpression instanceRef, PsiElement referencedInstance) {
                    LOG.assertTrue(false);
                }

                @Override
                public void visitTypeCast(PsiTypeCastExpression typeCastExpression, PsiExpression instanceRef, PsiElement referencedInstance) {
                    this.processType(typeCastExpression.getCastType().getType());
                }

                @Override
                public void visitReadUsage(PsiExpression instanceRef, PsiType expectedType, PsiElement referencedInstance) {
                    this.processType(expectedType);
                }

                @Override
                public void visitWriteUsage(PsiExpression instanceRef, PsiType assignedType, PsiElement referencedInstance) {
                    LOG.assertTrue(false);
                }

                private void processType(PsiType type) {
                    PsiClass resolved = PsiUtil.resolveClassInType((PsiType)type);
                    if (resolved != null && !InheritanceToDelegationProcessor.this.myBaseClassBases.contains(resolved)) {
                        OverriddenMethodClassMemberReferencesVisitor.this.myPsiActions.add(new QualifyThis(expression));
                    }
                }
            }
            Visitor visitor2 = new Visitor();
            ClassInstanceScanner.processNonArrayExpression(visitor2, (PsiExpression)expression, null);
        }

        protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/inheritanceToDelegation/InheritanceToDelegationProcessor$OverriddenMethodClassMemberReferencesVisitor", "visitThisExpression"));
        }

        class QualifyName
        implements PsiAction {
            private final PsiReferenceExpression myRef;
            private final String myReferencedName;

            QualifyName(PsiReferenceExpression ref, String name) {
                this.myRef = ref;
                this.myReferencedName = name;
            }

            @Override
            public void run() throws IncorrectOperationException {
                PsiReferenceExpression newRef = (PsiReferenceExpression)InheritanceToDelegationProcessor.this.myFactory.createExpressionFromText("a." + this.myReferencedName, null);
                newRef.getQualifierExpression().replace((PsiElement)OverriddenMethodClassMemberReferencesVisitor.this.myQualifiedThis);
                this.myRef.replace((PsiElement)newRef);
            }
        }

        class QualifyThis
        implements PsiAction {
            private final PsiThisExpression myThisExpression;

            QualifyThis(PsiThisExpression thisExpression) {
                this.myThisExpression = thisExpression;
            }

            @Override
            public void run() throws IncorrectOperationException {
                this.myThisExpression.replace((PsiElement)OverriddenMethodClassMemberReferencesVisitor.this.myQualifiedThis);
            }
        }

        class QualifyWithField
        implements PsiAction {
            private final PsiReferenceExpression myReference;
            private final String myReferencedName;

            QualifyWithField(PsiReferenceExpression reference, String name) {
                this.myReference = reference;
                this.myReferencedName = name;
            }

            @Override
            public void run() throws IncorrectOperationException {
                PsiReferenceExpression newRef = (PsiReferenceExpression)InheritanceToDelegationProcessor.this.myFactory.createExpressionFromText(InheritanceToDelegationProcessor.this.myFieldName + "." + this.myReferencedName, null);
                this.myReference.replace((PsiElement)newRef);
            }
        }
    }

    static interface PsiAction {
        public void run() throws IncorrectOperationException;
    }
}

