/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.java.JavaBundle;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModCommandExecutor;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InlineLocalHandler
extends JavaInlineActionHandler {
    private static final Logger LOG = Logger.getInstance(InlineLocalHandler.class);

    public boolean canInlineElement(PsiElement element) {
        return element instanceof PsiLocalVariable || element instanceof PsiPatternVariable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inlineElement(Project project, Editor editor, PsiElement element) {
        String refactoringId = InlineLocalHandler.getRefactoringId(element);
        RefactoringEventData beforeData = new RefactoringEventData();
        PsiElement scope = InlineLocalHandler.getScope(element);
        beforeData.addElement(element);
        beforeData.addElement(scope);
        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(refactoringId, beforeData);
        try {
            ActionContext context = ActionContext.from((Editor)editor, (PsiFile)element.getContainingFile()).withElement(element);
            String name = this.getActionName(element);
            ModCommandExecutor.executeInteractively((ActionContext)context, (String)name, (Editor)editor, () -> InlineLocalHandler.perform(context));
        }
        finally {
            RefactoringEventData afterData = new RefactoringEventData();
            afterData.addElement(scope);
            ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, afterData);
        }
    }

    @NotNull
    private static String getRefactoringId(@NotNull PsiElement element) {
        if (element == null) {
            InlineLocalHandler.$$$reportNull$$$0(0);
        }
        return element instanceof PsiPatternVariable ? "refactoring.inline.pattern.variable" : "refactoring.inline.local.variable";
    }

    private static PsiElement getScope(PsiElement element) {
        return PsiUtil.getVariableCodeBlock((PsiVariable)((PsiVariable)element), null);
    }

    @NotNull
    private static ModCommand perform(ActionContext context) {
        PsiElement psiElement;
        PsiElement psiElement2 = context.findLeaf();
        if (psiElement2 instanceof PsiIdentifier) {
            PsiIdentifier id = (PsiIdentifier)psiElement2;
            psiElement = id.getParent();
        } else {
            psiElement2 = context.findLeafOnTheLeft();
            if (psiElement2 instanceof PsiIdentifier) {
                PsiIdentifier id = (PsiIdentifier)psiElement2;
                psiElement = id.getParent();
            } else {
                psiElement = null;
            }
        }
        PsiElement parent = psiElement;
        PsiReferenceExpression refExpr = (PsiReferenceExpression)ObjectUtils.tryCast((Object)parent, PsiReferenceExpression.class);
        InlineMode mode = refExpr != null && PlatformUtils.isFleetBackend() && JavaRefactoringSettings.getInstance().INLINE_LOCAL_THIS ? InlineMode.INLINE_ONE : InlineMode.CHECK_CONFLICTS;
        return InlineLocalHandler.doInline(context, (PsiVariable)Objects.requireNonNull(context.element()), refExpr, mode);
    }

    @NotNull
    public static ModCommand doInline(@NotNull ActionContext context, @NotNull PsiVariable var, @Nullable PsiReferenceExpression refExpr, @NotNull InlineMode mode) {
        List<PsiReferenceExpression> allRefs;
        if (context == null) {
            InlineLocalHandler.$$$reportNull$$$0(1);
        }
        if (var == null) {
            InlineLocalHandler.$$$reportNull$$$0(2);
        }
        if (mode == null) {
            InlineLocalHandler.$$$reportNull$$$0(3);
        }
        List<PsiReferenceExpression> list = allRefs = refExpr != null && mode == InlineMode.INLINE_ONE ? List.of(refExpr) : VariableAccessUtils.getVariableReferences((PsiVariable)var);
        if (allRefs.isEmpty()) {
            ModCommand modCommand = ModCommand.error((String)RefactoringBundle.message((String)"variable.is.never.used", (Object[])new Object[]{var.getName()}));
            if (modCommand == null) {
                InlineLocalHandler.$$$reportNull$$$0(4);
            }
            return modCommand;
        }
        if (var instanceof PsiLocalVariable) {
            PsiLocalVariable local = (PsiLocalVariable)var;
            return InlineLocalHandler.inlineLocal(context, local, refExpr, allRefs, mode);
        }
        return InlineLocalHandler.inlinePattern(context, (PsiPatternVariable)var, refExpr, allRefs, mode);
    }

    @NotNull
    private static ModCommand inlinePattern(@NotNull ActionContext context, @NotNull PsiPatternVariable pattern, @Nullable PsiReferenceExpression refExpr, @NotNull List<PsiReferenceExpression> allRefs, @NotNull InlineMode mode) {
        String initializerText;
        if (context == null) {
            InlineLocalHandler.$$$reportNull$$$0(5);
        }
        if (pattern == null) {
            InlineLocalHandler.$$$reportNull$$$0(6);
        }
        if (allRefs == null) {
            InlineLocalHandler.$$$reportNull$$$0(7);
        }
        if (mode == null) {
            InlineLocalHandler.$$$reportNull$$$0(8);
        }
        if ((initializerText = JavaPsiPatternUtil.getEffectiveInitializerText((PsiPatternVariable)pattern)) == null) {
            ModCommand modCommand = ModCommand.error((String)JavaRefactoringBundle.message((String)"tooltip.cannot.inline.pattern.variable", (Object[])new Object[0]));
            if (modCommand == null) {
                InlineLocalHandler.$$$reportNull$$$0(9);
            }
            return modCommand;
        }
        Project project = context.project();
        if (mode == InlineMode.CHECK_CONFLICTS || mode == InlineMode.ASK) {
            if (refExpr == null || allRefs.size() == 1 || !EditorSettingsExternalizable.getInstance().isShowInlineLocalDialog()) {
                mode = InlineMode.INLINE_ALL_AND_DELETE;
            } else {
                return InlineLocalHandler.createChooser((PsiVariable)pattern, refExpr, allRefs);
            }
        }
        PsiElement[] refsToInline = PsiUtilCore.toPsiElementArray(allRefs);
        PsiExpression defToInline = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(initializerText, (PsiElement)pattern);
        boolean inlineAll = mode == InlineMode.INLINE_ALL_AND_DELETE;
        ModCommand modCommand = ModCommand.psiUpdate((ActionContext)context, updater -> {
            PsiPatternVariable writablePattern = (PsiPatternVariable)updater.getWritable((PsiElement)pattern);
            List<SmartPsiElementPointer<PsiExpression>> pointers = InlineLocalHandler.inlineOccurrences(project, (PsiVariable)writablePattern, defToInline, ContainerUtil.map((Object[])refsToInline, arg_0 -> ((ModPsiUpdater)updater).getWritable(arg_0)));
            if (inlineAll) {
                writablePattern.delete();
            }
            InlineLocalHandler.highlightOccurrences(updater, pointers);
        });
        if (modCommand == null) {
            InlineLocalHandler.$$$reportNull$$$0(10);
        }
        return modCommand;
    }

    @NotNull
    private static ModCommand createChooser(@NotNull PsiVariable variable, @Nullable PsiReferenceExpression refExpr, @NotNull List<? extends PsiElement> allRefs) {
        if (variable == null) {
            InlineLocalHandler.$$$reportNull$$$0(11);
        }
        if (allRefs == null) {
            InlineLocalHandler.$$$reportNull$$$0(12);
        }
        ModCommand modCommand = ModCommand.chooseAction((String)InlineLocalHandler.getRefactoringName((PsiElement)variable), (ModCommandAction[])new ModCommandAction[]{new InlineLocalStep(variable, refExpr, InlineMode.INLINE_ONE, allRefs), new InlineLocalStep(variable, refExpr, InlineMode.INLINE_ALL_AND_DELETE, allRefs)});
        if (modCommand == null) {
            InlineLocalHandler.$$$reportNull$$$0(13);
        }
        return modCommand;
    }

    @NotNull
    private static ModCommand createRenameChooser(@NotNull PsiVariable variable, @NotNull List<? extends PsiElement> allRefs) {
        if (variable == null) {
            InlineLocalHandler.$$$reportNull$$$0(14);
        }
        if (allRefs == null) {
            InlineLocalHandler.$$$reportNull$$$0(15);
        }
        ModCommand modCommand = ModCommand.chooseAction((String)InlineLocalHandler.getRefactoringName((PsiElement)variable), (ModCommandAction[])new ModCommandAction[]{new InlineLocalStep(variable, null, InlineMode.INLINE_ALL_KEEP_OLD_NAME, allRefs), new InlineLocalStep(variable, null, InlineMode.INLINE_ALL_RENAME_INITIALIZER, allRefs)});
        if (modCommand == null) {
            InlineLocalHandler.$$$reportNull$$$0(16);
        }
        return modCommand;
    }

    private static ModCommand createConflictChooser(PsiLocalVariable variable, PsiReferenceExpression refExpr, Map<PsiElement, PsiVariable> conflicts) {
        return ModCommand.chooseAction((String)JavaRefactoringBundle.message((String)"inline.warning.variables.used.in.initializer.are.updated", (Object[])new Object[0]), (ModCommandAction[])new ModCommandAction[]{new InlineLocalStep((PsiVariable)variable, refExpr, InlineMode.HIGHLIGHT_CONFLICTS, conflicts.keySet()), new InlineLocalStep((PsiVariable)variable, refExpr, InlineMode.ASK, List.of())});
    }

    @NotNull
    private static ModCommand inlineLocal(@NotNull ActionContext context, @NotNull PsiLocalVariable local, @Nullable PsiReferenceExpression refExpr, @NotNull List<PsiReferenceExpression> allRefs, @NotNull InlineMode mode) {
        PsiReferenceExpression ref2;
        PsiExpression psiExpression;
        PsiAssignmentExpression assignment;
        PsiElement psiElement;
        PsiExpression defToInline;
        PsiCodeBlock containerBlock;
        InnerClassUsages innerClassUses;
        String localName;
        block43: {
            ModCommand modCommand;
            if (context == null) {
                InlineLocalHandler.$$$reportNull$$$0(17);
            }
            if (local == null) {
                InlineLocalHandler.$$$reportNull$$$0(18);
            }
            if (allRefs == null) {
                InlineLocalHandler.$$$reportNull$$$0(19);
            }
            if (mode == null) {
                InlineLocalHandler.$$$reportNull$$$0(20);
            }
            localName = local.getName();
            innerClassUses = InnerClassUsages.getUsages(local, allRefs);
            containerBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)local, PsiCodeBlock.class);
            if (containerBlock == null) {
                ModCommand modCommand2 = ModCommand.error((String)JavaRefactoringBundle.message((String)"inline.local.variable.declared.outside.cannot.refactor.message", (Object[])new Object[0]));
                if (modCommand2 == null) {
                    InlineLocalHandler.$$$reportNull$$$0(21);
                }
                return modCommand2;
            }
            try {
                List<PsiElement> innerClassesWithUsages = innerClassUses.innerClassesWithUsages();
                defToInline = InlineLocalHandler.getDefToInline((PsiVariable)local, (PsiElement)(innerClassesWithUsages.isEmpty() ? refExpr : innerClassesWithUsages.get(0)), containerBlock, true);
                if (defToInline != null) break block43;
                String key = refExpr == null ? "variable.has.no.initializer" : "variable.has.no.dominating.definition";
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)key, (Object[])new Object[]{localName}));
                modCommand = ModCommand.error((String)message);
            }
            catch (RuntimeException e) {
                return InlineLocalHandler.processWrappedAnalysisCanceledException(e);
            }
            if (modCommand == null) {
                InlineLocalHandler.$$$reportNull$$$0(22);
            }
            return modCommand;
        }
        ArrayList<Object> refsToInlineList = new ArrayList<Object>();
        boolean simpleInlining = false;
        if (mode == InlineMode.INLINE_ONE && refExpr != null) {
            refsToInlineList.add(refExpr);
        } else {
            List refs;
            if (defToInline == local.getInitializer() && !ContainerUtil.exists((Iterable)(refs = VariableAccessUtils.getVariableReferences((PsiVariable)local)), ref -> PsiUtil.isAccessedForWriting((PsiExpression)ref))) {
                simpleInlining = true;
                refsToInlineList.addAll(refs);
            }
            if (!simpleInlining) {
                try {
                    Collections.addAll(refsToInlineList, DefUseUtil.getRefs((PsiCodeBlock)containerBlock, (PsiVariable)local, (PsiElement)defToInline, (boolean)true));
                }
                catch (RuntimeException e) {
                    return InlineLocalHandler.processWrappedAnalysisCanceledException(e);
                }
            }
            for (PsiElement innerClassUsage : innerClassUses.innerClassUsages()) {
                if (refsToInlineList.contains(innerClassUsage)) continue;
                refsToInlineList.add(innerClassUsage);
            }
        }
        if (refsToInlineList.isEmpty()) {
            ModCommand modCommand = ModCommand.error((String)JavaRefactoringBundle.message((String)"variable.is.never.used.before.modification", (Object[])new Object[]{localName}));
            if (modCommand == null) {
                InlineLocalHandler.$$$reportNull$$$0(23);
            }
            return modCommand;
        }
        if (mode == InlineMode.CHECK_CONFLICTS) {
            Map<PsiElement, PsiVariable> conflicts = InlineUtil.getChangedBeforeLastAccessMap(defToInline, (PsiVariable)local);
            if (conflicts.isEmpty()) {
                mode = InlineMode.ASK;
            } else {
                ModCommand modCommand = InlineLocalHandler.createConflictChooser(local, refExpr, conflicts);
                if (modCommand == null) {
                    InlineLocalHandler.$$$reportNull$$$0(24);
                }
                return modCommand;
            }
        }
        if (mode == InlineMode.ASK) {
            PsiElement innerClassUsage;
            if (refExpr != null && refsToInlineList.size() > 1 && refsToInlineList.contains(refExpr) && EditorSettingsExternalizable.getInstance().isShowInlineLocalDialog()) {
                return InlineLocalHandler.createChooser((PsiVariable)local, refExpr, refsToInlineList);
            }
            if (defToInline == local.getInitializer() && (innerClassUsage = PsiUtil.skipParenthesizedExprDown((PsiExpression)defToInline)) instanceof PsiReferenceExpression) {
                PsiVariable var;
                PsiElement psiElement2;
                PsiReferenceExpression ref3 = (PsiReferenceExpression)innerClassUsage;
                if (ControlFlowUtil.isEffectivelyFinal((PsiVariable)local, (PsiElement)containerBlock) && (psiElement2 = ref3.resolve()) instanceof PsiVariable && PsiUtil.isJvmLocalVariable((PsiElement)(var = (PsiVariable)psiElement2)) && var.getType().equals(local.getType())) {
                    return InlineLocalHandler.createRenameChooser((PsiVariable)local, refsToInlineList);
                }
            }
        }
        Object[] refsToInline = PsiUtilCore.toPsiElementArray(refsToInlineList);
        if (refExpr != null && PsiUtil.isAccessedForReading((PsiExpression)refExpr) && ArrayUtil.find((Object[])refsToInline, (Object)refExpr) < 0) {
            PsiElement[] defs = DefUseUtil.getDefs((PsiCodeBlock)containerBlock, (PsiVariable)local, (PsiElement)refExpr);
            LOG.assertTrue(defs.length > 0);
            ModCommand modCommand = ModCommand.highlight((PsiElement[])defs).andThen(ModCommand.error((String)RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"variable.is.accessed.for.writing", (Object[])new Object[]{localName}))));
            if (modCommand == null) {
                InlineLocalHandler.$$$reportNull$$$0(25);
            }
            return modCommand;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)defToInline, PsiTryStatement.class);
        if (tryStatement != null && ExceptionUtil.getThrownExceptions((PsiElement)defToInline).isEmpty()) {
            tryStatement = null;
        }
        PsiFile workingFile = local.getContainingFile();
        for (Object ref4 : refsToInline) {
            PsiFile otherFile = ref4.getContainingFile();
            if (!otherFile.equals((Object)workingFile)) {
                ModCommand modCommand = ModCommand.error((String)RefactoringBundle.message((String)"variable.is.referenced.in.multiple.files", (Object[])new Object[]{localName}));
                if (modCommand == null) {
                    InlineLocalHandler.$$$reportNull$$$0(26);
                }
                return modCommand;
            }
            if (tryStatement == null || PsiTreeUtil.isAncestor((PsiElement)tryStatement, (PsiElement)ref4, (boolean)false)) continue;
            ModCommand modCommand = ModCommand.error((String)JavaRefactoringBundle.message((String)"inline.local.unable.try.catch.warning.message", (Object[])new Object[0]));
            if (modCommand == null) {
                InlineLocalHandler.$$$reportNull$$$0(27);
            }
            return modCommand;
        }
        for (Object ref4 : refsToInline) {
            PsiElement[] defs = DefUseUtil.getDefs((PsiCodeBlock)containerBlock, (PsiVariable)local, (PsiElement)ref4);
            boolean isSameDefinition = true;
            for (PsiElement def : defs) {
                isSameDefinition &= InlineLocalHandler.isSameDefinition(def, defToInline);
            }
            if (isSameDefinition) continue;
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"variable.is.accessed.for.writing.and.used.with.inlined", (Object[])new Object[]{localName}));
            ModCommand modCommand = ModCommand.highlight((TextAttributesKey)EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES, (PsiElement[])defs).andThen(ModCommand.highlight((PsiElement[])new PsiElement[]{ref4})).andThen(ModCommand.error((String)message));
            if (modCommand == null) {
                InlineLocalHandler.$$$reportNull$$$0(28);
            }
            return modCommand;
        }
        PsiElement writeAccess = InlineLocalHandler.checkRefsInAugmentedAssignmentOrUnaryModified((PsiElement[])refsToInline, (PsiElement)defToInline);
        if (!(writeAccess == null || (psiElement = writeAccess.getParent()) instanceof PsiAssignmentExpression && (assignment = (PsiAssignmentExpression)psiElement).getLExpression() == writeAccess && ArrayUtil.contains((Object)writeAccess, (Object[])refsToInline))) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"variable.is.accessed.for.writing", (Object[])new Object[]{localName}));
            ModCommand modCommand = ModCommand.highlight((TextAttributesKey)EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES, (PsiElement[])new PsiElement[]{writeAccess}).andThen(ModCommand.error((String)message));
            if (modCommand == null) {
                InlineLocalHandler.$$$reportNull$$$0(29);
            }
            return modCommand;
        }
        if (ContainerUtil.exists((Object[])refsToInline, ref -> ref.getParent() instanceof PsiResourceExpression)) {
            ModCommand modCommand = ModCommand.error((String)RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"inline.local.used.as.resource.cannot.refactor.message", (Object[])new Object[0])));
            if (modCommand == null) {
                InlineLocalHandler.$$$reportNull$$$0(30);
            }
            return modCommand;
        }
        Project project = context.project();
        if (mode == InlineMode.INLINE_ALL_RENAME_INITIALIZER && (psiExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)defToInline)) instanceof PsiReferenceExpression && (psiExpression = (ref2 = (PsiReferenceExpression)psiExpression).resolve()) instanceof PsiVariable) {
            PsiVariable nextVar = (PsiVariable)psiExpression;
            ModCommand modCommand = ModCommand.psiUpdate((ActionContext)context, updater -> InlineLocalHandler.renameNextVariable(local, nextVar, updater));
            if (modCommand == null) {
                InlineLocalHandler.$$$reportNull$$$0(31);
            }
            return modCommand;
        }
        boolean inlineAll = mode != InlineMode.INLINE_ONE;
        ModCommand modCommand = ModCommand.psiUpdate((ActionContext)context, arg_0 -> InlineLocalHandler.lambda$inlineLocal$5(defToInline, local, (PsiElement[])refsToInline, writeAccess, project, inlineAll, arg_0));
        if (modCommand == null) {
            InlineLocalHandler.$$$reportNull$$$0(32);
        }
        return modCommand;
    }

    private static void renameNextVariable(@NotNull PsiLocalVariable local, @NotNull PsiVariable nextVar, @NotNull ModPsiUpdater updater) {
        if (local == null) {
            InlineLocalHandler.$$$reportNull$$$0(33);
        }
        if (nextVar == null) {
            InlineLocalHandler.$$$reportNull$$$0(34);
        }
        if (updater == null) {
            InlineLocalHandler.$$$reportNull$$$0(35);
        }
        PsiVariable writableNextVar = (PsiVariable)updater.getWritable((PsiElement)nextVar);
        List refs = VariableAccessUtils.getVariableReferences((PsiVariable)writableNextVar);
        new CommentTracker().deleteAndRestoreComments(updater.getWritable((PsiElement)local));
        writableNextVar.setName(local.getName());
        for (PsiReferenceExpression nextVarRef : refs) {
            if (!nextVarRef.isValid()) continue;
            nextVarRef.handleElementRename(local.getName());
        }
    }

    @NotNull
    private static List<SmartPsiElementPointer<PsiExpression>> inlineOccurrences(@NotNull Project project, @NotNull PsiVariable local, PsiExpression defToInline, @NotNull List<PsiElement> refsToInline) {
        if (project == null) {
            InlineLocalHandler.$$$reportNull$$$0(36);
        }
        if (local == null) {
            InlineLocalHandler.$$$reportNull$$$0(37);
        }
        if (refsToInline == null) {
            InlineLocalHandler.$$$reportNull$$$0(38);
        }
        ArrayList<SmartPsiElementPointer<PsiExpression>> pointers = new ArrayList<SmartPsiElementPointer<PsiExpression>>();
        SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project);
        for (PsiElement element : refsToInline) {
            PsiJavaCodeReferenceElement refElement = (PsiJavaCodeReferenceElement)element;
            if (refElement.getParent() instanceof PsiMethodCallExpression) continue;
            pointers.add((SmartPsiElementPointer<PsiExpression>)pointerManager.createSmartPsiElementPointer((PsiElement)InlineUtil.inlineVariable(local, defToInline, refElement)));
        }
        ArrayList<SmartPsiElementPointer<PsiExpression>> arrayList = pointers;
        if (arrayList == null) {
            InlineLocalHandler.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    private static void highlightOccurrences(ModPsiUpdater updater, List<SmartPsiElementPointer<PsiExpression>> pointers) {
        for (SmartPsiElementPointer<PsiExpression> pointer : pointers) {
            PsiExpression expression = (PsiExpression)pointer.getElement();
            if (expression == null) continue;
            updater.highlight((PsiElement)expression);
        }
        if (pointers.size() > 1) {
            Shortcut shortcut = KeymapUtil.getPrimaryShortcut((String)"FindNext");
            String message = shortcut != null ? JavaBundle.message((String)"hint.text.press.to.go.through.inlined.occurrences", (Object[])new Object[]{KeymapUtil.getShortcutText((Shortcut)shortcut), pointers.size()}) : JavaBundle.message((String)"hint.text.occurrences.were.inlined", (Object[])new Object[]{pointers.size()});
            updater.message(message);
        }
    }

    @NotNull
    private static ModCommand processWrappedAnalysisCanceledException(@NotNull RuntimeException e) {
        Throwable cause;
        if (e == null) {
            InlineLocalHandler.$$$reportNull$$$0(40);
        }
        if ((cause = e.getCause()) instanceof AnalysisCanceledException) {
            ModCommand modCommand = ModCommand.error((String)RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"extract.method.control.flow.analysis.failed", (Object[])new Object[0])));
            if (modCommand == null) {
                InlineLocalHandler.$$$reportNull$$$0(41);
            }
            return modCommand;
        }
        throw e;
    }

    private static void deleteInitializer(@NotNull PsiExpression defToInline) {
        PsiElement gParent;
        PsiElement parent;
        if (defToInline == null) {
            InlineLocalHandler.$$$reportNull$$$0(42);
        }
        if ((parent = defToInline.getParent()) instanceof PsiAssignmentExpression && !((gParent = PsiUtil.skipParenthesizedExprUp((PsiElement)parent.getParent())) instanceof PsiExpressionStatement)) {
            parent.replace((PsiElement)defToInline);
            return;
        }
        parent.delete();
    }

    @Nullable
    static PsiElement checkRefsInAugmentedAssignmentOrUnaryModified(PsiElement[] refsToInline, PsiElement defToInline) {
        for (PsiElement element : refsToInline) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiArrayAccessExpression) {
                if (((PsiArrayAccessExpression)parent).getIndexExpression() == element || defToInline instanceof PsiExpression && !(defToInline instanceof PsiNewExpression)) continue;
                element = parent;
            }
            if (!RefactoringUtil.isAssignmentLHS(element)) continue;
            return element;
        }
        return null;
    }

    private static boolean isSameDefinition(PsiElement def, PsiExpression defToInline) {
        if (def instanceof PsiLocalVariable) {
            return defToInline.equals((Object)((PsiLocalVariable)def).getInitializer());
        }
        PsiElement parent = def.getParent();
        return parent instanceof PsiAssignmentExpression && defToInline.equals((Object)((PsiAssignmentExpression)parent).getRExpression());
    }

    private static boolean isInliningVariableInitializer(PsiExpression defToInline) {
        return defToInline.getParent() instanceof PsiVariable;
    }

    @Nullable
    static PsiExpression getDefToInline(PsiVariable local, PsiElement refExpr, @NotNull PsiCodeBlock block, boolean rethrow) {
        PsiExpression initializer;
        List refs;
        if (block == null) {
            InlineLocalHandler.$$$reportNull$$$0(43);
        }
        if (refExpr != null) {
            PsiElement psiElement;
            PsiElement def;
            if (refExpr instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)refExpr))) {
                def = refExpr;
            } else {
                if (local instanceof PsiLocalVariable && refExpr instanceof PsiReferenceExpression && !ContainerUtil.exists((Iterable)(refs = VariableAccessUtils.getVariableReferences((PsiVariable)local, (PsiElement)block)), ref -> PsiUtil.isAccessedForWriting((PsiExpression)ref))) {
                    return local.getInitializer();
                }
                PsiElement[] defs = DefUseUtil.getDefs((PsiCodeBlock)block, (PsiVariable)local, (PsiElement)refExpr, (boolean)rethrow);
                if (defs.length == 1) {
                    def = defs[0];
                } else {
                    return null;
                }
            }
            if (def instanceof PsiReferenceExpression && (psiElement = def.getParent()) instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)psiElement;
                if (assignmentExpression.getOperationTokenType() != JavaTokenType.EQ) {
                    return null;
                }
                PsiExpression rExpr = assignmentExpression.getRExpression();
                if (rExpr != null) {
                    return rExpr;
                }
            }
        }
        if ((initializer = local.getInitializer()) != null) {
            return initializer;
        }
        refs = VariableAccessUtils.getVariableReferences((PsiVariable)local, (PsiElement)block);
        HashSet<PsiExpression> allDefs = new HashSet<PsiExpression>();
        for (PsiReferenceExpression ref2 : refs) {
            if (PsiUtil.isAccessedForWriting((PsiExpression)ref2)) {
                if (!PsiUtil.isAccessedForReading((PsiExpression)ref2)) continue;
                return null;
            }
            PsiExpression def = InlineLocalHandler.getDefToInline(local, (PsiElement)ref2, block, rethrow);
            if (def == null) {
                return null;
            }
            allDefs.add(def);
            if (allDefs.size() == 1) continue;
            return null;
        }
        return (PsiExpression)ContainerUtil.getOnlyItem(allDefs);
    }

    @NotNull
    public String getActionName(PsiElement element) {
        return InlineLocalHandler.getRefactoringName(element);
    }

    @NlsContexts.DialogTitle
    @NotNull
    private static String getRefactoringName(PsiElement variable) {
        String string = variable instanceof PsiPatternVariable ? JavaRefactoringBundle.message((String)"inline.pattern.variable.title", (Object[])new Object[0]) : RefactoringBundle.message((String)"inline.variable.title");
        if (string == null) {
            InlineLocalHandler.$$$reportNull$$$0(44);
        }
        return string;
    }

    private static /* synthetic */ void lambda$inlineLocal$5(PsiExpression defToInline, PsiLocalVariable local, PsiElement[] refsToInline, PsiElement writeAccess, Project project, boolean inlineAll, ModPsiUpdater updater) {
        PsiExpression writableDef = (PsiExpression)updater.getWritable((PsiElement)defToInline);
        PsiLocalVariable writableLocal = (PsiLocalVariable)updater.getWritable((PsiElement)local);
        List writableRefs = StreamEx.of((Object[])refsToInline).without((Object)writeAccess).map(arg_0 -> ((ModPsiUpdater)updater).getWritable(arg_0)).toList();
        PsiElement writableWrite = updater.getWritable(writeAccess);
        List<SmartPsiElementPointer<PsiExpression>> pointers = InlineLocalHandler.inlineOccurrences(project, (PsiVariable)writableLocal, writableDef, writableRefs);
        if (writableWrite != null && writableWrite.isValid()) {
            PsiAssignmentExpression newAssignment = PsiReplacementUtil.replaceOperatorAssignmentWithAssignmentExpression((PsiAssignmentExpression)((PsiAssignmentExpression)writableWrite.getParent()));
            for (PsiReferenceExpression ref : VariableAccessUtils.getVariableReferences((PsiVariable)writableLocal, (PsiElement)newAssignment.getRExpression())) {
                pointers.add((SmartPsiElementPointer<PsiExpression>)SmartPointerManager.createPointer((PsiElement)InlineUtil.inlineVariable((PsiVariable)local, defToInline, (PsiJavaCodeReferenceElement)ref)));
            }
        }
        if (inlineAll) {
            if (!InlineLocalHandler.isInliningVariableInitializer(writableDef)) {
                InlineLocalHandler.deleteInitializer(writableDef);
            } else {
                writableDef.delete();
            }
        }
        if (inlineAll && !VariableAccessUtils.variableIsUsed((PsiVariable)writableLocal, (PsiElement)PsiUtil.getVariableCodeBlock((PsiVariable)writableLocal, null))) {
            writableLocal.normalizeDeclaration();
            new CommentTracker().deleteAndRestoreComments((PsiElement)writableLocal);
        }
        InlineLocalHandler.highlightOccurrences(updater, pointers);
        for (SmartPsiElementPointer<PsiExpression> expr : pointers) {
            CommonJavaRefactoringUtil.tryToInlineArrayCreationForVarargs((PsiExpression)((PsiExpression)expr.getElement()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9, 10, 13, 16, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 39, 41, 44 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 3: 
            case 8: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 39: 
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/inline/InlineLocalHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 7: 
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRefs";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 18: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextVar";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refsToInline";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defToInline";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/inline/InlineLocalHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doInline";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "inlinePattern";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createChooser";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenameChooser";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "inlineLocal";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "inlineOccurrences";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "processWrappedAnalysisCanceledException";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRefactoringId";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInline";
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 39: 
            case 41: 
            case 44: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "inlinePattern";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createChooser";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createRenameChooser";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "inlineLocal";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "renameNextVariable";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "inlineOccurrences";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processWrappedAnalysisCanceledException";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "deleteInitializer";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getDefToInline";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 9, 10, 13, 16, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 39, 41, 44 -> new IllegalStateException(string);
        };
    }

    public static enum InlineMode {
        CHECK_CONFLICTS,
        ASK,
        HIGHLIGHT_CONFLICTS,
        INLINE_ONE,
        INLINE_ALL_AND_DELETE,
        INLINE_ALL_KEEP_OLD_NAME,
        INLINE_ALL_RENAME_INITIALIZER;

    }

    private static class InlineLocalStep
    implements ModCommandAction {
        @NotNull
        private final PsiVariable myVariable;
        @Nullable
        private final PsiReferenceExpression myRefExpr;
        @NotNull
        private final InlineMode myMode;
        @NotNull
        private final Collection<? extends PsiElement> myAllRefs;

        private InlineLocalStep(@NotNull PsiVariable variable, @Nullable PsiReferenceExpression refExpr, @NotNull InlineMode mode, @NotNull Collection<? extends PsiElement> allRefs) {
            if (variable == null) {
                InlineLocalStep.$$$reportNull$$$0(0);
            }
            if (mode == null) {
                InlineLocalStep.$$$reportNull$$$0(1);
            }
            if (allRefs == null) {
                InlineLocalStep.$$$reportNull$$$0(2);
            }
            this.myVariable = variable;
            this.myRefExpr = refExpr;
            this.myMode = mode;
            this.myAllRefs = allRefs;
        }

        @NotNull
        public ModCommand perform(@NotNull ActionContext context) {
            if (context == null) {
                InlineLocalStep.$$$reportNull$$$0(3);
            }
            if (this.myMode == InlineMode.HIGHLIGHT_CONFLICTS) {
                ModCommand modCommand = ModCommand.highlight((PsiElement[])this.myAllRefs.toArray(PsiElement.EMPTY_ARRAY)).andThen(this.myAllRefs.stream().findFirst().map(ModCommand::select).orElse(ModCommand.nop()));
                if (modCommand == null) {
                    InlineLocalStep.$$$reportNull$$$0(4);
                }
                return modCommand;
            }
            ModCommand modCommand = InlineLocalHandler.doInline(context, this.myVariable, this.myRefExpr, this.myMode);
            if (modCommand == null) {
                InlineLocalStep.$$$reportNull$$$0(5);
            }
            return modCommand;
        }

        @NotNull
        public Presentation getPresentation(@NotNull ActionContext context) {
            TextRange[] textRangeArray;
            if (context == null) {
                InlineLocalStep.$$$reportNull$$$0(6);
            }
            Presentation presentation = Presentation.of((String)this.getFamilyName());
            if (this.myMode == InlineMode.INLINE_ONE) {
                TextRange[] textRangeArray2 = new TextRange[1];
                textRangeArray = textRangeArray2;
                textRangeArray2[0] = Objects.requireNonNull(this.myRefExpr).getTextRange();
            } else {
                textRangeArray = (TextRange[])ContainerUtil.map2Array(this.myAllRefs, (Object[])TextRange.EMPTY_ARRAY, PsiElement::getTextRange);
            }
            Presentation presentation2 = presentation.withHighlighting(textRangeArray);
            if (presentation2 == null) {
                InlineLocalStep.$$$reportNull$$$0(7);
            }
            return presentation2;
        }

        @NotNull
        public String getFamilyName() {
            String string = switch (this.myMode.ordinal()) {
                case 2 -> JavaRefactoringBundle.message((String)"inline.popup.highlight", (Object[])new Object[]{this.myAllRefs.size()});
                case 1 -> JavaRefactoringBundle.message((String)"inline.popup.ignore.conflicts", (Object[])new Object[0]);
                case 3 -> RefactoringBundle.message((String)"inline.popup.this.only");
                case 4 -> RefactoringBundle.message((String)"inline.popup.all", (Object[])new Object[]{this.myAllRefs.size()});
                case 5 -> RefactoringBundle.message((String)"inline.popup.all.keep.name", (Object[])new Object[]{Objects.requireNonNull(PsiUtil.skipParenthesizedExprDown((PsiExpression)this.myVariable.getInitializer())).getText()});
                case 6 -> RefactoringBundle.message((String)"inline.popup.all.keep.name", (Object[])new Object[]{this.myVariable.getName()});
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.myMode));
            };
            if (string == null) {
                InlineLocalStep.$$$reportNull$$$0(8);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allRefs";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/inline/InlineLocalHandler$InlineLocalStep";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/inline/InlineLocalHandler$InlineLocalStep";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 7, 8 -> new IllegalStateException(string);
            };
        }
    }

    private record InnerClassUsages(List<PsiElement> innerClassesWithUsages, List<PsiElement> innerClassUsages) {
        @NotNull
        private static InnerClassUsages getUsages(@NotNull PsiLocalVariable local, @NotNull List<PsiReferenceExpression> allRefs) {
            if (local == null) {
                InnerClassUsages.$$$reportNull$$$0(0);
            }
            if (allRefs == null) {
                InnerClassUsages.$$$reportNull$$$0(1);
            }
            ArrayList<PsiElement> innerClassesWithUsages = new ArrayList<PsiElement>();
            ArrayList<PsiElement> innerClassUsages = new ArrayList<PsiElement>();
            PsiElement containingClass = LambdaUtil.getContainingClassOrLambda((PsiElement)local);
            Iterator<PsiReferenceExpression> iterator = allRefs.iterator();
            block0: while (iterator.hasNext()) {
                PsiElement element;
                PsiElement innerClass = element = (PsiElement)iterator.next();
                while (innerClass != null) {
                    PsiElement parentPsiClass = LambdaUtil.getContainingClassOrLambda((PsiElement)innerClass.getParent());
                    if (parentPsiClass == containingClass) {
                        if (innerClass == element) continue block0;
                        innerClassesWithUsages.add(innerClass);
                        innerClassUsages.add(element);
                        continue block0;
                    }
                    innerClass = parentPsiClass;
                }
            }
            return new InnerClassUsages(innerClassesWithUsages, innerClassUsages);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "local";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "allRefs";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/inline/InlineLocalHandler$InnerClassUsages";
            objectArray[2] = "getUsages";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

