/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineMethodHandler;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.inline.InlineOptionsWithSearchSettingsDialog;

public class InlineMethodDialog
extends InlineOptionsWithSearchSettingsDialog {
    private final PsiReference myReference;
    private final Editor myEditor;
    private final boolean myAllowInlineThisOnly;
    private final PsiMethod myMethod;
    private final int myOccurrencesNumber;

    public InlineMethodDialog(Project project, PsiMethod method, PsiReference ref, Editor editor, boolean allowInlineThisOnly) {
        super(project, true, (PsiElement)method);
        this.myMethod = method;
        this.myReference = ref;
        this.myEditor = editor;
        this.myAllowInlineThisOnly = allowInlineThisOnly;
        this.myOccurrencesNumber = this.getNumberOfOccurrences((PsiNameIdentifierOwner)method);
        this.myInvokedOnReference = ref != null;
        this.setTitle(InlineMethodDialog.getRefactoringName());
        this.init();
    }

    protected boolean allowInlineAll() {
        return true;
    }

    protected String getNameLabelText() {
        int options2 = this.myReference != null ? 4353 : 257;
        String methodText = PsiFormatUtil.formatMethod((PsiMethod)this.myMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options2, (int)2);
        return this.myOccurrencesNumber > -1 ? JavaRefactoringBundle.message((String)"inline.method.method.occurrences", (Object[])new Object[]{methodText, this.myOccurrencesNumber}) : JavaRefactoringBundle.message((String)"inline.method.method.label", (Object[])new Object[]{methodText});
    }

    protected String getInlineThisText() {
        return JavaRefactoringBundle.message((String)"this.invocation.only.and.keep.the.method", (Object[])new Object[0]);
    }

    protected String getInlineAllText() {
        return JavaRefactoringBundle.message((String)(this.isLibraryInline() ? "all.invocations.in.project" : "all.invocations.and.remove.the.method"), (Object[])new Object[0]);
    }

    protected String getKeepTheDeclarationText() {
        if (!this.isLibraryInline()) {
            return JavaRefactoringBundle.message((String)"all.invocations.keep.the.method", (Object[])new Object[0]);
        }
        return super.getKeepTheDeclarationText();
    }

    private boolean isLibraryInline() {
        return this.myMethod.getOriginalElement() instanceof PsiCompiledElement;
    }

    protected void doAction() {
        super.doAction();
        this.invokeRefactoring(new InlineMethodProcessor(this.getProject(), this.myMethod, this.myReference, this.myEditor, this.isInlineThisOnly(), this.isSearchInCommentsAndStrings(), this.isSearchForTextOccurrences(), !this.isLibraryInline() && !this.isKeepTheDeclaration()));
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
            settings.INLINE_METHOD_THIS = this.isInlineThisOnly();
        }
        if (this.myKeepTheDeclaration != null && this.myKeepTheDeclaration.isEnabled()) {
            settings.INLINE_METHOD_KEEP = this.isKeepTheDeclaration();
        }
    }

    protected String getHelpId() {
        return this.myMethod.isConstructor() ? "refactoring.inlineConstructor" : "refactoring.inlineMethod";
    }

    protected boolean canInlineThisOnly() {
        return InlineMethodHandler.checkRecursive(this.myMethod) || this.myAllowInlineThisOnly;
    }

    protected boolean ignoreOccurrence(PsiReference reference) {
        return PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiImportStatementBase.class) == null;
    }

    protected boolean isInlineThis() {
        return JavaRefactoringSettings.getInstance().INLINE_METHOD_THIS;
    }

    protected boolean isKeepTheDeclarationByDefault() {
        return JavaRefactoringSettings.getInstance().INLINE_METHOD_KEEP;
    }

    protected boolean isSearchInCommentsAndStrings() {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD;
    }

    protected void saveSearchInCommentsAndStrings(boolean searchInComments) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD = searchInComments;
    }

    protected boolean isSearchForTextOccurrences() {
        return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_METHOD;
    }

    protected void saveSearchInTextOccurrences(boolean searchInTextOccurrences) {
        JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_METHOD = searchInTextOccurrences;
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"inline.method.title");
    }

    protected int getNumberOfOccurrences(PsiNameIdentifierOwner nameIdentifierOwner) {
        return InlineMethodDialog.getNumberOfOccurrences((PsiNameIdentifierOwner)nameIdentifierOwner, this::ignoreOccurrence, scope -> MethodReferencesSearch.search((PsiMethod)((PsiMethod)nameIdentifierOwner), (SearchScope)scope, (boolean)true));
    }
}

