/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineMethodDialog;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.inline.InlineMethodSpecialization;
import com.intellij.refactoring.inline.InlineObjectProcessor;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class InlineMethodHandler
extends JavaInlineActionHandler {
    private InlineMethodHandler() {
    }

    public boolean canInlineElement(PsiElement element) {
        return element instanceof PsiMethod && element.getNavigationElement() instanceof PsiMethod && element.getLanguage() == JavaLanguage.INSTANCE;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        InlineMethodHandler.performInline(project, editor, (PsiMethod)element.getNavigationElement(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performInline(Project project, Editor editor, PsiMethod method, boolean allowInlineThisOnly) {
        PsiElement referenceElement;
        boolean invokedOnReference;
        String errorMessage;
        PsiReference reference;
        PsiReference psiReference = reference = editor != null ? TargetElementUtil.findReference((Editor)editor, (int)editor.getCaretModel().getOffset()) : null;
        if (reference != null && reference.isReferenceTo((PsiElement)method) && method.hasModifierProperty("abstract") && InlineMethodHandler.tryInlineAbstractMethodImplementation(project, editor, method, reference)) {
            return;
        }
        PsiCodeBlock methodBody = method.getBody();
        Supplier<PsiCodeBlock> specialization = InlineMethodSpecialization.forReference(reference);
        if (specialization != null) {
            allowInlineThisOnly = true;
            methodBody = specialization.get();
        }
        if (methodBody == null) {
            String message = method.hasModifierProperty("abstract") ? JavaRefactoringBundle.message((String)"refactoring.cannot.be.applied.to.abstract.methods", (Object[])new Object[]{InlineMethodHandler.getRefactoringName()}) : (method.hasModifierProperty("native") ? JavaRefactoringBundle.message((String)"refactoring.cannot.be.applied.to.native.methods", (Object[])new Object[]{InlineMethodHandler.getRefactoringName()}) : JavaRefactoringBundle.message((String)"refactoring.cannot.be.applied.no.sources.attached", (Object[])new Object[]{InlineMethodHandler.getRefactoringName()}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)InlineMethodHandler.getRefactoringName(), (String)"refactoring.inlineMethod");
            return;
        }
        if (reference == null && InlineMethodHandler.checkRecursive(method)) {
            String message = RefactoringBundle.message((String)"refactoring.is.not.supported.for.recursive.methods", (Object[])new Object[]{InlineMethodHandler.getRefactoringName()});
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)InlineMethodHandler.getRefactoringName(), (String)"refactoring.inlineMethod");
            return;
        }
        if (reference != null && (errorMessage = InlineMethodProcessor.checkUnableToInsertCodeBlock(methodBody, reference.getElement())) != null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)errorMessage, (String)InlineMethodHandler.getRefactoringName(), (String)"refactoring.inlineMethod");
            return;
        }
        if (method.isConstructor()) {
            if (!InlineUtil.isChainingConstructor(method)) {
                InlineObjectProcessor processor = InlineObjectProcessor.create(reference, method);
                if (processor != null) {
                    if (Messages.showOkCancelDialog((String)JavaRefactoringBundle.message((String)"inline.method.object.suggestion.message", (Object[])new Object[0]), (String)JavaRefactoringBundle.message((String)"inline.method.object.action.name", (Object[])new Object[0]), (String)JavaRefactoringBundle.message((String)"inline.action.name", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon()) == 0) {
                        processor.setPrepareSuccessfulSwingThreadCallback(() -> {});
                        processor.run();
                    }
                    return;
                }
                if (!InlineMethodHandler.isThisReference(reference)) {
                    String message = JavaRefactoringBundle.message((String)"refactoring.cannot.be.applied.to.inline.non.chaining.constructors", (Object[])new Object[]{InlineMethodHandler.getRefactoringName()});
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)InlineMethodHandler.getRefactoringName(), (String)"refactoring.inlineConstructor");
                    return;
                }
                allowInlineThisOnly = true;
            }
            if (reference != null) {
                PsiCall constructorCall;
                PsiElement refElement = reference.getElement();
                if (refElement instanceof PsiJavaCodeReferenceElement) {
                    PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)refElement;
                    v1 = RefactoringUtil.getEnclosingConstructorCall(ref);
                } else {
                    v1 = constructorCall = null;
                }
                if (constructorCall == null || !method.equals((Object)constructorCall.resolveMethod())) {
                    reference = null;
                }
            }
        } else if (reference != null && !method.getManager().areElementsEquivalent((PsiElement)method, reference.resolve())) {
            reference = null;
        }
        if (reference != null && PsiTreeUtil.getParentOfType((PsiElement)reference.getElement(), PsiImportStaticStatement.class) != null) {
            reference = null;
        }
        boolean bl = invokedOnReference = reference != null;
        if (!invokedOnReference) {
            VirtualFile vFile = method.getContainingFile().getVirtualFile();
            ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Collections.singletonList(vFile));
        }
        if (reference != null && (referenceElement = reference.getElement()).getLanguage() == JavaLanguage.INSTANCE && !(referenceElement instanceof PsiJavaCodeReferenceElement)) {
            reference = null;
        }
        InlineMethodDialog dialog = new InlineMethodDialog(project, method, reference, editor, allowInlineThisOnly);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                dialog.doAction();
            }
            finally {
                dialog.close(0, true);
            }
        } else {
            dialog.show();
        }
    }

    private static boolean tryInlineAbstractMethodImplementation(@NotNull Project project, @NotNull Editor editor, @NotNull PsiMethod method, @NotNull PsiReference reference) {
        PsiMethod realMethod;
        if (project == null) {
            InlineMethodHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            InlineMethodHandler.$$$reportNull$$$0(1);
        }
        if (method == null) {
            InlineMethodHandler.$$$reportNull$$$0(2);
        }
        if (reference == null) {
            InlineMethodHandler.$$$reportNull$$$0(3);
        }
        if ((realMethod = (PsiMethod)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (PsiMethod)ReadAction.nonBlocking(() -> {
            Collection methods = OverridingMethodsSearch.search((PsiMethod)method).filtering(m -> !m.hasModifierProperty("abstract")).findAll();
            return (PsiMethod)ContainerUtil.getOnlyItem((Collection)methods);
        }).executeSynchronously(), JavaRefactoringBundle.message((String)"dialog.title.resolving.method.implementation", (Object[])new Object[0]), true, project)) == null || realMethod.getBody() == null) {
            return false;
        }
        String message = JavaRefactoringBundle.message((String)"dialog.message.confirmation.to.process.only.implementation", (Object[])new Object[]{PsiFormatUtil.formatMethod((PsiMethod)realMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4097, (int)0)});
        int answer = Messages.showYesNoDialog((Project)project, (String)message, (String)InlineMethodHandler.getRefactoringName(), (Icon)Messages.getQuestionIcon());
        if (answer == 1) {
            return true;
        }
        InlineMethodProcessor processor = new InlineMethodProcessor(project, realMethod, reference, editor, true, false, false, true);
        processor.setPrepareSuccessfulSwingThreadCallback(() -> {});
        processor.run();
        return true;
    }

    public static boolean checkRecursive(PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        return body != null && InlineMethodHandler.checkCalls((PsiElement)body, method);
    }

    private static boolean checkCalls(PsiElement scope, PsiMethod method) {
        PsiMethodReferenceExpression ref;
        PsiMethodCallExpression call;
        if (scope instanceof PsiMethodCallExpression && method.equals((Object)(call = (PsiMethodCallExpression)scope).getMethodExpression().resolve())) {
            return true;
        }
        if (scope instanceof PsiMethodReferenceExpression && method.equals((Object)(ref = (PsiMethodReferenceExpression)scope).resolve())) {
            return true;
        }
        for (PsiElement child = scope.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!InlineMethodHandler.checkCalls(child, method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isThisReference(PsiReference reference) {
        PsiJavaCodeReferenceElement codeRef;
        PsiElement psiElement;
        return reference != null && (psiElement = reference.getElement()) instanceof PsiJavaCodeReferenceElement && (codeRef = (PsiJavaCodeReferenceElement)psiElement).getParent() instanceof PsiMethodCallExpression && "this".equals(codeRef.getReferenceName());
    }

    @NotNull
    public String getActionName(PsiElement element) {
        String string = RefactoringBundle.message((String)"inline.method.action.name");
        if (string == null) {
            InlineMethodHandler.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NlsContexts.DialogTitle
    private static String getRefactoringName() {
        return RefactoringBundle.message((String)"inline.method.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/inline/InlineMethodHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/inline/InlineMethodHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryInlineAbstractMethodImplementation";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

