/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.Language;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalLoopStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ConditionalThrowToInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.EmptyInstruction;
import com.intellij.psi.controlFlow.GoToInstruction;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.controlFlow.ThrowToInstruction;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaLangClassMemberReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.OverrideMethodsProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.GenericInlineHandler;
import com.intellij.refactoring.inline.InlineMethodHelper;
import com.intellij.refactoring.inline.InlineMethodSpecialization;
import com.intellij.refactoring.inline.InlineTransformer;
import com.intellij.refactoring.inline.InlineViewDescriptor;
import com.intellij.refactoring.inline.ReferencedElementsCollector;
import com.intellij.refactoring.introduceParameter.Util;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.rename.NonCodeUsageInfoFactory;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.CodeBlockSurrounder;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.FieldAccessFixer;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineMethodProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(InlineMethodProcessor.class);
    private PsiMethod myMethod;
    private PsiReference myReference;
    private final Editor myEditor;
    private final boolean myInlineThisOnly;
    private final boolean mySearchInComments;
    private final boolean mySearchForTextOccurrences;
    private final boolean myDeleteTheDeclaration;
    private final Function<PsiReference, InlineTransformer> myTransformerChooser;
    private final PsiElementFactory myFactory;
    private final String myDescriptiveName;
    private List<CodeBlockSurrounder.SurroundResult> mySurroundResults;
    private PsiMethod myMethodCopy;
    private Map<Language, InlineHandler.Inliner> myInliners;
    private static final Key<PsiReferenceExpression> MARK_KEY = Key.create((String)"MarkForSurround");

    public InlineMethodProcessor(@NotNull Project project, @NotNull PsiMethod method, @Nullable PsiReference reference, Editor editor, boolean isInlineThisOnly) {
        if (project == null) {
            InlineMethodProcessor.$$$reportNull$$$0(0);
        }
        if (method == null) {
            InlineMethodProcessor.$$$reportNull$$$0(1);
        }
        this(project, method, reference, editor, isInlineThisOnly, false, false, true);
    }

    public InlineMethodProcessor(@NotNull Project project, @NotNull PsiMethod method, @Nullable PsiReference reference, Editor editor, boolean isInlineThisOnly, boolean searchInComments, boolean searchForTextOccurrences) {
        if (project == null) {
            InlineMethodProcessor.$$$reportNull$$$0(2);
        }
        if (method == null) {
            InlineMethodProcessor.$$$reportNull$$$0(3);
        }
        this(project, method, reference, editor, isInlineThisOnly, searchInComments, searchForTextOccurrences, true);
    }

    public InlineMethodProcessor(@NotNull Project project, @NotNull PsiMethod method, @Nullable PsiReference reference, Editor editor, boolean isInlineThisOnly, boolean searchInComments, boolean searchForTextOccurrences, boolean isDeleteTheDeclaration) {
        if (project == null) {
            InlineMethodProcessor.$$$reportNull$$$0(4);
        }
        if (method == null) {
            InlineMethodProcessor.$$$reportNull$$$0(5);
        }
        super(project);
        this.myMethod = InlineMethodSpecialization.specialize(method, reference);
        this.myTransformerChooser = InlineTransformer.getSuitableTransformer(this.myMethod);
        this.myReference = reference;
        this.myEditor = editor;
        this.myInlineThisOnly = isInlineThisOnly;
        this.mySearchInComments = searchInComments;
        this.mySearchForTextOccurrences = searchForTextOccurrences;
        this.myDeleteTheDeclaration = isDeleteTheDeclaration;
        this.myFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        this.myDescriptiveName = DescriptiveNameUtil.getDescriptiveName((PsiElement)this.myMethod);
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"inline.method.command", (Object[])new Object[]{this.myDescriptiveName});
        if (string == null) {
            InlineMethodProcessor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InlineMethodProcessor.$$$reportNull$$$0(7);
        }
        return new InlineViewDescriptor((PsiElement)this.myMethod);
    }

    protected UsageInfo @NotNull [] findUsages() {
        if (this.myInlineThisOnly) {
            UsageInfo[] usageInfoArray = new UsageInfo[]{new UsageInfo(this.myReference)};
            if (usageInfoArray == null) {
                InlineMethodProcessor.$$$reportNull$$$0(8);
            }
            return usageInfoArray;
        }
        Set usages = ConcurrentCollectionFactory.createConcurrentSet();
        if (this.myReference != null) {
            usages.add(new UsageInfo(this.myReference.getElement()));
        }
        for (PsiReference reference : MethodReferencesSearch.search((PsiMethod)this.myMethod, (SearchScope)this.myRefactoringScope, (boolean)true).asIterable()) {
            usages.add(new UsageInfo(reference.getElement()));
        }
        if (this.myDeleteTheDeclaration) {
            OverridingMethodsSearch.search((PsiMethod)this.myMethod, (SearchScope)this.myRefactoringScope, (boolean)true).forEach(method -> {
                if (this.shouldDeleteOverrideAttribute((PsiMethod)method)) {
                    usages.add(new OverrideAttributeUsageInfo((PsiElement)method));
                }
                return true;
            });
        }
        if (this.mySearchInComments || this.mySearchForTextOccurrences) {
            SearchScope searchScope;
            NonCodeUsageInfoFactory infoFactory = new NonCodeUsageInfoFactory((PsiElement)this.myMethod, this.myMethod.getName()){

                public UsageInfo createUsageInfo(@NotNull PsiElement usage, int startOffset, int endOffset) {
                    if (usage == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)InlineMethodProcessor.this.myMethod, (PsiElement)usage, (boolean)false)) {
                        return null;
                    }
                    return super.createUsageInfo(usage, startOffset, endOffset);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/refactoring/inline/InlineMethodProcessor$1", "createUsageInfo"));
                }
            };
            if (this.mySearchInComments) {
                String stringToSearch = ElementDescriptionUtil.getElementDescription((PsiElement)this.myMethod, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.STRINGS_AND_COMMENTS);
                TextOccurrencesUtil.addUsagesInStringsAndComments((PsiElement)this.myMethod, (SearchScope)this.myRefactoringScope, (String)stringToSearch, (Collection)usages, (UsageInfoFactory)infoFactory);
            }
            if (this.mySearchForTextOccurrences && (searchScope = this.myRefactoringScope) instanceof GlobalSearchScope) {
                GlobalSearchScope scope = (GlobalSearchScope)searchScope;
                String stringToSearch = ElementDescriptionUtil.getElementDescription((PsiElement)this.myMethod, (ElementDescriptionLocation)NonCodeSearchDescriptionLocation.NON_JAVA);
                TextOccurrencesUtil.addTextOccurrences((PsiElement)this.myMethod, (String)stringToSearch, (GlobalSearchScope)scope, (Collection)usages, (UsageInfoFactory)infoFactory);
            }
        }
        UsageInfo[] usageInfoArray = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            InlineMethodProcessor.$$$reportNull$$$0(9);
        }
        return usageInfoArray;
    }

    private boolean shouldDeleteOverrideAttribute(PsiMethod method) {
        return ContainerUtil.and((Iterable)method.getHierarchicalMethodSignature().getSuperSignatures(), signature -> {
            PsiMethod superMethod = signature.getMethod();
            if (superMethod == this.myMethod) {
                return true;
            }
            if (JavaLanguage.INSTANCE == method.getLanguage() && Objects.requireNonNull(superMethod.getContainingClass()).isInterface()) {
                return !PsiUtil.isAvailable((JavaFeature)JavaFeature.OVERRIDE_INTERFACE, (PsiElement)method);
            }
            return false;
        });
    }

    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InlineMethodProcessor.$$$reportNull$$$0(10);
        }
        for (UsageInfo usage : usages) {
            if (!(usage instanceof NonCodeUsageInfo)) continue;
            return true;
        }
        return super.isPreviewUsages(usages);
    }

    protected Set<UnloadedModuleDescription> computeUnloadedModulesFromUseScope(UsageViewDescriptor descriptor) {
        if (this.myInlineThisOnly) {
            return Collections.emptySet();
        }
        return super.computeUnloadedModulesFromUseScope(descriptor);
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            InlineMethodProcessor.$$$reportNull$$$0(11);
        }
        boolean condition = elements.length == 1 && elements[0] instanceof PsiMethod;
        LOG.assertTrue(condition);
        this.myMethod = (PsiMethod)elements[0];
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            InlineMethodProcessor.$$$reportNull$$$0(12);
        }
        if (!this.myInlineThisOnly && this.checkReadOnly() && !CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)this.myMethod)) {
            return false;
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        @NlsContexts.DialogMessage MultiMap conflicts = new MultiMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> {
            if (!this.myInlineThisOnly) {
                PsiMethod[] superMethods;
                for (PsiMethod psiMethod : superMethods = this.myMethod.findSuperMethods()) {
                    String className = Objects.requireNonNull(psiMethod.getContainingClass()).getQualifiedName();
                    String message = psiMethod.hasModifierProperty("abstract") ? JavaRefactoringBundle.message((String)"inlined.method.implements.method.from.0", (Object[])new Object[]{className}) : JavaRefactoringBundle.message((String)"inlined.method.overrides.method.from.0", (Object[])new Object[]{className});
                    conflicts.putValue((Object)psiMethod, (Object)message);
                }
                for (PsiMethod psiMethod : usagesIn) {
                    String errorMessage;
                    PsiMethodReferenceExpression ref;
                    PsiElement element = psiMethod.getElement();
                    if (element instanceof PsiDocMethodOrFieldRef && !PsiTreeUtil.isAncestor((PsiElement)this.myMethod, (PsiElement)element, (boolean)false)) {
                        conflicts.putValue((Object)element, (Object)JavaRefactoringBundle.message((String)"inline.method.used.in.javadoc", (Object[])new Object[0]));
                    }
                    if (element instanceof PsiLiteralExpression) {
                        if (ContainerUtil.or((Object[])element.getReferences(), JavaLangClassMemberReference.class::isInstance)) {
                            conflicts.putValue((Object)element, (Object)JavaRefactoringBundle.message((String)"inline.method.used.in.reflection", (Object[])new Object[0]));
                        }
                    }
                    if (element instanceof PsiMethodReferenceExpression) {
                        ref = (PsiMethodReferenceExpression)element;
                        InlineMethodProcessor.processSideEffectsInMethodReferenceQualifier((MultiMap<PsiElement, String>)conflicts, ref);
                    }
                    if (element instanceof PsiReferenceExpression && this.myTransformerChooser.apply((PsiReference)(ref = (PsiReferenceExpression)element)).isFallBackTransformer()) {
                        conflicts.putValue((Object)element, (Object)JavaRefactoringBundle.message((String)"inlined.method.will.be.transformed.to.single.return.form", (Object[])new Object[0]));
                    }
                    if ((errorMessage = InlineMethodProcessor.checkUnableToInsertCodeBlock(this.myMethod.getBody(), element)) == null) continue;
                    conflicts.putValue((Object)element, (Object)errorMessage);
                }
            } else if (this.myReference != null && this.myTransformerChooser.apply(this.myReference).isFallBackTransformer()) {
                conflicts.putValue((Object)this.myReference.getElement(), (Object)JavaRefactoringBundle.message((String)"inlined.method.will.be.transformed.to.single.return.form", (Object[])new Object[0]));
            } else {
                PsiReference patt0$temp = this.myReference;
                if (patt0$temp instanceof PsiMethodReferenceExpression) {
                    PsiMethodReferenceExpression ref = (PsiMethodReferenceExpression)patt0$temp;
                    InlineMethodProcessor.processSideEffectsInMethodReferenceQualifier((MultiMap<PsiElement, String>)conflicts, ref);
                }
            }
            InlineMethodProcessor.addInaccessibleMemberConflicts(this.myMethod, usagesIn, new ReferencedElementsCollector(), (MultiMap<PsiElement, String>)conflicts);
            this.addInaccessibleSuperCallsConflicts(usagesIn, (MultiMap<PsiElement, String>)conflicts);
        }), RefactoringBundle.message((String)"detecting.possible.conflicts"), true, this.myProject)) {
            return false;
        }
        this.myInliners = GenericInlineHandler.initInliners((PsiElement)this.myMethod, (UsageInfo[])usagesIn, (InlineHandler.Settings)new InlineHandler.Settings(){

            public boolean isOnlyOneReferenceToInline() {
                return InlineMethodProcessor.this.myInlineThisOnly;
            }
        }, (MultiMap)conflicts, (Language[])new Language[]{JavaLanguage.INSTANCE});
        return this.showConflicts(conflicts, usagesIn);
    }

    private static void processSideEffectsInMethodReferenceQualifier(@NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts, @NotNull PsiMethodReferenceExpression methodReferenceExpression) {
        PsiExpression qualifierExpression;
        if (conflicts == null) {
            InlineMethodProcessor.$$$reportNull$$$0(13);
        }
        if (methodReferenceExpression == null) {
            InlineMethodProcessor.$$$reportNull$$$0(14);
        }
        if ((qualifierExpression = methodReferenceExpression.getQualifierExpression()) != null) {
            ArrayList sideEffects = new ArrayList();
            SideEffectChecker.checkSideEffects((PsiExpression)qualifierExpression, sideEffects);
            if (!sideEffects.isEmpty()) {
                conflicts.putValue((Object)methodReferenceExpression, (Object)JavaRefactoringBundle.message((String)"inline.method.qualifier.usage.side.effect", (Object[])new Object[0]));
            }
        }
    }

    private boolean checkReadOnly() {
        return this.myMethod.isWritable() || this.myMethod instanceof PsiCompiledElement;
    }

    private void addInaccessibleSuperCallsConflicts(final UsageInfo[] usagesIn, final MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        this.myMethod.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(this){

            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    3.$$$reportNull$$$0(0);
                }
            }

            public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
                if (aClass == null) {
                    3.$$$reportNull$$$0(1);
                }
            }

            public void visitSuperExpression(@NotNull PsiSuperExpression expression) {
                if (expression == null) {
                    3.$$$reportNull$$$0(2);
                }
                super.visitSuperExpression(expression);
                PsiType type = expression.getType();
                PsiClass superClass = PsiUtil.resolveClassInType((PsiType)type);
                if (superClass != null) {
                    HashSet<PsiClass> targetContainingClasses = new HashSet<PsiClass>();
                    PsiExpression qualifiedCall = null;
                    for (UsageInfo info : usagesIn) {
                        PsiReferenceExpression ref;
                        PsiElement element = info.getElement();
                        if (element == null) continue;
                        PsiClass targetContainingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
                        if (!(targetContainingClass == null || InheritanceUtil.isInheritorOrSelf((PsiClass)targetContainingClass, (PsiClass)superClass, (boolean)true) && PsiUtil.getEnclosingStaticElement((PsiElement)element, (PsiClass)targetContainingClass) == null)) {
                            targetContainingClasses.add(targetContainingClass);
                            continue;
                        }
                        if (!(element instanceof PsiReferenceExpression) || ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)(ref = (PsiReferenceExpression)element))) continue;
                        qualifiedCall = ref.getQualifierExpression();
                    }
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethodCallExpression.class);
                    LOG.assertTrue(methodCallExpression != null);
                    if (!targetContainingClasses.isEmpty()) {
                        String names = StringUtil.join(targetContainingClasses, psiClass -> RefactoringUIUtil.getDescription((PsiElement)psiClass, (boolean)false), (String)",");
                        String message = JavaRefactoringBundle.message((String)"inline.method.calls.not.accessible.in", (Object[])new Object[]{methodCallExpression.getText(), names});
                        conflicts.putValue((Object)expression, (Object)message);
                    }
                    if (qualifiedCall != null) {
                        conflicts.putValue((Object)expression, (Object)JavaRefactoringBundle.message((String)"inline.method.calls.not.accessible.on.qualifier", (Object[])new Object[]{methodCallExpression.getText(), qualifiedCall.getText()}));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/refactoring/inline/InlineMethodProcessor$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAnonymousClass";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitSuperExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static void addInaccessibleMemberConflicts(PsiMethod method, UsageInfo[] usages, ReferencedElementsCollector collector, MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        PsiCodeBlock body = Objects.requireNonNull(method.getBody());
        body.accept((PsiElementVisitor)collector);
        Map<PsiMember, Set<PsiMember>> locationsToInaccessibles = InlineMethodProcessor.getInaccessible(collector.myReferencedMembers, usages, (PsiElement)method);
        String methodDescription = RefactoringUIUtil.getDescription((PsiElement)method, (boolean)true);
        locationsToInaccessibles.forEach((container, inaccessibles) -> {
            for (PsiMember inaccessible : inaccessibles) {
                String referencedDescription = RefactoringUIUtil.getDescription((PsiElement)inaccessible, (boolean)true);
                String containerDescription = RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true);
                String message = RefactoringBundle.message((String)"0.which.is.used.in.1.not.accessible.from.call.site.s.in.2", (Object[])new Object[]{referencedDescription, methodDescription, containerDescription});
                conflicts.putValue((Object)(usages.length == 1 ? inaccessible : container), (Object)StringUtil.capitalize((String)message));
            }
        });
    }

    static Map<PsiMember, Set<PsiMember>> getInaccessible(HashSet<? extends PsiMember> referencedElements, UsageInfo[] usages, PsiElement elementToInline) {
        HashMap<PsiMember, Set<PsiMember>> result = new HashMap<PsiMember, Set<PsiMember>>();
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)elementToInline.getProject()).getResolveHelper();
        for (UsageInfo usage : usages) {
            PsiMember memberContainer;
            HashSet<PsiMember> inaccessibleReferenced;
            PsiElement container;
            PsiElement usageElement = usage.getElement();
            if (usageElement == null || !((container = ConflictsUtil.getContainer(usageElement)) instanceof PsiMember) || (inaccessibleReferenced = (HashSet<PsiMember>)result.get(memberContainer = (PsiMember)container)) != null) continue;
            inaccessibleReferenced = new HashSet<PsiMember>();
            result.put(memberContainer, inaccessibleReferenced);
            for (PsiMember psiMember : referencedElements) {
                PsiElement resolveScope;
                PsiClass c;
                if (PsiTreeUtil.isAncestor((PsiElement)elementToInline, (PsiElement)psiMember, (boolean)false) || elementToInline instanceof PsiClass && InheritanceUtil.isInheritorOrSelf((PsiClass)(c = (PsiClass)elementToInline), (PsiClass)psiMember.getContainingClass(), (boolean)true)) continue;
                if (usageElement instanceof PsiReferenceExpression) {
                    PsiReferenceExpression ref = (PsiReferenceExpression)usageElement;
                    v0 = ref.advancedResolve(false).getCurrentFileResolveScope();
                } else {
                    v0 = resolveScope = null;
                }
                if (resolveHelper.isAccessible(psiMember, psiMember.getModifierList(), usageElement, null, resolveScope)) continue;
                inaccessibleReferenced.add(psiMember);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InlineMethodProcessor.$$$reportNull$$$0(15);
        }
        RangeMarker position = null;
        if (this.myEditor != null) {
            int offset = this.myEditor.getCaretModel().getOffset();
            position = this.myEditor.getDocument().createRangeMarker(offset, offset + 1);
        }
        LocalHistoryAction a = LocalHistory.getInstance().startAction(this.getCommandName());
        try {
            this.doRefactoring(usages);
        }
        finally {
            a.finish();
        }
        if (position != null) {
            if (position.isValid()) {
                this.myEditor.getCaretModel().moveToOffset(position.getStartOffset());
            }
            position.dispose();
        }
    }

    protected String getRefactoringId() {
        return "refactoring.inline.method";
    }

    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        if (this.myDeleteTheDeclaration) {
            data.addElement((PsiElement)this.myMethod);
        }
        return data;
    }

    private void doRefactoring(UsageInfo[] usages) {
        try {
            if (this.myInlineThisOnly) {
                if (JavaLanguage.INSTANCE != this.myReference.getElement().getLanguage()) {
                    GenericInlineHandler.inlineReference((UsageInfo)new UsageInfo(this.myReference.getElement()), (PsiElement)this.myMethod, this.myInliners);
                } else if (this.myMethod.isConstructor() && InlineUtil.isChainingConstructor(this.myMethod)) {
                    PsiReference psiReference = this.myReference;
                    if (psiReference instanceof PsiMethodReferenceExpression) {
                        ref = (PsiMethodReferenceExpression)psiReference;
                        this.inlineMethodReference(ref);
                    } else {
                        PsiCall constructorCall = RefactoringUtil.getEnclosingConstructorCall((PsiJavaCodeReferenceElement)this.myReference);
                        if (constructorCall != null) {
                            InlineMethodProcessor.inlineConstructorCall(constructorCall);
                        }
                    }
                } else {
                    this.myReference = this.surroundWithCodeBlock(new PsiReferenceExpression[]{(PsiReferenceExpression)this.myReference})[0];
                    PsiReference constructorCall = this.myReference;
                    if (constructorCall instanceof PsiMethodReferenceExpression) {
                        ref = (PsiMethodReferenceExpression)constructorCall;
                        this.inlineMethodReference(ref);
                    } else {
                        this.inlineMethodCall((PsiReferenceExpression)this.myReference);
                    }
                }
            } else {
                CommonRefactoringUtil.sortDepthFirstRightLeftOrder((UsageInfo[])usages);
                if (this.myMethod.isConstructor()) {
                    for (PsiMethodReferenceExpression usage : usages) {
                        PsiElement element = usage.getElement();
                        if (element instanceof PsiMethodReferenceExpression) {
                            PsiMethodReferenceExpression ref = (PsiMethodReferenceExpression)element;
                            this.inlineMethodReference(ref);
                            continue;
                        }
                        if (element instanceof PsiJavaCodeReferenceElement) {
                            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = (PsiJavaCodeReferenceElement)element;
                            PsiCall constructorCall = RefactoringUtil.getEnclosingConstructorCall(psiJavaCodeReferenceElement);
                            if (constructorCall == null) continue;
                            InlineMethodProcessor.inlineConstructorCall(constructorCall);
                            continue;
                        }
                        if (element instanceof PsiEnumConstant) {
                            constant = (PsiEnumConstant)element;
                            InlineMethodProcessor.inlineConstructorCall((PsiCall)constant);
                            continue;
                        }
                        if (element instanceof PsiDocMethodOrFieldRef) continue;
                        GenericInlineHandler.inlineReference((UsageInfo)usage, (PsiElement)this.myMethod, this.myInliners);
                    }
                } else {
                    ArrayList<PsiReferenceExpression> refExprList = new ArrayList<PsiReferenceExpression>();
                    ArrayList<PsiElement> imports2Delete = new ArrayList<PsiElement>();
                    for (PsiMethodReferenceExpression usage : usages) {
                        PsiElement psiElement = usage.getElement();
                        if (psiElement == null) continue;
                        if (usage instanceof OverrideAttributeUsageInfo) {
                            OverrideMethodsProcessor processor;
                            constant = OverrideMethodsProcessor.EP_NAME.getExtensionList().iterator();
                            while (constant.hasNext() && !(processor = (OverrideMethodsProcessor)constant.next()).removeOverrideAttribute(psiElement)) {
                            }
                            continue;
                        }
                        if (psiElement instanceof PsiReferenceExpression) {
                            PsiReferenceExpression ref = (PsiReferenceExpression)psiElement;
                            refExprList.add(ref);
                            continue;
                        }
                        if (psiElement instanceof PsiImportStaticReferenceElement) {
                            PsiImportStaticReferenceElement ref = (PsiImportStaticReferenceElement)psiElement;
                            JavaResolveResult[] resolveResults = ref.multiResolve(false);
                            if (resolveResults.length >= 2) continue;
                            imports2Delete.add(PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiImportStaticStatement.class));
                            continue;
                        }
                        if (JavaLanguage.INSTANCE == psiElement.getLanguage()) continue;
                        GenericInlineHandler.inlineReference((UsageInfo)usage, (PsiElement)this.myMethod, this.myInliners);
                    }
                    PsiReferenceExpression[] refs = refExprList.toArray(new PsiReferenceExpression[0]);
                    refs = this.surroundWithCodeBlock(refs);
                    for (PsiReferenceExpression psiReferenceExpression : refs) {
                        if (psiReferenceExpression instanceof PsiMethodReferenceExpression) {
                            PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)psiReferenceExpression;
                            this.inlineMethodReference(methodRef);
                            continue;
                        }
                        this.inlineMethodCall(psiReferenceExpression);
                    }
                    for (PsiElement psiElement : imports2Delete) {
                        if (psiElement == null || !psiElement.isValid()) continue;
                        psiElement.delete();
                    }
                }
                if (this.myMethod.isValid() && this.myMethod.isWritable() && this.myDeleteTheDeclaration) {
                    CommentTracker tracker = new CommentTracker();
                    tracker.markUnchanged((PsiElement)this.myMethod.getBody());
                    tracker.markUnchanged((PsiElement)this.myMethod.getDocComment());
                    tracker.deleteAndRestoreComments((PsiElement)this.myMethod);
                }
            }
            if (this.mySurroundResults != null) {
                for (CodeBlockSurrounder.SurroundResult result : this.mySurroundResults) {
                    result.collapse();
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void inlineMethodReference(PsiMethodReferenceExpression reference) {
        PsiLambdaExpression lambdaExpression = LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)reference, (boolean)false, (boolean)false);
        if (lambdaExpression == null) {
            return;
        }
        PsiExpression callExpression = LambdaUtil.extractSingleExpressionFromBody((PsiElement)lambdaExpression.getBody());
        if (callExpression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)callExpression;
            this.inlineMethodCall(call.getMethodExpression());
        } else if (callExpression instanceof PsiCall) {
            PsiCall call = (PsiCall)callExpression;
            InlineMethodProcessor.inlineConstructorCall(call);
        } else {
            LOG.error("Unexpected expr: " + callExpression.getText());
        }
        LambdaRefactoringUtil.simplifyToExpressionLambda((PsiLambdaExpression)lambdaExpression);
    }

    public static void inlineConstructorCall(PsiCall constructorCall) {
        PsiMethod oldConstructor = constructorCall.resolveMethod();
        LOG.assertTrue(oldConstructor != null);
        oldConstructor = (PsiMethod)oldConstructor.getNavigationElement();
        PsiExpression[] arguments = CommonJavaRefactoringUtil.getNonVarargArguments((PsiCall)constructorCall);
        PsiStatement[] statements = oldConstructor.getBody().getStatements();
        LOG.assertTrue(statements.length == 1 && statements[0] instanceof PsiExpressionStatement);
        PsiExpression expression = ((PsiExpressionStatement)statements[0]).getExpression();
        LOG.assertTrue(expression instanceof PsiMethodCallExpression);
        ChangeContextUtil.encodeContextInfo((PsiElement)expression, (boolean)true);
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression.copy();
        for (PsiExpression arg : methodCall.getArgumentList().getExpressions()) {
            InlineMethodProcessor.replaceParameterReferences((PsiElement)arg, oldConstructor, arguments);
        }
        try {
            PsiExpressionList exprList = (PsiExpressionList)constructorCall.getArgumentList().replace((PsiElement)methodCall.getArgumentList());
            ChangeContextUtil.decodeContextInfo((PsiElement)exprList, (PsiClass)((PsiClass)PsiTreeUtil.getParentOfType((PsiElement)constructorCall, PsiClass.class)), null);
            if (!exprList.isEmpty()) {
                PsiExpression[] expressions = exprList.getExpressions();
                CommonJavaRefactoringUtil.tryToInlineArrayCreationForVarargs((PsiExpression)expressions[expressions.length - 1]);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        ChangeContextUtil.clearContextInfo((PsiElement)expression);
    }

    private static void replaceParameterReferences(final PsiElement element, final PsiMethod oldConstructor, final PsiExpression[] instanceCreationArguments) {
        final LinkedHashMap replacement2 = new LinkedHashMap();
        element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    4.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(expression);
                PsiElement resolved = expression.resolve();
                if (resolved instanceof PsiParameter) {
                    int parameterIndex;
                    PsiParameter param = (PsiParameter)resolved;
                    if (element.getManager().areElementsEquivalent(param.getDeclarationScope(), (PsiElement)oldConstructor) && (parameterIndex = oldConstructor.getParameterList().getParameterIndex(param)) >= 0) {
                        replacement2.put(expression, instanceCreationArguments[parameterIndex]);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/inline/InlineMethodProcessor$4", "visitReferenceExpression"));
            }
        });
        for (Map.Entry entry : replacement2.entrySet()) {
            try {
                ((PsiReferenceExpression)entry.getKey()).replace((PsiElement)entry.getValue());
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void inlineMethodCall(PsiReferenceExpression ref) {
        this.myMethodCopy = (PsiMethod)this.myMethod.copy();
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)ref.getParent();
        InlineMethodHelper helper = new InlineMethodHelper(this.myProject, this.myMethod, this.myMethodCopy, (PsiCallExpression)methodCall);
        BlockData blockData = this.prepareBlock(ref, helper);
        PsiCodeBlock block = blockData.block;
        InlineMethodProcessor.replaceWithAccessors(ref, block);
        ChangeContextUtil.encodeContextInfo((PsiElement)block, (boolean)false);
        helper.substituteTypes(blockData.parmVars);
        InlineUtil.solveLocalNameConflicts((PsiElement)block, (PsiElement)ref, (PsiElement)this.myMethodCopy.getBody());
        helper.initializeParameters(blockData.parmVars);
        this.addThisInitializer(methodCall, blockData.thisVar);
        PsiElement anchor = CommonJavaRefactoringUtil.getParentStatement((PsiElement)methodCall, (boolean)true);
        if (anchor == null) {
            throw new IllegalStateException("Cannot inline: parent statement should be available after CodeBlockSurround");
        }
        PsiElement anchorParent = anchor.getParent();
        PsiLocalVariable thisVar = null;
        PsiLocalVariable[] parmVars = new PsiLocalVariable[blockData.parmVars.length];
        PsiLocalVariable resultVar = null;
        PsiStatement[] statements = block.getStatements();
        PsiElement firstBodyElement = block.getFirstBodyElement();
        if (firstBodyElement instanceof PsiWhiteSpace) {
            firstBodyElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)firstBodyElement);
        }
        PsiElement firstAdded = null;
        if (firstBodyElement != null && firstBodyElement != block.getRBrace()) {
            int last = statements.length - 1;
            PsiElement rBraceOrReturnStatement = last >= 0 ? PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statements[last]) : block.getLastBodyElement();
            LOG.assertTrue(rBraceOrReturnStatement != null);
            PsiElement beforeRBraceStatement = rBraceOrReturnStatement.getPrevSibling();
            LOG.assertTrue(beforeRBraceStatement != null);
            firstAdded = anchorParent.addRangeBefore(firstBodyElement, beforeRBraceStatement, anchor);
            JavaCodeStyleManager style = JavaCodeStyleManager.getInstance((Project)this.myProject);
            block0: for (PsiElement e = firstAdded; e != anchor; e = e.getNextSibling()) {
                PsiDeclarationStatement declaration;
                Object object;
                style.shortenClassReferences(e);
                if (!(e instanceof PsiDeclarationStatement) || !((object = ArrayUtil.getFirstElement((Object[])(declaration = (PsiDeclarationStatement)e).getDeclaredElements())) instanceof PsiLocalVariable)) continue;
                PsiLocalVariable var = (PsiLocalVariable)object;
                String name = var.getName();
                if (blockData.resultVar != null && name.equals(blockData.resultVar.getName())) {
                    resultVar = var;
                    continue;
                }
                if (blockData.thisVar != null && name.equals(blockData.thisVar.getName())) {
                    thisVar = var;
                    continue;
                }
                for (int i = 0; i < blockData.parmVars.length; ++i) {
                    if (!name.equals(blockData.parmVars[i].getName())) continue;
                    parmVars[i] = var;
                    continue block0;
                }
            }
        }
        PsiClass thisClass = this.myMethod.getContainingClass();
        PsiExpression thisAccessExpr = thisVar != null ? (!InlineUtil.canInlineParameterOrThisVariable(thisVar) ? this.myFactory.createExpressionFromText(thisVar.getName(), null) : thisVar.getInitializer()) : null;
        ChangeContextUtil.decodeContextInfo((PsiElement)anchorParent, (PsiClass)thisClass, (PsiExpression)thisAccessExpr);
        PsiReferenceExpression resultUsage = InlineMethodProcessor.replaceCall(this.myFactory, methodCall, firstAdded, blockData.resultVar);
        if (thisVar != null) {
            InlineUtil.tryInlineGeneratedLocal(thisVar, false);
        }
        helper.inlineParameters(parmVars);
        if (resultVar != null && resultUsage != null) {
            InlineUtil.tryInlineResultVariable(resultVar, resultUsage);
        }
        ChangeContextUtil.clearContextInfo((PsiElement)anchorParent);
    }

    private static void replaceWithAccessors(PsiReferenceExpression ref, PsiCodeBlock block) {
        List list = SyntaxTraverser.psiTraverser((PsiElement)block).filter(PsiReferenceExpression.class).toList();
        for (PsiReferenceExpression r : list.reversed()) {
            FieldAccessFixer fixer;
            if (!r.isValid() || (fixer = FieldAccessFixer.create((PsiReferenceExpression)r, (PsiElement)r.resolve(), (PsiElement)ref)) == null || fixer.kind() == FieldAccessFixer.AccessorKind.NAME_BASED) continue;
            fixer.apply(r);
        }
    }

    @Nullable
    static PsiReferenceExpression replaceCall(@NotNull PsiElementFactory factory, @NotNull PsiMethodCallExpression methodCall, @Nullable PsiElement firstAdded, @Nullable PsiLocalVariable resultVar) {
        if (factory == null) {
            InlineMethodProcessor.$$$reportNull$$$0(16);
        }
        if (methodCall == null) {
            InlineMethodProcessor.$$$reportNull$$$0(17);
        }
        if (resultVar != null) {
            PsiExpression expr = factory.createExpressionFromText(resultVar.getName(), null);
            return (PsiReferenceExpression)new CommentTracker().replaceAndRestoreComments((PsiElement)methodCall, (PsiElement)expr);
        }
        CommentTracker tracker = new CommentTracker();
        PsiElement anchor = CommonJavaRefactoringUtil.getParentStatement((PsiElement)methodCall, (boolean)true);
        assert (anchor != null);
        if (anchor instanceof PsiReturnStatement) {
            PsiReturnStatement newReturn;
            PsiReturnStatement oldReturn = (PsiReturnStatement)anchor;
            PsiElement psiElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)anchor);
            if (psiElement instanceof PsiReturnStatement && (newReturn = (PsiReturnStatement)psiElement).getReturnValue() != null) {
                tracker.replace((PsiElement)Objects.requireNonNull(oldReturn.getReturnValue()), (PsiElement)newReturn.getReturnValue());
                anchor = newReturn;
            }
        }
        if (firstAdded != null) {
            tracker.delete(anchor);
            tracker.insertCommentsBefore(firstAdded);
        } else {
            tracker.deleteAndRestoreComments(anchor);
        }
        return null;
    }

    private void substituteMethodTypeParams(PsiElement scope, PsiSubstitutor substitutor) {
        InlineUtil.substituteTypeParams(scope, substitutor, this.myFactory);
    }

    private boolean syncNeeded(PsiReferenceExpression ref) {
        PsiClass targetContainingClass;
        if (!this.myMethod.hasModifierProperty("synchronized")) {
            return false;
        }
        PsiMethod containingMethod = Util.getContainingMethod((PsiElement)ref);
        if (containingMethod == null) {
            return true;
        }
        if (!containingMethod.hasModifierProperty("synchronized")) {
            return true;
        }
        PsiClass sourceContainingClass = this.myMethod.getContainingClass();
        return !sourceContainingClass.equals((Object)(targetContainingClass = containingMethod.getContainingClass()));
    }

    private BlockData prepareBlock(PsiReferenceExpression ref, InlineMethodHelper helper) {
        PsiCodeBlock block = Objects.requireNonNull(this.myMethodCopy.getBody());
        PsiSubstitutor callSubstitutor = helper.getSubstitutor();
        if (callSubstitutor != PsiSubstitutor.EMPTY) {
            this.substituteMethodTypeParams((PsiElement)block, callSubstitutor);
        }
        PsiStatement[] originalStatements = block.getStatements();
        PsiType returnType = callSubstitutor.substitute(this.myMethod.getReturnType());
        InlineTransformer transformer = this.myTransformerChooser.apply((PsiReference)ref);
        PsiLocalVariable[] parmVars = helper.declareParameters();
        PsiLocalVariable thisVar = this.declareThis(callSubstitutor, block);
        this.addSynchronization(ref, block, originalStatements, thisVar);
        PsiLocalVariable resultVar = transformer.transformBody(this.myMethodCopy, (PsiReference)ref, returnType);
        return new BlockData(block, thisVar, parmVars, resultVar);
    }

    @Nullable
    private PsiLocalVariable declareThis(PsiSubstitutor callSubstitutor, PsiCodeBlock block) {
        PsiClass containingClass = this.myMethod.getContainingClass();
        if (this.myMethod.hasModifierProperty("static") || containingClass == null || containingClass instanceof PsiImplicitClass) {
            return null;
        }
        PsiType thisType = GenericsUtil.getVariableTypeByExpressionType((PsiType)this.myFactory.createType(containingClass, callSubstitutor));
        String thisVarName = new VariableNameGenerator(this.myMethod.getFirstChild(), VariableKind.LOCAL_VARIABLE).byType(thisType).byName(new String[]{"self"}).generate(true);
        PsiExpression initializer = this.myFactory.createExpressionFromText("null", null);
        PsiDeclarationStatement declaration = this.myFactory.createVariableDeclarationStatement(thisVarName, thisType, initializer);
        declaration = (PsiDeclarationStatement)block.addAfter((PsiElement)declaration, null);
        return (PsiLocalVariable)declaration.getDeclaredElements()[0];
    }

    private void addSynchronization(PsiReferenceExpression ref, PsiCodeBlock block, PsiStatement[] originalStatements, PsiLocalVariable thisVar) {
        PsiClass containingClass = this.myMethod.getContainingClass();
        Object lockName = null;
        if (thisVar != null) {
            lockName = thisVar.getName();
        } else if (this.myMethod.hasModifierProperty("static") && containingClass != null) {
            lockName = containingClass.getQualifiedName() + ".class";
        }
        if (lockName != null && this.syncNeeded(ref)) {
            PsiSynchronizedStatement synchronizedStatement = (PsiSynchronizedStatement)this.myFactory.createStatementFromText("synchronized(" + (String)lockName + "){}", (PsiElement)block);
            synchronizedStatement = (PsiSynchronizedStatement)CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)synchronizedStatement);
            synchronizedStatement = (PsiSynchronizedStatement)block.add((PsiElement)synchronizedStatement);
            PsiCodeBlock synchronizedBody = Objects.requireNonNull(synchronizedStatement.getBody());
            for (PsiStatement originalStatement : originalStatements) {
                synchronizedBody.add((PsiElement)originalStatement);
                originalStatement.delete();
            }
        }
    }

    private void addThisInitializer(PsiMethodCallExpression methodCall, PsiLocalVariable thisVar) {
        if (thisVar != null) {
            PsiExpression qualifier = methodCall.getMethodExpression().getQualifierExpression();
            if (qualifier == null) {
                PsiElement parent = methodCall.getContext();
                while (!(parent instanceof PsiClass) && !(parent instanceof PsiFile)) {
                    assert (parent != null) : methodCall;
                    parent = parent.getContext();
                }
                if (parent instanceof PsiClass) {
                    PsiClass parentClass = (PsiClass)parent;
                    PsiClass containingClass = this.myMethod.getContainingClass();
                    if (containingClass != null && parentClass.isInheritor(containingClass, true)) {
                        String name = parentClass.getName();
                        qualifier = this.myFactory.createExpressionFromText((String)(name == null ? "this" : name + ".this"), null);
                    } else if (containingClass != null && parentClass.equals((Object)containingClass)) {
                        qualifier = this.myFactory.createExpressionFromText("this", null);
                    } else if (PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)parent, (boolean)false)) {
                        String name = containingClass.getName();
                        qualifier = name != null ? this.myFactory.createExpressionFromText(name + ".this", null) : this.myFactory.createExpressionFromText("this", null);
                    } else {
                        do {
                            if (!InheritanceUtil.isInheritorOrSelf((PsiClass)(parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parentClass, PsiClass.class, (boolean)true)), (PsiClass)containingClass, (boolean)true)) continue;
                            String childClassName = parentClass.getName();
                            qualifier = this.myFactory.createExpressionFromText((String)(childClassName != null ? childClassName + ".this" : "this"), null);
                            break;
                        } while (parentClass != null);
                    }
                } else {
                    qualifier = this.myFactory.createExpressionFromText("this", null);
                }
            } else if (qualifier instanceof PsiSuperExpression) {
                qualifier = this.myFactory.createExpressionFromText("this", null);
            } else if (qualifier.getType() != null && !thisVar.getType().isAssignableFrom(qualifier.getType())) {
                PsiTypeCastExpression cast = (PsiTypeCastExpression)this.myFactory.createExpressionFromText("(A)b", null);
                Objects.requireNonNull(cast.getOperand()).replace((PsiElement)qualifier);
                Objects.requireNonNull(cast.getCastType()).replace((PsiElement)this.myFactory.createTypeElement(thisVar.getType()));
                qualifier = cast;
            }
            Objects.requireNonNull(thisVar.getInitializer()).replace((PsiElement)qualifier);
        }
    }

    private PsiReferenceExpression[] surroundWithCodeBlock(PsiReferenceExpression[] refs) {
        this.mySurroundResults = new ArrayList<CodeBlockSurrounder.SurroundResult>();
        for (PsiReferenceExpression ref2 : refs) {
            if (ref2 instanceof PsiMethodReferenceExpression) continue;
            ref2.putCopyableUserData(MARK_KEY, (Object)ref2);
        }
        PsiRecursiveElementWalkingVisitor visitor2 = new PsiRecursiveElementWalkingVisitor(this){
            final Map<PsiReferenceExpression, PsiReferenceExpression> mapping = new HashMap<PsiReferenceExpression, PsiReferenceExpression>();

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (element instanceof PsiReferenceExpression) {
                    PsiReferenceExpression ref = (PsiReferenceExpression)element;
                    PsiReferenceExpression orig = (PsiReferenceExpression)element.getCopyableUserData(MARK_KEY);
                    if (orig != null) {
                        this.mapping.put(orig, ref);
                    }
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/inline/InlineMethodProcessor$5", "visitElement"));
            }
        };
        for (PsiReferenceExpression ref3 : refs) {
            CodeBlockSurrounder surrounder;
            if (!ref3.isValid() || ref3 instanceof PsiMethodReferenceExpression || (surrounder = CodeBlockSurrounder.forExpression((PsiExpression)ref3)) == null) continue;
            CodeBlockSurrounder.SurroundResult surround = surrounder.surround();
            surround.getAnchor().accept((PsiElementVisitor)visitor2);
            this.mySurroundResults.add(surround);
        }
        return (PsiReferenceExpression[])((StreamEx)StreamEx.of((Object[])refs).map(arg_0 -> InlineMethodProcessor.lambda$surroundWithCodeBlock$5(visitor2, arg_0)).peek(ref -> ref.putCopyableUserData(MARK_KEY, null))).toArray((Object[])new PsiReferenceExpression[0]);
    }

    @NlsContexts.DialogMessage
    public static String checkUnableToInsertCodeBlock(PsiCodeBlock methodBody, PsiElement element) {
        if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.STATEMENTS_BEFORE_SUPER, (PsiElement)element) && InlineMethodProcessor.checkUnableToInsertCodeBlock(methodBody, element, expr -> JavaPsiConstructorUtil.isConstructorCall((PsiElement)expr) && expr.getMethodExpression() != element)) {
            return JavaRefactoringBundle.message((String)"inline.method.multiline.method.in.ctor.call", (Object[])new Object[0]);
        }
        Predicate<PsiMethodCallExpression> errorCondition = call -> {
            PsiConditionalLoopStatement loopStatement = (PsiConditionalLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)call, PsiConditionalLoopStatement.class);
            return loopStatement != null && PsiTreeUtil.isAncestor((PsiElement)loopStatement.getCondition(), (PsiElement)call, (boolean)false);
        };
        return InlineMethodProcessor.checkUnableToInsertCodeBlock(methodBody, element, errorCondition) ? JavaRefactoringBundle.message((String)"inline.method.multiline.method.in.loop.condition", (Object[])new Object[0]) : null;
    }

    private static boolean checkUnableToInsertCodeBlock(PsiCodeBlock methodBody, PsiElement element, Predicate<? super PsiMethodCallExpression> errorCondition) {
        PsiStatement[] statements = methodBody.getStatements();
        if (statements.length > 1 || statements.length == 1 && !(statements[0] instanceof PsiExpressionStatement) && !(statements[0] instanceof PsiReturnStatement)) {
            PsiMethodCallExpression expr = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class, (boolean)true, (Class[])new Class[]{PsiStatement.class});
            while (expr != null) {
                if (errorCondition.test((PsiMethodCallExpression)expr)) {
                    return true;
                }
                expr = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiMethodCallExpression.class, (boolean)true, (Class[])new Class[]{PsiStatement.class});
            }
        }
        return false;
    }

    public static boolean checkBadReturns(PsiMethod method) {
        PsiReturnStatement[] returns = PsiUtil.findReturnStatements((PsiMethod)method);
        PsiCodeBlock body = method.getBody();
        return InlineMethodProcessor.checkBadReturns(returns, body);
    }

    public static boolean checkBadReturns(PsiReturnStatement[] returns, PsiCodeBlock body) {
        int offset;
        ControlFlow controlFlow;
        if (returns.length == 0) {
            return false;
        }
        try {
            controlFlow = ControlFlowFactory.getInstance((Project)body.getProject()).getControlFlow((PsiElement)body, (ControlFlowPolicy)new LocalsControlFlowPolicy((PsiElement)body), false);
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Control flow:");
            LOG.debug(controlFlow.toString());
        }
        ArrayList<EmptyInstruction> instructions = new ArrayList<EmptyInstruction>(controlFlow.getInstructions());
        for (PsiReturnStatement aReturn : returns) {
            int endOffset = controlFlow.getEndOffset((PsiElement)aReturn);
            for (offset = controlFlow.getStartOffset((PsiElement)aReturn); offset <= endOffset && !(instructions.get(offset) instanceof GoToInstruction); ++offset) {
            }
            LOG.assertTrue(instructions.get(offset) instanceof GoToInstruction);
            instructions.set(offset, EmptyInstruction.INSTANCE);
        }
        for (PsiReturnStatement aReturn : returns) {
            offset = controlFlow.getEndOffset((PsiElement)aReturn);
            while (offset != instructions.size()) {
                Instruction instruction = (Instruction)instructions.get(offset);
                if (instruction instanceof GoToInstruction) {
                    GoToInstruction g = (GoToInstruction)instruction;
                    offset = g.offset;
                    continue;
                }
                if (instruction instanceof ThrowToInstruction) {
                    ThrowToInstruction t = (ThrowToInstruction)instruction;
                    offset = t.offset;
                    continue;
                }
                if (instruction instanceof ConditionalThrowToInstruction) {
                    ++offset;
                    continue;
                }
                return true;
            }
        }
        return false;
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            InlineMethodProcessor.$$$reportNull$$$0(18);
        }
        if (this.myInlineThisOnly) {
            List<PsiElement> list = Collections.singletonList(this.myReference.getElement());
            if (list == null) {
                InlineMethodProcessor.$$$reportNull$$$0(19);
            }
            return list;
        }
        if (!this.checkReadOnly()) {
            List list = Collections.emptyList();
            if (list == null) {
                InlineMethodProcessor.$$$reportNull$$$0(20);
            }
            return list;
        }
        List<Object> list = this.myReference == null ? Collections.singletonList(this.myMethod) : Arrays.asList(this.myReference.getElement(), this.myMethod);
        if (list == null) {
            InlineMethodProcessor.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static /* synthetic */ PsiReferenceExpression lambda$surroundWithCodeBlock$5(5 visitor2, PsiReferenceExpression ref) {
        return visitor2.mapping.getOrDefault(ref, ref);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9, 19, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/inline/InlineMethodProcessor";
                break;
            }
            case 7: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReferenceExpression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/inline/InlineMethodProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processSideEffectsInMethodReferenceQualifier";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replaceCall";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9, 19, 20, 21 -> new IllegalStateException(string);
        };
    }

    private static class OverrideAttributeUsageInfo
    extends UsageInfo {
        private OverrideAttributeUsageInfo(@NotNull PsiElement element) {
            if (element == null) {
                OverrideAttributeUsageInfo.$$$reportNull$$$0(0);
            }
            super(element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/inline/InlineMethodProcessor$OverrideAttributeUsageInfo", "<init>"));
        }
    }

    private record BlockData(PsiCodeBlock block, PsiLocalVariable thisVar, PsiLocalVariable[] parmVars, PsiLocalVariable resultVar) {
    }
}

