/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.java.JavaBundle;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.util.ImportsUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.inline.JavaInlineActionHandler;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class InlineStaticImportHandler
extends JavaInlineActionHandler {
    public static final String REFACTORING_ID = "refactoring.inline.import";

    public boolean canInlineElement(PsiElement element) {
        if (element.getContainingFile() == null) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class) != null;
    }

    public void inlineElement(Project project, Editor editor, PsiElement element) {
        PsiImportStaticStatement staticStatement = (PsiImportStaticStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class);
        List referenceElements = ImportsUtil.collectReferencesThrough((PsiFile)element.getContainingFile(), null, (PsiImportStaticStatement)staticStatement);
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(element);
        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(REFACTORING_ID, data);
        WriteCommandAction.writeCommandAction((Project)project).withName(JavaBundle.message((String)"action.expand.static.import.text", (Object[])new Object[0])).run(() -> ImportsUtil.replaceAllAndDeleteImport((List)referenceElements, null, (PsiImportStaticStatement)staticStatement));
        ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(REFACTORING_ID, null);
    }

    @Nullable
    public String getActionName(PsiElement element) {
        return JavaBundle.message((String)"action.expand.static.import.text", (Object[])new Object[0]);
    }
}

