/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import com.intellij.refactoring.inlineSuperClass.InlineSuperClassRefactoringProcessor;
import com.intellij.refactoring.ui.DocCommentPanel;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineSuperClassRefactoringDialog
extends InlineOptionsDialog {
    private final PsiClass mySuperClass;
    private final PsiClass myCurrentInheritor;
    private final DocCommentPanel myDocPanel;

    protected InlineSuperClassRefactoringDialog(@NotNull Project project, PsiClass superClass, PsiClass currentInheritor) {
        if (project == null) {
            InlineSuperClassRefactoringDialog.$$$reportNull$$$0(0);
        }
        super(project, false, (PsiElement)superClass);
        this.mySuperClass = superClass;
        this.myCurrentInheritor = currentInheritor;
        this.myInvokedOnReference = currentInheritor != null;
        this.myDocPanel = new DocCommentPanel(JavaRefactoringBundle.message((String)"inline.super.doc.panel.title", (Object[])new Object[0]));
        this.myDocPanel.setPolicy(JavaRefactoringSettings.getInstance().PULL_UP_MEMBERS_JAVADOC);
        this.init();
        this.setTitle(JavaRefactoringBundle.message((String)"inline.super.class", (Object[])new Object[0]));
    }

    protected void doAction() {
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        if (this.myRbInlineThisOnly.isEnabled() && this.myRbInlineAll.isEnabled()) {
            settings.INLINE_SUPER_CLASS_THIS = this.isInlineThisOnly();
        }
        this.invokeRefactoring((BaseRefactoringProcessor)new InlineSuperClassRefactoringProcessor(this.getProject(), this.isInlineThisOnly() ? this.myCurrentInheritor : null, this.mySuperClass, this.myDocPanel.getPolicy()));
    }

    protected JComponent createNorthPanel() {
        return null;
    }

    @Nullable
    protected String getHelpId() {
        return "Inline_Super_Class";
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBInsets.emptyInsets(), 0, 0);
        panel.add((Component)super.createCenterPanel(), gc);
        panel.add((Component)this.myDocPanel, gc);
        if (this.mySuperClass.getDocComment() == null) {
            boolean hasJavadoc = InlineSuperClassRefactoringProcessor.getClassMembersToPush(this.mySuperClass).stream().anyMatch(memberInfo -> {
                PsiMember member = (PsiMember)memberInfo.getMember();
                return member instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)member).getDocComment() != null;
            });
            this.myDocPanel.setVisible(hasJavadoc);
        }
        gc.weighty = 1.0;
        gc.fill = 1;
        panel.add(Box.createVerticalGlue(), gc);
        JPanel jPanel = panel;
        if (jPanel == null) {
            InlineSuperClassRefactoringDialog.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    protected String getNameLabelText() {
        return JavaRefactoringBundle.message((String)"inline.super.class.label", (Object[])new Object[]{this.mySuperClass.getQualifiedName()});
    }

    protected String getBorderTitle() {
        return JavaRefactoringBundle.message((String)"inline.action.name", (Object[])new Object[0]);
    }

    protected String getInlineAllText() {
        return JavaRefactoringBundle.message((String)"all.references.and.remove.super.class", (Object[])new Object[0]);
    }

    protected String getInlineThisText() {
        return JavaRefactoringBundle.message((String)"this.reference.only.and.keep.super.class", (Object[])new Object[0]);
    }

    protected boolean isInlineThis() {
        return JavaRefactoringSettings.getInstance().INLINE_SUPER_CLASS_THIS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/inlineSuperClass/InlineSuperClassRefactoringDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/inlineSuperClass/InlineSuperClassRefactoringDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

