/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiQualifiedReferenceElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.inlineSuperClass.InlineSuperClassUsageViewDescriptor;
import com.intellij.refactoring.inlineSuperClass.usageInfo.CopyDefaultConstructorUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.InlineSuperCallUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.RemoveImportUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.RemovePermitsListUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.RemoveQualifierUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.ReplaceConstructorUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.ReplaceExtendsListUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.ReplaceReferenceUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.ReplaceStaticImportUsageInfo;
import com.intellij.refactoring.inlineSuperClass.usageInfo.ReplaceWithSubtypeUsageInfo;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.memberPushDown.PushDownConflicts;
import com.intellij.refactoring.memberPushDown.PushDownProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.refactoring.util.FixableUsagesRefactoringProcessor;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.MemberInfoStorage;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineSuperClassRefactoringProcessor
extends FixableUsagesRefactoringProcessor {
    public static final Logger LOG = Logger.getInstance(InlineSuperClassRefactoringProcessor.class);
    private final PsiClass myCurrentInheritor;
    private final PsiClass mySuperClass;
    private final int myPolicy;
    private PsiClass[] myTargetClasses;
    private final MemberInfo[] myMemberInfos;

    public InlineSuperClassRefactoringProcessor(Project project, PsiClass currentInheritor, PsiClass superClass, int policy) {
        super(project);
        this.myCurrentInheritor = currentInheritor;
        this.mySuperClass = superClass;
        this.myPolicy = policy;
        List<MemberInfo> members = InlineSuperClassRefactoringProcessor.getClassMembersToPush(this.mySuperClass);
        for (MemberInfo member : members) {
            member.setChecked(true);
        }
        this.myMemberInfos = members.toArray(new MemberInfo[0]);
    }

    public static List<MemberInfo> getClassMembersToPush(final PsiClass superClass) {
        MemberInfoStorage memberInfoStorage = new MemberInfoStorage(superClass, new MemberInfoBase.Filter<PsiMember>(){

            public boolean includeMember(PsiMember element) {
                return !(element instanceof PsiClass) || PsiTreeUtil.isAncestor((PsiElement)superClass, (PsiElement)element, (boolean)true);
            }
        });
        return memberInfoStorage.getClassMemberInfos((PsiElement)superClass);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InlineSuperClassRefactoringProcessor.$$$reportNull$$$0(0);
        }
        return new InlineSuperClassUsageViewDescriptor(this.mySuperClass);
    }

    protected void findUsages(@NotNull List<? super FixableUsageInfo> usages) {
        if (usages == null) {
            InlineSuperClassRefactoringProcessor.$$$reportNull$$$0(1);
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myProject);
        PsiElementFactory elementFactory = facade.getElementFactory();
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        if (this.myCurrentInheritor != null) {
            this.myTargetClasses = new PsiClass[]{this.myCurrentInheritor};
        } else {
            Collection inheritors = DirectClassInheritorsSearch.search((PsiClass)this.mySuperClass).findAll();
            this.myTargetClasses = inheritors.toArray(PsiClass.EMPTY_ARRAY);
        }
        if (this.myCurrentInheritor != null) {
            this.findUsagesInExtendsList(usages, this.myCurrentInheritor.getExtendsList());
            this.findUsagesInExtendsList(usages, this.myCurrentInheritor.getImplementsList());
        } else {
            ReferencesSearch.search((PsiElement)this.mySuperClass).forEach(reference -> {
                PsiElement element = reference.getElement();
                if (element instanceof PsiJavaCodeReferenceElement) {
                    PsiJavaCodeReferenceElement classRef = (PsiJavaCodeReferenceElement)element;
                    PsiImportStaticStatement staticImportStatement = (PsiImportStaticStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class);
                    if (staticImportStatement != null) {
                        usages.add(new ReplaceStaticImportUsageInfo(staticImportStatement, this.myTargetClasses));
                    } else {
                        PsiImportStatement importStatement = (PsiImportStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStatement.class);
                        if (importStatement != null) {
                            usages.add(new RemoveImportUsageInfo(importStatement));
                        } else {
                            PsiElement parent = element.getParent();
                            if (parent instanceof PsiReferenceList) {
                                PsiElement pparent = parent.getParent();
                                if (pparent instanceof PsiClass) {
                                    PsiClass inheritor = (PsiClass)pparent;
                                    if (parent.equals((Object)inheritor.getExtendsList()) || parent.equals((Object)inheritor.getImplementsList())) {
                                        usages.add(new ReplaceExtendsListUsageInfo(classRef, this.mySuperClass, inheritor));
                                    } else if (parent.equals((Object)inheritor.getPermitsList())) {
                                        usages.add(new RemovePermitsListUsageInfo(classRef, this.mySuperClass, inheritor));
                                    }
                                }
                            } else {
                                PsiClass targetClass = this.myTargetClasses[0];
                                PsiClassType targetClassType = elementFactory.createType(targetClass, TypeConversionUtil.getSuperClassSubstitutor((PsiClass)this.mySuperClass, (PsiClass)targetClass, (PsiSubstitutor)PsiSubstitutor.EMPTY));
                                if (parent instanceof PsiTypeElement) {
                                    PsiTypeElement typeElement = (PsiTypeElement)parent;
                                    PsiType superClassType = typeElement.getType();
                                    PsiSubstitutor subst = InlineSuperClassRefactoringProcessor.getSuperClassSubstitutor(superClassType, targetClassType, resolveHelper, targetClass);
                                    usages.add(new ReplaceWithSubtypeUsageInfo(typeElement, elementFactory.createType(targetClass, subst), this.myTargetClasses));
                                } else if (parent instanceof PsiNewExpression) {
                                    PsiNewExpression newExpression = (PsiNewExpression)parent;
                                    PsiClassType newType = elementFactory.createType(targetClass, InlineSuperClassRefactoringProcessor.getSuperClassSubstitutor(newExpression.getType(), targetClassType, resolveHelper, targetClass));
                                    usages.add(new ReplaceConstructorUsageInfo(newExpression, (PsiType)newType, this.myTargetClasses));
                                } else if (parent instanceof PsiJavaCodeReferenceElement) {
                                    PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)parent;
                                    usages.add(new ReplaceReferenceUsageInfo(ref.getQualifier(), this.myTargetClasses));
                                }
                            }
                        }
                    }
                }
                return true;
            });
        }
        block0: for (PsiClass targetClass : this.myTargetClasses) {
            if (this.skipTargetClass(targetClass)) continue;
            for (MemberInfo memberInfo : this.myMemberInfos) {
                PsiMember member = (PsiMember)memberInfo.getMember();
                for (PsiReference reference2 : ReferencesSearch.search((PsiElement)member, (SearchScope)member.getUseScope(), (boolean)true).asIterable()) {
                    PsiElement element = reference2.getElement();
                    if (!(element instanceof PsiReferenceExpression) || !(((PsiReferenceExpression)element).getQualifierExpression() instanceof PsiSuperExpression) || !PsiTreeUtil.isAncestor((PsiElement)targetClass, (PsiElement)element, (boolean)false) || PushDownConflicts.isSuperCallToBeInlined(member, targetClass, this.mySuperClass)) continue;
                    usages.add(new RemoveQualifierUsageInfo((PsiReferenceExpression)element));
                }
            }
            if (this.mySuperClass.isInterface()) continue;
            PsiMethod[] superConstructors = this.mySuperClass.getConstructors();
            HashSet addedSuperConstructors = new HashSet();
            for (PsiMethod constructor : targetClass.getConstructors()) {
                PsiMethod superConstructor;
                PsiCodeBlock constrBody = constructor.getBody();
                PsiMethodCallExpression call = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)constructor);
                if (JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)call) && (superConstructor = call.resolveMethod()) != null && superConstructor.getBody() != null) {
                    usages.add(new InlineSuperCallUsageInfo(call));
                    InlineSuperClassRefactoringProcessor.processChainedCallsInSuper(superConstructor, targetClass, usages, addedSuperConstructors);
                    continue;
                }
                for (PsiMethod superConstructor2 : superConstructors) {
                    if (!superConstructor2.getParameterList().isEmpty()) continue;
                    PsiExpression expression = JavaPsiFacade.getElementFactory((Project)this.myProject).createExpressionFromText("super()", (PsiElement)constructor);
                    usages.add(new InlineSuperCallUsageInfo((PsiMethodCallExpression)expression, constrBody));
                    InlineSuperClassRefactoringProcessor.processChainedCallsInSuper(superConstructor2, targetClass, usages, addedSuperConstructors);
                }
            }
            if (targetClass.getConstructors().length != 0) continue;
            for (PsiMethod superConstructor : superConstructors) {
                if (!superConstructor.getParameterList().isEmpty()) continue;
                usages.add(new CopyDefaultConstructorUsageInfo(targetClass, superConstructor));
                continue block0;
            }
        }
    }

    private static void processChainedCallsInSuper(PsiMethod superConstructorWithChain, PsiClass targetClass, List<? super FixableUsageInfo> usages, Set<? super PsiMethod> addedSuperConstructors) {
        addedSuperConstructors.add((PsiMethod)superConstructorWithChain);
        PsiMethod chainedConstructor = CommonJavaRefactoringUtil.getChainedConstructor((PsiMethod)superConstructorWithChain);
        while (chainedConstructor != null && addedSuperConstructors.add((PsiMethod)chainedConstructor)) {
            usages.add(new CopyDefaultConstructorUsageInfo(targetClass, chainedConstructor));
            chainedConstructor = CommonJavaRefactoringUtil.getChainedConstructor((PsiMethod)chainedConstructor);
        }
    }

    private void findUsagesInExtendsList(@NotNull List<? super FixableUsageInfo> usages, PsiReferenceList extendsList) {
        PsiJavaCodeReferenceElement[] referenceExtendsElements;
        if (usages == null) {
            InlineSuperClassRefactoringProcessor.$$$reportNull$$$0(2);
        }
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = referenceExtendsElements = extendsList != null ? extendsList.getReferenceElements() : null;
        if (referenceExtendsElements != null) {
            for (PsiJavaCodeReferenceElement element : referenceExtendsElements) {
                if (!this.mySuperClass.equals((Object)element.resolve())) continue;
                usages.add(new ReplaceExtendsListUsageInfo(element, this.mySuperClass, this.myCurrentInheritor));
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            InlineSuperClassRefactoringProcessor.$$$reportNull$$$0(3);
        }
        @NlsContexts.DialogMessage MultiMap conflicts = new MultiMap();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> this.collectConflicts((MultiMap<PsiElement, String>)conflicts)), RefactoringBundle.message((String)"detecting.possible.conflicts"), true, this.myProject)) {
            return false;
        }
        InlineSuperClassRefactoringProcessor.checkConflicts(refUsages, (MultiMap)conflicts);
        return this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
    }

    private void collectConflicts(MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        PushDownConflicts pushDownConflicts = new PushDownConflicts(this.mySuperClass, this.myMemberInfos, conflicts);
        for (PsiClass targetClass : this.myTargetClasses) {
            if (targetClass instanceof PsiAnonymousClass) {
                conflicts.putValue((Object)targetClass, (Object)JavaRefactoringBundle.message((String)"inline.super.no.anonymous.class", (Object[])new Object[0]));
                continue;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)this.mySuperClass, (PsiElement)targetClass, (boolean)false)) {
                conflicts.putValue((Object)targetClass, (Object)JavaRefactoringBundle.message((String)"inline.super.no.inner.class", (Object[])new Object[]{targetClass.getName()}));
                continue;
            }
            if (!targetClass.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
                conflicts.putValue((Object)targetClass, (Object)JavaRefactoringBundle.message((String)"inline.superclass.foreign.language.conflict.message", (Object[])new Object[]{targetClass.getLanguage().getDisplayName()}));
                continue;
            }
            for (MemberInfo info : this.myMemberInfos) {
                PsiMember member = (PsiMember)info.getMember();
                pushDownConflicts.checkMemberPlacementInTargetClassConflict(targetClass, member);
                if (this.myCurrentInheritor != null) continue;
                HashSet<PsiMember> movedMembers = new HashSet<PsiMember>(pushDownConflicts.getMovedMembers());
                movedMembers.addAll(Arrays.asList(this.mySuperClass.getConstructors()));
                RefactoringConflictsUtil.getInstance().analyzeAccessibilityConflictsAfterMemberMove(movedMembers, targetClass, null, (PsiElement)targetClass, pushDownConflicts.getAbstractMembers(), Conditions.alwaysTrue(), conflicts);
            }
        }
        if (this.myCurrentInheritor != null) {
            ReferencesSearch.search((PsiElement)this.myCurrentInheritor).forEach(reference -> {
                PsiClass aClass;
                PsiElement element = reference.getElement();
                PsiElement parent = element.getParent();
                if (parent instanceof PsiNewExpression && (aClass = PsiUtil.resolveClassInType((PsiType)InlineSuperClassRefactoringProcessor.getPlaceExpectedType(parent))) == this.mySuperClass) {
                    conflicts.putValue((Object)parent, (Object)JavaRefactoringBundle.message((String)"inline.super.target.instead.of.super.class", (Object[])new Object[0]));
                    return false;
                }
                return true;
            });
        }
    }

    private boolean skipTargetClass(PsiClass targetClass) {
        return targetClass instanceof PsiAnonymousClass || PsiTreeUtil.isAncestor((PsiElement)this.mySuperClass, (PsiElement)targetClass, (boolean)false);
    }

    @Nullable
    private static PsiType getPlaceExpectedType(PsiElement parent) {
        PsiElement arg;
        PsiElement gParent;
        PsiType type = PsiTypesUtil.getExpectedTypeByParent((PsiElement)parent);
        if (type == null && (gParent = (arg = PsiUtil.skipParenthesizedExprUp((PsiElement)parent)).getParent()) instanceof PsiExpressionList) {
            PsiMethod method;
            int i = ArrayUtilRt.find((Object[])((PsiExpressionList)gParent).getExpressions(), (Object)arg);
            PsiElement pParent = gParent.getParent();
            if (pParent instanceof PsiCallExpression && (method = ((PsiCallExpression)pParent).resolveMethod()) != null) {
                PsiParameter[] parameters = method.getParameterList().getParameters();
                if (i >= parameters.length) {
                    if (method.isVarArgs()) {
                        return ((PsiEllipsisType)parameters[parameters.length - 1].getType()).getComponentType();
                    }
                } else {
                    return parameters[i].getType();
                }
            }
        }
        return type;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InlineSuperClassRefactoringProcessor.$$$reportNull$$$0(4);
        }
        try {
            UsageInfo[] infos = (UsageInfo[])ContainerUtil.map2Array((Object[])this.myTargetClasses, UsageInfo.class, UsageInfo::new);
            new PushDownProcessor((PsiElement)this.mySuperClass, Arrays.asList(this.myMemberInfos), new DocCommentPolicy(this.myPolicy), this.myCurrentInheritor != null).pushDownToClasses(infos);
            CommonRefactoringUtil.sortDepthFirstRightLeftOrder((UsageInfo[])usages);
            for (UsageInfo usageInfo : usages) {
                if (usageInfo instanceof ReplaceExtendsListUsageInfo || usageInfo instanceof RemoveImportUsageInfo) continue;
                try {
                    ((FixableUsageInfo)usageInfo).fixUsage();
                }
                catch (IncorrectOperationException e) {
                    LOG.info((Throwable)e);
                }
            }
            this.replaceInnerTypeUsages();
            for (UsageInfo usage : usages) {
                if (!(usage instanceof ReplaceExtendsListUsageInfo) && !(usage instanceof RemoveImportUsageInfo)) continue;
                ((FixableUsageInfo)usage).fixUsage();
            }
            if (this.myCurrentInheritor == null) {
                this.mySuperClass.delete();
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)this.mySuperClass);
        data.addElements((PsiElement[])this.myTargetClasses);
        return data;
    }

    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            InlineSuperClassRefactoringProcessor.$$$reportNull$$$0(5);
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElements((PsiElement[])this.myTargetClasses);
        return data;
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.inline.class";
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            InlineSuperClassRefactoringProcessor.$$$reportNull$$$0(6);
        }
        Collection<Object> collection = this.myCurrentInheritor != null ? Collections.emptyList() : super.getElementsToWrite(descriptor);
        if (collection == null) {
            InlineSuperClassRefactoringProcessor.$$$reportNull$$$0(7);
        }
        return collection;
    }

    private void replaceInnerTypeUsages() {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myProject);
        final PsiElementFactory elementFactory = facade.getElementFactory();
        final PsiResolveHelper resolveHelper = facade.getResolveHelper();
        final HashMap replacementMap = new HashMap();
        for (final PsiClass targetClass : this.myTargetClasses) {
            if (this.skipTargetClass(targetClass)) continue;
            PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)this.mySuperClass, (PsiClass)targetClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            final PsiClassType targetClassType = elementFactory.createType(targetClass, superClassSubstitutor);
            targetClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitTypeElement(@NotNull PsiTypeElement typeElement) {
                    if (typeElement == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    super.visitTypeElement(typeElement);
                    PsiType superClassType = typeElement.getType();
                    if (PsiUtil.resolveClassInClassTypeOnly((PsiType)superClassType) == InlineSuperClassRefactoringProcessor.this.mySuperClass) {
                        PsiSubstitutor subst = InlineSuperClassRefactoringProcessor.getSuperClassSubstitutor(superClassType, targetClassType, resolveHelper, targetClass);
                        replacementMap.put(new UsageInfo((PsiElement)typeElement), elementFactory.createTypeElement((PsiType)elementFactory.createType(targetClass, subst)));
                    }
                }

                public void visitNewExpression(@NotNull PsiNewExpression expression) {
                    if (expression == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    super.visitNewExpression(expression);
                    PsiType superClassType = expression.getType();
                    if (PsiUtil.resolveClassInType((PsiType)superClassType) == InlineSuperClassRefactoringProcessor.this.mySuperClass) {
                        PsiSubstitutor subst = InlineSuperClassRefactoringProcessor.getSuperClassSubstitutor(superClassType, targetClassType, resolveHelper, targetClass);
                        try {
                            String typeCanonicalText = elementFactory.createType(targetClass, subst).getCanonicalText();
                            PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
                            if (classReference != null) {
                                replacementMap.put(new UsageInfo((PsiQualifiedReferenceElement)classReference), elementFactory.createReferenceFromText(typeCanonicalText, (PsiElement)expression));
                            }
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }

                public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
                    if (reference == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    super.visitReferenceElement(reference);
                    if (reference.resolve() == InlineSuperClassRefactoringProcessor.this.mySuperClass && PsiTreeUtil.getParentOfType((PsiElement)reference, PsiComment.class) != null) {
                        replacementMap.put(new UsageInfo((PsiQualifiedReferenceElement)reference), elementFactory.createClassReferenceElement(targetClass));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "typeElement";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "reference";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/refactoring/inlineSuperClass/InlineSuperClassRefactoringProcessor$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitTypeElement";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitNewExpression";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitReferenceElement";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        try {
            for (Map.Entry entry : replacementMap.entrySet()) {
                PsiElement element = ((UsageInfo)entry.getKey()).getElement();
                if (element == null) continue;
                element.replace((PsiElement)entry.getValue());
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static PsiSubstitutor getSuperClassSubstitutor(PsiType superClassType, PsiClassType targetClassType, PsiResolveHelper resolveHelper, PsiClass targetClass) {
        PsiSubstitutor subst = PsiSubstitutor.EMPTY;
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)targetClass)) {
            subst = subst.put(typeParameter, resolveHelper.getSubstitutionForTypeParameter(typeParameter, (PsiType)targetClassType, superClassType, false, PsiUtil.getLanguageLevel((PsiElement)targetClass)));
        }
        return subst;
    }

    @NotNull
    protected String getCommandName() {
        String string = JavaRefactoringBundle.message((String)"inline.super.class", (Object[])new Object[0]);
        if (string == null) {
            InlineSuperClassRefactoringProcessor.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/inlineSuperClass/InlineSuperClassRefactoringProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/inlineSuperClass/InlineSuperClassRefactoringProcessor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findUsagesInExtendsList";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

