/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass.usageInfo;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;

public class ReplaceWithSubtypeUsageInfo
extends FixableUsageInfo {
    public static final Logger LOG = Logger.getInstance(ReplaceWithSubtypeUsageInfo.class);
    private final PsiTypeElement myTypeElement;
    private final PsiClassType myTargetClassType;
    private final PsiType myOriginalType;
    @Nls
    private String myConflict;

    public ReplaceWithSubtypeUsageInfo(PsiTypeElement typeElement, PsiClassType classType, PsiClass[] targetClasses) {
        super((PsiElement)typeElement);
        this.myTypeElement = typeElement;
        this.myTargetClassType = classType;
        this.myOriginalType = this.myTypeElement.getType();
        if (targetClasses.length > 1) {
            this.myConflict = JavaRefactoringBundle.message((String)"inline.super.type.element.can.be.replaced", (Object[])new Object[]{typeElement.getText(), StringUtil.join((Object[])targetClasses, psiClass -> psiClass.getQualifiedName(), (String)", ")});
        }
    }

    public void fixUsage() throws IncorrectOperationException {
        if (this.myTypeElement.isValid()) {
            Project project = this.myTypeElement.getProject();
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            PsiElement replaced = this.myTypeElement.replace((PsiElement)elementFactory.createTypeElement((PsiType)this.myTargetClassType));
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(replaced);
        }
    }

    public String getConflictMessage() {
        if (!TypeConversionUtil.isAssignable((PsiType)this.myOriginalType, (PsiType)this.myTargetClassType)) {
            String conflict = JavaRefactoringBundle.message((String)"inline.super.no.substitution", (Object[])new Object[]{this.getElement().getText(), this.myOriginalType.getPresentableText(), this.myTargetClassType.getPresentableText()});
            this.myConflict = this.myConflict == null ? conflict : this.myConflict + "\n" + conflict;
        }
        return this.myConflict;
    }
}

