/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInsight.daemon.impl.quickfix.AnonymousTargetClassPreselectionUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.navigation.PsiTargetNavigator;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.PackageUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceHandlerBase;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceField.InplaceIntroduceConstantPopup;
import com.intellij.refactoring.introduceField.IntroduceConstantHandler;
import com.intellij.refactoring.introduceField.IntroduceFieldHandler;
import com.intellij.refactoring.introduceField.LocalToFieldHandler;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.rename.RenameJavaMemberProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.EnumConstantsUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.classMembers.ClassMemberReferencesVisitor;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseExpressionToFieldHandler
extends IntroduceHandlerBase {
    private static final Logger LOG = Logger.getInstance(BaseExpressionToFieldHandler.class);
    private final boolean myIsConstant;
    @Nullable
    private PsiClass myParentClass;

    protected BaseExpressionToFieldHandler(boolean isConstant) {
        this.myIsConstant = isConstant;
    }

    @Override
    protected boolean invokeImpl(final Project project, final @NotNull PsiExpression selectedExpr, final Editor editor) {
        AbstractInplaceIntroducer activeIntroducer;
        boolean shouldSuggestDialog;
        PsiType tempType;
        PsiElement element;
        PsiFile file;
        if (selectedExpr == null) {
            BaseExpressionToFieldHandler.$$$reportNull$$$0(0);
        }
        LOG.assertTrue((file = (element = BaseExpressionToFieldHandler.getPhysicalElement(selectedExpr)).getContainingFile()) != null, (Object)"expr.getContainingFile() == null");
        if (LOG.isDebugEnabled()) {
            LOG.debug("expression:" + String.valueOf(selectedExpr));
        }
        if ((tempType = BaseExpressionToFieldHandler.getTypeByExpression(selectedExpr)) == null || LambdaUtil.notInferredType((PsiType)tempType)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"unknown.expression.type", (Object[])new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getRefactoringName(), (String)this.getHelpID());
            return false;
        }
        if (PsiTypes.voidType().equals((Object)tempType)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"selected.expression.has.void.type", (Object[])new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getRefactoringName(), (String)this.getHelpID());
            return false;
        }
        String switchLabelError = RefactoringUtil.checkEnumConstantInSwitchLabel(selectedExpr);
        if (switchLabelError != null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)switchLabelError), (String)this.getRefactoringName(), (String)this.getHelpID());
            return false;
        }
        this.myParentClass = this.getParentClass(selectedExpr);
        ArrayList<PsiClass> classes = new ArrayList<PsiClass>();
        PsiClass aClass = this.myParentClass;
        while (aClass != null) {
            classes.add(aClass);
            PsiField psiField = ConvertToFieldRunnable.checkForwardRefs(selectedExpr, aClass);
            if (psiField != null && psiField.getParent() == aClass) break;
            aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class, (boolean)true);
        }
        boolean bl = shouldSuggestDialog = (activeIntroducer = AbstractInplaceIntroducer.getActiveIntroducer((Editor)editor)) instanceof InplaceIntroduceConstantPopup && activeIntroducer.startsOnTheSameElement((PsiElement)selectedExpr, null);
        if (classes.size() == 1 || editor == null || IntentionPreviewUtils.isPreviewElement((PsiElement)this.myParentClass) || ApplicationManager.getApplication().isUnitTestMode() || shouldSuggestDialog) {
            return !this.convertExpressionToField(selectedExpr, editor, file, project, tempType);
        }
        if (!classes.isEmpty()) {
            PsiClass selection = AnonymousTargetClassPreselectionUtil.getPreselection(classes, (PsiClass)this.myParentClass);
            @Nls String title = this.myIsConstant ? JavaRefactoringBundle.message((String)"popup.title.choose.class.to.introduce.constant", (Object[])new Object[0]) : JavaRefactoringBundle.message((String)"popup.title.choose.class.to.introduce.field", (Object[])new Object[0]);
            new PsiTargetNavigator((PsiElement[])classes.toArray(PsiClass.EMPTY_ARRAY)).selection((PsiElement)selection).createPopup(project, title, (PsiElementProcessor)new PsiElementProcessor<PsiClass>(){

                public boolean execute(@NotNull PsiClass aClass) {
                    if (aClass == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    AnonymousTargetClassPreselectionUtil.rememberSelection((PsiClass)aClass, (PsiClass)BaseExpressionToFieldHandler.this.myParentClass);
                    BaseExpressionToFieldHandler.this.myParentClass = aClass;
                    BaseExpressionToFieldHandler.this.convertExpressionToField(selectedExpr, editor, file, project, tempType);
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/refactoring/introduceField/BaseExpressionToFieldHandler$1", "execute"));
                }
            }).showInBestPositionFor(editor);
        }
        return true;
    }

    private boolean convertExpressionToField(PsiExpression selectedExpr, @Nullable Editor editor, PsiFile file, Project project, PsiType tempType) {
        if (this.myParentClass == null) {
            if (FileTypeUtils.isInServerPageFile((PsiElement)file)) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaRefactoringBundle.message((String)"error.not.supported.for.jsp", (Object[])new Object[]{this.getRefactoringName()}), (String)this.getRefactoringName(), (String)this.getHelpID());
                return true;
            }
            if ("package-info.java".equals(file.getName())) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaRefactoringBundle.message((String)"error.not.supported.for.package.info", (Object[])new Object[]{this.getRefactoringName()}), (String)this.getRefactoringName(), (String)this.getHelpID());
                return true;
            }
            LOG.error("Unexpected file: " + String.valueOf(file));
            return true;
        }
        if (!this.validClass(this.myParentClass, selectedExpr, editor)) {
            return true;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            return true;
        }
        OccurrenceManager occurrenceManager = this.createOccurrenceManager(selectedExpr, this.myParentClass);
        PsiExpression[] occurrences = occurrenceManager.getOccurrences();
        PsiElement anchorStatementIfAll = occurrenceManager.getAnchorStatementForAll();
        List<RangeHighlighter> highlighters = null;
        if (editor != null) {
            highlighters = RefactoringUtil.highlightAllOccurrences(project, (PsiElement[])occurrences, editor);
        }
        PsiElement tempAnchorElement = CommonJavaRefactoringUtil.getParentExpressionAnchorElement((PsiElement)selectedExpr);
        if (!Comparing.strEqual((String)IntroduceConstantHandler.getRefactoringNameText(), (String)this.getRefactoringName()) && IntroduceFieldHandler.isInSuperOrThis(selectedExpr) && this.isStaticFinalInitializer(selectedExpr) != null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"invalid.expression.context", (Object[])new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getRefactoringName(), (String)this.getHelpID());
            return true;
        }
        Settings settings = this.showRefactoringDialog(project, editor, this.myParentClass, selectedExpr, tempType, occurrences, tempAnchorElement, anchorStatementIfAll);
        if (settings == null) {
            return true;
        }
        if (settings.getForcedType() != null) {
            tempType = settings.getForcedType();
        }
        PsiType type = tempType;
        if (editor != null) {
            HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
            for (RangeHighlighter highlighter : highlighters) {
                highlightManager.removeSegmentHighlighter(editor, highlighter);
            }
        }
        ConvertToFieldRunnable runnable = new ConvertToFieldRunnable(settings.getSelectedExpr(), settings, type, settings.getOccurrences(), anchorStatementIfAll, tempAnchorElement, editor, this.myParentClass);
        if (IntentionPreviewUtils.isPreviewElement((PsiElement)this.myParentClass)) {
            runnable.run();
        } else {
            WriteCommandAction.writeCommandAction((Project)project).withName(this.getRefactoringName()).run(runnable::run);
        }
        return false;
    }

    public static void setModifiers(PsiField field, Settings settings) {
        if (!settings.isIntroduceEnumConstant()) {
            if (settings.isDeclareStatic()) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"static", (boolean)true);
            }
            if (settings.isDeclareFinal()) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)field, (String)"final", (boolean)true);
            }
            if (settings.isAnnotateAsNonNls()) {
                PsiAnnotation annotation = JavaPsiFacade.getElementFactory((Project)field.getProject()).createAnnotationFromText("@org.jetbrains.annotations.NonNls", (PsiElement)field);
                PsiModifierList modifierList = field.getModifierList();
                LOG.assertTrue(modifierList != null);
                modifierList.addAfter((PsiElement)annotation, null);
            }
        }
        JavaCodeStyleManager.getInstance((Project)field.getProject()).shortenClassReferences((PsiElement)field);
    }

    public static PsiElement getPhysicalElement(PsiExpression selectedExpr) {
        PsiElement element = (PsiElement)selectedExpr.getUserData(ElementToWorkOn.PARENT);
        if (element == null) {
            element = selectedExpr;
        }
        return element;
    }

    @Nullable
    protected PsiElement isStaticFinalInitializer(PsiExpression expr) {
        PsiClass parentClass;
        PsiClass psiClass = parentClass = expr != null ? this.getParentClass(expr) : null;
        if (parentClass == null) {
            return null;
        }
        IsStaticFinalInitializerExpression visitor2 = new IsStaticFinalInitializerExpression(parentClass, expr);
        expr.accept((PsiElementVisitor)visitor2);
        return visitor2.getElementReference();
    }

    protected abstract OccurrenceManager createOccurrenceManager(PsiExpression var1, PsiClass var2);

    @Nullable
    protected final PsiClass getParentClass() {
        return this.myParentClass;
    }

    protected abstract boolean validClass(PsiClass var1, PsiExpression var2, Editor var3);

    private static PsiElement getNormalizedAnchor(PsiElement anchorElement2) {
        PsiElement prev;
        PsiElement child = anchorElement2;
        while (child != null && !CommonJavaRefactoringUtil.isExpressionAnchorElement((PsiElement)(prev = child.getPrevSibling())) && !PsiUtil.isJavaToken((PsiElement)prev, (IElementType)JavaTokenType.LBRACE)) {
            child = prev;
        }
        PsiElement anchor = (child = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)child)) != null ? child : anchorElement2;
        return anchor;
    }

    protected abstract String getHelpID();

    protected abstract Settings showRefactoringDialog(Project var1, Editor var2, PsiClass var3, PsiExpression var4, PsiType var5, PsiExpression[] var6, PsiElement var7, PsiElement var8);

    private static PsiType getTypeByExpression(PsiExpression expr) {
        return CommonJavaRefactoringUtil.getTypeByExpressionWithExpectedType((PsiExpression)expr);
    }

    @Nullable
    public PsiClass getParentClass(@NotNull PsiExpression initializerExpression) {
        if (initializerExpression == null) {
            BaseExpressionToFieldHandler.$$$reportNull$$$0(1);
        }
        boolean compileTimeConstant = LocalToFieldHandler.isCompileTimeConstant(initializerExpression, initializerExpression.getType());
        PsiElement parent = (PsiElement)initializerExpression.getUserData(ElementToWorkOn.PARENT);
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)(parent == null ? initializerExpression : parent), PsiClass.class);
        while (aClass != null) {
            if (!this.myIsConstant || compileTimeConstant || LocalToFieldHandler.isStaticFieldAllowed(aClass)) {
                return aClass;
            }
            aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)aClass, PsiClass.class);
        }
        return null;
    }

    public static PsiMethod getEnclosingConstructor(PsiClass parentClass, PsiElement element) {
        PsiMethod[] constructors;
        if (element == null) {
            return null;
        }
        for (PsiMethod constructor : constructors = parentClass.getConstructors()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)constructor, (PsiElement)element, (boolean)false)) continue;
            if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class) != parentClass) {
                return null;
            }
            return constructor;
        }
        return null;
    }

    private static void addInitializationToSetUp(PsiExpression initializer, PsiField field, PsiExpression[] occurrences, boolean replaceAll, PsiClass parentClass) throws IncorrectOperationException {
        PsiExpressionStatement expressionStatement;
        PsiAssignmentExpression expr;
        PsiExpression rExpression;
        PsiMethod setupMethod = TestFrameworks.getInstance().findOrCreateSetUpMethod(parentClass);
        assert (setupMethod != null);
        PsiElement anchor = null;
        if (PsiTreeUtil.isAncestor((PsiElement)setupMethod, (PsiElement)initializer, (boolean)true)) {
            anchor = replaceAll ? CommonJavaRefactoringUtil.getAnchorElementForMultipleExpressions((PsiExpression[])occurrences, (PsiElement)setupMethod) : PsiTreeUtil.getParentOfType((PsiElement)initializer, PsiStatement.class);
        }
        LOG.assertTrue((rExpression = (expr = (PsiAssignmentExpression)(expressionStatement = (PsiExpressionStatement)JavaPsiFacade.getElementFactory((Project)parentClass.getProject()).createStatementFromText(field.getName() + "= expr;", null)).getExpression()).getRExpression()) != null);
        rExpression.replace((PsiElement)initializer);
        PsiCodeBlock body = setupMethod.getBody();
        assert (body != null);
        body.addBefore((PsiElement)expressionStatement, anchor);
    }

    private static void addInitializationToConstructors(PsiExpression initializerExpression, PsiField field, PsiMethod enclosingConstructor, PsiClass parentClass) {
        try {
            PsiClass aClass = field.getContainingClass();
            PsiMethod[] constructors = aClass.getConstructors();
            boolean added = false;
            for (PsiMethod constructor : constructors) {
                String text;
                PsiExpression expression;
                PsiStatement first;
                PsiStatement[] statements;
                PsiCodeBlock body;
                if (constructor == enclosingConstructor || (body = constructor.getBody()) == null || (statements = body.getStatements()).length > 0 && (first = statements[0]) instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)first).getExpression()) instanceof PsiMethodCallExpression && "this".equals(text = ((PsiMethodCallExpression)expression).getMethodExpression().getText())) continue;
                PsiStatement assignment = BaseExpressionToFieldHandler.createAssignment(field, initializerExpression, body.getLastChild(), parentClass);
                assignment = (PsiStatement)body.add((PsiElement)assignment);
                ChangeContextUtil.decodeContextInfo((PsiElement)assignment, (PsiClass)field.getContainingClass(), (PsiExpression)RefactoringChangeUtil.createThisExpression((PsiManager)field.getManager(), null));
                added = true;
            }
            if (!added && enclosingConstructor == null) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)field.getProject());
                PsiMethod constructor = (PsiMethod)aClass.add((PsiElement)factory.createConstructor());
                PsiCodeBlock body = constructor.getBody();
                PsiStatement assignment = BaseExpressionToFieldHandler.createAssignment(field, initializerExpression, body.getLastChild(), parentClass);
                assignment = (PsiStatement)body.add((PsiElement)assignment);
                ChangeContextUtil.decodeContextInfo((PsiElement)assignment, (PsiClass)field.getContainingClass(), (PsiExpression)RefactoringChangeUtil.createThisExpression((PsiManager)field.getManager(), null));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static PsiField createField(String fieldName, PsiType type, PsiExpression initializerExpr, boolean includeInitializer, PsiClass parentClass) {
        @NonNls StringBuilder pattern = new StringBuilder();
        pattern.append("private int ");
        pattern.append(fieldName);
        if (includeInitializer) {
            pattern.append("=0");
        }
        pattern.append(";");
        PsiManager psiManager = parentClass.getManager();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiManager.getProject());
        try {
            PsiField field = factory.createFieldFromText(pattern.toString(), null);
            PsiTypeElement typeElement = factory.createTypeElement(type);
            field.getTypeElement().replace((PsiElement)typeElement);
            field = (PsiField)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)field);
            if (includeInitializer) {
                field.getInitializer().replace((PsiElement)initializerExpr);
            }
            return field;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static PsiStatement createAssignment(PsiField field, PsiExpression initializerExpr, PsiElement context, PsiClass parentClass) {
        try {
            @NonNls String pattern = "x=0;";
            PsiManager psiManager = parentClass.getManager();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiManager.getProject());
            PsiExpressionStatement statement = (PsiExpressionStatement)factory.createStatementFromText(pattern, null);
            statement = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)statement);
            PsiAssignmentExpression expr = (PsiAssignmentExpression)statement.getExpression();
            PsiExpression rExpression = expr.getRExpression();
            LOG.assertTrue(rExpression != null);
            rExpression.replace((PsiElement)initializerExpr);
            PsiReferenceExpression fieldReference = RenameJavaMemberProcessor.createMemberReference((PsiMember)field, context);
            expr.getLExpression().replace((PsiElement)fieldReference);
            return statement;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    protected abstract boolean accept(ElementToWorkOn var1);

    protected ElementToWorkOn.ElementsProcessor<ElementToWorkOn> getElementProcessor(final Project project, final Editor editor) {
        return new ElementToWorkOn.ElementsProcessor<ElementToWorkOn>(){

            public boolean accept(ElementToWorkOn el) {
                return BaseExpressionToFieldHandler.this.accept(el);
            }

            public void pass(ElementToWorkOn elementToWorkOn) {
                boolean hasRunTemplate;
                if (elementToWorkOn == null) {
                    return;
                }
                if (elementToWorkOn.getExpression() == null && elementToWorkOn.getLocalVariable() == null) {
                    ElementToWorkOn.showNothingSelectedErrorMessage((Editor)editor, (String)BaseExpressionToFieldHandler.this.getRefactoringName(), (String)BaseExpressionToFieldHandler.this.getHelpID(), (Project)project);
                    return;
                }
                boolean bl = hasRunTemplate = LookupManager.getActiveLookup((Editor)editor) == null;
                if (elementToWorkOn.getExpression() == null) {
                    boolean result;
                    PsiLocalVariable localVariable = elementToWorkOn.getLocalVariable();
                    boolean bl2 = result = BaseExpressionToFieldHandler.this.invokeImpl(project, localVariable, editor) && hasRunTemplate;
                    if (result) {
                        editor.getSelectionModel().removeSelection();
                    }
                } else if (BaseExpressionToFieldHandler.this.invokeImpl(project, elementToWorkOn.getExpression(), editor) && hasRunTemplate) {
                    editor.getSelectionModel().removeSelection();
                }
            }
        };
    }

    @NlsContexts.DialogTitle
    protected abstract String getRefactoringName();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedExpr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializerExpression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/introduceField/BaseExpressionToFieldHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ConvertToFieldRunnable
    implements Runnable {
        private PsiExpression mySelectedExpr;
        private final Settings mySettings;
        private final PsiElement myAnchorElement;
        private final Project myProject;
        private final String myFieldName;
        private final PsiType myType;
        private final PsiExpression[] myOccurrences;
        private final boolean myReplaceAll;
        private final PsiElement myAnchorStatementIfAll;
        private final PsiElement myAnchorElementIfOne;
        private final Boolean myOutOfCodeBlockExtraction;
        private final PsiElement myElement;
        private boolean myDeleteSelf;
        private final Editor myEditor;
        private final PsiClass myParentClass;
        private PsiField myField;

        public ConvertToFieldRunnable(PsiExpression selectedExpr, Settings settings, PsiType type, PsiExpression[] occurrences, PsiElement anchorStatementIfAll, PsiElement anchorElementIfOne, Editor editor, PsiClass parentClass) {
            this.mySelectedExpr = selectedExpr;
            this.mySettings = settings;
            this.myAnchorElement = settings.isReplaceAll() ? anchorStatementIfAll : anchorElementIfOne;
            this.myProject = selectedExpr.getProject();
            this.myFieldName = settings.getFieldName();
            this.myType = type;
            this.myOccurrences = occurrences;
            this.myReplaceAll = settings.isReplaceAll();
            this.myAnchorStatementIfAll = anchorStatementIfAll;
            this.myAnchorElementIfOne = anchorElementIfOne;
            this.myOutOfCodeBlockExtraction = (Boolean)selectedExpr.getUserData(ElementToWorkOn.OUT_OF_CODE_BLOCK);
            this.myDeleteSelf = this.myOutOfCodeBlockExtraction != null;
            this.myElement = BaseExpressionToFieldHandler.getPhysicalElement(selectedExpr);
            PsiElement psiElement = this.myElement.getParent();
            if (psiElement instanceof PsiExpressionStatement) {
                PsiExpressionStatement statement = (PsiExpressionStatement)psiElement;
                if (BaseExpressionToFieldHandler.getNormalizedAnchor(this.myAnchorElement).equals((Object)this.myAnchorElement) && selectedExpr.isPhysical() && statement.getParent() instanceof PsiCodeBlock) {
                    this.myDeleteSelf = true;
                }
            }
            this.myEditor = editor;
            this.myParentClass = parentClass;
        }

        @Override
        public void run() {
            try {
                PsiMember anchorMember;
                PsiClass destClass;
                InitializationPlace initializerPlace = this.mySettings.getInitializerPlace();
                PsiLocalVariable localVariable = this.mySettings.getLocalVariable();
                boolean deleteLocalVariable = this.mySettings.isDeleteLocalVariable();
                PsiExpression initializer = null;
                if (localVariable != null) {
                    initializer = localVariable.getInitializer();
                } else if (!(this.mySelectedExpr instanceof PsiReferenceExpression) || ((PsiReferenceExpression)this.mySelectedExpr).resolve() != null) {
                    initializer = this.mySelectedExpr;
                }
                SmartTypePointer type = SmartTypePointerManager.getInstance((Project)this.myProject).createSmartTypePointer(this.myType);
                initializer = IntroduceVariableBase.simplifyVariableInitializer(initializer, this.myType, initializerPlace == InitializationPlace.IN_FIELD_DECLARATION);
                PsiMethod enclosingConstructor = BaseExpressionToFieldHandler.getEnclosingConstructor(this.myParentClass, this.myAnchorElement);
                PsiClass psiClass = destClass = this.mySettings.getDestinationClass() == null ? this.myParentClass : this.mySettings.getDestinationClass();
                if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)destClass.getContainingFile())) {
                    return;
                }
                ChangeContextUtil.encodeContextInfo((PsiElement)destClass, (boolean)true);
                this.myField = this.mySettings.isIntroduceEnumConstant() ? EnumConstantsUtil.createEnumConstant(destClass, this.myFieldName, initializer) : BaseExpressionToFieldHandler.createField(this.myFieldName, type.getType(), initializer, initializerPlace == InitializationPlace.IN_FIELD_DECLARATION && initializer != null, this.myParentClass);
                BaseExpressionToFieldHandler.setModifiers(this.myField, this.mySettings);
                PsiElement finalAnchorElement = null;
                if (destClass == this.myParentClass) {
                    for (finalAnchorElement = this.myAnchorElement; finalAnchorElement != null && finalAnchorElement.getParent() != destClass; finalAnchorElement = finalAnchorElement.getParent()) {
                    }
                }
                PsiMember psiMember = anchorMember = finalAnchorElement instanceof PsiMember ? (PsiMember)finalAnchorElement : null;
                if (anchorMember instanceof PsiEnumConstant && destClass == anchorMember.getContainingClass() && initializer != null && PsiTreeUtil.isAncestor((PsiElement)((PsiEnumConstant)anchorMember).getArgumentList(), (PsiElement)initializer, (boolean)false)) {
                    String initialName = "Constants";
                    Object constantsClassName = "Constants";
                    PsiClass innerClass = destClass.findInnerClassByName((String)constantsClassName, true);
                    if (innerClass == null || !ConvertToFieldRunnable.isConstantsClass(innerClass)) {
                        int i = 1;
                        while (destClass.findInnerClassByName((String)constantsClassName, true) != null) {
                            constantsClassName = "Constants" + i++;
                        }
                        PsiClass psiClass2 = JavaPsiFacade.getElementFactory((Project)this.myProject).createClass((String)constantsClassName);
                        PsiUtil.setModifierProperty((PsiModifierListOwner)psiClass2, (String)"private", (boolean)true);
                        PsiUtil.setModifierProperty((PsiModifierListOwner)psiClass2, (String)"static", (boolean)true);
                        destClass = (PsiClass)destClass.add((PsiElement)psiClass2);
                    } else {
                        destClass = innerClass;
                    }
                    anchorMember = null;
                }
                this.myField = ConvertToFieldRunnable.appendField(initializer, initializerPlace, destClass, this.myParentClass, this.myField, anchorMember);
                if (!this.mySettings.isIntroduceEnumConstant()) {
                    VisibilityUtil.fixVisibility((PsiExpression[])this.myOccurrences, (PsiMember)this.myField, (String)this.mySettings.getFieldVisibility());
                }
                PsiStatement assignStatement = null;
                PsiElement anchorElementHere = null;
                if (initializerPlace == InitializationPlace.IN_CURRENT_METHOD && initializer != null || initializerPlace == InitializationPlace.IN_CONSTRUCTOR && enclosingConstructor != null && initializer != null) {
                    PsiElement anchorInConstructor;
                    anchorElementHere = this.myReplaceAll ? (enclosingConstructor != null ? ((anchorInConstructor = CommonJavaRefactoringUtil.getAnchorElementForMultipleExpressions((PsiExpression[])this.mySettings.myOccurrences, (PsiElement)enclosingConstructor)) != null ? anchorInConstructor : this.myAnchorStatementIfAll) : this.myAnchorStatementIfAll) : this.myAnchorElementIfOne;
                    assignStatement = BaseExpressionToFieldHandler.createAssignment(this.myField, initializer, anchorElementHere, this.myParentClass);
                    if (anchorElementHere != null && !CommonJavaRefactoringUtil.isLoopOrIf((PsiElement)anchorElementHere.getParent())) {
                        anchorElementHere.getParent().addBefore((PsiElement)assignStatement, BaseExpressionToFieldHandler.getNormalizedAnchor(anchorElementHere));
                    }
                }
                if (initializerPlace == InitializationPlace.IN_CONSTRUCTOR && initializer != null) {
                    BaseExpressionToFieldHandler.addInitializationToConstructors(initializer, this.myField, enclosingConstructor, this.myParentClass);
                }
                if (initializerPlace == InitializationPlace.IN_SETUP_METHOD && initializer != null) {
                    BaseExpressionToFieldHandler.addInitializationToSetUp(initializer, this.myField, this.myOccurrences, this.myReplaceAll, this.myParentClass);
                }
                if (this.mySelectedExpr.getParent() instanceof PsiParenthesizedExpression) {
                    this.mySelectedExpr = (PsiExpression)this.mySelectedExpr.getParent();
                }
                if (this.myOutOfCodeBlockExtraction != null) {
                    PsiElement parent;
                    int endOffset = ((RangeMarker)this.mySelectedExpr.getUserData(ElementToWorkOn.TEXT_RANGE)).getEndOffset();
                    PsiElement endElement = this.myElement.getContainingFile().findElementAt(endOffset);
                    while (!((parent = endElement.getParent()) instanceof PsiClass)) {
                        endElement = parent;
                    }
                    PsiElement last = PsiTreeUtil.skipWhitespacesBackward((PsiElement)endElement);
                    if (last.getTextRange().getStartOffset() < this.myElement.getTextRange().getStartOffset()) {
                        last = this.myElement;
                    }
                    this.myElement.getParent().deleteChildRange(this.myElement, last);
                } else if (this.myDeleteSelf) {
                    this.myElement.getParent().delete();
                }
                if (this.myReplaceAll) {
                    ArrayList<PsiElement> array = new ArrayList<PsiElement>();
                    for (PsiExpression occurrence : this.myOccurrences) {
                        PsiElement replaced;
                        occurrence = CommonJavaRefactoringUtil.outermostParenthesizedExpression((PsiExpression)occurrence);
                        if (this.myDeleteSelf && occurrence.equals((Object)this.mySelectedExpr) || (replaced = RefactoringUtil.replaceOccurenceWithFieldRef(occurrence, this.myField, destClass)) == null) continue;
                        array.add(replaced);
                    }
                    if (this.myEditor != null && !ApplicationManager.getApplication().isUnitTestMode()) {
                        PsiElement[] exprsToHighlight = PsiUtilCore.toPsiElementArray(array);
                        HighlightManager highlightManager = HighlightManager.getInstance((Project)this.myProject);
                        highlightManager.addOccurrenceHighlights(this.myEditor, exprsToHighlight, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
                        WindowManager.getInstance().getStatusBar(this.myProject).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
                    }
                } else if (!this.myDeleteSelf) {
                    this.mySelectedExpr = CommonJavaRefactoringUtil.outermostParenthesizedExpression((PsiExpression)this.mySelectedExpr);
                    RefactoringUtil.replaceOccurenceWithFieldRef(this.mySelectedExpr, this.myField, destClass);
                }
                if (anchorElementHere != null && CommonJavaRefactoringUtil.isLoopOrIf((PsiElement)anchorElementHere.getParent())) {
                    CommonJavaRefactoringUtil.putStatementInLoopBody((PsiStatement)assignStatement, (PsiElement)anchorElementHere.getParent(), (PsiElement)anchorElementHere);
                }
                if (localVariable != null && deleteLocalVariable) {
                    localVariable.normalizeDeclaration();
                    localVariable.getParent().delete();
                }
                ChangeContextUtil.decodeContextInfo((PsiElement)destClass, (PsiClass)destClass, null);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        static boolean isConstantsClass(PsiClass innerClass) {
            if (innerClass.getMethods().length != 0) {
                return false;
            }
            for (PsiField field : innerClass.getFields()) {
                if (field.hasModifierProperty("static") && field.hasModifierProperty("final")) continue;
                return false;
            }
            return true;
        }

        static PsiField appendField(PsiExpression initializer, InitializationPlace initializerPlace, PsiClass destClass, PsiClass parentClass, PsiField psiField, PsiMember anchorMember) {
            return CommonJavaRefactoringUtil.appendField((PsiClass)destClass, (PsiField)psiField, (PsiElement)anchorMember, initializerPlace == InitializationPlace.IN_FIELD_DECLARATION ? ConvertToFieldRunnable.checkForwardRefs(initializer, parentClass) : null);
        }

        @Nullable
        private static PsiField checkForwardRefs(final @Nullable PsiExpression initializer, final PsiClass parentClass) {
            if (initializer == null) {
                return null;
            }
            final PsiField[] refConstantFields = new PsiField[1];
            initializer.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitReferenceExpression(expression);
                    PsiElement resolve = expression.resolve();
                    if (resolve instanceof PsiField && PsiTreeUtil.isAncestor((PsiElement)parentClass, (PsiElement)resolve, (boolean)false) && ((PsiField)resolve).hasInitializer() && !PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)resolve, (boolean)false) && (refConstantFields[0] == null || refConstantFields[0].getTextOffset() < resolve.getTextOffset())) {
                        refConstantFields[0] = (PsiField)resolve;
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/introduceField/BaseExpressionToFieldHandler$ConvertToFieldRunnable$1", "visitReferenceExpression"));
                }
            });
            return refConstantFields[0];
        }

        public PsiField getField() {
            return this.myField;
        }
    }

    public static class Settings {
        private final String myFieldName;
        private final PsiType myForcedType;
        private final boolean myReplaceAll;
        private final boolean myDeclareStatic;
        private final boolean myDeclareFinal;
        private final InitializationPlace myInitializerPlace;
        private final String myVisibility;
        private final boolean myDeleteLocalVariable;
        private final TargetDestination myTargetClass;
        private final boolean myAnnotateAsNonNls;
        private final boolean myIntroduceEnumConstant;
        private final PsiExpression mySelectedExpr;
        private PsiExpression[] myOccurrences;
        private final PsiLocalVariable myLocalVariable;

        public PsiLocalVariable getLocalVariable() {
            return this.myLocalVariable;
        }

        public boolean isDeleteLocalVariable() {
            return this.myDeleteLocalVariable;
        }

        public String getFieldName() {
            return this.myFieldName;
        }

        public boolean isDeclareStatic() {
            return this.myDeclareStatic;
        }

        public boolean isDeclareFinal() {
            return this.myDeclareFinal;
        }

        public InitializationPlace getInitializerPlace() {
            return this.myInitializerPlace;
        }

        public String getFieldVisibility() {
            return this.myVisibility;
        }

        @Nullable
        public PsiClass getDestinationClass() {
            return this.myTargetClass != null ? this.myTargetClass.getTargetClass() : null;
        }

        public PsiType getForcedType() {
            return this.myForcedType;
        }

        public boolean isReplaceAll() {
            return this.myReplaceAll;
        }

        public boolean isAnnotateAsNonNls() {
            return this.myAnnotateAsNonNls;
        }

        public boolean isIntroduceEnumConstant() {
            return this.myIntroduceEnumConstant;
        }

        public Settings(String fieldName, PsiExpression selectedExpr, PsiExpression[] occurrences, boolean replaceAll, boolean declareStatic, boolean declareFinal, InitializationPlace initializerPlace, String visibility, PsiLocalVariable localVariableToRemove, PsiType forcedType, boolean deleteLocalVariable, TargetDestination targetDestination, boolean annotateAsNonNls, boolean introduceEnumConstant) {
            this.myFieldName = fieldName;
            this.myOccurrences = occurrences;
            this.mySelectedExpr = selectedExpr;
            this.myReplaceAll = replaceAll;
            this.myDeclareStatic = declareStatic;
            this.myDeclareFinal = declareFinal;
            this.myInitializerPlace = initializerPlace;
            this.myVisibility = visibility;
            this.myLocalVariable = localVariableToRemove;
            this.myDeleteLocalVariable = deleteLocalVariable;
            this.myForcedType = forcedType;
            this.myTargetClass = targetDestination;
            this.myAnnotateAsNonNls = annotateAsNonNls;
            this.myIntroduceEnumConstant = introduceEnumConstant;
        }

        public Settings(String fieldName, PsiExpression selectedExpression, PsiExpression[] occurrences, boolean replaceAll, boolean declareStatic, boolean declareFinal, InitializationPlace initializerPlace, String visibility, PsiLocalVariable localVariableToRemove, PsiType forcedType, boolean deleteLocalVariable, PsiClass targetClass, boolean annotateAsNonNls, boolean introduceEnumConstant) {
            this(fieldName, selectedExpression, occurrences, replaceAll, declareStatic, declareFinal, initializerPlace, visibility, localVariableToRemove, forcedType, deleteLocalVariable, new TargetDestination(targetClass), annotateAsNonNls, introduceEnumConstant);
        }

        public PsiExpression getSelectedExpr() {
            return this.mySelectedExpr;
        }

        public PsiExpression[] getOccurrences() {
            return this.myOccurrences;
        }

        public void setOccurrences(PsiExpression[] occurrences) {
            this.myOccurrences = occurrences;
        }
    }

    private static class IsStaticFinalInitializerExpression
    extends ClassMemberReferencesVisitor {
        private PsiElement myElementReference;
        private final PsiExpression myInitializer;
        private boolean myCheckThrowables = true;

        IsStaticFinalInitializerExpression(PsiClass aClass, PsiExpression initializer) {
            super(aClass);
            this.myInitializer = initializer;
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            PsiElement psiElement;
            if (expression == null) {
                IsStaticFinalInitializerExpression.$$$reportNull$$$0(0);
            }
            if (PsiUtil.isJvmLocalVariable((PsiElement)(psiElement = expression.resolve())) && !PsiTreeUtil.isAncestor((PsiElement)this.myInitializer, (PsiElement)psiElement, (boolean)false)) {
                this.myElementReference = expression;
            } else {
                super.visitReferenceExpression(expression);
            }
        }

        public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
            if (expression == null) {
                IsStaticFinalInitializerExpression.$$$reportNull$$$0(1);
            }
            if (!PsiMethodReferenceUtil.isResolvedBySecondSearch((PsiMethodReferenceExpression)expression)) {
                super.visitMethodReferenceExpression(expression);
            }
        }

        public void visitCallExpression(@NotNull PsiCallExpression callExpression) {
            if (callExpression == null) {
                IsStaticFinalInitializerExpression.$$$reportNull$$$0(2);
            }
            super.visitCallExpression(callExpression);
            if (!this.myCheckThrowables) {
                return;
            }
            List checkedExceptions = ExceptionUtil.getThrownCheckedExceptions((PsiElement[])new PsiElement[]{callExpression});
            if (!checkedExceptions.isEmpty()) {
                this.myElementReference = callExpression;
            }
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                IsStaticFinalInitializerExpression.$$$reportNull$$$0(3);
            }
            this.myCheckThrowables = false;
            super.visitClass(aClass);
        }

        public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
            if (expression == null) {
                IsStaticFinalInitializerExpression.$$$reportNull$$$0(4);
            }
            this.myCheckThrowables = false;
            super.visitLambdaExpression(expression);
        }

        protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
            if (!classMember.hasModifierProperty("static")) {
                this.myElementReference = classMemberReference;
            }
        }

        public void visitThisExpression(@NotNull PsiThisExpression expression) {
            if (expression == null) {
                IsStaticFinalInitializerExpression.$$$reportNull$$$0(5);
            }
            this.myElementReference = expression;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                IsStaticFinalInitializerExpression.$$$reportNull$$$0(6);
            }
            if (this.myElementReference != null) {
                return;
            }
            super.visitElement(element);
        }

        @Nullable
        public PsiElement getElementReference() {
            return this.myElementReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/introduceField/BaseExpressionToFieldHandler$IsStaticFinalInitializerExpression";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodReferenceExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitCallExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLambdaExpression";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitThisExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class TargetDestination {
        private final String myQualifiedName;
        private final Project myProject;
        private PsiClass myParentClass;
        private PsiClass myTargetClass;

        public TargetDestination(String qualifiedName, PsiClass parentClass) {
            this.myQualifiedName = qualifiedName;
            this.myParentClass = parentClass;
            this.myProject = parentClass.getProject();
        }

        public TargetDestination(@NotNull PsiClass targetClass) {
            if (targetClass == null) {
                TargetDestination.$$$reportNull$$$0(0);
            }
            this.myTargetClass = targetClass;
            this.myQualifiedName = targetClass.getQualifiedName();
            this.myProject = targetClass.getProject();
        }

        @Nullable
        public PsiClass getTargetClass() {
            PsiDirectory[] directories;
            if (this.myTargetClass != null) {
                return this.myTargetClass;
            }
            String packageName = StringUtil.getPackageName((String)this.myQualifiedName);
            String shortName = StringUtil.getShortName((String)this.myQualifiedName);
            if (Comparing.strEqual((String)this.myParentClass.getQualifiedName(), (String)packageName)) {
                this.myTargetClass = (PsiClass)this.myParentClass.add((PsiElement)JavaPsiFacade.getElementFactory((Project)this.myProject).createClass(shortName));
                return this.myTargetClass;
            }
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.myProject).findPackage(packageName);
            PsiDirectory psiDirectory = psiPackage != null ? ((directories = psiPackage.getDirectories(GlobalSearchScope.allScope((Project)this.myProject))).length > 1 ? DirectoryChooserUtil.chooseDirectory((PsiDirectory[])directories, null, (Project)this.myProject, new HashMap()) : directories[0]) : PackageUtil.findOrCreateDirectoryForPackage((Project)this.myProject, (String)packageName, (PsiDirectory)this.myParentClass.getContainingFile().getContainingDirectory(), (boolean)false);
            this.myTargetClass = psiDirectory != null ? JavaDirectoryService.getInstance().createClass(psiDirectory, shortName) : null;
            return this.myTargetClass;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetClass", "com/intellij/refactoring/introduceField/BaseExpressionToFieldHandler$TargetDestination", "<init>"));
        }
    }

    public static enum InitializationPlace {
        IN_CURRENT_METHOD,
        IN_FIELD_DECLARATION,
        IN_CONSTRUCTOR,
        IN_SETUP_METHOD;

    }
}

