/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.PreviewableRefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.AbstractInplaceIntroducer;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceField.InplaceIntroduceConstantPopup;
import com.intellij.refactoring.introduceField.IntroduceConstantDialog;
import com.intellij.refactoring.introduceField.LocalToFieldHandler;
import com.intellij.refactoring.introduceVariable.JavaIntroduceVariableHandlerBase;
import com.intellij.refactoring.ui.NameSuggestionsGenerator;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.occurrences.ExpressionOccurrenceManager;
import com.intellij.refactoring.util.occurrences.OccurrenceManager;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class IntroduceConstantHandler
extends BaseExpressionToFieldHandler
implements JavaIntroduceVariableHandlerBase,
PreviewableRefactoringActionHandler {
    protected InplaceIntroduceConstantPopup myInplaceIntroduceConstantPopup;

    public IntroduceConstantHandler() {
        super(true);
    }

    @Override
    protected String getHelpID() {
        return "refactoring.introduceConstant";
    }

    public void invoke(@NotNull Project project, Editor editor, PsiExpression expression) {
        if (project == null) {
            IntroduceConstantHandler.$$$reportNull$$$0(0);
        }
        this.invoke(project, new PsiExpression[]{expression});
    }

    public void invoke(@NotNull Project project, PsiExpression @NotNull [] expressions) {
        if (project == null) {
            IntroduceConstantHandler.$$$reportNull$$$0(1);
        }
        if (expressions == null) {
            IntroduceConstantHandler.$$$reportNull$$$0(2);
        }
        for (PsiExpression expression : expressions) {
            PsiFile file = expression.getContainingFile();
            if (CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) continue;
            return;
        }
        super.invoke(project, (PsiElement[])expressions, null);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            IntroduceConstantHandler.$$$reportNull$$$0(3);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file)) {
            return;
        }
        ElementToWorkOn.processElementToWorkOn((Editor)editor, (PsiFile)file, (String)IntroduceConstantHandler.getRefactoringNameText(), (String)this.getHelpID(), (Project)project, this.getElementProcessor(project, editor));
    }

    @Override
    protected boolean invokeImpl(final Project project, PsiLocalVariable localVariable, final Editor editor) {
        PsiElement parent = localVariable.getParent();
        if (!(parent instanceof PsiDeclarationStatement)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"error.wrong.caret.position.local.or.expression.name", (Object[])new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)IntroduceConstantHandler.getRefactoringNameText(), (String)this.getHelpID());
            return false;
        }
        LocalToFieldHandler localToFieldHandler = new LocalToFieldHandler(project, true){

            @Override
            protected BaseExpressionToFieldHandler.Settings showRefactoringDialog(PsiClass aClass, PsiLocalVariable local, PsiExpression[] occurences, boolean isStatic) {
                return IntroduceConstantHandler.this.showRefactoringDialog(project, editor, aClass, local.getInitializer(), local.getType(), occurences, (PsiElement)local, null);
            }
        };
        return localToFieldHandler.convertLocalToField(localVariable, editor);
    }

    @Override
    protected BaseExpressionToFieldHandler.Settings showRefactoringDialog(Project project, Editor editor, PsiClass parentClass, PsiExpression expr, PsiType type, PsiExpression[] occurrences, PsiElement anchorElement2, PsiElement anchorElementIfAll) {
        PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)(expr != null ? expr : anchorElement2), PsiMethod.class);
        ElementToWorkOn elementToWorkOn = ElementToWorkOn.adjustElements((PsiExpression)expr, (PsiElement)anchorElement2);
        PsiLocalVariable localVariable = elementToWorkOn.getLocalVariable();
        expr = elementToWorkOn.getExpression();
        String enteredName = null;
        boolean replaceAllOccurrences = true;
        AbstractInplaceIntroducer activeIntroducer = AbstractInplaceIntroducer.getActiveIntroducer((Editor)editor);
        if (activeIntroducer != null) {
            activeIntroducer.stopIntroduce(editor);
            expr = (PsiExpression)activeIntroducer.getExpr();
            localVariable = (PsiLocalVariable)activeIntroducer.getLocalVariable();
            occurrences = (PsiExpression[])activeIntroducer.getOccurrences();
            enteredName = activeIntroducer.getInputName();
            replaceAllOccurrences = activeIntroducer.isReplaceAllOccurrences();
            type = ((InplaceIntroduceConstantPopup)activeIntroducer).getType();
        }
        for (PsiExpression occurrence : occurrences) {
            if (!RefactoringUtil.isAssignmentLHS((PsiElement)occurrence)) continue;
            String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"variable.is.accessed.for.writing", (Object[])new Object[]{occurrence.getText()}));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)IntroduceConstantHandler.getRefactoringNameText(), (String)this.getHelpID());
            IntroduceConstantHandler.highlightError(project, editor, (PsiElement)occurrence);
            return null;
        }
        if (localVariable == null) {
            PsiElement errorElement = this.isStaticFinalInitializer(expr);
            if (errorElement != null) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"selected.expression.cannot.be.a.constant.initializer", (Object[])new Object[0]));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)IntroduceConstantHandler.getRefactoringNameText(), (String)this.getHelpID());
                IntroduceConstantHandler.highlightError(project, editor, errorElement);
                return null;
            }
        } else {
            PsiExpression initializer = localVariable.getInitializer();
            if (initializer == null) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"variable.does.not.have.an.initializer", (Object[])new Object[]{localVariable.getName()}));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)IntroduceConstantHandler.getRefactoringNameText(), (String)this.getHelpID());
                return null;
            }
            PsiElement errorElement = this.isStaticFinalInitializer(initializer);
            if (errorElement != null) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"initializer.for.variable.cannot.be.a.constant.initializer", (Object[])new Object[]{localVariable.getName()}));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)IntroduceConstantHandler.getRefactoringNameText(), (String)this.getHelpID());
                IntroduceConstantHandler.highlightError(project, editor, errorElement);
                return null;
            }
        }
        TypeSelectorManagerImpl typeSelectorManager = new TypeSelectorManagerImpl(project, type, containingMethod, expr, occurrences);
        if (editor != null && editor.getSettings().isVariableInplaceRenameEnabled() && (expr == null || expr.isPhysical()) && activeIntroducer == null) {
            this.myInplaceIntroduceConstantPopup = new InplaceIntroduceConstantPopup(project, editor, parentClass, expr, localVariable, occurrences, typeSelectorManager, anchorElement2, anchorElementIfAll);
            if (this.myInplaceIntroduceConstantPopup.startInplaceIntroduceTemplate()) {
                return null;
            }
        }
        if (IntentionPreviewUtils.isIntentionPreviewActive()) {
            boolean preselectNonNls = PropertiesComponent.getInstance((Project)project).getBoolean("INTRODUCE_CONSTANT_NONNLS");
            PsiType defaultType = typeSelectorManager.getDefaultType();
            NameSuggestionsGenerator generator = IntroduceConstantDialog.createNameSuggestionGenerator(null, expr, JavaCodeStyleManager.getInstance((Project)project), enteredName, this.getParentClass());
            return new BaseExpressionToFieldHandler.Settings(generator.getSuggestedNameInfo((PsiType)defaultType).names[0], expr, occurrences, replaceAllOccurrences, true, true, BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION, (String)ObjectUtils.notNull((Object)JavaRefactoringSettings.getInstance().INTRODUCE_CONSTANT_VISIBILITY, (Object)"public"), localVariable, defaultType, localVariable != null, this.getParentClass(), preselectNonNls, false);
        }
        IntroduceConstantDialog dialog = new IntroduceConstantDialog(project, parentClass, expr, localVariable, localVariable != null, occurrences, this.getParentClass(), (TypeSelectorManager)typeSelectorManager, enteredName);
        dialog.setReplaceAllOccurrences(replaceAllOccurrences);
        if (!dialog.showAndGet()) {
            if (occurrences.length > 1) {
                WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
            }
            return null;
        }
        return new BaseExpressionToFieldHandler.Settings(dialog.getEnteredName(), expr, occurrences, dialog.isReplaceAllOccurrences(), true, true, BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION, dialog.getFieldVisibility(), localVariable, dialog.getSelectedType(), dialog.isDeleteVariable(), dialog.getDestinationClass(), dialog.isAnnotateAsNonNls(), dialog.introduceEnumConstant());
    }

    private static void highlightError(Project project, Editor editor, PsiElement errorElement) {
        if (editor != null) {
            TextRange textRange = errorElement.getTextRange();
            HighlightManager.getInstance((Project)project).addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), EditorColors.SEARCH_RESULT_ATTRIBUTES, true, new ArrayList());
        }
    }

    @Override
    protected String getRefactoringName() {
        return IntroduceConstantHandler.getRefactoringNameText();
    }

    public InplaceIntroduceConstantPopup getInplaceIntroducer() {
        return this.myInplaceIntroduceConstantPopup;
    }

    @Override
    protected OccurrenceManager createOccurrenceManager(PsiExpression selectedExpr, PsiClass parentClass) {
        return new ExpressionOccurrenceManager(selectedExpr, (PsiElement)parentClass, null);
    }

    @Override
    protected boolean accept(ElementToWorkOn elementToWorkOn) {
        PsiExpression expr = elementToWorkOn.getExpression();
        if (expr != null) {
            return this.isStaticFinalInitializer(expr) == null;
        }
        PsiLocalVariable localVariable = elementToWorkOn.getLocalVariable();
        PsiExpression initializer = localVariable.getInitializer();
        return initializer != null && this.isStaticFinalInitializer(initializer) == null;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull PsiElement element) {
        if (project == null) {
            IntroduceConstantHandler.$$$reportNull$$$0(4);
        }
        if (element == null) {
            IntroduceConstantHandler.$$$reportNull$$$0(5);
        }
        if (element instanceof PsiExpression) {
            PsiExpression expression = (PsiExpression)element;
            this.invoke(project, null, expression);
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
            if (intentionPreviewInfo == null) {
                IntroduceConstantHandler.$$$reportNull$$$0(6);
            }
            return intentionPreviewInfo;
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            IntroduceConstantHandler.$$$reportNull$$$0(7);
        }
        return intentionPreviewInfo;
    }

    @Override
    protected boolean validClass(PsiClass parentClass, PsiExpression selectedExpr, Editor editor) {
        return true;
    }

    @NlsActions.ActionText
    public static String getRefactoringNameText() {
        return RefactoringBundle.message((String)"introduce.constant.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/introduceField/IntroduceConstantHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/introduceField/IntroduceConstantHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7 -> new IllegalStateException(string);
        };
    }
}

