/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduce.inplace.KeyboardComboSwitcher;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.IntroduceFieldCentralPanel;
import com.intellij.refactoring.introduceField.IntroduceFieldDialog;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.concurrent.Executor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroduceFieldPopupPanel
extends IntroduceFieldCentralPanel {
    @Nullable
    private JComboBox<BaseExpressionToFieldHandler.InitializationPlace> myInitializerCombo;
    private DefaultComboBoxModel<BaseExpressionToFieldHandler.InitializationPlace> myInitialisersPlaceModel;

    public IntroduceFieldPopupPanel(PsiClass parentClass, PsiExpression initializerExpression, PsiLocalVariable localVariable, boolean isCurrentMethodConstructor, boolean isInvokedOnDeclaration, boolean willBeDeclaredStatic, PsiExpression[] occurrences, boolean allowInitInMethod, boolean allowInitInMethodIfAll, TypeSelectorManager typeSelectorManager) {
        super(parentClass, initializerExpression, localVariable, isCurrentMethodConstructor, isInvokedOnDeclaration, willBeDeclaredStatic, occurrences, allowInitInMethod, allowInitInMethodIfAll, typeSelectorManager);
    }

    @Override
    protected void initializeInitializerPlace(PsiExpression initializerExpression, BaseExpressionToFieldHandler.InitializationPlace ourLastInitializerPlace) {
        if (initializerExpression != null) {
            boolean inOnlyConstructor;
            this.setEnabledInitializationPlaces(initializerExpression);
            if (!this.myAllowInitInMethod) {
                this.myInitialisersPlaceModel.removeElement((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD);
            }
            boolean bl = inOnlyConstructor = this.myIsCurrentMethodConstructor && this.myParentClass.getConstructors().length == 1;
            if (this.myWillBeDeclaredStatic || inOnlyConstructor) {
                this.myInitialisersPlaceModel.removeElement((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR);
            }
        } else {
            this.myInitialisersPlaceModel.removeAllElements();
        }
    }

    void setupSelection(@NotNull Disposable disposable) {
        if (disposable == null) {
            IntroduceFieldPopupPanel.$$$reportNull$$$0(0);
        }
        boolean canBeInitializedInField = this.myInitialisersPlaceModel.getIndexOf((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION) > -1;
        boolean canBeInitializedInConstructor = this.myInitialisersPlaceModel.getIndexOf((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR) > -1;
        int canBeInitializedInCurrentMethod = this.myInitialisersPlaceModel.getIndexOf((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD);
        ReadAction.nonBlocking(() -> this.getSelection(IntroduceFieldDialog.ourLastInitializerPlace, canBeInitializedInField, canBeInitializedInConstructor, canBeInitializedInCurrentMethod)).finishOnUiThread(ModalityState.any(), this.myInitialisersPlaceModel::setSelectedItem).expireWith(disposable).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private BaseExpressionToFieldHandler.InitializationPlace getSelection(BaseExpressionToFieldHandler.InitializationPlace ourLastInitializerPlace, boolean canBeInitializedInField, boolean canBeInitializedInConstructor, int canBeInitializedInCurrentMethod) {
        PsiMethod setUpMethod = TestFrameworks.getInstance().findSetUpMethod(this.myParentClass);
        if (ourLastInitializerPlace == BaseExpressionToFieldHandler.InitializationPlace.IN_SETUP_METHOD && this.hasSetUpChoice() && (this.myInitializerExpression != null && PsiTreeUtil.isAncestor((PsiElement)setUpMethod, (PsiElement)this.myInitializerExpression, (boolean)false) || TestFrameworks.getInstance().isTestClass(this.myParentClass))) {
            return BaseExpressionToFieldHandler.InitializationPlace.IN_SETUP_METHOD;
        }
        if (ourLastInitializerPlace == BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR && canBeInitializedInConstructor && this.myParentClass.getConstructors().length > 0) {
            return BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR;
        }
        if (ourLastInitializerPlace == BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION && canBeInitializedInField) {
            return BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION;
        }
        if (canBeInitializedInCurrentMethod > -1) {
            return BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD;
        }
        if (canBeInitializedInField) {
            return BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION;
        }
        return BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD;
    }

    @Override
    protected void initializeControls(PsiExpression initializerExpression, BaseExpressionToFieldHandler.InitializationPlace ourLastInitializerPlace) {
    }

    @Override
    public boolean isDeclareFinal() {
        return ourLastCbFinalState && this.allowFinal();
    }

    @Override
    public BaseExpressionToFieldHandler.InitializationPlace getInitializerPlace() {
        if (this.myInitializerCombo != null) {
            return (BaseExpressionToFieldHandler.InitializationPlace)((Object)this.myInitializerCombo.getSelectedItem());
        }
        return this.myInitialisersPlaceModel.getElementAt(0);
    }

    @Override
    public String getFieldVisibility() {
        String visibility = JavaRefactoringSettings.getInstance().INTRODUCE_FIELD_VISIBILITY;
        if (visibility == null) {
            visibility = "private";
        }
        return visibility;
    }

    @Override
    protected JComponent createInitializerPlacePanel(final ItemListener itemListener, final ItemListener finalUpdater) {
        JPanel groupPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBInsets.emptyInsets(), 0, 0);
        this.myInitialisersPlaceModel = new DefaultComboBoxModel();
        this.myInitialisersPlaceModel.addElement(BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD);
        this.myInitialisersPlaceModel.addElement(BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION);
        this.myInitialisersPlaceModel.addElement(BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR);
        if (!DumbService.isDumb((Project)this.myParentClass.getProject()) && TestFrameworks.getInstance().isTestClass(this.myParentClass)) {
            this.myInitialisersPlaceModel.addElement(BaseExpressionToFieldHandler.InitializationPlace.IN_SETUP_METHOD);
        }
        this.initializeInitializerPlace(this.myInitializerExpression, IntroduceFieldDialog.ourLastInitializerPlace);
        if (this.myInitialisersPlaceModel.getSize() > 1) {
            JLabel initLabel = new JLabel(RefactoringBundle.message((String)"initialize.in.border.title") + ":");
            gridBagConstraints.insets.left = 5;
            gridBagConstraints.anchor = 17;
            groupPanel.add((Component)initLabel, gridBagConstraints);
            ComboBox initializersCombo = new ComboBox(this.myInitialisersPlaceModel);
            KeyboardComboSwitcher.setupActions((JComboBox)initializersCombo, (Project)this.myParentClass.getProject());
            initLabel.setLabelFor((Component)initializersCombo);
            initializersCombo.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", IntroduceFieldPopupPanel::getPresentableText));
            initializersCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    itemListener.itemStateChanged(null);
                    finalUpdater.itemStateChanged(null);
                }
            });
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets.top = 0;
            gridBagConstraints.insets.left = 0;
            groupPanel.add((Component)initializersCombo, gridBagConstraints);
            this.myInitializerCombo = initializersCombo;
        }
        return groupPanel;
    }

    @Nullable
    private static String getPresentableText(BaseExpressionToFieldHandler.InitializationPlace value) {
        if (value == BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD) {
            return "current method";
        }
        if (value == BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR) {
            return "constructor";
        }
        if (value == BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION) {
            return "field declaration";
        }
        if (value == BaseExpressionToFieldHandler.InitializationPlace.IN_SETUP_METHOD) {
            return "setUp";
        }
        return null;
    }

    @Override
    protected boolean updateInitializationPlaceModel(boolean initializedInSetup, boolean initializedInConstructor, boolean locals) {
        if (locals) {
            this.myInitialisersPlaceModel.removeElement((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION);
        }
        if (!initializedInConstructor) {
            this.myInitialisersPlaceModel.removeElement((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR);
        }
        if (initializedInSetup) {
            return true;
        }
        this.myInitialisersPlaceModel.removeElement((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_SETUP_METHOD);
        return false;
    }

    @Override
    protected boolean hasSetUpChoice() {
        return this.myInitialisersPlaceModel.getIndexOf((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_SETUP_METHOD) > -1;
    }

    @Override
    public void setInitializeInFieldDeclaration() {
        LOG.assertTrue(this.myInitializerCombo != null);
        this.myInitializerCombo.setSelectedItem((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION);
    }

    @Override
    protected void updateCbFinal() {
    }

    @Override
    protected boolean allowFinal() {
        boolean allowFinal;
        BaseExpressionToFieldHandler.InitializationPlace selectedItem = this.getInitializerPlace();
        boolean bl = allowFinal = selectedItem == BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION || selectedItem == BaseExpressionToFieldHandler.InitializationPlace.IN_CONSTRUCTOR && !this.myWillBeDeclaredStatic;
        if (selectedItem == BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD && this.myIsCurrentMethodConstructor) {
            PsiMethod[] constructors = this.myParentClass.getConstructors();
            allowFinal = constructors.length <= 1;
        }
        return super.allowFinal() && allowFinal;
    }

    @Override
    protected void updateInitializerSelection() {
        if (this.myAllowInitInMethodIfAll || !this.isReplaceAllOccurrences()) {
            if (this.myInitialisersPlaceModel.getIndexOf((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD) == -1) {
                this.myInitialisersPlaceModel.insertElementAt(BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD, 0);
            }
        } else {
            this.myInitialisersPlaceModel.removeElement((Object)BaseExpressionToFieldHandler.InitializationPlace.IN_CURRENT_METHOD);
        }
    }

    @Override
    protected boolean shouldUpdateTypeSelector() {
        return false;
    }

    @Override
    protected JPanel appendCheckboxes(ItemListener itemListener) {
        JPanel panel = new JPanel(new GridBagLayout());
        this.appendOccurrences(itemListener, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBInsets.emptyInsets(), 0, 0), panel);
        return panel;
    }

    @Override
    protected JPanel composeWholePanel(JComponent initializerPlacePanel, JPanel checkboxPanel) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBInsets.emptyInsets(), 0, 0);
        panel.add((Component)initializerPlacePanel, constraints);
        ++constraints.gridy;
        panel.add((Component)checkboxPanel, constraints);
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/refactoring/introduceField/IntroduceFieldPopupPanel", "setupSelection"));
    }
}

