/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.FunctionalInterfaceSuggester;
import com.intellij.codeInsight.navigation.PsiTargetNavigator;
import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.java.JavaBundle;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.IntroduceFunctionalVariableAction;
import com.intellij.refactoring.extractMethod.AbstractExtractDialog;
import com.intellij.refactoring.extractMethod.ExtractMethodDialog;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.InputVariables;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.introduceParameter.IntroduceParameterHandler;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.introduceVariable.IntroduceVariableHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.VariableData;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.FlowLayout;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntroduceFunctionalVariableHandler
extends IntroduceVariableHandler {
    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            IntroduceFunctionalVariableHandler.$$$reportNull$$$0(0);
        }
        ExtractMethodHandler.selectAndPass(project, editor, file, elements -> {
            if (((PsiElement[])elements).length == 0) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.a.set.of.statements.or.an.expression"));
                this.showErrorMessage(project, editor, message);
                return;
            }
            PsiElement anchorStatement = elements[0] instanceof PsiComment ? elements[0] : CommonJavaRefactoringUtil.getParentStatement((PsiElement)elements[0], (boolean)false);
            IntroduceVariableBase.ErrorOrContainer errorOrContainer = IntroduceFunctionalVariableHandler.getTempContainer(anchorStatement);
            if (errorOrContainer instanceof IntroduceVariableBase.ErrorOrContainer.Error) {
                IntroduceVariableBase.ErrorOrContainer.Error $b$0 = (IntroduceVariableBase.ErrorOrContainer.Error)errorOrContainer;
                try {
                    String patt1$temp;
                    @NlsContexts.DialogMessage String message = patt1$temp = $b$0.message();
                    this.showErrorMessage(project, editor, message);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            PsiElement[] elementsInCopy = IntroduceParameterHandler.getElementsInCopy(project, file, elements);
            MyExtractMethodProcessor processor = new MyExtractMethodProcessor(project, editor, elementsInCopy, null, IntroduceFunctionalVariableAction.getRefactoringName(), null, "refactoring.introduceVariable");
            processor.setShowErrorDialogs(false);
            try {
                if (!processor.prepare()) {
                    this.showErrorMessage(project, editor);
                    return;
                }
            }
            catch (PrepareFailedException e) {
                this.showErrorMessage(project, editor, e.getMessage());
                return;
            }
            if (!processor.showDialog()) {
                return;
            }
            PsiMethod emptyMethod = processor.generateEmptyMethod("name", elements[0]);
            Collection types = FunctionalInterfaceSuggester.suggestFunctionalInterfaces((PsiMethod)emptyMethod);
            if (types.isEmpty()) {
                types = FunctionalInterfaceSuggester.suggestFunctionalInterfaces((PsiMethod)emptyMethod, (boolean)true);
            }
            if (types.isEmpty()) {
                this.showErrorMessage(project, editor, JavaBundle.message((String)"introduce.functional.variable.nothing.found.message", (Object[])new Object[0]));
                return;
            }
            if (types.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
                this.functionalInterfaceSelected((PsiType)ContainerUtil.getFirstItem((Collection)types), project, editor, processor, (PsiElement[])elements);
                return;
            }
            LinkedHashMap<PsiClass, PsiType> classes = new LinkedHashMap<PsiClass, PsiType>();
            for (PsiType type : types) {
                classes.put(PsiUtil.resolveClassInType((PsiType)type), type);
            }
            PsiClass[] psiClasses = classes.keySet().toArray(PsiClass.EMPTY_ARRAY);
            String methodSignature = PsiFormatUtil.formatMethod((PsiMethod)emptyMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)256, (int)2);
            PsiType returnType = emptyMethod.getReturnType();
            assert (returnType != null);
            String title = JavaBundle.message((String)"introduce.functional.variable.interface.chooser.title", (Object[])new Object[]{methodSignature, returnType.getPresentableText()});
            new PsiTargetNavigator((PsiElement[])psiClasses).createPopup(project, title, psiClass -> {
                this.functionalInterfaceSelected((PsiType)classes.get(psiClass), project, editor, processor, (PsiElement[])elements);
                return true;
            }).showInBestPositionFor(editor);
        });
    }

    @Override
    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        if (editor == null) {
            IntroduceFunctionalVariableHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            IntroduceFunctionalVariableHandler.$$$reportNull$$$0(2);
        }
        if (dataContext == null) {
            IntroduceFunctionalVariableHandler.$$$reportNull$$$0(3);
        }
        if (editor.getSelectionModel().hasSelection()) {
            return super.isAvailableForQuickList(editor, file, dataContext);
        }
        return false;
    }

    private void functionalInterfaceSelected(PsiType type, Project project, Editor editor, MyExtractMethodProcessor processor, PsiElement[] elements) {
        if (!elements[0].isValid()) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)elements[0])) {
            return;
        }
        MyExtractMethodProcessor physicalProcessor = new MyExtractMethodProcessor(project, editor, elements, null, IntroduceFunctionalVariableAction.getRefactoringName(), null, "refactoring.introduceVariable");
        try {
            physicalProcessor.prepare();
        }
        catch (PrepareFailedException e) {
            this.showErrorMessage(project, editor);
        }
        physicalProcessor.copyParameters(processor);
        physicalProcessor.setMethodVisibility("public");
        CommandProcessor.getInstance().executeCommand(project, () -> {
            PsiMethodCallExpression expression = (PsiMethodCallExpression)WriteAction.compute(() -> IntroduceFunctionalVariableHandler.createReplacement(project, type, physicalProcessor));
            this.invokeImpl(project, expression.getMethodExpression().getQualifierExpression(), editor);
        }, IntroduceFunctionalVariableAction.getRefactoringName(), null);
    }

    private static PsiMethodCallExpression createReplacement(Project project, PsiType selectedType, ExtractMethodProcessor processor) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)selectedType);
        PsiClass wrapperClass = resolveResult.getElement();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)wrapperClass);
        assert (method != null) : "not functional class";
        String interfaceMethodName = method.getName();
        processor.setMethodName(interfaceMethodName);
        processor.doExtract();
        PsiMethod extractedMethod = processor.getExtractedMethod();
        PsiParameter[] parameters = extractedMethod.getParameterList().getParameters();
        PsiParameter[] interfaceParameters = method.getParameterList().getParameters();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        for (int i = 0; i < interfaceParameters.length; ++i) {
            PsiTypeElement typeAfterInterface = factory.createTypeElement(substitutor.substitute(interfaceParameters[i].getType()));
            PsiTypeElement typeElement = parameters[i].getTypeElement();
            if (typeElement == null) continue;
            typeElement.replace((PsiElement)typeAfterInterface);
        }
        PsiMethodCallExpression methodCall = processor.getMethodCall();
        PsiMethodCallExpression psiExpression = (PsiMethodCallExpression)factory.createExpressionFromText("new " + selectedType.getCanonicalText() + "() {}." + methodCall.getText(), (PsiElement)methodCall);
        PsiExpression qualifierExpression = psiExpression.getMethodExpression().getQualifierExpression();
        assert (qualifierExpression != null);
        PsiAnonymousClass anonymousClass = ((PsiNewExpression)qualifierExpression).getAnonymousClass();
        assert (anonymousClass != null);
        ChangeContextUtil.encodeContextInfo((PsiElement)extractedMethod, (boolean)true);
        PsiClass aClass = extractedMethod.getContainingClass();
        ChangeContextUtil.decodeContextInfo((PsiElement)anonymousClass.add((PsiElement)extractedMethod), (PsiClass)aClass, (PsiExpression)RefactoringChangeUtil.createThisExpression((PsiManager)anonymousClass.getManager(), (PsiClass)aClass));
        if (AnonymousCanBeLambdaInspection.canBeConvertedToLambda((PsiAnonymousClass)anonymousClass, (boolean)false, Collections.emptySet())) {
            PsiExpression castExpression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("((" + selectedType.getCanonicalText() + ")" + AnonymousCanBeLambdaInspection.replaceAnonymousWithLambda((PsiElement)qualifierExpression, (PsiType)selectedType).getText() + ")", (PsiElement)qualifierExpression);
            qualifierExpression.replace((PsiElement)castExpression);
        }
        extractedMethod.delete();
        return (PsiMethodCallExpression)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(methodCall.replace((PsiElement)psiExpression));
    }

    @Override
    protected void showErrorMessage(@NotNull Project project, Editor editor, @NlsContexts.DialogMessage @NotNull String message) {
        if (project == null) {
            IntroduceFunctionalVariableHandler.$$$reportNull$$$0(4);
        }
        if (message == null) {
            IntroduceFunctionalVariableHandler.$$$reportNull$$$0(5);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)IntroduceFunctionalVariableAction.getRefactoringName(), (String)"refactoring.introduceVariable");
    }

    private void showErrorMessage(@NotNull Project project, Editor editor) {
        if (project == null) {
            IntroduceFunctionalVariableHandler.$$$reportNull$$$0(6);
        }
        String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"is.not.supported.in.the.current.context", (Object[])new Object[]{IntroduceFunctionalVariableAction.getRefactoringName()}));
        this.showErrorMessage(project, editor, message);
    }

    protected void setupProcessorWithoutDialog(ExtractMethodProcessor processor, InputVariables inputVariables) {
        processor.setDataFromInputVariables();
        processor.setMethodVisibility("public");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/introduceVariable/IntroduceFunctionalVariableHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableForQuickList";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyExtractMethodProcessor
    extends ExtractMethodProcessor {
        MyExtractMethodProcessor(Project project, Editor editor, PsiElement[] elements, @NlsContexts.DialogTitle PsiType forcedReturnType, String refactoringName, String initialMethodName, String helpId) {
            super(project, editor, elements, forcedReturnType, refactoringName, initialMethodName, helpId);
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        protected boolean isFoldingApplicable() {
            return false;
        }

        @Override
        protected void showMultipleOutputMessage(PsiType expressionType) throws PrepareFailedException {
            throw new PrepareFailedException(this.buildMultipleOutputMessageError(expressionType), this.myElements[0]);
        }

        @Override
        protected AbstractExtractDialog createExtractMethodDialog(boolean direct) {
            this.setDataFromInputVariables();
            return new ExtractMethodDialog(this.myProject, this.myTargetClass, this.myInputVariables, null, this.getTypeParameterList(), (PsiType[])this.getThrownExceptions(), this.isStatic(), this.isCanBeStatic(), false, IntroduceFunctionalVariableAction.getRefactoringName(), "refactoring.introduceVariable", null, this.myElements, null){

                @Override
                protected JComponent createNorthPanel() {
                    if (!MyExtractMethodProcessor.this.myInputVariables.hasInstanceFields()) {
                        return null;
                    }
                    JPanel optionsPanel = new JPanel(new FlowLayout(0, 0, 5));
                    this.createStaticOptions(optionsPanel, JavaRefactoringBundle.message((String)"introduce.functional.variable.pass.fields.checkbox", (Object[])new Object[0]));
                    return optionsPanel;
                }

                @Override
                public JComponent getPreferredFocusedComponent() {
                    return this.myParamTable;
                }

                @Override
                protected String getSignature() {
                    String parametersList = Arrays.stream(this.getChosenParameters()).filter(data -> data.passAsParameter).map(data -> data.type.getPresentableText()).reduce((result, item) -> result + ", " + item).orElse("");
                    String returnTypeString = MyExtractMethodProcessor.this.myReturnType == null || PsiTypes.voidType().equals((Object)MyExtractMethodProcessor.this.myReturnType) ? "{}" : MyExtractMethodProcessor.this.myReturnType.getPresentableText();
                    return "(" + parametersList + ") -> " + returnTypeString;
                }

                @Override
                protected void checkMethodConflicts(MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
                    this.checkParametersConflicts(conflicts);
                    for (VariableData data : this.getChosenParameters()) {
                        if (data.passAsParameter) continue;
                        PsiElement scope = PsiUtil.getVariableCodeBlock((PsiVariable)data.variable, null);
                        if (!(PsiUtil.isAvailable((JavaFeature)JavaFeature.EFFECTIVELY_FINAL, (PsiElement)data.variable) ? scope != null && !ControlFlowUtil.isEffectivelyFinal((PsiVariable)data.variable, (PsiElement)scope) : data.variable.hasModifierProperty("final"))) continue;
                        conflicts.putValue(null, (Object)JavaBundle.message((String)"introduce.functional.variable.accessibility.conflict", (Object[])new Object[]{data.name}));
                    }
                }

                @Override
                @NotNull
                public String getVisibility() {
                    return "public";
                }
            };
        }

        @Override
        public boolean prepare(@Nullable Consumer<? super ExtractMethodProcessor> pass) throws PrepareFailedException {
            boolean prepare = super.prepare(pass);
            if (prepare && (this.myNotNullConditionalCheck || this.myNullConditionalCheck)) {
                return false;
            }
            return prepare;
        }

        @Override
        public boolean showDialog() {
            if (!this.myInputVariables.hasInstanceFields() && this.myInputVariables.getInputVariables().isEmpty() || ApplicationManager.getApplication().isUnitTestMode()) {
                IntroduceFunctionalVariableHandler.this.setupProcessorWithoutDialog(this, this.myInputVariables);
                return true;
            }
            return super.showDialog();
        }

        @Override
        protected boolean defineVariablesForUnselectedParameters() {
            return false;
        }

        void copyParameters(MyExtractMethodProcessor processor) {
            this.myInputVariables.setPassFields(processor.myInputVariables.isPassFields());
            VariableData[] variables = processor.myVariableDatum;
            this.myVariableDatum = new VariableData[variables.length];
            for (int i = 0; i < variables.length; ++i) {
                VariableData data = variables[i];
                String variableName = data.variable.getName();
                assert (variableName != null);
                VariableData dataByVName = (VariableData)ContainerUtil.find((Iterable)this.myInputVariables.getInputVariables(), vData -> variableName.equals(vData.variable.getName()));
                if (dataByVName == null) continue;
                dataByVName.passAsParameter = data.passAsParameter;
                dataByVName.name = data.name;
                this.myVariableDatum[i] = dataByVName;
            }
        }
    }
}

