/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.FusInputEvent;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.IntroduceVariableUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.introduceVariable.FinalListener;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.introduceVariable.IntroduceVariableUsagesCollector;
import com.intellij.refactoring.introduceVariable.JavaVariableInplaceIntroducer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dBF\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\r\u0010\t\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b\u0012\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0014\u0010\u0013\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u00160\u0014J\u0010\u0010\u0017\u001a\u00020\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u0015J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001aJ\u0012\u0010\u001b\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\t\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/refactoring/introduceVariable/IntroduceVariablePopupComponent;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "cantChangeFinal", "", "canBeVarType", "commandName", "", "Lcom/intellij/openapi/util/NlsContexts$Command;", "variableSupplier", "Ljava/util/function/Supplier;", "Lcom/intellij/psi/PsiVariable;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;ZZLjava/lang/String;Ljava/util/function/Supplier;)V", "createPopupPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "logStatisticsOnShowCallback", "Lkotlin/Function1;", "Ljava/awt/event/MouseEvent;", "", "logStatisticsOnShow", "event", "logStatisticsOnHideCallback", "Lkotlin/Function0;", "logStatisticsOnHide", "psiVariable", "Companion", "intellij.java.impl.refactorings"})
public final class IntroduceVariablePopupComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    private final boolean cantChangeFinal;
    private final boolean canBeVarType;
    @Nullable
    private final String commandName;
    @NotNull
    private final Supplier<PsiVariable> variableSupplier;
    @NotNull
    private static final Logger LOG;

    public IntroduceVariablePopupComponent(@NotNull Editor editor, @NotNull Project project, boolean cantChangeFinal, boolean canBeVarType, @Nullable String commandName, @NotNull Supplier<PsiVariable> variableSupplier) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(variableSupplier, (String)"variableSupplier");
        this.editor = editor;
        this.project = project;
        this.cantChangeFinal = cantChangeFinal;
        this.canBeVarType = canBeVarType;
        this.commandName = commandName;
        this.variableSupplier = variableSupplier;
    }

    @NotNull
    public final DialogPanel createPopupPanel() {
        return BuilderKt.panel(arg_0 -> IntroduceVariablePopupComponent.createPopupPanel$lambda$0(this, arg_0));
    }

    @NotNull
    public final Function1<MouseEvent, Unit> logStatisticsOnShowCallback() {
        return arg_0 -> IntroduceVariablePopupComponent.logStatisticsOnShowCallback$lambda$0(this, arg_0);
    }

    public final void logStatisticsOnShow(@Nullable MouseEvent event) {
        PsiVariable psiVariable = this.variableSupplier.get();
        if (psiVariable == null) {
            return;
        }
        PsiVariable variable = psiVariable;
        EventPair[] eventPairArray = new EventPair[]{EventFields.InputEvent.with((Object)new FusInputEvent((InputEvent)event, null)), IntroduceVariableUsagesCollector.varType.with((Object)IntroduceVariableBase.createVarType()), IntroduceVariableUsagesCollector.finalState.with((Object)JavaVariableInplaceIntroducer.createFinals(variable.getContainingFile()))};
        IntroduceVariableUsagesCollector.settingsOnShow.log(this.project, eventPairArray);
    }

    @NotNull
    public final Function0<Unit> logStatisticsOnHideCallback() {
        return () -> IntroduceVariablePopupComponent.logStatisticsOnHideCallback$lambda$0(this);
    }

    private final void logStatisticsOnHide(PsiVariable psiVariable) {
        PsiTypeElement typeElement;
        PsiVariable psiVariable2 = psiVariable;
        if (psiVariable2 == null || (psiVariable2 = psiVariable2.getContainingFile()) == null) {
            return;
        }
        PsiVariable file = psiVariable2;
        boolean oldFinal = JavaVariableInplaceIntroducer.createFinals((PsiFile)file);
        boolean oldVarType = IntroduceVariableBase.createVarType();
        if (!this.cantChangeFinal) {
            JavaRefactoringSettings.getInstance().INTRODUCE_LOCAL_CREATE_FINALS = psiVariable.hasModifierProperty("final");
        }
        if (this.canBeVarType && (typeElement = psiVariable.getTypeElement()) != null) {
            JavaRefactoringSettings.getInstance().INTRODUCE_LOCAL_CREATE_VAR_TYPE = typeElement.isInferredType();
        }
        boolean newFinals = JavaVariableInplaceIntroducer.createFinals((PsiFile)file);
        boolean newVarType = IntroduceVariableBase.createVarType();
        EventPair[] eventPairArray = new EventPair[]{IntroduceVariableUsagesCollector.changed.with((Object)(newFinals != oldFinal || newVarType != oldVarType ? 1 : 0))};
        IntroduceVariableUsagesCollector.settingsChanged.log(this.project, eventPairArray);
        eventPairArray = new EventPair[]{IntroduceVariableUsagesCollector.varType.with((Object)newVarType), IntroduceVariableUsagesCollector.finalState.with((Object)newFinals)};
        IntroduceVariableUsagesCollector.settingsOnPerform.log(this.project, eventPairArray);
    }

    private static final void createPopupPanel$lambda$0$0$0$0(IntroduceVariablePopupComponent this$0, FinalListener $finalListener, JBCheckBox $it) {
        PsiDocumentManager.getInstance((Project)this$0.project).commitDocument(this$0.editor.getDocument());
        PsiVariable newVar = this$0.variableSupplier.get();
        if (newVar != null) {
            $finalListener.perform($it.isSelected(), newVar);
        }
    }

    private static final Unit createPopupPanel$lambda$0$0$0(IntroduceVariablePopupComponent this$0, FinalListener $finalListener, JBCheckBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        WriteCommandAction.writeCommandAction((Project)this$0.project).withName(this$0.commandName).withGroupId(this$0.commandName).run(() -> IntroduceVariablePopupComponent.createPopupPanel$lambda$0$0$0$0(this$0, $finalListener, it));
        return Unit.INSTANCE;
    }

    private static final void createPopupPanel$lambda$0$1$0$0(IntroduceVariablePopupComponent this$0, JBCheckBox $it) {
        PsiVariable newVar = this$0.variableSupplier.get();
        if (newVar != null) {
            PsiTypeElement typeElement = newVar.getTypeElement();
            LOG.assertTrue(typeElement != null);
            if ($it.isSelected()) {
                IntroduceVariableUtil.expandDiamondsAndReplaceExplicitTypeWithVar((PsiTypeElement)typeElement, (PsiElement)((PsiElement)newVar));
            } else if ((typeElement = PsiTypesUtil.replaceWithExplicitType((PsiTypeElement)typeElement)) != null) {
                IntroduceVariableBase.simplifyVariableInitializer(newVar.getInitializer(), typeElement.getType());
            }
        }
    }

    private static final Unit createPopupPanel$lambda$0$1$0(IntroduceVariablePopupComponent this$0, JBCheckBox it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        WriteCommandAction.writeCommandAction((Project)this$0.project).withName(this$0.commandName).withGroupId(this$0.commandName).run(() -> IntroduceVariablePopupComponent.createPopupPanel$lambda$0$1$0$0(this$0, it));
        return Unit.INSTANCE;
    }

    private static final Unit createPopupPanel$lambda$0$0(IntroduceVariablePopupComponent this$0, PsiVariable $variable, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        FinalListener finalListener = new FinalListener(this$0.editor);
        String string = JavaRefactoringBundle.message((String)"declare.final", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.selected((Cell)$this$row.checkBox(string), (boolean)JavaVariableInplaceIntroducer.createFinals($variable.getContainingFile())).onChanged(arg_0 -> IntroduceVariablePopupComponent.createPopupPanel$lambda$0$0$0(this$0, finalListener, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPopupPanel$lambda$0$1(IntroduceVariablePopupComponent this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = JavaRefactoringBundle.message((String)"declare.var.type", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.selected((Cell)$this$row.checkBox(string), (boolean)IntroduceVariableBase.createVarType()).onChanged(arg_0 -> IntroduceVariablePopupComponent.createPopupPanel$lambda$0$1$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit createPopupPanel$lambda$0(IntroduceVariablePopupComponent this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        PsiVariable variable = this$0.variableSupplier.get();
        if (!this$0.cantChangeFinal && variable != null) {
            Panel.row$default((Panel)$this$panel, null, arg_0 -> IntroduceVariablePopupComponent.createPopupPanel$lambda$0$0(this$0, variable, arg_0), (int)1, null);
        }
        if (this$0.canBeVarType) {
            Panel.row$default((Panel)$this$panel, null, arg_0 -> IntroduceVariablePopupComponent.createPopupPanel$lambda$0$1(this$0, arg_0), (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit logStatisticsOnShowCallback$lambda$0(IntroduceVariablePopupComponent this$0, MouseEvent event) {
        this$0.logStatisticsOnShow(event);
        return Unit.INSTANCE;
    }

    private static final Unit logStatisticsOnHideCallback$lambda$0(IntroduceVariablePopupComponent this$0) {
        this$0.logStatisticsOnHide(this$0.variableSupplier.get());
        return Unit.INSTANCE;
    }

    static {
        Logger logger = Logger.getInstance(IntroduceVariablePopupComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/refactoring/introduceVariable/IntroduceVariablePopupComponent$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.java.impl.refactorings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

