/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.core.JavaPsiBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.light.LightJavaToken;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.IntroduceVariableUtil;
import com.intellij.refactoring.introduceField.ElementToWorkOn;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.introduceVariable.IntroduceVariableSettings;
import com.intellij.refactoring.util.FieldConflictsResolver;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CodeBlockSurrounder;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import com.siyeh.ig.psiutils.ReorderingUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VariableExtractor {
    private static final Logger LOG = Logger.getInstance(VariableExtractor.class);
    @NotNull
    private final Project myProject;
    @Nullable
    private final Editor myEditor;
    @NotNull
    private final IntroduceVariableSettings mySettings;
    @NotNull
    private final PsiExpression myExpression;
    private final PsiFile myContainingFile;
    @NotNull
    private PsiElement myAnchor;
    private final PsiElement myContainer;
    private final PsiExpression @NotNull [] myOccurrences;
    private final boolean myReplaceSelf;
    @NotNull
    private final FieldConflictsResolver myFieldConflictsResolver;
    @Nullable
    private final LogicalPosition myPosition;

    VariableExtractor(@NotNull Project project, @NotNull PsiExpression expression, @Nullable Editor editor, @NotNull PsiElement anchorStatement, PsiExpression @NotNull [] occurrences, @NotNull IntroduceVariableSettings settings) {
        if (project == null) {
            VariableExtractor.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            VariableExtractor.$$$reportNull$$$0(1);
        }
        if (anchorStatement == null) {
            VariableExtractor.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            VariableExtractor.$$$reportNull$$$0(3);
        }
        if (occurrences == null) {
            VariableExtractor.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myExpression = expression;
        this.myEditor = editor;
        this.myOccurrences = occurrences;
        this.mySettings = settings;
        this.myContainer = anchorStatement.getParent();
        this.myAnchor = VariableExtractor.correctAnchor(expression, anchorStatement, occurrences);
        this.myContainingFile = this.myContainer.getContainingFile();
        this.myReplaceSelf = settings.isReplaceLValues() || !RefactoringUtil.isAssignmentLHS((PsiElement)expression);
        PsiCodeBlock newDeclarationScope = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)this.myContainer, PsiCodeBlock.class, (boolean)false);
        this.myFieldConflictsResolver = new FieldConflictsResolver(settings.getEnteredName(), newDeclarationScope);
        this.myPosition = editor != null ? editor.getCaretModel().getLogicalPosition() : null;
    }

    @NotNull
    SmartPsiElementPointer<PsiVariable> extractVariable() {
        if (!IntentionPreviewUtils.isPreviewElement((PsiElement)this.myExpression)) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
        }
        PsiExpression newExpr = this.myFieldConflictsResolver.fixInitializer(this.myExpression);
        if (this.myAnchor == this.myExpression) {
            this.myAnchor = newExpr;
        }
        PsiExpression initializer = RefactoringUtil.unparenthesizeExpression(newExpr);
        SmartTypePointer selectedType = SmartTypePointerManager.getInstance((Project)this.myProject).createSmartTypePointer(PsiTypesUtil.removeExternalAnnotations((PsiType)this.mySettings.getSelectedType()));
        initializer = IntroduceVariableBase.simplifyVariableInitializer(initializer, selectedType.getType());
        CommentTracker commentTracker = new CommentTracker();
        commentTracker.markUnchanged((PsiElement)initializer);
        initializer = (PsiExpression)initializer.copy();
        PsiType type = VariableExtractor.stripNullabilityAnnotationsFromTargetType(selectedType, newExpr);
        PsiElement declaration = this.createDeclaration(type, this.mySettings.getEnteredName(), initializer);
        this.replaceOccurrences(newExpr);
        this.ensureCodeBlock(type);
        PsiVariable var = this.addVariable(declaration, initializer);
        if (this.myAnchor instanceof PsiExpressionStatement && ExpressionUtils.isReferenceTo((PsiExpression)((PsiExpressionStatement)this.myAnchor).getExpression(), (PsiVariable)var)) {
            commentTracker.deleteAndRestoreComments(this.myAnchor);
            if (this.myEditor != null) {
                assert (this.myPosition != null);
                this.myEditor.getCaretModel().moveToLogicalPosition(this.myPosition);
                this.myEditor.getCaretModel().moveToOffset(var.getTextRange().getEndOffset());
                this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                this.myEditor.getSelectionModel().removeSelection();
            }
        }
        this.highlight(var);
        PsiUtil.setModifierProperty((PsiModifierListOwner)var, (String)"final", (boolean)this.mySettings.isDeclareFinal());
        if (!(var instanceof PsiPatternVariable) && this.mySettings.isDeclareVarType()) {
            PsiTypeElement typeElement = var.getTypeElement();
            LOG.assertTrue(typeElement != null);
            IntroduceVariableUtil.expandDiamondsAndReplaceExplicitTypeWithVar((PsiTypeElement)typeElement, (PsiElement)var);
        }
        this.myFieldConflictsResolver.fix();
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)var);
        if (smartPsiElementPointer == null) {
            VariableExtractor.$$$reportNull$$$0(5);
        }
        return smartPsiElementPointer;
    }

    private void ensureCodeBlock(PsiType type) {
        if (this.myAnchor instanceof PsiStatement && CommonJavaRefactoringUtil.isLoopOrIf((PsiElement)this.myAnchor.getParent())) {
            this.myAnchor = BlockUtils.expandSingleStatementToBlockStatement((PsiStatement)((PsiStatement)this.myAnchor));
        }
        if (this.myAnchor instanceof PsiInstanceOfExpression && PsiUtil.skipParenthesizedExprDown((PsiExpression)this.myExpression) instanceof PsiTypeCastExpression) {
            return;
        }
        if (this.myAnchor instanceof PsiExpression) {
            CodeBlockSurrounder surrounder = CodeBlockSurrounder.forExpression((PsiExpression)((PsiExpression)this.myAnchor));
            boolean addedCast = false;
            if (surrounder == null) {
                PsiExpression typedAnchor = JavaPsiFacade.getElementFactory((Project)this.myProject).createExpressionFromText("(" + type.getCanonicalText() + ")" + this.myAnchor.getText(), null);
                this.myAnchor = this.myAnchor.replace((PsiElement)typedAnchor);
                addedCast = true;
                surrounder = CodeBlockSurrounder.forExpression((PsiExpression)((PsiExpression)this.myAnchor));
            }
            if (surrounder == null) {
                throw new RuntimeExceptionWithAttachments("Cannot ensure code block: myAnchor type is " + String.valueOf(this.myAnchor.getClass()) + "; parent type is " + String.valueOf(this.myAnchor.getParent().getClass()), new Attachment[]{new Attachment("context.txt", this.myContainer.getText())});
            }
            CodeBlockSurrounder.SurroundResult result = surrounder.surround();
            this.myAnchor = result.getAnchor();
            PsiExpression expression = result.getExpression();
            if (addedCast && expression instanceof PsiTypeCastExpression) {
                expression.replace((PsiElement)Objects.requireNonNull(((PsiTypeCastExpression)expression).getOperand()));
            }
        }
    }

    private void highlight(@NotNull PsiVariable var) {
        if (var == null) {
            VariableExtractor.$$$reportNull$$$0(6);
        }
        if (this.myEditor != null) {
            PsiElement[] occurrences = (PsiElement[])ContainerUtil.map2Array((Collection)ReferencesSearch.search((PsiElement)var, (SearchScope)new LocalSearchScope((PsiElement)this.myContainingFile)).findAll(), PsiElement.class, ref -> ref.getElement());
            IntroduceVariableBase.highlightReplacedOccurrences(this.myProject, this.myEditor, occurrences);
        }
    }

    private void replaceOccurrences(PsiExpression newExpr) {
        assert (this.myAnchor.isValid());
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        PsiExpression ref = elementFactory.createExpressionFromText(this.mySettings.getEnteredName(), null);
        boolean needReplaceSelf = this.myReplaceSelf;
        if (this.mySettings.isReplaceAllOccurrences()) {
            for (PsiExpression occurrence : this.myOccurrences) {
                PsiExpression correctedOccurrence = occurrence.equals((Object)this.myExpression) ? newExpr : occurrence;
                correctedOccurrence = CommonJavaRefactoringUtil.outermostParenthesizedExpression((PsiExpression)correctedOccurrence);
                if (!this.mySettings.isReplaceLValues() && RefactoringUtil.isAssignmentLHS((PsiElement)correctedOccurrence)) continue;
                PsiElement replacement2 = IntroduceVariableUtil.replace((PsiExpression)correctedOccurrence, (PsiExpression)ref, (Project)this.myProject);
                if (this.myAnchor.isValid()) continue;
                this.myAnchor = replacement2;
            }
            needReplaceSelf &= newExpr instanceof PsiPolyadicExpression && newExpr.isValid() && !newExpr.isPhysical();
        }
        if (needReplaceSelf) {
            PsiElement replacement3 = IntroduceVariableUtil.replace((PsiExpression)newExpr, (PsiExpression)ref, (Project)this.myProject);
            if (!this.myAnchor.isValid()) {
                this.myAnchor = replacement3;
            }
        }
    }

    @NotNull
    private PsiVariable addVariable(PsiElement declaration, @NotNull PsiExpression initializer) {
        if (initializer == null) {
            VariableExtractor.$$$reportNull$$$0(7);
        }
        declaration = VariableExtractor.addDeclaration(declaration, initializer, this.myAnchor);
        declaration = JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences(declaration);
        PsiVariable psiVariable = (PsiVariable)(declaration instanceof PsiDeclarationStatement ? ((PsiDeclarationStatement)declaration).getDeclaredElements()[0] : declaration);
        if (psiVariable == null) {
            VariableExtractor.$$$reportNull$$$0(8);
        }
        return psiVariable;
    }

    @NotNull
    private PsiElement createDeclaration(@NotNull PsiType type, @NotNull String name, PsiExpression initializer) {
        if (type == null) {
            VariableExtractor.$$$reportNull$$$0(9);
        }
        if (name == null) {
            VariableExtractor.$$$reportNull$$$0(10);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        if (this.myAnchor instanceof PsiInstanceOfExpression && initializer instanceof PsiTypeCastExpression) {
            PsiTypeElement castType = Objects.requireNonNull(((PsiTypeCastExpression)initializer).getCastType());
            PsiExpression psiExpression = elementFactory.createExpressionFromText(((PsiInstanceOfExpression)this.myAnchor).getOperand().getText() + " instanceof " + castType.getText() + " " + name, this.myContainer);
            if (psiExpression == null) {
                VariableExtractor.$$$reportNull$$$0(11);
            }
            return psiExpression;
        }
        if (this.myContainer instanceof PsiClass) {
            PsiField declaration = elementFactory.createField(name, type);
            declaration.setInitializer(initializer);
            PsiField psiField = declaration;
            if (psiField == null) {
                VariableExtractor.$$$reportNull$$$0(12);
            }
            return psiField;
        }
        PsiDeclarationStatement psiDeclarationStatement = elementFactory.createVariableDeclarationStatement(name, type, initializer, this.myContainer);
        if (psiDeclarationStatement == null) {
            VariableExtractor.$$$reportNull$$$0(13);
        }
        return psiDeclarationStatement;
    }

    private static PsiElement addDeclaration(PsiElement declaration, PsiExpression initializer, @NotNull PsiElement anchor) {
        PsiElement[] declaredElements;
        if (anchor == null) {
            VariableExtractor.$$$reportNull$$$0(14);
        }
        if (anchor instanceof PsiDeclarationStatement && (declaredElements = ((PsiDeclarationStatement)anchor).getDeclaredElements()).length > 1) {
            final int[] usedFirstVar = new int[]{-1};
            initializer.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                    int i;
                    if (expression == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((i = ArrayUtilRt.find((Object[])declaredElements, (Object)expression.resolve())) > -1) {
                        usedFirstVar[0] = Math.max(i, usedFirstVar[0]);
                    }
                    super.visitReferenceExpression(expression);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/introduceVariable/VariableExtractor$1", "visitReferenceExpression"));
                }
            });
            if (usedFirstVar[0] > -1) {
                PsiVariable psiVariable = (PsiVariable)declaredElements[usedFirstVar[0]];
                psiVariable.normalizeDeclaration();
                PsiDeclarationStatement parDeclarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)psiVariable, PsiDeclarationStatement.class);
                return anchor.getParent().addAfter(declaration, (PsiElement)parDeclarationStatement);
            }
        }
        if (anchor instanceof PsiInstanceOfExpression && declaration instanceof PsiInstanceOfExpression) {
            PsiInstanceOfExpression newInstanceOf = (PsiInstanceOfExpression)anchor.replace(declaration);
            return ((PsiTypeTestPattern)Objects.requireNonNull(newInstanceOf.getPattern())).getPatternVariable();
        }
        if (anchor instanceof PsiResourceListElement) {
            PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)declaration;
            PsiLocalVariable localVariable = (PsiLocalVariable)declarationStatement.getDeclaredElements()[0];
            PsiResourceVariable resourceVariable = JavaPsiFacade.getElementFactory((Project)anchor.getProject()).createResourceVariable(localVariable.getName(), localVariable.getType(), initializer, anchor);
            return anchor.replace((PsiElement)resourceVariable);
        }
        PsiElement parent = anchor.getParent();
        if (parent == null) {
            throw new IllegalStateException("Unexpectedly anchor has no parent. Anchor class: " + String.valueOf(anchor.getClass()));
        }
        VariableExtractor.tryFixSurroundContext(anchor);
        return parent.addBefore(declaration, anchor);
    }

    private static void tryFixSurroundContext(@NotNull PsiElement anchor) {
        if (anchor == null) {
            VariableExtractor.$$$reportNull$$$0(15);
        }
        if (anchor.getParent() instanceof PsiCodeBlock && anchor.getParent().getParent() instanceof PsiClassInitializer) {
            PsiElement element = anchor.getParent().getParent();
            while (element != null) {
                if (!((element = element.getPrevSibling()) instanceof PsiErrorElement) || !((PsiErrorElement)element).getErrorDescription().equals(JavaPsiBundle.message((String)"expected.class.or.interface", (Object[])new Object[0]))) continue;
                PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)element);
                if (PsiUtil.isJavaToken((PsiElement)prev, (IElementType)JavaTokenType.RBRACE)) {
                    prev.delete();
                }
                if (!(prev instanceof PsiErrorElement) || !((PsiErrorElement)prev).getErrorDescription().equals(JavaPsiBundle.message((String)"expected.lbrace", (Object[])new Object[0]))) continue;
                prev.replace((PsiElement)new LightJavaToken(anchor.getManager(), "{"));
            }
        }
    }

    @NotNull
    private static PsiType stripNullabilityAnnotationsFromTargetType(@NotNull SmartTypePointer selectedType, @NotNull PsiExpression expression) {
        PsiType type;
        if (selectedType == null) {
            VariableExtractor.$$$reportNull$$$0(16);
        }
        if (expression == null) {
            VariableExtractor.$$$reportNull$$$0(17);
        }
        if ((type = selectedType.getType()) == null) {
            throw new IncorrectOperationException("Unexpected empty type pointer");
        }
        if (!DumbService.isDumb((Project)expression.getProject())) {
            PsiDeclarationStatement probe = JavaPsiFacade.getElementFactory((Project)expression.getProject()).createVariableDeclarationStatement("x", (PsiType)TypeUtils.getObjectType((PsiElement)expression), null, (PsiElement)expression);
            Project project = expression.getProject();
            NullabilityAnnotationInfo nullabilityAnnotationInfo = NullableNotNullManager.getInstance((Project)project).findExplicitNullability((PsiModifierListOwner)((PsiLocalVariable)probe.getDeclaredElements()[0]));
            NullabilityAnnotationInfo info = DfaPsiUtil.getTypeNullabilityInfo((PsiType)type);
            if (info != null && nullabilityAnnotationInfo != null && info.getNullability() != nullabilityAnnotationInfo.getNullability() && ArrayUtil.contains((Object)info.getAnnotation(), (Object[])type.getAnnotations())) {
                PsiType psiType = type.annotate(TypeAnnotationProvider.Static.create((PsiAnnotation[])new PsiAnnotation[]{info.getAnnotation()}));
                if (psiType == null) {
                    VariableExtractor.$$$reportNull$$$0(18);
                }
                return psiType;
            }
        }
        PsiType psiType = type.annotate(TypeAnnotationProvider.EMPTY);
        if (psiType == null) {
            VariableExtractor.$$$reportNull$$$0(19);
        }
        return psiType;
    }

    @NotNull
    private static PsiElement correctAnchor(@NotNull PsiExpression expr, @NotNull PsiElement anchor, PsiExpression @NotNull [] occurrences) {
        PsiExpression ancestorCandidate;
        PsiWhileStatement whileStatement;
        PsiExpression condition;
        PsiTypeCastExpression cast;
        if (expr == null) {
            VariableExtractor.$$$reportNull$$$0(20);
        }
        if (anchor == null) {
            VariableExtractor.$$$reportNull$$$0(21);
        }
        if (occurrences == null) {
            VariableExtractor.$$$reportNull$$$0(22);
        }
        if (!expr.isPhysical() && (expr = (PsiExpression)ObjectUtils.tryCast((Object)expr.getUserData(ElementToWorkOn.PARENT), PsiExpression.class)) == null) {
            PsiElement psiElement = anchor;
            if (psiElement == null) {
                VariableExtractor.$$$reportNull$$$0(23);
            }
            return psiElement;
        }
        if (anchor instanceof PsiSwitchLabelStatementBase) {
            PsiSwitchBlock block = ((PsiSwitchLabelStatementBase)anchor).getEnclosingSwitchBlock();
            if (block == null) {
                PsiElement psiElement = anchor;
                if (psiElement == null) {
                    VariableExtractor.$$$reportNull$$$0(24);
                }
                return psiElement;
            }
            anchor = block;
            if (anchor instanceof PsiExpression) {
                expr = (PsiExpression)anchor;
            }
        }
        if (anchor instanceof PsiStatement) {
            anchor = VariableExtractor.correctDueToSyntaxErrors(anchor);
        }
        Set allOccurrences = ((StreamEx)StreamEx.of((Object[])occurrences).filter(PsiElement::isPhysical)).append((Object)expr).toSet();
        PsiExpression firstOccurrence = Collections.min(allOccurrences, Comparator.comparing(e -> e.getTextRange().getStartOffset()));
        if (PsiUtil.isAvailable((JavaFeature)JavaFeature.PATTERNS, (PsiElement)anchor) && (cast = (PsiTypeCastExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)firstOccurrence), PsiTypeCastExpression.class)) != null) {
            PsiInstanceOfExpression candidate;
            PsiType castType = cast.getType();
            PsiExpression operand = cast.getOperand();
            if (castType != null && !(castType instanceof PsiPrimitiveType) && operand != null && operand.getType() != null && !castType.isAssignableFrom(operand.getType()) && !(PsiUtil.skipParenthesizedExprUp((PsiElement)firstOccurrence.getParent()) instanceof PsiExpressionStatement) && (candidate = InstanceOfUtils.findPatternCandidate((PsiTypeCastExpression)cast)) != null && allOccurrences.stream().map(occ -> (PsiTypeCastExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)occ), PsiTypeCastExpression.class)).allMatch(occ -> occ != null && (occ == firstOccurrence || InstanceOfUtils.findPatternCandidate((PsiTypeCastExpression)occ) == candidate))) {
                PsiInstanceOfExpression psiInstanceOfExpression = candidate;
                if (psiInstanceOfExpression == null) {
                    VariableExtractor.$$$reportNull$$$0(25);
                }
                return psiInstanceOfExpression;
            }
        }
        if (anchor instanceof PsiWhileStatement && (condition = (whileStatement = (PsiWhileStatement)anchor).getCondition()) != null && ContainerUtil.and((Iterable)allOccurrences, occurrence -> PsiTreeUtil.isAncestor((PsiElement)whileStatement, (PsiElement)occurrence, (boolean)true)) && firstOccurrence != null && PsiTreeUtil.isAncestor((PsiElement)condition, (PsiElement)firstOccurrence, (boolean)false) && !ExpressionUtils.isLoopInvariant((PsiExpression)firstOccurrence, (PsiLoopStatement)whileStatement)) {
            PsiPolyadicExpression polyadic = (PsiPolyadicExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)condition), PsiPolyadicExpression.class);
            if (polyadic != null && !PsiTreeUtil.isAncestor((PsiElement)firstOccurrence, (PsiElement)polyadic, (boolean)false) && JavaTokenType.ANDAND.equals(polyadic.getOperationTokenType())) {
                PsiExpression operand = (PsiExpression)ContainerUtil.find((Object[])polyadic.getOperands(), op -> PsiTreeUtil.isAncestor((PsiElement)op, (PsiElement)firstOccurrence, (boolean)false));
                LOG.assertTrue((operand = PsiUtil.skipParenthesizedExprDown((PsiExpression)operand)) != null);
                PsiExpression psiExpression = operand;
                if (psiExpression == null) {
                    VariableExtractor.$$$reportNull$$$0(26);
                }
                return psiExpression;
            }
            PsiExpression psiExpression = condition;
            if (psiExpression == null) {
                VariableExtractor.$$$reportNull$$$0(27);
            }
            return psiExpression;
        }
        if (firstOccurrence != null && CodeBlockSurrounder.canSurround((PsiExpression)firstOccurrence) && !PsiUtil.isAccessedForWriting((PsiExpression)firstOccurrence) && PsiTreeUtil.isAncestor((PsiElement)anchor, (PsiElement)(ancestorCandidate = ExpressionUtils.getTopLevelExpression((PsiExpression)firstOccurrence)), (boolean)false)) {
            PsiElement extractable;
            PsiElement statement = CommonJavaRefactoringUtil.getParentStatement((PsiElement)ancestorCandidate, (boolean)false);
            PsiElement psiElement = extractable = statement == null ? PsiTreeUtil.getParentOfType((PsiElement)ancestorCandidate, PsiField.class) : statement;
            if (ContainerUtil.and((Iterable)allOccurrences, occurrence -> PsiTreeUtil.isAncestor((PsiElement)extractable, (PsiElement)occurrence, (boolean)false) && (!PsiTreeUtil.isAncestor((PsiElement)ancestorCandidate, (PsiElement)occurrence, (boolean)false) || ReorderingUtils.canExtract((PsiExpression)ancestorCandidate, (PsiExpression)occurrence) == ThreeState.NO))) {
                PsiExpression psiExpression = firstOccurrence;
                if (psiExpression == null) {
                    VariableExtractor.$$$reportNull$$$0(28);
                }
                return psiExpression;
            }
        }
        if (anchor instanceof PsiTryStatement && firstOccurrence != null) {
            PsiResourceList resourceList = ((PsiTryStatement)anchor).getResourceList();
            PsiElement parent = firstOccurrence.getParent();
            if (resourceList != null && parent instanceof PsiResourceExpression && parent.getParent() == resourceList && InheritanceUtil.isInheritor((PsiType)firstOccurrence.getType(), (String)"java.lang.AutoCloseable")) {
                PsiElement psiElement = parent;
                if (psiElement == null) {
                    VariableExtractor.$$$reportNull$$$0(29);
                }
                return psiElement;
            }
        }
        if (anchor.getParent() instanceof PsiSwitchLabeledRuleStatement) {
            PsiExpression psiExpression = ExpressionUtils.getTopLevelExpression((PsiExpression)expr);
            if (psiExpression == null) {
                VariableExtractor.$$$reportNull$$$0(30);
            }
            return psiExpression;
        }
        if (CommonJavaRefactoringUtil.isLoopOrIf((PsiElement)anchor.getParent())) {
            PsiElement psiElement = anchor;
            if (psiElement == null) {
                VariableExtractor.$$$reportNull$$$0(31);
            }
            return psiElement;
        }
        PsiElement child = VariableExtractor.locateAnchor(anchor);
        PsiElement psiElement = child == null ? anchor : child;
        if (psiElement == null) {
            VariableExtractor.$$$reportNull$$$0(32);
        }
        return psiElement;
    }

    @NotNull
    private static PsiElement correctDueToSyntaxErrors(@NotNull PsiElement anchor) {
        if (anchor == null) {
            VariableExtractor.$$$reportNull$$$0(33);
        }
        while (true) {
            PsiElement prevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)anchor);
            PsiElement prevStatement = null;
            if (prevSibling instanceof PsiErrorElement) {
                prevStatement = PsiTreeUtil.getPrevSiblingOfType((PsiElement)prevSibling, PsiStatement.class);
            } else if (prevSibling instanceof PsiStatement) {
                PsiElement lastChild;
                for (lastChild = prevSibling; lastChild != null && !(lastChild instanceof PsiErrorElement); lastChild = lastChild.getLastChild()) {
                }
                if (lastChild != null) {
                    prevStatement = prevSibling;
                }
            }
            if (prevStatement == null) break;
            anchor = prevStatement;
        }
        PsiElement psiElement = anchor;
        if (psiElement == null) {
            VariableExtractor.$$$reportNull$$$0(34);
        }
        return psiElement;
    }

    private static PsiElement locateAnchor(PsiElement child) {
        PsiElement prev;
        while (child != null && !((prev = child.getPrevSibling()) instanceof PsiStatement) && !PsiUtil.isJavaToken((PsiElement)prev, (IElementType)JavaTokenType.LBRACE)) {
            child = prev;
        }
        while (child instanceof PsiWhiteSpace || child instanceof PsiComment) {
            child = child.getNextSibling();
        }
        return child;
    }

    @Nullable
    public static PsiVariable introduce(@NotNull Project project, @NotNull PsiExpression expr, @Nullable Editor editor, @NotNull PsiElement anchorStatement, PsiExpression @NotNull [] occurrences, @NotNull IntroduceVariableSettings settings) {
        if (project == null) {
            VariableExtractor.$$$reportNull$$$0(35);
        }
        if (expr == null) {
            VariableExtractor.$$$reportNull$$$0(36);
        }
        if (anchorStatement == null) {
            VariableExtractor.$$$reportNull$$$0(37);
        }
        if (settings == null) {
            VariableExtractor.$$$reportNull$$$0(38);
        }
        if (occurrences == null) {
            VariableExtractor.$$$reportNull$$$0(39);
        }
        Computable computation = new VariableExtractor(project, expr, editor, anchorStatement, occurrences, settings)::extractVariable;
        PsiFile file = expr.getContainingFile();
        SmartPsiElementPointer pointer = (SmartPsiElementPointer)ApplicationManager.getApplication().runWriteAction(computation);
        if (pointer != null) {
            PsiVariable var = (PsiVariable)pointer.getElement();
            if (var == null) {
                throw new RuntimeExceptionWithAttachments("Refactoring is interrupted due to syntax errors in the file", new Attachment[]{new Attachment("expression.txt", expr.getText()), new Attachment("source.java", file.getText())});
            }
            return var;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 11, 12, 13, 18, 19, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorStatement";
                break;
            }
            case 3: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 22: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occurrences";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/introduceVariable/VariableExtractor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: 
            case 15: 
            case 21: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedType";
                break;
            }
            case 20: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/introduceVariable/VariableExtractor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "extractVariable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "addVariable";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeclaration";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "stripNullabilityAnnotationsFromTargetType";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "correctAnchor";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "correctDueToSyntaxErrors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addVariable";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDeclaration";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addDeclaration";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryFixSurroundContext";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "stripNullabilityAnnotationsFromTargetType";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "correctAnchor";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "correctDueToSyntaxErrors";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "introduce";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8, 11, 12, 13, 18, 19, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 34 -> new IllegalStateException(string);
        };
    }
}

