/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.makeStatic;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.model.PsiElementUsageInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.ConflictsDialogBase;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.makeStatic.ChainedCallUsageInfo;
import com.intellij.refactoring.makeStatic.InternalUsageInfo;
import com.intellij.refactoring.makeStatic.MakeMethodOrClassStaticViewDescriptor;
import com.intellij.refactoring.makeStatic.MakeMethodStaticProcessor;
import com.intellij.refactoring.makeStatic.MakeStaticUtil;
import com.intellij.refactoring.makeStatic.OverridingMethodUsageInfo;
import com.intellij.refactoring.makeStatic.SelfUsageInfo;
import com.intellij.refactoring.makeStatic.Settings;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MakeMethodOrClassStaticProcessor<T extends PsiTypeParameterListOwner>
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(MakeMethodStaticProcessor.class);
    protected T myMember;
    protected Settings mySettings;

    public MakeMethodOrClassStaticProcessor(Project project, T member, Settings settings) {
        super(project);
        this.myMember = member;
        this.mySettings = settings;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MakeMethodOrClassStaticProcessor.$$$reportNull$$$0(0);
        }
        return new MakeMethodOrClassStaticViewDescriptor((PsiMember)this.myMember);
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.makeStatic";
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(this.myMember);
        return data;
    }

    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MakeMethodOrClassStaticProcessor.$$$reportNull$$$0(1);
        }
        RefactoringEventData data = new RefactoringEventData();
        data.addElement(this.myMember);
        return data;
    }

    protected final boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        MultiMap<PsiElement, String> conflictDescriptions;
        if (refUsages == null) {
            MakeMethodOrClassStaticProcessor.$$$reportNull$$$0(2);
        }
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        if (ApplicationManager.getApplication().isUnitTestMode() && !BaseRefactoringProcessor.ConflictsInTestsException.isTestIgnore() && !(conflictDescriptions = this.getConflictDescriptions(usagesIn)).isEmpty()) {
            throw new BaseRefactoringProcessor.ConflictsInTestsException(conflictDescriptions.values());
        }
        if (this.myPrepareSuccessfulSwingThreadCallback != null) {
            ConflictsDialogBase conflictsDialog;
            MultiMap<PsiElement, String> conflicts = this.getConflictDescriptions(usagesIn);
            if (conflicts.size() > 0 && !(conflictsDialog = this.prepareConflictsDialog(conflicts, (UsageInfo[])refUsages.get())).showAndGet()) {
                if (conflictsDialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
            if (!this.mySettings.isChangeSignature()) {
                refUsages.set((Object)MakeMethodOrClassStaticProcessor.filterInternalUsages(usagesIn));
            }
        }
        LinkedHashSet<UsageInfo> toMakeStatic = new LinkedHashSet<UsageInfo>();
        refUsages.set((Object)MakeMethodOrClassStaticProcessor.filterOverriding(usagesIn, toMakeStatic));
        if (!this.findAdditionalMembers(toMakeStatic)) {
            return false;
        }
        this.prepareSuccessful();
        return true;
    }

    protected boolean findAdditionalMembers(Set<UsageInfo> toMakeStatic) {
        return true;
    }

    private static UsageInfo[] filterOverriding(UsageInfo[] usages, Set<? super UsageInfo> suggestToMakeStatic) {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (usage instanceof ChainedCallUsageInfo) {
                suggestToMakeStatic.add((UsageInfo)usage);
                continue;
            }
            if (usage instanceof OverridingMethodUsageInfo) continue;
            result.add(usage);
        }
        return result.toArray(UsageInfo.EMPTY_ARRAY);
    }

    private static UsageInfo[] filterInternalUsages(UsageInfo[] usages) {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (usage instanceof InternalUsageInfo) continue;
            result.add(usage);
        }
        return result.toArray(UsageInfo.EMPTY_ARRAY);
    }

    protected MultiMap<PsiElement, @Nls String> getConflictDescriptions(UsageInfo[] usages) {
        MultiMap conflicts = new MultiMap();
        HashSet<PsiElement> processed = new HashSet<PsiElement>();
        String typeString = StringUtil.capitalize((String)UsageViewUtil.getType(this.myMember));
        for (UsageInfo usageInfo : usages) {
            if (usageInfo instanceof InternalUsageInfo && !(usageInfo instanceof SelfUsageInfo)) {
                PsiElement referencedElement = ((InternalUsageInfo)usageInfo).getReferencedElement();
                if (!this.mySettings.isMakeClassParameter()) {
                    if (referencedElement instanceof PsiModifierListOwner && ((PsiModifierListOwner)referencedElement).hasModifierProperty("static") || processed.contains(referencedElement)) continue;
                    processed.add(referencedElement);
                    if (referencedElement instanceof PsiField) {
                        PsiField field = (PsiField)referencedElement;
                        if (this.mySettings.getNameForField(field) == null) {
                            message = JavaRefactoringBundle.message((String)"0.uses.non.static.1.which.is.not.passed.as.a.parameter", (Object[])new Object[]{typeString, RefactoringUIUtil.getDescription((PsiElement)field, (boolean)true)});
                            conflicts.putValue((Object)field, (Object)message);
                        }
                    } else {
                        message = JavaRefactoringBundle.message((String)"0.uses.1.which.needs.class.instance", (Object[])new Object[]{typeString, RefactoringUIUtil.getDescription((PsiElement)referencedElement, (boolean)true)});
                        conflicts.putValue((Object)referencedElement, (Object)message);
                    }
                }
            }
            if (usageInfo instanceof OverridingMethodUsageInfo) {
                LOG.assertTrue(this.myMember instanceof PsiMethod);
                PsiMethod overridingMethod = (PsiMethod)usageInfo.getElement();
                String message = JavaRefactoringBundle.message((String)"method.0.is.overridden.by.1", (Object[])new Object[]{RefactoringUIUtil.getDescription(this.myMember, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)overridingMethod, (boolean)true)});
                conflicts.putValue((Object)overridingMethod, (Object)message);
                continue;
            }
            PsiElement element = usageInfo.getElement();
            PsiElement container = ConflictsUtil.getContainer(element);
            if (processed.contains(container)) continue;
            processed.add(container);
            List<Settings.FieldParameter> fieldParameters = this.mySettings.getParameterOrderList();
            ArrayList<PsiField> inaccessible = new ArrayList<PsiField>();
            for (Settings.FieldParameter fieldParameter : fieldParameters) {
                if (PsiUtil.isAccessible((PsiMember)fieldParameter.field, (PsiElement)element, null)) continue;
                inaccessible.add(fieldParameter.field);
            }
            if (inaccessible.isEmpty()) continue;
            MakeMethodOrClassStaticProcessor.createInaccessibleFieldsConflictDescription(inaccessible, container, (MultiMap<PsiElement, String>)conflicts);
        }
        return conflicts;
    }

    private static void createInaccessibleFieldsConflictDescription(ArrayList<PsiField> inaccessible, PsiElement container, MultiMap<PsiElement, String> conflicts) {
        for (PsiField field : inaccessible) {
            conflicts.putValue((Object)field, (Object)JavaRefactoringBundle.message((String)"field.0.is.not.accessible", (Object[])new Object[]{CommonRefactoringUtil.htmlEmphasize((String)field.getName()), RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true)}));
        }
    }

    protected UsageInfo @NotNull [] findUsages() {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        ContainerUtil.addAll(result, (Object[])MakeStaticUtil.findClassRefsInMember(this.myMember, true));
        if (this.mySettings.isReplaceUsages()) {
            this.findExternalUsages(result);
        }
        if (this.myMember instanceof PsiMethod) {
            PsiMethod[] overridingMethods;
            for (PsiMethod overridingMethod : overridingMethods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)((PsiMethod)this.myMember), (SearchScope)this.myMember.getUseScope(), (boolean)false).toArray((Object[])PsiMethod.EMPTY_ARRAY)) {
                if (overridingMethod == this.myMember) continue;
                result.add(new OverridingMethodUsageInfo(overridingMethod));
            }
        }
        UsageInfo[] usageInfoArray = result.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            MakeMethodOrClassStaticProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    protected abstract void findExternalUsages(ArrayList<UsageInfo> var1);

    protected void findExternalReferences(PsiMethod method, ArrayList<UsageInfo> result) {
        for (PsiReference ref : ReferencesSearch.search((PsiElement)method).asIterable()) {
            PsiElement element = ref.getElement();
            PsiExpression qualifier = null;
            if (element instanceof PsiReferenceExpression && (qualifier = ((PsiReferenceExpression)element).getQualifierExpression()) instanceof PsiThisExpression) {
                qualifier = null;
            }
            if (!PsiTreeUtil.isAncestor(this.myMember, (PsiElement)element, (boolean)true) || qualifier != null) {
                result.add((UsageInfo)new PsiElementUsageInfo(element));
            }
            this.processExternalReference(element, method, result);
        }
    }

    protected void processExternalReference(PsiElement element, PsiMethod method, ArrayList<UsageInfo> result) {
    }

    protected void setupTypeParameterList(T member) throws IncorrectOperationException {
        PsiTypeParameterList list = member.getTypeParameterList();
        assert (list != null);
        PsiTypeParameterList newList = CommonJavaRefactoringUtil.createTypeParameterListWithUsedTypeParameters((PsiElement[])new PsiElement[]{member});
        if (newList != null) {
            list.replace((PsiElement)newList);
        }
    }

    protected boolean makeClassParameterFinal(UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            PsiField field;
            PsiElement psiElement;
            InternalUsageInfo internalUsageInfo;
            if (!(usage instanceof InternalUsageInfo) || !(internalUsageInfo = (InternalUsageInfo)usage).isInsideAnonymous() || (psiElement = internalUsageInfo.getReferencedElement()) instanceof PsiField && this.mySettings.getNameForField(field = (PsiField)psiElement) != null) continue;
            return true;
        }
        return false;
    }

    protected static boolean makeFieldParameterFinal(PsiField field, UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            PsiField refField;
            PsiElement psiElement;
            InternalUsageInfo internalUsageInfo;
            if (!(usage instanceof InternalUsageInfo) || !(internalUsageInfo = (InternalUsageInfo)usage).isInsideAnonymous() || !((psiElement = internalUsageInfo.getReferencedElement()) instanceof PsiField) || !field.equals((Object)(refField = (PsiField)psiElement))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected String getCommandName() {
        String string = JavaRefactoringBundle.message((String)"make.static.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName(this.myMember)});
        if (string == null) {
            MakeMethodOrClassStaticProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    public T getMember() {
        return this.myMember;
    }

    public Settings getSettings() {
        return this.mySettings;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MakeMethodOrClassStaticProcessor.$$$reportNull$$$0(5);
        }
        PsiManager manager = this.myMember.getManager();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
        try {
            for (UsageInfo usage : usages) {
                if (usage instanceof SelfUsageInfo) {
                    this.changeSelfUsage((SelfUsageInfo)usage);
                    continue;
                }
                if (usage instanceof InternalUsageInfo) {
                    this.changeInternalUsage((InternalUsageInfo)usage, factory);
                    continue;
                }
                this.changeExternalUsage(usage, factory);
            }
            this.changeSelf(factory, usages);
        }
        catch (IncorrectOperationException ex) {
            LOG.error((Throwable)ex);
        }
    }

    protected abstract void changeSelf(PsiElementFactory var1, UsageInfo[] var2) throws IncorrectOperationException;

    protected abstract void changeSelfUsage(SelfUsageInfo var1) throws IncorrectOperationException;

    protected abstract void changeInternalUsage(InternalUsageInfo var1, PsiElementFactory var2) throws IncorrectOperationException;

    protected abstract void changeExternalUsage(UsageInfo var1, PsiElementFactory var2) throws IncorrectOperationException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/makeStatic/MakeMethodOrClassStaticProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/makeStatic/MakeMethodOrClassStaticProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

