/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.makeStatic;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfoImpl;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureUsageProcessor;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.changeSignature.ThrownExceptionInfo;
import com.intellij.refactoring.makeStatic.ChainedCallUsageInfo;
import com.intellij.refactoring.makeStatic.InternalUsageInfo;
import com.intellij.refactoring.makeStatic.MakeMethodOrClassStaticProcessor;
import com.intellij.refactoring.makeStatic.MakeStaticJavaCallerChooser;
import com.intellij.refactoring.makeStatic.SelfUsageInfo;
import com.intellij.refactoring.makeStatic.Settings;
import com.intellij.refactoring.util.CanonicalTypes;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.javadoc.MethodJavaDocHelper;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import org.jetbrains.annotations.Nullable;

public class MakeMethodStaticProcessor
extends MakeMethodOrClassStaticProcessor<PsiMethod> {
    private static final Logger LOG = Logger.getInstance(MakeMethodStaticProcessor.class);
    @Nullable
    private List<PsiMethod> myAdditionalMethods;

    public MakeMethodStaticProcessor(Project project, PsiMethod method, Settings settings) {
        super(project, method, settings);
    }

    @Override
    protected boolean findAdditionalMembers(final Set<UsageInfo> toMakeStatic) {
        if (!toMakeStatic.isEmpty()) {
            this.myAdditionalMethods = new ArrayList<PsiMethod>();
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                for (UsageInfo usageInfo : toMakeStatic) {
                    this.myAdditionalMethods.add((PsiMethod)usageInfo.getElement());
                }
            } else {
                MakeStaticJavaCallerChooser chooser = new MakeStaticJavaCallerChooser(this, (PsiMethod)this.myMember, this.myProject, methods -> this.myAdditionalMethods.addAll((Collection<PsiMethod>)methods)){

                    @Override
                    protected ArrayList<UsageInfo> getTopLevelItems() {
                        return new ArrayList<UsageInfo>(toMakeStatic);
                    }
                };
                TreeUtil.expand((JTree)chooser.getTree(), (int)2);
                if (!chooser.showAndGet()) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected MultiMap<PsiElement, String> getConflictDescriptions(UsageInfo[] usages) {
        MultiMap<PsiElement, String> descriptions = super.getConflictDescriptions(usages);
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            if (!(element instanceof PsiMethodReferenceExpression) || !this.needLambdaConversion((PsiMethodReferenceExpression)element)) continue;
            descriptions.putValue((Object)element, (Object)JavaBundle.message((String)"refactoring.method.reference.to.lambda.conflict", (Object[])new Object[0]));
        }
        return descriptions;
    }

    @Override
    protected void changeSelfUsage(SelfUsageInfo usageInfo) throws IncorrectOperationException {
        PsiElement element = usageInfo.getElement();
        PsiElement parent = element.getParent();
        if (element instanceof PsiMethodReferenceExpression) {
            if (this.needLambdaConversion((PsiMethodReferenceExpression)element)) {
                PsiMethodCallExpression methodCallExpression = MakeMethodStaticProcessor.getMethodCallExpression((PsiMethodReferenceExpression)element);
                if (methodCallExpression == null) {
                    return;
                }
                parent = methodCallExpression;
            } else {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)parent.getProject());
                PsiClass memberClass = ((PsiMethod)this.myMember).getContainingClass();
                LOG.assertTrue(memberClass != null);
                PsiElement qualifier = ((PsiMethodReferenceExpression)element).getQualifier();
                LOG.assertTrue(qualifier != null);
                qualifier.replace((PsiElement)factory.createReferenceExpression(memberClass));
                return;
            }
        }
        LOG.assertTrue(parent instanceof PsiMethodCallExpression, (Object)parent);
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)parent;
        PsiExpression qualifier = methodCall.getMethodExpression().getQualifierExpression();
        if (qualifier != null) {
            qualifier.delete();
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)methodCall.getProject());
        PsiExpressionList args = methodCall.getArgumentList();
        PsiElement addParameterAfter = null;
        if (this.mySettings.isMakeClassParameter()) {
            PsiExpression arg = factory.createExpressionFromText(this.mySettings.getClassParameterName(), null);
            addParameterAfter = args.addAfter((PsiElement)arg, null);
        }
        if (this.mySettings.isMakeFieldParameters()) {
            List<Settings.FieldParameter> parameters = this.mySettings.getParameterOrderList();
            for (Settings.FieldParameter fieldParameter : parameters) {
                PsiExpression arg = factory.createExpressionFromText(fieldParameter.name, null);
                if (addParameterAfter == null) {
                    addParameterAfter = args.addAfter((PsiElement)arg, null);
                    continue;
                }
                addParameterAfter = args.addAfter((PsiElement)arg, addParameterAfter);
            }
        }
    }

    @Override
    protected void changeSelf(PsiElementFactory factory, UsageInfo[] usages) throws IncorrectOperationException {
        MethodJavaDocHelper javaDocHelper = new MethodJavaDocHelper((PsiMethod)this.myMember);
        PsiParameterList paramList = ((PsiMethod)this.myMember).getParameterList();
        PsiElement addParameterAfter = null;
        PsiDocTag anchor = null;
        PsiClass containingClass = ((PsiMethod)this.myMember).getContainingClass();
        LOG.assertTrue(containingClass != null);
        if (this.mySettings.isDelegate()) {
            ArrayList<ParameterInfoImpl> params = new ArrayList<ParameterInfoImpl>();
            PsiParameter[] parameters = ((PsiMethod)this.myMember).getParameterList().getParameters();
            if (this.mySettings.isMakeClassParameter()) {
                params.add(ParameterInfoImpl.createNew().withName(this.mySettings.getClassParameterName()).withType((PsiType)factory.createType(containingClass, PsiSubstitutor.EMPTY)).withDefaultValue("this"));
            }
            if (this.mySettings.isMakeFieldParameters()) {
                for (Settings.FieldParameter parameter : this.mySettings.getParameterOrderList()) {
                    params.add(ParameterInfoImpl.createNew().withName(this.mySettings.getClassParameterName()).withType(parameter.type).withDefaultValue(parameter.field.getName()));
                }
            }
            for (int i = 0; i < parameters.length; ++i) {
                params.add(ParameterInfoImpl.create((int)i));
            }
            PsiType returnType = ((PsiMethod)this.myMember).getReturnType();
            LOG.assertTrue(returnType != null);
            JavaChangeSignatureUsageProcessor.generateDelegate((JavaChangeInfo)new JavaChangeInfoImpl(VisibilityUtil.getVisibilityModifier((PsiModifierList)((PsiMethod)this.myMember).getModifierList()), (PsiMethod)this.myMember, ((PsiMethod)this.myMember).getName(), CanonicalTypes.createTypeWrapper((PsiType)returnType), params.toArray(new ParameterInfoImpl[0]), new ThrownExceptionInfo[0], false, Collections.emptySet(), Collections.emptySet()));
        }
        if (this.mySettings.isMakeClassParameter()) {
            PsiClassType parameterType = factory.createType(containingClass, PsiSubstitutor.EMPTY);
            String classParameterName = this.mySettings.getClassParameterName();
            PsiParameter parameter = factory.createParameter(classParameterName, (PsiType)parameterType);
            if (this.makeClassParameterFinal(usages)) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)parameter, (String)"final", (boolean)true);
            }
            addParameterAfter = paramList.addAfter((PsiElement)parameter, null);
            anchor = javaDocHelper.addParameterAfter(classParameterName, null);
        }
        if (this.mySettings.isMakeFieldParameters()) {
            List<Settings.FieldParameter> parameters = this.mySettings.getParameterOrderList();
            for (Settings.FieldParameter fieldParameter : parameters) {
                PsiType fieldParameterType = fieldParameter.field.getType();
                PsiParameter parameter = factory.createParameter(fieldParameter.name, fieldParameterType);
                if (MakeMethodStaticProcessor.makeFieldParameterFinal(fieldParameter.field, usages)) {
                    PsiUtil.setModifierProperty((PsiModifierListOwner)parameter, (String)"final", (boolean)true);
                }
                addParameterAfter = paramList.addAfter((PsiElement)parameter, addParameterAfter);
                anchor = javaDocHelper.addParameterAfter(fieldParameter.name, anchor);
            }
        }
        this.makeStatic((PsiMethod)this.myMember);
        if (this.myAdditionalMethods != null) {
            for (PsiMethod method : this.myAdditionalMethods) {
                this.makeStatic(method);
            }
        }
    }

    private void makeStatic(PsiMethod member) {
        PsiAnnotation overrideAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, (String[])new String[]{"java.lang.Override"});
        if (overrideAnnotation != null) {
            overrideAnnotation.delete();
        }
        this.setupTypeParameterList(member);
        PsiModifierList modifierList = member.getModifierList();
        modifierList.setModifierProperty("static", true);
        modifierList.setModifierProperty("final", false);
        modifierList.setModifierProperty("default", false);
        PsiReceiverParameter receiverParameter = (PsiReceiverParameter)PsiTreeUtil.getChildOfType((PsiElement)member.getParameterList(), PsiReceiverParameter.class);
        if (receiverParameter != null) {
            receiverParameter.delete();
        }
    }

    @Override
    protected void changeInternalUsage(InternalUsageInfo usage, PsiElementFactory factory) throws IncorrectOperationException {
        if (!this.mySettings.isChangeSignature()) {
            return;
        }
        PsiElement element = usage.getElement();
        if (element instanceof PsiReferenceExpression) {
            String name;
            PsiElement resolved;
            PsiReferenceExpression newRef = null;
            if (this.mySettings.isMakeFieldParameters() && (resolved = ((PsiReferenceExpression)element).resolve()) instanceof PsiField && (name = this.mySettings.getNameForField((PsiField)resolved)) != null) {
                newRef = (PsiReferenceExpression)factory.createExpressionFromText(name, null);
            }
            if (newRef == null && this.mySettings.isMakeClassParameter()) {
                newRef = (PsiReferenceExpression)factory.createExpressionFromText(this.mySettings.getClassParameterName() + "." + element.getText(), null);
            }
            if (newRef != null) {
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
                newRef = (PsiReferenceExpression)codeStyleManager.reformat(newRef);
                element.replace((PsiElement)newRef);
            }
        } else if (element instanceof PsiThisExpression && this.mySettings.isMakeClassParameter()) {
            element.replace((PsiElement)factory.createExpressionFromText(this.mySettings.getClassParameterName(), null));
        } else if (element instanceof PsiSuperExpression && this.mySettings.isMakeClassParameter()) {
            element.replace((PsiElement)factory.createExpressionFromText(this.mySettings.getClassParameterName(), null));
        } else if (element instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)element;
            if (this.mySettings.isMakeClassParameter()) {
                LOG.assertTrue(newExpression.getQualifier() == null);
                String newText = this.mySettings.getClassParameterName() + "." + newExpression.getText();
                PsiExpression expr = factory.createExpressionFromText(newText, null);
                element.replace((PsiElement)expr);
            }
        }
    }

    @Override
    protected void changeExternalUsage(UsageInfo usage, PsiElementFactory factory) throws IncorrectOperationException {
        int copyingSafetyLevel;
        PsiReferenceExpression newQualifier;
        PsiMethodReferenceExpression methodRef;
        PsiElement element = usage.getElement();
        if (!(element instanceof PsiReferenceExpression)) {
            return;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)element;
        if (ref instanceof PsiMethodReferenceExpression && this.needLambdaConversion(methodRef = (PsiMethodReferenceExpression)ref)) {
            PsiMethodCallExpression expression = MakeMethodStaticProcessor.getMethodCallExpression(methodRef);
            if (expression == null) {
                return;
            }
            ref = expression.getMethodExpression();
        }
        PsiElement parent = ref.getParent();
        PsiExpression instanceRef = ref.getQualifierExpression();
        PsiClass memberClass = ((PsiMethod)this.myMember).getContainingClass();
        if (instanceRef == null || instanceRef instanceof PsiSuperExpression) {
            String name;
            PsiClass contextClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiClass.class);
            Object qualifier = "";
            if (memberClass != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)contextClass, (PsiClass)memberClass, (boolean)true) && (name = memberClass.getQualifiedName()) != null) {
                qualifier = name + ".";
            }
            instanceRef = factory.createExpressionFromText((String)qualifier + "this", null);
            newQualifier = null;
        } else {
            PsiReferenceExpression psiReferenceExpression = newQualifier = memberClass == null || memberClass instanceof PsiAnonymousClass ? null : factory.createReferenceExpression(memberClass);
        }
        if (this.mySettings.getNewParametersNumber() > 1 && (copyingSafetyLevel = RefactoringUtil.verifySafeCopyExpression((PsiElement)instanceRef)) == 2) {
            String tempVar = RefactoringUtil.createTempVar(instanceRef, parent, true);
            instanceRef = factory.createExpressionFromText(tempVar, null);
        }
        PsiElement anchor = null;
        PsiExpressionList argList = null;
        PsiExpression[] exprs = PsiExpression.EMPTY_ARRAY;
        if (parent instanceof PsiMethodCallExpression) {
            argList = ((PsiMethodCallExpression)parent).getArgumentList();
            exprs = argList.getExpressions();
            if (this.mySettings.isMakeClassParameter()) {
                anchor = exprs.length > 0 ? argList.addBefore((PsiElement)instanceRef, (PsiElement)exprs[0]) : argList.add((PsiElement)instanceRef);
            }
        }
        if (this.mySettings.isMakeFieldParameters()) {
            List<Settings.FieldParameter> parameters = this.mySettings.getParameterOrderList();
            for (Settings.FieldParameter fieldParameter : parameters) {
                PsiReferenceExpression fieldRef;
                if (newQualifier != null) {
                    fieldRef = (PsiReferenceExpression)factory.createExpressionFromText("a." + fieldParameter.field.getName(), null);
                    fieldRef.getQualifierExpression().replace((PsiElement)instanceRef);
                } else {
                    fieldRef = (PsiReferenceExpression)factory.createExpressionFromText(fieldParameter.field.getName(), null);
                }
                if (anchor != null) {
                    anchor = argList.addAfter((PsiElement)fieldRef, anchor);
                    continue;
                }
                if (argList == null) continue;
                if (exprs.length > 0) {
                    anchor = argList.addBefore((PsiElement)fieldRef, (PsiElement)exprs[0]);
                    continue;
                }
                anchor = argList.add((PsiElement)fieldRef);
            }
        }
        if (newQualifier != null) {
            ref.getQualifierExpression().replace((PsiElement)newQualifier);
        }
    }

    private static PsiMethodCallExpression getMethodCallExpression(PsiMethodReferenceExpression methodRef) {
        PsiLambdaExpression lambdaExpression = LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)methodRef, (boolean)true, (boolean)true);
        List returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)lambdaExpression);
        if (returnExpressions.size() != 1) {
            return null;
        }
        PsiExpression expression = (PsiExpression)returnExpressions.get(0);
        if (!(expression instanceof PsiMethodCallExpression)) {
            return null;
        }
        return (PsiMethodCallExpression)expression;
    }

    private boolean needLambdaConversion(PsiMethodReferenceExpression methodRef) {
        if (((PsiMethod)this.myMember).getContainingClass() instanceof PsiAnonymousClass) {
            return true;
        }
        if (this.mySettings.isMakeFieldParameters()) {
            return true;
        }
        if (PsiMethodReferenceUtil.isResolvedBySecondSearch((PsiMethodReferenceExpression)methodRef)) {
            return ((PsiMethod)this.myMember).getParameters().length != 0 || !this.mySettings.isMakeClassParameter();
        }
        return this.mySettings.isMakeClassParameter();
    }

    @Override
    protected void findExternalUsages(ArrayList<UsageInfo> result) {
        if (this.mySettings.isDelegate()) {
            return;
        }
        this.findExternalReferences((PsiMethod)this.myMember, result);
    }

    @Override
    protected void processExternalReference(PsiElement element, PsiMethod method, ArrayList<UsageInfo> result) {
        PsiMethod containingMethod;
        if (!this.mySettings.isChangeSignature() && (containingMethod = MakeStaticJavaCallerChooser.isTheLastClassRef(element, method)) != null && !TestFrameworks.getInstance().isTestMethod(containingMethod)) {
            result.add(new ChainedCallUsageInfo((PsiElement)containingMethod));
        }
    }
}

