/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.memberPushDown;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.memberPushDown.PushDownDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.refactoring.util.classMembers.MemberInfoStorage;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaPushDownHandler
implements ElementsHandler,
ContextAwareActionHandler {
    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext dataContext) {
        List elements;
        if (editor == null) {
            JavaPushDownHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JavaPushDownHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            JavaPushDownHandler.$$$reportNull$$$0(2);
        }
        if ((elements = CommonRefactoringUtil.findElementsFromCaretsAndSelections((Editor)editor, (PsiFile)file, PsiCodeBlock.class, e -> e instanceof PsiMember)).isEmpty()) {
            return false;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)elements.get(0)), PsiClass.class, (boolean)false);
        if (psiClass == null) {
            return false;
        }
        return ClassInheritorsSearch.search((PsiClass)psiClass).asIterable().iterator().hasNext();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            JavaPushDownHandler.$$$reportNull$$$0(3);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        List elements = CommonRefactoringUtil.findElementsFromCaretsAndSelections((Editor)editor, (PsiFile)file, null, e -> e instanceof PsiMember);
        this.invoke(project, elements.toArray(PsiElement.EMPTY_ARRAY), dataContext);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        Editor editor;
        PsiClass parentClass;
        PsiElement parent;
        if (project == null) {
            JavaPushDownHandler.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            JavaPushDownHandler.$$$reportNull$$$0(5);
        }
        PsiClass aClass = (parent = PsiTreeUtil.findCommonParent((PsiElement[])elements)) instanceof PsiClass ? (parentClass = (PsiClass)parent) : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class, (boolean)false);
        Editor editor2 = editor = dataContext != null ? (Editor)CommonDataKeys.EDITOR.getData(dataContext) : null;
        if (aClass == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.push.members.from"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)JavaPushDownHandler.getRefactoringName(), (String)"refactoring.pushMembersDown");
            return;
        }
        if (aClass instanceof JspClass) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"refactoring.is.not.supported.for.jsp.classes", (Object[])new Object[0]));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)JavaPushDownHandler.getRefactoringName(), (String)"refactoring.pushMembersDown");
            return;
        }
        if (aClass instanceof PsiAnonymousClass) {
            String message = JavaRefactoringBundle.message((String)"class.is.anonymous.warning.message", (Object[])new Object[0]);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)JavaPushDownHandler.getRefactoringName(), (String)"refactoring.pushMembersDown");
            return;
        }
        if (aClass.hasModifierProperty("final")) {
            String message = JavaRefactoringBundle.message((String)"class.is.final.warning.message", (Object[])new Object[0]);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)JavaPushDownHandler.getRefactoringName(), (String)"refactoring.pushMembersDown");
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)aClass)) {
            return;
        }
        HashSet selectedMembers = new HashSet();
        Collections.addAll(selectedMembers, elements);
        MemberInfoStorage memberInfoStorage = new MemberInfoStorage(aClass, (MemberInfoBase.Filter<PsiMember>)((MemberInfoBase.Filter)element -> !(element instanceof PsiEnumConstant)));
        List members = memberInfoStorage.getClassMemberInfos((PsiElement)aClass);
        for (MemberInfo memberInfo : members) {
            if (!selectedMembers.contains(memberInfo.getMember())) continue;
            memberInfo.setChecked(true);
        }
        PushDownDialog dialog = new PushDownDialog(project, members.toArray(new MemberInfo[0]), aClass);
        dialog.show();
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return ContainerUtil.exists((Object[])elements, element -> element instanceof PsiMember);
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"push.members.down.title");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/memberPushDown/JavaPushDownHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableForQuickList";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

