/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.move.moveClassesOrPackages.ModuleInfoModifyUsageDetector;
import com.intellij.refactoring.safeDelete.ModuleInfoSafeDeleteUsageDetector;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SmartHashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class ModuleInfoUsageDetector {
    protected final Project myProject;
    protected final MultiMap<PsiDirectory, PsiClass> mySourceClassesByDir;

    protected ModuleInfoUsageDetector(@NotNull Project project, PsiElement @NotNull [] elements) {
        if (project == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.mySourceClassesByDir = ModuleInfoUsageDetector.groupClassesByDir(elements);
    }

    @NotNull
    public static ModuleInfoUsageDetector createModifyUsageInstance(@NotNull Project project, PsiElement @NotNull [] elementsToMove, @NotNull MoveDestination moveDestination) {
        if (project == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(2);
        }
        if (moveDestination == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(3);
        }
        if (elementsToMove == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(4);
        }
        return new ModuleInfoModifyUsageDetector(project, elementsToMove, moveDestination);
    }

    @NotNull
    public static ModuleInfoUsageDetector createSafeDeleteUsageInstance(@NotNull Project project, PsiElement @NotNull [] elementsToDelete) {
        if (project == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(5);
        }
        if (elementsToDelete == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(6);
        }
        return new ModuleInfoSafeDeleteUsageDetector(project, elementsToDelete);
    }

    public abstract void detectModuleStatementsUsed(@NotNull List<? super UsageInfo> var1, @NotNull MultiMap<PsiElement, String> var2);

    @NotNull
    public abstract List<UsageInfo> createUsageInfosForNewlyCreatedDirs();

    @NotNull
    private static MultiMap<PsiDirectory, PsiClass> groupClassesByDir(PsiElement @NotNull [] elementsToMove) {
        PsiElement firstElement;
        if (elementsToMove == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(7);
        }
        if ((firstElement = (PsiElement)ArrayUtil.getFirstElement((Object[])elementsToMove)) == null || !PsiUtil.isAvailable((JavaFeature)JavaFeature.MODULES, (PsiElement)firstElement)) {
            MultiMap multiMap = MultiMap.empty();
            if (multiMap == null) {
                ModuleInfoUsageDetector.$$$reportNull$$$0(8);
            }
            return multiMap;
        }
        MultiMap result = new MultiMap();
        for (PsiElement element : elementsToMove) {
            PsiDirectory directory;
            PsiJavaFile javaFile;
            PsiClass psiClass = (PsiClass)ObjectUtils.tryCast((Object)element, PsiClass.class);
            if (psiClass == null || !ModuleInfoUsageDetector.classVisibleToOtherModules(psiClass) || (javaFile = (PsiJavaFile)ObjectUtils.tryCast((Object)psiClass.getContainingFile(), PsiJavaFile.class)) == null || (directory = javaFile.getContainingDirectory()) == null) continue;
            result.putValue((Object)directory, (Object)psiClass);
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(9);
        }
        return multiMap;
    }

    @NotNull
    protected static MultiMap<PsiJavaModule, PsiDirectory> groupDirsByModuleDescriptor(@NotNull Set<PsiDirectory> dirs) {
        if (dirs == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(10);
        }
        MultiMap result = new MultiMap();
        for (PsiDirectory directory : dirs) {
            PsiJavaModule moduleDescriptor = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)directory);
            if (moduleDescriptor == null) continue;
            result.putValue((Object)moduleDescriptor, (Object)directory);
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(11);
        }
        return multiMap;
    }

    @NotNull
    protected static MultiMap<PsiPackage, PsiPackageAccessibilityStatement> collectModuleStatements(@NotNull Iterable<? extends PsiPackageAccessibilityStatement> statements) {
        if (statements == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(12);
        }
        MultiMap result = new MultiMap();
        for (PsiPackageAccessibilityStatement psiPackageAccessibilityStatement : statements) {
            PsiPackage psiPackage;
            PsiJavaCodeReferenceElement packageReference = psiPackageAccessibilityStatement.getPackageReference();
            if (packageReference == null || (psiPackage = (PsiPackage)ObjectUtils.tryCast((Object)packageReference.resolve(), PsiPackage.class)) == null) continue;
            result.putValue((Object)psiPackage, (Object)psiPackageAccessibilityStatement);
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(13);
        }
        return multiMap;
    }

    @NotNull
    protected static List<PsiPackageAccessibilityStatement> findModuleStatementsForPkg(@NotNull PsiPackage psiPackage, @NotNull MultiMap<PsiPackage, PsiPackageAccessibilityStatement> exports, @NotNull MultiMap<PsiPackage, PsiPackageAccessibilityStatement> opens) {
        if (psiPackage == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(14);
        }
        if (exports == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(15);
        }
        if (opens == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(16);
        }
        SmartList result = new SmartList();
        result.addAll(exports.get((Object)psiPackage));
        result.addAll(opens.get((Object)psiPackage));
        SmartList smartList = result;
        if (smartList == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(17);
        }
        return smartList;
    }

    protected static boolean dirContainsOnlyClasses(@NotNull PsiDirectory psiDirectory, @NotNull Collection<PsiClass> classes) {
        if (psiDirectory == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(18);
        }
        if (classes == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(19);
        }
        SmartList javaClassesInDir = new SmartList();
        for (PsiFile file : psiDirectory.getFiles()) {
            PsiJavaFile javaFile = (PsiJavaFile)ObjectUtils.tryCast((Object)file, PsiJavaFile.class);
            if (javaFile == null) continue;
            for (PsiClass psiClass : javaFile.getClasses()) {
                if (!ModuleInfoUsageDetector.classVisibleToOtherModules(psiClass)) continue;
                javaClassesInDir.add(psiClass);
            }
        }
        javaClassesInDir.removeAll((Collection<?>)new SmartHashSet(classes));
        return javaClassesInDir.isEmpty();
    }

    private static boolean classVisibleToOtherModules(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            ModuleInfoUsageDetector.$$$reportNull$$$0(20);
        }
        return psiClass.hasModifierProperty("public") || psiClass.hasModifierProperty("protected");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 11, 13, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moveDestination";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToMove";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToDelete";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveClassesOrPackages/ModuleInfoUsageDetector";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirs";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statements";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exports";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "opens";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveClassesOrPackages/ModuleInfoUsageDetector";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "groupClassesByDir";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "groupDirsByModuleDescriptor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "collectModuleStatements";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "findModuleStatementsForPkg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModifyUsageInstance";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSafeDeleteUsageInstance";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "groupClassesByDir";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 17: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "groupDirsByModuleDescriptor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectModuleStatements";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findModuleStatementsForPkg";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "dirContainsOnlyClasses";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "classVisibleToOtherModules";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 11, 13, 17 -> new IllegalStateException(string);
        };
    }
}

