/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.containers.MultiMap;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

class PackageLocalsUsageCollector
extends JavaRecursiveElementWalkingVisitor {
    private final HashMap<PsiElement, HashSet<PsiElement>> myReported = new HashMap();
    private final PsiElement[] myElementsToMove;
    private final MultiMap<PsiElement, @NlsContexts.DialogMessage String> myConflicts;
    private final PackageWrapper myTargetPackage;

    PackageLocalsUsageCollector(PsiElement[] elementsToMove, PackageWrapper targetPackage, MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        this.myElementsToMove = elementsToMove;
        this.myConflicts = conflicts;
        this.myTargetPackage = targetPackage;
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
        if (expression == null) {
            PackageLocalsUsageCollector.$$$reportNull$$$0(0);
        }
        super.visitReferenceExpression(expression);
        this.visitReferenceElement((PsiJavaCodeReferenceElement)expression);
    }

    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement reference) {
        if (reference == null) {
            PackageLocalsUsageCollector.$$$reportNull$$$0(1);
        }
        super.visitReferenceElement(reference);
        PsiElement resolved = reference.resolve();
        this.visitResolvedReference(resolved, reference);
    }

    private void visitResolvedReference(PsiElement resolved, PsiJavaCodeReferenceElement reference) {
        PsiPackage aPackage;
        PsiDirectory containingDirectory;
        PsiFile aFile;
        if (resolved instanceof PsiModifierListOwner && ((PsiModifierListOwner)resolved).hasModifierProperty("packageLocal") && (aFile = resolved.getContainingFile()) != null && !this.isInsideMoved(resolved) && (containingDirectory = aFile.getContainingDirectory()) != null && (aPackage = JavaDirectoryService.getInstance().getPackage(containingDirectory)) != null && !this.myTargetPackage.equalToPackage(aPackage)) {
            PsiElement container;
            HashSet<Object> reportedRefs = this.myReported.get(resolved);
            if (reportedRefs == null) {
                reportedRefs = new HashSet();
                this.myReported.put(resolved, reportedRefs);
            }
            if (!reportedRefs.contains(container = ConflictsUtil.getContainer((PsiElement)reference))) {
                String message = JavaRefactoringBundle.message((String)"0.uses.a.package.local.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)resolved, (boolean)true)});
                this.myConflicts.putValue((Object)resolved, (Object)StringUtil.capitalize((String)message));
                reportedRefs.add(container);
            }
        }
    }

    private boolean isInsideMoved(PsiElement place) {
        for (PsiElement element : this.myElementsToMove) {
            if (element.getContainingFile() == null || !PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)place, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/move/moveClassesOrPackages/PackageLocalsUsageCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

