/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInner;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.Language;
import com.intellij.lang.jvm.JvmLanguage;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveClassesOrPackages.JavaMoveClassesOrPackagesHandler;
import com.intellij.refactoring.move.moveInner.MoveInnerToUpperHandler;
import com.intellij.refactoring.move.moveMembers.MoveMembersHandler;
import com.intellij.refactoring.util.RadioUpDownListener;
import com.intellij.ui.components.JBBox;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MoveInnerToUpperOrMembersHandler
extends MoveHandlerDelegate {
    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        if (elements.length != 1) {
            return false;
        }
        PsiElement element = elements[0];
        return MoveInnerToUpperOrMembersHandler.isStaticInnerClass(element);
    }

    private static boolean isStaticInnerClass(PsiElement element) {
        return element instanceof PsiClass && element.getParent() instanceof PsiClass && ((PsiClass)element).hasModifierProperty("static");
    }

    public void doMove(Project project, PsiElement[] elements, PsiElement targetContainer, MoveCallback callback) {
        SelectInnerOrMembersRefactoringDialog dialog = new SelectInnerOrMembersRefactoringDialog((PsiClass)elements[0], project);
        if (!dialog.showAndGet()) {
            return;
        }
        MoveHandlerDelegate delegate = dialog.getRefactoringHandler();
        if (delegate != null) {
            delegate.doMove(project, elements, targetContainer, callback);
        }
    }

    public boolean tryToMove(PsiElement element, Project project, DataContext dataContext, PsiReference reference, Editor editor) {
        if (MoveInnerToUpperOrMembersHandler.isStaticInnerClass(element) && !JavaMoveClassesOrPackagesHandler.isReferenceInAnonymousClass(reference)) {
            MoveHandlerDelegate moveHandlerDelegate;
            PsiElement targetContainer = (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext);
            PsiClass aClass = (PsiClass)element;
            SelectInnerOrMembersRefactoringDialog dialog = new SelectInnerOrMembersRefactoringDialog(aClass, project);
            if (dialog.showAndGet() && (moveHandlerDelegate = dialog.getRefactoringHandler()) != null) {
                moveHandlerDelegate.doMove(project, new PsiElement[]{aClass}, targetContainer, null);
            }
            return true;
        }
        return false;
    }

    public boolean supportsLanguage(@NotNull Language language) {
        if (language == null) {
            MoveInnerToUpperOrMembersHandler.$$$reportNull$$$0(0);
        }
        return language instanceof JvmLanguage;
    }

    @Nullable
    public String getActionName(PsiElement @NotNull [] elements) {
        if (elements == null) {
            MoveInnerToUpperOrMembersHandler.$$$reportNull$$$0(1);
        }
        return JavaRefactoringBundle.message((String)"move.inner.class.action.name", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/move/moveInner/MoveInnerToUpperOrMembersHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SelectInnerOrMembersRefactoringDialog
    extends DialogWrapper {
        private JRadioButton myRbMoveInner;
        private JRadioButton myRbMoveMembers;
        private final String myClassName;

        SelectInnerOrMembersRefactoringDialog(PsiClass innerClass, Project project) {
            super(project, true);
            this.setTitle(RefactoringBundle.message((String)"select.refactoring.title"));
            this.myClassName = innerClass.getName();
            this.init();
        }

        protected JComponent createNorthPanel() {
            return new JLabel(RefactoringBundle.message((String)"what.would.you.like.to.do"));
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myRbMoveInner;
        }

        protected String getDimensionServiceKey() {
            return "#com.intellij.refactoring.move.MoveHandler.SelectRefactoringDialog";
        }

        protected JComponent createCenterPanel() {
            JPanel panel = new JPanel(new BorderLayout());
            this.myRbMoveInner = new JRadioButton();
            this.myRbMoveInner.setText(JavaRefactoringBundle.message((String)"move.inner.class.to.upper.level", (Object[])new Object[]{this.myClassName}));
            this.myRbMoveInner.setSelected(true);
            this.myRbMoveMembers = new JRadioButton();
            this.myRbMoveMembers.setText(JavaRefactoringBundle.message((String)"move.inner.class.to.another.class", (Object[])new Object[]{this.myClassName}));
            ButtonGroup gr = new ButtonGroup();
            gr.add(this.myRbMoveInner);
            gr.add(this.myRbMoveMembers);
            RadioUpDownListener.installOn((JRadioButton[])new JRadioButton[]{this.myRbMoveInner, this.myRbMoveMembers});
            JBBox box = JBBox.createVerticalBox();
            box.add(Box.createVerticalStrut(5));
            box.add((Component)this.myRbMoveInner);
            box.add((Component)this.myRbMoveMembers);
            panel.add((Component)box, "Center");
            return panel;
        }

        @Nullable
        public MoveHandlerDelegate getRefactoringHandler() {
            if (this.myRbMoveInner.isSelected()) {
                return new MoveInnerToUpperHandler();
            }
            if (this.myRbMoveMembers.isSelected()) {
                return new MoveMembersHandler();
            }
            return null;
        }
    }
}

