/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInstanceMethod;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.ide.util.EditorHelper;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveInstanceMembersUtil;
import com.intellij.refactoring.move.moveInstanceMethod.InheritorUsageInfo;
import com.intellij.refactoring.move.moveInstanceMethod.InternalUsageInfo;
import com.intellij.refactoring.move.moveInstanceMethod.JavadocUsageInfo;
import com.intellij.refactoring.move.moveInstanceMethod.MethodCallUsageInfo;
import com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodViewDescriptor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MoveInstanceMethodProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(MoveInstanceMethodProcessor.class);
    private PsiMethod myMethod;
    private PsiVariable myTargetVariable;
    private PsiClass myTargetClass;
    private final String myNewVisibility;
    private final boolean myOpenInEditor;
    private final Map<PsiClass, String> myOldClassParameterNames;

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    public PsiVariable getTargetVariable() {
        return this.myTargetVariable;
    }

    public MoveInstanceMethodProcessor(Project project, PsiMethod method, PsiVariable targetVariable, String newVisibility, Map<PsiClass, String> oldClassParameterNames) {
        this(project, method, targetVariable, newVisibility, false, oldClassParameterNames);
    }

    public MoveInstanceMethodProcessor(Project project, PsiMethod method, PsiVariable targetVariable, String newVisibility, boolean openInEditor, Map<PsiClass, String> oldClassParameterNames) {
        super(project);
        this.myMethod = method;
        this.myTargetVariable = targetVariable;
        this.myOpenInEditor = openInEditor;
        this.myOldClassParameterNames = oldClassParameterNames;
        LOG.assertTrue(this.myTargetVariable instanceof PsiParameter || this.myTargetVariable instanceof PsiField);
        LOG.assertTrue(this.myTargetVariable.getType() instanceof PsiClassType);
        PsiType type = this.myTargetVariable.getType();
        LOG.assertTrue(type instanceof PsiClassType);
        this.myTargetClass = ((PsiClassType)type).resolve();
        this.myNewVisibility = newVisibility;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveInstanceMethodProcessor.$$$reportNull$$$0(0);
        }
        return new MoveInstanceMethodViewDescriptor(this.myMethod, this.myTargetVariable, this.myTargetClass);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            MoveInstanceMethodProcessor.$$$reportNull$$$0(1);
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        @NlsContexts.DialogMessage MultiMap conflicts = new MultiMap();
        HashSet<Object> members = new HashSet<Object>();
        members.add(this.myMethod);
        if (this.myTargetVariable instanceof PsiField) {
            members.add((PsiMember)this.myTargetVariable);
        }
        if (!this.myTargetClass.isInterface()) {
            RefactoringConflictsUtil.getInstance().analyzeAccessibilityConflictsAfterMemberMove(this.myTargetClass, this.myNewVisibility, members, conflicts);
        } else {
            for (UsageInfo usage : usages) {
                if (!(usage instanceof InheritorUsageInfo)) continue;
                RefactoringConflictsUtil.getInstance().analyzeAccessibilityConflictsAfterMemberMove(((InheritorUsageInfo)usage).getInheritor(), this.myNewVisibility, members, conflicts);
            }
        }
        PsiVariable psiVariable = this.myTargetVariable;
        if (psiVariable instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)psiVariable;
            int index = this.myMethod.getParameterList().getParameterIndex(parameter);
            for (UsageInfo usageInfo : usages) {
                if (!(usageInfo instanceof MethodCallUsageInfo)) continue;
                PsiElement methodCall = ((MethodCallUsageInfo)usageInfo).getMethodCallExpression();
                if (methodCall instanceof PsiMethodCallExpression) {
                    PsiExpression[] expressions = ((PsiMethodCallExpression)methodCall).getArgumentList().getExpressions();
                    if (index >= expressions.length) continue;
                    PsiExpression instanceValue = expressions[index];
                    if (!((instanceValue = RefactoringUtil.unparenthesizeExpression(instanceValue)) instanceof PsiLiteralExpression) || ((PsiLiteralExpression)instanceValue).getValue() != null) continue;
                    String message = JavaRefactoringBundle.message((String)"0.contains.call.with.null.argument.for.parameter.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)ConflictsUtil.getContainer(methodCall), (boolean)true), CommonRefactoringUtil.htmlEmphasize((String)parameter.getName())});
                    conflicts.putValue((Object)instanceValue, (Object)message);
                    continue;
                }
                if (!(methodCall instanceof PsiMethodReferenceExpression) || !this.shouldBeExpandedToLambda((PsiMethodReferenceExpression)methodCall, index)) continue;
                conflicts.putValue((Object)methodCall, (Object)JavaRefactoringBundle.message((String)"expand.method.reference.warning", (Object[])new Object[0]));
            }
        }
        try {
            ConflictsUtil.checkMethodConflicts(this.myTargetClass, this.myMethod, this.getPatternMethod(), (MultiMap<PsiElement, String>)conflicts);
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
        return this.showConflicts(conflicts, usages);
    }

    private boolean shouldBeExpandedToLambda(PsiMethodReferenceExpression referenceExpression, int index) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)referenceExpression.getFunctionalInterfaceType());
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult);
        if (interfaceMethod != null) {
            MethodSignature methodSignature = interfaceMethod.getSignature(LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult));
            if (index == 0 && methodSignature.getParameterTypes().length > 0 && methodSignature.getParameterTypes()[0].isAssignableFrom(this.myMethod.getParameterList().getParameters()[0].getType())) {
                return false;
            }
        }
        return true;
    }

    protected UsageInfo @NotNull [] findUsages() {
        PsiCodeBlock body;
        PsiManager manager = this.myMethod.getManager();
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)manager.getProject());
        final ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        for (PsiReference ref : ReferencesSearch.search((PsiElement)this.myMethod, (SearchScope)searchScope, (boolean)false).asIterable()) {
            PsiElement element = ref.getElement();
            if (element instanceof PsiReferenceExpression) {
                boolean isInternal = PsiTreeUtil.isAncestor((PsiElement)this.myMethod, (PsiElement)element, (boolean)true);
                usages.add(new MethodCallUsageInfo((PsiReferenceExpression)element, isInternal));
                continue;
            }
            if (element instanceof PsiDocTagValue) {
                usages.add(new JavadocUsageInfo((PsiDocTagValue)element));
                continue;
            }
            throw new BaseRefactoringProcessor.UnknownReferenceTypeException(element.getLanguage());
        }
        if (this.myTargetClass.isInterface() && !PsiUtil.isAvailable((JavaFeature)JavaFeature.EXTENSION_METHODS, (PsiElement)this.myTargetClass)) {
            MoveInstanceMethodProcessor.addInheritorUsages(this.myTargetClass, searchScope, usages);
        }
        if ((body = this.myMethod.getBody()) != null) {
            body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitNewExpression(@NotNull PsiNewExpression expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (MoveInstanceMembersUtil.getClassReferencedByThis((PsiExpression)expression) != null) {
                        usages.add(new InternalUsageInfo((PsiElement)expression));
                    }
                    super.visitNewExpression(expression);
                }

                public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                    PsiElement resolved;
                    if (expression == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (MoveInstanceMembersUtil.getClassReferencedByThis((PsiExpression)expression) != null) {
                        usages.add(new InternalUsageInfo((PsiElement)expression));
                    } else if (!expression.isQualified() && MoveInstanceMethodProcessor.this.myTargetVariable.equals((Object)(resolved = expression.resolve()))) {
                        usages.add(new InternalUsageInfo((PsiElement)expression));
                    }
                    super.visitReferenceExpression(expression);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "expression";
                    objectArray2[1] = "com/intellij/refactoring/move/moveInstanceMethod/MoveInstanceMethodProcessor$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitNewExpression";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitReferenceExpression";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        UsageInfo[] usageInfoArray = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            MoveInstanceMethodProcessor.$$$reportNull$$$0(2);
        }
        return usageInfoArray;
    }

    private static void addInheritorUsages(PsiClass aClass, GlobalSearchScope searchScope, List<? super UsageInfo> usages) {
        for (PsiClass inheritor : ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)searchScope, (boolean)false).findAll()) {
            if (!inheritor.isInterface()) {
                usages.add(new InheritorUsageInfo(inheritor));
                continue;
            }
            MoveInstanceMethodProcessor.addInheritorUsages(inheritor, searchScope, usages);
        }
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            MoveInstanceMethodProcessor.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(elements.length == 3);
        this.myMethod = (PsiMethod)elements[0];
        this.myTargetVariable = (PsiVariable)elements[1];
        this.myTargetClass = (PsiClass)elements[2];
    }

    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"move.instance.method.command");
        if (string == null) {
            MoveInstanceMethodProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    public PsiClass getTargetClass() {
        return this.myTargetClass;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveInstanceMethodProcessor.$$$reportNull$$$0(5);
        }
        PsiMethod patternMethod = this.createMethodToAdd();
        ArrayList<PsiReference> docRefs = new ArrayList<PsiReference>();
        for (UsageInfo usage : usages) {
            MethodCallUsageInfo methodCallUsage;
            if (usage instanceof InheritorUsageInfo) {
                InheritorUsageInfo inheritorUsage = (InheritorUsageInfo)usage;
                PsiClass inheritor = inheritorUsage.getInheritor();
                MoveInstanceMethodProcessor.addMethodToClass(inheritor, patternMethod, true);
                continue;
            }
            if (usage instanceof MethodCallUsageInfo && !(methodCallUsage = (MethodCallUsageInfo)usage).isInternal()) {
                PsiReferenceExpression ref;
                PsiElement expression = methodCallUsage.getMethodCallExpression();
                if (expression instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
                    this.correctMethodCall(call, false);
                    continue;
                }
                if (!(expression instanceof PsiMethodReferenceExpression)) continue;
                PsiMethodReferenceExpression methodReferenceExpression = (PsiMethodReferenceExpression)expression;
                PsiExpression qualifierExpression = methodReferenceExpression.getQualifierExpression();
                PsiVariable psiVariable = this.myTargetVariable;
                if (psiVariable instanceof PsiParameter) {
                    PsiParameter parameter = (PsiParameter)psiVariable;
                    if (this.shouldBeExpandedToLambda(methodReferenceExpression, this.myMethod.getParameterList().getParameterIndex(parameter))) {
                        List returnExpressions;
                        PsiLambdaExpression lambdaExpression = LambdaRefactoringUtil.convertMethodReferenceToLambda((PsiMethodReferenceExpression)methodReferenceExpression, (boolean)false, (boolean)true);
                        if (lambdaExpression == null || (returnExpressions = LambdaUtil.getReturnExpressions((PsiLambdaExpression)lambdaExpression)).isEmpty()) continue;
                        this.correctMethodCall((PsiMethodCallExpression)returnExpressions.get(0), false);
                        continue;
                    }
                }
                Object exprText = this.myTargetVariable instanceof PsiParameter || qualifierExpression instanceof PsiReferenceExpression && (ref = (PsiReferenceExpression)qualifierExpression).resolve() == this.myMethod.getContainingClass() ? this.myTargetVariable.getType().getCanonicalText() : (qualifierExpression instanceof PsiReferenceExpression ? qualifierExpression.getText() + "." + this.myTargetVariable.getName() : this.myTargetVariable.getName());
                PsiExpression newQualifier = JavaPsiFacade.getElementFactory((Project)this.myProject).createExpressionFromText((String)exprText, null);
                methodReferenceExpression.setQualifierExpression(newQualifier);
                JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences(expression);
                continue;
            }
            if (!(usage instanceof JavadocUsageInfo)) continue;
            docRefs.add(usage.getElement().getReference());
        }
        try {
            PsiModifierList modifierList = patternMethod.getModifierList();
            if (this.myTargetClass.isInterface() && !this.myMethod.hasModifierProperty("abstract")) {
                if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.EXTENSION_METHODS, (PsiElement)this.myTargetClass)) {
                    patternMethod.getBody().delete();
                    modifierList.setModifierProperty("default", false);
                } else {
                    modifierList.setModifierProperty("default", true);
                }
                RefactoringUtil.makeMethodAbstract(this.myTargetClass, patternMethod);
            } else if (this.myMethod.hasModifierProperty("default")) {
                modifierList.setModifierProperty("default", false);
                VisibilityUtil.setVisibility((PsiModifierList)modifierList, (String)"public");
            }
            PsiMethod method = MoveInstanceMethodProcessor.addMethodToClass(this.myTargetClass, patternMethod, false);
            this.myMethod.delete();
            for (PsiReference reference : docRefs) {
                reference.bindToElement((PsiElement)method);
            }
            VisibilityUtil.fixVisibility((PsiElement[])UsageViewUtil.toElements((UsageInfo[])usages), (PsiMember)method, (String)this.myNewVisibility);
            if (this.myOpenInEditor) {
                EditorHelper.openInEditor((PsiElement)method);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private void correctMethodCall(PsiMethodCallExpression expression, boolean isInternalCall) {
        try {
            PsiClass resolved;
            PsiType type;
            PsiManager manager = this.myMethod.getManager();
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            if (!methodExpression.isReferenceTo((PsiElement)this.myMethod)) {
                return;
            }
            PsiExpression oldQualifier = methodExpression.getQualifierExpression();
            PsiExpression newQualifier = null;
            PsiClass classReferencedByThis = MoveInstanceMembersUtil.getClassReferencedByThis((PsiExpression)methodExpression);
            if (this.myTargetVariable instanceof PsiParameter) {
                PsiExpression[] arguments;
                int index = this.myMethod.getParameterList().getParameterIndex((PsiParameter)this.myTargetVariable);
                if (index < (arguments = expression.getArgumentList().getExpressions()).length) {
                    newQualifier = (PsiExpression)arguments[index].copy();
                    arguments[index].delete();
                }
            } else {
                PsiClass aClass;
                VisibilityUtil.escalateVisibility((PsiMember)((PsiField)this.myTargetVariable), (PsiElement)expression);
                Object newQualifierName = this.myTargetVariable.getName();
                if (this.myTargetVariable instanceof PsiField && oldQualifier != null && (aClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)oldQualifier.getType())) == ((PsiField)this.myTargetVariable).getContainingClass()) {
                    newQualifierName = oldQualifier.getText() + "." + (String)newQualifierName;
                }
                newQualifier = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText((String)newQualifierName, null);
            }
            PsiExpression newArgument = null;
            if (classReferencedByThis != null) {
                Object thisArgumentText = null;
                if (manager.areElementsEquivalent((PsiElement)this.myMethod.getContainingClass(), (PsiElement)classReferencedByThis)) {
                    if (this.myOldClassParameterNames.containsKey(this.myMethod.getContainingClass())) {
                        thisArgumentText = "this";
                    }
                } else {
                    String name = classReferencedByThis.getName();
                    thisArgumentText = name != null ? name + ".this" : "this";
                }
                if (thisArgumentText != null) {
                    newArgument = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText((String)thisArgumentText, null);
                }
            } else if (!isInternalCall && oldQualifier != null && (type = oldQualifier.getType()) instanceof PsiClassType && (resolved = ((PsiClassType)type).resolve()) != null && this.getParameterNameToCreate(resolved) != null) {
                newArgument = this.replaceRefsToTargetVariable(oldQualifier);
            }
            if (newArgument != null) {
                expression.getArgumentList().add(newArgument);
            }
            if (newQualifier != null) {
                if (newQualifier instanceof PsiThisExpression && ((PsiThisExpression)newQualifier).getQualifier() == null) {
                    if (oldQualifier != null) {
                        oldQualifier.delete();
                    }
                } else {
                    PsiReferenceExpression refExpr = (PsiReferenceExpression)JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText("q." + this.myMethod.getName(), null);
                    refExpr.getQualifierExpression().replace((PsiElement)newQualifier);
                    methodExpression.replace((PsiElement)refExpr);
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private PsiExpression replaceRefsToTargetVariable(PsiExpression expression) {
        final PsiManager manager = expression.getManager();
        if (ExpressionUtils.isReferenceTo((PsiExpression)expression, (PsiVariable)this.myTargetVariable)) {
            return MoveInstanceMethodProcessor.createThisExpr(manager);
        }
        expression.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    2.$$$reportNull$$$0(0);
                }
                super.visitReferenceExpression(expression);
                if (expression.isReferenceTo((PsiElement)MoveInstanceMethodProcessor.this.myTargetVariable)) {
                    try {
                        expression.replace((PsiElement)MoveInstanceMethodProcessor.createThisExpr(manager));
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/move/moveInstanceMethod/MoveInstanceMethodProcessor$2", "visitReferenceExpression"));
            }
        });
        return expression;
    }

    private static PsiExpression createThisExpr(PsiManager manager) {
        try {
            return JavaPsiFacade.getElementFactory((Project)manager.getProject()).createExpressionFromText("this", null);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private static PsiMethod addMethodToClass(PsiClass aClass, PsiMethod patternMethod, boolean canAddOverride) {
        try {
            PsiMethod method = (PsiMethod)aClass.add((PsiElement)patternMethod);
            ChangeContextUtil.decodeContextInfo((PsiElement)method, null, null);
            if (canAddOverride && OverrideImplementUtil.isInsertOverride((PsiMethod)method, (PsiClass)aClass)) {
                method.getModifierList().addAnnotation("java.lang.Override");
            }
            return method;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    private PsiMethod createMethodToAdd() {
        ChangeContextUtil.encodeContextInfo((PsiElement)this.myMethod, (boolean)true);
        try {
            PsiCodeBlock body = this.myMethod.getBody();
            if (body != null) {
                this.replaceReferences(body);
            } else if (this.myMethod.hasModifierProperty("abstract") && !this.myTargetClass.isInterface() && !this.myTargetClass.hasModifierProperty("abstract")) {
                CreateFromUsageUtils.setupMethodBody((PsiMethod)this.myMethod);
            }
            PsiMethod methodCopy = this.getPatternMethod();
            List<PsiParameter> newParameters2 = Arrays.asList(methodCopy.getParameterList().getParameters());
            CommonJavaRefactoringUtil.fixJavadocsForParams((PsiMethod)methodCopy, new HashSet<PsiParameter>(newParameters2));
            return methodCopy;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return this.myMethod;
        }
    }

    private void replaceReferences(PsiCodeBlock body) {
        final PsiManager manager = this.myMethod.getManager();
        final JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        final PsiElementFactory factory = facade.getElementFactory();
        final HashMap replaceMap = new HashMap();
        body.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitThisExpression(@NotNull PsiThisExpression expression) {
                PsiClass classReferencedByThis;
                if (expression == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((classReferencedByThis = MoveInstanceMembersUtil.getClassReferencedByThis((PsiExpression)expression)) != null && !PsiTreeUtil.isAncestor((PsiElement)MoveInstanceMethodProcessor.this.myMethod, (PsiElement)classReferencedByThis, (boolean)false)) {
                    PsiElementFactory factory2 = JavaPsiFacade.getElementFactory((Project)MoveInstanceMethodProcessor.this.myProject);
                    String paramName = MoveInstanceMethodProcessor.this.getParameterNameToCreate(classReferencedByThis);
                    try {
                        PsiExpression refExpression = factory2.createExpressionFromText(paramName, null);
                        replaceMap.put(expression, refExpression);
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    3.$$$reportNull$$$0(1);
                }
                try {
                    String paramName;
                    PsiClass classReferencedByThis;
                    PsiExpression qualifier = expression.getQualifierExpression();
                    PsiElement resolved = expression.resolve();
                    if (ExpressionUtils.isReferenceTo((PsiExpression)qualifier, (PsiVariable)MoveInstanceMethodProcessor.this.myTargetVariable)) {
                        if (resolved instanceof PsiField) {
                            String fieldName = ((PsiField)resolved).getName();
                            for (PsiParameter parameter : MoveInstanceMethodProcessor.this.myMethod.getParameterList().getParameters()) {
                                if (!Comparing.strEqual((String)parameter.getName(), (String)fieldName) && facade.getResolveHelper().resolveReferencedVariable(fieldName, (PsiElement)expression) == null) continue;
                                qualifier.replace((PsiElement)factory.createExpressionFromText("this", null));
                                return;
                            }
                        }
                        if (expression instanceof PsiMethodReferenceExpression) {
                            qualifier.replace((PsiElement)factory.createExpressionFromText("this", null));
                        } else {
                            qualifier.delete();
                        }
                        return;
                    }
                    if (MoveInstanceMethodProcessor.this.myTargetVariable.equals((Object)resolved)) {
                        PsiThisExpression thisExpression = RefactoringChangeUtil.createThisExpression((PsiManager)manager, PsiTreeUtil.isAncestor((PsiElement)MoveInstanceMethodProcessor.this.myMethod, (PsiElement)PsiUtil.getContainingClass((PsiElement)expression), (boolean)true) ? MoveInstanceMethodProcessor.this.myTargetClass : null);
                        replaceMap.put(expression, thisExpression);
                        return;
                    }
                    if (!MoveInstanceMethodProcessor.this.myMethod.equals((Object)resolved) && (classReferencedByThis = MoveInstanceMembersUtil.getClassReferencedByThis((PsiExpression)expression)) != null && (paramName = MoveInstanceMethodProcessor.this.getParameterNameToCreate(classReferencedByThis)) != null) {
                        PsiReferenceExpression newQualifier = (PsiReferenceExpression)factory.createExpressionFromText(paramName, null);
                        expression.setQualifierExpression((PsiExpression)newQualifier);
                        return;
                    }
                    super.visitReferenceExpression(expression);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }

            public void visitNewExpression(@NotNull PsiNewExpression expression) {
                if (expression == null) {
                    3.$$$reportNull$$$0(2);
                }
                try {
                    PsiExpression qualifier = expression.getQualifier();
                    if (ExpressionUtils.isReferenceTo((PsiExpression)qualifier, (PsiVariable)MoveInstanceMethodProcessor.this.myTargetVariable)) {
                        qualifier.delete();
                    } else {
                        PsiClass classReferencedByThis = MoveInstanceMembersUtil.getClassReferencedByThis((PsiExpression)expression);
                        if (classReferencedByThis != null) {
                            if (qualifier != null) {
                                qualifier.delete();
                            }
                            String paramName = MoveInstanceMethodProcessor.this.getParameterNameToCreate(classReferencedByThis);
                            PsiExpression newExpression = factory.createExpressionFromText(paramName + "." + expression.getText(), null);
                            replaceMap.put(expression, newExpression);
                        }
                    }
                    super.visitNewExpression(expression);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
                if (expression == null) {
                    3.$$$reportNull$$$0(3);
                }
                MoveInstanceMethodProcessor.this.correctMethodCall(expression, true);
                super.visitMethodCallExpression(expression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "expression";
                objectArray2[1] = "com/intellij/refactoring/move/moveInstanceMethod/MoveInstanceMethodProcessor$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitThisExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNewExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        for (PsiElement element : replaceMap.keySet()) {
            PsiElement replacement2 = (PsiElement)replaceMap.get(element);
            element.replace(replacement2);
        }
    }

    private PsiMethod getPatternMethod() throws IncorrectOperationException {
        String name;
        PsiMethod methodCopy = (PsiMethod)this.myMethod.copy();
        String string = this.myTargetClass.isInterface() ? "public" : (name = !Comparing.strEqual((String)this.myNewVisibility, (String)"EscalateVisible") ? this.myNewVisibility : null);
        if (name != null) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)methodCopy, (String)name, (boolean)true);
        }
        if (this.myTargetVariable instanceof PsiParameter) {
            int index = this.myMethod.getParameterList().getParameterIndex((PsiParameter)this.myTargetVariable);
            methodCopy.getParameterList().getParameters()[index].delete();
        }
        this.addParameters(JavaPsiFacade.getElementFactory((Project)this.myProject), methodCopy, this.myTargetClass.isInterface());
        return methodCopy;
    }

    private void addParameters(PsiElementFactory factory, PsiMethod methodCopy, boolean isInterface) throws IncorrectOperationException {
        Set<Map.Entry<PsiClass, String>> entries = this.myOldClassParameterNames.entrySet();
        for (Map.Entry<PsiClass, String> entry : entries) {
            PsiClassType type = factory.createType(entry.getKey());
            PsiParameter parameter = factory.createParameter(entry.getValue(), (PsiType)type);
            if (isInterface) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)parameter, (String)"final", (boolean)false);
            }
            methodCopy.getParameterList().add((PsiElement)parameter);
        }
    }

    private String getParameterNameToCreate(@NotNull PsiClass aClass) {
        if (aClass == null) {
            MoveInstanceMethodProcessor.$$$reportNull$$$0(6);
        }
        return this.myOldClassParameterNames.get(aClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveInstanceMethod/MoveInstanceMethodProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveInstanceMethod/MoveInstanceMethodProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getParameterNameToCreate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

